# Air302@LuatOS

## Air302是什么?

合宙Air302, 是基于移芯EC616的NB-IOT模块, 封装尺寸兼容合宙Air202,功能管脚基本上一一对应.

## LuatOS为它提供哪些功能

* 192kb的系统内存, 可用内存约40kb
* 64kb的Lua专属内存,可用内存约40kb
* 文件系统大小332kb,格式littlefs 2.1,可用空间约200kb
* 基于Lua 5.3.5, 提供95%的原生库支持
* 适配LuaTask,提供极为友好的`sys.lua`
* `gpio`库提供GPIO管脚控制功能(映射表后面有提供)
* `uart`库提供串口输入输出功能,支持uart1(调试/刷机)/uart2(用户可用)/uart0(芯片日志)
* `i2c`库提供iic总线master功能
* `disp`库提供基于i2c的显示屏支持,当前支持SSD1306
* `nbiot`库提供与nbiot相关的支持
* `json`库,提供lua对象与json字符串的双向转换
* `socket`库,提供异步Socket接口,用于与服务器的通信
* `log`库提供简洁的日志功能
* `libcoap`库提供coap消息处理所需方法
* `mqtt`库提供连接到mqtt服务器的功能,结合`crypto`加密库,可连接到阿里云
* `pwm`库提供多个PWM输出管脚,存在复用关系
* `adc`库提供外部电平检测,内部温度检测,供电电压检测

## 管脚映射表

管脚编号对应w600芯片的管脚编号, 与GPIO编号有对应关系, 请查阅Air302硬件设计手册

特别提示:

1. ADC0 实际上对应通道2, 读取时应使用 `adc.read(2)`. 通道0为CPU温度, 通道1为VBAT电压.
2. AON_GPIO2 对应 GPIO24 `gpio.setup(21,0)`
3. AON_GPIO3 对应 GPIO23 `gpio.setup(23,0)`
4. SPI功能暂不可用(截止到20200627,尚未支持)

## 刷机工具

1. LuaTools 最新版, 支持ec后缀的固件下载, 也支持lua脚本下载
2. windows命令行工具链

## 已知限制

1. 鉴于较少的系统内存,请合理分配资源
2. 尚未支持加密连接(TCP/UDP)
3. 尚未支持远程升级功能

## 注意事项

部分管脚的电压是1.8v,请勿超电压范围使用.

## 模块购买

1. 骑士智能Air302开发板 https://item.taobao.com/item.htm?id=621910075534

## 详细教程

TODO 敬请期待
