﻿/*
 menu for javascript
 author:mr·zhong
 date:2010-01-25
*/

/*判断当前子菜单显示或隐藏*/
var MenuShowOrHide = false;

$(function(){
    SetMenuID();
    BindMenuHoverEval();
    BindChideMenuHoverEval();
});

/*
 设置主、子菜单按钮ID
*/
function SetMenuID(){
    var id = 1;
    
    $('#ul_menu a').each(function(){
        $(this).attr("id","a_" + id);
        var chideObj = $(this).next();
        chideObj.attr("id","ChideMenu_a_" + id);
        chideObj.hide();
         id++;
    });
}

/*
 设置菜单颜色样式
*/
function SetMenuColor(menuID,isSelected){
    if(isSelected) $("#" + menuID).addClass("menuSelected");
    else $("#" + menuID).removeClass("menuSelected");
}

/*
 设置子菜单显示或隐藏
*/
function ShowOrHideChideMenu(menuID,isShow){
    var obj = $("#" + menuID);
    if(isShow)
    {                
        obj.slideDown("slow");
    }
    else obj.hide("slow");
}

/*
 绑定主菜单鼠标事件
*/
function BindMenuHoverEval(){    
    $("#ul_menu a").each(function(){
       $(this).hover(function(){
            ShowOrHideChideMenu("ChideMenu_" + $(this).attr("id"),true);
            MenuShowOrHide = true;
       },function(){
            setTimeout('Hide(ChideMenu_' + $(this).attr("id") +')',500);            
       }); 
    });
}

/*
 绑定子菜单鼠标事件
*/
function BindChideMenuHoverEval(){
    $("#ul_menu .chideMenuForShow").each(function(){
       $(this).hover(function(){            
            MenuShowOrHide = true;
       },function(){                        
            MenuShowOrHide = false;
            Hide($(this).attr("id"));            
       }); 
    });            
}

/*
 隐藏子菜单
*/
function Hide(id){    
    if(!MenuShowOrHide) ShowOrHideChideMenu(id,false);
}