﻿/**
------------------------validate.js------------------------
 ※【功能】表单验证类
 ※【作者】Ryan
 ※【版本】1.5
 ※【友情下载】<!--
   ┏━━━━━━━━━━━━━━━━━━━━━┓
   ┃             源 码 爱 好 者               ┃
   ┣━━━━━━━━━━━━━━━━━━━━━┫
   ┃                                          ┃
   ┃           提供源码发布与下载             ┃
   ┃                                          ┃
   ┃        http://www.jb51.net           ┃
   ┃                                          ┃
   ┃            互助、分享、提高              ┃
   ┗━━━━━━━━━━━━━━━━━━━━━┛
-->
 ※【版权】Copyright (C) 2009-2010 Riyan All Rights Reserved. 
 ※【联系方式】email:453344972@163.com QQ:474003869
 ※【创建日期】2009/08/18
 ※【修改日期】2009/09/10
------------------------函数说明------------------------
 chk.reg:正则表达式;
 chk.config:待验证项目信息,对应项目说明：
	id:待验证项目的id.(类型:字符串,必填)
	tip:待验证项目的提示标题.(类型:字符串,必填)
	arr:待验证的项目，对应的内容分别是:(类型:数组,至少填一项)
		arr[0]待验证项目的正则表达式类型，即check.js中reg下面所对应的项目。如果不需要则为"".(类型:字符串)
		arr[1]待验证项目最少输入字符,如果不限制则为0.(类型:正整数)
		arr[2]待验证项目最大输入字符,如果不限制则为0.(类型:正整数)
		arr[3]待验证项目是否不能为空,是则为true,不限制则为"".(类型:字符串)
		arr[4]待验证项目内容与另一输入框内容是否相同，其中arr[4]为另一输入框的id，一般用于判断两次输入的密码是否相同.不判断则为""或者不填.(类型:字符串)
 chk.form:提交表单时验证，参数fm为表单的ID,调用方法为window.onload = chk.form(fm);
 chk.input:当前输入框内容验证,调用方法为window.onload = chk.form();
 chk.limit:判断输入值是否在(n, m)区间,对应参数：
 		str:待验证的字符串;
		n:最小值;
		m:最大值.
 chk.showErr:返回验证信息,对应参数:
 		obj:待验证项目组件名称,主要用于当前输入框内容验证;
		errs:错误信息，如果为输入框内容验证则在其后面显示当前项目验证信息,如果为表单提交验证则在弹出消息框内显示错误信息列表.
------------------------------------------------------
*/
function $(id){return typeof(id) === 'object' ? id:document.getElementById(id);}
function $C(tag){return typeof(tag) === 'object' ? tag:document.createElement(tag);}
function Trim(str){return str.replace(/(^\s*)|(\s*$)/g,"");}
var chk = {
	reg:{
		name:[/^[a-zA-Z]{1}[a-zA-Z0-9_\-]+$/, "只能由字母、数字以及(-_)组成，必须以字母开头."],
		pass:[/^[A-Za-z0-9]+$/, "只能由字母和数字组成."],
		str:[/^[0-9a-zA-Z_\u0391-\uFFE5]+$/, "只能由中文、字母、数字以及下划线组成."],
		eng:[/^[A-Za-z]+$/, "只能输入英文字母."],
		chs:[/^[\u4e00-\u9fa5]+$/, "只能输入中文."],
		num:[/^\d+$/, "只能输入数字."],
		mail:[/^[\w-]+(\.[\w-]+)*@[\w-]+(\.[\w-]+)+$/, "格式不正确."],
		qq:[/^[1-9]{1}[0-9]{4,10}$/, "必须由5-10个整数组成."],
		msn:[/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/, "格式不正确."],
		phone:[/^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$/, "格式不正确."],
		mobile:[/^(?:13\d|15[89])-?\d{5}(\d{3}|\*{3})$/, "格式不正确."],
		post:[/^[1-9]{1}[0-9]{5}$/, "格式不正确."],
		card:[/(^\d{15}$)|(^\d{17}[0-9Xx]$)/, "格式不正确."],
		url:[/^(((ht|f)tp(s?))\:\/\/)[a-zA-Z0-9]+\.[a-zA-Z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/, "不是有效的URL地址."],
		ip:[/^((\d{1,2}|1\d{1,2}|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d{1,2}|2[0-4]\d|25[0-5])$/, "不是有效的IP地址."],
		date:[/^((((1[6-9]|[2-9]\d)\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\d|3[01]))|(((1[6-9]|[2-9]\d)\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\d|30))|(((1[6-9]|[2-9]\d)\d{2})-0?2-(0?[1-9]|1\d|2[0-8]))|(((1[6-9]|[2-9]\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-))$/ , "格式不正确."]
	},
	config:[], //chk.config = [{id:"obj.id", title:"tipTitle", arr:[chk.reg.item, minsize, maxsize, isnull, comregeID]}]
	form:function(fm){
		if (this.config && $(fm)){
			$(fm).onsubmit = function(){
				var msg = "", n = 1, str, tip, rst, arr ,reg;
				for (i in chk.config){
					str = Trim($(chk.config[i].id).value);
					tip = chk.config[i].tip;
					arr = chk.config[i].arr;
					if (tip){
						if (!str){
							if (arr[3] === true) msg += "[" + (n++) + "]." + tip + "不能为空.\n";
						}else{
							reg = chk.reg[arr[0]];
							if (arr[1] || arr[2]){
								rst = chk.limit(str, arr[1], arr[2]);
								if (rst !== "yes") msg += "[" + (n++) + "]." + tip + rst + "\n";
							}
							if (arr[4] && str !== $(arr[4]).value) {msg += "[" + (n++) + "]." + tip + "与上次输入内容不同." + "\n"}
							if (reg && !reg[0].test(str)){msg += "[" + (n++) + "]." + tip + reg[1] + "\n";}
						}
					}
					
				}
				if (msg){msg = "以下原因导致提交失败：\n" + msg;}
				return chk.showErr("", msg);
			}
		}
	},
	input:function(){
		var msg, obj, arr, reg, k;
		for (i in chk.config){
			$(chk.config[i].id).setAttribute("key", i);
			$(chk.config[i].id).onblur = function(){
				k = chk.config[this.getAttribute("key")];
				if (k.tip){
					msg = "";
					obj = $(k.id);
					arr = k.arr;
					if (!obj.value){
						msg = (arr[3] === true) ? "不能为空!":"";
					}else{
						msg = "yes";
						reg = chk.reg[arr[0]];
						if (arr[1] || arr[2]) msg = chk.limit(obj.value, arr[1], arr[2]);
						if (msg === "yes" && arr[4] && obj.value !== $(arr[4]).value) msg = "与上次输入内容不同.";
						if (msg === "yes" && reg && !reg[0].test(obj.value)) msg = reg[1];
					}
					if (msg && msg !== "yes"){msg = k.tip + msg;}
					chk.showErr(obj, msg);
				}
				obj.style.backgroundColor = "#EAFFCA";
			}
			$(chk.config[i].id).onfocus = function(){$(chk.config[this.getAttribute("key")].id).style.backgroundColor = "#FFF";}
		}
	},
	limit:function(str, n, m){
		if (str){
			var len = str.length;
			return (n > 0 && len < n && "不能少于" + n + "个字符.") || (m > 0 && len > m && "不能超过" + m + "个字符.") || "yes";
		}
	},
	showErr:function(obj, errs){
		if (!obj){
			if (errs){
				alert(errs);
				return false;
			}
		}else{
			var tips = $("ck_" + obj.id);
			if(!tips){
				tips = $C("span");
				tips.setAttribute('id',"ck_" + obj.id);
				tips.style.color="#F00";
				tips.style.fontSize="12px";
				obj.parentNode.appendChild(tips);
			}
			switch (errs) {
				case "":
					tips.innerHTML = "";
					return true;
				case "yes":
					tips.innerHTML = "&nbsp;<img src='js/yes.gif' style='vertical-align:middle;' />";
					return true;
				default:
					tips.innerHTML = "<br><img src='js/no.gif' style='vertical-align:middle;' />&nbsp;" + errs;
					return false;
			}
		}
	}
}
