Class('App.Dlg', 'linb.Com',{
    Instance:{
        //base Class for linb.Com
        base:["linb.UI"], 
        //requried class for the App
        required:["linb.UI.Dialog", "linb.UI.CheckBox", "linb.UI.Input", "linb.UI.Button", "linb.UI.Div"], 
        //prepare data
        customAppend:function(){
            var self=this,
                prop = this.properties;
            if(prop.fromRegion)
                self.dialog.setFromRegion(prop.fromRegion);

            if(!self.dialog.get(0).root)
                self.dialog.render();

            self.col1.resetValue(prop.col1);
            self.col2.resetValue(prop.col2);
            self.col3.resetValue(prop.col3);

            //asy
            self.dialog.show(self.parent, true);
        }, 
        iniComponents:function(){
            // [[code created by jsLinb UI Builder
            var host=this, children=[], append=function(child){children.push(child.get(0))};
            
            append((new linb.UI.Dialog)
                .host(host,"dialog")
                .setLeft(150)
                .setTop(90)
                .setWidth(350)
                .setHeight(170)
                .setCaption("\u7f16\u8f91\u5bf9\u8bdd\u6846")
                .onHotKeydown("_dialog_onhotkey")
                .beforeClose("_dialog_beforeclose")
            );
            
            host.dialog.append((new linb.UI.Div)
                .host(host,"div13")
                .setLeft(20)
                .setTop(100)
                .setWidth(300)
                .setHeight(30)
                .setHtml("\u8bd5\u4e00\u8bd5'Tab'\u3002Tab\u7126\u70b9\u4e0d\u4f1a\u79bb\u5f00\u5bf9\u8bdd\u6846")
                .setCustomStyle({"KEY":"overflow:visible; "})
            );
            
            host.dialog.append((new linb.UI.Button)
                .host(host,"btnOK")
                .setLeft(110)
                .setTop(70)
                .setTabindex("1")
                .setCaption("OK")
                .onClick("_btnok_onclick")
            );
            
            host.dialog.append((new linb.UI.Input)
                .host(host,"col1")
                .setLeft(20)
                .setTop(10)
                .setTabindex("2")
            );
            
            host.dialog.append((new linb.UI.Input)
                .host(host,"col2")
                .setLeft(160)
                .setTop(10)
                .setZIndex("3")
                .setTabindex("3")
                .setValueFormat("^-?\\d\\d*$")
            );
            
            host.dialog.append((new linb.UI.CheckBox)
                .host(host,"col3")
                .setLeft(20)
                .setTop(40)
                .setTabindex("4")
                .setCaption("col3")
            );
            
            return children;
            // ]]code created by jsLinb UI Builder
        }, 
        _btnok_onclick:function (profile, e, value) {
            _.tryF(this.events.onOK, [this.col1.getUIValue(), this.col2.getUIValue(), this.col3.getUIValue()], this.$parent);
            this.dialog.close();
        }, 
        _dialog_beforeclose:function (profile) {
            profile.boxing().hide();
            return false;
        }, 
        _dialog_onhotkey:function(profile, key, control, shift, alt){
            if(key=='esc')
                profile.boxing().close();
        }
    }
});