/*
jsLinb 2.0
Copyright(c) 2008 Yingbo Li(www.longboo.com, longboo.com[at]gmail.com)
Open Source under LGPL (http://www.gnu.org/licenses/lgpl-3.0-standalone.html)
Contact longboo.com[at]gmail.com for Commercial issues
*/

undefined;
//window.onerror will be redefined in linb.Debugger
//window.onerror=function(){return true};

//time stamp
_=function(){return +new Date()};

/*merge hash from source to target
  target:hash
  source:hash
  type:'all', 'with', 'without'[default], or function <return true will trigger merge>
  return: merged target
*/
_.merge=function(target, source, type){
    var i,f;
    if(typeof type == "function"){
        f=type;
        type='fun';
    }
    switch(type){
        case 'fun':
            for(i in source)if(true===f(source[i],i))target[i]=source[i];
            break;
        case 'all':
            for(i in source)target[i]=source[i];
            break;
        case 'with':
            for(i in source)if(i in target)target[i]=source[i];
            break;
        default:
            for(i in source)if(!(i in target))target[i]=source[i];
    }
    return target;
};
_.merge(_,{
    fun:function(){return function(){}},
    exec:function(script){
        var me=this,
            d=document,
            h=me.h||(me.h=d.getElementsByTagName("head")[0] || d.documentElement),
            s=d.createElement("script");
        s.type = "text/javascript";
        if(linb.browser.ie)
            s.text=script;
        else
            s.appendChild(d.createTextNode(script));
        h.insertBefore(s, h.firstChild);
        h.removeChild(s);
    },
    /*
    get something from deep hash
    hash:target hash
    arr:path array,
    example:
    _.get({a:{b:{c:1}}},['a','b']) => {c:1};
        _.get({a:{b:{c:1}}},['a','b','c']) => 1;
        _.get({a:{b:{c:1}}},['a','b','c','d']) => undefined;
    */
    get:function(hash,arr){
        for(var i=0,l=arr.length;i<l;)
            if(!hash || (hash=hash[arr[i++]])===undefined )return;
        return hash;
    },
    /*
    set/unset a value to deep hash
    example:
        _.set({a:{b:{c:1}}},['a','b','c'],2) => {a:{b:{c:2}}}
        _.set({a:{b:{c:1}}},['a','b','c']) => {a:{b:{}}}
    */
    set:function(hash,arr,value){
        var v,i=0,m,last=arr.length-1,key = arr[last];
        for(;i<last;){
            v=arr[i++];
            if(hash[v]&&((m=typeof hash[v])=='object' || m=='function')) hash=hash[v];
            else hash=hash[v]={};
        }
        if(value===undefined)
            delete hash[key];
        else
            return hash[key]=value;
    },
    /* try to excute a function
    fun:target function
    args:arguments for fun
    scope:[this] pointer for fun
    df:default return vale
    */
    tryF:function(fun, args, scope, df){
        return (fun && typeof fun=='function') ? fun.apply(scope||null, args||[]) : df
    },
    /*asynchronous run function
    fun:target function
    defer: setTimeout defer time
    args: arguments for fun
    scope: [this] pointer for fun
    */
    asyRun:function(fun, defer, args, scope){
        //defer must set in opera
        return setTimeout(typeof fun=='string' ? fun : function(){fun.apply(scope,args||[]);fun=args=null;}, defer||0);
    },
    isEmpty:function(hash){for(var i in hash)return false; return true},

    /*
    this will always run newer function
    key: for identify
    fun: to run
    defer: setTimeout defer time
    args: arguments for fun
    scope: 'this' for fun
    */
    resetRun:function(key, fun, defer ,args, scope){
        var me=arguments.callee, k=key, cache = me.$cache || (me.$cache = {});
        if(cache[k]){clearTimeout(cache[k])}
        if(typeof fun=='function')
            cache[k] = setTimeout(function(){delete cache[k];fun.apply(scope||null,args||[])},defer||0);
        else delete cache[k];
    },
    //Dependency: linb.Dom linb.Thread
    observableRun:function(tasks,onEnd,threadid){
        linb.Thread.observableRun(tasks,onEnd,threadid);
    },

    /*break object memory link
    target: target object
    n: depth, default 1
    */
    breakO:function(target,depth){
        var n=depth||1, l=1+(arguments[2]||0), self=arguments.callee, _t='___gc_',_o=self._o||(self._o={}), i, b, p;
        if(target && (typeof target=='object' || typeof target=='function') && target!==window&&target!==Object&&target!==Date&&target!==Array&&target!==document){
            if(_t in target)return; else try{target[_t]=1;}catch(e){return}
            p=(p=target.constructor)?p.prototype:_o;
            for(i in target)
                if(i!=_t){
                    if(l<n && target[i] && (typeof target[i]=='object' || typeof target[i]=='function'))self(target[i],n,l);
                    if(!(p && p[i]) && i!="prototype" && i!="constructor")try{delete target[i]}catch(e){}
                }
            try{delete target[_t]}catch(e){}
            if(target.constructor==Array)target.length=0;
        }
    },

    /*each function for hash
    fun: fun to exec, if return false, stop the $iterator
    scope: 'this' pointer;
    */
    each:function(hash,fun,scope){
        scope = scope||hash;
        for(var i in hash)
            if(false===fun.call(scope, hash[i], i, hash))
                break;
        return hash;
    },
    /*shadow copy for hash/array
    * var a=[]; a.b='b'; a.b will not be copied
    */
    copy:function(hash,fun){
        return _.clone(hash,fun,1);
    },
    /*deep copy for hash/array, and hash/array only
    * var a=[]; a.b='b'; a.b will not be cloned
    *be careful for dead lock
    */
    clone:function(hash,fun,deep){
        if(hash && typeof hash=='object'){
            var c=hash.constructor,a=c==Array;
            if(a||c==Object){
                var me=arguments.callee,h=a?[]:{},v,i=0,l;
                if(!deep){
                    if(deep===0)return hash;
                    else deep=100;
                }
                if(a){
                    l=hash.length;
                    for(;i<l;i++)
                        if(fun?fun(hash[i],i):1)
                            h[h.length]=((v=hash[i]) && deep && typeof v=='object')?me(v,fun,deep-1):v;
                }else{
                    for(i in hash)
                        if(fun?fun(hash[i],i):1)
                            h[i]=((v=hash[i]) && deep && typeof v=='object')?me(v,fun,deep-1):v;
                }
                return h;
            }else return hash;
        }else return hash;
    },
    /*filter hash/array
    fun: filter function(will delete "return false")
    */
    filter:function(obj, fun, scope,force){
        if(!force && obj && obj.constructor == Array){
            var i,l,a=[],o;
            for(i=0, l=obj.length; i<l; i++)a[a.length]=obj[i];
            obj.length=0;
            scope=scope||a;
            for(i=0, l=a.length; i<l; i++)
                if(fun.call(scope,a[i],i,a)!==false)
                    obj[obj.length]=a[i];
        }else{
            var i, bak={};
            scope=scope||obj;
            for(i in obj)
                if(false===fun.call(scope, obj[i], i, obj))
                    bak[i]=1;
            for(i in bak)
                delete obj[i];
        }
        return obj;
    },
    /*convert iterator to Array
    value: something can be iteratorred
    _.toArr({a:1},true) => [a];
    _.toArr({a:1},false) => [1];
    _.toArr('a,b') => ['a','b'];
    _.toArr('a;b',';') => ['a','b'];
    */
    toArr:function(value, flag){
        if(!value)return [];
        var arr=[];
        //hash
        if(typeof flag == 'boolean')
            for(var i in value)
                arr[arr.length]=flag?i:value[i];
        //other like arguments
        else{
            if(typeof value=='string')
                arr=value.split(flag||',');
            else
                for(var i=0,l=value.length; i<l; ++i)
                    arr[i]=value[i];
        }
        return arr;
    },
    toUTF8:function(str){
        return str.replace(/[^\x00-\xff]/g, function(a,b) {
            b=a.charCodeAt();
            return '\\u' + Math.floor(b/16).toString(16)+(b%16).toString(16);
        })
    },
    fromUTF8:function(str){
        return str.replace(/\\u([0-9a-f]{3})([0-9a-f])/g,function(a,b,c){return String.fromCharCode((parseInt(b,16)*16+parseInt(c,16)))})
    },
    urlEncode:function(hash){
        var a=[],i,o;
        for(i in hash){
            o=hash[i];
            a.push(encodeURIComponent(i)+'='+encodeURIComponent(typeof o=='string'?o:_.serialize(o)));
        }
        return a.join('&');
    },
    urlDecode:function(str, key){
        if(!str)return key?'':{};
        var arr,hash={},a=str.split('&'),o;
        for(var i=0,l=a.length;i<l;i++){
            o=a[i];
            arr=o.split('=');
            hash[decodeURIComponent(arr[0])]=decodeURIComponent(arr[1]);
        }
        return key?hash[key]:hash;
    },

    // type detection
    exists:function(target)  {return target!==undefined},
    isNull:function(target)  {return (typeof target == 'object') && !target },
    isObj:function(target)   {return !!target  && (typeof target == 'object' || typeof target == 'function')},
    isBool:function(target)  {return typeof target == 'boolean'},
    isNumb:function(target)  {return typeof target == 'number' && isFinite(target)},
    isDate:function(target)  {return !!target && target.constructor == Date},
    isFun:function(target)   {return typeof target == "function" && target.constructor != RegExp},
    isArr:function(target)   {return !!target && target.constructor == Array},
    isHash:function(target)  {return !!target && typeof target == 'object' && target.constructor == Object},
    isReg:function(target)   {return !!target && target.constructor == RegExp},
    isStr:function(target)   {return typeof target == "string"},
    isArguments:function(target)   {return !!(target && target.callee && target.callee.arguments===target)},
    //for handling String
    str:{
        startWith:function(str,sStr){
            return str.indexOf(sStr) === 0;
        },
        endWith:function (str,eStr) {
            var l=str.length-eStr.length;
            return l>=0 && str.lastIndexOf(eStr) === l;
        },
        repeat:function(str,times){
            return new Array(times+1).join(str);
        },
        initial:function(str){
            return str.charAt(0).toUpperCase() + str.substring(1);
        },
        trim:function(str){
            return this.ltrim(this.rtrim(str));
        },
        ltrim:function(str){
            return str.replace(/^ */,"");
        },
        rtrim:function(str){
            return str.replace(/ *$/,"");
        },
/*
        blen : function(s){
            var _t=s.match(/[^\x00-\xff]/ig);
            return s.length+(null===_t?0:_t.length);
        },
*/
        //Dependency: linb.Dom
        toDom:function(str,flag){
            var me=arguments.callee, pool=me._pool||(me._pool=[]),i=0,l=pool.length,p,r=[];
            do{p=pool[i++]}while(i<l && (p&&p.firstChild))
            if(!p || p.firstChild){
                p=document.createElement('div');
                pool.push(p);
            }
            p.innerHTML=str;
            for(var i=0,t=p.childNodes,l=t.length;i<l;i++)r[r.length]=t[i];
            return linb(r);
        }
    },
    //for handling Array
    arr:{
        subIndexOf:function(arr,key,value){
            if(value===undefined)return -1;
            for(var i=0, l=arr.length; i<l; i++)
                if(arr[i] && arr[i][key] === value)
                    return i;
            return -1;
        },
        removeFrom:function(arr, index,length){
            arr.splice(index, length || 1);
            return arr;
        },
        removeValue:function(arr, value){
            for(var l=arr.length,i=l-1; i>=0; i--)
                if(arr[i]===value)
                    arr.splice(i,1);
            return arr;
        },
        /*
         insert something to array
         arr: any
         index:default is length-1
         flag: is add array

         For example:
         [1,2].insertAny(3)
            will return [1,2,3]
         [1,2].insertAny(3,0)
            will return [3,1,2]
         [1,2].insertAny([3,4])
            will return [1,2,3,4]
         [1,2].insertAny([3,4],3,true)
            will return [1,2,[3,4]]
        */
        insertAny:function (arr, target,index, flag) {
            var l=arr.length;
            flag=target.constructor!=Array || flag;
            if(index===0){
                if(flag)
                    arr.unshift(target);
                else
                    arr.unshift.apply(arr, target);
            }else{
                var a;
                if(!index || index<0 || index>l)index=l;
                if(index!=l)
                    a=arr.splice(index,l-index);
                if(flag)
                    arr[arr.length]=target;
                else
                    arr.push.apply(arr, target);
                if(a)
                    arr.push.apply(arr, a);
            }
            return index;
        },
        indexOf:function(arr, value) {
            for(var i=0, l=arr.length; i<l; i++)
                if(arr[i] === value)
                    return i;
            return -1;
        },
        /*
        fun: fun to apply
        desc: true - max to min , or min to max
        atarget: for this
        */
        each:function(arr,fun,scope,desc){
            var i, l, a=arr;
            if(a.constructor!=Array){
                if((a=a._nodes) || a.constructor!=Array)
                    throw new Error('errNotArray');
                if(desc===undefined)
                    desc=1;
            }
            l=a.length;
            scope = scope||arr;
            if(!desc){
                for(i=0; i<l; i++)
                    if(fun.call(scope, a[i], i, a)===false)
                        break;
            }else
                for(i=l-1; i>=0; i--)
                    if(fun.call(scope, a[i], i, a)===false)
                        break;
            return arr;
        }
    }
});
_.merge(_.fun,{
    body:function(fun){
        with (String(fun))return slice(indexOf("{") + 1, lastIndexOf("}"));
    },
    args:function(fun){
        with (String(fun)) return slice(indexOf("(") + 1, indexOf(")")).split(',');
    },
    clone:function(fun){
        return new Function(_.fun.args(fun),_.fun.body(fun));
    }
});


Namespace=function(key){
    var a=key.split('.'),w=window;
    return _.get(w, a) || _.set(w, a, {});
};

Class=function(key, pkey, obj){
    var _Static, _parent=[], self=Class, w=window, env=self._fun, reg=self._reg, parent0, _this,i,t,_t;
    obj=obj||{};
    //exists?
    if(t=_.get(w, key.split('.')))return t;

    //multi parents mode
    pkey = ( !pkey?[]:typeof pkey=='string'?[pkey]:pkey);
    for(i=0; t=pkey[i]; i++)
        if(!(_parent[i]=(_.get(w, t.split('.')) || (linb&&linb.SC&&linb.SC(t)))))
            throw new Error('errNoParent:'+ t);
    if(obj.Dependency)
        for(i=0; t=obj.Dependency[i]; i++)
            if(!(_.get(w, t.split('.')) || (linb&&linb.SC&&linb.SC(t))))
                throw new Error('errNoDependency:'+ t);
    parent0=_parent[0];

    // collect items
    _Static=obj.Static||{};
    t={};
    for(i in _Static)
        if(reg[i])t[i]=1;
    for(i in t)
        delete _Static[i];

    //before and after will pass to children
    _Static.Before = obj.Before || (parent0&&parent0.Before);
    _Static.After = obj.After || (parent0&&parent0.After);
    _Static.$End = obj.$End || (parent0&&parent0.$End);
    _Static.__gc = obj.__gc || _Static.__gc || function(){Class.__gc(this.$key);};

    /*set constructor first and create _this
    upper is the first parent Class
    */
    if(typeof obj.Constructor == 'function'){
        _this = env(obj.Constructor, 'Constructor', key, parent0||_.fun());
        _this.Constructor = String(obj.Constructor);
    }else{
        if(parent0){
            // Constructor is for opera, in opear fun.toString can't get arguments sometime
            var f=_.fun(),str = parent0.Constructor;
            if(str)f=new Function(str.slice(str.indexOf("(") + 1, str.indexOf(")")).split(','), str.slice(str.indexOf("{") + 1, str.lastIndexOf("}")));
            _this = env(f, 'Constructor', key, parent0.upper);
            _this.Constructor = str;
        }else
            _this = _.fun();
    }

    //collect parent items, keep the last one
    _t=_.fun();
    for(i=_parent.length-1; t=_parent[i--];){
        _.merge(_t,t);
        _.merge(_t.prototype,t.prototype);
    }
    //set keys
    _this.KEY=_this.$key=_this.prototype.KEY=_this.prototype.$key=key;
    //envelop
    //  from Static
    self._wrap(_this,_Static,0,_t);
    //  from Instance
    if(t=obj.Instance)
        self._wrap(_this.prototype,t,1,_t.prototype);
    //inherite from parents
    self._inherit(_this,_t);
    self._inherit(_this.prototype,_t.prototype);
    _t=null;

    //exe before functoin
    if(_.tryF(_this.Before, arguments, _this)===false)
        return false;

    //add child key to parents
    for(i=0; t=_parent[i]; i++){
        t=(t.$children || (t.$children=[]));
        for(var j=0,k=t.length,b;j<k;j++)
            if(t[k]==key){
                b=true;
                break;
            }
        if(!b)t[t.length]=key;
    }

    //set symbol
    _this.$linb$ = 1;
    _this.$children = [];
    _this.$parent = _parent;

    //set constructor
    _this.prototype.constructor = _this;
    //set key
    _this[key] = _this.prototype[key] = true;

    //attached to global
    _.set(w, key.split('.'), _this);
    //exe after function
    _.tryF(_this.After, [], _this);
    //exe ini function
    _.tryF(obj.Initialize, [], _this);
    _.tryF(_this.$End, [], _this);

    //return Class
    return _this;
};
_.merge(Class, {
    _reg:{$key:1,$parent:1,$children:1,KEY:1,Static:1,Instance:1,Constructor:1,Initialize:1},
    _reg2:{'constructor':1,'prototype':1,'toString':1,'valueOf':1},
    /*envelop a function by some keys
    */
    _fun:function(fun, name, original, upper){
        fun.$name$=name;
        fun.$original$=original;
        if(upper)fun.upper = upper;
        return fun;
    },
    _other:["toString", "valueOf"],
    /*envelop object's item from an object
    target: target object
    src: from object
     i: key in hash
    limit: envelop values in a hash
    */
    _o:{},
    //inherit from parents
    _inherit:function (target, src, instance){
        var i, o, r=this._reg;
        for(i in src){
            if(i in target || (!instance && r[i]) || i.charAt(0)=='$')continue;
            o=src[i];
            if(o && o.$linb$)continue;
            target[i]=o;
        }
    },
    //wrap
    _wrap:function (target, src, instance, parent){
        var self=this, i,j,o,k=target.KEY,r=self._reg,r2=self._reg2,f=self._fun,oo=self._other;
        for(i in src){
            if(r2[i] || (!instance && r[i]))continue;
            o=src[i];
            target[i] = (typeof o != 'function') ? o : f(o, i, k, typeof parent[i]=='function'&&parent[i]);
        }
        for(j=0;i=oo[j++];){
            o=src[i];
            if(o && (o == self._o[i]))continue;
            target[i] = (typeof o != 'function') ? o : f(o, i, k, typeof parent[i]=='function'&&parent[i]);
        }
    },
    __gc:function(key){
        if(typeof key=='object')key=key.KEY||"";
        var t = _.get(window, key.split('.')),s;
        if(t){
            //remove from SC cache
            if(s=_.get(window,['linb','cache','SC']))delete s[key];
            //destroy children
            for(var i=0,o; o=t.$children[i];i++)
                if(o=_.get(window,o.split('.')))
                    CLASS.__gc(o);
            t.$parent.length=t.$children.length=0;
            _.set(window, key.split('.'));
        }
    }
});

//function dependency: linb.Dom linb.Thread
/*
    linb(window)
    linb(document)
    linb("id")
    linb(["id1","id2","id3"...])
    linb(linb(...))
    linb(node)
    linb([node,node,node,...])
    linb(fun):fun will reutun dom node array
*/
linb=function(nodes,flag){return linb.Dom.pack(nodes, flag)};
_.merge(linb,{
    cache:{dom:{},domId:{},template:{},hookKey:{},thread:{},SC:{},text:{}},
    Locale:{en:{}},
    $lang:'en',
    $href:'javascript:;',
    $langId:'linblangkey',
    reLang:function(key,callback){
        var l=linb.Locale,g=linb.getRes,t,v,i,j,f,m,z,a=[];
        linb.$lang=key;
        v = linb.browser.ie ? document.all.tags('span') : document.getElementsByTagName('span');
        for(i=0;t=v[i];i++)if(t.id==linb.$langId)a[a.length]=t;
        f=function(){
            (function(){
                j=a.splice(0,100);
                for(i=0;t=j[i];i++)
                    if(typeof(v=g(t.className))=='string')
                        t.innerHTML=v;
                if(a.length)
                    setTimeout(arguments.callee,0);
                _.tryF(callback);
            }())
        },
        z = 'linb.Locale.' + key,
        m=function(){
            linb.include(z+'.'+linb.ini.appLangKey,linb.getPath('Locale.' + key, '.js'),f,f);
        };
        linb.include(z,linb.getPath(z, '.js'),m,m);
    },
    _r:/\x24(\d+)/g,
    getRes:function(id){
        var d,
            b= id.indexOf('-')!=-1?((d=id.split('-'))&&(id=d[0])&&d):arguments ,
            c=_.get(linb.Locale[linb.$lang], id.split('.'));
        return (d=typeof c)=='string'
               ? c.replace(linb._r,function(z,id){return b[parseInt(id)+1]||z})
               : d=='function'
               ? c.apply(null,b) :
               c ? c : id.substr(id.lastIndexOf('.')+1)
    },
    wrapRes:function(id){
        var i=id, s,r;
        if(i.charAt(0)=='$')arguments[0]=i.substr(1,i.length-1);
        s=id;
        r= linb.getRes.apply(null,arguments);
        if(s==r)r=i;
        return '<span id="'+linb.$langId+'" class="'+s+'">'+r+'</span>';
    },
    request:function(uri, query, onSuccess, onFail, threadid, options){
        if(!query)
            query=''+_();
            return ((options&&options.method.toLowerCase()=='post')?linb.IAjax:linb.absIO.isCrossDomain(uri)?linb.SAjax:linb.Ajax).apply(null, arguments).start()
    },
    include:function(id,path,onSuccess,onFail){if(id&&linb.SC.get(id))_.tryF(onSuccess); else linb.SAjax(path,'',onSuccess,onFail,0,{rspType:'script'}).start()},
    /*
    set application main function
    example:
        linb.main(function(){
            ...
        });
    */
    _m:[],
    main:function(fun){linb._m.push(fun)},
    /*
    key: linb.UI.xxx
    tag: file tag
    add: appearance or bahavior
    example:
        linb.getPath('linb.UI.Button','','appearance') => linb.ini.path + /appearance/UI/Button/
        linb.getPath('linb.UI.Button','.gif','appearance') => linb.ini.path + /appearance/UI/Button.gif
        linb.getPath('a.b','','appearance') => linb.ini.appPath + /a/appearance/b/"
        linb.getPath('a.b','.gif','appearance') => linb.ini.appPath + /a/appearance/b.gif"
    */
    getPath : function(key, tag, folder){
        key=key.split('.');
        if(folder){
            var a=[key[0],folder];
            for(var i=1,l=key.length;i<l;i++)
                a.push(key[i]);
            key.length=0;
            key=a;
        }

        var pre,ini=linb.ini;
        if(key[0]=='linb'){
            pre=ini.path;
            key.shift();
            if(key.length==(folder?1:0))key.push('linb');
        }else{
            pre=ini.appPath;
            if(key.length==((folder?1:0)+1) && tag=='.js')key.push('index');
            if(ini.verPath) pre += ini.verPath + '/';
            if(ini.ver) pre += ini.ver + '/';
        }
        return pre + key.join('\/') + (tag||'\/');
    },
    log:_.fun(),
    message:_.fun(),

    //profile object cache
    _pool:[],
    getObject:function(id){return linb._pool['$'+id]},

    //Dependency: linb.absBox
    //create:function(tag, properties, events, host){
    create:function(tag, id){
        var arr,o,t,me=arguments.callee,r1=me.r1||(me.r1=/</);
        if(typeof tag == 'string'){
            //HTML text node
            if(id===true)
                o = linb([document.createTextNode(tag)]);
            //Any class inherited from linb.absBox
            else if(t=linb.absBox.$type[tag]){
                arr=[];
                //shift will crash in opera
                for(var i=1,l=arguments.length;i<l;i++)
                    arr[i-1]=arguments[i];
                o =new (linb.SC(t))(false);
                if(o._ini)o._ini.apply(o, arr);
                if(o.render)o.render();
            //from HTML string
            }else if(r1.test(tag))
                o = _.str.toDom(tag);
            //from HTML element tagName
            else{
                o=document.createElement(tag);
                o.id = typeof id=='string'?id:_.id();
                o=linb([o]);
            }
        //Any class inherited from linb.absBox
        }else
            o =new (linb.SC(tag.key))(tag).render();
        return o;
    }
});

/* linb.ini linb.browser dom ready
*/

new function(){
    //browser sniffer
    var w=window, u = navigator.userAgent.toLowerCase(), d=document, b=linb.browser={
        kde:/webkit/.test(u),
        opr:/opera/.test(u),
        ie:/msie/.test(u) && !/opera/.test(u),
        gek:/mozilla/.test(u) && !/(compatible|webkit)/.test(u),

        isWin:/(windows|win32)/.test(u),
        isMac:/(macintosh|mac os x)/.test(u),
        isAir:/adobeair/.test(u),
        isLinux:/linux/.test(u),
        isSecure:location.href.toLowerCase().indexOf("https")==0
    },v=function(k,s){return k + (b.ver=u.split(s)[1].split('.')[0])};
    _.filter(b,function(o){return !!o});
    if(b.ie){
        b[v('ie','msie ')]=true;
        if(b.ie6){
            //ex funs for ie6
            try {document.execCommand('BackgroundImageCache', false, true)}catch(e){}
            w.XMLHttpRequest = function(){return new ActiveXObject("Msxml2.XMLHTTP")};
        }
    }else if(b.gek)
        b[v('gek','firefox/')]=true;
    else if(b.opr)
        b[v('opr','opera/')]=true;
    else if(b.kde)
        b[v('kde','safari/')]=true;

    b.contentBox = function(n){
        return (b.ie||b.opr) ?
                !/BackCompat|QuirksMode/.test(d.compatMode) :
                (n = (n=n||d.documentElement).style["-moz-box-sizing"] || n.style["box-sizing"]) ? (n=="content-box") : true;
    }();

    var ini=linb.ini={};
    //special var
    if(window.linb_ini)
        _.merge(ini,window.linb_ini);

    if(!ini.path){
        var s,arr = document.getElementsByTagName('script'), reg = /js\/linb(-[\w]+)?\.js$/,l=arr.length;
        while(--l>=0){
            s=arr[l].src;
            if(s.match(reg)){
                ini.path = s.replace(reg,'');
                break;
            }
        }
    }
    _.merge(ini,{
        appPath:location.href.split('?')[0].replace(/[^\\\/]+$/,''),
        appLangKey:'app',
        file_bg:ini.path+'bg.gif',
        dummy_tag:'$_dummy_$'
    });
    if(!ini.path)
        ini.path=ini.appPath+'/jsLinb';


    //for dom ready
    var f = function(){
        if(d.addEventListener && !b.kde)
            d.removeEventListener("DOMContentLoaded",arguments.callee,false);
        try{
            for(var i=0,l=linb._m.length;i<l;i++)
                _.tryF(linb._m[i])
            linb._m.length=0;
            linb.isDomReady=true;
        }catch(e){
            _.asyRun(function(){throw e})
        }
    };

    /* for Mozilla/Opera9 */
    if (d.addEventListener && !b.kde)
        d.addEventListener("DOMContentLoaded", f, false);
    //for ie
    else if (b.ie)
        (function(){try{
            //for ie7 iframe(doScroll is always ok)
            d.activeElement.id;
            d.documentElement.doScroll('left');f()}catch(e){setTimeout(arguments.callee,1)}})();
    //kde
    else
        (function(){/loaded|complete/.test(d.readyState)?f():setTimeout(arguments.callee,1)})()
};

/*linb.Thread
*  dependency: _ ; Class ; linb
parameters:
id: id of this thread, if input null, thread will create a new id
tasks: [task,task,task ...] or [{},{},{} ...]
    task: function
    or
    {
      task,      //function
      args,      //args array for task
      scope,     //this object for task
      delay ,    //ms number
      callback   //function for callback
   }
delay:default delay time;
callback:default calback function;
onStart: on start function
onEnd: on end function
cycle: is the thread circular
*/
Class('linb.Thread',null,{
    Constructor:function(id, tasks, delay, callback, onStart, onEnd, cycle){
        //for api call directly
        var self=this,me=arguments.callee,t=linb.cache.thread;
        // linb.Thread() => self.constructor!==me
        // in an inner method => !!self.id is true
        if(self.constructor!==me || !!self.id)
            return new me(id, tasks, delay, callback, onStart, onEnd, cycle);

        if(typeof id!='string')id='$' + (self.constructor.$id++);
        self.id=id;
        //thread profile
        self.profile = t[id] || (t[id] = {
            id:id,
            _start:false,
            time:0,
            _left:0,
            _asy:-1,
            //sleep_flag:-1,
            index:0,

            tasks:tasks||[],
            delay: delay || 0,
            callback:callback,
            onStart:onStart,
            onEnd:onEnd,
            cache:{},
            status:"run",
            cycle:!!cycle
        });
    },
    Instance:{
        _fun:_.fun(),
        __gc:function(){
            var m=linb.cache.thread,t=m[this.id];
            if(t){
                delete m[this.id];
                t.tasks.length=0;
                for(var i in t)t[i]=null;
            }
        },
        _task:function(){
            var self=this,p=self.profile,t={args:[]}, value=p.tasks[p.index],r,i,type=typeof value;
            p._asy=-1;

            //maybe aborted
            if(!p.status)return;

            //function
            if(type=='function') t.task=value;
            //hash
            else if(type=='object')
                for(i in value) t[i]=value[i];
            //others, give all default

            //defalut task
            if(typeof t.task!='function')t.task=self._fun;
            //default callback
            if(typeof t.callback!='function')t.callback=p.callback

            //last arg is threadid
            t.args.push(p.id);
            //to next pointer
            p.index++;
            p.time=_();
            //if error raise in the process, abort the thread
            //try{
                r = _.tryF(t.task, t.args || [p.id], t.scope||self, null);
                //called abort in [task]
                if(!p.status)return;

                //cache return value
                if(t.id)p.cache[t.id] = r;
                // call back function
                // if callback return false, stop.
                if(t.callback)
                    if(false===_.tryF(t.callback, [p.id], self, true)){
                      self.abort();
                      return;
                    }
                //called suspend in [task]
                if(p.status!=="run")return;
            //}catch(e){
           //     self.abort();
            //    linb.Debugger && linb.Debugger.trace(e);
           // }
            // if set Sleep at t.task or t.callback , stop continue running
            if(!p || p.status!=="run")return;
            self.start();
        },
        start:function(time){
            var self=this, p=self.profile, task,delay;
            if(p._start===false){
                p._start=true;
                //call onstart
                if(false===_.tryF(p.onStart,[p.id],self))
                    return self.abort();
            }
            if(!p.tasks.length)return self.abort();
            if(p.index>=p.tasks.length)
                if(p.cycle===true)
                    self.profile.index = 0;
                else
                    return self.abort();
            task=p.tasks[p.index];

            delay=typeof task=='number'?task:typeof task.delay=='number'?task.delay:p.delay;
            p._left= (time || time===0)?time:delay;

            if(p._asy!=-1)clearTimeout(p._asy);
            p._asy = _.asyRun(self._task, p._left, [], self);
            p.time=_();
            return self;
        },
        suspend:function(){
            var n,p=this.profile;
            if(p.status=="pause")return;
            p.status="pause";
            if(p._asy!==-1){
                clearTimeout(p._asy);
                if(p.index>0)p.index--;
            }
            n=p._left-(_() - p.time);

            p._left=(n>=0?n:0);
            return this;
        },
        /*time
        number:set timeout to number
        true:set timeout to default
        false:set timeout to 0
        undefined: timetou to left
        */
        resume:function(time){
            var self=this;
            if(self.profile.status=="run")return;

            time = time===undefined ? self.profile._left :
                        time===true ? self.profile.delay :
                        time===false ? 0 :
                        (Number(time) || 0);

            self.profile.status="run";
            self.start(time);
            return self;
        },
        abort:function(){
            var t=this.profile;
            t.status="stop";
            clearTimeout(t._asy);
            _.tryF(t.onEnd, [t.id]);
            this.__gc();
        },
        links:function(thread){
            var p=this.profile, onEnd=p.onEnd, id=p.id;
            p.onEnd=function(){_.tryF(onEnd,[id]); thread.start()};
            return this;
        },
        insert:function(arr, index){
            var self=this,o=self.profile.tasks,l=o.length,a;
            if(arr.constructor!=Array)arr=[arr];
            index= index || self.profile.index;
            if(index<0 || index>l)index=l;
            a=o.splice(index,l-index);
            o.push.apply(o, arr);
            o.push.apply(o, a);
            return self;
        },
        getCache:function(key){
            return this.profile.cache[key];
        },
        setCache:function(key,value){
            this.profile.cache[key] = value;
            return this;
        }
    },
    After:function(){
        /*
        give shortcut to some functions
        */
        var self=this, f=function(i){
            self[i]=function(id){
                var t;
                if(linb.cache.thread[id])
                    (t=linb.Thread(id))[i].apply(t,Array.prototype.slice.call(arguments,1));
            }
        },
        a = 'start,suspend,resume,abort'.split(',');
        for(var i=0,l=a.length;i<l;i++)f(a[i]);
    },
    Static:{
        $id:1,
        __gc : function(){
            linb.cache.thread={};
        },
        isAlive:function(id){
            return !!linb.cache.thread[id];
        },
        //Dependency: linb.Dom
        observableRun:function(tasks,onEnd,threadid){
            var thread=linb.Thread, dom=linb.Dom;
            if(!_.isArr(tasks))tasks=[tasks];
            //if thread exists, just inset task to the next positiong
            if(linb.cache.thread[threadid]){
                if(typeof onEnd=='function')
                    tasks.push(onEnd);
                thread(threadid).insert(tasks);
            //if does not exist, create a new thread
            }else{
                thread(threadid, tasks,
                    0,null,
                    //set busy status to UI
                    function(threadid){
                        if(dom)dom.busy(threadid)
                    },
                    //set free status to UI
                    function(threadid){
                        _.tryF(onEnd,arguments,this);
                        if(dom)dom.free(threadid)
                    }
                ).start();
            }
        },
        /*group thread run once
        group: hash include thread or threadid
        callback: call after a thread finish
        onStart:before all threads start
        onEnd:after all threads end
        */
        group:function(id, group, callback,onStart,onEnd){
            var bak={},
                thread=linb.Thread,
                f=function(o,i,threadid){
                    if(typeof o == 'string')o=thread(o);
                    if(o){
                        var f = function(){
                            var me=arguments.callee;
                            _.tryF(me.onEnd,arguments,this);
                            me.onEnd=null;
                            delete bak[i];
                            //call callback here
                            _.tryF(callback,[i, threadid],this);
                            if(_.isEmpty(bak))
                                thread.resume(threadid);
                        };
                        f.onEnd = o.profile.onEnd;
                        o.profile.onEnd = f;
                        o.start();
                    }
                };
            for(var i in group)bak[i]=1;
            return thread(id, [function(threadid){
                if(!_.isEmpty(group)){
                    thread.suspend(threadid);
                    for(var i in group)f(group[i],i, threadid);
                }
            }],0,null,onStart,onEnd);
        }
    }
});


/*linb.absIO/ajax
*  dependency: _ ; Class ; linb ; linb.Thread
*/
/*
        get     post    get(cross domain)   post(corss domain)  post file   return big data(corss domain)
ajax    +       +       -                   -                   -           -
sajax   +       -       +                   -                   -           *
iajax   +       +       +                   *                   *           *
*/
Class('linb.absIO',null,{
    Constructor:function(uri, query, onSuccess, onFail, threadid, options){
        //get properties
        if(typeof uri=='object')
            options=uri;
        else{
            options=options||{};
            _.merge(options, {
                uri:uri,
                query:query,
                onSuccess:onSuccess,
                onFail:onFail,
                threadid:threadid
            });
        }
        //for cache
        var self=this,  me=arguments.callee,con=self.constructor;
        if((con !== me) || self.id)
            return new me(options);

        //give defalut value to those members
        _.merge(options,{
            id : options.id || (_()+ '' +(con._id++)),
            uri : options.uri||'',
            query : options.query||'',
            asy : options.asy!==false,
            method : 'POST'==(options.method||con.method).toUpperCase()?'POST':'GET'
        },'all');
        var a='retry,timeout,rspType,customQS'.split(',');
        for(var i=0,l=a.length;i<l;i++)
            options[a[i]] = (a[i] in options)?options[a[i]]:con[a[i]];

        _.merge(self, options, 'all');
        if(con.events)
            _.merge(self, con.events);

        self.query = self.customQS(self.query);

        if(!self._useForm && typeof self.query!='string')
            self.query = con._buildQS(self.query, self._single);

        return self;
    },
    Instance:{
        _fun:_.fun(),
        _flag:0,
        _response:'',
        _retryNo:0,
        _end:false,

        _time:function() {
            var self=this,c=self.constructor;
            self._clear();
            if (self._retryNo < self.retry) {
                self._retryNo++;
                _.tryF(self.onRetry,[self._retryNo],self);
                self.start();
            }else{
                _.tryF(self.onTimeout,[],self);
                self._onError(new Error("errTimout"));
            }
        },
        _onEnd:function(){
            var self=this;
            self._end=true;
            if(self._flag>0){
                clearTimeout(self._flag);
                self._flag=0
            }
            linb.Thread.resume(self.threadid);
            _.tryF(self.onEnd,[],self);
            self._clear();
        },
        _onStart:function(){
            var self=this;
            linb.Thread.suspend(self.threadid);
            _.tryF(self.onStart,[],self);
        },
        _onResponse:function(){
            var self=this;
            if(false!==_.tryF(self.beforeSuccess,[self._response, self.rspType, self.threadid], self))
                _.tryF(self.onSuccess,[self._response, self.rspType, self.threadid], self);
            self._onEnd();
        },
        _onError:function(e){
            var self=this;
            if(false!==_.tryF(self.beforeFail,[e, self.threadid],self))
                _.tryF(self.onFail,[String(e), self.rspType, self.threadid], self);
            self._onEnd();
        },
        abort:function(){
            this._onEnd();
        }
    },
    Static:{
        $abstract:true,
        _id:1,
        method:'GET',
        retry:2,
        timeout:60000,
        rspType:'text',

        //paras in request object
        type:'type',
        randkey:'id',
        callback:'callback',

        _buildQS:function(hash, flag){
            return flag?_.serialize(hash):_.urlEncode(hash);
        },
        customQS:function(obj){
            return obj;
        },
        _if:function(doc,id,onLoad){
            var e=linb.browser.ie,n = doc.createElement(e?"<iframe name='"+id+"' "+(onLoad?"onload='linb.IAjax._o(\""+id+"\")'":"")+">":"iframe"),w;
            if(id)n.id=n.name=id;
            if(!e&&onLoad)n.onload=onLoad;
            n.style.display = "none";
            doc.body.appendChild(n);
            w=frames[frames.length-1];
            return [n,w,w.document];
        },
        isCrossDomain:function(uri){
            uri=uri||'';
            var me=arguments.callee,
                r=me.r || (me.r=/(http(s)?\:\/\/)?([\w\.]+(:[\d]+)?)(.*)/),t;
            if((t=uri.indexOf(':'))==-1||t>uri.indexOf('/'))return false;
            if(uri.indexOf('file:')===0)return !!location.host;
            return  location.host != uri.replace(r,'$3')
        },
        //get multi ajax results once
        groupCall:function(hash, callback, onStart, onEnd, threadid){
            var i,f=function(o,i,hash){
                hash[i]=linb.Thread(null,[function(threadid){
                    o.threadid=threadid;
                    o.start();
                }]);
            };
            for(i in hash)f(hash[i],i,hash);
            return linb.Thread.group(null, hash, callback, function(){
                linb.Thread(threadid).suspend();
                _.tryF(onStart,arguments,this);
            }, function(){
                _.tryF(onEnd,arguments,this);
                linb.Thread(threadid).resume();
            }).start();
        }
    }
});
Class('linb.Ajax','linb.absIO',{
    Instance:{
        _single:true,
        _XML:null,
        start:function() {
            var self=this;
            if(false===_.tryF(self.beforeStart,[],self)){
                self._onEnd();
                return;
            }
            if (!self._retryNo)
                self._onStart();
            try {
                with(self){
                    //must use "self._XML", else opera will not set the new one
                   var x = self._XML = new window.XMLHttpRequest();
                   if(asy)
                       x.onreadystatechange = function(){
                           if(self && x && x.readyState==4) {
                               self._complete.apply(self);
                               //must clear here, else memory leak
                               self._clear();
                           }
                       };

                    if (!_retryNo && method != "POST"){
                        if(query)
                            uri = uri.split("?")[0] + "?" + query;
                        query=null;
                    }

                    if(x.overrideMimeType)
                          x.overrideMimeType('text/xml');

                    x.open(method, uri, asy);
                    if(method != "POST")
                        x.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                    x.setRequestHeader("X-Requested-With", "XMLHttpRequest");
                        if(x.overrideMimeType )
                    x.setRequestHeader("Connection", "close");

                    //for firefox syc GET bug
                    try{x.send(query);}catch(e){}

                    if(asy){
                      if(x&&timeout > 0)
                        _flag = _.asyRun(function(){if(self && !self._end){self._time()}}, self.timeout);
                    }else
                        _complete();
                }
            }catch(e){
                self._onError(e);
            }
            return self;
        },
        abort:function(){
            var self=this, x = self._XML;
            if(x){
                x.onreadystatechange=self._fun;
                x.abort();
                self._XML=null;
            }
            arguments.callee.upper.call(self);
        },
        _clear:function(){
            var self=this,x = self._XML;
            if(x){
                x.onreadystatechange=self._fun;
                self._XML=null;
            }
        },
        _complete:function() {
            with(this){
                //this is for opera
                var x= this._XML,status = x.status;
                _response = rspType=='text'?x.responseText:x.responseXML;
                if(status===undefined || status===0 || status==304 || (status >= 200 && status < 300 ))
                    _onResponse();
                else
                    _onError(new Error('errXMLHTTP:' +status));
            }
        }
    }
});
Class('linb.SAjax','linb.absIO',{
    Instance:{
        start:function(){
            var self=this,id,c=self.constructor, t, n, ok=false;
            if(false===_.tryF(self.beforeStart,[],self)){
                self._onEnd();
                return;
            }
            if (!self._retryNo)
                self._onStart();

            //first
            id=self.id;
            if(c._pool[id])
                c._pool[id].push(self);
            else
                c._pool[id]=[self];

            var w=c._n=document;
            n = self.node = w.createElement("script");
            n.src = self.uri + (self.query?'?'+self.query:'');
            n.type= 'text/javascript';
            n.charset='utf-8';
            n.id='linb:script:'+self.id;
            n.onload = n.onreadystatechange = function(){
                var t=this.readyState;
                if(!ok && (!t || t == "loaded" || t == "complete") ) {
                    ok=true;
                    if(self.rspType=='script')
                        self._onResponse();
                    else self._loaded();
                }
            };
            //firefox only
            n.onerror=function(){
                self._loaded();
            };

            //w.getElementsByTagName("head")[0].appendChild(n);
            w.body.appendChild(n);

            //set timeout
            if(self.timeout > 0)
                self._flag = _.asyRun(function(){if(self && !self._end){self._time()}}, self.timeout);
        },
        _clear:function(){
            var self=this, n=self.node, c=self.constructor, div=c.div||(c.div=c._n.createElement('div')),_pool=self.constructor._pool;
            _pool.length=0;
            delete _pool[self.id];
            if(n){
                self.node=n.id=n.onload=n.onreadystatechange=n.onerror=null;

                if(self.rspType!='script'){
                    //in ie + add script with url(remove script immediately) + add the same script(remove script immediately) => crash
                    //so, always clear it later
                    div.appendChild(n.parentNode&&n.parentNode.removeChild(n)||n);
                    if(linb.browser.ie)
                        _.asyRun(function(){div.innerHTML='';n.removeNode()});
                    else
                        div.innerHTML='';
                }
            }
        },
        _loaded:function(){
            var self=this;
            _.asyRun(function(){
                if(self.id && self.constructor._pool[self.id])
                    self._onError(new Error("errInData"));
            },500);
        }
    },
    Static : {
        _pool:{},
        $response:function(obj) {
            var self=this;
            try{
                if(obj && (o = self._pool[obj[self.randkey]])){
                    for(var i=0,l=o.length;i<l;i++){
                        o[i]._response=obj;
                        o[i]._onResponse();
                    }
                }else
                    self._onError(new Error("errInData:"+obj));
            }catch(e){
                linb.Debugger && linb.Debugger.trace(e);
            }
        },
        customQS:function(obj){
            var c=this.constructor, t=c.type, k=c.randkey, b=c.callback,nr=(this.rspType!='script'),rand=nr?k + '=' + this.id + '&type=script&':'';
            if(typeof obj=='string')
                return (obj && obj + '&') + rand + (nr?b + '=linb.SAjax.$response':'');
            else{
                if(nr){
                    obj[t]='script';
                    obj[k]=this.id;
                    obj[b]="linb.SAjax.$response";
                }
                return obj;
            }
        }
    }
});
Class('linb.IAjax','linb.absIO',{
    Instance:{
        _useForm:true,
        $e:function(s){this._onError(new Error("errInData:"+s));},
        start:function(){
            var self=this,c=self.constructor, i, id, t, n, k, o, b, form,onload;
            if(false===_.tryF(self.beforeStart,[],self)){
                self._onEnd();
                return;
            }
            if (!self._retryNo)
                self._onStart();

            //first
            id=self.id;
            if(c._pool[id])
                c._pool[id].push(self);
            else
                c._pool[id]=[self];
            //use window.name
            self._onload = onload = function(id){
                //in some situation, this function will be triggered twice.
                //in IE/opera, "setting an image file as dummy" will trigger the second onload event with 'self.node == null'
                if(!self.node)return;
                var w=self.node.contentWindow,c=linb.IAjax,o,t;
                //in opera, "set location" will trigger location=='about:blank' at first
                if(linb.browser.opr)try{if(w.location=='about:blank')return}catch(e){}
                try{
                    w.location=c._getDummy()+'#'+linb.ini.dummy_tag;
                    if(w.name==self.id)
                        self.$e('no response');
                    else{
                        try{
                            o=_.unserialize(decodeURIComponent(w.name));
                            if(o&&(t=c._pool[o[c.randkey]]))
                                for(var i=0,l=t.length;i<l;i++){
                                    t[i]._response=o;
                                    t[i]._onResponse();
                                }
                            else
                                self.$e(w.name);
                         }catch(a){
                            self.$e(w.name);
                         }
                    }
                }catch(e){}
            };

            //create form
            var a=c._if(document,id, onload);
            self.node=a[0];
            self.frm=a[1];
            //create form
            form = self.form = document.createElement('form');
            form.style.display='none';
            form.action=self.uri;
            form.method=self.method;
            form.target=id;

            k=self.query||{};
            for(i in k){
                if(k[i] && k[i].nodeName=="INPUT"){
                    k[i].id=k[i].name=i;
                    form.appendChild(k[i]);
                    b=true;
                }else{
                    t=document.createElement('input');
                    t.id=t.name=i;
                    t.value= typeof k[i]=='string'?k[i]:_.serialize(k[i]);
                    form.appendChild(t);
                }
            }
            if(self.method=='POST' && b){
                form.enctype = 'multipart/form-data';
                if(form.encoding)
                    form.encoding = form.enctype;
            }
            document.body.appendChild(form);
            //submit
            form.submit();
            //set timeout
            if(self.timeout > 0)
                self._flag = _.asyRun(function(){if(self && !self._end){self._time()}}, self.timeout);
        },
        _clear:function(){
            var self=this, n=self.node,f=self.form, c=self.constructor, div=c.div||(c.div=document.createElement('div'));
			if(linb.browser.gek&&n)try{n.onload=null;var d=n.contentWindow.document;d.write(" ");d.close()}catch(e){}
            self.form=self.node=self.frm=null;
            clearTimeout(self._tf);
            if(n)div.appendChild(n.parentNode.removeChild(n));
            if(f)div.appendChild(f.parentNode.removeChild(f));
            div.innerHTML='';
        }
    },
    Static : {
        method:'POST',
        _pool:{},
        _o:function(id){
            var self=this,p=self._pool[id],o=p[p.length-1];
            _.tryF(o._onload);
        },
        _getDummy:function(win){
            win=win||window;
            var ns=this,
                arr,o,
                d=win.document,
                ini=linb.ini,
                b=linb.browser,
                f=ns.isCrossDomain;
            if(ns.dummy)return ns.dummy;
            //can get from linb.ini;
            if(ini.dummy)return ns.dummy=ini.dummy;
            if(b.gek){
                arr=d.getElementsByTagName("link");
                for(var i=0,j=arr.length; i<j; i++){
                    o = arr[i];
                    if (o.rel == "stylesheet" && !f(o.href))
                        return ns.dummy=o.href.split('#')[0];
                }
            }
            if(!f(ini.path)){
                //not for 'ex-domain include jslinb' case
                if(!d.getElementById('linb:img:bg')){
                    o=d.createElement('img');
                    o.id='linb:img:bg';
                    o.src=ini.file_bg;
                    o.style.display='none';
                    d.body.appendChild(o);
                }
            }
            arr=d.getElementsByTagName("img");
            for(var i=0,j=arr.length; i<j; i++){
                o = arr[i];
                if(!f(o.src))
                    return ns.dummy=o.src.split('#')[0];
            }
            //get from parent, not for opera in this case
            try{
                if(win!=win.parent)
                    if((win=win.parent) && !f(''+win.document.location.href))
                        return ns._getDummy(win);
            }catch(e){}
            //for the last change, return a file name whether it existes or does not exist, and not cache it.
            return '/favicon.ico';
        },
        customQS:function(obj){
            var s=this,c=s.constructor,t=c.type;
            obj[t]='iframe';
            obj[c.randkey]=s.id;
            return obj;
        }
    }
});

/*linb.SC for straight call
*  dependency: _ ; Class ; linb ; linb.Thread ; linb.absIO/ajax
*/
Class('linb.SC',null,{
    Constructor:function(path, callback, isAsy, threadid, options){
        var p = linb.cache.SC,r;
        if(r=p[path]||(p[path]=_.get(window,path.split('.'))))
            _.tryF(callback,[path,null,threadid],r);
        else{
            options=options||{};
            options.$cb=callback;
            if(isAsy)options.threadid=threadid;
            r=p[path]=linb.SC._call(path||'', options, isAsy);
        }
        return r;
    },
    Static:{
        __gc:function(k){
            linb.cache.SC={};
        },

        //get object from obj string
        get : function (path, obj){
            return _.get(obj||window,(path||'').split('.'));
        },
        /* function for "Straight Call"
        *   asy     loadSnips use
        *   true    true    ajax
        *   true    false   sajax
        *   false   ture    ajax
        *   false   false   ajax
        */
        _call : function (s, options, isAsy){
            isAsy = !!isAsy;
            var i,t,r,o,funs=[],ep=linb.SC.get,ct=linb.cache.text,
            f= function(text,n,threadid){
                var self=this;
                if(text){
                    //test again when asy end.
                    if(!ep(s)){
                        //loadSnips only
                        if(self.$p)
                            (self.$cache || ct)[self.$tag]=text;
                        else
                            //for sy xmlhttp ajax
                            try{_.exec(text)}catch(e){throw new Error('errInEval:"'+e + self.$tag)}
                    }
                }
                _.tryF(self.$cb,[self.$tag,text,threadid],ep(s)||{});
            },fe=function(text){
                var self=this;
                //for loadSnips resume with error too
                _.tryF(self.$cb,[null,null,self.threadid],self);
            };
            //get from object first
            if(!(r=ep(s))){
                //if script in cache
                if(t=ct[s]){
                    isAsy=false;
                    f.call({$cb: options.$cb},t);
                    //delete it
                    delete ct[s];
                }
                //get from object second
                if(!(r=ep(s))){
                     //load from sy ajax
                     o=linb.getPath(s,'.js','js');
                     options = options ||{};
                     options.$tag = s;
                     var ajax;
                     //asy and not for loadSnips
                     if(isAsy && !options.$p){
                        options.rspType="script";
                        ajax=linb.SAjax;
                     }else{
                        options.asy=isAsy;
                        ajax=linb.Ajax;
                    }
                    //get text from sy ajax
                    ajax(o, "", f, fe, null, options).start();
                    //for asy once only
                    if(!isAsy)
                        r=ep(s);
                }
            }else
                if(options.$cb)
                    f.call(options);
            return r;
        },
        /*
        arr: key array, ['linb.UI.Button','linb.UI.Input']
        callback: fire this function after all js loaded
        */
        loadSnips:function(pathArr,cache,callback,onEnd,threadid){
            if(!pathArr || !pathArr.length){
                _.tryF(onEnd,[threadid]);
                return;
            }
            var bak={}, options={$p:1,$cache:cache||linb.cache.text};
            for(var i=0,l=pathArr.length;i<l;i++)
                bak[pathArr[i]]=1;

            if(callback||onEnd){
                options.$cb=function(path){
                    //give callback call
                    if(callback)_.tryF(callback,arguments,this);
                    delete bak[path||this.$tag];
                    if(_.isEmpty(bak)){
                        _.tryF(onEnd,[threadid]);
                        onEnd=null;
                        linb.Thread.resume(threadid);
                    }
                };
            }
            linb.Thread.suspend(threadid);
            for(var i=0,s; s=pathArr[i++];)
                this._call(s, _.merge({$tag:s},options), true);
        },
        runInBG:function(pathArr, callback, onStart, onEnd){
            var i=0,j,t,self=this,fun=function(threadid){
                while(pathArr.length>i && (t=self.get(j=pathArr[i++])));
                if(!t)
                    self._call(j, {threadid:threadid},true);
                //set abort function to the next step
                if(pathArr.length<i)
                    linb.Thread(threadid).abort();
                if(pathArr.length==i)i++;
            };
            linb.Thread(null, [fun], 1000, callback, onStart, onEnd, true).start();
        },
        execSnips:function(cache){
            var i,h=cache||linb.cache.text;
            for(i in h)
                try{_.exec(h[i])}catch(e){throw new Error('errInEval:"'+e)}
            h={};
        },
        //asy load multi js file, whatever dependency
        /*
        *1.busy UI
        *3.linb.SC.groupCall some js/class
        *4.resume thread
        *5.linb.SC.loadSnips other js/class
        *6.execute other ..
        *7.free UI
        */
        groupCall:function(pathArr, callback, onEnd, threadid){
            if(pathArr){
                //clear first
                var self=this;
                self.execSnips();
                linb.Thread.suspend(threadid);
                self.loadSnips(pathArr, 0, callback, function(){
                    self.execSnips();
                    _.tryF(onEnd,[threadid]);
                    onEnd=null;
                    linb.Thread.resume(threadid);
                });
            }else
                _.tryF(onEnd,[threadid]);
        }
    }
});

/*serialize/unserialize
*/
new function(){
    var M ={
        '\b': '\\b',
        '\t': '\\t',
        '\n': '\\n',
        '\f': '\\f',
        '\r': '\\r',
        '"' : '\\"',
        '\\': '\\\\'
    },
    H={'@window':'window','@this':'this'},
    A=/[\x00-\x1f\x7f-\x9f\\\"]/g,
    C=/^\s*\x7b/, // /^\s*\{/,
    D=/^(-\d+|\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})(?:\.(\d{1,3}))?((?:[+-](\d{2}):(\d{2}))|Z)?$/,
    E=function(t,i,a,v,m,n){
        for(i in t)
            if((a=typeof (v=t[i]))=='string' && (v=D.exec(v))){
                m=v[8]&&v[8].charAt(0);
                if(m!='Z')n=(m=='-'?-1:1)*((+v[9]||0)*60)+(+v[10]||0);
                else n=0;
                m=new Date(+v[1],+v[2]-1,+v[3],+v[4],+v[5],+v[6],+v[7]||0);
                n-=m.getTimezoneOffset();
                if(n)m.setTime(m.getTime()+n*60000);
                t[i]=m;
            }else if(a=='object' &&a.constructor===Object) E(t[i]);
        return t;
    },
    R=function(n){return n<10?'0'+n:n},

    F='function',
    N='number',
    L='boolean',
    S='string',
    O='object',
    T={},
    S16=function(b){return Math.floor(b/16).toString(16)+(b%16).toString(16)},
    MS=function(x,s){return '.'+((s=x[s]())?s<10?'00'+s:s<100?'0'+s:s:'000')},
    Z=(function(a,b){a=-(new Date).getTimezoneOffset()/60; b=a>0?'+':'-'; a=''+Math.abs(a); return b+a+(a.length==1?'0':'')+':00'})();
    T['undefined']=function(){return 'undefined'};
    T[L]=function(x){return String(x)};
    T[N]=function(x){return isFinite(x) ? String(x) : 'null'};
    T[S]=function(x){
        return H[x] ||
            '"' +
            (
            A.test(x)
            ?
            x.replace(A, function(a,b) {
                if(b=M[a])return b;
                b=a.charCodeAt();
                return '\\u00' + S16(b)
            })
            :
            x
            )
            + '"'
    };
    T[O]=function(x,dateformat,deep){
        var me=arguments.callee, map = me.map || (me.map={prototype:1,constructor:1,toString:1,valueOf:1});
        deep=deep||1;
        if(deep>99)return '"too much recursion!"';
        if (x){
            var a=[], b=[], c=x.constructor, f, i, l, v;
            if(x===window)return "window";
            if(x===document)return "document";
            //for ie alien
            if((typeof x==O || typeof x==F) && typeof c != F)
                return x.nodeType? "document.getElementById('"+x.id+"')" :"$alien";
            else if(c==Array){
                a[0] = '[';
                l = x.length;
                for(i=0;i<l;++i)
                    if(f=T[typeof (v=x[i])])
                        if(typeof (v=f(v,dateformat,deep+1))==S)
                            b[b.length]=v;

                a[2]=']';
            }else if(c==Date){
                if(dateformat=='utc')
                    return '"'+ x.getUTCFullYear() + '-' +
                        R(x.getUTCMonth() + 1) + '-' +
                         R(x.getUTCDate()) + 'T' +
                         R(x.getUTCHours()) + ':' +
                         R(x.getUTCMinutes()) + ':' +
                         R(x.getUTCSeconds()) +
                         MS(x,'getUTCMilliseconds')+
                         'Z"';
                else if(dateformat=='gmt')
                    return '"'+ x.getFullYear() + '-' +
                        R(x.getMonth() + 1) + '-' +
                         R(x.getDate()) + 'T' +
                         R(x.getHours()) + ':' +
                         R(x.getMinutes()) + ':' +
                         R(x.getSeconds()) +
                         MS(x,'getMilliseconds')+
                         Z+'"';
                else
                    return 'new Date('+[x.getFullYear(),x.getMonth(),x.getDate(),x.getHours(),x.getMinutes(),x.getSeconds(),x.getMilliseconds()].join(',')+')';
            }else if(c==RegExp){
                return String(x);
            }else{
                if(typeof x.serialize == F)
                    x = x.serialize();
                if(typeof x==O){
                    if(x.nodeType){
                        return "document.getElementById('"+x.id+"')";
                    }else{
                        a[0] = '{';
                        for(i in x)
                            if(!map[i])
                                if (f=T[typeof (v=x[i])])
                                    if (typeof (v=f(v,dateformat,deep+1))==S)
                                        b[b.length] = T.string(i) + ':' + v;
                        a[2]='}';
                    }
                }else return String(x);
            }
            a[1]=b.join(', ');
            return a[0]+a[1]+a[2];
        }
        return 'null'
    };
    T[F]=function(x){return x.$path?x.$path:String(x)};

    //serialize object to string (bool/string/number/array/hash/simple function)
    _.serialize = function (obj,dateformat){
        return T[typeof obj](obj,dateformat)||'';
    };
    //unserialize string to object
    _.unserialize = function(str, dateformat){
        try{
            str=eval(C.test(str) ? '('+str+')' : str);
            if(dateformat){if(typeof str==='object')E(str);else if(typeof str==='string')return E({a:str}).a}
            return str;
        }catch(e){
            return false;
        }
    };
};
/*26 based id, some number id can crash opera9
*/
_.id=function(){
    var self=this, me=arguments.callee;
    if(self.constructor!==me || self.a)
        return (me._ || (me._= new me)).next();
    self.a=[-1];
    self.b=[''];
    self.value='';
};
_.id.prototype = {
    constructor:_.id,
    _chars  :"abcdefghijklmnopqrstuvwxyz".split(''),
    next : function(i){
        with(this){
            var m,k,l,i = (i||i===0)?i:b.length-1;
            if((m=a[i]) >= 25){
                m=0;
                if(i===0){
                    a.splice(0,0,1);
                    b.splice(0,0,'a');
                    l=a.length;
                    for(k=1;k<l;++k){
                        a[k]=0;
                        b[k]='0';
                    }
                    ++i;
                }else
                  next(i-1);
            }else ++m;
            a[i]=m;
            b[i]=_chars[m];
            return value = b.join('');
        }
    }
};(linb.Locale.en||(linb.Locale.en={})).inline={
    ok:'O K',
    cancel:'Cancel',
    today:'Today',
    yes:'Yes',
    no:'No'
};
linb.Locale.en.date={
    WEEKS:{
        '0':'Su',
        '1':'Mo',
        '2':'Tu',
        '3':'We',
        '4':'Th',
        '5':'Fr',
        '6':'Sa',
        '7':'WK'
    },
    VIEWS:{
        '10 ms':'10 millisecond',
        '100 ms':'100 milliseconds',
        '1 s':'1 second',
        '10 s':'10 seconds',
        '1 n':'1 minute',
        '5 n':'5 minutes',
        '10 n':'10 minutes',
        '30 n':'30 minutes',
        '1 h':'1 hour',
        '2 h':'2 hours',
        '6 h':'6 hours',
        '1 d':'1 day',
        '1 w':'1 week',
        '15 d':'15 days',
        '1 m':'1 month',
        '1 q':'1 quarter',
        '1 y':'1 year',
        '1 de':'10 years',
        '1 c':'1 century'
    },
    MONTHS:{
        '1':'Jan.',
        '2':'Feb.',
        '3':'Mar.',
        '4':'Apr.',
        '5':'May.',
        '6':'Jun.',
        '7':'Jul.',
        '8':'Aug.',
        '9':'Sep.',
        '10':'Oct.',
        '11':'Nov.',
        '12':'Dec.'
    },
    MS:'ms',
    S:'s',
    N:'n',
    H:'h',
    D:'d',
    W:'w',
    M:'m',
    Q:'q',
    Y:'y',
    DE:'de',
    C:'c',
    HN:function(n,a,b){return a+":"+b},
    DHN:function(n,a,b,c){return a +'th '+ b + ":" +c },
    MDHN:function(n,a,b,c,d){return b+ 'th ' + linb.getRes('date.MONTHS.'+a) + " " + c + ":" + d},
    HNS:function(n,a,b,c){return a+":"+b+":"+c},
    HNSMS:function(n,a,b,c,d){return a+":"+b+":"+c + ' ' +d},
    YM:function(n,a,b){return linb.getRes('date.MONTHS.'+b)+' '+a},
    YQ:function(n,a,b){return b+'Q ' + a},
    YMD:function(n,a,b,c){return b+'/'+c+'/'+a},
    YMD2:function(n,a,b,c){return linb.getRes('date.MONTHS.'+b)+' '+c+', '+a},
    MD:function(n,a,b){return linb.getRes('date.MONTHS.'+a) + " "+ b},
    YMDH:function(n,a,b,c,d){return c+'/'+b+'/'+a + ' ' +d+':00'},
    YMDHN:function(n,a,b,c,d,e){return b+'/'+c+'/'+a + ' ' +d+":"+e},
    YMDHNS:function(n,a,b,c,d,e,f){return b+'/'+c+'/'+a + ' ' +d+":"+e+":"+f},
    ALL:function(n,a,b,c,d,e,f,g){return b+'/'+c+'/'+a + ' ' +d+":"+e+":"+f +" " +g}
};
linb.Locale.en.color={
  LIST:{
    "FFFFFF":"White",
    "FFFFF0":"Ivory",
    "FFFFE0":"Light Yellow",
    "FFFF00":"Yellow",
    "FFFAFA":"Snow",
    "FFFAF0":"Floral White",
    "FFFACD":"Lemon Chiffon",
    "FFF8DC":"Cornislk",
    "FFF5EE":"Sea Shell",
    "FFF0F5":"Lavender Blush",
    "FFEFD5":"Papaya Whip",
    "FFEBCD":"Blanched Almond",
    "FFE4E1":"Misty Rose",
    "FFE4C4":"Bisque",
    "FFE4B5":"Moccasin",
    "FFDEAD":"Navajo White",
    "FFDAB9":"Peach Puff",
    "FFD700":"Gold",
    "FFC0CB":"Pink",
    "FFB6C1 ":"Light Pink",
    "FFA500":"Orange",
    "FFA07A":"Light Salmon",
    "FF8C00":"Dark Orange",
    "FF7F50":"Coral",
    "FF69B4":"Hot Pink",
    "FF6347":"Tomato",
    "FF4500":"Orange Red",
    "FF1493":"Deep Pink",
    "FF00FF":"Magenta",
    "FF00FF":"Fuchsia",
    "FF0000":"Red",
    "FDF5E6":"Old Lace",
    "FAFAD2":"Light Goldenrod Yellow",
    "FAF0E6":"Linen",
    "FAEBD7":"Antique White",
    "FA8072":"Salmon",
    "F8F8FF":"Ghost White",
    "F5FFFA":"Medium Spring Green",
    "F5F5F5":"White Smoke",
    "F5DEB3":"Wheat",
    "F4A460":"Sandy Brown",
    "F0FFFF":"Azure",
    "F0FFF0":"Honeydew",
    "F0F8FF":"Alice Blue",
    "F0E68C":"Khaki",
    "F08080":"Light Coral",
    "EEE8AA":"Pale Godenrod",
    "EE82EE":"Violet",
    "E9967A":"Dark Salmon",
    "E6E6FA":"Lavender",
    "E1FFFF":"Light Cyan",
    "DEB887":"Bruly Wood",
    "DDA0DD":"plum",
    "DCDCDC":"Gainsboro",
    "DC143C":"Crimson",
    "DB7093":"Pale Violet Red",
    "DAA520":"Gold Enrod",
    "DA70D6":"Orchid",
    "D8BFD8":"Thistle",
    "D3D3D3":"Light Grey",
    "D2B48C":"Tan",
    "D2691E":"Chocolate",
    "CD853F":"Peru",
    "CD5C5C":"Indian Red",
    "C71585":"Medium Violet Red",
    "C0C0C0":"Silver",
    "BDB76B":"Dark Khaki",
    "BC8F8F":"Rosy Brown",
    "BA55D3":"Medium Orchid",
    "B22222":"Fire Brick",
    "B0E0E6":"Pow Der Blue",
    "B0C4DE":"Light Steel Blue",
    "AFEEEE":"Pale Turquoise",
    "ADFF2F":"Green Yellow",
    "ADD8E6":"Light BLue",
    "A9A9A9":"Dark Gray",
    "A52A2A":"Brown",
    "A0522D":"Sienna",
    "9932CC":"Dark Orchid",
    "98FB98":"Pale Green",
    "9400D3":"Dark Voilet",
    "9370DB":"Medium Purple",
    "90EE90":"Light Green",
    "8FBC8F":"Dark Sea Green",
    "8B4513":"Saddle Brown",
    "8B008B":"Dark Magenta",
    "8B0000":"Dark Red",
    "8A2BE2":"Blue Violet",
    "87CEFA":"Light Sky Blue",
    "87CEEB":"Sky Blue",
    "808080":"Gray",
    "808000":"Olive",
    "800080":"Purple",
    "800000":"Maroon",
    "7FFFAA":"Auqamarin",
    "7FFF00":"Chartreuse",
    "7CFC00":"Lawn Green",
    "7B68EE":"Medium Slate Blue",
    "778899":"Light Slate Gray",
    "708090":"Slate Gray",
    "6B8E23":"Beige",
    "6A5ACD":"Slate Blue",
    "696969":"Dim Gray",
    "6495ED":"Cornflower Blue",
    "5F9EA0":"Cadet Blue",
    "556B2F":"Olive Drab",
    "4B0082":"Indigo",
    "48D1CC":"Medium Turquoise",
    "483D8B":"Dark Slate Blue",
    "4682B4":"Steel Blue",
    "4169E1":"Royal Blue",
    "40E0D0":"Turquoise",
    "3CB371":"Spring Green",
    "32CD32":"Lime Green",
    "2F4F4F":"Dark Slate Gray",
    "2E8B57":"Sea Green",
    "228B22":"Forest Green",
    "20B2AA":"Light Sea Green",
    "1E90FF":"Doder Blue",
    "191970":"Midnight Blue",
    "00FFFF":"Cyan",
    "00FFFF":"Aqua",
    "00FF7F":"Mint Cream",
    "00FF00":"Lime",
    "00FA9A":"Medium Aquamarine",
    "00CED1":"Dark Turquoise",
    "00BFFF":"Deep Sky Blue",
    "008B8B":"Dark Cyan",
    "008080":"Teal",
    "008000":"Green",
    "006400":"Dark Green",
    "0000FF":"Blue",
    "0000CD":"Medium Blue",
    "00008B":"Dark Blue",
    "000080":"Navy",
    "000000":"Black"
  }
};/* event
*  dependency: base _ ; Class ; linb ;
*
*
*/
Class('linb.Event',null,{
    Constructor:function(event,node,fordrag,tid){
        var self = linb.Event,
            dd=0,id,
            dragdrop=linb.DragDrop,
            src, type,  pre, obj;

        //get event object , and src of event
        if(!(event=event||window.event) || !(src=node))return false;
        //type
        type = event.type;
        //template id
        if(tid)src._tid=tid;

        //for correct mouse hover problems;
        if('mouseover'==type || 'mouseout'==type){
            dd=(dragdrop&&dragdrop._profile.isWorking)?1:2;
            //for dropable
            if(dd!=1 && fordrag)return self.$FALSE;
            //don't return flase, here, opera will stop the system event hander => cursor not change
            if(!self._handleMouseHover(event, src, self.getSrc(event), dd==1))
                return self.$FALSE;
            if(dd==1)
                pre=dragdrop&&dragdrop._dropElement;
        }

        //for tab focusHook
        if((obj=self._tabHookStack).length &&
            self._kb[type] &&
            (event.$key || event.keyCode || event.charCode)==9 &&
            false === self._handleTabHook(self.getSrc(event), obj=obj[obj.length-1]))
                return;

        id = tid || self.getId(src);
        //get profile from dom cache
        if(obj = self._getProfile(id)){
            //for setBlurTrigger
            if(type=='mousedown')
                _.tryF(linb.Dom._blurTrigger,[obj,event,src],src);
            //for resize
            if(type=="resize"){
                type='size';
                //for IE, always fire window onresize event after any innerHTML action
                if(linb.browser.ie && window===src){
                    var w=linb.browser.contentBox && document.documentElement.clientWidth || document.body.clientWidth,
                        h=linb.browser.contentBox && document.documentElement.clientHeight || document.body.clientHeight;
                    if(obj._w==w&&obj._h==h)
                        return;
                    obj._w=w;obj._h=h;
                }
            }

            var j, f, name, r=true, funs=[];
            //order by: before, on, after
            for(j=0; j<=2; ++j){
                //if in dd, get before Mouse.. only
                if(dd==1 && j!==0 && !event.$force)break;
                //if not in dd, get on/after Mouse.. only
                if(dd==2 && j===0)continue;
                //get event name from event type
                name = self._type[type+j] || ( self._type[type+j] = self._getEventName(type, self._eventtag[j]));
                /*
                event.$e : called by fireEvent
                event.$all : fire all events of the type: before/on/after
                event.$name : fire one group of event of the type.
                */
                if(!event.$e || event.$all || (name==event.$name))Array.prototype.push.apply(funs, obj._getEV(id, name, src));
            }

            /*call function by order
             widget before -> dom before -> widget on -> dom on -> widget after -> dom after
            */
            f=function(a){
                var i, v, k = arguments.callee.funs;
                for(i=0;v=k[i++];)
                    //if any fun return false, stop event bubble
                    if(false === v.call(src, obj, a||event, src))
                        return false;
                return true;
            };
            f.funs=funs;
            r = f();

            if(dragdrop){
                //shortcut for onDrag('mousemove')
                if(type=='drag')
                    dragdrop._onDrag=f;
                else if(type=='dragover')
                    dragdrop._onDragover=f;
            }

            if(dd==1){
                //From parent dropable node to child dropable node, fire parent node's mouseout manually
                if('mouseover'==type && dragdrop._dropElement==src && pre && pre!=src){
                    self({
                        type: 'mouseout',
                        target: pre,
                        $e:true,
                        $name:'beforeMouseout',
                        preventDefault:function(){this.returnValue=false},
                        stopPropagation:function(){this.cancelBubble=true}
                        },pre);
                    dragdrop.setDropElement(src);
                }
                
                //Out of dropable node, 'dragdrop._dropElement' will be set to null in beforeMouseover
                //set _preDropable flag, for parent node is dropable too
                if('mouseout'==type && !dragdrop._dropElement && pre && pre==src){
                    self._preDropable=id;
                    _.asyRun(function(){delete linb.Event._preDropable});
                }

                //if fire dd, prevent to fire parent dd
                //notice: this dont trigger cursor changing in opera
                if(src==dragdrop._dropElement)
                    r=false;
            }
            if(r===false)self.stopBubble(event);
            return r;
        }
    },
    Static:{
        $FALSE:linb.browser.opr?undefined:false,
        _type:{},
        _kb:{keydown:1,keypress:1,keyup:1},
        _reg:/([\.\w]+)(-[\.\w]+)?(:[\.\w]+:)([\.\w]*)/,
        $eventhandler:function(){return linb.Event(arguments[0],this)},
        $eventhandler2:function(){return linb.Event(arguments[0],this,1)},
        _eventtag:'before,on,after'.split(','),
        //collection
        _events : ("mouseover,mouseout,mousedown,mouseup,mousemove,click,dblclick," +
                "keydown,keypress,keyup,scroll,"+
                "blur,focus,"+
                "load,unload,"+
                "change,select,submit,error,"+

                //customized handlers:
                //dont use resize in IE
                "location,size," +
                //dragstart dragdrop dragout will not work in IE(using innerHTML)
                "dragbegin,drag,dragstop,dragleave,dragenter,dragover,drop")
                .split(','),
        //_dragMap:{'drag':1,'dragstop':1,'dragleave':1,'dragenter':1,'dragover':1,'drop':1},
        _getEventName:function(name,pos){
            var me=arguments.callee, map = me.map || (me.map={});
            return map[name+pos] || (name=name.charAt(0).toUpperCase()+name.substring(1))  &&
                (map[name+pos] = pos ?
                    (pos+name.charAt(0).toUpperCase()+name.substring(1)):
                    function(name){
                        var i,j,a=[];
                        for(i=0; j=linb.Event._eventtag[i]; i++)a[i]=j+name;
                        return a;
                    }(name)
                );
        },
        _getEventType:function(name){
            var me=arguments.callee, map = me.map || (me.map={});
            return map[name] || (map[name] = name.replace(/^(on|before|after)/,'').toLowerCase())
        },

        _getProfile:function(id){
            return id && linb.cache.dom[id.replace(this._reg,'$1$3')];
        },
        _handleTabHook:function(src, target){
            if(src===document)return true;
            var node=src,r;
            do{
                if(node==target[0])return true;
            }while(node && (node=node.parentNode) && node!==document && node!==window)

            r=_.tryF(target[1],[target[0]],src);
            return false;
        },
        _handleMouseHover:function(event,target,src,dd){
            if(target==document)return true;
            var node = (event.type=='mouseover'?event.fromElement:event.toElement)||event.relatedTarget;

            //When out of dropable node, if the parent node is dropable return true;
            if(dd && event.type=='mouseover' &&this._preDropable)
                try{
                    do{
                        if(node && node.id && node.id==this._preDropable){return true}
                    }while(node && (node=node.parentNode) && node!==document && node!==window)
                }catch(a){}

            //for firefox wearing anynomous div in input/textarea
            //related to 'div.anonymous-div' always return true
            if(linb.browser.gek)
                try{
                    do{if(node==target)return false;}while(node && (node=node.parentNode))
                }catch(a){
                    var pos=this.getPos(event),
                        node=linb([target]),
                        p=node.offset(),
                        s=node.cssSize(),
                        out=(pos.left<p.left||pos.left>p.left+s.width||pos.top<p.top||pos.top>p.top+s.height);
                    return event.type=='mouseover'?!out:out;
                }
            else
                do{if(node==target)return false;}while(node && (node=node.parentNode))
            return true;
        },

        _tabHookStack:[],
        pushTabOutTrigger:function(boundary, trigger){this._tabHookStack.push([boundary, trigger]);return this},
        popTabOutTrigger:function(flag){if(flag)this._tabHookStack=[];else this._tabHookStack.pop();return this},
        $EVENTHANDLER:"return linb.Event(arguments[0],this)",
        $EVENTHANDLER2:"return linb.Event(arguments[0],this,1)",
        getSrc:function(event){
            var a;
            return ((a=event.target||event.srcElement||null) && linb.browser.kde && a.nodeType == 3)?a.parentNode:a
        },
        getId:function(node){
            return window===node?"___window":document===node?"___document":node?node.id:'';
        },
        // only for mousedown and mouseup
        // return 1 : left button, else not left button
        getBtn:function(event){
	        return linb.browser.ie ?
	                event.button==4 ?
	                    'middle' :
	                        event.button==2 ?
	                            'right' :
	                                'left' :
	                event.which==2 ?
	                    'middle':
	                        event.which==3 ?
	                            'right':
	                                'left';
        },
        getPos:function(event){
            event = event || window.event;
            if(typeof event.pageX == 'number')
                return {left:event.pageX, top:event.pageY};
            else{
                var m = linb.browser.contentBox?document.documentElement:document.body;
                return {left:event.clientX + m.scrollLeft, top:event.clientY + m.scrollTop};
            }
        },
        /*return array(key, control, shift, alt)
        ['k','1','',''] : 'k' pressed, 'control' pressed, 'shift' and 'alt' not pressed
        */
        /*
        opear in window:
            ' = right (39)
            - = insert (45)
            . = del (46)
        */
        getKey:function(event){
            event=event||window.event;
            // use keyCode first for newer safari
            var res=[],t, k= event.$key || event.keyCode || event.charCode || 0;
            //from linb event
            if(typeof k == 'string')
                res[0]=k;
            else{
                var key= String.fromCharCode(k),
                    type=event.type;
                if(
                 //visible char
                 (type=='keypress' && k>=33 && k<=128)
                 //0-9, A-Z
                 ||((k>=48&&k<=57) || (k>=65&&k<=90))
                 )res[0]=key;
                else{
                    if(!(t=arguments.callee.map)){
                        t = arguments.callee.map ={};
                        var k,arr =
                        ("3,enter,8,backspace,9,tab,12,numlock,13,enter,19,pause,20,capslock," +
                        "27,esc,32, ,33,pageup,34,pagedown,35,end,36,home,37,left,38,up,39,right,40,down,44,printscreen," +
                        "45,insert,46,delete,50,down,52,left,54,right,56,up," +
                        "91,win,92,win,93,apps," +
                        "96,0,97,1,98,2,99,3,100,4,101,5,102,6,103,7,104,8,105,9," +
                        "106,*,107,+,109,-,110,.,111,/," +
                        "112,f1,113,f2,114,f3,115,f4,116,f5,117,f6,118,f7,119,f8,120,f9,121,f10,122,f11,123,f12," +
                        "144,numlock,145,scroll," +
                        "186,;,187,=,189,-,190,.,191,/,192,`,"+
                        "219,[,220,\\,221,],222,'," +
                        "224,meta,"+ //Apple Meta and Windows key
                        //safari
                        "63289,numlock,63276,pageup,63277,pagedown,63275,end,63273,home,63234,left,63232,up,63235,right,63233,down,63272,delete,63302,insert,63236,f1,63237,f2,63238,f3,63239,f4,63240,f5,63241,f6,63242,f7,63243,f8,63244,f9,63245,f10,63246,f11,63247,f12,63248,print"
                        ).split(',')
                        for(var i=1,l=arr.length; i<l; i=i+2)
                            t[arr[i-1]]=arr[i]
                        arr.length=0;
                        //add
                        t[188]=',';
                    }
                    res[0]= t[k] || key;
                }
            }

            //control
            if((event.modifiers)?(event.modifiers&Event.CONTROL_MASK):(event.ctrlKey||event.ctrlLeft||k==17||k==57391)){
                if(k==17||k==57391)
                    res[0]='';
                res.push('1');
            }else
                res.push('');

            //shift
            if((event.modifiers)?(event.modifiers&Event.SHIFT_MASK):(event.shiftKey||event.shiftLeft||k==16||k==57390)){
                if(k==16||k==57390)
                    res[0]='';
                res.push('1');
            }else
                res.push('');

            //alt
            if((event.modifiers)?false:(event.altKey||event.altLeft||k==18||k==57388)){
                if(k==18||k==57388)
                    res[0]='';
                res.push('1');
            }else
                res.push('');

            return res;
        },
        getEventPara:function(event){
            var pos=this.getPos(event), keys = this.getKey(event), h={
                pageX:pos.left,
                pageY:pos.top,
                keyCode:keys[0],
                ctrlKey:keys[1],
                shiftKey:keys[2],
                altKey:keys[3]
            };
            for(var i in event)if(i.charAt(0)=='$')h[i]=event[i];
            return h;
        },
        stopBubble:function(event){
            event=event||window.event;
            if(event.stopPropagation)event.stopPropagation();
            event.cancelBubble = true;
            this.stopDefault(event);
        },
        stopDefault:function(event){
            event=event||window.event;
            if(event.preventDefault)event.preventDefault();
            event.returnValue = false;
        },
        //key:control:shift:alt
        keyboardHook:function(key, ctrl, shift, alt, fun,args,scope){
            if(key){
                var p = linb.cache.hookKey, k = (key||'').toLowerCase() + ":"  + (ctrl?'1':'') + ":"  +(shift?'1':'')+ ":" + (alt?'1':'');
                if(typeof fun!='function')delete p[k];
                else p[k]=[fun,args,scope];
             }
            return this;
        }
    }
});Class('linb.Date',null,{
    Initialize:function(){
        var self=this;
        self._mapKeys(self.$TIMEUNIT);
        var a=self._key1,b=self._key2,u=self.$UNIT={};
        for(var i=0,l=a.length;i<l;i++)u[a[i]]=1;
        for(var i=0,l=b.length;i<l;i++)u[b[i]]=1;
        u.w=1;
    },
    Static:{
        _key1:'MILLISECOND,SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR,DECADE,CENTURY'.split(','),
        _key2:'ms,s,n,h,d,ww,m,q,y,de,c'.split(','),
        // Conversion factors
        $TIMEUNIT : {
            MILLISECOND : 1,
            SECOND      : 1000,           //SECONDS
            MINUTE      : 60000,          //MINUTES 60 * 1000
            HOUR        : 3600000,        //HOURS 60 * 60 * 1000
            DAY         : 86400000,       //DAYS 24 * 60 * 60 * 1000
            WEEK        : 604800000,      //WEEKS 7 * 24 * 60 * 60 * 1000
            MONTH       : 2592000000,     //MONTHS 30 * 24 * 60 * 60 * 1000  (approx = 1 month)
            QUARTER     : 7776000000,     //QUARTERS 90 * 24 * 60 * 60 * 1000  (approx = 3 months)
            YEAR        : 31557600000,    //YEARS 365 * 24 * 60 * 60 * 1000 (approx = 1 year)
            DECADE      : 315576000000,   //DECADES 10 * 365 * 24 * 60 * 60 * 1000 (approx = 1 decade)
            CENTURY     : 3155760000000   //CENTURIES 100 * 365 * 24 * 60 * 60 * 1000 (approx = 1 century)
        },
        $TEXTFORMAT:{
            utciso:function(d,f){f=linb.Date._fix; return d.getUTCFullYear() + '-' +f(d.getUTCMonth() + 1) + '-' +f(d.getUTCDate()) + 'T' +f(d.getUTCHours()) + ':' +f(d.getUTCMinutes()) + ':' +f(d.getUTCSeconds()) + 'Z'},
            iso:function(d,f){f=linb.Date._fix; return d.getFullYear() + '-' +f(d.getMonth() + 1) + '-' +f(d.getDate()) + 'T' +f(d.getHours()) + ':' +f(d.getMinutes()) + ':' +f(d.getSeconds())},
            ms:function(d){return linb.Date._fix(d.getMilliseconds(),3)+ linb.wrapRes('date.MS')},
            s:function(d){return linb.Date._fix(d.getSeconds())+ linb.wrapRes('date.S')},
            n:function(d){return linb.Date._fix(d.getMinutes())+ linb.wrapRes('date.N')},
            h :function(d){return linb.Date._fix(d.getHours())+ linb.wrapRes('date.H')},
            d:function(d){return d.getDate()+ linb.wrapRes('date.D')},
            w : function(d,firstDayOfWeek){return linb.wrapRes('date.WEEKS.'+(d.getDay() - firstDayOfWeek +7)%7 )},
            ww : function(d,firstDayOfWeek){return linb.Date.getWeek(d, firstDayOfWeek) + linb.wrapRes('date.W')},
            m:function(d){return (d.getMonth()+1) + linb.wrapRes('date.M')},
            q : function(d){return (parseInt((d.getMonth()+3)/3-1) + 1) + linb.wrapRes('date.Q')},
            y :function(d){return d.getFullYear() + linb.wrapRes('date.Y')},
            de:function(d){return parseInt(d.getFullYear()/10) + linb.wrapRes('date.DE')},
            c:function(d){return parseInt(d.getFullYear()/100) + linb.wrapRes('date.C')},

            hn:function(d){return linb.wrapRes('date.HN-'+d.getHours()+"-"+d.getMinutes())},
            dhn:function(d){return linb.wrapRes('date.DHN-'+d.getDate()+"-"+d.getHours()+"-"+d.getMinutes())},
            mdhn:function(d){return linb.wrapRes('date.MDHN-'+(d.getMonth()+1)+"-"+d.getDate()+"-"+d.getHours()+"-"+d.getMinutes())},
            hns:function(d){return linb.wrapRes('date.HNS-'+d.getHours()+"-"+d.getMinutes()+"-"+d.getSeconds())},
            hnsms:function(d){return linb.wrapRes('date.HNSMS-'+d.getHours()+"-"+d.getMinutes()+"-"+d.getSeconds()+"-"+d.getMilliseconds())},

            yq:function(d){return linb.wrapRes('date.YQ-'+d.getFullYear()+"-"+(parseInt((d.getMonth()+3)/3-1)+1))},

            ym :   function(d){return linb.wrapRes('date.YM-'+d.getFullYear()+"-"+(d.getMonth()+1))},
            md :  function(d){return linb.wrapRes('date.MD-'+(d.getMonth()+1)+"-"+d.getDate())},
            ymd :  function(d){return linb.wrapRes('date.YMD-'+d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate())},
            ymd2 :  function(d){return linb.wrapRes('date.YMD2-'+d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate())},
            ymdh:  function(d){return linb.wrapRes('date.YMDH-'+d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate()+"-"+d.getHours())},
            ymdhn: function(d){return linb.wrapRes('date.YMDHN-'+d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate()+"-"+d.getHours()+"-"+d.getMinutes())},
            ymdhns:function(d){return linb.wrapRes('date.YMDHNS-'+d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate()+"-"+d.getHours()+"-"+d.getMinutes()+"-"+d.getSeconds())},
            'all' :  function(d){return linb.wrapRes('date.ALL-'+d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate()+"-"+d.getHours()+"-"+d.getMinutes()+"-"+d.getSeconds()+"-"+d.getMilliseconds())}
        },
        $TIMEZONE:[{
            id:"Asia(East,North)",
            sub:[{
                    id:"Brunei",
                    v:"+0800"
                },{
                    id:"Burma",
                    v:"+0630"
                },{
                    id:"Cambodia",
                    v:"+0700"
                },{
                    id:"China",
                    v:"+0800"
                },{
                    id:"China(HK,Macau)",
                    v:"+0800"
                },{
                    id:"China(TaiWan)",
                    v:"+0800"
                },{
                    id:"China(Urumchi)",
                    v:"+0700"
                },{
                    id:"East Timor",
                    v:"+0800"
                },{
                    id:"Indonesia",
                    v:"+0700"
                },{
                    id:"Japan",
                    v:"+0900"
                },{
                    id:"Kazakhstan(Aqtau)",
                    v:"+0400"
                },{
                    id:"Kazakhstan(Aqtobe)",
                    v:"+0500"
                },{
                    id:"Kazakhstan(Astana)",
                    v:"+0600"
                },{
                    id:"Kirghizia",
                    v:"+0500"
                },{
                    id:"Korea",
                    v:"+0900"
                },{
                    id:"Laos",
                    v:"+0700"
                },{
                    id:"Malaysia",
                    v:"+0800"
                },{
                    id:"Mongolia",
                    v:"+0800",
                    tag:"03L03|09L03"
                },{
                    id:"Philippines",
                    v:"+0800"
                },{
                    id:"Russia(Anadyr)",
                    v:"+1300",
                    tag:"03L03|10L03"
                },{
                    id:"Russia(Kamchatka)",
                    v:"+1200",
                    tag:"03L03|10L03"
                },{
                    id:"Russia(Magadan)",
                    v:"+1100",
                    tag:"03L03|10L03"
                },{
                    id:"Russia(Vladivostok)",
                    v:"+1000",
                    tag:"03L03|10L03"
                },{
                    id:"Russia(Yakutsk)",
                    v:"+0900",
                    tag:"03L03|10L03"
                },{
                    id:"Singapore",
                    v:"+0800"
                },{
                    id:"Thailand",
                    v:"+0700"
                },{
                    id:"Vietnam",
                    v:"+0700"
                }]
            },{
                id:"Asia(South,West)",
                sub:[{
                    id:"Afghanistan",
                    v:"+0430"
                },{
                    id:"Arab Emirates",
                    v:"+0400"
                },{
                    id:"Bahrain",
                    v:"+0300"
                },{
                    id:"Bangladesh",
                    v:"+0600"
                },{
                    id:"Bhutan",
                    v:"+0600"
                },{
                    id:"Cyprus",
                    v:"+0200"
                },{
                    id:"Georgia",
                    v:"+0500"
                },{
                    id:"India",
                    v:"+0530"
                },{
                    id:"Iran",
                    v:"+0330",
                    tag:"04 13|10 13"
                },{
                    id:"Iraq",
                    v:"+0300",
                    tag:"04 13|10 13"
                },{
                    id:"Israel",
                    v:"+0200",
                    tag:"04F53|09F53"
                },{
                    id:"Jordan",
                    v:"+0200"
                },{
                    id:"Kuwait",
                    v:"+0300"
                },{
                    id:"Lebanon",
                    v:"+0200",
                    tag:"03L03|10L03"
                },{
                    id:"Maldives",
                    v:"+0500"
                },{
                    id:"Nepal",
                    v:"+0545"
                },{
                    id:"Oman",
                    v:"+0400"
                },{
                    id:"Pakistan",
                    v:"+0500"
                },{
                    id:"Palestine",
                    v:"+0200"
                },{
                    id:"Qatar",
                    v:"+0300"
                },{
                    id:"Saudi Arabia",
                    v:"+0300"
                },{
                    id:"Sri Lanka",
                    v:"+0600"
                },{
                    id:"Syria",
                    v:"+0200",
                    tag:"04 13|10 13"
                },{
                    id:"Tajikistan",
                    v:"+0500"
                },{
                    id:"Turkey",
                    v:"+0200"
                },{
                    id:"Turkmenistan",
                    v:"+0500"
                },{
                    id:"Uzbekistan",
                    v:"+0500"
                },{
                    id:"Yemen",
                    v:"+0300"
                }]
            },{
                id:"North Europe",
                sub:[{
                    id:"Denmark",
                    v:"+0100",
                    tag:"04F03|10L03"
                },{
                    id:"Faroe Is.(DK)",
                    v:"+0100"
                },{
                    id:"Finland",
                    v:"+0200",
                    tag:"03L01|10L01"
                },{
                    id:"Iceland",
                    v:"+0000"
                },{
                    id:"Jan Mayen(Norway)",
                    v:"-0100"
                },{
                    id:"Norwegian",
                    v:"+0100"
                },{
                    id:"Svalbard(NORWAY)",
                    v:"+0100"
                },{
                    id:"Sweden",
                    v:"+0100",
                    tag:"03L01|10L01"
                }]
            },{
                id:"Eastern Europe",
                sub:[{
                    id:"Armenia",
                    v:"+0400"
                },{
                    id:"Austria",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Azerbaijan",
                    v:"+0400"
                },{
                    id:"Belarus",
                    v:"+0200",
                    tag:"03L03|10L03"
                },{
                    id:"Czech",
                    v:"+0100"
                },{
                    id:"Estonia",
                    v:"+0200"
                },{
                    id:"Georgia",
                    v:"+0500"
                },{
                    id:"Germany",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Hungarian",
                    v:"+0100"
                },{
                    id:"Latvia",
                    v:"+0200"
                },{
                    id:"Liechtenstein",
                    v:"+0100"
                },{
                    id:"Lithuania",
                    v:"+0200"
                },{
                    id:"Moldova",
                    v:"+0200"
                },{
                    id:"Poland",
                    v:"+0100"
                },{
                    id:"Rumania",
                    v:"+0200"
                },{
                    id:"Russia(Moscow)",
                    v:"+0300",
                    tag:"03L03|10L03"
                },{
                    id:"Slovakia",
                    v:"+0100"
                },{
                    id:"Switzerland",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Ukraine",
                    v:"+0200"
                },{
                    id:"Ukraine(Simferopol)",
                    v:"+0300"
                }]
            },{
                id:"Western Europe",
                sub:[{
                    id:"Andorra",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Belgium",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Channel Is.(UK)",
                    v:"+0000",
                    tag:"03L01|10L01"
                },{
                    id:"France",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Gibraltar(UK)",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Ireland",
                    v:"+0000",
                    tag:"03L01|10L01"
                },{
                    id:"Isle of Man(UK)",
                    v:"+0000",
                    tag:"03L01|10L01"
                },{
                    id:"Luxembourg",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Monaco",
                    v:"+0100"
                },{
                    id:"Netherlands",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"United Kingdom",
                    v:"+0000",
                    tag:"03L01|10L01"
                }]
            },{
                id:"South Europe",
                sub:[{
                    id:"Albania",
                    v:"+0100"
                },{
                    id:"Bosnia",
                    v:"+0100"
                },{
                    id:"Bulgaria",
                    v:"+0200"
                },{
                    id:"Croatia",
                    v:"+0100"
                },{
                    id:"Greece",
                    v:"+0200",
                    tag:"03L01|10L01"
                },{
                    id:"Holy See",
                    v:"+0100"
                },{
                    id:"Italy",
                    v:"+0100",
                    tag:"03L01|10L01"
                },{
                    id:"Macedonia",
                    v:"+0100"
                },{
                    id:"Malta",
                    v:"+0100"
                },{
                    id:"Montenegro",
                    v:"+0100"
                },{
                    id:"Portugal",
                    v:"+0000",
                    tag:"03L01|10L01"
                },{
                    id:"San Marino",
                    v:"+0100"
                },{
                    id:"Serbia",
                    v:"+0100"
                },{
                    id:"Slovenia",
                    v:"+0100"
                },{
                    id:"Span",
                    v:"+0100",
                    tag:"03L01|10L01"
                }]
            },{
                id:"North America",
                sub:[{
                    id:"Canada(AST)",
                    v:"-0400",
                    tag:"04F02|10L02"
                },{
                    id:"Canada(CST)",
                    v:"-0600",
                    tag:"04F02|10L02"
                },{
                    id:"Canada(EST)",
                    v:"-0500",
                    tag:"04F02|10L02"
                },{
                    id:"Canada(MST)",
                    v:"-0700",
                    tag:"04F02|10L02"
                },{
                    id:"Canada(NST)",
                    v:"-0330",
                    tag:"04F02|10L02"
                },{
                    id:"Canada(PST)",
                    v:"-0800",
                    tag:"04F02|10L02"
                },{
                    id:"Greenland(DK)",
                    v:"-0300"
                },{
                    id:"US(Central)",
                    v:"-0600",
                    tag:"03S02|11F02"
                },{
                    id:"US(Eastern)",
                    v:"-0500",
                    tag:"03S02|11F02"
                },{
                    id:"US(Mountain)",
                    v:"-0700",
                    tag:"03S02|11F02"
                },{
                    id:"US(Pacific)",
                    v:"-0800",
                    tag:"03S02|11F02"
                },{
                    id:"US(Alaska)",
                    v:"-0900"
                },{
                    id:"US(Arizona)",
                    v:"-0700"
                }]
            },{
                id:"South America",
                sub:[{
                    id:"Anguilla(UK)",
                    v:"-0400"
                },{
                    id:"Antigua&amp;Barbuda",
                    v:"-0400"
                },{
                    id:"Antilles(NL)",
                    v:"-0400"
                },{
                    id:"Argentina",
                    v:"-0300"
                },{
                    id:"Aruba(NL)",
                    v:"-0400"
                },{
                    id:"Bahamas",
                    v:"-0500"
                },{
                    id:"Barbados",
                    v:"-0400"
                },{
                    id:"Belize",
                    v:"-0600"
                },{
                    id:"Bolivia",
                    v:"-0400"
                },{
                    id:"Brazil(AST)",
                    v:"-0500",
                    tag:"10F03|02L03"
                },{
                    id:"Brazil(EST)",
                    v:"-0300",
                    tag:"10F03|02L03"
                },{
                    id:"Brazil(FST)",
                    v:"-0200",
                    tag:"10F03|02L03"
                },{
                    id:"Brazil(WST)",
                    v:"-0400",
                    tag:"10F03|02L03"
                },{
                    id:"British Virgin Is.(UK)",
                    v:"-0400"
                },{
                    id:"Cayman Is.(UK)",
                    v:"-0500"
                },{
                    id:"Chilean",
                    v:"-0300",
                    tag:"10F03|03F03"
                },{
                    id:"Chilean(Hanga Roa)",
                    v:"-0500",
                    tag:"10F03|03F03"
                },{
                    id:"Colombia",
                    v:"-0500"
                },{
                    id:"Costa Rica",
                    v:"-0600"
                },{
                    id:"Cuba",
                    v:"-0500",
                    tag:"04 13|10L03"
                },{
                    id:"Dominican",
                    v:"-0400"
                },{
                    id:"Ecuador",
                    v:"-0500"
                },{
                    id:"El Salvador",
                    v:"-0600"
                },{
                    id:"Falklands",
                    v:"-0300",
                    tag:"09F03|04F03"
                },{
                    id:"Grenada",
                    v:"-0400"
                },{
                    id:"Guadeloupe(FR)",
                    v:"-0400"
                },{
                    id:"Guatemala",
                    v:"-0600"
                },{
                    id:"Guiana(FR)",
                    v:"-0300"
                },{
                    id:"Guyana",
                    v:"-0400"
                },{
                    id:"Haiti",
                    v:"-0500"
                },{
                    id:"Honduras",
                    v:"-0600"
                },{
                    id:"Jamaica",
                    v:"-0500"
                },{
                    id:"Martinique(FR)",
                    v:"-0400"
                },{
                    id:"Mexico(Mazatlan)",
                    v:"-0700"
                },{
                    id:"Mexico(Tijuana)",
                    v:"-0800"
                },{
                    id:"Mexico(Mexico)",
                    v:"-0600"
                },{
                    id:"Montserrat(UK)",
                    v:"-0400"
                },{
                    id:"Nicaragua",
                    v:"-0500"
                },{
                    id:"Panama",
                    v:"-0500"
                },{
                    id:"Paraguay",
                    v:"-0400",
                    tag:"10F03|02L03"
                },{
                    id:"Peru",
                    v:"-0500"
                },{
                    id:"Puerto Rico(US)",
                    v:"-0400"
                },{
                    id:"So. Georgia&amp;So. Sandwich Is.(UK)",
                    v:"-0200"
                },{
                    id:"St. Kitts&amp;Nevis",
                    v:"-0400"
                },{
                    id:"St. Lucia",
                    v:"-0400"
                },{
                    id:"St. Vincent&amp;Grenadines",
                    v:"-0400"
                },{
                    id:"Suriname",
                    v:"-0300"
                },{
                    id:"Trinidad&amp;Tobago",
                    v:"-0400"
                },{
                    id:"Turks&amp;Caicos Is.(UK)",
                    v:"-0500"
                },{
                    id:"Uruguay",
                    v:"-0300"
                },{
                    id:"Venezuela",
                    v:"-0400"
                },{
                    id:"Virgin Is.(US)",
                    v:"-0400"
                }]
            },{
                id:"Africa(North)",
                sub:[{
                    id:"Algeria",
                    v:"+0100"
                },{
                    id:"Egypt",
                    v:"+0200",
                    tag:"04L53|09L43"
                },{
                    id:"Libyan",
                    v:"+0200"
                },{
                    id:"Morocco",
                    v:"+0000"
                },{
                    id:"Sudan",
                    v:"+0200"
                },{
                    id:"Tunisia",
                    v:"+0100"
                }]
            },{
                id:"Africa(Western)",
                sub:[{
                    id:"Benin",
                    v:"+0100"
                },{
                    id:"Burkina Faso",
                    v:"+0000"
                },{
                    id:"Canary Is.(SP)",
                    v:"-0100"
                },{
                    id:"Cape Verde",
                    v:"-0100"
                },{
                    id:"Chad",
                    v:"+0100"
                },{
                    id:"Gambia",
                    v:"+0000"
                },{
                    id:"Ghana",
                    v:"+0000"
                },{
                    id:"Guinea",
                    v:"+0000"
                },{
                    id:"Guinea-Bissau",
                    v:"+0000"
                },{
                    id:"Ivory Coast",
                    v:"+0000"
                },{
                    id:"Liberia",
                    v:"+0000"
                },{
                    id:"Mali",
                    v:"+0000"
                },{
                    id:"Mauritania",
                    v:"+0000"
                },{
                    id:"Niger",
                    v:"+0100"
                },{
                    id:"Nigeria",
                    v:"+0100"
                },{
                    id:"Senegal",
                    v:"+0000"
                },{
                    id:"Sierra Leone",
                    v:"+0000"
                },{
                    id:"Togo",
                    v:"+0000"
                },{
                    id:"Western Sahara",
                    v:"+0000"
                }]
            },{
                id:"Africa(Central)",
                sub:[{
                    id:"Cameroon",
                    v:"+0100"
                },{
                    id:"Cen.African Rep.",
                    v:"+0100"
                },{
                    id:"Congo,Democratic",
                    v:"+0100"
                },{
                    id:"Congo,Republic",
                    v:"+0100"
                },{
                    id:"Equatorial Guinea",
                    v:"+0100"
                },{
                    id:"Gabon",
                    v:"+0100"
                },{
                    id:"Sao Tome&amp;Principe",
                    v:"+0000"
                }]
            },{
                id:"Africa(East)",
                sub:[{
                    id:"Burundi",
                    v:"+0200"
                },{
                    id:"Comoros",
                    v:"+0300"
                },{
                    id:"Djibouti",
                    v:"+0300"
                },{
                    id:"Eritrea",
                    v:"+0300"
                },{
                    id:"Ethiopia",
                    v:"+0300"
                },{
                    id:"Kenya",
                    v:"+0300"
                },{
                    id:"Madagascar",
                    v:"+0300"
                },{
                    id:"Malawi",
                    v:"+0200"
                },{
                    id:"Mauritius",
                    v:"+0400"
                },{
                    id:"Mayotte(FR)",
                    v:"+0300"
                },{
                    id:"Mozambique",
                    v:"+0200"
                },{
                    id:"Reunion(FR)",
                    v:"+0400"
                },{
                    id:"Rwanda",
                    v:"+0200"
                },{
                    id:"Seychelles",
                    v:"+0300"
                },{
                    id:"Somalia",
                    v:"+0300"
                },{
                    id:"Tanzania",
                    v:"+0300"
                },{
                    id:"Uganda",
                    v:"+0300"
                }]
            },{
                id:"Africa(South)",
                sub:[{
                    id:"Angola",
                    v:"+0100"
                },{
                    id:"Botswana",
                    v:"+0200"
                },{
                    id:"Lesotho",
                    v:"+0200"
                },{
                    id:"Namibia",
                    v:"+0200",
                    tag:"09F03|04F03"
                },{
                    id:"Saint Helena(UK)",
                    v:"-0100"
                },{
                    id:"South Africa",
                    v:"+0200"
                },{
                    id:"Swaziland",
                    v:"+0200"
                },{
                    id:"Zambia",
                    v:"+0200"
                },{
                    id:"Zimbabwe",
                    v:"+0200"
                }]
            },{
                id:"Oceania",
                sub:[{
                    id:"American Samoa(US)",
                    v:"-1100"
                },{
                    id:"Australia(Adelaide)",
                    v:"+0930",
                    sub:"10L03|03L03"
                },{
                    id:"Australia(Brisbane)",
                    v:"+1000"
                },{
                    id:"Australia(Darwin)",
                    v:"+0930"
                },{
                    id:"Australia(Hobart)",
                    v:"+1000",
                    sub:"10L03|03L03"
                },{
                    id:"Australia(Perth)",
                    v:"+0800"
                },{
                    id:"Australia(Sydney)",
                    v:"+1000",
                    sub:"10L03|03L03"
                },{
                    id:"Cook Islands(NZ)",
                    v:"-1000"
                },{
                    id:"Eniwetok",
                    v:"-1200"
                },{
                    id:"Fiji",
                    v:"+1200",
                    sub:"11F03|02L03"
                },{
                    id:"Guam",
                    v:"+1000"
                },{
                    id:"Hawaii(US)",
                    v:"-1000"
                },{
                    id:"Kiribati",
                    v:"+1100"
                },{
                    id:"Marshall Is.",
                    v:"+1200"
                },{
                    id:"Micronesia",
                    v:"+1000"
                },{
                    id:"Midway Is.(US)",
                    v:"-1100"
                },{
                    id:"Nauru Rep.",
                    v:"+1200"
                },{
                    id:"New Calednia(FR)",
                    v:"+1100"
                },{
                    id:"New Zealand",
                    v:"+1200",
                    sub:"10F03|04F63"
                },{
                    id:"New Zealand(CHADT)",
                    v:"+1245",
                    sub:"10F03|04F63"
                },{
                    id:"Niue(NZ)",
                    v:"-1100"
                },{
                    id:"Nor. Mariana Is.",
                    v:"+1000"
                },{
                    id:"Palau",
                    v:"+0900"
                },{
                    id:"Papua New Guinea",
                    v:"+1000"
                },{
                    id:"Pitcairn Is.(UK)",
                    v:"-0830"
                },{
                    id:"Polynesia(FR)",
                    v:"-1000"
                },{
                    id:"Solomon Is.",
                    v:"+1100"
                },{
                    id:"Tahiti",
                    v:"-1000"
                },{
                    id:"Tokelau(NZ)",
                    v:"-1100"
                },{
                    id:"Tonga",
                    v:"+1300",
                    tag:"10F63|04F63"
                },{
                    id:"Tuvalu",
                    v:"+1200"
                },{
                    id:"Vanuatu",
                    v:"+1100"
                },{
                    id:"Western Samoa",
                    v:"-1100"
                },{
                    id:"Data Line",
                    v:"-1200"
                }]
            }
        ],
        //map like: MILLISECOND <=> ms
        _mapKeys:function(obj){
            var self=this, t=self._key2, m=self._key1;
            for(var i=0,l=m.length;i<l;i++)
                obj[t[i]]=obj[m[i]];
        },
        //get valid datepart
        _validUnit:function(datepart){
            return this.$UNIT[datepart]?datepart:'d';
        },
        _isDate:function(target)  {return !!target && target.constructor == Date},
        _date:function(value,df){return this._isDate(value)?value:this._isDate(df)?df:new Date},
        _isNumb:function(target)  {return typeof target == 'number' && isFinite(target)},
        _numb:function(value,df){return this._isNumb(value)?value:this._isNumb(df)?df:0},
        //time Zone like: -8
        _timeZone:-((new Date).getTimezoneOffset()/60),

        /*get specific date datepart
        *
        */
        get:function(date, datepart, firstDayOfWeek){
            var self=this;
            date = self._date(date);
            datepart = self._validUnit(datepart);
            firstDayOfWeek = self._numb(firstDayOfWeek);

            var map = arguments.callee.map || ( arguments.callee.map = {
                    ms:function(d){return d.getMilliseconds()},
                    s:function(d){return d.getSeconds()},
                    n:function(d){return d.getMinutes()},
                    h :function(d){return d.getHours()},
                    d:function(d){return d.getDate()},
                    ww:function(d,fd){return linb.Date.getWeek(d, fd)},
                    w :function(d,fd){return (7+d.getDay()-fd)%7},
                    m:function(d){return d.getMonth()},
                    q:function(d){return parseInt((d.getMonth()+3)/3-1)},
                    y :function(d){return d.getFullYear()},
                    de:function(d){return parseInt(d.getFullYear()/10)},
                    c:function(d){return parseInt(d.getFullYear()/100)}
                });
            return map[datepart](date,firstDayOfWeek);
        },
        /*
        * _fix(1,3,'0') => '100'
        */
        _fix:function(str,len,chr){
            len=len||2;
            chr=chr||'0';
            str+="";
            if(str.length<len)
                for(var i=str.length;i<len;i++)
                    str=chr+str;
            return str;
        },
        /*add specific datepart to date
        *
        */
        add: function(date, datepart, count ){
            var self=this,
                tu=self.$TIMEUNIT,
                map,
                date2;
            date = self._date(date);
            datepart = self._validUnit(datepart);


            if(!(map=arguments.callee.map)){
                map=arguments.callee.map = {
                    MILLISECOND:function(date,count){date.setTime(date.getTime() + count*tu.ms)},
                    SECOND:function(date,count){date.setTime(date.getTime() + count*tu.s)},
                    MINUTE:function(date,count){date.setTime(date.getTime() + count*tu.n)},
                    HOUR:function(date,count){date.setTime(date.getTime() + count*tu.h)},
                    DAY:function(date,count){date.setTime(date.getTime() + count*tu.d)},
                    WEEK:function(date,count){date.setTime(date.getTime() + count*tu.ww)},
                    MONTH:function(date,count){
                        var a=date.getDate(),b;
                        count = date.getMonth() + count;
                        this.YEAR(date, Math.floor(count/12));
                        date.setMonth((count%12+12)%12);
                        if((b=date.getDate())!=a)
                            this.DAY(date, -b)
                    },
                    QUARTER:function(date,count){this.MONTH(date,count*3)},
                    YEAR:function(date,count){
                        var a=date.getDate(),b;
                        date.setFullYear(date.getFullYear() + count)
                        if((b=date.getDate())!=a)
                            this.DAY(date, -b)
                    },
                    DECADE:function(date,count){this.YEAR(date,10*count)},
                    CENTURY:function(date,count){this.YEAR(date,100*count)}
                };
                self._mapKeys(map);
            }
            map[datepart](date2=new Date(date), count);
            return date2;
        },
        /*get specific datepart diff between startdate and date2
        *
        */
        diff:function(startdate, enddate, datepart, firstDayOfWeek) {
            var self=this;
            startdate = self._date(startdate);
            enddate = self._date(enddate);
            datepart = self._validUnit(datepart);
            firstDayOfWeek = self._numb(firstDayOfWeek);

            var tu=self.$TIMEUNIT,
                map;

            if(!(map=arguments.callee.map)){
                map = arguments.callee.map = {
                    MILLISECOND:function(startdate,enddate){return enddate.getTime()-startdate.getTime()},
                    SECOND:function(startdate,enddate){
                        var startdate = self.getTimSpanStart(startdate,'s'),
                            enddate = self.getTimSpanStart(enddate,'s'),
                            t=enddate.getTime()-startdate.getTime();
                        return t/tu.s;
                    },
                    MINUTE:function(startdate,enddate){
                        var startdate = self.getTimSpanStart(startdate,'n'),
                            enddate = self.getTimSpanStart(enddate,'n'),
                            t=enddate.getTime()-startdate.getTime();
                        return t/tu.n;
                    },
                    HOUR:function(startdate,enddate){
                        var startdate = self.getTimSpanStart(startdate,'h'),
                            enddate = self.getTimSpanStart(enddate,'h'),
                            t=enddate.getTime()-startdate.getTime();
                        return t/tu.h;
                    },
                    DAY:function(startdate,enddate){
                        var startdate = self.getTimSpanStart(startdate,'d',1),
                            enddate = self.getTimSpanStart(enddate,'d',1),
                            t=enddate.getTime()-startdate.getTime();
                        return t/tu.d;
                    },
                    WEEK:function(startdate,enddate,firstDayOfWeek){
                        var startdate = self.getTimSpanStart(startdate,'ww',1,firstDayOfWeek),
                            enddate = self.getTimSpanStart(enddate,'ww',1,firstDayOfWeek),
                            t=enddate.getTime()-startdate.getTime();
                        return t/tu.ww;
                    },
                    MONTH:function(startdate,enddate){return (enddate.getFullYear()-startdate.getFullYear())*12 + (enddate.getMonth()-startdate.getMonth())},
                    QUARTER:function(startdate,enddate){return (enddate.getFullYear()-startdate.getFullYear())*4 + parseInt((enddate.getMonth()-startdate.getMonth())/3)},
                    YEAR:function(startdate,enddate){return parseInt((enddate.getFullYear()-startdate.getFullYear()))},
                    DECADE:function(startdate,enddate){return parseInt((enddate.getFullYear()-startdate.getFullYear())/10)},
                    CENTURY:function(startdate,enddate){return parseInt((enddate.getFullYear()-startdate.getFullYear())/100)}
                };
                self._mapKeys(map);
            }
            return map[datepart](new Date(startdate),new Date(enddate),firstDayOfWeek);
        },
        /*get the first datepart begin of certain datepart
        *
        */
        getTimSpanStart: function(date, datepart, count, firstDayOfWeek) {
            var self=this,
                tu=self.$TIMEUNIT,
                map,date2;
            date = self._date(date);
            datepart = self._validUnit(datepart);
            firstDayOfWeek = self._numb(firstDayOfWeek);
            count=self._numb(count,1);
            if(!(map=arguments.callee.map)){
                var clearInDay = function(d) {
                        d.setMilliseconds(0);
                        d.setSeconds(0);
                        d.setMinutes(0);
                        d.setHours(0);
                    },
                    clearInYear = function(d) {
                        clearInDay(d);
                        d.setDate(1);
                        d.setMonth(0);
                    };

                map = arguments.callee.map = {
                    MILLISECOND:function(date,count){
                        var x = date.getMilliseconds();
                        date.setMilliseconds(x - (x % count));
                    },
                    SECOND:function(date,count){
                        date.setMilliseconds(0);
                        var x = date.getSeconds();
                        date.setSeconds(x - (x % count));
                    },
                    MINUTE:function(date,count){
                        date.setMilliseconds(0);
                        date.setSeconds(0);
                        var x = date.getMinutes();
                        date.setTime(date.getTime() - (x % count) * tu.n);
                    },
                    HOUR:function(date,count){
                        date.setMilliseconds(0);
                        date.setSeconds(0);
                        date.setMinutes(0);

                        var x = date.getHours();
                        date.setHours(x - (x % count));
                    },
                    DAY:function(date,count){
                        clearInDay(date);
                        var x=date.getDate();
                        date.setDate(x - (x % count));
                    },
                    WEEK:function(date,count,firstDayOfWeek){
                        clearInDay(date);

                        var d = (date.getDay() + 7 - firstDayOfWeek) % 7,date2,x, a=new Date();
                        date.setTime(date.getTime() - d * tu.d);
                        clearInYear(a);
                        a.setFullYear(date.getFullYear());
                        date2 = (a.getDay() + 7 - firstDayOfWeek) % 7;
                        a.setTime(a.getTime() - date2 * tu.d);

                        x= (date.getTime()-a.getTime())/tu.d/7;

                        date.setTime(date.getTime() - (x % count) * tu.ww);
                    },
                    MONTH:function(date,count){
                        clearInDay(date);
                        date.setDate(1);
                        var x = date.getMonth();
                        date.setMonth(x - (x % count));
                    },
                    QUARTER:function(date,count){
                        count=self._numb(count,1);
                        return this.MONTH(date, count*3);
                    },
                    YEAR:function(date,count){
                        clearInYear(date);
                        var x = date.getFullYear();
                        date.setFullYear(x - (x % count));
                    },
                    DECADE:function(date,count){
                        clearInYear(date);
                        date.setFullYear(Math.floor(date.getFullYear() / 10) * 10);
                    },
                    CENTURY:function(date,count){
                        clearInYear(date);
                        date.setFullYear(Math.floor(date.getFullYear() / 100) * 100);
                    }
                };
                self._mapKeys(map);

            }
            map[datepart](date2=new Date(date),count, firstDayOfWeek);
            return date2;
        },
        /*get the last datepart begin of certain datepart
        *
        */
        getTimSpanEnd : function(date, datepart, count,firstDayOfWeek) {
            var self=this;

            date = self._date(date);
            datepart = self._validUnit(datepart);
            firstDayOfWeek = self._numb(firstDayOfWeek);

            count=self._numb(count,1);

            var originalTime = date.getTime(),
                date2 = self.getTimSpanStart(date, datepart, count, firstDayOfWeek);
            if (date2.getTime() < originalTime)
                date2=self.add(date2, datepart, count);
            return date2;
        },
        /*fake a date for a certain timezone (based on the current timezone of "Date object")
        * You have to offset back it, if you expect a total real date:
        *   var localDate = new Date, timezone9Date=linb.Date.offsetTimeZone(localDate, 9);
        *   localDate.toString() == linb.Date.offsetTimeZone(timezone9Date, -9);
        */
        offsetTimeZone:function(date, timeZone, back){
            var self=this;
            date=self._date(date);
            return new Date(date.getTime() + (back?-1:1)*(timeZone - self._timeZone)*self.$TIMEUNIT.h);
        },

        /*get week
        *
        */
        getWeek:function(date, firstDayOfWeek){
            var self=this, date2, y;
            date=self._date(date);
            firstDayOfWeek = self._numb(firstDayOfWeek),
            y=date.getFullYear();

            date = self.add(self.getTimSpanStart(date, 'ww', 1, firstDayOfWeek),'d',6);

            if(date.getFullYear()!=y)return 1;

            date2 = self.getTimSpanStart(date, 'y', 1);
            date2 = self.add(self.getTimSpanStart(date2, 'ww', 1, firstDayOfWeek),'d',6);

            return self.diff(date2, date, 'ww')+1;
        },
        parse:function(str){
            str+="";
            var self=this,utc,
                me=arguments.callee,
                dp=me.dp||(me.dp={
                  FullYear: 2,
                  Month: 4,
                  Date: 6,
                  Hours: 8,
                  Minutes: 10,
                  Seconds: 12,
                  Milliseconds: 14
                }),
                match = str.match(me.iso||(me.iso=/^((-\d+|\d{4,})(-(\d{2})(-(\d{2}))?)?)?T((\d{2})(:(\d{2})(:(\d{2})(\.(\d{1,3})(\d)?\d*)?)?)?)?(([+-])(\d{2})(:(\d{2}))?|Z)?$/)),
                date = new Date(0)
                ;
            if(match){
                //month
                if(match[4])match[4]--;
                //ms to 3 digits
                if (match[15]>=5)match[14]++;
                utc = match[16]||match[18]?"UTC":"";
                for (var i in dp) {
                    var v = match[dp[i]];
                    if(!v)continue;
                    date["set" + utc + i](v);
                    if (date["get" + utc + i]() != match[dp[i]])
                        return null;
                }
                if(match[18]){
                    var h = Number(match[17] + match[18]),
                        m = Number(match[17] + (match[20] || 0));
                    date.setUTCMinutes(date.getUTCMinutes() + (h * 60) + m);
                }
                return date;
            }else{
                var r=Date.parse(str);
                return r?date.setTime(r) && date:null;
            }
        },
        getText:function(date, datepart, firstDayOfWeek){
            var self=this;
            date = self._date(date);
            firstDayOfWeek = self._numb(firstDayOfWeek);
            datepart=datepart||'';
            return self.$TEXTFORMAT[datepart](date, firstDayOfWeek);
        }
    }
});/* css
*  dependency: base _ ; Class ; linb ;
*/
Class("linb.CSS", null,{
    Static:{
        _r:linb.browser.ie?'rules':'cssRules',
        _baseid:'linb:css:base',
        _firstid:'linb:css:first',
        _lastid:'linb:css:last',
        _createCss:function(id, last){
            var ns=this,
                head=this._getHead(),
                fid=ns._firstid,
                lid=ns._lastid,
                fc,
                c;
            fc=document.createElement('style');
            fc.type="text/css";
            fc.id=id;
            if(!last){
                c= document.getElementById(fid) || head.firstChild;
                while((c=c.nextSibling) && !/^(script|link|style)$/i.test(''+c.tagName));
                if(c)
                    head.insertBefore(fc, c);
                else{
                    if(c= document.getElementById(lid))
                        head.insertBefore(fc, c);
                    else
                        head.appendChild(fc);
                }
            }else
                head.appendChild(fc);
            return fc;
        },
        _getCss:function(id, last){
            return document.getElementById(id) || this._createCss(id, last);
        },
        _getBase:function(){
            return this._getCss(this._baseid);
        },
        _getFirst:function(){
            return this._getCss(this._firstid);
        },
        _getLast:function(){
            return this._getCss(this._lastid, true);
        },
        _getHead:function(){
            return this._head || (this._head=document.getElementsByTagName("head")[0]||document.documentElement);
        },
        _check:function(){
            if(!linb.browser.ie)return;
            var count=0;
            for(var head = this._getHead(),i=0,t=head.childNodes,l;l=t[i++];)
                if(l.type=="text/css" )
                    count++
            return count>20;
        },
        get:function(property, value){
            for(var head = this._getHead(),i=0,t=head.childNodes,l;l=t[i++];)
                if(l.type=="text/css" && property in l && l[property]==value)
                    return l;
            return false;
        },
        //if backOf==true, add to head last node
        //else add to the before position of the base styleSheet
        addStyleSheet:function(txt, id, backOf ){
            var e, ns=this, head = ns._getHead(),add=function(txt,id,backOf){
                var e = document.createElement('style');
                e.type="text/css";
                if(id)e.id=id;
                //for ie
                if(linb.browser.ie)
                    e.styleSheet.cssText = txt||'';
                else
                    try{e.appendChild(document.createTextNode(txt||''))}catch(p){e.styleSheet.cssText = txt||''}
                head.insertBefore(e, backOf  ?ns._getLast():ns._getBase());
                e.disabled=true;
                e.disabled=false;
                return e;
            },merge=function(txt,backOf){
                var e=backOf ?ns._getLast():ns._getBase();
                e.styleSheet.cssText +=txt;
                return e;
            };
            if(id && (id=id.replace(/[^\w\-\_\.\:]/g,'_')) && (e=ns.get('id',id)))
                return e;

            if(ns._check()){
                return merge(txt, backOf);
            }else
                return add(txt,id,backOf);
        },
        //if front==true, add to the before position of the base styleSheet
        //else add to the last postion
        includeLink:function(href, id, front, attr){
            var e, ns=this, head = ns._getHead();
            if(href && (e=ns.get('href',href))){}else{
                e = document.createElement('link');
                e.type = 'text/css';
                e.rel = 'stylesheet';
                e.href = href;
                if(id)
                    e.id=id;
                e.media = 'all';
                _.each(attr,function(o,i){
                    e.setAttribute(i,o);
                });
            }
            head.insertBefore(e, front?ns._getBase():ns._getLast());
            e.disabled=true;
            e.disabled=false;
            return e;
        },
        remove:function(property,value){
            var head = this._getHead();
            if(value=this.get(property,value)){
                value.disabled=true;
                head.removeChild(value);
            }
        },
        replaceLink:function(href, property, oValue, nValue){
            var ns=this,
                head=ns._getHead(),
                attr={},e,v;
            attr[property]=nValue;
            e=ns.includeLink(href,null,false,attr);
            if(v=ns.get(property,oValue))
                head.replaceChild(e,v);
            e.disabled=true;
            e.disabled=false;
        },
        _build:function(selector, value, flag){
            var t='';
            _.each(value,function(o,i){
                t += i.replace(/([A-Z])/g,"-$1").toLowerCase() + ":" + o +";";
            });
            return flag?t:selector+"{" + t + "}";
        },
        //selector: single css exp without ','; not allow '.a, .b{}'
        //  for *** IE *** allow single css exp only
        setStyleRules:function(selector, value, force){
            var ns=this,
                add=true,
                ds=document.styleSheets,
                target, target2, selectorText, bak, h, e, t, _t;
            selector = _.str.trim(selector.replace(/\s+/g,' '));
            if(!(value&&force)){
                bak=selector.toLowerCase();
                _.arr.each(_.toArr(ds),function(o){
                    try{o[ns._r]}catch(e){return}
                    _.arr.each(_.toArr(o[ns._r]),function(v,i){
                        if(!v.selectorText)return;
                        selectorText =  v.selectorText.replace(/\.(\w+)\[CLASS~="\1"\]/g,'.$1')
                                         .replace(/\[ID"([^"]+)"\]/g,'#$1')
                                         .replace(/\*([.#])/g,'$1')
                                         .replace(/\s+/g,' ')
                                         .replace(/\*\|/g,'')
                                         .replace(/(\s*,\s*)/g,',').toLowerCase();
                        /*Notice: in IE, no ',' in any selectorTExt*/
                        _t=_.toArr(selectorText);
                        //null=>remove
                        if(!value){
                            add=false;
                            if(_.arr.indexOf(_t,bak)!=-1 && _t.length>1){
                                _t=_.arr.removeFrom(_t,_.arr.indexOf(_t,bak)).join(',');
                                t=v.cssText.slice(v.cssText.indexOf("{")+1,v.cssText.lastIndexOf("}"));
                                if(o.insertRule)
                                    o.insertRule(_t+"{" + t + "}", o[ns._r].length);
                                else if(o.addRule )
                                    o.addRule(_t, t);
                                if(o.deleteRule)
                                    o.deleteRule(i);
                                else
                                    o.removeRule(i);
                                o.disabled=true;
                                o.disabled=false;
                            }else if(selectorText == bak){
                                if(o.deleteRule)
                                    o.deleteRule(i);
                                else
                                    o.removeRule(i);
                                o.disabled=true;
                                o.disabled=false;
                            }
                        //modify the last one
                        }else{
                            //for single css exp, (all single css exp in IE)
                            if(selectorText==bak){target=v;return false}
                            //for multi css exps, not in IE
                            if(_.arr.indexOf(_t,bak)!=-1){target2=v;return false}
                        }
                    },null,true);
                    if(target){
                        add=false;
                        try{
                            _.each(value,function(o,i){
                                i=i.replace(/(-[a-z])/gi, function(m,a){return a.charAt(1).toUpperCase()});
                                target.style[i]= typeof o=='function'?o(target.style[i]):o;
                            })
                        }catch(e){}
                        o.disabled=true;
                        o.disabled=false;
                        return false;
                    //not in IE
                    }else if(target2){
                        add=false;
                        o.insertRule(ns._build(selector,value), o[ns._r].length);
                        o.disabled=true;
                        o.disabled=false;
                        return false;
                    }
                },null,true);
            }
            //need to add
            if(force || add)
                ns._addRules(selector,value);
            return ns;
        },
        _addRules:function(selector,value){
            var ns=this,
                target=ns._getLast(),
                changed=target.sheet || target.styleSheet;
            if(changed.insertRule)
                changed.insertRule(ns._build(selector,value), changed[ns._r].length);
            else if(changed.addRule )
                changed.addRule(selector, ns._build(selector,value,true));
            target.disabled=true;
            target.disabled=false;
            return ns;
        }
    },
    Initialize:function(){
        var b=linb.browser;
        this.addStyleSheet(""+
            "html{color:#000;background:#FFF;}"+
            "body{cursor:default;font:13px/1.231 arial,helvetica,clean,sans-serif;}"+
            (linb.browser.ie?"body{font-size:small;font:x-small;}":"")+
            "body *{line-height:1.22em;}"+
            "body,div,dl,dt,dd,ul,ol,li,h1,h2,h3,h4,h5,h6,pre,code,form,fieldset,legend,input,textarea,p,blockquote,th,td{margin:0;padding:0;}"+
            "table{border-collapse:collapse;border-spacing:0;empty-cells:show;font-size:inherit;font:100%;}"+
            "fieldset,img{border:0;}"+
            "address,caption,cite,code,dfn,em,strong,th,var{font-style:normal;font-weight:normal;}"+
            "ol,ul,li{list-style:none;}"+
            "caption,th{text-align:left;}"+
            "h1,h2,h3,h4,h5,h6{font-size:100%;font-weight:normal;}"+
            "q:before,q:after{content:'';}"+
            "abbr,acronym {border:0;font-variant:normal;}"+
            "sup {vertical-align:text-top;}"+
            "sub {vertical-align:text-bottom;}"+
            "input,textarea,select{font-family:inherit;font-size:inherit;font-weight:inherit;}"+
            (b.ie?"input,textarea,select{font-size:100%;}":"")+
            "legend{color:#000;}"+
            "del,ins{text-decoration:none;}"+
            "pre,code,kbd,samp,tt{font-family:monospace;"+(b.ie?"font-size:108%;":"")+"line-height:100%;}"+
            "select,input,button,textarea{font:99% arial,helvetica,clean,sans-serif;border-width:1px;}"+

            "a{text-decoration:none;"+(b.gek?"-moz-user-select:none;":"")+"}"+
            "a:hover{color:red}"+
            (b.gek?"a:focus{-moz-outline-offset:-1px !important}":"")+
            "div{font-size:12px;}"+
            "span{"+
            (b.gek?"display:-moz-inline-block;display:-moz-inline-box;display:inline-block;":
                b.ie6?"display:inline-box;display:inline;":"display:inline-block;")+
            (b.ie?"zoom:1;":"")+
            (b.gek3?"":"vertical-align:middle;")+
            "}"+
            "h1{font-size:138.5%;}"+
            "h2{font-size:123.1%;}"+
            "h3{font-size:108%;}"+
            "h1,h2,h3{margin:1em 0;}"+
            "h1,h2,h3,h4,h5,h6,strong {font-weight:bold;}"+
            "em{font-style:italic;}"
        , 'linb.CSS');
    }   
});Class('linb.absProfile',null,{
    Constructor:function(){
        if(!this.$id)this.$id=linb.absProfile.$id.next();
    },
    Instance:{
        getId:function(){
            return this.$id;
        },
        link:function(obj,id,target){
            var self=this,
                //avoid Number;
                uid='$'+self.$id;

            target = target||self;
            if(obj[uid])self.unLink(id);

            //double link
            obj[uid]=target;
            if(obj instanceof Array)obj.push(target);

            //antilink track
            self._links[id]=obj;
            return self;
        },
        unLink:function(id){
            var self=this,
                o,
                //avoid Number;
                uid='$'+self.$id;
            if(!self._links)return;
            if(!(o=self._links[id]))return;

            //remove from target
            if(o instanceof Array)_.arr.removeValue(o,o[uid]);
            delete o[uid];

            //remove from self
            delete self._links[id];

            return self;
        },
        unLinkAll:function(){
            var self=this,
                id='$'+self.$id,
                l=self._links,
                o,i;
            for(i in l){
                o=l[i];
                if(o instanceof Array)_.arr.removeValue(o,o[id]);
                delete o[id];
            }
            self._links={};
            return self;
        }
    },
    Static:{
        $id:new _.id,
        $abstract:true
    }
});
Class('linb.DomProfile', 'linb.absProfile', {
    Constructor:function(domId, domNode){
        arguments.callee.upper.call(this);
        var self=this;
        self.domNode=domNode;
        linb.cache.dom[self.domId=domId]=self;
        self.nodeVars={};
    },
    Instance:{
        __gc:function(){
            var self=this,t;
            if(self.nodeVars&&(t=self.domNode))
                _.each(self.nodeVars,function(o,i){
                    t[i]=null;
                });
            delete linb.cache.dom[self.domId];
            _.breakO(self);
        },
        _getEV:function(id, name){
            var funs=[],t=linb.cache.dom[id];
            if(t&&(t=t.events)&&(t=t[name]))
                for(var i=0,l=t.length;i<l;i++)
                    if(typeof t[t[i]]=='function')
                        funs[funs.length]=t[t[i]];
            return funs;
        }
    },
    Static:{
        get:function(id){
            return linb.cache.dom[id];
        },
        $abstract:true
    }
});

//linb.absBox
Class('linb.absBox',null, {
    Constructor:function(){
        this._nodes=[];
    },
    Before:function(key){
        var t=linb.absBox;
        if(t)(t=t.$type)[key.replace('linb.','')]=t[key]=key;
    },
    Instance:{
        get:function(index){
            var t=this._nodes;
            return  t[index]||t;
        },
        each:function(fun){
            var self=this;
            for(var i=0,j=self._nodes,l=j.length;i<l;i++)
                if(false===fun.call(self,j[i],i))
                    break;
            return self;
        },
        isEmpty:function(){
            return !this._nodes.length;
        },
        merge:function(obj){
            if(this==linb.win||this==linb.doc||this==linb('body'))return this;
            var self=this, c=self.constructor, obj=obj._nodes, i=0, t, n=self._nodes;
            if(obj.length){
                for(;t=obj[i++];)n[n.length]=t;
                self._nodes=c._unique(n);
            }
            return self;
        },
        reBoxing:function(key,ensureValue){
            var self=this, t=linb.absBox.$type[key||'Dom'];
            if(t==self.KEY)return self;
            if(t=linb.SC(t))return t.pack(self._nodes, ensureValue);
        }
    },
    Static:{
        $abstract:true,
        $type:{},
        pack:function(arr, ensureValue){
            var o = new this(false);
            o._nodes = arr ? ensureValue===false ? arr : typeof this._ensureValues=='function'? this._ensureValues(arr) : arr : [];
            return o;
        },
        _unique:function(arr){
            var h={},a=[],i=0,t,m;
            for(;t=arr[i++];){
                m=t.$id;
                if(!h[m]){
                    h[m]=1;
                    a[a.length]=t;
                }
            }
            return a;
        },
        plugIn:function(name, fun){
            this.prototype[name]=fun;
            return this;
        }
    }
});

/*linb.Dom
*/
Class('linb.Dom','linb.absBox',{
    Instance:{
        serialize:function(){
            var a=[];
            this.each(function(o){
                a[a.length]=o.id;
            });
            return "linb(['"+a.join("','")+"'])";
        },
        //Need to consider the cache in linb.cache.dom
        id:function(value, ignoreCache){
            var t,i,cache=linb.cache.dom;
            if(typeof value == 'string')
                return this.each(function(o){
                    if((i=o.id)!==value){
                        if(!ignoreCache&&(t=cache[i])){
                            cache[value] = t;
                            delete cache[i];
                        }
                        o.id=value;
                    }
                });
            else
                return this.get(0).id;
        },

        /*dom collection
        fun: fun to run
        args: arguments for fun
        */
        $sum:function(fun, args){
            var arr=[],r,i;
            this.each(function(o){
                r=fun.apply(o, args||[]);
                if(r){
                    if(r.constructor==Array)
                        for(i=0;o=r[i];i++)
                            arr[arr.length]=o;
                    else
                        arr[arr.length]=r;
                }
            });
            return linb(arr);
        },
        /*get all dir children
        */
        children:function(){
            return this.$sum(function(){
                return _.toArr(this.childNodes)
            });
        },
        /* clone
         deep for clone all children
        */
        clone:function(deep){
            return this.$sum(function(){
                return this.cloneNode(deep?true:false);
            },arguments);
        },
        /* iterator
        // type: left : x-axis,  top :y-axis, xy: x-axis and y-axis
        // dir : true => left to right; top to buttom, false => right to left ; bottom to top
        // inn: does start consider children
         fun : number or function => number is iterator index; function is "return true ->stop"
        */
        $iterator:function(type, dir, inn, fun, top){
            return this.$sum(function(type, dir, inn, fun, top){
                var self=arguments.callee;
                if(typeof fun != 'function'){
                    var count=fun||0;
                    fun = function(n,index){return index==count;}
                }
                var index=0,m,n=this,flag=0,t;
                while(n){
                    if(n.nodeType==1)
                        if(fun(n, index++)===true)break;

                    //x-axis true: right ;false: left
                    if(type=='x')
                        n= dir?n.nextSibling:n.previousSibling;
                    //y-axis true: down ;false: up
                    else if(type=='y')
                        n= dir ? self.call(dir===1?n.lastChild:n.firstChild, 'x',(dir!==1), true, 0, top) : n.parentNode;
                    else{
                        inn=_.isBool(inn)?inn:true;
                        m=null;
                        n= dir ?
                                 (t = inn && n.firstChild ) ? t
                                              : (t = n.nextSibling ) ? t
                                                              :(m=n.parentNode)
                               : (t = inn && n.lastChild) ? t
                                              : (t = n.previousSibling ) ? t
                                                              :(m=n.parentNode);
                        if(m){
                            while(!( m = dir ? n.nextSibling: n.previousSibling)){
                                n=n.parentNode;
                                //to the top node
                                if(!n)
                                    if(flag)
                                        return null;
                                    else{
                                        flag=true;
                                        m = dir ? document.body.firstChild : document.body.lastChild;
                                        break;
                                    }
                            }
                            n=m;
                        }
                        inn=true;
                    }
                }
                return n;
            },arguments);
        },
        /*
        query('div');
        query('div','id');
        query('div','id','a');
        query('div','id',/^a/);
        query('div',function(){return true});
        */
        query:function(tagName, property, expr){
            tagName = tagName||'*';
            var f='getElementsByTagName',
                me=arguments.callee, f1=me.f1||(me.f1=function(tag, attr, expr){
                var all = this[f](tag), arr=[];
                if(expr.test(this[attr]))
                    arr[arr.length]=this;
                for(var o,i=0; o=all[i]; i++)
                    if(expr.test(o[attr]))
                        arr[arr.length]=o;
                return arr;
            }),f2=me.f2||(me.f2=function(tag, attr, expr){
                var all = this[f](tag), arr=[];
                if(this[attr]==expr)
                    arr[arr.length]=this;
                for(var o,i=0; o=all[i]; i++)
                    if(o[attr]==expr)
                        arr[arr.length]=o;
                return arr;
            }),f3=me.f3||(me.f3=function(tag, attr, expr){
                var all = this[f](tag), arr=[];
                if(this[attr])
                    arr[arr.length]=this;
                for(var o,i=0; o=all[i]; i++)
                    if(o[attr])
                        arr[arr.length]=o;
                return arr;
            }),f4=me.f4||(me.f4=function(tag){
                return _.toArr(this[f](tag));
            }),f5=me.f5||(me.f5=function(tag, attr){
                var all = this[f](tag), arr=[];
                if(attr(this))
                    arr[arr.length]=this;
                for(var o,i=0; o=all[i]; i++)
                    if(attr(o))
                        arr[arr.length]=o;
                return arr;
            });
            return this.$sum(property?typeof property=='function'?f5:expr?expr.constructor == RegExp?f1:f2:f3:f4, [tagName, property, expr]);
        },

        /*
        dom add implementation
        for addPrev prepend addNext append
        fun :for wrap
        o: to added target
        flag: false for add one only, not clone
        */
        $add:function(fun,target){
            target=linb(target);
            var v=this.get(0),dom=linb.Dom,cache=linb.cache.dom,uiObj,p;//,s,b,k;
            target.each(function(target){
                //two &&p.LayoutTrigger for performance
                uiObj=(p=target.id)&&(p=cache[p])&&p.LayoutTrigger&&dom.getStyle(v,'display')!='none'&&p.LayoutTrigger;
                //if(uiObj){
                    //s=target.style;
                    //if(s.visibility!='hidden'){
                     //   b=1;
                       // k=s.visibility;
                        //s.visibility='hidden';
                    //}else b=0;
                //}
                //add dom node
                fun.call(v,target);
                if(uiObj){
                    for(var i=0,l=uiObj.length;i<l;i++)
                        uiObj[i].call(p);
                    //if(b)s.visibility=k;
                }
            });
            return this;
        },
        prepend:function(target){
            var temp;
            return this.$add(function(target){
                var self=this;
                if(self.firstChild!=target){
                    if(self.firstChild)
                        self.insertBefore(target, temp||(temp=self.firstChild));
                    else
                        self.appendChild(target);
                }
            },target);
        },
        append:function(target){
            return this.$add(function(target){
                if(this.lastChild!=target)
                    this.appendChild(target);
            },target);
        },
        addPrev:function(target){
            return this.$add(function(target){
                if(this.previousSibling!=target)
                    this.parentNode.insertBefore(target,this);
            },target);
        },
        addNext:function(target){
            var t;
            return this.$add(function(target){
                var self=this;
                if((t=self.nextSibling)!=target){
                    if(t)
                        self.parentNode.insertBefore(target, t);
                    else
                        self.parentNode.appendChild(target);
                }
            },target);
        },

        //flag: false => no remove this from momery(IE)
        replace:function(target, triggerGC){
            target=linb(target);
            var v,i,c=this.get(0),ns=target.get(),l=ns.length;
            if(l>0 && (v=ns[l-1])){
                c.parentNode.replaceChild(v,c);
                for(i=0;i<l-1;i++)
                    v.parentNode.insertBefore(ns[i],v);
                //for memory __gc
                if(triggerGC)
                    this.remove(triggerGC);
            }
            return target;
        },
        swap:function(target){
            var self=this,t = linb.Dom.getEmptyDiv().html('*',false);

            target=linb(target);

            self.replace(t,false);
            target.replace(self,false);
            t.replace(target,false);

            t.get(0).innerHTML='';
            document.body.insertBefore(t.get(0), document.body.firstChild);
            return self;
        },
        //flag : false => remove from dom tree, not free memory
        remove:function(triggerGC){
            var me=arguments.callee,c=me._c||(me._c=document.createElement('div'));
            if(triggerGC===false)
                this.each(function(o,i){
                    if(o.parentNode)o.parentNode.removeChild(o);
                });
            else{
                this.each(function(o){
                    c.appendChild(o);
                });
                c.innerHTML='';
                _.resetRun('dom.__gc', linb.Dom.__gc, 300);
            }
            return this;
        },
        //set innerHTML empty
        //flag = false: no gc
        empty:function(triggerGC){
            return this.each(function(o){
                linb([o]).html('',triggerGC);
            });
        },

        //flag = false: no gc
        html:function(content,triggerGC){
            var s='',t,bak,o=this.get(0);triggerGC=triggerGC!==false;
            if(content!==undefined){
                if(o.nodeType==3)
                    o.nodeValue=content;
                else{
                     if(!(bak=o.firstChild) && content=="")return this;
                     // innerHTML='' in IE, will clear it's childNodes innerHTML
                     if(!triggerGC && linb.browser.ie)while(t=o.firstChild)o.removeChild(t);
                     //clear first
                     if(triggerGC)o.innerHTML='';

                     o.innerHTML=content;
                     // set triggerGC->true will not gc
                     // no original innerHTML will not gc
                     // use resetRun for performance
                     if(triggerGC && bak)
                        _.resetRun('dom.__gc', linb.Dom.__gc, 300);
                }
                return this;
            }else
                return (o.nodeType==3)?o.nodeValue:o.innerHTML;
        },
        outerHTML:function(content, triggerGC){
            var self=this, t,s='', o=self.get(0),id=o.id;
            if(content!==undefined){
                //clear ehandler
                if(o.nodeVars&&(t=o.domNode))
                    _.each(o.nodeVars,function(o,i){
                        t[i]=null;
                    });

                if(linb.browser.gek){
                    var n=self.replace(_.str.toDom(content),false);
                    self._nodes[0]=n.get(0);
                }else{
                    var b,r = (b=o.previousSibling)?o.previousSibling:o.parentNode;
                    o.outerHTML=content;
                    if(r)
                        self._nodes[0] = b?r.nextSibling:r.firstChild;
                }

                //avoid inner nodes memory leak
                linb([o]).remove(triggerGC);
                return self;
            }else{
                if(linb.browser.gek){
                    var dom=linb.Dom, m = dom.getEmptyDiv(), n = dom.getEmptyDiv(2), np=n.parent(), p;
                    //has parentNode, need keep node in this way
                    if(p=o.parentNode)self.replace(n, false);
                    //set to box
                    m.append(o);
                    //get string
                    s = m.html();
                    //set back
                    if(p)n.replace(o, false);
                    m.empty();
                    np.prepend(n);
                    return s;
                }else
                    return o.outerHTML;
            }
        },
        text:function(content){
            if(content!==undefined){
                var self=this, arr=[];
                self.each(function(o){
                    var t=o.childNodes[0];
                     if(t&&t.nodeType!=1)
                        t.nodeValue = content;
                     else
                        arr[arr.length]=o;
                });
                if(arr.length){
                    linb(arr).empty().each(function(o){
                        o.appendChild(document.createTextNode(content));
                    })
                }
                return self;
            }else{
               return (function(o){
                  var i,a=o.childNodes,l=a.length,content='',me=arguments.callee;
                  for(i=0;i<l;i++)
                    if(a[i].nodeType!= 8)
                      content += (a[i].nodeType!=1) ? a[i].nodeValue : me(a[i]);
                  return content;
                })(this.get(0));
            }
        },
        /*
        .attr(name)=>get attr
        .attr(name,value)=>set attr
        .attr(name,null)=>remove attr
        */
        attr:function(name, value){
            //set one time only
            var self=this,
                me = arguments.callee,
                map1 = me.map1 || (me.map1 = {
                    'class':'className',
                    readonly: "readOnly",
                    tabindex: "tabIndex",
                    'for':'htmlFor',
                    maxlength: "maxLength",
                    cellspacing: "cellSpacing",
                    rowspan: "rowSpan",
                    value:'value'
                }),
                map2 = me.map2||(me.map2={
                    href:1,src:1,style:1
                });

            if(typeof name=='object'){
                for(var i in name)
                    me.call(self,i,name[i]);
                return self;
            }

            var iestyle = linb.browser.ie && name=='style',
                normal=!map2[name=map1[name]||name];
            if(value!==undefined){
                return self.each(function(o){
                    //remove attr
                    if(value===null){
                        if(iestyle)o.style.cssText='';
                        else if(normal){
                            try{
                                o[name]=null;
                                if(o.nodeType==1)o.removeAttribute(name)
                            }catch(e){}
                        }
                    //set attr
                    }else{
                        if(iestyle)o.style.cssText=''+value;
                        else if(normal){
                             o[name]=value;
                             if(o.nodeType==1 && typeof value=='string')o.setAttribute(name, value);
                        }else
                            o.setAttribute(name, value);
                    }
                 });
            //get attr
            }else{
                var o=self.get(0);
                if(iestyle) return o.style.cssText;
                if(name=="selected"&&linb.browser.kde) o.parentNode.selectedIndex;
                return ((name in o) && normal)?o[name]:o.getAttribute(name, linb.browser.ie && !normal ? 2 : undefined );
            }
        },
        /*
        name format: 'xxxYxx', not 'xxx-yyy'
        left/top/width/height like, must specify 'px'
        Does't fire onResize onlocation event
        */
        css:function(name, value){
            return (typeof name=='object' || value!==undefined)
                ?
                this.each(function(o){
                    linb.Dom.setStyle(o,name,value)
                })
                :
                linb.Dom.getStyle(this.get(0), name)
        },
        /*
        *IE/opera \r\n will take 2 chars
        *in IE: '/r/n'.lenght is 2, but range.moveEnd/moveStart will take '/r/n' as 1.
        */
        caret:function(begin,end){
            var input =this.get(0), tn=input.tagName, type=typeof begin,ie=linb.browser.ie, pos;
            if(!/^(input|textarea)$/i.test(tn))return this;
            input.focus();
            //set caret
            if(type=='number'){
                if(ie){
                    var r = input.createTextRange();
                    r.collapse(true);
                    r.moveEnd('character', end);
                    r.moveStart('character', begin);
                    r.select();
                }else
                    input.setSelectionRange(begin, end);
                return this;
            //replace text
            }else if(type=='string'){
                    var r=this.caret(),l=0,m=0,ret,
                        v=input.value,
                        reg1=/\r/g;
                    //for IE, minus \r
                    if(ie){
                        l=v.substr(0,r[0]).match(reg1);
                        l=(l && l.length) || 0;
                        m=begin.match(reg1);
                        m=(m && m.length) || 0;
                    }
                    //opera will add \r to \n, automatically
                    if(linb.browser.opr){
                        l=begin.match(/\n/g);
                        l=(l && l.length) || 0;
                        m=begin.match(/\r\n/g);
                        m=(m && m.length) || 0;
                        m=l-m;l=0;
                    }
                    input.value=v.substr(0,r[0])+begin+v.substr(r[1],v.length);
                    ret= r[0] - l + m + begin.length;
                    this.caret(ret,ret);
                    return ret;
            //get caret
            }else{
                if(ie){
                    var r=document.selection.createRange(),
                        txt=r.text,
                        l=txt.length,
                        e,m;
                    r.moveStart('character', -input.value.length);
                    e=r.text.length;
                    return[e-l,e];
                //firefox opera safari
                }else
                    return [input.selectionStart, input.selectionEnd];
            }
        },
        //left,top format: "23px"
        show:function(left,top){
            var style,t,auto='auto',v=linb.Dom.HIDE_VALUE;
            return this.each(function(o){
                if(o.nodeType != 1)return;
                style=o.style;
                if( t = (top || (style.top==v && (o._top || auto))))style.top = t;
                if( t = (left || (style.left==v && (o._left || auto))))style.left = t;
                if(t=o._position)if(style.position!=t)style.position=t;
                if(style.visibility!='visible')style.visibility='visible';
                //ie6 bug
              /*  if(linb.browser.ie6){
                    t=style.wordWrap=='normal';
                    _.asyRun(function(){
                        style.wordWrap=t?'break-word':'normal'
                    })
                }*/
            });
        },
        hide:function(){
            var style,t;
            return this.each(function(o){
                if(o.nodeType != 1)return;
                style=o.style;t=linb([o]);
                o._position = style.position;
                o._top = style.top;
                o._left = style.left;
                if(style.position!='absolute')style.position = 'absolute';
                style.top = style.left = linb.Dom.HIDE_VALUE;
            });
        },
        cssRegion:function(region,triggerEvent) {
            var self=this
            if(typeof region=='object'){
                var i,t,m,  node=self._nodes[0], dom=linb.Dom, f=dom._setPxStyle,m={};
                for(var j=0,c=dom._boxArr;i=c[j++];)
                    m[i] = ((i in region) && region[i]!==null)?f(node,i,region[i]):false;
                if(triggerEvent){
                    var f=dom.$hasEventHandler;
                    if(f(node,'onsize') && (m.width||m.height))self.onSize(true, {width:m.width,height:m.height});
                    if(f(node,'onlocation') && (m.left||m.top))self.onLocation(true, {left:m.left,top:m.top});
                }
                return self;
            }else{
                var offset=region,parent=triggerEvent,
                    pos = offset?self.offset(null,parent):self.cssPos(),
                    size = self.cssSize();
                return {
                    left:pos.left,
                    top:pos.top,
                    width:size.width,
                    height:size.height
                };
            }
        },
        //for quick size
        cssSize:function(size,triggerEvent) {
            var self=this, node=self._nodes[0],dom=linb.Dom,f=dom._setPxStyle,b1,b2;
           if(size){
                var t;
                b1 = size.width!==null?f(node,'width',size.width):false;
                b2 = size.height!==null?f(node,'height',size.height):false;
                if(triggerEvent && (b1||b2) && dom.$hasEventHandler(node,'onsize'))self.onSize(true, {width:b1,height:b2});
                return self;
            }else
                return { width :self._W(node,1)||0,  height :self._H(node,1)};
        },
        //for quick move
        cssPos:function(pos, triggerEvent){
            var node=this._nodes[0],dom=linb.Dom,f=dom._setPxStyle,b1,b2;
            if(pos){
                var t;
                b1 = pos.left!=null?f(node,'left',pos.left):false;
                b2 = pos.top!==null?f(node,'top',pos.top):false;
                if(triggerEvent && (b1||b2) && dom.$hasEventHandler(node,'onlocation'))this.onLocation(true, {left:b1,top:b2});
                return this;
            }else{
                f=dom.getStyle;
                return {left :parseInt(f(node, 'left'))||0,  top :parseInt(f(node, 'top'))||0};
            }
        },
/*
+--------------------------+
|margin                    |
| #----------------------+ |
| |border                | |
| | +------------------+ | |
| | |padding           | | |
| | | +--------------+ | | |
| | | |   content    | | | |

# is the offset position in jsLinb
*/
        offset:function (pos,boundary){
            var r,t,
            browser = linb.browser,
            ns=this,
            node = ns.get(0),
            keepNode=node,
            parent =node.parentNode,
            op=node.offsetParent,
            doc=node.ownerDocument,
            dd=doc.documentElement,
            db=doc.body,
            _d=/^inline|table.*$/i,
            getStyle=linb.Dom.getStyle,
            fixed = getStyle(node, "position") == "fixed",

            me=arguments.callee,
            add= me.add || (me.add=function(pos, l, t){
                pos.left += parseInt(l,10)||0;
                pos.top += parseInt(t,10)||0;
            }),
            border=me.border || ( me.border = function(node, pos){
                add(pos, getStyle(node,'borderLeftWidth'), getStyle(node,'borderTopWidth'));
            }),
            TTAG=me.TTAG||(me.TTAG={TABLE:1,TD:1,TH:1}),
            HTAG = me.HTAG ||(me.HTAG={BODY:1,HTML:1}),
            posDiff=me.posDiff ||(me.posDiff=function(o,target){
                var cssPos = o.cssPos(),absPos = o.offset(null,target);
                return {left :absPos.left-cssPos.left, top :absPos.top-cssPos.top};
            });

            boundary=boundary?linb(boundary).get(0):doc;

            if(pos){
                //all null, return dir
                if(pos.left===null&&pos.top===null)return ns;
                var d = posDiff(ns,boundary);
                ns.cssPos({left :pos.left===null?null:(pos.left - d.left),  top :pos.top===null?null:(pos.top - d.top)});
                r=ns;
            }else{
                //for IE, firefox3(except document.body)
                if(!(linb.browser.gek && node==document.body) && node.getBoundingClientRect){
                    t = node.getBoundingClientRect();
                    pos = {left :t.left, top :t.top};
                    if(boundary.nodeType==1)
                        add(pos, -(t=boundary.getBoundingClientRect()).left+boundary.scrollLeft, -t.top+boundary.scrollTop);
                    else
                        add(pos, Math.max(dd.scrollLeft, db.scrollLeft)-dd.clientLeft, Math.max(dd.scrollTop,  db.scrollTop)-dd.clientTop);
                }else{
                    pos = {left :0, top :0};
                    add(pos, node.offsetLeft, node.offsetTop );
                    //get offset, stop by boundary or boundary.offsetParent
                    while(op && op!=boundary && op!=boundary.offsetParent){
                        add(pos, op.offsetLeft, op.offsetTop);
                        if(browser.kde || (browser.gek && !TTAG[op.tagName]))
                            border(op, pos);
                        if ( !fixed && getStyle(op,"position")== "fixed")
                            fixed = true;
                        if(op.tagName!='BODY')
                            keepNode=op.tagName=='BODY'?keepNode:op;
                        op = op.offsetParent;
                    }

                    //get scroll offset, stop by boundary
                    while (parent && parent.tagName && parent!=boundary && !HTAG[parent.tagName]){
                        if(!_d.test(getStyle(parent, "display")) )
                            add(pos, -parent.scrollLeft, -parent.scrollTop );
                        if(browser.gek && getStyle(parent,"overflow")!= "visible" )
                            border(parent,pos);
                        parent = parent.parentNode;
                    }
                    if((browser.gek && getStyle(keepNode,"position")!="absolute"))
                        add(pos, -db.offsetLeft, -db.offsetTop);
                    if(fixed)
                        add(pos, Math.max(dd.scrollLeft, db.scrollLeft), Math.max(dd.scrollTop,  db.scrollTop));
                }
                r=pos;
            }
            return r;
        },

//class and src
        hasClass:function(name){
            var arr = this.get(0).className.split(/\s+/);
            return _.arr.indexOf(arr,name)!=-1;
        },
        addClass:function(name){
            var arr, t, me=arguments.callee,reg=(me.reg||(me.reg=/\s+/));
            return this.each(function(o){
                arr = (t=o.className).split(reg);
                if(_.arr.indexOf(arr,name)==-1)
                    o.className = t + " " +name;
            });
        },
        removeClass:function(name){
            var arr, i,l,a, t, bs=typeof name=='string', me=arguments.callee,reg=(me.reg||(me.reg=/\s+/));
            return this.each(function(o){
                arr = o.className.split(reg);
                l=arr.length;
                a=[];
                for(i=0;t=arr[i];i++)
                    if(bs?(t!=name):(!name.test(String(t))))
                        a[a.length]=t;
                if(l!=a.length)o.className=a.join(' ');
            });
        },
        replaceClass:function(regexp,replace){
            var n,r;
            return this.each(function(o){
                r = (n=o.className).replace(regexp, replace);
                if(n!=r)o.className=r;
            });
        },
        tagClass:function(tag, isAdd){
            var self=this,
                me=arguments.callee,
                r1=me["_r1_"+tag]||(me["_r1_"+tag]=new RegExp("([-\\w]+" + tag + "[-\\w]*)")),
                r2=me["_r2"]||(me["_r2"]=/([-\w]+)/g);
            self.removeClass(r1);
            return (false===isAdd)? self : self.replaceClass(r2, '$1 $1' + tag);
        },
//events:
        /*
        $addEvent('onClick',fun,'idforthisclick';)
        $addEvent([['onClick',fun,'idforthisclick'],[...]...])

        will
            add onclick to dom
            add onclick to dom attribute
            append fun to linb.cache.dom.id.events.onClick array
            append 'onclick' to linb.cache.dom.id.add array
        */
        _ajustType:function(o,type){return (window===o||document===o) && type=="onsize" ? "onresize" :type},
        $addEventHandler:function(name, flag){
            var id,
                c,
                event=linb.Event,
                type='on'+event._getEventType(name),
                f=event.$eventhandler,
                fs=event.$EVENTHANDLER,
                fi=event.getId,
                _a=this._ajustType;

            return this.each(function(o){
                if(o.nodeType==3)return;
                id=fi(o);
                if(!id)id=o.id=_.id();
                type=_a(o,type);
                if(flag===false){
                    //for before innerHTML
                    if(o.setAttribute)o.setAttribute(type, fs);
                }else{
                    //if exists
                    if(o[type])return;
                    o[type]=f;
                }
                if(!(c = linb.DomProfile.get(id)))
                    c =new linb.DomProfile(id,o);
                (c.nodeVars||(c.nodeVars={}))[type]=fs;
            });
        },
        $removeEventHandler:function(name){
            var type='on'+linb.Event._getEventType(name),_a=this._ajustType;
            return this.each(function(o){
                type=_a(o,type);
               if(o[type])o[type]=null;
               if(o.getAttribute && o.getAttribute(type))o.removeAttribute(type);
            });
        },
        $addEvent:function(name, fun, label, index){
            var self=this,c,t,id,type,fi=linb.Event.getId,dom=linb.cache.dom,event=linb.Event,arv=_.arr.removeValue,ari=_.arr.insertAny;
            if(!(name  instanceof Array))
                name=[[name,fun,label]];
            if(!index && index!==0)index=-1;

            _.arr.each(name,function(o,i){
                name=o[0];fun=o[1];label=o[2];
                if(typeof label=='string')
                    label="$"+label;
                else label=undefined;

                self.$addEventHandler(name).each(function(o){
                    if(o.nodeType==3)return;
                    id=fi(o);
                    if(!id)id=o.id=_.id();

                    c = dom[id];

                    t = c.events || (c.events = {});
                    c = t[name] || (t[name]=[]);

                    //if no label input, clear all, and add a single
                    if(label===undefined){
                        c.length=0;c=t[name]=[];
                        index=-1;
                        label='_';
                    }
                    c[label]=fun;
                    arv(c,label);
                    if(index==-1)c[c.length]=label;
                    else
                        ari(c,label, index);

                    if(t=(c=dom[id]).clearCache)t.call(c);
                });
            });
            return self;
        },
        /*
        $removeEvent('onClick','idforthisclick')
        $removeEvent('onClick')
            will remove all onClick in linb.cache.dom.id.events.
        $removeEvent('onClick',null,true)
            will remove all onClick/beforeClick/afterClick in linb.cache.dom.id.events.
        */
        $removeEvent:function(name, label, flag){
            var self=this,c,t,k,id,i,type,fi=linb.Event.getId,dom=linb.cache.dom,event=linb.Event;
            if(!(name instanceof Array))
                name=[[name,label]];

            _.arr.each(name,function(o,i){
                name=o[0];label=o[1];
                type=event._getEventType(name);
                self.each(function(o){
                    if(!(id=fi(o)))return;

                    if(!(c=dom[id]))return;
                    if(!(t=c.events))return;
                    if(flag)
                        _.arr.each(event._getEventName(type),function(o){
                            delete t[o];
                        });
                    else{
                        if(typeof label == 'string'){
                            label='$'+label;
                            if(k=t[name]){
                                if(_.arr.indexOf(k,label)!=-1)
                                    _.arr.removeValue(k,label);
                                delete k[label];
                            }
                        }else
                            delete t[name];
                    }
                    if(t=(c=dom[id]).clearCache)t.call(c);
// Removes events handler too:
//                    if(_.isEmpty(t) || flag){
//                        o[linb.Dom._ajustType(o,"on"+type)]=null;
//                        delete c.nodeVars["on"+type];
//                    }
                });
            });
            return self;
        },
        $getEvent:function(name, label){
            var id;
            if(!(id=linb.Event.getId(this.get(0))))return;

            if(label)
                return _.get(linb.cache.dom,[id,'events',name,'$' + label]);
            else{
                var r=[],arr = _.get(linb.cache.dom,[id,'events',name]);
                _.arr.each(arr,function(o,i){
                    r[r.length]=[o,arr[o]];
                });
                return r;
            }
        },
        $clearEventHandler:function(){
            return this.each(function(o){
                _.arr.each(linb.Event._events,function(s){
                   if(o[s="on"+s])o[s]=null;
                   if(o.getAttribute && o.getAttribute(s))o.removeAttribute(s);
                });
            });
        },
        $clearEvent:function(){
            this.$clearEventHandler();
            return this.each(function(o){
                var id,c;
                if(!(id=linb.Event.getId(o)))return;
                if(!(c=linb.cache.dom[id]))return;
                _.filter(c.nodeVars, function(i,v){
                    if(_.str.startWith(v,"on"))return false;
                });
                _.breakO(c.events,2);
                delete c.events;
            });
        },
        $fireEvent:function(name, args){
            var type=linb.Event._getEventType(name),
            t,s='on'+type,
            me=arguments.callee,
            f=linb.Event.$eventhandler,
            f1=me.f1||(me.f1=function(){this.returnValue=false}),
            f2=me.f2||(me.f2=function(){this.cancelBubble=true}),
            _a=this._ajustType;

            args= args || {};
            return this.each(function(o){
                s=_a(o,s);
                //for no standard events, like onDrag
                if(typeof o[s]!='function'){
                    if(!o[s] && !(o.getAttribute && o.getAttribute(s)))
                        return;
                     o[s] = f;
                }
                _.merge(args,{
                    type: type,
                    target: o,
                    button : 1,
                    $e:true,
                    $name:name,
                    preventDefault:f1,
                    stopPropagation:f2
                },'all');

                if('blur'==type || 'focus'==type)
                    //try{
                        o[type].call(o,args);
                    //}catch(e){}
                else
                   o[s].call(o,args);
            });
        },

//functions
        $canFocus:function(){
            var me=arguments.callee, getStyle=linb.Dom.getStyle, map = me.map || (me.map={a:1,input:1,select:1,textarea:1,button:1}),t,node;
            return !!(
                (node = this._nodes[0]) &&
                node.focus &&
                //IE bug: It can't be focused with 'default tabIndex 0'; but if you set it to 0, it can be focused.
                //So, for cross browser, don't set tabIndex to 0
                (((t=map[node.tagName.toLowerCase()]) && !(parseInt(node.tabIndex)<=-1)) || (!t && parseInt(node.tabIndex)>=(linb.browser.ie?1:0))) &&
                getStyle(node,'display')!='none' &&
                getStyle(node,'visibility')!='hidden' &&
                node.offsetWidth>0 &&
                node.offsetHeight>0
            );
        },
        focus:function(force){
            var ns=this;
            if(force || ns.$canFocus())
                try{ns.get(0).focus()}catch(e){}
            return ns;
        },
        setSelectable:function(value){
            var me=arguments.callee, _f = me._f || (me._f=function(){return false});
             return this.each(function(o){
                if(linb.browser.gek)
                    o.style.MozUserSelect=value?"all":"none"
                else{
                    o.unselectable=value?"off":"on";
                    o.onselectstart=value?null:_f;
                }
            })
        },
        setInlineBlock:function(){
            var ns=this;
            if(linb.browser.gek)
                ns.css('display','-moz-inline-block').css('display','-moz-inline-box').css('display','inline-block');
            else
                ns.css('display','inline-block');
            return ns;
        },
        topZindex:function(flag){
            //set the minimum to 1000
            var i=1000, j=0, k, node = this.get(0), p = node.offsetParent, t, o;
            if(node.nodeType !=1 || !p)return 1;

            t=p.childNodes;
            for(k=0;o=t[k];k++){
                if(o==node || o.nodeType !=1 || o.style.display=='none' || o.style.visibility=='hidden' || o.zIndexIgnore)continue;
                j = parseInt(o.style && o.style.zIndex) || 0 ;
                i=i>j?i:j;
            }
            i++;
            if(i>=linb.Dom.TOP_ZINDEX)
                linb.Dom.TOP_ZINDEX =i+1000;

            if(flag)
                 node.style.zIndex = i;
            else{
                j = parseInt(node.style.zIndex) || 0;
                return i>j?i:j;
            }
            return this;
        },
        /*
        dir:true for next, false for prev
        inn:true for include the inner node
        set:true for give focus
        */
        nextFocus:function(downwards, includeChild, setFocus){
            downwards=_.isBool(downwards)?downwards:true;
            var self=this.get(0),node = this.$iterator('',downwards,includeChild,function(node){return node!==self && linb([node]).$canFocus()});
            if(!node.isEmpty() && setFocus!==false)node.focus();
            return node;
        },

        /*
        args:{
            with:[0,100],
            height:[0,100],
            left:[0,100]
            top:[0,100]
            opacity:[0,1],
            backgroundColor:['#ffffff','#000000']
            scrollTop:[0,100]
            scrollLeft:[0,100]
            fontSize:[12,18]
        }
        */
        animate: function(args, onStart, onEnd, time, step, type, threadid){
            var me=arguments.callee,
            hash = me.lib ||  (me.lib = {
                line:function(x){return x},
                inexp:function(x){return (x==0)?0:Math.pow(2,10*(x-1))},
                outexp:function(x){return (x==1)?1:-Math.pow(2,-10*x)+1},
                insine:function(x){return -1*Math.cos(x*(Math.PI/2))+1},
                outsine:function(x){return Math.sin(x*(Math.PI/2))},
                inoutsine:function(x){return -1/2*(Math.cos(Math.PI*x)-1)}
            }),
            color = me.color || (me.color = function(type, args, step, j){
                var f,fun,value = 0 + (100-0)*hash[type](j/step), from = args[0], to = args[1];

                if(typeof from !='string' || typeof to != 'string')return '#fff';
                if(value<0)
                    return from;
                else if(value>100)
                    return to;

                f=function(str){
                    return (str.charAt(0)!='#')?('#'+str):str;
                };
                from=f(from);to=f(to);

                f=function(str, i, j){
                    return parseInt(str.slice(i,j),16)||0;
                };
                fun=function(o){
                    return {red:f(o,1,3),green:f(o,3,5),blue:f(o,5,7)}
                };
                from = fun(from);to = fun(to);

                f=function(from, to, value,c){
                    var r= from[c]+Math.round((value/100)*(to[c]-from[c]));
                    return (r < 16 ? '0' : '') + r.toString(16)
                };
                return '#' + f(from,to, value, 'red') + f(from,to, value, 'green') + f(from,to, value, 'blue');
            });

            time = time||100;
            step = step||5;
            type = hash[type]!==undefined?type:'inexp';

            var self=this, count=0,
                funs=[function(threadid){
                    //try{
                       // if(++count > step)throw new Error;
                        if(++count > step){
                            linb.Thread(threadid).abort();
                            return false;
                        }
                        _.each(args,function(o,i){
                            if(typeof o == 'function') o(hash[type](count/step));
                            else{
                                var value = String( _.str.endWith(i.toLowerCase(),'color') ? color(type, o, step, count) : (o[0] + (o[1]-o[0])*hash[type](count/step)));
                                (self[i]) ? (self[i](value)) :(self.css(i, value));
                            }
                        });
                    //}catch(e){
                    //    linb.Thread(threadid).abort();
                    //    color=hash=null;
                   // }
                }];
            return linb.Thread(threadid||_.id(), funs, Math.max(time/step-9,0), null, onStart, onEnd ,true);
        },
        /*
        pos: {left:,top:} or domNode
        parent:parent node
        type:1,2,3,4
        */
        popToTop : function(pos, type, parent){
            var region, target=this,  t;

            parent=linb(parent);
            if(parent.isEmpty())parent=linb('body');

            //prepare
            target.css({position:'absolute',left:linb.Dom.HIDE_VALUE, top:linb.Dom.HIDE_VALUE,display:'block', zIndex:linb.Dom.TOP_ZINDEX});

            if(pos['linb.Dom'] || pos.nodeType){
                type = (type || 1).toString();
                var node=linb(pos),
                    //base region
                    abspos = node.offset(null, parent);
                region = {
                    left:abspos.left,
                    top:abspos.top,
                    width:node.offsetWidth(),
                    height:node.offsetHeight()
                };
             }else{
                type = type?'3':'0';
                t=type=='0'?0:8;
                region = pos.region || {
                    left:pos.left-t,
                    top:pos.top-t,
                    width:t*2,
                    height:t*2
                };
            }
            pos={left :0, top :0};

            //window edge
            var t=linb.win, box = {};
            box.left=t.scrollLeft();
            box.top=t.scrollTop();
            box.width =t.width()+box.left;
            box.height =t.height()+box.top;
/*
type:1
    +------------------+    +------------------+
    |        3         |    |        4         |
    +--------------+---+    +---+--------------+
    |              |            |              |
    |              |            |              |
    +--------------+---+    +---+--------------+
    |        1         |    |        2         |
    +------------------+    +------------------+
type:2
                         +---+              +---+
                         |   |              |   |
+---+--------------+---+ |   +--------------+   |
|   |              |   | | 3 |              | 4 |
| 2 |              | 1 | |   |              |   |
|   +--------------+   | +---+--------------+---+
|   |              |   |
+---+              +---+
type:3
                         +---+              +---+
                         | 3 |              | 4 |
    +--------------+     +---+--------------+---+
    |              |         |              |
    |              |         |              |
+---+--------------+---+     +--------------+
| 2 |              | 1 |
+---+              +---+
type:4
                     +------------------+
                     | 3                |
+--------------+---+ |   +--------------+ +----+--------------+ +--------------+----+
|              |   | |   |              | |    |              | |              |    |
|              |   | |   |              | |    |              | |              |    |
+--------------+   | +---+--------------+ |    +--------------+ +--------------+    |
|                1 |                      |  2                | |               4   |
+------------------+                      +-------------------- +-------------------+
*/

            //target size
            var w = target.offsetWidth(), h = target.offsetHeight(),
                hi,wi;
            switch(type){
                case '1':
                    hi=false;wi=true;
                break;
                case '2':
                    hi=true;wi=false;
                break;
                case '3':
                    hi=false;wi=false;
                break;
                case '4':
                    hi=wi=true;
                break;
            }

            if(hi){
                if(region.top + h < box.height)
                    pos.top=region.top;
                else
                    pos.top=region.top+region.height-h;
            }else{
                if(region.top + region.height + h < box.height)
                    pos.top=region.top + region.height;
                else
                    pos.top=region.top - h;
            }
            if(wi){
                if(region.left + w < box.width)
                    pos.left=region.left;
                else
                    pos.left=region.left+region.width-w;
            }else{
                if(region.left + region.width + w < box.width)
                    pos.left=region.left + region.width;
                else
                    pos.left=region.left - w;
            }

            //over right
            if(pos.left + w>  box.width)pos.left = box.width - w;
            //over left
            if(pos.left < box.left)pos.left = box.left;
            //over bottom
            if(pos.top + h>  box.height)pos.top = box.height - h;
            //over top
            if(pos.top < box.top)pos.top = box.top;
            //show
            target.cssPos(pos).css({visibility:'visible',display:'block'});

            //ensure show target on the top of the other elements with the same zindex
            parent.get(0).appendChild(target.get(0))

            return this;
        },
        //for remove obj when blur
        setBlurTrigger : function(id, trigger, group){
            var ns=this,
                doc=document,
                sid='$blur_triggers$',
                target = linb(group?group:ns.get()),
                fun=linb.Dom._blurTrigger||(linb.Dom._blurTrigger=function(p,e){
                    var me=arguments.callee,
                        p=linb.Event.getPos(e),
                        arr=me.arr,
                        a=_.copy(arr),
                        b, pos, w, h, v;
                    //filter first
                    _.arr.each(a,function(i){
                        b=true;
                        if(!(v=arr[i].target))b=false;
                        else
                            v.each(function(o){
                                if(!linb.Dom.byId(o.id))
                                    return b=false;
                            });
                        if(!b){
                            _.arr.removeValue(arr,i);
                            delete arr[i];
                        };
                    });
                    a=_.copy(arr);
                    _.arr.each(a,function(i){
                        v=arr[i];
                        b=true;
                        v.target.each(function(o){
                            if(o.parentNode && (w=o.offsetWidth) && (h=o.offsetHeight)){
                                pos=linb([o]).offset();
                                if(p.left>=pos.left && p.top>=pos.top && p.left<=(pos.left+w) && p.top<=(pos.top+h))
                                    return b=false;
                            }
                        });
                        if(b){
                            _.tryF(v.trigger,[],v.target);
                            _.arr.removeValue(arr,i);
                            delete arr[i];
                        }else
                            //if the top layer popwnd cant be triggerred, prevent the other layer popwnd trigger
                            return false;
                    },null,true);
                    a.length=0;
                }),
                arr=fun.arr||(fun.arr=[]);
            if(!doc.onmousedown)doc.onmousedown=linb.Event.$eventhandler;
            target.each(function(o){if(!o.id)o.id=_.id()});
            //remove this trigger
            if(!trigger){
                _.arr.removeValue(arr,id);
                delete arr[id];
            //double link
            }else
                if(arr[id]){
                    _.arr.removeValue(arr,id);
                    delete arr[id];
                }
                arr[id]={
                    trigger:trigger,
                    target:target
                };
                arr.push(id);
            return this;
        },
        //for firefox disappeared cursor bug in input/textarea
        $firfox2:function(){
            if(!linb.browser.gek2)return this;
            var ns=this;
            ns.css('overflow','hidden');
            _.asyRun(function(){ns.css('overflow','auto')});
            return ns;
        },
        //IE not trigger dimension change, when change height only in overflow=visible.
        ieRemedy:function(){
            if(linb.browser.ie){
                var self=this;
                _.asyRun(function(){self.css('wordWrap','break-word')});
                _.asyRun(function(){self.css('wordWrap','normal');});
            }
            return this;
        },
        //for ie6
        fixPng:function(type){
            if(linb.browser.ie6)
                return this.each(function(n){
                    if(n.tagName=='IMG'){
                        n.style.height = n.height;
                        n.style.width = n.width;
                        n.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + n.src + "',sizingMethod='"+type+"')";
                        n.src = linb.ini.file_bg;
                    }
                });
        }
        /*,
        gekRemedy:function(){
            if(linb.browser.gek)
                return this.each(function(o,i){
                    if(i=o.style){
                        var b=i.zIndex||0;
                        i.zIndex=++b;
                        i.zIndex=b;
                    }
                });
        }*/
    },
    Static:{
        HIDE_VALUE : '-10000px',
        TOP_ZINDEX:10000,

        _boxArr:_.toArr('width,height,left,top,right,bottom'),
        _cursor:{},

        __gc:function(){
            var i,o,t,w,cache=linb.cache.dom,bak=[];
            for(i in cache){
                 o=cache[i];
                 if(!o)continue;
                 t=o.domNode;
                 if(window===t||document===t||document.body===t)continue;
                 if(!document.getElementById(o.domId)){
                     if(t)t.$id=null;
                     o.__gc();
                     //clear the cache
                     bak[bak.length]=i;
                     //clear the cache shadow
                     if(o.$domId && o.$domId!=o.domId)
                        bak[bak.length]=o.$domId;
                 }
             }
             for(i=0;i<bak.length;)
                 delete cache[bak[i++]];
             if(linb.browser.ie6)CollectGarbage();
        },
        $linbid:0,
        _map:{
            'html':1,
            'head':1,
            'body':1
        },
        _ff:function(n){return document.getElementsByTagName(n)[0]},
        _ensureValues:function(obj){
            var t,i,a,map=this._map,fun=this._ff,
            //can't be obj, or opera will crash
            arr = window===obj ? [window] :
                    document===obj ? [obj] :
                    obj.constructor == Array ? obj :
                    obj['linb.Dom'] ? obj._nodes :
                    obj._toDomElems?obj._toDomElems():
                    typeof obj == 'function' ? obj() :
                    typeof obj!='string' ? [obj] :
                    obj.charAt(0)=='{' ? linb.SC(obj.slice(1,obj.length-1)).getAll().reBoxing()._nodes :
                    [obj]
            ;
            //for performance
            //Can't input mix value
            if(arr[0] && !arr[0].nodeType){
                a=[];
                //can't be e, or opera will crash
                for(i=0;i<arr.length;i++)
                    if( t = typeof (t=arr[i])=='string' ? map[t]? fun(t):document.getElementById(t) : t ? t.nodeType ? t : (t['linb.UIProfile']||t['linb.Template']) ? t.domNode ? t.domNode : (t.boxing().render() && t.domNode) : t===window ? t : 0 : 0)
                        a[a.length]=t;
            }else
                a=arr;
            for(i=0;t=a[i++];)
                if(t.nodeType==1){
//                    if(!t.id)t.id=_.id();
                    if(!t.$id)t.$id='$'+this.$linbid++;
                }
            return a.length<=1?a:this._unique(a);
        },
        getStyle:function(node, name){
            if(node.nodeType != 1)return '';

            var value,b;
            if(name=='opacity' && linb.browser.ie)
                b = name = 'filter';

            value= node.style[name];
            if(!value){
                var me = arguments.callee,t,
                map = me.map || (me.map = {'float':1,'cssFloat':1,'styleFloat':1}),
                c1 = me._c1 || (me._c1={}),
                c2 = me._c2 || (me._c2={}),
                name = c1[name] || (c1[name] = name.replace(/\-(\w)/g, function(a,b){return b.toUpperCase()})),
                name2 = c2[name] || (c2[name] = name.replace(/([A-Z])/g, "-$1" ).toLowerCase())
                ;
                if(map[name])
                    name = linb.browser.ie?"styleFloat":"cssFloat";
                //document.defaultView first, for opera 9.0
                value = ((t=document.defaultView) && t.getComputedStyle)?(t=t.getComputedStyle(node,null))?t.getPropertyValue(name2):'':(node.currentStyle&&(node.currentStyle[name]||node.currentStyle[name2]));
/*
                if(linb.browser.opr){
                    var map2 = me.map2 || (me.map2={left:1,top:1,right:1,bottom:1});
                    if(map2[name] && (linb.Dom.getStyle(node,'position')=='static'))
                        value = 'auto';
                }
*/
            }
            return b?value?(parseFloat(value.match(/alpha\(opacity=(.*)\)/)[1] )||0)/100:1:(value||'');
        },
        setStyle:function(node, name , value){
            if(node.nodeType != 1)return;
            if(typeof name == 'string'){
                var me=this.getStyle,
                c1 = me._c1 || (me._c1={}),
                r1 = me._r1 || (me._r1=/alpha\([^\)]*\)/ig);
                name = c1[name] || (c1[name] = name.replace(/\-(\w)/g, function(a,b){return b.toUpperCase()}));
                if(name=='opacity'){
                    value=parseFloat(value)||0;
                    value= value >0.9999 ? '' : linb.browser.ie ? "alpha(opacity="+ 100*value +")" : value;
                    if(linb.browser.ie){
                        node.zoom=1;
                        name='filter';
                        value = node.style.filter.replace(r1, "") + value;
                    }
                }
                node.style[name]=value;
            }else
                for(var i in name)
                    arguments.callee.call(this,node, i, name[i]);
        },
        _setPxStyle:function(node, key, value){
            if(node.nodeType != 1)return false;
            var style=node.style;
            if(value || value===0){
                value = ((''+parseFloat(value))==(''+value)) ? (parseInt(value)||0) + "px" : value +'';
                if((key=='width'||key=='height') && value.charAt(0)=='-')value='0';
                if(style[key]!=value){
                    style[key]=value;
                    return true;
                }
            }return false;
        },
        _matrixid:"linb.matrix::",
        /* Get available DOM matrix(a special empty DOM div)
         sequence: Number, sequence number. Default is 1;
            e.g. 2 => get the second available matrix
        */
        getEmptyDiv:function(sequence){
            var i=1,id,style,o,t,count=0,doc=document,body=doc.body,ini=function(o){
                o.id=id;
                linb([o]).attr('style','position:absolute;visibility:hidden;overflow:visible;left:'+linb.Dom.HIDE_VALUE+';top:'+linb.Dom.HIDE_VALUE+';');
            };
            sequence=sequence || 1;
            while(1){
                id = this._matrixid + i;
                //don't remove this {
                if(o=linb.Dom.byId(id)){
                    //Using firstChild, for performance
                    if(!o.firstChild && ++count == sequence)
                        return linb([o]);
                }else{
                    o=doc.createElement('div');
                    ini(o,id);
                    if(body.firstChild)
                        body.insertBefore(o, body.firstChild);
                    else
                        body.appendChild(o);
                    return linb([o]);
                }
                i++;
            }
        },
        setCover:function(visible,label){
            // get or create first
            var me=arguments.callee,
                id="linb.temp:cover:",
                id2="linb.temp:message:",
                content = typeof visible=='string'?visible:'',
                o1,o2;

            if((o1=linb(id)).isEmpty()){
                linb('body').prepend(o1=linb.create('<div id="'+ id +'" style="position:absolute;display:none;left:0;top:0;background-image:url('+linb.ini.file_bg+')"><div id="'+id2+'" style="position:absolute;font-size:12px"></div></div>'));
                o1.get(0).zIndexIgnore=1;
            }
            o2=linb(id2);

            //clear
            if(!visible){
                if(typeof me._label =='string' && me._label!==label)
                    return;
                if(me._showed){
                    o2.empty(false);
                    o1.css({zIndex:0,cursor:'',display:'none'});
                    me._showed=false;
                }
                delete me._label;
            }else{
                if(typeof label=='string')me._label=label;
                var t = linb.win;
                if(!me._showed){
                    o1.css({zIndex:linb.Dom.TOP_ZINDEX*2,display:'',width:t.scrollWidth()+'px',height:t.scrollHeight()+'px',cursor:'wait'});
                    me._showed=true;
                }
                //show content
                if(content){
                    o2.css({left :t.scrollLeft()+t.width()/2+'px', top: t.scrollTop()+t.height()/2+'px'});
                    o2.html(content +'',false);
                }
            }
        },

        byId:function(id){
            return  document.getElementById(id||"");
        },
        $hasEventHandler:function(node, name){
            return !!(node[name] || (node.getAttribute && node.getAttribute(name)));
        },
        /*
        action: uri
        data:hash{key:value}
        method:'post'(default) or 'get'
        target: uri target: _blank etc.
        */
        submit:function(action, data, method, target, enctype){
            data=_.isHash(data)?data:{};method=method||'get';action=action||'';target=target||'_blank';
            var _t=[];
            _.each(data,function(o,i){
                _t.push('<textarea name="'+i+'">'+(typeof o=='object'?_.serialize(o):o)+'</textarea>');
            });
            if(!_.isEmpty(data))_t.push('<input type="hidden" name="rnd" value="'+_()+'">');
            var d=_.str.toDom('<form target="'+target+'" action="'+action+'" method="'+method  + (enctype?'" enctype="' +enctype:'') +  '">'+_t.join('')+'</form>');
            linb.Dom.getEmptyDiv().append(d);
            d.get(0).submit();
            d.remove();
        },
        busy:function(label){
            linb.Dom.setCover(true,label);
        },
        free:function(label){
           linb.Dom.setCover(false,label);
        },
        animate:function(css, args, onStart, onEnd, time, step, type, threadid){
            var node = document.createElement('div');
            _.merge(css,{position:'absolute', left:this.HIDE_VALUE, zIndex:this.TOP_ZINDEX+10});
            linb.Dom.setStyle(node, css);
            document.body.appendChild(node);
            return linb([node]).animate(args, onStart, function(){
                _.tryF(onEnd);
                if(node.parentNode)
                    node.parentNode.removeChild(node);
            }, time, step, type, threadid);
        },
        //plugin event function to linb.Dom
        $enableEvents:function(name){
            if(!(name instanceof Array))name=[name];
            var self=this,f;
            _.arr.each(name,function(o){
                f=function(fun, label, flag){
                    if(typeof fun  == 'function')
                        return this.$addEvent(o, fun, label, flag);
                    else if(fun===null)
                        return this.$removeEvent(o, label, flag);
                    var args = arguments[1] || {};
                    args.$all = (arguments[0]===true);
                    return this.$fireEvent(o, args)
                };
                f.$event$=1;
                self.plugIn(o, f)
            });
        }
    },
    After:function(d){
        var self=this;
       //getter
        _.each({ parent:['y',false], prev:['x',false], next:['x',true], first:['y',true], last:['y',1]},function(o,i){
            self.plugIn(i, function(index){
                return this.$iterator(o[0], o[1], true, index || 1)
            });
        });

        //readonly profile
        _.arr.each(_.toArr('offsetLeft,offsetTop,scrollWidth,scrollHeight'),function(o){
            self.plugIn(o,function(){
                var t=this.get(0),w=window,d=document;
                if(t==w||t==d){
                    if("scrollWidth"==o||"scrollHeight"==o){
                        var a=d.documentElement,b=d.body;
                        return Math.max(a[o], b[o]);
                    }else
                        t = linb.browser.contentBox ? d.documentElement : d.body;
                }
                return t[o];
            })
        });

        var p='padding',m='margin',b='border',c='inner',o='offset',r='outer',w='width',h='height',W='Width',H='Height',T='Top',L='Left',t='top',l='left',R='Right',B='Bottom';
        //dimesion
        _.arr.each([['_'+p+'H',p+T,p+B],
            ['_'+p+'W',p+L,p+R],
            ['_'+b+'H',b+T+W,b+B+W],
            ['_'+b+'W',b+L+W,b+R+W],
            ['_'+m+'W',m+L,m+R],
            ['_'+m+'H',m+T,m+B]
        ],function(o){
            //use get Style dir
            var node,fun=linb.Dom.getStyle;
            self.plugIn(o[0],function(){
                node = this.get(0);
                return (parseInt(fun(node, o[1])) + parseInt(fun(node, o[2]))) || 0;
            })
        });
        /*
        get W/H for

        1:width
        2:innerWidth
        3:offsetWidth
        4:outerWidth

        content-box
        +--------------------------+
        |margin                    |
        | +----------------------+ |
        | |border                | |
        | | +------------------+ | |
        | | |padding           | | |
        | | | +--------------+ | | |
        | | | |   content    | | | |
        |-|-|-|--------------|-|-|-|
        | | | |<-css width ->| | | |
        | | |<-  innerWidth  ->| | |
        | |<--  offsetWidth   -->| |
        |<--    outerWidth      -->|

        border-box
        +--------------------------+
        |margin                    |
        | +----------------------+ |
        | |border                | |
        | | +------------------+ | |
        | | |padding           | | |
        | | | +--------------+ | | |
        | | | |   content    | | | |
        |-|-|-|--------------|-|-|-|
        | | |<-   css width  ->| | |
        | | |<-  innerWidth  ->| | |
        | |<--  offsetWidth   -->| |
        |<--    outerWidth      -->|
        */

        _.arr.each([['_W',w, '_'+p+'W', '_'+b+'W', '_'+m+'W', c+W, o+W],
        ['_H',h, '_'+p+'H', '_'+b+'H', '_'+m+'H', c+H, o+H]],function(o){
            self.plugIn(o[0],function(node,index,value){
                var n,r,t,style=node.style,me=arguments.callee,contentBox=linb.browser.contentBox,
                r1=me.r1 || (me.r1=/%$/),
                getStyle=linb.Dom.getStyle,
                f=linb.Dom._setPxStyle,type=typeof value,t1;
                if(type=='undefined' || type=='boolean'){
                    if(value===true){
                        n=(getStyle(node,'display')=='none');
                        if(n){
                            var temp = linb.Dom.getEmptyDiv().html('*',false);
                            linb([node]).swap(temp);
                            var b,p,d;
                            b = style.visibility,p = style.position,d = style.display; p=p||'';b=b||'';d=d||'';
                            style.visibility = 'hidden'; style.position ='absolute';style.display = 'block';
                        }
                    }
                    switch(index){
                        case 1:
                            r=getStyle(node,o[1]);
                            if(isNaN(parseInt(r)) || r1.test(r))
                                r = me(node,2) - (contentBox?linb([node])[o[2]]():0);
                            r=parseInt(r)||0;
                            break;
                        case 2:
                            r=node[o[6]]-linb([node])[o[3]]();
                            break;
                        case 3:
                            //for in firefox, offsetHeight/Width's bad performance
                            //if(node._bp)
                            //    r=node['_'+o[6]];
                            //else{
                            //    t1=_();
                                r=node[o[6]];
                            //    if(_()-t1>60){
                            //        node['_'+o[6]]=r;
                            //        node._bp=1;
                            //    }
                            //}
                            if(!r)
                                //get from css setting before css applied
                                r=me(node,1)+(contentBox?(t=linb([node]))[o[2]]():0)+t[o[3]]();
                            break;
                        case 4:
                            r=me(node,3);
                            r+=linb([node])[o[4]]();
                            break;
                    }
                    if(n){
                        style.display = d; style.position = p;style.visibility = b;
                        linb([node]).swap(temp);
                        temp.empty(false);
                    }
                    return parseInt(r)||0;
                }else{
                    switch(index){
                        case 1:
                            if(f(node, o[1], value))
                                if(linb.Dom.$hasEventHandler(node,'onsize')){
                                    var args={};args[o[1]]=1;
                                    linb([node]).onSize(true, args);
                                }
                            break;
                        case 2:
                            me(node, 1, value - (contentBox?linb([node])[o[2]]():0));
                            break;
                        case 3:
                            //back value for offsetHeight/offsetWidth slowly
                            me(node, 1, value - (t=linb([node]))[o[3]]() - (contentBox?t[o[2]]():0));
                            break;
                        case 4:
                            me(node, 1, value - (t=linb([node]))[o[4]]() - t[o[3]]() - (contentBox?t[o[2]]():0));
                            break;
                    }
                    //if(node._bp)
                    //    node['_'+o[6]]=null;
                }
            })
        });
        _.arr.each([[c+W,'_W',2],[o+W,'_W',3],[r+W,'_W',4],
         [c+H,'_H',2],[o+H,'_H',3],[r+H,'_H',4]],function(o){
            self.plugIn(o[0],function(value){
                var type=typeof value;
                if(type=='undefined' || type=='boolean')
                    return this[o[1]](this.get(0), o[2]);
                else
                    return this.each(function(v){
                        this[o[1]](v, o[2],value);
                    });
            })
        });
        _.arr.each([[l+'By',l],[t+'By',t],[w+'By',w],[h+'By',h]],function(o){
            self.plugIn(o[0],function(offset,triggerEvent){
                if(offset===0)return this;
                var m,args,k=o[1],fun=linb.Dom.getStyle;
                return this.each(function(node){
                    m=fun(node,k);
                    m=(parseInt(m)||0)+offset;
                    if(k=='width'||k=='height')m=m>0?m:0;
                    node.style[k]=m+'px';
                    if(triggerEvent){
                        args={};args[k]=1;
                        var f=linb.Dom.$hasEventHandler;
                        if((k=='left' || k=='top')&& f(node,'onlocation'))
                            linb([node]).onLocation(true, args);
                        if((k=='width' || k=='height')&& f(node,'onsize')){
                            linb([node]).onSize(true, args);
                        }
                    }
                },this)
            });
        });
        _.arr.each(['scrollLeft','scrollTop'],function(o){
            self.plugIn(o,function(value){
                if(value !==undefined)
                    return this.each(function(v){
                        v[o]=value;
                    });
                else{
                    var v=this.get(0);
                    if(v===window || v===document){
                        var a=document.documentElement,b=document.body;
                        if("scrollTop"==o)return window.pageYOffset || Math.max(a[o], b[o]);
                        if("scrollLeft"==o)return window.pageXOffset || Math.max(a[o], b[o]);
                    }
                    return v[o];
                }
            })
        });
        _.arr.each('width,height,left,top'.split(','),function(o){
            self.plugIn(o,function(value){
                var self=this, node=self._nodes[0],b=linb.browser,type=typeof value,doc=document,t;
                if(!node || node.nodeType==3)return;
                if(type=='undefined'||type=='boolean'){
                    if((o=='width' && (t='Width'))||(o=='height' && (t='Height'))){
                        if(doc===node)return Math.max( doc.body['scroll'+t], doc.body['offset'+t], doc.documentElement['scroll'+t], doc.documentElement['offset'+t]);
                        if(window===node)return b.opr?(doc.body['client'+t]||window['inner'+t]):b.kde?window['inner'+t]:(linb.browser.contentBox && doc.documentElement['client'+t]) ||doc.body['client'+t];
                    }
                    //give shortcut
                    if(o=='width')value=parseInt(node.style.width)||self._W(node,1,value);
                    else if(o=='height')value=parseInt(node.style.height)||self._H(node,1,value);
                    else
                        value = linb.Dom.getStyle(node, o);
                    return value=='auto'?value:(parseInt(value)||0);
                }else{
                    var f=linb.Dom._setPxStyle,t,a;
                    return self.each(function(v){
                        if(v.nodeType!=1)return;
                            if(v.style[o]!==value){
                                if(o=='width')self._W(v,1,value);
                                else if(o=='height')self._H(v,1,value);
                                else{
                                    if(f(v, o, value))
                                        if((o=='top' || o=='left') && linb.Dom.$hasEventHandler(node,'onlocation')){
                                            a={};a[o]=1;
                                            linb([v]).onLocation(true, a);
                                        }
                                }
                            }
                    });
                }
            });
        });

        //linb.Dom event
        _.arr.each(linb.Event._events,function(o){
            _.arr.each(linb.Event._getEventName(o),function(o){
                self.$enableEvents(o);
            })
        });
    },
    Initialize:function(){
        linb.win=linb([window]);
        linb.doc=linb([document]);
        linb.$inlineBlock=linb.browser.gek?['-moz-inline-block', '-moz-inline-box','inline-block'] : linb.browser.ie6? ['inline-block', 'inline'] : 'inline-block',
        //hot keys
        linb.doc.onKeydown(function(p,e){
            var event=linb.Event,set,
                ks=event.$keyboard=event.getKey(e);
            if(ks){
                if(ks[0].length==1)ks[0]=ks[0].toLowerCase();
                set = linb.cache.hookKey[ks.join(":")];
                //if hot function return false, stop bubble
                if(set)
//                    try{
                        if(_.tryF(set[0],set[1],set[2])===false){
                            event.stopBubble(e);
                            return false;
                        }
//                    }catch(e){}
            }
            return true;
        },"document")
        .onKeyup(function(p,e){
            delete linb.Event.$keyboard;
        },"document");

        //free memory
        linb.win.afterUnload(function(){
            //unlink link 'App'
            linb.SC.__gc();
            linb.Thread.__gc();
            linb([window, document]).$clearEvent();
            linb('body').empty();
            linb.Dom.__gc();
            _.breakO([linb,Class,_],3);
            window.Class=window.linb=window._=undefined;
        },"window",-1);
    }
});Class('linb.Template','linb.absProfile',{
    Constructor:function(template,properties,events,domId){
        var self=this;
        self.$id = self.$domId = self.KEY + ':' + (self.serialId=self._pickSerialId()) + ':';
        self.domId = typeof domId == 'string'?domId:self.$domId;
        self._links={};
        self.template={'':[['<div></div>'],[]]};
        self.properties={};
        self.events={};
        self.$template={};
        self.link(self.constructor._cache,'self').link(linb._pool,'linb');
        self.box=self.constructor;
        self.boxing=function(){return this};

        if(template)self.setTemplate(typeof template=='string'?{'':template}:template);
        if(events)self.setEvents(events);
        if(properties)self.setProperties(properties);
        return self;
    },
    Instance : {
        rendered:false,
        __gc:function(){
            //no detach event here. so, don't add event using addEventlis...
            //use innerHTML way only
            //template has no memory leak, ignore it when window.unload
            this.destroy();
        },
        _reg:/^\w[\w_-]*$/,
        getRootNode:function(){
            return this.domNode || (this.domNode=document.getElementById(this.domId));
        },
        setDomId:function(id){
            var t=this, c=linb.cache.dom, reg=t._reg;
            //ensure the value
            if(typeof id== 'string' && reg.test(id) && !document.getElementById(id)){
                //delete the original one
                if(t.domId!=t.$domId)delete c[t.domId];
                //set profile's domId
                t.domId=id;
                //change the domNode id value
                if(t.getRootNode())t.getRootNode().id=id;
                //if doesn't create yet, don't set it to linb.cache:
                if(c[t.$domId])c[id]=t;
            }
            return t;
        },
        destroy:function(){
            var self=this,
                t=linb.cache.domId;
            if(self.domNode){
                var me=this.constructor, c=me.c||(me.c=document.createElement('div'));
                c.appendChild(self.domNode);
                self.domNode=null;
                c.innerHTML='';
            }

            (t[self.KEY] || (t[self.KEY]=[])).push(self.serialId);
            delete linb.cache.dom[self.domId];
            delete linb.cache.dom[self.$domId];
            self.unLinkAll();
            _.breakO(self);
        },
        setEvents:function(key,value){
            var self=this;
            if(typeof key == 'object')
                self.events=key;
            else
                self.events[key]=value;
            return self;
        },
        setTemplate:function(key,value){
            var self=this, t=self.template,$t=self.$template,f=self._buildTemplate,h;
            if(typeof key == 'object'){
                self.template=key;
                h={};
                for(var i in key)
                    h[i]=f(key[i]);
                self.$template=h;
            }else if(typeof value == 'string')
                $t[key]=f(t[key]=value);
            else
                $t['']=f(t['']=key);
            return self;
        },
        setProperties:function(key,value){
            var self=this;
            if(typeof key == 'object')
                self.properties=key;
            else
                self.properties[key]=value;
            return self;
        },
        getItem:function(src){
            if(typeof src=='string')src=document.getElementById(src);
            if(!src)return;
            var id=src.getAttribute('evid'), evkey=src.getAttribute('evkey');
            if(!id || !evkey)return;

            var me=arguments.callee,
                f = me.f || (me.f = function(data, evkey, id){
                    var i,o,j,v;
                    for(j in data){
                        o=data[j];
                        if(o  && o.constructor==Array && (evkey==j||evkey.indexOf((data._evkey||j)+'.')===0))
                            for(i=0;v=o[i];i++){
                                if(v._evkey==evkey&&v.id==id)return v;
                                else if(v=f(v,evkey,id)) return v;
                            }
                    }
                });
            return f(this.properties, evkey, id);
        } ,
        _pickSerialId:function(){
            //get id from cache or id
            var arr = linb.cache.domId[this.KEY];
            if(arr && arr[0])return arr.shift();
            return this.constructor._ctrlId.next();
        },
        render:function(){
            var self=this,
                str = self.toHtml(),
                o;
            if(o=self.getRootNode()){
                var b,r = (b=o.previousSibling)?o.previousSibling:o.parentNode;
                if(linb.browser.gek){
                    o.id='';
                    var range = o.ownerDocument.createRange();
                    range.setStartBefore(o);
                    o.parentNode.replaceChild(range.createContextualFragment(str), o);
                }else
                    o.outerHTML=str;
                if(r)
                    self.domNode = b?r.nextSibling:r.firstChild;
            }else{
                var me=this.constructor, c=me.c||(me.c=document.createElement('div'));
                linb.cache.dom[self.domId]=linb.cache.dom[self.$domId]=this;
                self.rendered=true;
                c.innerHTML = str;
                self.domNode = c.removeChild(c.firstChild);
            }
            return self;
        },
        renderOnto:function(node){
            var id,domNode,style='style',t;
            if(typeof node=='string')node=document.getElementById(node);
            id=node.id||(node.id=_.id());
            domNode=this.domNode;
            node.parentNode.replaceChild(domNode,node);

            if(domNode.tabIndex!=node.tabIndex)
                domNode.tabIndex!=node.tabIndex;
            if(node.className)
                domNode.className += node.className;
            if(linb.browser.ie && (t=node.style.cssText))
                domNode.style.cssText += t+'';
            else if(t=node.getAttribute(style))
                domNode.setAttribute(style, (domNode.getAttribute(style)||'') + t);

            this.setDomId(id);
        },
        toHtml:function(properties){
            return this._doTemplate(properties||this.properties||{});
        },
        _buildTemplate:function(str){
            if(typeof str=='string'){
                var me=arguments.callee,
                reg = me._reg || (me._reg=/([^{}]*)\{([\w]+)\}([^{}]*)/g),
                reg2 = me._reg2 || (me._reg2=/(<[^>]+\[\$e\])([^>]*[>])/g),
                obj=[[],[]],
                a0=obj[0],
                a1=obj[1]
                ;
                str=str.replace(reg2,'$1 evid={id} evkey={_evkey}$2');
                str.replace(reg,function(a,b,c,d){
                    if(b)a0[a0.length]=b;
                    a1[a0.length]=a0[a0.length]=c;
                    if(d)a0[a0.length]=d;
                    return '';
                });
                return obj;
            }else
                return str;
        },
        _getEV:function(id, name, src){
            var evs = this.events,
                evkey = src.getAttribute('evkey'),
                evg = evkey&&evs&&evs[evkey]||evs,
                ev = evg&&evg[name];
            return typeof ev=='function'?[ev]:[];
        },
        _doTemplate:function(properties, tag, result){
            if(!properties)return '';

            var self=this, me=arguments.callee,s,t,n,isA = properties.constructor == Array,
            r1=me.r1||(me.r1=/(\[\$e\])/g),
            r2=me.r2||(me.r2=/(^\s*<\w+)(\s|>)(.*)/),
            template = self.$template,
            temp = template[tag||''],
            r = !result;

            result= result || [];
            if(isA){
                if(typeof temp != 'function')temp = me;
                for(var i=0;t=properties[i++];){
                    t._evkey=tag;
                    temp.call(self, t, tag, result);
                }
            }else{
                if(typeof temp == 'function')
                    temp.call(self, properties, tag, result);
                else{
                    tag = tag?tag+'.':'';
                    var a0=temp[0], a1=temp[1];
                    for(var i=0,l=a0.length;i<l;i++){
                        if(n=a1[i]){
                            if(n in properties){
                                t=properties[n];
                                //if sub template exists
                                if(template[s=tag+n])
                                    me.call(self, t, s, result);
                                else
                                    result[result.length]=t;
                            }
                        }else
                            result[result.length]=a0[i];
                    }
                }
            }
            if(r){
                return result.join('')
                    .replace(r1,  '"return linb.Event(arguments[0],this,0,\'' + self.domId +'\')"')
                    .replace(r2, '$1 id="'+self.domId+'" $2$3');
            }
        },
        serialize:function(){
            var self=this,
                s=_.serialize,
                t=linb.absObj.$specialChars,
                properties = _.isEmpty(self.properties)?null:_.clone(self.properties,function(o,i){return !t[(i+'').charAt(0)]});            
            return 'new linb.Template(' + 
            s(self.template||null) + "," + 
            s(properties) + "," + 
            s(_.isEmpty(self.events)?null:self.events) + "," + 
            s(self.$domId!=self.domId?self.domId:null) + 
            ')';
        }
    },
    Static : {
        getFromDomId:function(id){
            var o=linb.cache.dom[id];
            if(o&&o.boxing)return o.boxing();
        },
        _cache:[],
        _ctrlId : new _.id()
    }
});/*
beforeCreated
onCreated
onLoadBaseClass
onIniResource
    iniResource (asy)
beforeIniComponents
    iniComponents (asy)
afterIniComponents
    iniExComs (asy)
onLoadReqiredClass
onReady
onRender
*/

Class('linb.Com',null,{
    Constructor:function(properties, events, host){
        var self=this;
        self._nodes=[];
        self.host=host||self;

        self.properties = properties || {};
        //copy those from class setting
        self.events = _.copy(self.events) || {};
        if(events)
            _.merge(self.events, events, 'all');
    },
    Instance:{
        setHost:function(value, alias){
            this.host=value;
            return value[alias]=this;
        },
        getHost:function(){
            return this.host;
        },
        setProperties:function(key,value){
            var self=this;
            if(!key)
                self.properties={};
            else if(typeof key=='string')
                self.properties[key]=value;
            else
                _.merge(self.properties, key, 'all');
            return self;
        },
        getProperties:function(key){
            return key?this.properties[key]:this.properties;
        },
        setEvents:function(key,value){
            var self=this;
            if(!key)
                self.events={};
            else if(typeof key=='string')
                self.events[key]=value;
            else
                _.merge(self.events, key, 'all');
            return self;
        },
        getEvents:function(key){
            return key?this.events[key]:this.events;
        },

        _fireEvent:function(name, args){
            var t, self=this;
            if(t=self.events[name]){
                if(typeof t=='string')t=self.host[t];
                args=args||[];
                args.splice(0,0,self,self.threadid);
                self.$lastEvent=name;
                if(typeof t=='function')
                    return t.apply(self.host, args);
            }
        },
        _innerCall:function(name){
            var self=this;
            return _.tryF(self[name],[self, self.threadid],self);
        },
        show:function(onEnd,parent,subId,threadid){
            var self=this,f=function(){
                self.render();
                if(self.customAppend)
                    self.customAppend.call(self, parent,subId,threadid);
                else
                    (parent||linb('body')).append(self.getUIComponents(),subId);
                _.tryF(onEnd,[self, threadid],self.host);
            };
            self.threadid=threadid;
            
            if(self.created)
                f();
            else
                self.create(f,threadid);
        },
        render:function(triggerLayOut){
            var self=this;
            self.getUIComponents().render(triggerLayOut);
            self._fireEvent('onRender');
            self.rendered=true;
        },
        create:function(onEnd, threadid){
            //get paras
            var self=this,
                t,funs=[]
                ;
            self.threadid=threadid;

            if(false===self._fireEvent('beforeCreated'))return;
            //if no threadid or threadid doesnt exist, reset threadid to self
            funs.push(function(threadid){
                self.threadid=threadid;
                self._fireEvent('onCreated');
            });
            //base classes
            if((t=self.base) && t.length)
                funs.push(function(threadid){
                    linb.SC.groupCall(self.base,function(key){
                        self._fireEvent('onLoadBaseClass', [key]);
                    },null,threadid);
                });
            //load resource here
            if(self.iniResource)
                funs.push(function(){
                    self._fireEvent('onIniResource');
                    self._innerCall('iniResource');
                });
            //load required class
            if((t=self.required) && t.length)
                funs.push(function(threadid){
                    linb.SC.groupCall(self.required,function(key){
                        self._fireEvent('onLoadReqiredClass', [key]);
                    },null,threadid);
                });
            //inner components
            if(self.iniComponents)
                funs.push(function(){
                    if(false===self._fireEvent('beforeIniComponents'))return;
                    Array.prototype.push.apply(self._nodes, self._innerCall('iniComponents')||[]);
                    self._fireEvent('afterIniComponents');
                });
            //Outer components
            if(self.iniExComs)
                funs.push(function(){
                    self._innerCall('iniExComs');
                });
            //core
            funs.push(function(threadid){
                self.loaded=true;
                //lazy load
                if(self.background)
                    linb.SC.runInBG(self.background);
                self._fireEvent('onReady');
            });
            funs.push(function(threadid){
                _.tryF(onEnd,[self, threadid],self.host);
            });
            //use asyUI to insert tasks
            linb.Thread.observableRun(funs, function(){
                self.created=true;
            },threadid);
        },

        iniComponents:function(){},

//<<<todo:

        requestData:function(group, onEnd, threadid){
            var thread=linb.Thread;
            thread.observableRun(function(t){
                linb.absIO.groupCall(group, null, null, onEnd,thread||t);
            },null,threadid);
        },
        /* build order:
        +-----------+
        |  +-------+|
        |  |  +---+||
        |a |ab|abc|||
        |  |  +---+||
        |  +-------+|
        +-----------+
        1.thread start
        2.build a UI
            build ab UI
                build abc UI
        3.fill a data
            fill ab data
                fill abc data
        4.thread end
        */
        //buid UI
        composeUI:function(onEnd, threadid, flag){
            _.tryF(onEnd);
        },
        //fill data
        fillUI:function(onEnd, threadid, flag){
            _.tryF(onEnd);
        },
//>>>todo end



        getUIComponents:function(){
            var nodes = _.copy(this._nodes),t,k='linb.UI';
            _.filter(nodes,function(o){
                return !!(o.box[k] && !o.box.$noDomRoot);
            });
            return linb.UI.pack(nodes, false);
        },
        getComponents:function(){
            return linb.absObj.pack(_.copy(this._nodes),false);
        },
        setComponents:function(obj){
            var self=this,t;
            _.arr.each(self._nodes,function(o){
                if((t=self[o.alias]) &&t.get(0)==o)
                    delete self[o.alias];
            });
            _.arr.each(self._nodes=obj.get(),function(o){
                self[o.alias]=o.boxing();
            });
            return self;
        },
        destroy:function(threadid){
            var self=this;
            self.threadid=threadid;
            self._fireEvent('onDestroy');
            _.arr.each(self._nodes, function(o){
                if(o.box)
                    o.boxing().destroy();
            });
            self._nodes.length=0;
            _.breakO(self);
        }
    },
    Static:{
        load:function(cls, onEnd, lang, showUI){
            var fun=function(){
                //get app class
                linb.SC(cls,function(path){
                    //if successes
                    if(path){
                        var a=this,f=function(){
                            var o=new a();
                            if(showUI!==false)o.show(onEnd);
                            else _.tryF(onEnd,[o],o);
                        };
                        //get locale info
                        if(lang) linb.reLang(lang, f);
                        else f();
                    }else
                        throw new Error(cls+' doesnt exists!');
                },true);
            };
            if(linb.isDomReady)
                fun();
            else
                linb.main(fun);
        },
        $EventHandlers:{
            beforeCreated:function(com, threadid){},
            onLoadBaseClass:function(com, threadid, key){},
            onIniResource:function(com, threadid){},
            beforeIniComponents:function(com, threadid){},
            afterIniComponents:function(com, threadid){},
            onLoadRequiredClass:function(com, threadid, key){},
            onReady:function(com, threadid){},
            onRender:function(com, threadid){}
        }
    }
});
Class("linb.Cookies", null,{
    Static:{
        set:function(name,value,days,path,domain,isSecure){
	        if(name){
    	        document.cookie = escape(name) + "=" + escape(value) +
    		        (days?";expires="+(new Date((new Date()).getTime()+(24*60*60*1000*days))).toGMTString():"")+
    		        (path?";path="+path:"")+
    		        (domain?";domain="+domain:"")+ 
    		        (isSecure?";secure":"");
    		}
    		return this;
        },
        get:function(name){
        	var i,a,ca = document.cookie.split( "; " );
        	for(i=0;i<ca.length;i++){
        		a=ca[i].split("=");
        		if(a[0]==escape(name))
        		    return a[1]?unescape(a[1]):'';
        	}
        	return null;
        },
        remove:function(name){
        	return this.set(name,"",-1).set(name,"/",-1);
        }
    }
});/*
profile input:
===========================
    [dragType]: String , "move","copy","deep_copy","shape","icon","blank" and "none", default is "shape"
        "blank": moves a empty proxy when mouse moves
        "move": moves target object directly when mouse moves
        "copy": moves a copy of target object when mouse moves
        "deep_copy": moves a deep copy of target object when mouse moves
        "shape": moves a shape of target object when mouse moves
        "icon": moves a icon that represents target object when mouse moves
        "none": moves mouse only
-------------------------
    [dragDefer] :  Number, when [linb.DragDrop.startDrag] is called, the real drag action will be triggered after [document.onmousemove] runs [dragDefer] times, default is 0;
-------------------------
    [magneticDistance]: Number,
    [xMagneticLines]: Array of Number,
    [yMagneticLines]: Array of Number,
        Magnetic setting:
        yMagneticLines 1                      2                     3
              |                      |                     |       xMagneticLines
          ----+----------------------+---------------------+-------1
              |                      |                     |
              |                      |                     |
              |                      |                     |
              |                      |                     |
          ----+----------------------+---------------------+-------2
              |                      |                     |
              |                      |                     |
              |                      |                     |
          ----+----------------------+---------------------+-------3
              |                      |                     |

        magneticDistance
         +-------------
         |*************
         |*************
         |**
         |**
         |**
-------------------------
    [widthIncrement]: Number,
    [heightIncrement]: Number,
        Increment setting:
                   widthIncrement
               <-------------------->
              |                      |                     |
          ----+----------------------+---------------------+-------
              |                      |                     |
heightIncrement|                      |                     |
              |                      |                     |
              |                      |                     |
          ----+----------------------+---------------------+-------
              |                      |                     |
              |                      |                     |
              |                      |                     |
              |                      |                     |
          ----+----------------------+---------------------+-------
              |                      |                     |
              |                      |                     |
-------------------------
    [horizontalOnly]: Number,
    [verticalOnly]: Number,
    horizontalOnly
    ------------------------------------------
                ****************
                ****************
                ****************
                ****************
                ****************
                ****************
    ------------------------------------------
    verticalOnly
               |                |
               |                |
               |****************|
               |****************|
               |****************|
               |****************|
               |****************|
               |****************|
               |                |
               |                |
-------------------------
    [maxBottomOffset]: Number,
    [maxLeftOffset]: Number,
    [maxRightOffset]: Number,
    [maxTopOffset]: Number,
        you can set the limited offset region
        +----------------------------------------------+
        |              |                               |
        |              |maxTopOffset                   |
        |<------------>****************<-------------->|
        |maxLeftOffset**************** maxRightOffset  |
        |              ****************                |
        |              ****************                |
        |              ****************                |
        |              ****************                |
        |              |maxBottomOffset                |
        |              |                               |
        +----------------------------------------------+
-------------------------
    [targetReposition]: <bool>,

    //ini pos and size
    [targetLeft]: Number
    [targetTop]: Number
    [targetWidth]: Number
    [targetHeight]: Number
    [targetCSS]: <object>
        You can set position and size when drag start:
                      targetLeft
                      |
                      |
        targetTop  ---**************** |
                      **************** |
                      **************** |
                      **************** |targetHeight
                      **************** |
                      **************** |
                     |<--targetWidth ->+
-------------------------
    //properties
    [dragCursor]: <string>
-------------------------
    //for drag data
    [dragKey]
    [dragData]

profile output: readonly
===========================
linb.DragDrop.getProfile():
    x  :current X value of mouse;
    y  :current Y value of mouse;
    ox: mouse original X when drag start;
    oy: mouse original Y when drag start;
    curPos:{left:xx,top:xx}: current css pos of the dragging node;
    offset : {x:,y}: offset from now to origin
    restrictedLeft : Number
    restrictedRight : Number
    restrictedTop : Number
    restrictedBottom : Number
    isWorking: Bool.
    proxyNode: linb.Dom object,
    dropElement: String, DOM element id.
*/
Class('linb.DragDrop',null,{
    Static:{
        _eh:"_dd",
        _id:"linb.dd:proxy:",
        _idi:"linb.dd:td:",
        _type:{blank:1,move:1,shape:1,deep_copy:1,copy:1,icon:1,none:1},
        _Icons:{none:'top', move:'-16px', link:'-32px',add:'-48px'},
        _profile:{},

        //get left for cssPos
        _left:function(value){
            with(this._profile){
                if(magneticDistance>0 && xMagneticLines.length){
                    var l=xMagneticLines.length;
                    while(l--)
                        if(Math.abs(value - xMagneticLines[l])<=magneticDistance)
                            return xMagneticLines[l];
                }
                if(widthIncrement>1)
                   return Math.floor(value/widthIncrement)*widthIncrement;
                return value;
            }
        },
        //get top for cssPos
        _top:function(value){
            with(this._profile){
                if(magneticDistance>0 && yMagneticLines.length){
                    var l=yMagneticLines.length;
                    while(l--)
                        if(Math.abs(value - yMagneticLines[l])<=magneticDistance)
                            return yMagneticLines[l];
                }
                if(heightIncrement>1)
                    return Math.floor(value/heightIncrement)*heightIncrement;
                return value;
            }
        },

        _ini:function(o){
            var d=this,p=d._profile,_t=linb.win;

            d._box = { width :_t.width()+_t.scrollLeft(),  height :_t.height()+_t.scrollTop()};

            p.ox = p.x;
            p.oy = p.y;

            if(d._proxy = o){
                d._proxystyle=o.get(0).style;

                //ini cssPos here
                d._profile.curPos = d._cssPos= d._proxy.cssPos();

                d._cssPos_x = p.x - d._cssPos.left;
                d._cssPos_y = p.y - d._cssPos.top;

                p.restrictedLeft = p.x - (p.maxLeftOffset||0);
                p.restrictedRight =  p.x + (p.maxRightOffset||0);
                p.restrictedTop = p.y - (p.maxTopOffset||0);
                p.restrictedBottom = p.y + (p.maxBottomOffset||0);

                //here
                d._proxyLeft = d._pre.left = d._cssPos.left;
                d._proxyTop = d._pre.top = d._cssPos.top;

                if("move" !== p.dragType)
                    d._proxy.css('zIndex',linb.Dom.TOP_ZINDEX*10);
            }

        },
        _reset:function(){
            var d=this,NULL=null,FALSE=false;
            //reset
            _.tryF(d.$reset);
            d.setDropFace();
            d._resetProxy();

            d.$proxySize=50;
            //event
            d.$mousemove=d.$mouseup=d.$onselectstart=d.$ondragstart='*';

            //reset private vars
            d._cursor='';
            d._pre={};
            d._proxyLeft=d._proxyTop=d._cssPos_x=d._cssPos_y=0;
            d._stop=FALSE;
            d._cssPos=d._box=d._dropElement=d._source=d._proxy=d._proxystyle=d._onDrag=d._onDragover=NULL;

            //reset profile
            d._profile={
                dragType:'shape',
                dragCursor:'move',
                targetReposition:true,

                dragIcon:linb.ini.path+'ondrag.gif',
                magneticDistance:0,
                xMagneticLines:[],
                yMagneticLines:[],
                widthIncrement:0,
                heightIncrement:0,
                dragDefer:0,

                horizontalOnly:FALSE,
                verticalOnly:FALSE,
                maxBottomOffset:NULL,
                maxLeftOffset:NULL,
                maxRightOffset:NULL,
                maxTopOffset:NULL,

                targetNode:NULL,
                targetCSS:NULL,
                dragKey:NULL,
                dragData:NULL,
                targetLeft:NULL,
                targetTop:NULL,
                targetWidth:NULL,
                targetHeight:NULL,
                targetOffsetParent:NULL,

                shadowFrom:NULL,

                //Cant input the following items:
                proxyNode:NULL,
                x:0,
                y:0,
                ox:0,
                oy:0,
                curPos:{},
                offset:{},
                isWorking:FALSE,
                restrictedLeft:NULL,
                restrictedRight:NULL,
                restrictedTop:NULL,
                restrictedBottom:NULL,
                dropElement:NULL
            };
            return d;
        },
        abort:function(){
            this._stop=true;
        },
        _end:function(){
            var d=this,doc=document;

            if(d._proxy) d._unpack();

            //must here
            //if bak, restore
            if(d.$onselectstart!='*')doc.body.onselectstart=d.$onselectstart;
            if(d.$ondragstart!='*')doc.ondragstart=d.$ondragstart;
            //if bak, restore
            if(d.$mousemove!='*')doc.onmousemove=d.$mousemove;
            if(d.$mouseup!='*')doc.onmouseup=d.$mouseup;

            return  d;
        },
        startDrag:function(e, targetNode, profile, dragKey, dragData){
            var d=this;
            profile=_.isHash(profile)?profile:{};

            //clear
            d._end()._reset();

            e = e || window.event;
            // not left button
            if(linb.Event.getBtn(e) !== 'left')
               return true;

            d._source = profile.targetNode = linb(targetNode);
            d._cursor = d._source.css('cursor');

            if(!profile.targetNode.id())profile.targetNode.id(_.id(),true);

            //must set here
            d._defer = profile.dragDefer = _.isNumb(profile.dragDefer) ? profile.dragDefer : 0;
            if(true===profile.dragCursor)profile.dragCursor=d._cursor;
            if(typeof profile.dragIcon == 'string') profile.dragType="icon";

            var doc=document, _pos = linb.Event.getPos(e);
            profile.x = _pos.left;
            profile.y = _pos.top;

            profile.dragKey= dragKey || profile.dragKey || null;
            profile.dragData= dragData  || profile.dragData|| null;
            
            var fromN=linb.Event.getSrc(e);

            d._start=function(e){
//ie6: mousemove - mousedown =>78 ms
//delay is related to window size, weird
            //                  try{
                var p=d._profile;
                //set profile
                _.merge(p, profile, "with");

                //call event, you can call abort(set _stoop)
                d._source.beforeDragbegin();

                if(p.isWorking || d._stop){d._end()._reset();return false}

                //set linb.Event._preDropable at the begining of drag, for a dd from a child in a dropable node
                if(linb.Event)linb.Event._preDropable=d._source.get(0).id;

                //set default icon
                if(p.dragType=='icon')p.targetReposition=false;

                //ini
                d._ini(p.dragType=='none'?null:d._pack(_pos, p.targetNode));
                // on scrollbar
                if(profile.x >= d._box.width  || profile.y >= d._box.height ){d._end()._reset();return true}

                //set isWorking flag
                p.isWorking = true;

                d._source.onDragbegin();

                //set back first
                if(p.dragDefer<1){
                    d.$mousemove = doc.onmousemove;
                    d.$mouseup = doc.onmouseup;
                }
                //avoid setcapture
                if(linb.browser.ie)
                    setTimeout(function(){fromN.releaseCapture()});

                //back up
                doc.onmousemove = d.$onDrag;
                doc.onmouseup = d.$onDrop;
                //for events
                d._source.afterDragbegin();
                //for delay, call ondrag now
                if(p.dragDefer>0)d.$onDrag.call(d, e);
            //                  }catch(e){d._end()._reset();}
            };
            if(linb.browser.ie){
                d.$ondragstart=doc.ondragstart;
                d.$onselectstart=doc.body.onselectstart;
                doc.ondragstart = doc.body.onselectstart = null;
                if(doc.selection)_.tryF(doc.selection.empty);
            }

            //avoid select
            linb.Event.stopBubble(e);

            //fire document onmousedown event
            if(profile.targetNode.get(0)!==doc)
                linb(doc).onMousedown(true, linb.Event.getEventPara(e));

            if(profile.dragDefer<1){
                _.tryF(d._start,[e],d);
                return false;
            }else{
                //for mouseup before drag
                d.$mouseup = doc.onmouseup;
                doc.onmouseup = function(e){
                    linb.DragDrop._end()._reset();
                    return _.tryF(document.onmouseup,[e],null,true);
                };
                //for mousemove before drag
                d.$mousemove = doc.onmousemove;
                var pbak={};
                doc.onmousemove = function(e){
                    var p=linb.Event.getPos(e);
                    if(p.left===pbak.left&&p.top===pbak.top)return;
                    pbak=p;
                    if(--d._defer<=0)linb.DragDrop._start(e);
                    return false;
                };
            }
//ie6: mousemove - mousedown =>78 ms
        },
        $onDrag:function(e){
            var d=linb.DragDrop,p=d._profile;

           //try{
                e = e || window.event;
                //set _stop or in IE, show alert
                if((!p.isWorking) || d._stop || (linb.browser.ie && (!e.button) )){
                    d.$onDrop(e);
                    return true;
                }

                var _pos=linb.Event.getPos(e);
                p.x=_pos.left;
                p.y=_pos.top;

                if(!p.isWorking)return false;

                if(d._proxy){
                    if(!p.verticalOnly){
                        d._proxyLeft=Math.floor(d._left(
                            ((p.maxLeftOffset!==null||p.maxRightOffset!==null)?
                                ((p.x<=p.restrictedLeft)?p.restrictedLeft:(p.x>=p.restrictedRight)?p.restrictedRight:p.x):
                                p.x)
                            - d._cssPos_x)
                        );
                        if(d._proxyLeft-d._pre.left)
                            d._proxystyle.left=d._proxyLeft+'px';
                        d._pre.left=d._proxyLeft;
                        p.curPos.left = d._proxyLeft + d.$proxySize;
                    }
                    if(!p.horizontalOnly){
                        d._proxyTop=Math.floor(d._top(
                            ((p.maxTopOffset!==null||p.maxBottomOffset!==null)?
                                ((p.y<=p.restrictedTop)?p.restrictedTop:(p.y>=p.restrictedBottom)?p.restrictedBottom:p.y):
                                p.y)
                            - d._cssPos_y)
                        );
                        if(d._proxyTop-d._pre.top)
                            d._proxystyle.top=d._proxyTop+'px';
                        d._pre.top=d._proxyTop;
                        p.curPos.top = d._proxyTop + d.$proxySize;
                    }
                }else{
                    p.curPos.left = p.x;
                    p.curPos.top = p.y;
                    //style='none', no dd.current dd._pre provided
                    //fireEvent
                    //d._source.onDrag(true); //shortcut for mousemove
                }
                if(d._onDrag!=1){
                    if(d._onDrag)d._onDrag(e);
                    else{
                        //ensure to run once only
                        d._onDrag=1;
                        //if any ondrag event exists, this function will set _onDrag
                        d._source.onDrag(true,linb.Event.getEventPara(e));
                    }
                }
            //}catch(e){linb.DragDrop._end()._reset();}finally{
               return false;
            //}
        },
        $onDrop:function(e){
            var d=linb.DragDrop,p=d._profile,evt=linb.Event;
//                try{
                e = e || window.event;

                // opera 9 down with
                // if(!isWorking){evt.stopBubble(e);return false;}
                d._end();
                if(p.isWorking){
                    var r = d._source.onDragstop(true,evt.getEventPara(e));
                    if(d._dropElement)
                        linb([d._dropElement]).onDrop(true,evt.getEventPara(e));
                }
//                }catch(a){}finally{
                d._reset();
                evt.stopBubble(e);
                _.tryF(document.onmouseup,[e]);
                return !!r;
//                }
        },
        setDropElement:function(src){
            this._profile.dropElement=(this._dropElement=src) && src.id;
            return this;
        },
        getProfile:function(){
            var d=this,p=d._profile;
            p.offset=d._proxy
            ?
            { x : d._proxyLeft-p.ox+d._cssPos_x,  y : d._proxyTop-p.oy+d._cssPos_y}
            :
            { x : p.x-p.ox,  y : p.y-p.oy}
            ;
            return p;
        },
        setDropFace:function(target, dragIcon){
            var d=this,
                s1='<div style="position:absolute;z-index:'+linb.Dom.TOP_ZINDEX+';font-size:0;line-height:0;border-',
                s2=":dashed 1px #ff6600;",
                region=d._Region,rh=d._rh,
                bg='backgroundColor';
            if(region && region.parent())
                region.remove(false);
            if(d._R){
                d._R.css(bg, d._RB);
                delete d._R;
                delete d._RB;
            }

            if(target){
                if(!region){
                    region=d._Region=linb.create(s1+'top'+s2+'left:0;top:0;width:100%;height:0;"></div>'+s1+'right'+s2+'right:0;top:0;height:100%;width:0;"></div>'+s1+'bottom'+s2+'bottom:0;left:0;width:100%;height:0;"></div>'+s1+'left:solid 2px #ff6600;width:0;left:0;top:0;height:100%;"></div>');
                    rh=d._rh=linb([region.get(1),region.get(3)]);
                }target=linb(target);
                if(linb.browser.ie6)rh.height('100%');
                if(target.css('display')=='block'){
                    target.append(region);
                    if(linb.browser.ie6 && !rh.get(0).offsetHeight)
                        rh.height(target.get(0).offsetHeight);
                }else{
                    d._RB = target.get(0).style[bg];
                    d._R=target;
                    target.css(bg, '#FA8072');
                }
                d.setDragIcon(dragIcon||'move');
            }else
                d.setDragIcon('none');
            return d;
        },
        setDragIcon:function(key){
            //avoid other dropable targetNode's setDropFace disturbing.
            _.resetRun('setDropFace', null);
            var d=this,p=d._profile,i=p.proxyNode,ic=d._Icons;
            if(i && p.dragType=='icon')
                i.first(4).css('backgroundPosition', 'left ' + (ic[key]||ic.none));
            return d;
        },
        _setProxy:function(child, pos){
            var t,temp,d=this,p=d._profile,dom=linb.Dom;
            if(!dom.byId(d._id))
                linb('body').prepend(
                    //&nbsp; for IE6
                    linb.create('<div id="' + d._id + '" style="left:0;top:0;border:0;font-size:0;line-height:0;padding:'+d.$proxySize+'px; position: absolute;"><div style="font-size:0;line-height:0;" id="' +d._idi+ '">'+(linb.browser.ie6?'&nbsp;':'')+'</div></div>')
                );
            t=linb(d._id);
            if(p.dragKey){
                d.$proxySize=0;
                t.css('padding',0);
            }else{
                pos.left -=  d.$proxySize;
                pos.top -= d.$proxySize;
                if(!p.targetOffsetParent)
                    dom.setCover(true);
            }
            if(temp=p.targetOffsetParent)
                linb(temp).append(t);

            if(child){
                linb(d._idi).empty(false).append(child);
                p.proxyNode = child;
            }else
                p.proxyNode = linb(d._idi);
            t.css({display:'',zIndex:dom.TOP_ZINDEX*10,cursor:p.dragCursor}).offset(pos, temp);

            return t;
        },
        _resetProxy:function(){
            var d=this, p=d._profile,
                dom=linb.Dom,
                id1=d._id,
                id2=d._idi;
            if(dom.byId(id1)){
                var t,k,o=linb(id2),t=linb(id1);
                //&nbsp; for IE6
                if(linb.browser.ie6)
                    o.html('&nbsp;',false);
                else o.empty(false);
                o.attr('style','font-size:0;line-height:0;');

                linb('body').prepend(
                    t
                    .css({
                        zIndex:0,
                        cursor:'',
                        display:'none',
                        padding:d.$proxySize+'px'
                    })
                );
                p.proxyNode=d._proxystyle=null;
                dom.setCover(false);
            }
        },
        _pack:function(mousePos,targetNode){
            var target, pos={}, size={}, d=this, p=d._profile, t;
            // get abs pos (border corner)
            if(p.targetLeft===null || null===p.targetTop)
                t=targetNode.offset(null, p.targetOffsetParent);
            pos.left = null!==p.targetLeft?p.targetLeft: t.left;
            pos.top = null!==p.targetTop?p.targetTop: t.top;

            switch(p.dragType){
                case 'deep_copy':
                case 'copy':
                   var t;
                    size.width =  _.isNumb(p.targetWidth)? p.targetWidth:(targetNode.cssSize().width||0);
                    size.height = _.isNumb(p.targetHeight)?p.targetHeight:(targetNode.cssSize().height||0);
                    var n=targetNode.clone(p.dragType=='deep_copy').id('', true).css({position:'relative',cursor:p.dragCursor,margin:0,'cssFloat':'none'}).cssSize(size);
                    n.css('opacity',0.5);
                    if(p.targetCSS)
                        n.css(p.targetCSS);
                    n.cssPos({margin:'0',left:'0',top:'0'}).query().id('',true);
                    target = d._setProxy(n,pos);
                    break;
                case 'shape':
                    // get size
                    size.width = null!==p.targetWidth?p.targetWidth:targetNode.offsetWidth();
                    size.height = null!==p.targetHeight?p.targetHeight:targetNode.offsetHeight();
                    size.width-=2;size.height-=2;
                    target = d._setProxy(
                        linb.create('div').css({border:'dashed 1px',fontSize:'0',lineHeight:'0'}).cssSize(size)
                        ,pos);
                    break;
                case 'blank':
                    target = d._setProxy(null,pos);
                    break;
                case 'icon':
                    pos.left=_.isNumb(p.targetLeft)?p.targetLeft:(mousePos.left - linb.win.scrollLeft() + 16);
                    pos.top=_.isNumb(p.targetTop)?p.targetTop:(mousePos.top - linb.win.scrollTop() + 16);
                    t='<table border="0"><tr><td valign="top"><span style="background:url('+p.dragIcon+') no-repeat left top;width:'+(_.isNumb(p.targetWidth)?p.targetWidth:16)+'px;height:'+(_.isNumb(p.targetHeight)?p.targetHeight:16)+'px;" ></span></td><td id="linb:dd:shadow" '+(p.shadowFrom?'style="border:solid 1px #e5e5e5;"':'')+'>'+(p.shadowFrom?linb(p.shadowFrom).clone(true).cssPos({left:'auto',top:'auto',padding:0,margin:0}).outerHTML().replace(/\s*id\=[^\s\>]*/g,''):'')+'</td></tr></table>';
                    target = d._setProxy(linb.create(t), pos);
                    break;
                case 'move':
                    d.$proxySize=0;
                    target=targetNode;
                    if(target.css('position') != 'absolute')
                        target.css('position','absolute').offset(pos);
                    target.css('cursor',p.dragCursor);
            }

            return target;
        },
        _unpack:function(){
            var d=this, p=d._profile, t,f;
            if(p.targetReposition && ("move" != p.dragType)){
                if((t=linb(d._source)))
                    if(!t.isEmpty()){
                        if(t.css('position')!= 'absolute')
                            t.css('position','absolute').cssPos(t.offset(null,t.get(0).offsetParent ));

                        //for ie bug
                        if(linb.browser.ie)
                            t.cssRegion({right:'auto',bottom:'auto'});
                        t.offset(p.curPos, p.targetOffsetParent||document.body);
                    }
            }
            if("move" == p.dragType)
                d._source.css('cursor',d._cursor);
        },
        _unRegister:function(id, key){
            var o=linb(id), eh=this._eh;
            o.$removeEvent('beforeMouseover', eh)
              .$removeEvent('beforeMouseout', eh)
              .$removeEvent('beforeMousemove', eh)
            ;
            o.each(function(o){
                var c = linb.cache.dom[o.id];
                if(c=c.nodeVars)delete c._dropKeys;
                o._dropKeys=null;
            });
        },
        _register:function(id, key){
            var o=linb(id),eh=this._eh;
            o.beforeMouseover(function(){
                var t=linb.DragDrop,p=t._profile,self=this;
                if(p.dragKey && self._dropKeys[p.dragKey]){
                    t.setDropElement(self);
                    t._onDragover=null;
                    linb([self]).onDragenter(true);
                    if(t._dropElement)_.resetRun('setDropFace', t.setDropFace, 0, [self], t);
                }
            }, eh);
            o.beforeMouseout(function(){
                var t=linb.DragDrop,p=t._profile,self=this;
                 if(p.dragKey && self._dropKeys[p.dragKey]){
                    linb([self]).onDragleave(true);
                    t.setDropElement(t._onDragover=null);
                    _.resetRun('setDropFace', t.setDropFace, 0, [null], t);
                }
            }, eh)
            .beforeMousemove(function(a,e){
                var t=linb.DragDrop, h=t._onDragover, p=t._profile,self=this;
                //no dragover event
                if(h==1)return;
                if(t._dropElement==self && p.dragKey && self._dropKeys[p.dragKey]){
                    if(h)h(e);
                    else{
                        //ensure to run once only
                        t._onDragover=1;
                        //if any dragover event exists, this function will set _onDragover
                        linb([self]).onDragover(true,linb.Event.getEventPara(e));
                    }
                }
            }, eh);
            o.each(function(o){
                //attach a hash to dom targetNode
                (o._dropKeys || (o._dropKeys={}))[key]=true;
                var c = linb.cache.dom[o.id].nodeVars._dropKeys=1;
            });
            return this;
        }
    },
    After:function(){
        this._reset();
        //add dom dd functions
        _.each({
            startDrag:function(e, profile, dragKey, dragData){
                linb.DragDrop.startDrag(e, this.get(0), profile, dragKey||'', dragData||null);
                return this;
            },
            dragable:function(flag, profile, dragKey, dragData){
                var self=this, dd=linb.DragDrop;
                if(flag===undefined)
                    flag=true;
                else if(typeof flag=='object'){
                    profile=flag;
                    flag=true;
                }
                if(!!flag)
                    self.$addEvent('onMousedown',function(p,e){
                        if(linb.Event.getSrc(e)!=this)return true;
                        linb([this]).startDrag(e, profile, dragKey, dragData)
                    }, dd._eh, -1);
                else
                    self.$removeEvent('onMousedown', dd._eh);

                return self;
            },
            dropable:function(flag, key){
                if(flag===undefined)flag=true;
                key = key || 'default';
                var d=linb.DragDrop;
                return this.each(function(o){
                    if(!!flag)
                        d._register(o, key);
                    else
                        d._unRegister(o, key);
                });
            }
        },function(o,i){
            linb.Dom.plugIn(i,o);
        });
    }
});//singleton
Class("linb.Tips", null,{
    Constructor:function(){return null},
    Initialize:function(){
        var dd=linb.DragDrop,
            tips=this;
        if(dd)
            dd.$reset=function(){
                tips._pos={left:dd._profile.x,top:dd._profile.y}
            };

        //for: span(display:-moz-inline-box) cant wrap in firefox
        linb.CSS.addStyleSheet(
            ".linb-tips{font-size:0;line-height:0;position:absolute;overflow:visible;} "+
            ".linb-tips-i{font-size:12px;overflow:hidden;}"+
            ".linb-tips-i span{display:inline;}"
        , this.KEY);

        linb.doc
        .afterMousedown(function(){
            tips._cancel();
        },'$Tips',-1)
        .afterMousemove(function(obj, e, src){
            if(dd.isWorking)return;
            var event=linb.Event,
                p,n;

            //if ready to show in settimeout(resetRun)
            if((p=_.resetRun.$cache) && p['$Tips'])
                tips._pos=event.getPos(e);

            //it's first show
            if(tips._from){
                _.resetRun('$Tips3', null);
                tips._showF();
            //after show, before hide
            }else if(tips._showed && tips.MOVABLE){
                p=event.getPos(e);
                n=tips._Node.style;
                n.left = (parseInt(n.left)||0) + (p.left-tips._pos.left) +'px';
                n.top = (parseInt(n.top)||0) + (p.top-tips._pos.top) +'px';
                tips._pos=p;
            }
        },'$Tips',-1)
        .afterMouseover(function(obj, e, src){
            var event=linb.Event,
                rt=event.$FALSE,
                node=event.getSrc(e),
                id,
                rn = e.fromElement||e.relatedTarget,
                _from,
                tempid,evid,
                index=0,
                pass
            ;

            if(!node)
                return rt;
            try{
                //for inner renderer
                while((!node.id || node.id==linb.$langId) && node.parentNode!==document && index++<10)
                    node=node.parentNode;
                if(!(id=node.id))
                    return rt;
            }catch(e){}

            //check id
            if((_from=event._getProfile(id)) && _from.box && _from.KEY=='linb.UIProfile'){
                //if onShowTips exists, use custom tips id region, or use item region
                tempid=_from.onShowTips?id:id.replace(event._reg,'$1$3$4');
                if(tips._markId && tempid==tips._markId)
                    return rt;

                //set mark src id
                tips._markId = tempid;
                tips._pos=event.getPos(e);
                
                if(tips._showed){
                    tips._from=_from;
                    tips._enode=node;
                    tips._showF();
                }else
                    _.resetRun('$Tips', function(){
                        tips._from=_from;
                        tips._enode=node;
                        _.resetRun('$Tips3', function(){
                            if(tips._from)
                                tips._showF();
                        },100);
                    }, tips.DELAYTIME);
            }else
                tips._cancel();

            return rt;
        },'$Tips',-1)
        .afterMouseout(function(obj, e, src){
            if(tips._markId){
                var event=linb.Event,
                    id,
                    tempid,
                    evid,
                    _from=tips._from,
                    clear,
                    index=0,
                    node = e.toElement||e.relatedTarget;

                if(!node)
                    clear=1;
                else{
                    //for firefox wearing anynomous div in input/textarea
                    try{
                        //for inner renderer
                        while((!node.id || node.id==linb.$langId) && node.parentNode!==document && index++<10)
                            node=node.parentNode;
                        if(!(id=node.id))
                            clear=1
                    }catch(e){clear=1}
                }
                if(clear)
                    tips._cancel();
                else
                    tempid=(_from && _from.onShowTips)?id:id.replace(event._reg,'$1$3$4');

                return event.$FALSE;
            }
        },'$Tips',-1);

        this._Types = {
            'default' : new function(){
                this._r=/(\$)([\w\.]+)/g;
                this.show=function(item, pos, key){
                    //if trigger onmouseover before onmousemove, pos will be undefined
                    if(!pos)return;

                    var self=this,node,_ruler,s,w,h;
                    if(!(node=self.node)){
                        node = self.node = linb.create('<div class="linb-tips"><div class="linb-tips-i"></div></div>');
                        _ruler = self._ruler = linb.create('<div class="linb-tips" style="position:absolute;visibility:hidden;left:-10000px;"><div class="linb-tips-i" style="position:relative;"></div></div>');
                        self.n = node.first();
                        self._n = _ruler.first();
                        if(typeof node.addShadow == 'function'){
                            node.addShadow();
                            _ruler.addShadow();
                        }
                        linb('body').append(_ruler);
                    }
                    _ruler = self._ruler;
                    //ensure zindex is the top
                    if(document.body.lastChild!=node.get(0))
                        linb('body').append(node);

                    s = typeof item=='object'? item[key||linb.Tips.TIPSKEY] :item ;
                    if(typeof s=='function')
                        s=s();
                    if(s+=""){
                        var html=/^\s*\</.test(s);
                        //get string
                        s=s.replace(self._r, function(a,b,c){
                            return linb.getRes(c);
                        });
                        linb.Tips._curTips=s;
                        if(!item.transTips || !html)
                            s='<div style="border:solid gray 1px;background-color:#FFF8DC;padding:1px 2px 2px 2px;">'+s+'</div>';
                        //set to this one
                        self._n.get(0).innerHTML=s;

                        //get width
                        w=_ruler.get(0).offsetWidth;
                        if(!html)
                            w=Math.min(tips.MAXWIDTH, w);

                        //set content, AND dimension
                        var style=node.get(0).style, t1=self.n.get(0), t2,styleI=t1.style;
                        //hide first
                        style.visibility='hidden';
                        //set content
                        t1.innerHTML=s;
                        //set dimension
                        if(linb.browser.ie){
                            style.width=styleI.width=w+(w%2)+'px';
                            h=t1.offsetHeight;
                            style.height=h-(h%2)+'px';
                        }else
                            styleI.width=w+'px';

                        //pop(visible too)
                        node.popToTop({left:pos.left,top:pos.top,region:{
                            left:pos.left,
                            top:pos.top-12,
                            width:24,height:32
                        }},1);
                    }else
                        node.css('zIndex',0).hide();
                };
                this.hide = function(){
                    this.node.css('zIndex',0).hide();
                };
            }/*,
            'animate' : new function(){
                this.threadid='$tips:1$';
                this.show=function(item, pos){
                    if(!this.node){
                        this.node = linb.create('<div style="position:absolute;border:solid gray 1px;background-color:#FFFACD;font-size:12px;padding:3px;overflow:hidden;"></div>');
                        linb('body').append(this.node);
                    }
                    pos.left+=12;
                    pos.top+=12;
                    var s=item.tips;
                    s = s.charAt(0)=='$'?linb.wrapRes(s.slice(1)):s;
                    this.node.html(s).css('zIndex',linb.Dom.TOP_ZINDEX).cssPos(pos);
                    var w=this.node.width(),h=this.node.height();
                    this.node.cssSize({ width :0, height :0}).css('display','block').animate({width:[0,w],height:[0,h]},0,0,240,8,'outexp',this.threadid).start();
                };
                this.hide = function(){
                    linb.Thread.abort(this.threadid);
                    this.node.height('auto').width('auto').css('display','none').css('zIndex',0);
                };
            }*/
        };
    },
    Static:{
        TIPSKEY:'tips',
        MAXWIDTH:300,
        MOVABLE:true,
        DELAYTIME:200,
        AUTOHIDETIME:5000,

        _showF:function(){
            var self=this,
                _from=self._from,
                node=self._enode,
                pos=self._pos,
                id,
                o,t,b=false;

            self._from=self._enode=null;

            if(!node || !_from || !pos || !(o=_from.box))return;

            //keep older
            self._pos=pos;
            //1.CF.showTips
            b=((t=_from.CF) && (t=t.showTips) && t(_from, node, pos));
            //2._showTips / onShowTips
            //check if showTips works
            if(!b)b=(o._showTips && o._showTips(_from, node, pos));

            //default tips var(profile.tips > profile.properties.tips)
            if(!b && ((t=_from) && t.tips)||(t && (t=t.properties) && (t.tips))){
                self.show(pos, t);
                b=true;
            }

            //no work hide it
            if(!b)self.hide();
            else {
                if(!self.MOVABLE)
                    _.resetRun('$Tips2', self.hide,self.AUTOHIDETIME,null,self);
            }
        },
        getTips:function(){
            return this._curTips;
        },
        show:function(pos, item, key){
            var self=this,t;
            //for mousemove
            self._pos=pos;
            //same item, return
            if(self._item === item)return;

            //hide first
            //if(self._tpl)self._tpl.hide();

            //base check
            if(typeof item =='string' || (item && (item[key||linb.Tips.TIPSKEY]))){
                //get template
                t = self._tpl = self._Types[item.tipsTemplate] || self._Types['default'];
                t.show(item,pos,key);
                self._Node=t.node.get(0);
                self._item=item;
                self._showed = true;
            }else
                self._cancel();
        },
        hide:function(){
            var self=this;
            if(self._showed){
                if(self._tpl)self._tpl.hide();
                self._clear();
            }
        },
        _cancel:function(){
            var self=this;
            if(self._markId){
                if(self._showed)
                    self.hide();
                else{
                    _.resetRun('$Tips', null);
                    _.resetRun('$Tips3', null);
                    self._clear();
                }
            }            
        },
        _clear:function(){
            var self=this;
            self._curTips=self._markId = self._from=self._tpl = self._item = self._showed = null;
        }
    }
});Class("linb.History",null,{
    Static:{
        _fid:'linb:history',
        /* set callback function
        callback: function(hashStr<"string after #">)
        */
    	setCallback: function(callback){
    	    var self=this;
    		self._callback = callback;
    		var hash = location.hash;
            if(callback){
        		self._lastFI = hash;
        		if(linb.browser.ie) {
        			if(self._lastFI=='')self._lastFI = '#';
    
                    var n=document.createElement("div");
                    n.style.display = "none";
                    document.body.appendChild(n);
        			n.innerHTML = '<iframe id="'+this._fid+'" style="display: none;"></iframe>';
        			var ihistory = document.getElementById(this._fid), iframe = ihistory.contentWindow.document;
        			iframe.open();
        			iframe.close();
        			iframe.location.hash = hash;
        		}else if(linb.browser.kde) {
        			// etablish back/forward stacks
        			self.backStack = [];
        			self.backStack.length = history.length;
        			self.forwardStack = [];
        		}
        		self._callback(hash.replace(/^#/, ''));
                clearInterval(self._itimer);
                self._itimer = setInterval(self._timer,100);
            }else
                clearInterval(self._itimer);

    		return self;
    	},
        //cross case=>
	    //  1: goto another url, and back
	    //  2: back to another url, and forward
        //check location.hash change periodically
    	_timer: function(){
    	    var self=linb.History;
    	    if(typeof self._callback!='function'){
    	        clearInterval(self._itimer);
    	        return;
    	    }

    		if(linb.browser.ie) {
    		    var ihistory = document.getElementById(self._fid), iframe = ihistory.contentWindow.document;
    			hash = iframe.location.hash;
    			if(hash != self._lastFI) {
    				self._lastFI = location.hash = hash;
    				self._callback(hash.replace(/^#/, ''));
    			}
    		}else if(linb.browser.kde) {
    			if(!self.dontCheck) {
    			    var backStack=self.backStack,
    			        forwardStack=self.forwardStack,
    				    historyDelta = history.length - backStack.length;
    				//for back button or forward button
    				if(historyDelta) {
                        //back button case
    					if(historyDelta<0)
    						for (var i = 0; i < Math.abs(historyDelta); i++) forwardStack.unshift(backStack.pop());
    					//forward button case
    					else
    						for (var i = 0; i < historyDelta; i++) backStack.push(forwardStack.shift())
    					
    					var cachedHash = backStack[backStack.length-1];
    					if (cachedHash !== undefined) {
    						self._lastFI = location.hash;
    						self._callback(cachedHash);
    					}else{
    					    //cross case=>
    					}
    				}else if(backStack[backStack.length-1]===undefined){
    				    if(self._lastFI != location.hash){
    				        //cross case=>
        				    self._lastFI = location.hash;
        				    self._callback(location.hash);
        				}
    				}
    			}
    		}else{
    			// otherwise, check for location.hash
    			var hash = location.hash;
    			if(hash != self._lastFI) {
    				self._lastFI = hash;
    				self._callback(hash.replace(/^#/, ''));
    			}
    		}
    	},
    	getFI:function(){
    	    return this._lastFI;
    	},
        /*change Fragement Identifier(string after '#')
        */
    	setFI:function(fi,triggerCallback){
    	    var self=this;
    	    if(!self._callback)return;
    	    if(fi)fi=fi.replace(/^#+/,'');
            if(self._lastFI == '#' + fi)return false;

    		if(linb.browser.ie) {
    			var ihistory = document.getElementById(self._fid), iframe = ihistory.contentWindow.document;
                iframe.open();
    			iframe.close();
    			iframe.location.hash = location.hash = self._lastFI = '#' + fi;
    		}else if(linb.browser.kde) {
    			self.dontCheck = true;
        		self.backStack.push(fi);
        		self.forwardStack.length = 0;
    			var t=self;
    			_.asyRun(function(){t.dontCheck=false;t=null;},300);
    			location.hash = self._lastFI = fi;
    		}else
    		    location.hash = self._lastFI = '#' + fi;
            if(triggerCallback!==false)
		        _.tryF(self._callback,[fi]);
    	}
    },
	Initialize:function(){
        //hook link(<a ...>xxx</a>) click action
        if(linb.browser.ie || linb.browser.kde)
            linb.doc.onClick(function(p,e,src){
                var s = location.href.split('#')[0],
                    t=linb.Event,
                    o = t.getSrc(e),b,i=0,
                    b
                ;
                do{
                    if(o.tagName == 'A'){
                        b=true;
                        break;
                    }
                    if(++i>8)break;
                }while(o=o.parentNode)
                if(b){
                    if(o.href.indexOf('javascript:')==0)return false;
                    if(!t.getKey(e)[2] && t.getBtn(e)=='left' && (o.href.indexOf(s+'#')==0||o.href.indexOf('#')==0)){
                        linb.History.setFI(o.href.replace(s,''));
                        return false;
                    }
                }
            },'hookA',0);
	}
});Class('linb.ComFactory',null,{
    Static:{
        _pro:{},
        _cache:{},
        _domId:'linb:ComFactory:',
        getProfile:function(key){
            return key?this._pro[key]:this._pro;
        },
        setProfile:function(key, value){
            if(typeof key=='string')
                this._pro[key]=value;
            else
                this._pro=key;
            return this;
        },
        destroyAll:function(){
            _.each(this._cache,function(o){
                _.tryF(o.destroy,[],o);
            });
            this._cache={};
        },
        broadcast:function(fun){
            if(typeof fun=='function'){
                var i,c=this._cache;
                for(i in c)
                    fun.call(c[i],i);
            }
        },

        setCom:function(id, obj){
            this._cache[id]=obj;
            if(obj)obj.comRefId=id;
            return this;
        },
        getComFromCache:function(id){
            return this._cache[id]||null;
        },
        //singleton:false->don't get it from cache, and don't cache the result.
        getCom:function(id, onEnd, threadid, singleton){
            singleton=singleton!==false;
            var c=this._cache,p=this._pro,ini=p._iniMethod;
            if(singleton && c[id]){
                _.tryF(onEnd, [threadid,c[id]], c[id]);
                return c[id];
            }else{
                if(!(p=p[id]))return null;
                var self=arguments.callee, me=this, children=p.children;
                //ensure array
                var iniMethod = p.iniMethod || ini || 'create',
                    clsPath = p.cls || p,
                    properties = p.properties,
                    events = p.events,
                    singleton=p.singleton!==false,
                    cls,
                    task=function(cls,properties,threadid){
                        var o = new cls();
                        if(properties)
                            _.merge(o.properties,properties,'all');
                        if(events)
                            _.merge(o.events,event,'all');

                        if(singleton)
                            linb.ComFactory.setCom(id, o);

                        var args = [function(com){
                            var arr = com.getUIComponents().get(),
                                fun=function(arr,firstlayer){
                                    var self1 = arguments.callee;
                                    _.arr.each(arr,function(v,i){
                                        //if tag exists, replace tag with com from linb.ComFactory
                                        if(v.key=='linb.UI.Tag'){
                                            var tag=v, cid=tag.properties.tagKey;

                                            if(cid && children && children[cid])
                                                self.apply(me, [children[cid], function(){
                                                    //set link to parent com(linb.Com)
                                                    com[cid]=this;
                                                    //set com parent
                                                    this.parent=com;

                                                    //replace tag with this
                                                    var ui = this.getUIComponents(), root;
                                                    // no UI in this com
                                                    if(!(root=ui.get(0)))return;

                                                    linb.UI.Tag.replace(tag,root,firstlayer?com:null);
                                                },threadid]);
                                        }
                                        if(v.children){
                                            var a=[];
                                            _.arr.each(v.children,function(o){
                                                a[a.length]=o[0];
                                            });
                                            self1(a);
                                        }
                                    });
                                };
                            //handle tag sub from com
                            fun(arr,1);
                        }];
                        args.push(threadid||null);

                        //insert first
                        if(onEnd)
                            linb.Thread(threadid).insert({
                                task:onEnd,
                                args:[threadid,o],
                                scope:o
                            });
                        //latter
                        _.tryF(o[iniMethod], args, o);
                    };
                linb.Thread.observableRun(function(threadid){
                        var f=function(a,b,threadid){
                            var cls;
                            if(cls=linb.SC.get(clsPath)){
                                linb.Thread(threadid).insert({
                                    task:task,
                                    args:[cls, properties, threadid]
                                });
                            }
                        };
                        linb.SC(clsPath, function(path){
                            if(path)
                                f(0,0,threadid);
                            else
                                throw new Error(cls+' doesnt exists!');
                        }, true,threadid);

                    },null,threadid
                );
            }
        },
        newCom:function(cls, onEnd,threadid){
            var o=linb.SC.get(cls);
            o=typeof o == 'function' ?new o():null;
            if(o)
                _.tryF(onEnd,[threadid,o],o);
            else
                linb.Thread.observableRun(function(threadid){
                    linb.SC(cls, function(path,txt){
                        if(path){
                            var o=linb.SC.get(cls);
                            o=typeof o == 'function' ?new o():null;
                            _.tryF(onEnd,[threadid,o],o);
                        }else
                             throw new Error(cls+' doesnt exists!');
                    }, true,threadid);
                },null,threadid);
        },
        storeCom:function(id){
            var m,t,c=this._cache,domId=this._domId;
            if(t=c[id]){
                if(!(m=linb.Dom.byId(domId)))
                    //using display:none here for performance, when appendchild, it'll not trigger layout etc.
                    linb('body').prepend(linb.create('<div id="'+domId+'" style="display:none;"></div>'));
                m=linb(domId);
                t=t.getUIComponents();
                if(!t.isEmpty()){
                    //detach
                    t.get(0).unlinkParent();
                    //move to hide
                    m.append(t);
                }
            }
        },

        //prepare widget (build css string and add css to head, build template)
        prepareWidgets:function(){
            //prepare UI Ctrl
            var self=this,
                fun=function(threadid){
                    var r=false;
                    _.each(linb.UI, function(o){
                        if(o.$linb$ && o['linb.UI'] && o.$Appearances['default']){
                            var path = linb.getPath(o.KEY, '/default/css.css','appearance');
                            if(!linb.UI.$cache_csspath[path]){
                                o=(new o).get(0);
                                o.toString();
                                o.destroy();
                                r=true;
                                return false;
                            }
                        }
                    });
                    if(!r)linb.Thread(threadid).abort()
                };
            linb.Thread(null,[fun],100,null,null,null,true).start();
            return this;
        },
        prepareComs:function(arr){
            var self=this,funs=[];
            _.arr.each(arr, function(i){
                funs.push(function(){
                    self.getCom(i);
                });
            });
            linb.Thread(null, funs, 500).start();
            return this;
        }
    }
});Class('linb.Debugger', null, {
    Static:{
        $time:_(),
        _id1:'linb:dbg::_frm',
        _id4:'linb:dbg::_head',
        _id2:'linb:dbg::_con',
        _id3:'linb:dbg::_inp',
        err:function(sMsg,sUrl,sLine){
            if(linb.browser.gek && sMsg=='Error loading script')
                return true;
            linb.Debugger.log( '*** An error raised ***', ' >> Location: '+ sUrl + ' ( line ' + sLine + ' )', ' >> Message: '+sMsg);
        },
        trace:function(obj){
            var args=arguments,
                fun=args[1]||arguments.callee.caller,
                arr=args[2]||[];
            if(fun){
                arr.push('function "' + (fun.$name$||'') + '" in Class "' + (fun.$original$||'') +'"');
                if(fun.caller){
                    try{
                        arguments.callee(null,fun.caller,arr,1);
                    }catch(e){}
                }
            }
            if(!args[3]){
                var a=[];
                a.push(' >> Object Info:');
                if(typeof obj == 'object')
                    for(var i in obj)
                        a.push(' -- ' + i + " : " + obj[i]);
                else
                    a.push(obj);
                a.push(' >> Function Trace: ' + arr.join(' <= '));
                linb.Debugger.log.apply(linb.Debugger,a);
            }
        },
        log:function(){
            var t1,t2,time,self=this,arr=arguments,str;
            if(!arr.length)return;

            t1 = document.createElement("div");
            t2 = document.createElement("div");
            t2.className='linb-dbg-con1';
            time=_();
            t2.appendChild(document.createTextNode('Time stamp : '+time +'('+(time-self.$time)+')' ));
            self.$time=time;
            t1.appendChild(t2);
            for(var i=0,l=arr.length;i<l;i++){
                str=arr[i];
                t2 = document.createElement("div");
                t2.className='linb-dbg-con2';
                t2.appendChild(document.createTextNode(" "+_.serialize(_.isArguments(str)?_.toArr(str):str)));
                t1.appendChild(t2);
            }

            if(!linb.Dom.byId(self._id2)){
                var ns=linb.create('<div id='+self._id1+' style="left:5px;top:'+(linb.win.scrollTop()+5)+'px;" class="linb-dbg-frm"><div class="linb-dbg-box"><div id='+self._id4+' class="linb-dbg-header">&nbsp;&nbsp;:&nbsp;)&nbsp;&nbsp;jsLINB Debug Window <span class="linb-dbg-cmds"><a href="javascript:;" onclick="linb(\''+self._id2+'\').empty(false);">Clear</a><a href="javascript:;" onclick="linb(\''+self._id1+'\').remove();"> &Chi; </a></span></div><div id='+self._id2+' class="linb-dbg-content"></div><div class="linb-dbg-tail"><table><tr><td style="font-family:serif;">&nbsp;>>>&nbsp;</td><td style="width:100%"><input id='+self._id3+' /></td></tr></table></div></div></div>');
                linb('body').append(ns);
                self.$con=linb(self._id2);
                linb(self._id4).onMousedown(function(p,e){
                    if(linb.Event.getSrc(e)!=this)return;
                    linb(this).parent(2).startDrag(e);
                });

                if(linb.browser.ie6)ns.height(ns.offsetHeight());
                if(ns.addShadow)ns.addShadow();
                var bak='',temp;
                linb(self._id3).onKeydown(function(p,e,s){
                    var k=linb.Event.getKey(e)[0];
                    if(k=='enter'){
                        switch(s.value){
                            case '?':
                            case 'help':
                                self.$con.append(linb.create("<div class='linb-dbg-con3'><p><strong>vailable commands:</strong></p><ul><li> -- <strong>[clr]</strong> or <strong>[clear]</strong> : clears the message</li><li> -- <strong>[?]</strong> or <strong>[help]</strong> : shows this message</li><li> -- <strong>any other</strong>: shows its string representation</li></ul></div>"));
                                break;
                            case 'clr':
                            case 'clear':
                                linb(self._id2).empty();
                                break;
                            default:
                                try{
                                    temp=s.value;
                                    if(/^\s*\x7b/.test(temp))temp='('+temp+')';
                                    self.log(eval(temp));
                                }catch(e){self.$con.append(linb.create("<div  class='linb-dbg-con4'>"+String(e)+"</div>"));return;}
                        }
                        bak=s.value;
                        s.value='';
                    }else if(k=='up'||k=='down'){
                        var a=s.value;
                        s.value=bak||'';
                        bak=a;
                    }
                });
            }
            self.$con.append(t1).scrollTop(self.$con.scrollHeight());
        }
    },
    Initialize:function(){
        //window.onerror=(linb.browser.gek && window.console)?null:this.err;

        linb.CSS.addStyleSheet(
            '.linb-dbg-frm{position:absolute;width:300px;z-index:2000;}'+
            '.linb-dbg-header{cursor:move;height:18px;padding-top:2px;position:relative;border-bottom:solid 1px #CCC;background-color:#FFAB3F;font-weight:bold;}'+
            '.linb-dbg-cmds{position:absolute;right:2px;top:2px;}'+
            '.linb-dbg-cmds a{margin:2px;}'+
            '.linb-dbg-box{position:relative;overflow:hidden;border:solid 1px #AAA;}'+
            '.linb-dbg-content{position:relative;width:100%;overflow:auto;height:300px;background:#fff;}'+
            '.linb-dbg-con1{background-color:#CCC}'+
            '.linb-dbg-con2{padding-left:6px;border-bottom:dashed 1px #CCC}'+
            '.linb-dbg-con3{padding-left:6px;border-bottom:dashed 1px #CCC;background:#EEE;color:#0000ff;}'+
            '.linb-dbg-con4{padding-left:6px;border-bottom:dashed 1px #CCC;background:#EEE;color:#ff0000;}'+
            '.linb-dbg-tail{overflow:hidden;position:relative;border-top:solid 1px #CCC;height:16px;background:#fff;color:#0000ff;}'+
            '.linb-dbg-tail input{width:100%;border:0;background:transparent;}'
        ,this.KEY);
        //fix ie6:

        //shorcut
        linb.log = function(){
            if(linb.browser.gek && window.console)
                console.log.apply(console,arguments);
            linb.Debugger.log.apply(linb.Debugger,arguments);
        };
        linb.message = function(body, head, width, time){
           width = width || 200;
           if(linb.browser.ie)width=width+(width%2);
           var div, h, me=arguments.callee,
           stack=me.stack||(me.stack=[]),
           t=linb.win, left = t.scrollLeft() + t.width()/2 - width/2, height=t.height(), st=t.scrollTop();

           if(!(div=stack.pop())){
               div =
               '<div style="font-size:0;line-height:0;border:solid 1px #cdcdcd;position:absolute;overflow:visible;top:-50px;z-index:'+linb.Dom.TOP_ZINDEX+'; background:#fefefe">' +
               '<div style="font-size:14px;overflow:hidden;font-weight:bold;padding:2px;"></div>'+
               '<div style="padding:5px;overflow:hidden;"></div>'+
               '</div>';
               div = linb.create(div);
               if(div.addBorder)div.addBorder();
               linb('body').append(div);
            }
            div.css({left:left+'px', width:width+'px', visibility:'visible'})
            .first().html(head||'')
            .next().html(body||'');

            if(me.last && div!=me.last){
                var l=me.last.left();
                me.last.animate({left:[l,l+(me.last.width+width)/2+20]},null,null,100,5).start();
            }
            me.last = div;
            me.last.width = width;

            //height() is ok
            h = div.height();

            if(linb.browser.ie6)div.cssSize({ height :h, width :width+2});

            div.animate({top:[st-h-20,st+20]},null,null,100,5,'outexp').start();
            _.asyRun(function(){
                div.animate({top:[st+20, height+20]},null,function(){stack.push(div); div.hide()},100,10).start();
            }, time||5000);
        };
    }
});//Profile Class
Class('linb.Profile','linb.absProfile',{
    Constructor:function(host,key,alias,box,properties,events,options){
        arguments.callee.upper.apply(this,arguments);
        var self=this;
        _.merge(self,options);

        self.key=key||self.key||'';
        self.alias=alias||self.alias||'',
        self.properties=properties||self.properties||{};
        self.events=events||self.events||{};
        self.host=host||self.host||self;
        self.box=box||self.box||self.constructor;
        if(self.events){
            self.setEvents(self.events);
            delete self.events;
        }
        self._links={};
    },
    Instance:{
        setEvents:function(events){
            var evs=this.box.$EventHandlers;
            return _.merge(this,events,'all',function(o,i){return evs[i]});
        },
        getEvents:function(){
            var self=this, t,hash={};
            _.each(self.box.$EventHandlers,function(o,i){
                if(self[i])hash[i]=self[i];
            });
            return hash;
        },
        _applySetAction:function(fun, value){
            return fun.call(this,value);
        },
        __gc:function(){
            this.unLinkAll();
            _.tryF(this.clearCache,[],this);
            var o=_.get(this,['box','_namePool']);
            if(o)delete o[self.alias];
            _.breakO(this);
        },
        boxing:function(){
            //cache boxing
            var self=this, t;
            if(!((t=self.object) && t._nodes[0]==self && t._nodes.length==1))
                t = self.object = self.box.pack([self],false);
            return t;
        },
        serialize:function(rtnString, keepHost){
            var t,
                self = this,
                o = (t=self.box._beforeSerialized)?t(self):self,
                r={
                    alias:o.alias,
                    key:o.key,
                    host:o.host
                };
            //host
            if(r.host===self){
                delete r.host;
            }else if(o.host && !keepHost ){
                if(rtnString!==false)
                    r.host='@this';
                else
                    delete r.host;
            }

            //properties
            var c={}, p=o.box.$DataStruct, map=linb.absObj.$specialChars;
            _.merge(c,o.properties, function(o,i){return (i in p) &&  p[i]!==o && !map[i.charAt(0)]});
            if(!_.isEmpty(c))r.properties=c;

            //events
            if(!_.isEmpty(t=this.getEvents()))r.events=t;
            var eh = o.box.$EventHandlers;
            _.filter(r.events, function(o,i){
                return o!=eh[i];
            });
            if(_.isEmpty(r.events))delete r.events;
            return rtnString===false?r:_.serialize(r);
        }
    }
});
//absObj Class
Class('linb.absObj',"linb.absBox",{
    //properties, events, host
    Constructor:function(){
        arguments.callee.upper.apply(this,arguments);
        //for pack function
        if(arguments[0]!==false && typeof this._ini=='function')
            return this._ini.apply(this,arguments);
    },
    Before:function(key, parent_key, o){
        linb.absBox.$type[key]=key;
        return true;
    },
    After:function(){
        var self=this, me=arguments.callee,
            temp,t,k,u,m,i,j,l,v,n,b;
        self._nameId=0;
        self._namePool={};
        self._nameTag=(t=self.KEY.split('.'))[t.length-1].toLowerCase();
        self._cache=[];

        if(self===linb.absObj || self===linb.absObj)return;

        m=me.a1 || (me.a1=_.toArr('$Keys,$DataStruct,$EventHandlers,$DataModel'));
        for(j=0;v=m[j++];){
            k={};
            if((t=self.$parent) && (i=t.length))
                while(i--)
                    _.merge(k, t[i][v]);
            self[v]=k;
        }

        self.setDataModel(self.DataModel);
        delete self.DataModel;

        self.setEventHandlers(self.EventHandlers);
        delete self.EventHandlers;

        m=me.a5 || (me.a5=_.toArr('RenderTrigger,LayoutTrigger'));
        for(j=0;v=m[j++];){
            temp=[];
             if((t=self.$parent) && (l=t.length))
                for(i=0;i<l;i++){
                    u=t[i]
                    if(u=u['$'+v])
                        temp.push.apply(temp,u);
                }
            if(self[v])
                temp.push(self[v]);
            self['$'+v] = temp;
            delete self[v];
        }
    },
    //don't add any other function or member to absObj
    Static:{
        $abstract:true,
        $specialChars:{_:1,$:1},
        getAll:function(){
          return this.pack(this._cache);
        },
        pickAlias:function(){
            var t,p=this._namePool,a=this._nameTag;
            while(p[t=(a+(++this._nameId))]){}
            return  t;
        },
        setDataModel:function(hash){
            var self=this,
                sc=linb.absObj.$specialChars,
                ds=self.$DataStruct,
                properties=self.$DataModel,
                ps=self.prototype,
                i,j,t,o,n,m,r;

            //merge default value and properties
            for(i in hash){
                if(!properties[i])properties[i]={};
                o=hash[i];
                if(null===o || undefined===o){
                    r=_.str.initial(i);
                    delete ds[i];
                    delete properties[i]
                    delete ps['get'+r];
                    delete ps['set'+r];
                //Here, if $DataModel inherites from it's parent class, properties[i] will pointer to parent's object.
                }else{
                    t=typeof o;
                    if(t!='object' || o.constructor!=Object)
                        o={ini:o};
                    ds[i] = ('ini' in o)?o.ini:(i in ds)?ds[i]:'';

                    t=properties[i];
                    for(j in t)
                        if(!(j in o))
                            o[j]=t[j];
                    properties[i]=o;
                }
            }

            _.each(hash,function(o,i){
                if(null===o || undefined===o || sc[i.charAt(0)])return;
                r=_.str.initial(i);
                //readonly properties
                if(!(o && (o.readonly || o.inner))){
                    //custom set
                    t = o.set;
                    n = 'set'+r;
                    m = ps[n];
                    ps[n] = typeof t=='function' ? Class._fun(t,n,self.KEY) : typeof m=='function' ? m : Class._fun(function(value,flag){
                        return this.each(function(v){
                            if(!v.properties)return;
                            //if same return
                            if(v.properties[i] === value && !flag)return;
                            var ovalue = v.properties[i],
                                m = _.get(v.box.$DataModel, [i, 'action']);
                            v.properties[i] = value;
                            if(typeof m == 'function' && v._applySetAction(m, value, ovalue) === false)
                                v.properties[i] = ovalue;
                        });
                    },n,self.KEY);
                    delete o.set;
                    if(ps[n]!==m)ps[n].$auto$=1;
                }
                if(!(o && o.inner)){
                    // get custom getter
                    t = o.get;
                    n = 'get'+r;
                    m = ps[n];
                    ps[n] = typeof t=='function' ? Class._fun(t,n,self.KEY) : typeof m=='function' ? m : Class._fun(function(){
                        return this.get(0).properties[i];
                    },n,self.KEY);
                    delete o.get;
                    if(ps[n]!==m)ps[n].$auto$=1;
                }
            });
            return self;
        },
        setEventHandlers:function(hash){
            var self=this;
            _.each(hash,function(o,i){
                if(null===o){
                    delete self.$EventHandlers[i];
                    delete self.prototype[i];
                }else{
                    self.$EventHandlers[i]=o;
                    var f=function(fun){
                        var l=arguments.length;
                        if(l==1 && (typeof fun == 'function' || typeof fun == 'string'))
                            return this.each(function(v){
                                if(v.domNode)
                                    v.clearCache();
                                v[i] =fun;
                            });
                        else if(l==1 && null===fun)
                            return this.each(function(v){
                                v.clearCache();
                                delete v[i];
                            });
                        else{
                            var args=[], v=this.get(0), t=v[i], k=v.host || v,j;
                            if(v.$ignore)return;
                            if(arguments[0]!=v)args[0]=v;
                            for(j=0;j<l;j++)args[args.length]=arguments[j];
                            v.$lastEvent=i;
                            if(typeof t=='string')t=k[t];
                            if(typeof t=='function')return _.tryF(t, args, k);
                        }
                    };
                    f.$event$=1;
                    f.$original$=o.$original$||self.KEY;
                    self.plugIn(i,f);
                }
            });
            return self;
        }
    },
    Instance:{
        alias:function(str){
            var self=this,pro=this.get(0),old;
            if(str){
                if(old=pro.alias){
                    if(pro.host){try{delete pro.host[old]}catch(e){pro.host[old]=undefined}}
                    delete self.constructor._namePool[old];
                }
                self.constructor._namePool[pro.alias=str]=1;
                if(pro.host)
                    pro.host[str]=self;
                return self;
            }else
                return pro.alias;
        },
        host:function(value, alias){
            var self=this;
            if(value){
                self.get(0).host=value;
                if(alias){
                    self.alias(alias);
                    value[alias]=self;
                }
                return self;
            }else
                return self.get(0).host;
        }
        /*non-abstract inheritance must have those functions:*/
        //1. destroy:function(){delete this.box._namePool[this.alias];this.get(0).__gc();}
        //2. _ini(properties, events, host, .....){/*set _nodes with profile*/return this;}
        //3. render(){return this}
    }
});
//DataBinder Class
Class("linb.DataBinder","linb.absObj",{
    Instance:{
        _ini:function(properties, events, host){
            var self=this,
                c=self.constructor,
                profile,
                options,
                np=c._namePool,
                alias;
            if(properties && properties['linb.Profile']){
                profile=properties;
                alias = profile.alias || c.pickAlias();
            }else{
                if(properties && properties.key && linb.absBox.$type[properties.key]){
                    options=properties;
                    properties=null;
                    alias = options.alias;
                    alias = (alias&&!np[alias])?alias:c.pickAlias();
                }else
                    alias = c.pickAlias();
                profile=new linb.Profile(host,self.$key,alias,c,properties,events, options);
            }
            np[alias]=1;
            profile._n=profile._n||[];

            //set anti-links
            profile.link(c._cache,'self').link(linb._pool,'linb');

            self._nodes.push(profile);
            return self;
        },
        destroy:function(){
            this.each(function(profile){
                var box=profile.box,name=profile.properties.name;
                //unlink
                _.arr.each(profile._n, function(v){box._unBind(name,v)});
                //delete from pool
                delete box._pool[name];
                //free profile
                profile.__gc();
            });
        },
        resetValue:function(hash){
            return this.each(function(o,i){
                _.arr.each(o._n,function(profile){
                    var p=profile.properties;
                    profile.boxing().resetValue((hash && p.dataField in hash)?hash[p.dataField]:'');
                });
            })
        },
        getUI:function(){
            return linb.UI.pack(this.get(0)._n,false);
        },
        checkValid:function(){
            return linb.absValue.pack(this.get(0)._n,false).checkValid();
        },
        getValue:function(){
            var o=this.get(0);
            if( this.checkValid() ){
                var hash={};
                _.arr.each(o._n,function(profile){
                    var p=profile.properties, b = profile.boxing(),v;
                    if(profile.domNode)b.updateValue();
                    v = b.getValue();
                    hash[p.dataField]=v;
                });
                return hash;
            }else return null;
        },
        host:function(value, alias){
            var self=this;
            if(value && alias)
                self.setName(alias);
            return arguments.callee.upper.apply(self,arguments);
        }
    },
    Static:{
        _pool:{},
        destroyAll:function(){
            this.pack(this._pool,false).destroy();
            this._pool={};
        },
        getFromName:function(name){
            var o=this._pool[name];
            return o && o.boxing();
        },
        _bind:function(name, pro){
            var o=this._pool[name];
            if(!o){
                o=new linb.DataBinder();
                o.setName(name);
                o=o.get(0);
            }
            if(pro && _.arr.indexOf(o._n,pro)==-1)
                //use link for 'destroy UIProfile' trigger 'auto unbind function '
                pro.link(o._n, 'databinder.'+name);
        },
        _unBind:function(name, pro){
            if(this._pool[name])
                pro.unLink('databinder.'+name);
        },
        DataModel:{
            name:{
                set:function(value){
                    var o=this.get(0),
                        ov=o.properties.name;
                    if(ov!==value){
                        var c=linb.DataBinder,
                            _p=c._pool,
                            to=_p[ov],
                            t=_p[value];
                        if(to && t)
                            throw new Error(value+' exists!');

                        _p[o.properties.name=value]=o;
                        //modify name
                        if(to && !t){
                            linb.absValue.pack(o._n).setDataBinder(value);
                            _.arr.each(o._n, function(v){c._unBind(ov,v)});
                        }
                        //pointer to the old one
                        if(t && !to) o._n=t._n;
                        //delete the old name from pool
                        if(to)delete _p[ov];
                    }
                    return this;
                }
            }
        }
    }
});
//UIProfile Class
Class('linb.UIProfile','linb.Profile', {
    Instance:{
        //readonly please
        rendered:false,
        _render:function(){
            var self=this,t,ele=linb.Dom.byId(self.domId);
            //for dynRender
            if(!ele)return;

            //link dom
            self.root = linb([self.domNode = ele]);
            linb.cache.dom[self.domId] = linb.cache.dom[self.$domId] = self;

            //RenderTrigger
            if(t=self.RenderTrigger){
                for(var i=0,l=t.length;i<l;i++)
                    t[i].call(self);
                delete self.RenderTrigger;
            }
            if(arguments[0]===true && (t=self.LayoutTrigger))
                for(var i=0,l=t.length;i<l;i++)
                    t[i].call(self);
            if(self.children)
                for(var i=0,v;v=self.children[i++];)
                    v[0]._render(true);
            if(self.$attached){
                for(var i=0,v;v=self.$attached[i++];)
                    //avoid to _render linb.Template
                    if(v['linb.UIProfile'])
                        v._render(true);
                delete self.$attached;
            }
        },
        __gc:function(){
            var self=this, t;
            if(self.onDestroy)self.boxing().onDestroy();
            if(self.destroyTrigger)self.destroyTrigger();

            //gc already
            if(!self.serialId)return;
            //clear cache things
            self.clearCache();

            //for dock case
            if(t=self.$dockParent)
                if(t=self.constructor.getFromDomId(t))
                    _.tryF(t.clearCache,[],t);

            //clear dom link
            if(self.nodeVars && (t=self.domNode))
                for(var i in self.nodeVars)
                    t[i]=null;

            //for refresh function
            if(!self.$exID){
                //restore dom id
                t=linb.cache.domId;
                (t[self.key] || (t[self.key]=[])).push(self.serialId);
            }else delete self.$exID

            //clear cache point
            delete linb.cache.dom[self.domId];
            delete linb.cache.dom[self.$domId];
            delete self.box._namePool[self.alias];

            //clear anti link
            self.unLinkAll();
            _.tryF(self.$ondestory);

            _.breakO(self);
        },
        unlinkParent:function(){
            var profile=this;
            delete profile.parent;
            delete profile.childrenId;
            profile.unLink('$parent');
            return profile;
        },
        getRootNode:function(){
            return this.domNode || (this.domNode=document.getElementById(this.domId));
        },
        getRoot:function(){
            return this.root || null;
        },
        linkParent:function(parentProfile, linkId){
            var profile=this;
            //unlink first
            profile.unlinkParent();

            //link
            profile.parent = parentProfile;
            profile.childrenId = linkId;
            profile.link(parentProfile.children, '$parent', [profile, linkId]);
            return profile;
        },
        _reg:/^\w[\w_-]*$/,
        setDomId:function(id){
            var t=this, c=linb.cache.dom, reg=t._reg;
            //ensure the value
            if(typeof id== 'string' && (reg.test(id)||id==t.$domId) && !linb.Dom.byId(id)){
                //delete the original one
                if(t.domId!=t.$domId)delete c[t.domId];
                //set profile's domId
                t.domId=id;
                //change the domNode id value
                if(t.domNode)t.domNode.id=id;
                //if doesn't create yet, don't set it to linb.cache:
                if(c[t.$domId])c[id]=t;
            }
            return t;
        },
        getDomId:function(){
            return this.domId;
        },
        clearCache:function(){
            var ns=this,a='$_egetter',b='$_domid',t=ns[a];
            for(var i in t)
                t[i].length=0;
            t=ns[b];
            for(var i in t)
                t[i]=null;
            ns[a]=ns[b]=null;
        },
        //get events function from profile
        _getEV:function(id, name){
            var self=this,
                $k = id+"+"+name,
                g = self.$_egetter ||(self.$_egetter={});
            if(g[$k])return g[$k];

            var dom=linb.cache.dom,
                funs=[],
                t,key
                ;
            //for event attached on dom node
            if( (t=dom[id]) && (t=t.events) && (t=t[name]) )
                for(var i=0,l=t.length;i<l;i++)
                    if(typeof t[t[i]]=='function')
                        funs[funs.length]=t[t[i]];


            //for event attached on linb widgets
            //get event function path of cache
            key = id.split(":")[0].split("-")[1];

            //for priority intercept
            if(typeof (((t=self._CB) && (key?(t=t[key]):1)) && (t=t[name]))=='function')
                funs[funs.length]=t;
            else{
                //get event function from customBehavior first
                if(typeof (((t=self.CB) && (key?(t=t[key]):1)) && (t=t[name]))=='function')
                    funs[funs.length]=t;
                else{
                    //get event function from public behavior
                    if(typeof (((t=self.behavior) && (key?(t=t[key]):1)) && (t=t[name]))=='function')
                        funs[funs.length]=t;
                }
            }
            return g[$k] = funs;
        },
        toHtml:function(){
            var self=this,
                me=arguments.callee,
                reg = me._reg || ( me._reg = /<!--([^>^\s]*)-->/g),
                c = self.box,
                h={},
                str,
                k1='linb.UIProfile',
                k2='linb.Profile',
                id, i, o, m, a, b, data;
            //before _dynamicTemplate
            data=c._prepareData(self);
            if(c._dynamicTemplate)c._dynamicTemplate(self);
            str = c._build(self, data);

            if(m=c._getChildren(self)){
                for(i=0; o=m[i++];)
                    if(o[0][k1]){
                        id=o[1]||'';
                        a=h[id]||(h[id]=[]);
                        a[a.length]=o[0].toHtml();
                    }else if(!o[0][k2]){
                        b.ini.call(b,o[0]);
                        o[0]=b.get(0);
                    }
            }

            return str.replace(reg, function(a,b){
                return h[b]?h[b].join(''):'';
            });
        },
        buildItems:function(key, items){
            var self=this,box=self.box,str,reg= self.toHtml._reg;
            str=box._rpt(self, linb.UI.$doTemplate(self, _.get(linb.cache.template,[box.KEY, self._hash]), items, key));
            return str.replace(reg,'')
        },
        serialize:function(rtnString, keepHost){
            var t,m,
                self=this,
                o=(t=self.box._beforeSerialized)?t(self):self,
                r={
                    alias:o.alias,
                    key:o.key,
                    host:o.host
                };
            //host
            if(r.host===self){
                delete r.host;
            }else if(o.host && !keepHost ){
                if(rtnString!==false)
                    r.host='@this';
                else
                    delete r.host;
            }

            //domId
            if(o.$domId!=o.domId)r.domId=o.domId;

            //properties
            var c={}, p=o.box.$DataStruct, map=linb.absObj.$specialChars;
            _.merge(c,o.properties, function(o,i){return (i in p) &&  p[i]!==o && !map[i.charAt(0)]});
            if(!_.isEmpty(c))r.properties=c;

            //events
            if(!_.isEmpty(t=this.getEvents()))r.events=t;
            var eh = o.box.$EventHandlers;
            _.filter(r.events, function(o,i){
                return o!=eh[i];
            });
            if(_.isEmpty(r.events))delete r.events;

            if(!_.isEmpty(o.CS)) r.CS=_.copy(o.CS);
            if(!_.isEmpty(o.CB)) r.CB=_.copy(o.CB);
            if(!_.isEmpty(o.CC)) r.CC=_.copy(o.CC);
            if(!_.isEmpty(o.CF)) r.CF=_.copy(o.CF);

            //children
            if(o.children && o.children.length){
                o.children.sort(function(x,y){
                    x=parseInt(x[0].properties.tabindex);y=parseInt(y[0].properties.tabindex);
                    return x>y?1:x==y?0:-1;
                });
                t=r.children=[];
                _.arr.each(o.children,function(v){
                    m=[v[0].serialize(false, keepHost)];
                    if(v[1])m[1]=v[1];
                    t[t.length]=m
                });
            }
            return rtnString===false?r:_.serialize(r);
        },
        _applySetAction:function(fun, value, ovalue){
            if(this.domNode)
                return fun.call(this, value, ovalue);
        },
        getKey:function(id){
            var t;
            if(id.indexOf(':')==-1)id=(t=linb.cache.dom[id])&&(t.$domId);
            return id?id.split(":")[0]:"";
        },
        getSubId:function(id){
            var t;
            if(id.indexOf(':')==-1)id=(t=linb.cache.dom[id])&&(t.$domId);
            return id?id.split(":")[2]:"";
        },
        pickSubId:function(key){
            var self=this, r,o = self.cache_subid || (self.cache_subid={});
            if((o[key] || (o[key]=[]))[0])return o[key].shift();
            o = self.subId || (self.subId={});
            r=(o[key] || (o[key]=new _.id)).next();
            return r;
        },
        reclaimSubId:function(id, key){
            var o = this.cache_subid || (this.cache_subid={});
            (o[key] || (o[key]=[])).push(id);
        },
        /*
        *('KEY','-mouseover',false);
        */
        getClass:function(key, tag){
            key=this.keys[key] || key;
            var self=this,
                me=arguments.callee,
                map=me._map||(me._map={}),
                reg=me._reg||(me._reg=/\./g),
                hash=key+":"+tag;

            return map[hash] || (map[hash]=key.replace(reg,'-').toLowerCase().replace('linb-ui','linb') + (tag||''));
        },
        _getSubNodeId:function(key, subId){
            var arr = this.$domId.split(':');
            arr[0]=key;
            arr[2]=subId||'';
            key=arr.join(':');
            if(key==this.$domId)return linb.cache.dom[key].domId;
            else return key;
        },
        //flag : remove from cache
        getSubNode:function(key, subId){
            var self=this;
                key=self.keys[key] || key;
            var r,t,s,h=self.$_domid||(self.$_domid={});

            // by key only
            if(subId===true)
                //key==self.keys.KEY for domId!=$domId
                r =linb([self.domNode]).query('*', 'id', key==self.keys.KEY?self.domId:new RegExp('^'+key+':'+self.serialId));
            else{
                if(!subId && h[key] && h[key]._nodes.length==1)return h[key];
                r = (t=linb.Dom.byId(s=self._getSubNodeId(key, subId))) ? linb([t]) : ((t=self.domNode) && linb([t]).query('*', 'id', s));
                if(!subId)h[key]=r;
            }
            return r;
        },
        getSubNodes:function(arr,subId){
            var i=0,a=[],o;
            for(;o=arr[i++];)
                Array.prototype.push.apply(a,this.getSubNode(o,subId).get());
            return linb(a);
        },
        getSubNodeByItemId:function(key, itemId){
            return (itemId=this.getSubIdByItemId(itemId)) ? this.getSubNode(key, itemId) : linb();
        },
        getItemByItemId:function(itemId){
            var t;
            if((t=this.ItemIdMapSubSerialId) && (t=t[itemId]))
                return this.SubSerialIdMapItem[t];
        },
        getItemByDom:function(src){
            return this.SubSerialIdMapItem && this.SubSerialIdMapItem[this.getSubId(src.id || src)];
        },
        getItemIdByDom:function(src){
            var t;
            return (t=this.getItemByDom(src)) && t.id;
        },
        getSubIdByItemId:function(itemId){
            var t;
            return (t=this.ItemIdMapSubSerialId) && t[itemId];
        },
        queryItems:function(items, fun, deep, single){
            var r=[],
                me=arguments.callee,
                f = me.f || (me.f = function(items, fun, deep, single, r){
                    _.arr.each(items,function(o){
                        if(fun===true || fun.call(null, o)){
                            r.push(o);
                            if(single)
                                return false;
                        }
                        if(deep && o.sub && o.sub.length)
                            f(o.sub, fun, deep, single, r);
                    });
                });
            f(items, fun, deep, single, r);
            return r;
        }
    },
    Static:{
        getFromDomId:function(id){
            return linb.cache.dom[id.replace(linb.Event._reg,'$1$3')];
        }
    }
});

//UI Class
Class("linb.UI",  "linb.absObj", {
    Before:function(key, parent_key, o){
        linb.absBox.$type[key.replace("linb.UI.","").replace("linb.","")]=linb.absBox.$type[key]=key;
        return true;
    },
    After:function(){
        linb.absObj.After.apply(this,arguments);
        var self=this,me=arguments.callee,
            temp,t,k,u,c,i,j,e,w,v,b,d;

        self._ctrlId = new _.id();
        self._idCache=[];
        self.$cssKeys={};

        /*change keys*/
        t=self.$Keys;
        t.KEY = t.$key = self.KEY;
        self.addTemplateKeys(_.toArr(t,true));

        //Inheriates Behaviors
        v='$Behaviors';
        k={};
        if((t=self.$parent) && (e=t.length)){
            while(e--){
                b=t[e][v];
                for(i in b){
                    if(typeof b[i]=='object'){
                        if(b[i].constructor==Array){
                            u=k[i]||(k[i]=[]);
                            u.push.apply(u,b[i]);
                        }else{
                            u=k[i]||(k[i]={});
                            _.merge(u,b[i]);
                        }
                    }else
                        k[i]=b[i];
               }
            }
        }
        self[v]=k;

        //Inheriates Templates
        v='$Templates';
        k={};
        if((t=self.$parent) && (e=t[0]))
            for(i in e[v])
                if(i.charAt(0)!='$')
                    k[i]=e[v][i];
        self[v]=_.clone(k);

        //Inheriates Appearances
        v='$Appearances';
        k={};
        if((t=self.$parent) && (e=t.length))
        while(e--){
            b=t[e];
            for(i in b[v]){
                t=b[v][i];
                u=k[i]||(k[i]={});
                _.merge(u,t);
            }
        }
        self[v]=k;

        self.setTemplate(self.Templates);
        delete self.Templates;

        self.setBehavior(self.Behaviors);
        delete self.Behaviors;

        self.setAppearance(self.Appearances);
        delete self.Appearances;

        if(t=self.PublicAppearance){
            linb.UI.$cache_css += self.buildCSSText(t);
            delete self.PublicAppearance;
        }
    },
    Instance:{
        destroy:function(){
            this.each(function(o){
                if(o.beforeDestroy && false===o.boxing().beforeDestroy())return;

                if(o.root)o.root.remove();
                else o.__gc();
            });
        },
        serialize:function(rtnString, keepHost){
            var a=[];
            this.each(function(o){
                a[a.length]=o.serialize(false, keepHost);
            });
            return rtnString===false?a:a.length==1?" new "+a[0].key+"("+_.serialize(a[0])+")":"linb.UI.unserialize("+_.serialize(a)+")";
        },

        _toDomElems:function(){
            this.render();
            var t, arr=[];
            _.arr.each(this._nodes,function(o){
                if(t=o.domNode)arr.push(t);
            });
            return arr;
        },

        _ini:function(properties, events, host, CS, CC, CB, CF){
            var self=this,
                c=self.constructor,
                profile,
                t='default',
                options,
                np=c._namePool,
                alias,temp;
            if(properties && properties['linb.Profile']){
                profile=properties;
                alias = profile.alias || c.pickAlias();
                linb.UIProfile.apply(profile,[host,self.$key,alias,c,null,events]);
            }else{
                if(properties && properties.key && linb.absBox.$type[properties.key]){
                    options=properties;
                    properties=null;
                    alias = options.alias;
                    alias = (alias&&!np[alias])?alias:c.pickAlias();
                }else
                    alias = c.pickAlias();
                profile=new linb.UIProfile(host,self.$key,alias,c,properties,events, options);
            }
            np[alias]=1;
            for(var i in (temp=c.$DataStruct))
                if(!(i in profile.properties))
                    profile.properties[i]=typeof temp[i]=='object'?_.copy(temp[i]):temp[i];

            profile.keys = c.$Keys;

            // custom
            profile.CS = CS || profile.CS || {};
            profile.CB = CB || profile.CB || {};
            profile.CC = CC || profile.CC || {};
            profile.CF = CF || profile.CF || {};

            profile.template = c.getTemplate();
            profile.behavior = c.$Behaviors;

            if(!profile.serialId)profile.serialId=c._pickSerialId();

            profile.$domId = profile.key + ":" + profile.serialId + ":";
            profile.domId = profile.domId || profile.$domId;

            profile.RenderTrigger=_.copy(c.$RenderTrigger);
            profile.LayoutTrigger=_.copy(c.$LayoutTrigger);

            //not register subcontrols id / dom cache
            //attribute in innerHTML won't cause memory leak in IE.
            profile.nodeVars = profile.behavior?profile.behavior.$eventhandler:null;

            //set links
            profile.link(linb.UI._cache,'UI').link(c._cache,'self').link(linb._pool,'linb');

            temp=profile.children;
            profile.children=[];
            if(temp && temp.length){
                for(var i=0,v;v=temp[i++];){
                    //from serialize
                    if(!v[0]['linb.UIProfile'])
                        v[0]=new (linb.SC(v[0].key))(v[0]).get(0);
                    v[0].linkParent(profile,v[1]);
                }
            }
            self._nodes.push(profile);

            return self;
        },
        busy:function(message,html,key){
            message=message||'Loading...';
            html=html||'<span style="background:'+ linb.UI.$bg('busy.gif',' no-repeat left center')('linb.UI.Public') +';padding-left:16px;">'+message+'</span>';
            return this.each(function(profile){
                _.resetRun(profile.$id+':busy',function(){
                    var keys=profile.keys;
                    key=keys[key]||keys['BORDER']||keys['PANEL']||keys['KEY'];

                    var parentNode=profile.getSubNode(key),
                        size=parentNode.cssSize(),
                        node;
                    if(!(node=profile.$busy)){
                        node=profile.$busy=linb.create('<div style="left:0;top:0;z-index:10;position:absolute;background-color:#DDD;"></div><div style="left:0;top:0;z-index:20;text-align:center;position:absolute;">'+html+'</div>');
                        linb([node.get(0)]).css({opacity:0.5});
                        linb(parentNode).append(node);
                    }
                    node.css({display:'',width:size.width+'px',height:size.height+'px',lineHeight:size.height+'px'});
                    linb([node.get(1)]).html(html,false);
                },50);
            });
        },
        free:function(){
            return this.each(function(profile){
                _.resetRun(profile.$id+':busy');
                if(profile.$busy)profile.$busy.css('display','none');
            });
        },
        resize:function(){
            return this.each(function(o){_.tryF(o.$resizeFun)});
        },
        toHtml:function(){
            var a=[];
            _.arr.each(this._nodes,function(o){
                a[a.length]=o.toHtml();
            });
            return a.join('');
        },
        render:function(triggerLayOut){
            var self=this, arr=[], i, l, o, t, m, div, matix,n=self._nodes, a=[],byId=linb.Dom.byId;

            linb.UI.$applyCSS();

            for(i=0;o=n[i++];)
                if(!byId(o.domId))
                    arr[arr.length]=o;
            if(l=arr.length){
                for(i=0;i<l;i++) a[a.length]=arr[i].toHtml();
                //get dom node
                m=_.str.toDom(a.join(''));
                m=m.get();
                l=m.length;
                //must add to DOM page first
                matix=linb.Dom.getEmptyDiv().get(0);
                t=document.createDocumentFragment?document.createDocumentFragment():matix;
                for(i=0;i<l;i++) t.appendChild(m[i]);
                if(t!=matix)matix.appendChild(t);
            }
            for(i=0;o=n[i++];) o._render(triggerLayOut);
            return self;
        },
        renderOnto:function(node, host){
            node=linb(node);
            if(node.isEmpty())return this;

            var self=this,
                pro=self.get(0),
                me=arguments.callee,
                para=me.para||(me.para=function(node){
                    var r = node.cssRegion();
                    r.tabindex=node.attr('tabIndex');
                    r.zIndex=node.css('zIndex');
                    r.position=node.css('position');
                    return r;
                });
            _.merge(pro.properties, para(node),'all');
            node.outerHTML(pro.toHtml());
            pro.boxing().host(host||window, node.get(0).id || pro.alias);
            pro._render(true);
            return self;
        },
        setDomId:function(id){
            this.get(0).setDomId(id);
            return this;
        },
        hide:function(){
            return this.each(function(o){
                if(o.domNode){
                    o.root.hide();
                    o.properties.top=o.properties.left=-10000;
                    o.properties.dockIgnore=true;
                }
            });
        },
        show:function(left,top){
            return this.each(function(o){
                if(o.domNode){
                    var t=o.properties;
                    t.dockIgnore=false;
                    o.root.show(left,top);
                    
                    if(t.dock && t.dock!='none')
                        linb.UI.$dock(o,true);
                }
            });
        },
        clone:function(){
            var arr=[],f=function(p){
                //remove those
                delete p.alias;delete p.domId;
                if(p.children)
                    for(var i=0,c;c=children[i];i++)
                        f(c);
            };
            this.each(function(o){
                o=o.serialize(false,true);
                f(o);
                arr.push(o);
            });
            return this.constructor.unserialize(arr);
        },
        refreshDom:function(){
            (function(arr){
                var me=arguments.callee;
                _.arr.each(arr,function(o){
                    if(o.constructor==Array)o=o[0];
                    o.clearCache();
                    if(o.children&&o.children.length)
                        me(o.children);
                })
            })(this._nodes);
            return this.each(function(o){
                if(o.domNode){
                    var root=o.getRoot(),size=root.cssSize();
                    root.outerHTML(o.toHtml());
                    linb.UI.$tryResize(o,size.width,size.height,o.properties.$UIvalue,true);
                }
            });
        },
        refresh:function(){
            var para,b,p,s,$id,serialId,fun,box,children;
            return this.each(function(o){
                if(!o.domNode)return;

                box=o.box;

                //save related id
                $id=o.$id;
                serialId=o.serialId;

                //keep parent
                if(b=!!o.parent){
                    p=o.parent.boxing();
                    para=o.childrenId;
                }else
                    p=o.root.parent();

                //replace
                var replace = linb.create('span');
                o.root.replace(replace,true);

                //keep children
                children = _.copy(o.children);
                o.children.length=0;
                _.arr.each(children,function(o){
                    //for flush dock
                    delete o[0].$dockParent;

                    //keep it in dom
                    replace.append(o[0].root);
                });

                //unserialize
                s = o.serialize(false, true);
                fun = o.$addOns;

                //destroy it
                //avoid cache serialId back
                o.$exID=1;
                o.boxing().destroy();
                //call gc to clear immediately
                linb.Dom.__gc();

                //set back
                _.merge(o,s,'all');
                o.$id=$id;
                o.serialId=serialId;

                //create
                o=new box(o).render();

                //for functions like: UI refresh itself
                if(fun)
                    fun.call(fun.target,o.get(0));

                //replace back
                //empty, but keep the children
                replace.empty(false);
                replace.replace(o.get(0).root);

                //restore to parent
                if(b)
                    p.append(o,para);
                else
                    p.append(o);

                //restore children
                _.arr.each(children,function(v){
                    o.append.apply(o,v);
                });
                replace.remove();
            });
        },
        append:function(target, subId){
            if(target['linb.UIProfile'])target=target.boxing();
            var pro=this.get(0),parentNode;
            if(subId!==false){
                target.each(function(profile){
                    profile.linkParent(pro,subId);
                });
            }
            if(pro.domNode){
                if(subId=typeof subId=='string'?subId:null)subId=pro.getSubIdByItemId(subId);
                parentNode=pro.keys.PANEL?pro.getSubNode(pro.keys.PANEL, subId):pro.root;
                if(!parentNode.isEmpty())
                    parentNode.append(target);
            }
            return this;
        },
        getChildren:function(subId){
            var a=[];
            _.arr.each(this.get(0).children,function(v){
                if(subId?v[1]==subId:1)
                    a.push(v[0]);
            });
            return linb.UI.pack(a);
        },
        removeChildren:function(subId){
            return this.each(function(o){
                _.arr.each(o.children,function(v){
                    if(subId?v[1]==subId:1)
                        v[0].unlinkParent();
                        if(v[0].root)
                            v[0].root.remove();
                        else
                            v[0].__gc();
                });
            });
        },
        dragable:function(dragKey, dragData, key){
            return this.each(function(o){
                o.getSubNode(o.keys[key] || 'KEY', true)
                .beforeMousedown(dragKey?function(pro,e,src){
                    if(pro.properties.disabled)return;
                    linb([src]).startDrag(e, {
                        dragKey:dragKey,
                        dragData:typeof dragData == 'function'?dragData():dragData,
                        dragCursor:'pointer',
                        dragType:'icon',
                        dragDefer:1
                    });
                }:null,'_d',-1)
                .beforeDragbegin(dragKey?function(profile, e, src){
                    linb([src]).onMouseout(true,{$force:true}).onMouseup(true);
                }:null,'_d',-1);
                if(!dragKey)
                    o.clearCache();
            });
        },
        setCustomFunction:function(key, value){
            return this.each(function(o){
                if(typeof key=='string'){
                    if(value) o.CF[key]=value;
                    else delete o.CF[key];
                }else
                    o.CF=key||{};
            });
        },
        setCustomClass:function(key, value){
            var me=arguments.callee,
                fun=(me.fun||(me.fun=function(pro,i, h, flag){
                    if(!h[i])return;
                    var node=pro.getSubNode(i,true),b;
                    if(!node.isEmpty())
                        _.arr.each(h[i].split(/\s+/),function(o){
                            node[flag?'removeClass':'addClass'](o);
                        });
                }));
            return this.each(function(o){
                var bak = _.copy(o.CC);

                //set key and value
                if(typeof key=='string'){
                    if(o.domNode)
                        if(key in bak)
                            fun(o, key, bak, true);

                    if(!value)
                        delete o.CC[key];
                    else{
                        o.CC[key]=value;
                        if(o.domNode)
                            fun(o, key, o.CC);
                    }
                //set hash dir
                }else if(!!key && typeof key=='object'){
                    if(o.domNode){
                        for(var i in key)
                            fun(o, i, bak, true);
                        for(var i in key)
                            fun(o, i, key);
                    }
                    o.CC=key;
                //clear all
                }else{
                    if(o.domNode)
                        for(var i in bak)
                            fun(o, i, bak, true);
                    o.CC={};
                }
            });
        },
        setCustomStyle:function(key,value){
            var me=arguments.callee,
                fun=(me.fun||(me.fun=function(pro,i,h, flag){
                    if(!h[i])return;
                    var node=pro.getSubNode(i,true),b;
                    if(!node.isEmpty())
                        _.arr.each(h[i].split(';'),function(o,i){
                            if((b=o.split(':')).length==2){
                                b[0]=b[0].replace(/\-(\w)/g,function(a,b){return b.toUpperCase()});
                                try{node.css(b[0], flag?'':b[1])}catch(e){}
                            }
                        });
                }));
            return this.each(function(o){
                var bak = _.copy(o.CS);

                //set key and value
                if(typeof key=='string'){
                    if(o.domNode)
                        if(key in bak)
                            fun(o, key, bak, true);

                    if(!value)
                        delete o.CS[key];
                    else{
                        o.CS[key]=value;
                        if(o.domNode)
                            fun(o, key, o.CS);
                    }
                //set hash dir
                }else if(!!key && typeof key=='object'){
                    if(o.domNode){
                        for(var i in key)
                            fun(o, i, bak, true);
                        for(var i in key)
                            fun(o, i, key);
                    }
                    o.CS=key;
                //clear all
                }else{
                    if(o.domNode)
                        for(var i in bak)
                            fun(o, i, bak, true);
                    o.CS={};
                }
            });
        },
        setCustomBehavior:function(key, value){
            return this.each(function(o){
                if(typeof key=='string'){
                    if(o.keys[key])
                        o.CB[key]=value||{};
                }else
                    o.CB=key||{};
                if(o.CB.KEY){
                    _.merge(o.CB, o.CB.KEY, 'all');
                    delete o.CB.KEY;
                }
                o.clearCache();
            });
        }
    },
    Initialize:function(){
        var ns=this.prototype;
        _.arr.each('getSubNode,getDomId,getRootNode,getRoot'.split(','),function(o){
            if(!ns[o])
                ns[o]=function(){
                    var p=this.get(0);
                    return p[o].apply(p,arguments);
                };
                ns[o].$original$='linb.UI';
        });

        var self=this, hash={};
        _.arr.each(_.toArr('left,top,width,height,right,bottom'),function(o){
            hash[o] = {
                ini:'auto',
                action:function(value){
                    var self=this,
                        p=self.properties,b=false,
                        args={$type:p.dock};
                    if(self.domNode){
                        switch(p.dock){
                            case 'top':
                                if(o!='height'&&o!='top')return;
                                args.width=args.height=1;
                                break;
                            case 'bottom':
                                if(o!='height'&&o!='bottom')return;
                                args.width=args.height=1;
                                break;
                            case 'left':
                                if(o!='width'&&o!='left')return;
                                args.width=args.height=1;
                                break;
                            case 'right':
                                if(o!='width'&&o!='right')return;
                                args.width=args.height=1;
                                break;
                            case 'width':
                                if('width'==o)return;
                                args.width=1;
                                break;
                            case 'height':
                                if('height'==o)return;
                                args.height=1;
                                break;
                            case 'fill':
                            case 'cover':
                                if(o=='width'&&o=='height')return;
                                args.width=args.height=1;
                                break;
                        }
                        self.root[o]?self.root[o](value):linb.Dom._setPxStyle(self.domNode,o,value);
                        if(p.dock!='none')_.tryF(self.$dock,[self, args],self);
                    }
                }
            }
        });
        _.merge(hash,{
            renderer:{
                ini:null
            },
            //invalid after dom domNode
            zIndex:{
                ini:1,
                action:function(value){
                    if(this.domNode)
                        this.root.css('zIndex',value);
                }
            },
            tabindex:{
                ini:1
            },
            position:{
                ini : 'absolute',
                listbox:['','static','relative','absolute'],
                action:function(value){
                    if(this.domNode)
                        this.root.css('position',value);
                }
            },
            visibility:{
                listbox:['','visible','hidden'],
                action:function(value){
                    if(this.domNode)
                        this.root.css('visibility',value);
                }
            },
            display:{
                listbox:['','none','block','inline','inline-block'],
                action:function(value){
                    if(this.domNode){
                        if(value=='inline-block')
                            this.root.setInlineBlock();
                        else
                            this.root.css('display',value);
                    }
                }
            }
        });

        self.setDataModel(hash);

        linb.UI.$cache_css += linb.UI.buildCSSText({
            '.ui-ctrl':{
            },
            '.ui-content':{
                'background-color':'#fff'
            },
            '.ui-btn':{
                background:linb.UI.$bg('button.gif', ' repeat-x left -26px',true),
                border:'solid 1px #616161',
                padding:'0 3px',
                cursor:'default',
                'font-size':'12px',
                'vertical-align':'middle'
            },
            '.ui-icon':{
                'vertical-align':'middle',
                width:'16px',
                height:'16px',
                margin:'0 4px 0 2px'
            },
            '.uicmd-close, .uicmd-opt, .uicmd-land, .uicmd-toggle, .uicmd-min, .uicmd-max,.uicmd-restore,.uicmd-pin':{
                width:'15px',
                height:'15px',
                cursor:'default',
                'vertical-align':'middle'
            },
            '.uicmd-close':{
                background: linb.UI.$bg('cmds.gif', ' no-repeat -64px 0', true)
            },
            '.uicmd-close-mouseover':{
                $order:1,
                'background-position' : '-64px -16px'
            },
            '.uicmd-close-mousedown':{
                $order:2,
                'background-position' : '-64px -32px'
            },
            '.uicmd-opt':{
                background: linb.UI.$bg('cmds.gif', ' no-repeat -240px 0', true)
            },
            '.uicmd-opt-mouseover':{
                $order:1,
                'background-position' : '-240px -16px'
            },
            '.uicmd-opt-mousedown':{
                $order:2,
                'background-position' : '-240px -32px'
            },
            '.uicmd-land':{
                background: linb.UI.$bg('cmds.gif', ' no-repeat -220px 0', true)
            },
            '.uicmd-land-mouseover':{
                $order:1,
                'background-position' : '-220px -16px'
            },
            '.uicmd-land-mousedown':{
                $order:2,
                'background-position' : '-220px -32px'
            },
            '.uicmd-toggle':{
                background: linb.UI.$bg('cmds.gif', ' no-repeat -161px 0', true)
            },
            '.uicmd-toggle-mouseover':{
                $order:2,
                'background-position': '-161px -16px'
            },
            '.uicmd-toggle-mousedown':{
                $order:3,
                'background-position': '-161px -32px'
            },
            '.uicmd-toggle-checked':{
                $order:4,
                'background-position': '-176px top'
            },
            '.uicmd-toggle-checked-mouseover':{
                $order:5,
                'background-position': '-176px -16px'
            },
            '.uicmd-toggle-checked-mousedown':{
                $order:6,
                'background-position': '-176px -32px'
            },
            '.uicmd-toggle-busy':{
                $order:7,
                background: linb.UI.$bg('busy.gif', ' no-repeat center center', true)
            },
            '.uibar-bar':{
                position:'relative'
            },
            '.uibar-t':{
                background: linb.UI.$bg('barvbg.gif', ' repeat-x left top', true),
                border: 'solid #C1C1C1',
                'border-collapse':'separate',
               'border-width': '0 1px 0 1px'
            },
            '.uibar-cmdl':{
                '-moz-user-select':'none',
                overflow:'hidden',
                position:'absolute',
                left:0,
                top:'3px',
                width:'60%',
                'padding-left':'3px',
                'white-space': 'nowrap'
            },
            '.uibar-cmdr':{
                '-moz-user-select':'none',
                position:'absolute',
                top:'3px',
                right:'4px',
                'text-align':'right'
            }
        })
        + linb.UI.buildCSSText({
            '.widget-shell':{
                background:'transparent',
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                //overflow:'hidden',
                /*opera must be 0 not 'none'*/
                border:0,
                padding:0,
                margin:0
            },
            /*span*/
            '.widget-frame':{
                $order:1,
                display:'block',
                position:'relative',
                //overflow:'hidden',
                border:0,
                padding:0,
                margin:0,
                width:'100%',
                height:'100%',
                '-moz-box-flex':'1'
            },
            /*span*/
            '.widget-border':{
                $order:2,
                display:'block',
                position:'absolute',
                border:0,
                padding:0,
                margin:0,
                left:0,
                top:0,
                width:'100%',
                height:'100%'
            },
            '.ui-dirty':{
                background: linb.UI.$bg('dirty.gif', ' no-repeat left top', true)
            },
            '.ui-disabled, .ui-disabled *':{
                color: '#808080'
            },
            '.ui-invalid, .ui-invalid *':{
                'background-color': '#FFEBCD'
            },
            '#linblangkey':{
                'vertical-align':'baseline'
            }
        });
    },
    $End:function(){
        linb.UI.$cache_css += this.buildCSSText(this.$Appearances);
    },
    Static:{
        $cache_css:'',
        $css_tag_dirty: "ui-dirty",
        $css_tag_invalid: "ui-invalid",
        $tag_left:"{",
        $tag_right:"}",
        $tag_special:'#',
        $ID:"#id#",
        $DOMID:'#domid#',
        $CLS:"#cls#",
        $tag_subId:"_serialId",
        $childTag:"<!--{id}-->",

        $theme:'default',
        _getChildren:function(profile){
            return profile.children;
        },
        unserialize:function(target,keepSerialId){
            if(typeof target=='string')target=_.unserialize(str);
            var f=function(o){
                if(o && o.constructor==Array)o=o[0];
                delete o.serialId;
                if(o.children)_.arr.each(o.children,f);
            }, a=[];
            _.arr.each(target,function(o){
                if(!keepSerialId)f(o);
                a.push((new (linb.SC(o.key))(o)).get(0));
            });
            return this.pack(a,false);
        },

        _ensureValues:function(arr){
            var a=[],i=0,k=0,o,key=this.KEY,cache=linb.cache.dom;
            if(arr['linb.absBox'])arr=arr._nodes;
            for(;o=arr[i++];)
                if((o.box && o.box[key]) || ((o=cache[o.domNode?o.domNode.id:o.id]) && o.box && o.box[key]))
                    a[k++]=o;
            return a.length<=1?a:this._unique(a);
        },

        __gc:function(){
            var self=this, k=self.$key, cache=linb.cache;
            //clear templates memory in linb.cache
            _.breakO([cache.template[k], cache.domId[k], self._cache, self._idCache, self.$DataModel, self.$Templates,  self.$Behaviors, self],2);
            delete linb.absBox.$type[k.replace("linb.UI.","")];
            // add for base class
            Class.__gc(k);
        },
        _pickSerialId:function(){
            //get id from cache or id
            var arr = linb.cache.domId[this.$key];
            if(arr && arr[0])return arr.pop();
            return this._ctrlId.next();
        },
        $bg:function(path, para, forceKey){
            return function(key){
                var p = linb.getPath(typeof forceKey=='string'?forceKey:forceKey?'linb.Public':key.replace('UI.',''),null,'appearance/default') +   path;
                _.asyRun(function(){new Image().src=p;});
                return 'url(' + p +') '+ (para||'');
            }
        },
        $ieBg:function(path,  forceKey){
            return function(key){
                var s = linb.getPath(typeof forceKey=='string'?forceKey:forceKey?'linb.Public':key.replace('UI.',''), '/' + path,'appearance/default');
                _.asyRun(function(){new Image().src=s;});
                return 'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+s+'",sizingMethod="crop")';
            }
        },

       /* deep template function
          template: string
          properties: hash

          $doTemplate("{a}{b}{c}{a}{b}{/c}", {a:'*',b:'#',c:[{a:'1',b:'.'},{a:'2',b:'.'},{a:'3',b:'.'},{a:'4',b:'.'}]})
              will return "*#1.2.3.4."
          doTemplate("{a}{b}{c}{}{/c}", {a:'*',b:'#',c:['1','2','3','4']})
              will return "*#1234"

          flag: default flase => no clear not mactched symbols
        */
        $doTemplate:function(profile, template, properties, tag, result){
            var self=arguments.callee,
                s,t,n,
                isA = properties.constructor == Array,
                temp = template[tag||''],
                r = !result,
                result= result || [];
            if(isA){
                if(typeof temp != 'function')temp = self;
                for(var i=0;t=properties[i++];)
                    temp(profile, template, t, tag, result);
            }else{
                if(t=properties.object){
                    //[properties] is for linb.Template
                    result[result.length]=t.toHtml();
                }else{
                    if(typeof temp == 'function')
                        temp(profile, template, properties, tag, result);
                    else{
                        tag = tag?tag+'.':'';
                        var a0=temp[0], a1=temp[1];
                        for(var i=0,l=a0.length;i<l;i++){
                            if(n=a1[i]){
                                if(n in properties){
                                    t=properties[n];
                                    //if sub template exists
                                    if(template[s=tag+n] && t)
                                        self(profile, template, t, s, result);
                                    else
                                        result[result.length]=t;
                                }
                            }else
                                result[result.length]=a0[i];
                        }
                    }
                }
            }
            if(r)return result.join('');
        },
        /*
        set properties default map and set properties handler
        It's a merge function, not replace

        this.$DataStruct: {a:,b:,c}
        this.$DataModel: from hash, for example:
        hash:{
            key1:{
                ini:xx,
                set:fun..,
                get:fun..,
                action: fun
            },
            key2:null,
            key3:'abc,
        }
        */
        $buildTemplate:function(profile, template, key, obj, arr){
            if(template && String(template.tagName).toLowerCase()=='text'){
                arr[arr.length] = template.text;
                return;
            }
            var self =arguments.callee,
                behavior = profile.behavior?key?profile.behavior[key]:profile.behavior:null,
                map1 = self.map1 ||(self.map1={tagName:1,text:1}),
                map2 = self.map2 ||(self.map2={image:1,input:1}),
                r2=self.r2||(self.r2=/[a-z]/),
                r3=self.r3 || (self.r3=/^(on|before|after)/),
                r7=self.r7 || (self.r7=/([^{}]*)\{([\w]+)\}([^{}]*)/g),
                first=false,
                u=linb.UI,
                t, o , bak, lkey;

            if(!template)template=profile.template;
            lkey = key?profile.keys[key]:profile.key;

            //tagName
            if(!template.tagName)template.tagName="span";

            if(template.id!==null)
                //id
                template.id = key?lkey + ":" + u.$ID + ":" + u.$tag_left + u.$tag_subId + u.$tag_right:u.$DOMID;
            else
                delete template.id;

            if(template.className!==null){
                //className
                t = u.$CLS + (key?'-'+key.toLowerCase():'');
                //save bak
                bak = template.className || '';

                //default class first
                template['class'] =  t+' '+
                    //custom class here
                    bak+' '+
                    //add a special for root
                    (lkey==profile.key?' ui-ctrl ':'') +
                    //custom class
                    u.$tag_special + (key||'KEY') + '_CC'+u.$tag_special
                    ;
            }
            delete template.className;

            template.style = (template.style||'')+';'+ u.$tag_special + (key||'KEY') + '_CS'+u.$tag_special;

            var a=[], b={}, tagName=template.tagName, text= template.text, sc=linb.absObj.$specialChars;
            for(var i in template){
                if(!template[i])continue;
                if(!sc[i.charAt(0)] && !map1[i]){
                    o=template[i];
                    if(!r2.test(i)){
                        // collect sub node
                        if(typeof o == 'object'){
                            if(!o.$order)o.$order=0;
                            o.$key=i;
                            a[a.length]=o;
                        }
                    }else
                        b[i]=o;
                }
            }
            // sort sub node
            a.sort(function(x,y){
                x=x.$order;y=y.$order;
                return x>y?1:x==y?0:-1;
            });

            //first
            if(!arr){
                first=true;
                arr=[];
            }
            //<span id="" style="">
            arr[arr.length]='<'+tagName+' ';
            for(var i in b)
                arr[arr.length]=i+'="'+b[i]+'" ';

            //set className bak
            if(template.className!==null)
                template.className = bak;

            delete template['class'];

            // add event handler
            if(behavior && (t=behavior.$eventhandler))
                for(var i in t)
                    if(t[i])
                        arr[arr.length]=i+'="'+t[i]+'" ';

            arr[arr.length]='{attributes}>';

            if(!map2[tagName] && text)
                arr[arr.length]=text;

            // add sub node
            for(var i=0,l=a.length;i<l;){
                o=a[i++];
                self(profile, o, o.$key, obj, arr)
            }

            if(!map2[tagName])
                arr[arr.length]='</'+tagName+'>';

            if(first){
                var a0=obj[0],a1=obj[1];
                arr.join('').replace(r7,function(a,b,c,d){
                    if(b)a0[a0.length]=b;
                    a1[a0.length]=a0[a0.length]=c;
                    if(d)a0[a0.length]=d;
                    return '';
                });
            }
        },
        _rpt:function(profile,temp){
            var me=arguments.callee,
                tag=linb.UI.$tag_special,
                r=me._r||(me._r=new RegExp( tag+'([A-Z0-9]+)_C([SC])'+tag + '|'+ tag+'([\\w_\\-\\.]*)'+tag, 'img')),
                h1={
                    id:profile.serialId,
                    cls:profile.getClass('KEY'),
                    domid:profile.domId
                },
                h2={
                    S:profile.CS,
                    C:profile.CC
                };
            return temp.replace(r, function(a,b,c,d){return h1[d] || h2[c][b] || ''});
        },
        _build:function(profile, data){
            var template, t, m,
                u=linb.UI,
                temp=[[],[]],
                self=this,
                key=self.KEY,
                cache=linb.cache.template,
                hash = profile._hash =
                    'b:' + (profile.template._subid||'') + ';' +
                    '!' + (profile._exhash||'');

            //get template
            if(!(template = _.get(cache,[key, hash]))){
                //get main template
                u.$buildTemplate(profile,null,null,temp);
                //split sub template from main template

                //set main template
                _.set(cache, [key, hash, ''], temp);
                //set sub template
                if(t=profile.template.$dynamic)
                    for(var i in t){
                        if(typeof (m=t[i])!='function'){
                            var temp=[[],[]];
                            for(var j in m)
                                if(typeof m[j] == 'object')
                                    u.$buildTemplate(profile, m[j], j, temp);
                            m=temp;
                        }
                        _.set(cache, [key,hash,i], m);
                    }

                template = _.get(cache,[key, hash]);
            }
            if(!template)return '';

            //replace main template
            return self._rpt(profile, u.$doTemplate(profile, template, data));
        },
        /*
        allow function input, for some css bug
        */
        _setDefaultBehavior:function(hash){
            var self=this,
                me=arguments.callee,
                map=me._m||(me._m={'':1,KEY:1,$key:1}),
                f=me._f1||(me._f1=function(arr, type, mode){
                    var fun = function(profile, e, src){
                        var t,
                            id=src.id,item,
                            cid = profile.getSubId(id),
                            prop = profile.properties,nodes,funs,box;
                        if(prop.disabled)return;
                        item = profile.SubSerialIdMapItem && profile.SubSerialIdMapItem[cid];
                        if(item && item.disabled)return;
                        switch(typeof arr){
                            case 'string':
                                nodes=profile.getSubNode(arr,cid).get();
                                break;
                            case 'function':
                                funs=[arr];
                                break;
                            case 'object':
                                nodes=[];funs=[];
                                for(var o,i=0,l=arr.length;i<l;i++){
                                    o=arr[i];
                                    if(typeof o=='string')
                                        nodes.push.apply(nodes,profile.getSubNode(o,cid).get());
                                    else
                                        funs.push(o);
                                }
                        }

                        if(nodes&&nodes.length){
                            nodes=linb(nodes);
                            box=profile.boxing();
                            if(mode==1){
                                if(type=='mouseover' && profile.beforeHoverEffect)
                                    if(false == box.beforeHoverEffect(profile, item, e, src, 'mouseover'))
                                        return;
                                if(type=='mousedown' && profile.beforeClickEffect)
                                    if(false == box.beforeClickEffect(profile, item, e, src, 'mousedown'))
                                        return;

                                //default action
                                nodes.tagClass('-'+type);
                            }else{
                                if(type=='mouseup'){
                                    if(profile.beforeClickEffect && false == box.beforeClickEffect(profile, item, e, src, 'mouseup'))
                                        return;
                                    nodes.tagClass('-mousedown', false);
                                }else{
                                    if(profile.beforeHoverEffect && false == box.beforeHoverEffect(profile, item, e, src, 'mouseout'))
                                        return;
                                    nodes.tagClass('(-mouseover|-mousedown)', false);
                                }
                            }
                            nodes.length=0;
                        }
                        if(funs&&funs.length){
                            _.arr.each(funs,function(o){
                                _.tryF(o,[profile],profile)
                            });
                            funs.length=0;
                        }
                   };
                    return fun;
                }),
                hls={},t;
            if(!linb.SC.get('linb.absPlus'))
                Class('linb.absPlus','linb.absObj',{
                    Instance:{
                        addPanel:function(para, children, item){
                            var pro = _.copy(linb.UI.Panel.$DataStruct);
                            _.merge(pro, para, 'with');
                            _.merge(pro,{
                                left:0,
                                top:0,
                                dock:'fill',
                                tag:para.tag||para.id
                            },'all');

                            var pb = new linb.UI.Panel(pro),arr=[];
                            this.append(pb, item&&item.id);
                            _.arr.each(children,function(o){
                                arr.push(o[0]);
                            });
                            pb.append(linb.UI.pack(arr,false));
                        },
                        removePanel:function(){
                            this.destroy();
                        },
                        getPanelPara:function(){
                            return _.copy(this.get(0).properties);
                        },
                        getPanelChildren:function(){
                            return this.get(0).children;
                        },
                        e1:function(profile, item, e, src, type){},
                        e2:function(profile, key, control, shift, alt, e, src){},
                        e3:function(profile, e, shift, src){},
                        e4:function(profile, e, src, key, data, item){},
                        e5:function(profile, e, src){}
                    },
                    Static:{
                        DataModel:{
                            dragKey:'',
                            dropKeys:''
                        },
                        $abstract:true
                    }
                });
            var src=linb.absPlus.prototype;

            if(hash.HoverEffected){
                _.each(hash.HoverEffected,function(o,i){
                    t=map[i]?hash:(hash[i]||(hash[i]={}));
                    if(!o)
                        t.afterMouseover = t.afterMouseout = null;
                    else{
                        t.afterMouseover = f(o,'mouseover', 1);
                        t.afterMouseout = f(o,'mouseout', 2);
                    }
                });
                hls.beforeHoverEffect=src.e1;
            }
            if(hash.ClickEffected){
                _.each(hash.ClickEffected,function(o,i){
                    t=map[i]?hash:(hash[i]||(hash[i]={}));
                    if(!o)
                        t.afterMousedown = t.afterMouseup = null;
                    else{
                        t.afterMousedown = f(o,'mousedown', 1);
                        t.afterMouseup = f(o,'mouseup', 2);
                    }
                });
                hls.beforeClickEffect=src.e1;
            }
            //for onHotKey
            if(hash.KeyHook){
                _.merge(hash,{
                    afterKeydown:function(profile, e, src){
                        if(profile.onHotKeydown){
                            var key = linb.Event.getKey(e);
                            return false !== profile.boxing().onHotKeydown(profile,key[0], !!key[1], !!key[2], !!key[3], e, src);
                        }
                    },
                    afterKeypress:function(profile, e, src){
                        if(profile.onHotKeypress){
                            var key = linb.Event.getKey(e);
                            return false !== profile.boxing().onHotKeypress(profile,key[0], !!key[1], !!key[2], !!key[3], e, src);
                        }
                    },
                    afterKeyup: function(profile, e, src){
                        if(profile.onHotKeyup){
                            var key = linb.Event.getKey(e);
                            return false !== profile.boxing().onHotKeyup(profile,key[0], !!key[1], !!key[2], !!key[3], e, src);
                        }
                    }
                },'all');
                hls.onHotKeydown=hls.onHotKeypress=hls.onHotKeyup=src.e2;
            }
            //for focus action
            if(hash.NavKeys){
                _.each(hash.NavKeys,function(o,i){
                    var map=arguments.callee, k, m1=map.m1||(map.m1={KEY:1,$key:1});
                    if(m1[i])return;
                    var m2=map.m2||(map.m2={input:1,textarea:1}),
                    m3=map.m3||(map.m3={tab:1,enter:1,up:1,down:1,left:1,right:1}),
                    m4=map.m4||(map.m4={tab:1,up:1,down:1,left:1,right:1}),
                    t=hash[i]||(hash[i]={});

                    if(null===o)
                        t.afterKeydown = null;
                    else{
                        t.afterKeydown = function(profile, e, src){
                            var k=linb.Event.getKey(e), key = k[0], shift=k[2], alt=k[3], b=false;
                            if(m2[k=src.tagName.toLowerCase()]){
                                if(m3[key]){
                                    var reg = linb([src]).caret(),txt=src.value;

                                    switch(key){
                                        case 'up':
                                            if(!/[\n\r]/.test(txt.substr(0,reg[0]))) b=true;
                                            break;
                                        case 'left':
                                            if(reg[0]===0 && (reg[1]!==txt.length || reg[1]===0)) b=true;
                                            break;
                                        case 'down':
                                            if(!/[\n\r]/.test(txt.substr(reg[1],txt.length))) b=true;
                                            break;
                                        case 'right':
                                            if(reg[1]===txt.length && (reg[0]!==0 || reg[1]===0)) b=true;
                                            break;
                                        default:
                                            if(k=='input'|| alt)b=true;
                                            break;
                                        case "tab":
                                            b=true;
                                            break;
                                    }
                                }
                            }else
                                if(m4[key])
                                    b=true;
                            //hanlder focus
                            if(b){
                                //export event
                                if(profile.beforeNextFocus && false === profile.boxing().beforeNextFocus(profile,key,!!shift,e))return false;

                                if(key!='tab')
                                    linb(src).nextFocus(('up'==key || 'left'==key)?false:true);
                            }
                        }
                    }
                });
                hls.beforeNextFocus=src.e3;
            }
            if((t=hash.DropableKeys) && t.length){
                _.arr.each(t,function(o){
                    self._dropable(o)
                });

                t=self.prototype;
                _.arr.each('addPanel,removePanel,getPanelPara,getPanelChildren,getDropKeys,setDropKeys'.split(','),function(o){
                    if(!t[o])t[o]=src[o];
                });
                self.$DataModel.dropKeys=self.$DataStruct.dropKeys='';
                hls.onDragEnter=hls.onDragLeave=hls.onDrop=hls.onDropTest=hls.onDropMarkShow=hls.onDropMarkClear=src.e4;
            }
            if((t=hash.DragableKeys)&& t.length){
                _.arr.each(t,function(o){
                    self._dragable(o)
                });
                t=self.prototype;
                _.arr.each('getDragKey,setDragKey'.split(','),function(o){
                    if(!t[o])t[o]=src[o];
                });
                self.$DataModel.dragKey=self.$DataStruct.dragKey='';
                hls.onStartDrag=hls.onDragStop=src.e5;
            }
            self.setEventHandlers(hls);
        },

        addTemplateKeys:function(arr){
            var self=this, key=self.KEY, me=arguments.callee, reg=me._reg||(me._reg=/\./g);
            _.arr.each(arr,function(i){
                self.$cssKeys[i]=(self.$Keys[i]=i=='KEY'?key:key+"-"+i).replace(reg,'-').toLowerCase().replace('linb-ui','linb');
            });
            return self;
        },
        getTheme:function(){
            return this.$theme;
        },
        setTheme:function(key){
            key=key||'default';
            if(key!=this.$theme){
                if(key!='default')
                    linb.CSS.includeLink(linb.getPath('linb.appearance.'+key,'/theme.css'),'theme:'+key);
                var o=linb.CSS.get('id','theme:'+this.$theme);
                if(o){
                    o.disabled=true;
                    linb(o).remove(false);
                }
                this.$theme=key;
            }
            return this;
        },
        setAppearance:function(hash){
            _.merge(this.$Appearances,hash,'all');
            return this;
        },
        getAppearance:function(){
            return this.$Appearances;
        },
        /*replace mode*/
        setTemplate:function(hash, cacheId){
            if(hash){
                var self=this,
                    me=arguments.callee,
                    r2=me.r2||(me.r2=/[a-z]/),
                    sc=linb.absObj.$specialChars,
                    _ks=['KEY'],
                    fun = me._fun || (me._fun=function(hash, arr){
                        var o,i;
                        for(i in hash){
                            if(!sc[i.charAt(0)])
                                if(!r2.test(i)){
                                    arr[arr.length]=i;
                                    o=hash[i];
                                    if(typeof o == 'object')
                                        arguments.callee(o, arr)
                                }
                        };
                    })
                    ,t;
                fun(hash,_ks);
                self.addTemplateKeys(_ks);

                t = self.$Templates;

                // for sub template,
                if(typeof cacheId=='string'){
                    hash._subid = cacheId;
                    t[cacheId]=hash;
                }else
                    t._=hash;

                //set sub
                if(t=hash.$dynamic)
                    for(var i in t)
                        for(var j in t[i])
                            me.call(self, t[i], j);
            }
            return this;
        },
        getTemplate:function(cacheId){
            return this.$Templates[cacheId||'_'];
        },
        /*replace mode*/
        setBehavior:function(hash){
            if(hash){
                var self=this,
                    check=linb.absObj.$specialChars,
                    handler = linb.Event.$EVENTHANDLER,
                    ehs='$eventhandler',
                    eventType=linb.Event._getEventType,
                    me=arguments.callee,
                    r1=me.r1||(me.r1=/[a-z]/),
                    r2=me.r2||(me.r2=/^(on|before|after)/),
                    t= self.$Behaviors,
                    m,i,j,o,v, type;
                //set shortcut first
                self._setDefaultBehavior(hash);
                //merge KEY
                if(hash.KEY){
                    _.merge(hash, hash.KEY, 'all');
                    delete hash.KEY;
                }
                //attach event handler
                for(i in hash){
                    o=hash[i];
                    if(!check[i.charAt(0)]){
                        //only two layer
                        if(!r1.test(i)){
                            m=t[i]||(t[i]={});
                            for(j in o){
                                v=o[j];
                                if(!check[j.charAt(0)]){
                                    type = eventType(j);
                                    if(v){
                                        /*set to behavior*/
                                        m[j]=v;
                                        /*add handler*/
                                        (m[ehs] || (m[ehs]={}))['on'+type]=handler;
                                    }else{
                                        delete m[j];
                                        if(t[ehs])delete t[ehs]['on'+type];
                                    }
                                }
                            }
                        }else if(r2.test(i)){
                            type = eventType(i);
                            if(o){
                                /*set to behavior*/
                                t[i]=o;
                                /*add handler*/
                                (t[ehs] || (t[ehs]={}))['on'+type]=handler;
                            }else{
                                delete t[i];
                                if(t[ehs])delete t[ehs]['on'+type];
                            }
                        //for those special keys
                        }else
                            t[i]=o;
                    }
                }
            }

            return self;
        },
        getBehavior:function(){
            return this.$Behaviors;
        },
        $applyCSS:function( ){
            var self=linb.UI, cache=self.$cache_css;
            if(cache){
                if(!self.$cssNo)self.$cssNo=1;
                linb.CSS.addStyleSheet(cache, 'linb.UI-CSS'+(self.$cssNo++));
                self.$cache_css='';
            }
        },
        buildCSSText:function(hash){
            var self=this,
                me=arguments.callee,
                r1=me._r1||(me._r1=/(^|\s|,)([0-9A-Z_]+)/g),
                h=[], r=[],
                browser=linb.browser,
                ie6=browser.ie6,
                ie=browser.ie,
                gek=browser.gek,
                ks=self.$cssKeys,
                t,v,o;

            for(var i in hash){
                o=hash[i];
                t=i.replace(r1,function(a,b,c){return  b + '.' + (ks[c]||c)}).toLowerCase();
                o.$order=parseInt(o.$order)||0;
                o.$=t;
                h[h.length]=o;
            };
            h.sort(function(x,y){
                x=x.$order;y=y.$order;
                return x>y?1:x==y?0:-1;
            });

            for(var i=0,l=h.length;i<l;){
                o=h[i++];
                r[r.length]=o.$+"{";
                if(t=o.$before)r[r.length]=t;
                if(t=o.$text)r[r.length]=t;
                for(var j in o){
                    switch(j.charAt(0)){
                        case '$':continue;break;
                        case '_':if(!ie6)continue;break;
                        case '*':if(!ie)continue;break;
                        case '-':if(!gek)continue;break;
                    }
                    //neglect '' or null
                    if((v=o[j])||o[j]===0){
                        //put string dir
                        switch(typeof v){
                        case 'string':
                        case 'number':
                            r[r.length]=j+":"+v+";";break;
                        case 'function':
                            r[r.length]=j+":"+v(self.KEY)+";";break;
                        //arrray
                        default:
                            _.arr.each(v,function(k){
                                //neglect '' or null
                                if(k)r[r.length]=j+":"+k+";";
                            });
                        }
                    }
                }
                if(v=o.$after)r[r.length]=v;
                r[r.length]="}";
            }
            return r.join('');
        },
        _dropable:function(key){
            var self=this,
                h2=linb.Event.$EVENTHANDLER2,
                o=self.$Behaviors,
                v=key=='KEY'?o:(o[key]||(o[key]={}));
            //attach Behaviors
            _.merge(v, {
                beforeMouseover:function(profile, e, src){
                    if(profile.properties.disabled||profile.properties.readonly)return;
                    var self=this,
                        dd = linb.DragDrop,
                        pp = dd.getProfile(),
                        key = pp.dragKey,
                        data = pp.dragData,
                        item,box,t,args
                        ;

                    //not include the dragkey
                    if(!key
                    || !data
                    || !(new RegExp('\\b'+key+'\\b')).test(profile.box.getDropKeys(profile, self))
                    )return;

                    box=profile.boxing();
                    if(box.getItemByDom)
                        item=box.getItemByDom(src);

                    args=[profile, e, self, key, data, item];
                    if((t=profile.onDropTest) && (false===box.onDropTest.apply(box,args)))
                        return;
                    if((t=profile.box._onDropTest) && (false===t.apply(profile.host||profile, args)))
                        return;
                    //for trigger onDrop
                    dd.setDropElement(src);
                    if(profile.onDropMarkShow && (false===box.onDropMarkShow.apply(box,args))){}
                    else if((t=profile.box._onDropMarkShow) && (false===t.apply(profile.host||profile, args))){}
                    else
                        //show region
                        _.resetRun('setDropFace', dd.setDropFace, 0, [self], dd);

                    if(t=profile.box._onDragEnter)t.apply(profile.host||profile, args);
                    if(profile.onDragEnter)box.onDragEnter.apply(box,args);
                    //dont return false, multi layer dd wont work well
                    //return false;
                },
                beforeMouseout:function(profile, e, src){
                    if(profile.properties.disabled||profile.properties.readonly)return;
                    var self=this,
                        dd = linb.DragDrop,
                        pp = dd.getProfile(),
                        key = pp.dragKey,
                        data = pp.dragData,
                        item, box, args;
                    //not include the dragkey
                    if(pp.dropElement==src.id){
                        box=profile.boxing();
                        if(box.getItemByDom)
                            item=box.getItemByDom(src);

                        args=[profile, e, self, key, data, item];
                        if(profile.onDropMarkClear && (false===box.onDropMarkClear.apply(box,args))){}
                        else if((t=profile.box._onDropMarkClear) && (false===t.apply(profile.host||profile, args))){}
                        else _.resetRun('setDropFace', dd.setDropFace, 0, [null], linb.DragDrop);

                        if(t=profile.box._onDragLeave)t.apply(profile.host||profile, args);
                        if(profile.onDragLeave)box.onDragLeave.apply(box,args);
                        dd.setDropElement(null);
                    }
                    //return false;
                },
                beforeDrop:function(profile, e, src){
                    var self=this,
                        dd = linb.DragDrop,
                        pp = dd.getProfile(),
                        key = pp.dragKey,
                        data = pp.dragData,
                        item,t,args,
                        box=profile.boxing();
                    if(box.getItemByDom)
                        item=box.getItemByDom(src);
                    args=[profile, e, self, key, data, item];

                    if(profile.onDropMarkClear && (false===box.onDropMarkClear.apply(box,args))){}
                    else if((t=profile.box._onDropMarkClear) && (false===t.apply(profile.host||profile, args))){}

                    if(profile.onDrop && (false===box.onDrop.apply(box,args))){}
                    else if((t=profile.box._onDrop) && (false===t.apply(profile.host||profile, args))){}
                }
            }, 'all');
            _.merge(v.$eventhandler||(v.$eventhandler={}),{
                onmouseover:h2,
                onmouseout:h2,
                ondrop:h2
            });
            return self;
        },
        _dragable:function(key){
            var self=this,
                h2=linb.Event.$EVENTHANDLER2,
                o=self.$Behaviors,
                v=key=='KEY'?o:(o[key]||(o[key]={}));
            //attach Behaviors
            _.merge(v, {
                beforeMousedown:function(profile, e, src){
                    if(profile.properties.disabled)return;
                    //not resizable or drag
                    if(!profile.properties.dragKey)return;
                    var pos=linb.Event.getPos(e),box=profile.boxing(),args=[profile,e,src],t;
                    if(profile.onStartDrag && (false===box.onStartDrag.apply(box,args))){}
                    else if((t=profile.box._onStartDrag) && (false===t.apply(profile.host||profile, args))){}
                    else{
                        linb([src]).startDrag(e, {
                            dragType:'icon',
                            targetLeft:pos.left+12,
                            targetTop:pos.top+12,
                            dragCursor:'pointer',
                            dragDefer:1,
                            dragKey: profile.box.getDragKey(profile, this),
                            dragData: profile.box.getDragData(profile, this)
                        });
                    }
                },
                beforeDragbegin:function(profile, e, src){
                    linb(src).onMouseout(true,{$force:true}).onMouseup(true);
                },
                beforeDragstop:function(profile, e, src){
                    var t;
                    if(profile.onDragStop)profile.boxing().onDragStop(profile.e,src);
                    if(t=profile.box._onDragStop)t.apply(profile.host||profile, arguments);
                }
            }, 'all');
            _.merge(v.$eventhandler||(v.$eventhandler={}),{
                onmousedown:h2,
                ondragbegin:h2
            });

            return self;
        },
        /*copy item to hash, use 'without'
        exception: key start with $
        value(start with $) get a change to get value from lang setting
        */
        adjustData:function(profile, hashIn, hashOut){
            if(!hashOut)hashOut={};
            var i,o,w=linb.wrapRes,me=arguments.callee,r=me._r||(me._r=/\B\$([\w]+[\.][\w\.]+[\w])/g);
            for(i in hashIn){
                if(i.charAt(0)=='$')continue;
                if(!(i in hashOut))
                    hashOut[i] = typeof (o=hashIn[i])=='string' ?
                              (
                                  ((o.indexOf('$')!=-1) ? (o=o.replace(r, function(a,b){return w(b)})) : o)
                                &&((o.charAt(0)=='@') ? (linb.SC.get(o.substr(1,o.length)) || o) : o)
                              ) : o;
            }
            if((typeof (o=hashOut.renderer)=='function') || (typeof (o=hashIn.renderer)=='function'))
                hashOut.caption=o(hashIn,hashOut,profile);

            if('disabled' in hashIn)
                hashOut.disabled=hashIn.disabled?'ui-disabled':'';

            //todo: change it
            hashOut.iconDisplay = hashIn.image?'':'display:none';
            return hashOut;
        },

        cacheData:function(key, obj){
            _.set(linb.cache,['UIDATA', key], obj);
            return this;
        },
        getCachedData:function(key){
            var r = _.get(linb.cache,['UIDATA', key]);
            if(typeof r == 'function')r=r();
            return _.clone(r);
        },


        DataModel:{
            tag:'',
            tagVar:{
                ini:{}
            },
            disabled:{
                ini:false,
                action: function(v){
                    this.root.css('opacity',v?0.5:1);
                }
            },
            dock:{
                ini:'none',
                listbox:['none','top','bottom','left','right','center','middle','origin','width','height','fill','cover'],
                action:function(v){
                    var self=this;
                    if(self.domNode)
                        linb.UI.$dock(self,true);
                }
            },
            dockIgnore:{
                ini:false,
                action:function(v){
                    var self=this;
                    if(!v && self.domNode && self.properties.dock!='none')
                            linb.UI.$dock(self,true,true);
                }
            },
            dockOrder:{
                ini: 1,
                action:function(v){
                    var self=this;
                    if(self.domNode && self.properties.dock!='none')
                        linb.UI.$dock(self,true,true);
                }
            },
            dockMargin:{
                ini:{left:0,top:0,right:0,bottom:0},
                action:function(v){
                    var self=this;
                    if(self.domNode && self.properties.dock!='none')
                        linb.UI.$dock(self,true,true);
                }
            },
            dockFloat:{
                ini:false,
                action:function(v){
                    var self=this;
                    if(self.domNode && self.properties.dock!='none')
                        linb.UI.$dock(self,true,true);
                }
            },
            dockMinW:0,
            dockMinH:0,
            tips:''
        },
        EventHandlers:{
            onRender:function(profile){},
            onLayout:function(profile){},
            onDestroy:function(profile){},
            beforeDestroy:function(profile){},
            onShowTips:function(profile, node, pos){}
        },
        RenderTrigger:function(){
            var self=this, b=self.boxing(),p=self.properties;
            //avoid the resize blazzing
            if(self.box._onresize){
                var style=self.domNode.style,t
                if((t=style.visibility)!='hidden'){
                   self._$v=t;
                   style.visibility='hidden';
                }
                linb.UI.$tryResize(self,p.width,p.height);
            }

            if(p.disabled)
                b.setDisabled(true,true);

            self.inValid=1;
            self.rendered=true;
            if(self.onRender)
                b.onRender(self);
        },
        $tryResize:function(profile,w,h,key,force){
            var s=profile.box,t=s._onresize,args=profile.$rs_args;
            if(t&&(w||h)){
                if(!args){
                    args=profile.$rs_args=[profile,null,null];
                    _.asyRun(profile.$resizeFun=function(){
                        delete profile.$rs_args;
                        delete profile.$resizeFun;
                        //destroyed before resize
                        if(!linb.Dom.byId(profile.domId))return;
                        t.apply(s,args);
                        var style=profile.domNode.style;
                        if('_$v' in profile){
                            //some control will set visible to recover the css class
                            if(style.visibility!='visible')
                                style.visibility=profile._$v;
                            delete profile._$v;
                        }
                    });
                }
                //keep the last one
                if(w)args[1]=w;
                if(h)args[2]=h;
                args[3]=key;
            }
            if(force)_.tryF(profile.$resizeFun);
        },
        LayoutTrigger:function(){
            var self=this, b=self.boxing(),p=self.properties;
            if(p.dock && p.dock != 'none'){
                //first time, ensure _onresize to be executed.
                if(!self.$laidout){
                    self.$laidout=1;
                    var stl=self.domNode.style;
                    switch(p.dock){
                        case 'top':
                        case 'bottom':
                        case 'width':
                            stl.width=0;
                            break;
                        case 'left':
                        case 'right':
                        case 'height':
                            stl.height=0;
                            break;
                        default:
                            stl.width=stl.height=0;
                    }
                }
                linb.UI.$dock(this,true);
            }
            if(self.onLayout)
                b.onLayout(self);
        },
        $dock:function(profile, flag, force){
            var prop = profile.properties,
                margin=prop.dockMargin,
                node = profile.root,
                value = prop.dock || 'none',
                p= node.parent(),
                auto = 'auto',
                pid=p.id(),
                order=function(x,y){
                    x=parseInt(x.properties.dockOrder)||0;y=parseInt(y.properties.dockOrder)||0;
                    return x>y?1:x==y?0:-1;
                },
                win=false,
                region,
                inMatix='$inMatix',
                f,t,
                //for ie6 1px bug
                _adjust=function(v){return linb.browser.ie6?v-v%2:v}


            //attached to matix
            if(pid && _.str.startWith(pid,linb.Dom._matixid))
                return;

            if(profile.$dockParent!=pid || profile.$dockType != value || force){
                profile.$dockParent=pid;
                profile.$dockType = value;

                //unlink first
                profile.unLink('$dock');
                profile.unLink('$dock1');
                profile.unLink('$dock2');

                //set the fix value first
                switch(value){
                    case 'middle':
                        region={right:auto, bottom:auto,left:prop.left||'',width:prop.width||'',height:prop.height||''};
                        break;
                    case 'center':
                        region={right:auto, bottom:auto,top:prop.top||'',width:prop.width||'',height:prop.height||''};
                        break;
                    case 'origin':
                        region={right:auto, bottom:auto,width:prop.width||'',height:prop.height||''};
                        break;
                    case 'top':
                        region={left:margin.left, right:margin.right, bottom:auto, height:prop.height||''};
                        //width top
                        break;
                    case 'bottom':
                        region={left:margin.left, right:margin.right, top:auto, height:prop.height||''};
                        //width bottom
                        break;
                    case 'left':
                        region={right:auto,width:prop.width||''};
                        //height top left
                        break;
                    case 'right':
                        region={left:auto,width:prop.width||''};
                        //height top right
                        break;
                    case 'width':
                        region={bottom:auto,height:prop.height||'',top:prop.top||''};
                        //width left
                        break;
                    case 'height':
                        region={right:auto,width:prop.width||'',left:prop.left||''};
                        //height top
                        break;
                    case 'fill':
                    case 'cover':
                        region={right:auto,bottom:auto};
                        break;
                    case 'none':
                        region={left:prop.left, top:prop.top, width:prop.width||'',height:prop.height||''};
                        break;
                }
                node.cssRegion(region,true);
                //if in body, set to window
                if(p.get(0)===document.body){
                    p=linb.win;
                    win=true;
                    if(win && !linb.cache._resizeTime)linb.cache._resizeTime=1;
                }
                //set dynamic part
                if(value != 'none'){
//                        if(!win)p.css('overflow','hidden');

                    f = p.$getEvent('onSize','dock');
                    if(!f){
                        f=function(p,arg){
                            //get self vars
                            var me=arguments.callee,
                                map=me.map ||(me.map={middle:1,center:1}),
                                arr = me.arr,
                                rePos=me.rePos,
                                node=me.node,
                                style=node.get(0).style,
                                win=me.win,
                                obj,i,k,o,key,target
                            ;
                            //window resize: check time span, for window resize in firefox
                            //force call when input $dockid
                            //any node resize
                            if( arg.$dockid || !win || (_() - linb.cache._resizeTime > 100)){
                                //recruit call, give a short change
                                obj = {left:0,top:0,right:0,bottom:0,width:parseInt(style&&style.width)||node.width(),height:parseInt(style&&style.height)||node.height()};

                                for(k=0;key=arr[k++];){
                                    target = me[key];
                                    if(target.length){
                                        if(!map[key])arg.width=arg.height=1;
                                        for(i=0;o=target[i++];)
                                            if(!o.properties.dockIgnore)
                                                rePos(o, obj, key, arg.$dockid, win||arg.width, win||arg.height);

                                    }
                                }
                                if(obj.later){
                                    _.each(obj.later, function(o){
                                        //for safari
                                        try{
                                            o.node.cssRegion(o, true);
                                        }catch(e){
                                            _.asyRun(function(){
                                                o.width+=1;o.height+=1;
                                                o.node.cssRegion(o, true);
                                            })
                                        }
                                    });
                                }

                                //if window resize, keep the timestamp
                                if(win)
                                    linb.cache._resizeTime = _();
                            }
                        };
                        //self refrence
                        f.node=p;
                        f.arr=['top','bottom','left','right','center','middle','width','height'];
                        _.arr.each(f.arr,function(key){
                            f[key]=[];
                        });
                        //is window resizer
                        f.win = win;
                        f.rePos=function(profile, obj, value, id, w, h){
                            //if $dockid input, and not the specific node, return
                            var flag=false;
                            if(id && profile.$id!=id)flag=true;
                            var prop = profile.properties,
                                flt=prop.dockFloat,
                                margin = prop.dockMargin,
                                node = profile.root,
                                style = profile.domNode.style,
                                left, top, right, bottom,temp, other,
                                x = parseInt(prop._dockBorderWidth) || 0,
                                y = parseInt(prop._dockBorderHeight) || 0,
                                region={}
                                ;
                            //top/bottom/left/right must be set by order first
                            switch(value){
                                case 'middle':
                                    //use height() is ok
                                    node.top((obj.height - node.height())/2);
                                    break;
                                case 'center':
                                    node.left((obj.width - node.width())/2);
                                    break;
                                case 'top':
                                    if(!flag){
                                        left=margin.left;
                                        right=margin.right;
                                        top=(flt?0:obj.top)+margin.top;
                                        if(parseFloat(style.top)!=top)region.top=top;
                                        temp=obj.width - left - right - x;
                                        if(parseFloat(style.width)!=temp)region.width=_adjust(temp);
                                        if(!_.isEmpty(region))node.cssRegion(region,true);
                                    }

                                    if(!flt)
                                        obj.top += (node.offsetHeight() + margin.top + margin.bottom);
                                    break;
                                case 'bottom':
                                    if(!flag){
                                        left=margin.left;
                                        right=margin.right;
                                        bottom=(flt?0:obj.bottom)+margin.bottom;
                                        if(parseFloat(style.bottom)!=bottom)region.bottom=bottom;
                                        temp=obj.width - left - right - x;
                                        if(parseFloat(style.width)!=temp)region.width=_adjust(temp);
                                        if(!_.isEmpty(region))node.cssRegion(region,true);
                                    }
                                    if(!flt)
                                        obj.bottom += (node.offsetHeight() + margin.top + margin.bottom);
                                    break;
                                case 'left':
                                    if(!flag){
                                        left=(flt?0:obj.left)+margin.left;
                                        top=(flt?0:obj.top)+margin.top;
                                        bottom=(flt?0:obj.bottom)+margin.bottom;
                                        if(parseFloat(style.left)!=left)region.left=left;
                                        if(parseFloat(style.top)!=top)region.top=top;
                                        temp=obj.height - top - bottom - y;
                                        if(parseFloat(style.height)!=temp)region.height=_adjust(temp);
                                        if(!_.isEmpty(region))node.cssRegion(region,true);
                                    }
                                    if(!flt)
                                        obj.left += (node.offsetWidth() + margin.left + margin.right);
                                    break;
                                case 'right':
                                    //if no top/bottom and change w only
                                    if(!flag){
                                        right=(flt?0:obj.right)+margin.right;
                                        top=(flt?0:obj.top)+margin.top;
                                        bottom=(flt?0:obj.bottom)+margin.bottom;
                                        if(parseFloat(style.right)!=right)region.right=right;
                                        if(parseFloat(style.top)!=top)region.top=top;
                                        temp=obj.height - top - bottom - y;
                                        if(parseFloat(style.height)!=temp)region.height=_adjust(temp);
                                        if(!_.isEmpty(region))node.cssRegion(region,true);
                                    }
                                    if(!flt)
                                        obj.right += (node.offsetWidth() + margin.left + margin.right);
                                    break;
                                case 'width':
                                    //if no top/bottom/left/right and change h only
                                    if(!w)return;
                                    left = (prop.dock=='cover'?0:(flt?0:obj.left)) + margin.left;
                                    right = (prop.dock=='cover'?0:(flt?0:obj.right))  + margin.right;
                                    top = prop.dock=='width'?(parseInt(prop.top) || 0):( (prop.dock=='cover'?0:(flt?0:obj.top)) + margin.top);
                                    //later call for w/h change once
                                    temp=obj.width - left - right - x;
                                    obj.later=obj.later||{};
                                    obj.later[profile.$id] = obj.later[profile.$id] || {};
                                    _.merge(obj.later[profile.$id],{
                                        node:node,
                                        width: _adjust(prop.dockMinW?Math.max(prop.dockMinW,temp):temp),
                                        left:left,
                                        top:top
                                    },'all');
                                    break;
                                case 'height':
                                    //if no top/bottom/left/right and change w only
                                    if(!h)return;
                                    top = (prop.dock=='cover'?0:(flt?0:obj.top)) + margin.top;
                                    bottom = (prop.dock=='cover'?0:(flt?0:obj.bottom))  + margin.bottom;
                                    left = prop.dock=='height'?(parseInt(prop.left) || 0):((prop.dock=='cover'?0:(flt?0:obj.left))+ margin.left);
                                    //later call for w/h change once
                                    temp=obj.height - top - bottom - y;
                                    obj.later=obj.later||{};
                                    obj.later[profile.$id] = obj.later[profile.$id] || {};
                                    _.merge(obj.later[profile.$id],{
                                        node:node,
                                        height: _adjust(prop.dockMinH?Math.max(prop.dockMinH,temp):temp),
                                        left:left,
                                        top:top
                                    },'all');

                                    break;
                            }
                        };

                        //add handler to window or node
                        p.onSize(f,'dock');
                    }
                    //set link to node
                    if(value=='fill' || value=='cover'){
                        profile.link(f.height, '$dock1');
                        profile.link(f.width, '$dock2');
                        f.height.sort(order);
                        f.width.sort(order);
                    }else if(value=='origin'){
                        profile.link(f.center, '$dock1');
                        profile.link(f.middle, '$dock2');
                    }else{
                        profile.link(f[value], '$dock');
                        f[value].sort(order);
                    }

                    //
                    linb.cache._resizeTime=1;

                    //set shortuct
                    profile.$dock=f;
                }//else{
                    //delete overflow form style
//                        if(!win)p.css('overflow', '');
                //}
            }
            //run once now
            if(value != 'none' && flag)
                profile.$dock(profile, {width:1, height:1, $dockid:_.arr.indexOf(['width','height','fill','cover'],value)!=-1?profile.$id:null, $type: value});
        },

        _beforeSerialized:function(profile){
            var r=profile.boxing(),b,t,o={};
            _.merge(o, profile, 'all');
            var p = o.properties = _.copy(profile.properties);
            switch(p.dock){
                case 'top':
                case 'bottom':
                    delete p.width;delete p.left;delete p.top;delete p.right;delete p.bottom;
                    break;
                case 'left':
                case 'right':
                    delete p.height;delete p.left;delete p.top;delete p.right;delete p.bottom;
                    break;
                case 'width':
                    delete p.width;delete p.left;delete p.right;
                    break;
                case 'height':
                    delete p.height;delete p.top;delete p.bottom;
                    break;
                case 'fill':
                case 'cover':
                    delete p.width;delete p.height;delete p.left;delete p.top;delete p.right;delete p.bottom;
                    break;
            }

            if(p.items && p.items.length){
                t=linb.absObj.$specialChars;
                p.items = _.clone(p.items,function(o,i){return !t[(i+'').charAt(0)]&&o!=undefined});
            }
            if(_.isEmpty(p.tagVar))
                delete p.tagVar;
            if((t=p.dockMargin)&&!t.left&&!t.top&&!t.right&&!t.bottom)
                delete p.dockMargin;
            if(p.items&&(p.items.length==0||p.listKey))
                delete p.items;

            return o;
        },
        getDropKeys:function(profile,node){
            return profile.properties.dropKeys;
        },
        getDragKey:function(profile,node){
            return profile.properties.dragKey;
        },
        getDragData:function(profile,node){
            return {
                profile:profile,
                domId:node.id
            };
        },
        _prepareData:function(profile, data){
            var prop = profile.properties,
                dm = this.$DataModel,
                me = arguments.callee,
                map = me.map || (me.map=_.toArr('left,top,bottom,right,width,height')),
                a=[],
                ajd=linb.UI.adjustData,
                t
                ;
            data = data||{};
            //can't input id in properties
            if(prop.id)delete prop.id;

            //give default caption
            if('caption' in dm && prop.caption!==null)
                prop.caption = prop.caption===undefined ? profile.alias : prop.caption;

            //give border width
            if('$border' in dm){
                data.bWidth=prop.width - (t=(prop.$border||0)*2);
                data.bHeight=prop.height - t;
            }
            //set left,top,bottom,right,width,height,position,z-index,visibility,display
            for(var j=0,i;i=map[j];j++){
                if(prop[i] || prop[i]===0){
                    if(String(parseFloat(prop[i]))==String(prop[i]))
                        a[a.length]=i+':'+(parseInt(prop[i])||0)+'px';
                    else if(prop[i]!='auto' && prop[i])
                        a[a.length]=i+':'+prop[i];
                }
            }
            if(prop.position)a[a.length] = 'position:'+prop.position;
            if(prop.visibility)a[a.length]= 'visibility:'+prop.visibility;
            if(prop.zIndex)a[a.length]= 'z-index:'+prop.zIndex;
            if(prop.display)a[a.length]= 'display:'+ (prop.display=='inline-block'? linb.browser.gek?'-moz-inline-block;display:-moz-inline-box;display:inline-block;':'inline-block' :prop.display)

            data._style = ';'+a.join(';')+';';

            if('href' in dm)data.href = prop.href || linb.$href;
            if('tabindex' in dm)data.tabindex = prop.tabindex || '-1';
            if('items' in dm){
                profile.ItemIdMapSubSerialId = {};
                profile.SubSerialIdMapItem = {};
                data.items = this._prepareItems(profile, prop.items);
            }

            //default prepare
            data =  ajd(profile, prop, data);

            profile.prepared=true;
            return data;
        },
        _prepareItems:function(profile, items, pid, mapCache, serialId){
            var result=[],
                item,dataItem,t,
                SubID=linb.UI.$tag_subId,id ,
                tabindex = profile.properties.tabindex,
                ajd=linb.UI.adjustData;
            //set map
            for(var i=0,l=items.length;i<l;i++){
                if(typeof items[i]!='object')
                    items[i]={id:items[i]};
                item=items[i];
                if(!('caption' in item))item.caption=item.id;

                dataItem={id: item.id};
                if(pid)dataItem._pid = pid;

                id=dataItem[SubID]=typeof serialId=='string'?serialId:profile.pickSubId('items');

                if(false!==mapCache){
                    profile.ItemIdMapSubSerialId[item.id] = id;
                    profile.SubSerialIdMapItem[id] = item;
                }
                if(t=item.object){
                    t=dataItem.object=t['linb.absBox']?t.get(0):t;
                    //relative it.
                    if(t['linb.UIProfile'])
                        t.properties.position='relative';
                    item.$id=t.$id;
                    t.$item=item;
                    t.$holder=profile;
                    if(!profile.$attached)profile.$attached=[];
                    profile.$attached.push(t);
                }else{
                    dataItem._tabindex=tabindex;
                    //others
                    ajd(profile, item, dataItem);
                    if(this._prepareItem)
                        this._prepareItem(profile, dataItem, item, pid, mapCache, serialId);
                }
                result.push(dataItem);
            }

            return result;
        },
        _showTips:function(profile, node, pos){
            if(profile.onShowTips)
                return profile.boxing().onShowTips(profile, node, pos);
        }
    }
});
//absList cls
Class("linb.absList", "linb.absObj",{
    Instance:{
        activate:function(){
            var profile = this.get(0),
                items = profile.getSubNode('ITEM',true);
            if(!items.isEmpty())
                items.focus();
            return this;
        },
        /*
        [x] ,valid id   ,true  => insert [x] before node
        [x] ,valid id   ,false => insert [x ]after node
        [x] ,null ,true  => insert [x ] to head
        [x] ,null ,false => insert [x ] to tail
        [x] => html([x ])
        */
        insertItems:function(arr, base, before){
            if(!arr || !arr.length)return;
            var node,
                items, index, r,
                data,box,
                b=this._afterInsertItems;
            return this.each(function(profile){
                box=profile.box;
                items = profile.properties.items;
                index = _.arr.subIndexOf(items,'id',base);
                if(index==-1){
                    items.push.apply(items,arr);
                }else
                    _.arr.insertAny(items,arr, before?index:index+1);

                //if in dom, create it now
                if(profile.domNode){
                    // prepare properties format
                    data = box._prepareItems(profile, arr, base);

                    var ss=profile.buildItems('items', data);
                    if(index==-1){
                        //if no base specified, use innerHtml dir
                        node = profile.getSubNode(box.ITEMSKEY || profile.keys.ITEMS || profile.keys.KEY);

                        if(typeof before=="boolean"){
                            r=_.str.toDom(ss);
                            //items.length==1 for that one have fake item(for example: editable poll)
                            if(before||items.length==1)
                                node.prepend(r);
                            else
                                node.append(r);
                        }else
                            node.html(ss);
                    }else{
                        r = _.str.toDom(ss);
                        node=profile.getSubNodeByItemId(box.ITEMKEY || 'ITEM', base);
                        if(before===true)
                            node.addPrev(r);
                        else
                            node.addNext(r);
                    }
                    if(b)profile.boxing()._afterInsertItems(profile, data, base, before);
                }
            });
        },
        removeItems:function(arr, key){
            if(!(arr instanceof Array))arr=[arr];
            var obj,v,
                b=this._afterRemoveItems;
                remove=function(profile, arr, target, ns, force){
                    var self=arguments.callee;
                    if(!ns)ns=linb();
                    _.filter(arr,function(o){
                        var serialId,b;
                        if(force || (b=(_.arr.indexOf(target,o.id)!=-1))){
                            if(profile.domNode){
                                if(serialId=profile.ItemIdMapSubSerialId[o.id]){
                                    // clear maps
                                    delete profile.SubSerialIdMapItem[serialId];
                                    delete profile.ItemIdMapSubSerialId[o.id];
                                    profile.reclaimSubId(serialId, 'items');

                                    //parent node is deleted
                                    if(!force){
                                        if(!(obj = profile.getSubNode(profile.keys[key]?key:'ITEM', serialId) ).isEmpty() )
                                            ns.merge(obj);
                                        //for inner template or linb.UI
                                        if(o.$id)ns.get().push(linb.getObject(o.$id).getRootNode());
                                    }
                                }
                            }
                        }
                        //check sub
                        if(o.sub)self(profile, o.sub, target, ns, force || b);
                        //filter it
                        if(b){
                            for(var i in o)o[i]=null;
                            return false;
                        }
                    });
                    ns.remove();
                };
            return this.each(function(profile){
                var p=profile.properties;
                // clear properties
                remove(profile, p.items, arr);
                // clear value
                if(v=p.value){
                    if((v=v.split(';')).length>1){
                        _.filter(v,function(o){
                            return _.arr.indexOf(arr,o)==-1;
                        });
                        p.value=v.join(';');
                    }else{
                        if(_.arr.indexOf(arr,p.value)!=-1)
                            p.value=null;
                    }
                }
                if(b && profile.domNode)
                    profile.boxing()._afterRemoveItems(profile, arr);
            });
        },
        clearItems:function(key){
            return this.each(function(profile){
                if(!profile.SubSerialIdMapItem)return;
                //empty dom
                profile.getSubNode(profile.keys[key] || profile.keys.ITEMS || 'KEY', true).empty();
                //save subid
                _.each(profile.SubSerialIdMapItem, function(o,serialId){
                    profile.reclaimSubId(serialId, 'items');
                });
                //delete items
                profile.properties.items.length=0;
                //clear cache
                profile.SubSerialIdMapItem={};
                profile.ItemIdMapSubSerialId={};

                //keep the value
                //profile.properties.value=null;
            });
        },
        updateItem:function(subId,options){
            var self=this,
                profile=self.get(0),
                box=profile.box,
                items=profile.properties.items,
                item=profile.queryItems(items,function(o){return o.id==subId},true,true),
                serialId,node;
            if(item.length){
                item=item[0];
                _.merge(item, options, 'all');
                item.id=subId;

                //prepared already?
                serialId=_.get(profile,['ItemIdMapSubSerialId',subId]);
                arr=box._prepareItems(profile, [item],item._pid,false, serialId);

                //in dom already?
                node=profile.getSubNodeByItemId('ITEM',subId);
                if(!node.isEmpty()){
                    //for the sub node
                    if(items.sub){
                        delete item._created;
                        delete item._checked;
                    }
                    node.outerHTML(profile.buildItems(arguments[2]||'items',arr));
                }
            }
            return self;
        },
        fireItemClickEvent:function(subId){
            var profile = this.get(0),
                node =profile.getSubNodeByItemId('ITEM', subId);
            if(node.isEmpty()){
                profile.boxing().setUIValue(null);
            }else
                node.onClick();
            return this;
        }
    },
    Initialize:function(){
        var o=this.prototype;
        _.arr.each(_.toArr('getItemByItemId,getItemByDom,getSubIdByItemId,getSubNodeByItemId'),function(s){
            o[s]=function(){
                var t=this.get(0);
                return t[s].apply(t,arguments);
            };
            Class._fun(o[s],s,o.KEY);
        });
    },
    Static:{
        $abstract:true,
        DataModel:{
            listKey:{
                set:function(value, flag){
                    return this.each(function(o){
                        if(o.properties.listKey != value || flag){
                            var t = o.box.getCachedData(value);
                            if(t)
                                o.boxing().setItems(t);
                            else
                                o.boxing().setItems(o.properties.items);
                            o.properties.listKey = value;
                        }
                    });
                }
            },
            items:{
                ini:[],
                set:function(value){
                    return this.each(function(o){
                        if(o.domNode)o.boxing().clearItems().insertItems(value);
                        o.properties.items = value;
                    });
                }
            }
        },
        //
        _showTips:function(profile, node, pos){
            if(profile.onShowTips)
                return profile.boxing().onShowTips(profile, node, pos);

            var t=profile.properties,
                id=node.id,
                sid=profile.getSubId(id),
                map=profile.SubSerialIdMapItem,
                item=map&&map[sid];

            if(t.disabled)return;
            if(item && item.disabled)return;
            if(item && item.tips){
                linb.Tips.show(pos, item);
                return true;
            }else
                return false;
        }
    }
});

Class("linb.absValue", "linb.absObj",{
    Instance:{
        /*
        getUIValue:         return $UIvalue
        setUIValue:         set $UIvalue,and _setCtrlValue                   beforeUIValueSet/afterUIValueSet
        getValue:           return value
        setValue:           set value, set $UIvalue, and _setCtrlValue       beforeValueSet/afterValueSet
        resetValue:         reset value,UIvalue,Ctrlvalue not trigger event
        updateValue:        set $UIvalue to value

        _setCtrlValue:      change control value                *nedd to be overwritten
        _getCtrlValue:      get value from control              *nedd to be overwritten
        _setDirtyMark:      mark UI ctrl when value!==UIvalue   *nedd to be overwritten
        */
        _getCtrlValue:function(){return this.getUIValue()},
        _setCtrlValue:function(value){return this},
        _setDirtyMark:function(){return this},

        getValue:function(){return this.get(0).properties.value},
        getUIValue:function(){return this.get(0).properties.$UIvalue},
        resetValue:function(value){
            var self=this;
            self.each(function(profile){
                var r;
                if(typeof (r=profile.box._ensureValue)=='function')
                    value = r.call(profile.box, profile, value);
                profile.boxing()._setCtrlValue(profile.properties.$UIvalue = profile.properties.value = value);
                if(typeof(r=profile.$onValueSet)=='function')r.call(profile,value);
                profile.inValid=1;
            });
            self._setDirtyMark();
            return self;
        },
        setUIValue:function(value, force){
            var self=this;
            this.each(function(profile){
                var prop=profile.properties, r,
                    ovalue = prop.$UIvalue,
                    box = profile.boxing();
                if(ovalue !== value || force){
                    if(
                        false===profile.box._checkValid(profile, value) ||
                        (profile.beforeUIValueSet && false===(r=box.beforeUIValueSet(profile, ovalue, value)))
                      )
                        return;
                    //can get return value
                    if(r!==undefined)value=r;
                    //before _setCtrlValue
                    if(typeof (r=profile.box._ensureValue)=='function')
                        value = r.call(profile.box, profile, value);
                    if(typeof(r=profile.$onValueUpdated)=='function')r.call(profile,value);
                    //before value copy
                    if(profile.domNode)box._setCtrlValue(value);
                    //value copy
                    prop.$UIvalue = value;

                    if(profile.domNode)box._setDirtyMark();
                    if(profile.afterUIValueSet)box.afterUIValueSet(profile, ovalue, value);
                }
            });
            return this;
        },
        updateValue:function(){
            this.each(function(profile){
                var prop = profile.properties;
                if(profile.boxing().checkValid())
                    prop.value = prop.$UIvalue;
            });
            return this._setDirtyMark();
        },
        isDirtied:function(){
            var p = this.get(0).properties;
            return p.value !== p.$UIvalue;
        },
        checkValid:function(){
            var r=true;
            this.each(function(profile){
                var prop=profile.properties;
                //r must be at the end
                r = profile.box._checkValid(profile, prop.$UIvalue) && r;
                if(profile.domNode)
                    profile.boxing()._setDirtyMark();
            });
            return r;
        }
    },
    Static:{
        $abstract:true,
        DataModel:{
            dataBinder:{
                combobox:function(){
                    return _.toArr(linb.DataBinder._pool,true);
                },
                set:function(value,flag){
                    var ds,r;
                    return this.each(function(profile){
                        var p=profile.properties,
                            old = p.dataBinder;
                        if(old==value && !flag)return;
                        if(old)
                            linb.DataBinder._unBind(old, profile);
                        p.dataBinder=value;
                        linb.DataBinder._bind(value, profile);
                    });
                }
            },
            dataField:'',

            // setValue and getValue
            value:{
                ini:null,
                set:function(value, flag){
                    this.each(function(profile){
                        var p=profile.properties,r,
                            ovalue = p.value,
                            box=profile.boxing(),
                            nv=value;
                        //check value
                        if(ovalue!==nv || flag){
                            //check format
                            if(profile.box._checkValid(profile, nv)===false)return;
                            //if return false in beforeValueSet, not set
                            if(profile.beforeValueSet && false=== (r=box.beforeValueSet(profile, ovalue, nv)))return;
                            // can get return value
                            if(r!==undefined)nv=r;
                            //before _setCtrlValue
                            //ensure value
                            if(typeof (r=profile.box._ensureValue)=='function')
                                nv = r.call(profile.box, profile, nv);
                            if(typeof(r=profile.$onValueSet)=='function')r.call(profile,nv);
                            //before value copy
                            if(profile.domNode)box._setCtrlValue(nv);
                            //value copy
                            p.value = p.$UIvalue = nv;

                            profile.inValid=1;
                            if(profile.domNode)box._setDirtyMark();
                            if(profile.afterValueSet)box.afterValueSet(profile, ovalue, nv);
                        }
                    });
                    return this;
                }
            }
        },
        EventHandlers:{
           //$onValueSet
            beforeValueSet:function(profile, oldValue, newValue){},
            afterValueSet:function(profile, oldValue, newValue){},
            //$onValueUpdated
            beforeUIValueSet:function(profile, oldValue, newValue){},
            afterUIValueSet:function(profile, oldValue, newValue){},

            beforeDirtyMark:function(profile, dirty){}
        },
        RenderTrigger:function(){
            var self=this, b=self.boxing(),p=self.properties,t,value;
            p.$UIvalue = p.value;
            if(p.value !==undefined){
                value=p.value;
                if(typeof (t=self.box._ensureValue)=='function')
                    value = t.call(self.box, self, value);
                b._setCtrlValue(value);
            }

            if(t=p.dataBinder)b.setDataBinder(t,true);
            if(t=p.dataField)b.setDataField(t);
        },
        _checkValid:function(profile, value){
            return true;
        }
    }
});

//som base widgets Classes
new function(){
    var u='linb.UI';
    //Widget cls
    Class(u+".Widget", u,{
        Static:{
            Appearances:{
                KEY:{
                    'font-size':linb.browser.ie?0:null,
                    'line-height':linb.browser.ie?0:null
                }
            },
            Templates:{
                className:'widget-shell ',
                style:'{_style}',
                FRAME:{
                    className:'widget-frame ',
                    BORDER:{
                        style:'width:{bWidth}px;height:{bHeight}px;',
                        className:'widget-border'
                    }
                }
            },
            Behaviors:{
                KeyHook:true,
                onSize:function(profile,e){
                    //if fire onresize ,w/h must be set to style
                    var style = profile.domNode.style ,w=null,h=null;
                    if(e.width)
                        w=parseInt(style.width)||w;
                    if(e.height)
                        h=parseInt(style.height)||h;
                    linb.UI.$tryResize(profile,w,h);
                }
            },
            DataModel:{
                width:100,
                height:100,
                //hide props
                $paddingTop:0,
                $paddingLeft:0,
                $paddingBottom:0,
                $paddingRight:0,
                $border:0
            },
            RenderTrigger:function(){
                var self=this, p=self.properties, o=self.boxing();
                //for performance
                _.asyRun(function(){
                    if(!linb.Dom.byId(self.domId))return;
                    if((!self.$noB) && p.border && o._border)o._border(p.border);
                    if((!self.$noR) && p.resizer && o.setResizer)o.setResizer(p.resizer,true);
                    if((!self.$noS) && p.shadow && o._shadow)o._shadow(p.shadow);
                });
            },
            _onresize:function(profile,width,height){
                var o = profile.getSubNode('BORDER'), t = profile.properties,
                    left=null,top=null,ww=null,hh=null;
                if(null!==width){
                    width -= (t.$border*2 + t.$paddingLeft + t.$paddingRight);
                    /*for ie6 bug*/
                    /*for example, if single number, 100% width will add 1*/
                    /*for example, if single number, attached shadow will overlap*/
                    if(linb.browser.ie6)width=(parseInt(width/2))*2;
                    left=t.$paddingLeft;
                    ww=width;
                }
                if(null!==height){
                    height -= (t.$border*2 + t.$paddingTop + t.$paddingBottom);
                    if(linb.browser.ie6)height=(parseInt(height/2))*2;
                    top = t.$paddingTop;
                    hh=height;

                    /*for ie6 bug*/
                    if(linb.browser.ie6&&null===width)o.ieRemedy();
                }
                o.cssRegion({left:left,top:top,width:ww,height:hh});
                profile.getSubNode('CON').height(profile.getSubNode('TR1TD2').height());
                return { width :ww, height :hh};
            }
        }
    });
    Class(u+".Link", u,{
        Static:{
            Appearances:{
                KEY:{
                   'font-size':linb.browser.ie?'12px':null,
                   'line-height':linb.browser.ie?'14px':null
                }
            },
            Templates:{
                tagName:'a',
                style: '{_style}',
                href :"{href}",
                target:'{target}',
                tabindex: '{tabindex}',
                text:'{caption}'
            },
            Behaviors:{
                onClick:function(profile, e, src){
                    var r;
                    if(!profile.properties.disabled && profile.onClick)
                        r = profile.boxing().onClick(profile, e, src);
                    //**** if dont return false, this click will break sajax in IE
                    //**** In IE, click a href(not return false) will break the current script downloading
                    return r !==undefined?r:false;
                }
            },
            DataModel:{
                caption:{
                    ini:undefined,
                    action:function(v){
                        this.root.get(0).innerHTML = v;
                    }
                },
                href:{
                    ini:linb.$href,
                    action:function(v){
                        if(this.domNode)
                            this.root.attr('href',v);
                    }
                },
                target:{
                    action:function(v){
                        if(this.domNode)
                            this.root.attr('target',v);
                    }
                }
            },
            EventHandlers:{
                onClick:function(profile, e){}
            }
        }
    });
    Class(u+".Div", u,{
        Static:{
            Appearances:{
                KEY:{
                   // overflow:(linb.browser.gek && !linb.browser.gek3)?'auto':null,
                    outline:linb.browser.gek?'none':null,
                    zoom:linb.browser.ie6?'1':null,
                    background:linb.browser.ie?'url('+linb.ini.file_bg+') no-repeat left top':null
                }
            },
            Templates:{
                tagName:'div',
                style:'{_style}',
                //for firefox div focus bug: outline:none; tabindex:'-1'
                tabindex:'-1',
                text:'{html}'+linb.UI.$childTag
            },
            DataModel:{
                disabled:null,
                width:'100',
                height:'100',
                html:{
                    action:function(v){
                        //dont use .html() here
                        this.domNode.innerHTML = v;
                    }
                }
            }
        }
    });
    Class(u+".Tag", u+".Div",{
        Static:{
            Templates:{
                tagName:'div',
                style:'overflow:auto;border:dashed blue 1px;text-align:center;background:#EBEADB;{_style}',
                text:'{tagKey}'+linb.UI.$childTag
            },
            DataModel:{
                html:null,
                tagKey:{
                    action:function(v){
                        this.root.html(v);
                    }
                }
            },
            _l:_.toArr('left,top,bottom,right,width,height,zIndex,tabindex,position,dock,dockFloat,dockMinW,dockMinH,dockOrder,dockMargin'),
            //replace tag profile with other UI profile
            replace:function(tagProfile, profile, com){
                //reset properties
                _.arr.each(this._l,function(s){
                    if(s in tagProfile.properties)profile.properties[s]=tagProfile.properties[s];
                });
                _.merge(profile.CS,tagProfile.CS,'all');
                _.merge(profile.CC,tagProfile.CC,'all');

                //if parent exist, replace
                if(tagProfile.parent){
                    //get tag link
                    var clink = tagProfile.parent.children,
                        linkObj = clink['$'+tagProfile.$id],
                        index = _.arr.indexOf(clink,linkObj);
                    tagProfile.parent.boxing().append(profile, linkObj[1]);
                    // set to tag index
                    clink[index] = clink.pop();

                    //detach tag from parent
                    tagProfile.unLink('$parent');
                    delete tagProfile.parent;
                //for _nodes in com
                }else if(com){
                    _.arr.each(com._nodes,function(o,i){
                        if(o===tagProfile){
                            com._nodes[i]=profile;
                            return false;
                        }
                    });
                }

                if(tagProfile.domNode)
                    profile.boxing().renderOnto(tagProfile.domNode);
            }
        }
    });
    Class(u+".Pane", u+".Div",{
        Static:{
            Behaviors:{
                DropableKeys:['KEY']
            }
        }
    });
};Class("linb.UI.Image", "linb.UI",{
    Instance:{
        getRate:function(){
            return parseFloat(this.get(0)._rate) || 1;
        }
    },
    Static:{
        Templates:{
            tagName:'image',
            style:'{_style}',
            border:"0",
            width:"{width}",
            height:"{height}"
        },
        Behaviors:{
            HoverEffected:{KEY:'KEY'},
            ClickEffected:{KEY:'KEY'},
            DragableKeys:["KEY"],
            onError:function(profile, e, src){
                profile.boxing().onError(profile);
            },
            onLoad:function(profile, e, src){
                var i=new Image(), path=i.src=src.src,
                    size=profile.box._adjust(profile,i.width,i.height);
                profile.boxing().afterLoad(profile, path, size[0], size[1]);
            }
        },
        RenderTrigger:function(){
            var self=this, pro=self.properties, v=pro.src;
            if(v){
                pro.value=pro.$UIvalue='';
                self.boxing().setSrc(v,true);
            }
        },
        EventHandlers:{
            onError:function(profile){},
            beforeLoad:function(profile){},
            afterLoad:function(profile, path, width, height){}
        },
        _adjust:function(profile,width,height){
            var pro=profile.properties,
                src=profile.getRootNode();
            if(width>0 && height>0){
                var r1=pro.maxWidth/width, r2=pro.maxHeight/height,r= r1<r2?r1:r2;
                if(r>=1)r=1;
                profile._rate=r;
                src.width=width*r;
                src.height=height*r;
                return [width*r, height*r];
            }
            return [0,0];
        },
        DataModel:{
            maxWidth:{
                ini:800,
                action:function(v){
                    var src=this.getRootNode();
                    this.box._adjust(this,src.width,src.height);
                }
            },
            maxHeight:{
                ini:600,
                action:function(v){
                    var src=this.getRootNode();
                    this.box._adjust(this,src.width,src.height);
                }
            },
            width:{
                ini:'auto',
                action:function(v){
                    var src=this.getRootNode();
                    src.width=v;
                }
            },
            height:{
                ini:'auto',
                action:function(v){
                    var src=this.getRootNode();
                    src.height=v;
                }
            },

            src:{
                //use asyn mode
                action:function(v){
                    var self=this;
                    if(false!==self.boxing().beforeLoad(this))
                        _.asyRun(function(){self.root.attr({width:'0',height:'0',src:v})});
                }
            }
        }
    }
});//add/get/remove border to a dom node(display:block;position:absolute) / or a widget inherite from linb.UI.Widget
Class("linb.UI.Border","linb.UI",{
    Instance:{
        _attachTo:function(target, eventTrigger){
            var self=this, v=self.get(0);
            //add to dom
            target.append(self);
            //save id
            v.$edgeId = linb(target).id();
            v.$tieId = eventTrigger;
            //add event
            if(v.properties.borderActive){
                var t = v.behavior.TAG, tag='tag',n=v.domNode;
                if(linb.Dom.byId(eventTrigger))
                    linb(eventTrigger).afterMouseover(function(p,e){
                        _.tryF(t.afterMouseover,[v,e,n],this)
                    },tag).afterMouseout(function(p,e){
                        _.tryF(t.afterMouseout,[v,e,n],this)
                    },tag).afterMousedown(function(p,e){
                        _.tryF(t.afterMousedown,[v,e,n],this)
                    },tag).afterMouseup(function(p,e){
                        _.tryF(t.afterMouseup,[v,e,n],this)
                    },tag);
            }
            return target;
        },
        _detach:function(){
            var self=this, v=self.get(0),n,nl=null,tag='tag';
            if(n=v.$tieId)
                if(n=linb.Dom.byId(n))
                    linb(n).afterMouseover(nl,tag).afterMouseout(nl,tag).afterMousedown(nl,tag).afterMouseup(nl,tag);
            return self;
        }
    },
    Initialize:function(){
        //for linb.Dom
        _.each({
            addBorder :function(properties){
                var target = linb([this.get(0)]), eventTrigger=arguments[1]||target.id();
                return new linb.UI.Border(properties)._attachTo(target, eventTrigger);
            },
            $getBorder:function(){
                var s = this.id(), b;
                _.arr.each(linb.UI.Border._cache,function(o){
                    if(o.$edgeId==s){b=o;return false;}
                });
                return b && b.boxing();
            },
            removeBorder:function(){
                var s = this.id();
                _.arr.each(linb.UI.Border._cache,function(o){
                    if(o.$edgeId==s)
                        o.boxing()._detach().destroy();
                });
                return this;
            }
        },function(o,i){
            linb.Dom.plugIn(i,o);
        });
        //for linb.UI.Widget
        _.each({
            _border:function(key, args){
                return this.each(function(o){
                    var target = o.getSubNode('BORDER');
                    if(target.$getBorder())return;

                    var v = o.boxing(),
                        d = o.properties,
                        n = v.reBoxing(),
                        w = n.width(),
                        h = n.height(),
                        bs=d._borderSize
                        ;
                    d.$paddingLeft+=bs;
                    d.$paddingTop+=bs;
                    d.$paddingBottom+=bs;
                    d.$paddingRight+=bs;
                    args = args || {};
                    _.merge(args,{
                        _borderSize:bs,
                        _extend:bs
                    },'without');

                    o.$border = target.addBorder(args, o.domId);

                    if(d.$fix){
                        w=o.width=w+bs;
                        h=o.height=h+bs;
                    }
                    linb.UI.$tryResize(o,w,h);

                    o.clearCache();

                    if(target.$getShadow){
                        var o= target.$getShadow();
                        if(o)o.setOffset(o.getOffset()+bs/2+1);
                    }
                });
            },
            _unBorder:function(){
                return this.each(function(o){
                    var target = o.getSubNode('BORDER');
                    if(!target.$getBorder())return;

                    var v = o.boxing(),
                        d = o.properties,
                        n = v.reBoxing(),
                        w = n.width(),
                        h = n.height(),
                        bs=d._borderSize
                        ;
                    d.$paddingLeft-=bs;
                    d.$paddingTop-=bs;
                    d.$paddingBottom-=bs;
                    d.$paddingRight-=bs;
                    target.removeBorder();
                    linb.UI.$tryResize(o,w,h);

                    delete o.$border;
                    if(target.$getShadow){
                        var o= target.$getShadow();
                        if(o)o.setOffset(o.getOffset()-bs/2-1);
                    }

                });
            }
        },function(o,i){
            linb.UI.Widget.plugIn(i,o);
        });
        linb.UI.Widget.setDataModel({
            border:{
                ini:false,
                action: function(v){
                    var b=this.boxing();
                    if(v)
                        b._border(v);
                    else
                        b._unBorder();
                }
            },
            _borderSize:this.SIZE
        });
    },
    Static:{
        SIZE:4,
        Templates:{
            tagName:'div',
            TAG:{},
            T:{style:'width:100%;left:0;top:-{_extend}px;height:{_borderSize}px;'},
            RT:{style:'top:-{_extend}px;right:-{_extend}px;width:{_borderSize}px;height:{_borderSize}px;'},
            R:{style:'height:100%;top:0;right:-{_extend}px;width:{_borderSize}px;' },
            RB:{style:'right:-{_extend}px;bottom:-{_extend}px;width:{_borderSize}px;height:{_borderSize}px;'},
            B:{style:'width:100%;left:0;bottom:-{_extend}px;height:{_borderSize}px;'},
            LB:{style:'left:-{_extend}px;bottom:-{_extend}px;width:{_borderSize}px;height:{_borderSize}px;'},
            L:{style:'height:100%;top:0;left:-{_extend}px;width:{_borderSize}px;' },
            LT:{style:'top:-{_extend}px;left:-{_extend}px;width:{_borderSize}px;height:{_borderSize}px;'}
        },
        Appearances:{
            KEY:{
                position:'static',
                display:'inline',

                //don't use width/height to trigger hasLayout in IE6
                width:0,
                height:0,

                '_font-size':0,
                '_line-height':0,
                visibility: 'hidden',
                /*for get top Index, when it's static*/
                'z-index':'50'
            },
            TAG:{
                '_font-size':0,
                '_line-height':0
            },
            'T, RT, R, RB, B, LB, L, LT':{
                $order:1,
                position:'absolute',
                display:'block',
                border:0,
                'z-index':30,
                visibility: 'visible',
                '_font-size':0,
                '_line-height':0
            },
            'RT, RB, LB, LT':{
                'z-index':40
            },
            T:{
                background: linb.UI.$bg('v.gif', ' repeat-x left top')
            },
            B:{
                background: linb.UI.$bg('v.gif', ' repeat-x left bottom')
            },
            'KEY-mouseover T, KEY-mouseover B':{
                $order:1,
                'background-image':linb.UI.$bg('v_mouseover.gif')
            },
            'KEY-checked T, KEY-checked B, KEY-mousedown T, KEY-mousedown B':{
                $order:2,
                'background-image':linb.UI.$bg('v_mousedown.gif')
            },
            L:{
                background: linb.UI.$bg('h.gif', ' repeat-y left top')
            },
            R:{
               background: linb.UI.$bg('h.gif', ' repeat-y right top')
            },
            'KEY-mouseover L, KEY-mouseover R':{
                $order:1,
                'background-image': linb.UI.$bg('h_mouseover.gif')
            },
            'KEY-checked L, KEY-checked R, KEY-mousedown L, KEY-mousedown R':{
                $order:2,
                'background-image': linb.UI.$bg('h_mousedown.gif')
            },
            LT:{
                background: linb.UI.$bg('corner.gif', ' no-repeat left top')
            },
            RT:{
               background: linb.UI.$bg('corner.gif', ' no-repeat right top')
            },
            RB:{
                background: linb.UI.$bg('corner.gif', ' no-repeat right bottom')
            },
            LB:{
                background: linb.UI.$bg('corner.gif', ' no-repeat left bottom')
            },
            'KEY-mouseover LT, KEY-mouseover RT, KEY-mouseover RB, KEY-mouseover LB':{
                $order:1,
                'background-image': linb.UI.$bg('corner_mouseover.gif')
            },
            'KEY-checked LT, KEY-checked RT, KEY-checked RB, KEY-checked LB, KEY-mousedown LT, KEY-mousedown RT, KEY-mousedown RB, KEY-mousedown LB':{
                $order:2,
                'background-image' : linb.UI.$bg('corner_mousedown.gif')
            }
        },
        Behaviors:{
            HoverEffected:{TAG:'KEY'},
            ClickEffected:{TAG:'KEY'}
        },
        DataModel:{
            _borderSize:4,
            _extend:4,
            borderActive:false
        }
    }
});//shadow class, add a plugin to linb.Dom
Class("linb.UI.Shadow","linb.UI",{
    Instance:{
        _attachTo:function(obj){
            //to linb.Dom
            obj=obj.reBoxing();
            var self=this;
            //set target first
            self.get(0)._target=obj.get(0);
            // add dom for dom node
            obj.append(self);
            return obj;
        }
    },
    Initialize:function(){
        //for linb.Dom
        _.each({
            addShadow :function(properties){
                return new linb.UI.Shadow(properties)._attachTo(linb([this.get(0)],false));
            },
            $getShadow:function(){
                var s=this.get(0),b;
                _.arr.each(linb.UI.Shadow._cache,function(o){
                    if(o._target==s){b=o;return false;}
                });
                return b && b.boxing();
            },
            removeShadow:function(){
                var s = this.get();
                _.arr.each(linb.UI.Shadow._cache,function(o){
                    if(_.arr.indexOf(s,linb(o._target).get(0))!=-1)
                        o.boxing().destroy();
                });
                return this;
            }
        },function(o,i){
            linb.Dom.plugIn(i,o);
        });
        //for linb.UI.Widget
        _.each({
            _shadow:function(key){
                return this.each(function(o){
                    var target = o.getSubNode('BORDER');
                    if(target.$getShadow())return;

                    var v = o.boxing(),
                        d = o.properties,
                        n = v.reBoxing(),
                        w = n.width(),
                        h = n.height()
                        ;

                    o.$shadow=target.addShadow({shadowSize:d._shadowSize, shadowOffset:d.$paddingBottom||d.$border});

                    d.$paddingBottom +=d._shadowSize;
                    d.$paddingRight +=d._shadowSize;

                    if(d.$fix){
                        w=d.width=w+d._shadowSize;
                        h=d.height=h+d._shadowSize;
                    }
                    linb.UI.$tryResize(o,w,h);

                });
            },
            _unShadow:function(){
                return this.each(function(o){
                    var target = o.getSubNode('BORDER');
                    if(!target.$getShadow())return;
                    target.removeShadow();

                    var v = o.boxing(),
                        d = o.properties,
                        n = v.reBoxing(),
                        w = n.width(),
                        h = n.height()
                        ;
                    d.$paddingBottom -=d._shadowSize;
                    d.$paddingRight -=d._shadowSize;
                    linb.UI.$tryResize(o,w,h);
                    delete o.$shadow
                });
            }
        },function(o,i){
            linb.UI.Widget.plugIn(i,o);
        });
        linb.UI.Widget.setDataModel({
            shadow:{
                ini:false,
                action: function(v){
                    var b=this.boxing();
                    if(v)b._shadow(v);
                    else b._unShadow();
                }
            },
            _shadowSize:this.SIZE
        });
    },
    Static:{
        SIZE:8,
        Templates:{
            tagName:'div',
            R:{
                tagName: 'div',
                style:'top:{shadowOffset}px;width:{shadowSize}px;right:-{pos}px;'
            },
            RB:{
                tagName: 'div',
                style:'height:{shadowSize}px;width:{shadowSize}px;right:-{rbpos}px;bottom:-{rbpos}px;'
            },
            B:{
                tagName: 'div',
                style: 'left:{shadowOffset}px;height:{shadowSize}px;bottom:-{pos}px;'
            }
        },
        Appearances:{
            KEY:{
               width:0,
               height:0,
               _display:'inline',
               '_font-size':0,
               '_line-height':0
            },
            'B, RB, R':{
                position:'absolute',
                display:'block',
                '*font-size':0,
                '*line-height':0
            },
            B:{
                left:0,
                width:'100%',
                background: linb.browser.ie6 ? '' : linb.UI.$bg('B.png', 'repeat-x left bottom'),
                _filter: linb.UI.$ieBg('B.png')
            },
            RB:{
                background: linb.browser.ie6?'':linb.UI.$bg('RB.png', 'left top'),
                _filter: linb.UI.$ieBg('RB.png')
            },
            R:{
                top:0,
                height:'100%',
                background: linb.browser.ie6?'': linb.UI.$bg('R.png', 'repeat-y right top'),
                _filter: linb.UI.$ieBg('R.png')
            }
        },
        DataModel:{
            shadowSize:{
                ini:8,
                action: function(value){
                    var self=this,
                    shadowOffset =self.properties.shadowOffset;
                    self.getSubNode('R').cssRegion({width:value,top:shadowOffset,right:-value-shadowOffset});
                    self.getSubNode('RB').cssRegion({width:value,height:value,right:-value-shadowOffset+1,bottom:-value-shadowOffset+1});
                self.getSubNode('B').cssRegion({height:value,left:shadowOffset,bottom:-value-shadowOffset});
                }
            },
            shadowOffset:{
                ini:0,
                action: function(value){
                    this.boxing().setShadowSize(this.properties.shadowSize, true);
                }
            }
        },
        _prepareData:function(profile){
            var t = arguments.callee.upper.call(this, profile);
            t.pos = (parseInt(t.shadowSize)||0) + (parseInt(t.shadowOffset)||0);
            t.rbpos = t.pos-1;
            return t;
        },
        LayoutTrigger:function(){
            // refresh height for IE6
            if(linb.browser.ie) this.root.ieRemedy()
        } 
    }
});//resizer class, add a plug in to linb.Dom
Class("linb.UI.Resizer","linb.UI",{
    Instance:{
        _attachTo:function(target, parent){
            var self=this, v=self.get(0);

            //set target first
            v._target= linb(target);
            v._parent= parent || linb('body');

            //add to dom
            v._parent.append(self);

            v.$resizeId = linb(target).id();

            return self;
        },
        show:function(){
            var self=this;
            self.each(function(o){
                o.root.css('display',o.$display||'block');
            });
            if(linb.browser.ie)
                self.reBoxing().ieRemedy();
            return self;
        },
        hide:function(){
            var self=this;
            self.each(function(o){
                o.$display = o.root.css('display');
            });
            self.reBoxing().css('display','none');
            return self;
        }
    },
    Initialize:function(){
        this.addTemplateKeys(['HANDLER','HIDDEN','MOVE','L','R','T','B','LT','RB','LB','RB']);
        _.each({
            // add resizer to linb.Dom plugin
            addResizer:function(properties, onUpdate){
                var target=linb([this.get(0)]);
                properties=properties||{};
                _.merge(properties,{
                    _attached:true
                });

                var r = new linb.UI.Resizer(properties)._attachTo(target, target);

                //set event
                if(onUpdate) r.onUpdate(onUpdate);
                return r;
            },
            removeResizer:function(){
                var s = this.id();
                _.arr.each(linb.UI.Resizer._cache,function(o){
                    if(o.$resizeId==s)
                        o.boxing().destroy();
                });
                return this;
            },
            $getResizer:function(){
                var s = this.id(), b;
                _.arr.each(linb.UI.Resizer._cache,function(o){
                    if(o.$resizeId==s){b=o;return false;}
                });
                return b && b.boxing();
            }
        },function(o,i){
            linb.Dom.plugIn(i,o);
        });

        //for linb.UI.Widget
        _.each({
            _resize:function(key, args){
                return this.each(function(o){
                    var target = o.getSubNode('BORDER'),
                        d = o.properties;
                    if(target.$getResizer())return;
                    args = args || {};
                    var update = function(pro, target, size, cssPos){
                        var profile=arguments.callee.profile,
                            node=profile.root,
                            prop=profile.properties,
                            t
                        ;
                        if(size){
                            var w=null,h=null;
                            if(t=size.width){
                                node.widthBy(t);
                                prop.width = w = node.width();
                            }
                            if(t=size.height){
                                node.heightBy(t);
                                prop.height = h = node.height();
                            }
                            linb.UI.$tryResize(profile,w,h);
                        }
                        if(cssPos){
                            if((t=cssPos.left) && !(prop.left=='auto'&&parseInt(prop.right)>=0)){
                                node.leftBy(t);
                                prop.left= node.left();
                            }
                            if((t=cssPos.top) && !(prop.top=='auto'&&parseInt(prop.bottom)>=0)){
                                node.topBy(t);
                                prop.top = node.top();
                            }
                        }
                    };
                    update.profile = o;

                    o.$resizer = target.addResizer(args, update);
                });
            },
            _unResize:function(){
                return this.each(function(o){
                    var target = o.getSubNode('BORDER');
                    if(!target.$getResizer())return;
                    target.removeResizer();
                    delete o.$resizer;
                });
            } 
        },function(o,i){
            linb.UI.Widget.plugIn(i,o);
        });
        linb.UI.Widget.setDataModel({
            resizer:{
                ini:false,
                action: function(v){
                    var b=this.boxing();
                    if(v){
                        var t = this.properties,
                            arg={};
                        _.each('minHeight,minWidth,maxHeight,maxWidth'.split(','),function(i){
                            if(i in t)arg[i]=t[i];
                        });
                        b._resize(v,arg);
                    }else
                        b._unResize();
                }
            }
        });

    },
    Static:{
        Templates:{
            tagName:'div',
            style:'{_style};'
        },
        Appearances:{
            KEY:{
                position:'absolute',
                margin:'0 -1px -1px 0',
                visibility: 'visible',
                '_font-size':0,
                '_line-height':0,

                //for ie
                '*background': 'url('+linb.ini.path+'bg.gif)',
                /*for get top Index, when it's static*/
                'z-index':60,
                cursor:'move'
            },
            MOVE:{
                position:'absolute',
                display:'block',
                'z-index':100,
                visibility: 'visible',
                background: linb.UI.$bg('icon.gif', ' no-repeat -17px top', true),
                '_font-size':0,
                '_line-height':0
            },
            HANDLER:{
                $order:0,
                position:'absolute',
                display:'block',
                border:'solid 1px',
                'background-color':'#fff',
                'z-index':100,
                visibility: 'visible',
                '_font-size':0,
                '_line-height':0
            },
            T:{
               $order:1,
               left:'50%',
               cursor: 'n-resize'
            },
            RT:{
               $order:1,
               cursor: 'ne-resize',
               'z-index': 110
            },
            R:{
               $order:1,
               top:'50%',
               cursor: 'e-resize'
            },
            RB:{
               $order:1,
                cursor: 'se-resize',
                'z-index': 110
            },
            B:{
               $order:1,
                left:'50%',
                cursor: 's-resize'
            },
            LB:{
               $order:1,
                cursor: 'sw-resize',
                'z-index': 110
            },
            L:{
               $order:1,
                top:'50%',
                cursor: 'w-resize'
            },
            LT:{
               $order:1,
                cursor: 'nw-resize',
                'z-index': 110
            },
            //must after HANDLER
            HIDDEN:{
                $order:10,
                'background-color':'transparent',
                'border-width': 0
            }
        },
        Behaviors:{
            onMousedown:function(profile, e, src){
                profile.box._onMousedown(profile, e, src, {move:true});
            },
            onDragbegin:function(profile, e, src){
                profile.box._onDragbegin(profile, e, src);
            },
            onDrag:function(profile, e, src){
                profile.box._onDrag(profile, e, src, {move:true});
            },
            onDragstop:function(profile, e, src){
                profile.box._onDragstop(profile, e, src, {move:true} );
            },
            LT:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {left:true, top:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {left:true, top:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {left:true, top:true});
                }
            },
            RT:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {right:true, top:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {right:true, top:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {right:true, top:true});
                }
            },
            LB:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {left:true, bottom:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {left:true, bottom:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {left:true, bottom:true});
                }
            },
            RB:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {right:true, bottom:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {right:true, bottom:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {right:true, bottom:true});
                }
            },
            L:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {left:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {left:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {left:true});
                }
            },
            T:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {top:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {top:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {top:true});
                }
            },
            R:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {right:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {right:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {right:true});
                }
            },
            B:{
                onMousedown:function(profile, e, src){
                    profile.box._onMousedown(profile, e, src, {bottom:true});
                },
                onDragbegin:function(profile, e, src){
                    profile.box._onDragbegin(profile, e, src);
                },
                onDrag:function(profile, e, src){
                    profile.box._onDrag(profile, e, src, {bottom:true});
                },
                onDragstop:function(profile, e, src){
                    profile.box._onDragstop(profile, e, src, {bottom:true});
                }
            }
        },
        DataModel:{
            // attached to a dom node for resizer function.
            _attached:false,

//<< can be used in addResizer({*})
            // handler visible?
            forceVisible:false,
            // movable
            forceMovable:false,

            // only show right/bottom handlers
            singleDir:false,
            // can change width
            vertical :true,
            // can chang height
            horizontal :true,

            minHeight: 12,
            minWidth: 12,
            maxHeight: 5000,
            maxWidth: 5000,

            handlerSize:4,
            handlerOffset:0,
//>>

            left: 100,
            top: 100,
            height: 100,
            width: 100,
            position:'absolute',
            display:'block'
        },
        EventHandlers:{
            onUpdate:function(profile, target, size, cssPos){}
        },
        _dynamicTemplate:function(profile){
            var pro = profile.properties,size,pos,temp,
                hash = profile._exhash =
                    "$" +
                    '_attached:' + pro._attached + ';' +
                    'forceVisible:' + pro.forceVisible + ';' +
                    'singleDir:' + pro.singleDir + ';' +
                    'vertical:' + pro.vertical + ';' +
                    'horizontal:' + pro.horizontal + ';' +
                    'forceMovable:' + pro.forceMovable + ';'
            ;

            var map= arguments.callee.map || (arguments.callee.map={
                //move icon size 13*13
                MOVE:{tagName:'div', style:'top:50%;left:50%;margin-left:-6px;margin-top:-6px;width:13px;height:13px;'},
                T:{tagName:'div', style:'top:-{extend}px;margin-left:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                RT:{tagName:'div', style:'top:-{extend}px;right:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                R:{tagName:'div', style:'right:-{extend}px;margin-top:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                RB:{tagName:'div', style:'bottom:-{extend}px;right:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                B:{tagName:'div', style:'bottom:-{extend}px;margin-left:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                LB:{tagName:'div',style:'bottom:-{extend}px;left:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                L:{tagName:'div', style:'left:-{extend}px;margin-top:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                LT:{tagName:'div', style:'left:-{extend}px;top:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                cover:{
                    T:{tagName:'div', style:'width:100%;left:0;top:-{extend}px;height:{handlerSize}px;'},
                    RT:{tagName:'div', style:'top:-{extend}px;right:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                    R:{tagName:'div', style:'height:100%;top:0;right:-{extend}px;width:{handlerSize}px;' },
                    RB:{tagName:'div', style:'right:-{extend}px;bottom:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                    B:{tagName:'div', style:'width:100%;left:0;bottom:-{extend}px;height:{handlerSize}px;'},
                    LB:{tagName:'div', style:'left:-{extend}px;bottom:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'},
                    L:{tagName:'div', style:'height:100%;top:0;left:-{extend}px;width:{handlerSize}px;' },
                    LT:{tagName:'div', style:'top:-{extend}px;left:-{extend}px;width:{handlerSize}px;height:{handlerSize}px;'}
                }
            });

            /* dynamic template set here
                template._id is main id, which can input by create arg
                template._did is sub id, which must be built on fly, and cached
            */
            var template = profile.box.getTemplate(hash);
            // set template dynamic
            if(!template){
                var t,n;
                template = _.clone(profile.box.getTemplate());

                // cover or not?
                t = pro._cover?map.cover:map;
                // can move?
                if(pro._move)template.MOVE = map.MOVE;

                // change height only
                if(pro.vertical){
                    if(!pro.singleDir)
                        template.T = t.T;
                    template.B = t.B;
                }
                // change width only
                if(pro.horizontal){
                    if(!pro.singleDir)
                        template.L = t.L;
                    template.R = t.R;
                    // change height and width
                    if(pro.vertical){
                        if(!pro.singleDir){
                            template.LB = t.LB;
                            template.RT = t.RT;
                            template.LT = t.LT;
                        }
                        template.RB = t.RB;
                    }
                }

                n = profile.getClass('KEY', '-handler') + " ";
                if(t=template.T)t.className = n;
                if(t=template.RT)t.className = n;
                if(t=template.R)t.className = n;
                if(t=template.RB)t.className = n;
                if(t=template.B)t.className = n;
                if(t=template.LB)t.className = n;
                if(t=template.L)t.className = n;
                if(t=template.LT)t.className = n;

                // if hidden
                if(!pro._visible){
                    n = profile.getClass('KEY', '-hidden') + " ";
                    if(t=template.T)t.className += n;
                    if(t=template.RT)t.className += n;
                    if(t=template.R)t.className += n;
                    if(t=template.RB)t.className += n;
                    if(t=template.B)t.className += n;
                    if(t=template.LB)t.className += n;
                    if(t=template.L)t.className += n;
                    if(t=template.LT)t.className += n;

                }
                // set template
                profile.box.setTemplate(template, hash);
            }
            profile.template = template;
        },
        _prepareData:function(profile){
            var t = profile.properties;
            //default is true
            t._visible=true;
            t._cover=false;
            t._move=true;
            // for _attached type
            if(t._attached){
                t._visible=false;
                t._cover=true;
                t._move=false;

                t.position = 'static';
                t.display = 'inline';
                t.left = t.top = t.width = t.height = 0;
            }
            if(t.forceVisible){
                t._visible=true;
                t._cover=false;
            }
            if(t.forceMovable)
                t._move=true;

            t.extend =  (parseInt(t.handlerSize)||0)/2 + (parseInt(t.handlerOffset)||0);

            return arguments.callee.upper.call(this, profile);
        },
        RenderTrigger:function(){
            var self=this;
            self.domNode.zIndexIgnore=true;
            // set ini update function
            if(!self.onUpdate)
                self.onUpdate = self.constructor.onUpdate;
        },
        onUpdate:function(profile, target, size, cssPos){
            if(target){
                if(size)target.widthBy(size.width,true).heightBy(size.height,true);
                if(cssPos){
                    var t=target.get(0).style;
                    if(t.left=='auto'&&(parseInt(t.right)>=0)){}else
                    target.leftBy(cssPos.left)
                    if(t.top=='auto'&&(parseInt(t.bottom)>=0)){}else
                    target.topBy(cssPos.top);
                }
            }
        },
        //
        _onMousedown:function(profile, e, src, ddparas){
            var pos=linb.Event.getPos(e);
            linb([src]).startDrag(e,{
                dragDefer:1,
                targetReposition:false, 
                dragType:'blank',
                dragCursor:true,
                targetLeft:pos.left, 
                targetTop:pos.top
            });
        },
        _onDragbegin:function(profile, e){
            if(profile.properties._attached){
                //set target to specific target
                var o=profile._target,
                pos =o.offset(),
                w = o.offsetWidth(),
                h = o.offsetHeight()
                ;

                //custom proxy
                profile.proxy = linb.Dom.getEmptyDiv();
                profile.proxy
                .html(' ',false)
                .css({border:'1px dashed',visibility:'visible'})
                .offset(pos)
                .offsetWidth(w)
                .offsetHeight(h)
                .css('zIndex',linb.Dom.TOP_ZINDEX+20);
            }else{
                //set target to resizer
                var o  = linb([profile.domNode]);
                //set proxy to itself
                profile.proxy = o;
            }
            //get pos for target and proxy
            profile.o_pos = profile.proxy.cssPos();
            //get current w h from target
            profile.o_w2 =profile.o_w = o.width();
            profile.o_h2 =profile.o_h = o.height();

            profile.$onDrag = true;
        },
        _onDrag:function(profile, e,src, ddparas){
            var o=ddparas;
            //get dragdop off set
            profile.oos = profile.oos ||{};
            var os = linb.DragDrop.getProfile().offset;
            if(os.x == profile.oos.width && os.y == profile.oos.height)return;
            profile.oos=os;

            var x,y,w,h,t=profile.properties;

            if(o.left){
                // width of proxy
                w = profile.o_w - os.x;
                // left of proxy
                x = profile.o_pos.left + os.x;
                if(w<t.minWidth){
                    w=t.minWidth;
                    x = profile.o_w+profile.o_pos.left - w;
                }else if(w>t.maxWidth){
                    w=t.maxWidth;
                    x= profile.o_w+profile.o_pos.left - w;
                }
                profile.proxy.width(w).left(x);
            }else if(o.right){
                w = profile.o_w + os.x;
                if(w<t.minWidth)w=t.minWidth;
                else if(w>t.maxWidth)w=t.maxWidth;
                profile.proxy.width(w);
            }
            if(o.left || o.right){
                //resize inner region block
                var byw = w-profile.o_w2;
                if(profile.regions && byw!==0){
                    profile.regions.widthBy(byw);
                    profile.o_w2=w;
                }
            }

            if(o.top){
                h = profile.o_h - os.y;
                y = profile.o_pos.top + os.y;
                if(h<t.minHeight){
                    h=t.minHeight;
                    y=profile.o_h+profile.o_pos.top - h;
                }else if(h>t.maxHeight){
                    h=t.maxHeight;
                    y=profile.o_h+profile.o_pos.top - h;
                }
                profile.proxy.height(h).top(y);
            }else if(o.bottom){
                h= profile.o_h + os.y;
                if(h<t.minHeight)h=t.minHeight;
                else if(h>t.maxHeight)h=t.maxHeight;
                profile.proxy.height(h);
            }
            if(o.top || o.bottom){
                //resize inner region block
                var byh = h-profile.o_h2;
                if(profile.regions && byh!==0){
                    profile.regions.heightBy(byh);
                    profile.o_h2=h;
                }
            }

            if(o.move){
                x = profile.o_pos.left + os.x;
                y = profile.o_pos.top + os.y;
                profile.proxy.top(y).left(x);
            }
        },
        _onDragstop:function(profile, e, src, args){
            var cssPos,size,pos,o=profile.proxy;

            if(!args.move)
                size = { width :o.width()-profile.o_w, height :o.height()-profile.o_h};

            if(args.left || args.top || args.move){
                cssPos = o.cssPos();
                pos = {left :cssPos.left-profile.o_pos.left,  top :cssPos.top-profile.o_pos.top};
            }
            profile.boxing().onUpdate(profile, profile._target, size, pos);

            if(profile.properties._attached){
                if(linb.browser.ie6)profile._target.ieRemedy();
                profile.proxy.html('',false).css({visibility:'hidden',zIndex:'0',width:'0',height:'0'});
            }
            //profile.boxing().active();
            profile.$onDrag = false;
        }
    }
});Class("linb.UI.Block", "linb.UI.Widget",{
    Initialize:function(){
        var self=this,
            t = self.getTemplate();
        //modify
        _.merge(t.FRAME.BORDER,{
            PANEL:{
                tagName:'div',
                className:'ui-content',
                text:'{html}'+linb.UI.$childTag
            }
        },'all');
        //set back
        self.setTemplate(t);

        //get default Appearance
        t = self.getAppearance();
        //modify
        _.merge(t,{
            PANEL:{
                position:'absolute',
                left:0,
                top:0,
                overflow:'auto'
            }
        });
        //set back
        self.setAppearance(t);
    },
    Static:{
        Behaviors:{
            DropableKeys:['PANEL']
        },
        DataModel:{
            //delete those properties
            disabled:null,
            tips:null,
            html:{
                action:function(v){
                    this.getSubNode('PANEL').html(v);
                }
            },

            width:100,
            height:100
        },
        _onresize:function(profile,width,height){
            var size = arguments.callee.upper.apply(this,arguments);
            profile.getSubNode('PANEL').cssSize(size,true);
        }
    }
});

Class("linb.UI.Label", "linb.UI.Widget",{
    Instance:{
        _shadowText:function(key){
            return this.each(function(o){
                o.getSubNode('SHADOW').css('display','block');
            });
        },
        _unShadowText:function(key){
            return this.each(function(o){
                o.getSubNode('SHADOW').css('display','none');
            });
        }
    },
    Initialize:function(){
        //modify default template from parent
        var t = this.getTemplate();
        _.merge(t.FRAME.BORDER,{
            SHADOW:{
                $order:1,
                style:'display:none;',
                SICON:{
                    style:'background:url({image}) transparent no-repeat {imagePos};{iconDisplay}',
                    className:'ui-icon',
                    $order:0
                },
                SCAPTION:{
                    text : '{caption}',
                    style:'color:#cdcdcd;',
                    $order:1
                }
            },
            BOX:{
                $order:2,
                ICON:{
                    style:'background:url({image}) transparent no-repeat {imagePos};{iconDisplay}',
                    className:'ui-icon',
                    $order:0
                },
                CAPTION:{
                    text : '{caption}',
                    $order:1
                }
            }
        },'all');
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            KEY:{
                'font-size':'12px',
                'line-height':'12px'
            },
            BOX:{
                position:'absolute'
            },
            SHADOW:{
                position:'absolute',
                top:'4px'
            }
        },
        DataModel:{
            tabindex:null,
            // setCaption and getCaption
            caption:{
                ini:undefined,
                // ui update function when setCaption
                action: function(value){
                    var self=this,p=self.properties,b=self.boxing(),k=self.keys;
                    self.getSubNodes(['CAPTION','SCAPTION']).html(value,false);
                    if(p.hAlign!='left')b.setHAlign(p.hAlign,true);
                    if(p.vAlign!='top')b.setVAlign(p.vAlign,true);
                }
            },
            image:{
                action: function(value){
                    var self=this,k=self.keys;
                    self.getSubNodes(['ICON','SICON'])
                        .css('display',value?'':'none')
                        .css('backgroundImage','url('+(value||'')+')');
                }
            },
            imagePos:{
                action: function(value){
                    var self=this,k=self.keys;
                    self.getSubNodes(['ICON','SICON'])
                        .css('backgroundPosition', value);
                }
            },
            shadowText:{
                ini:false,
                action: function(v){
                    var b=this.boxing();
                    //for string input
                    v = String(v).toLowerCase()!='false';
                    if(v)
                        b._shadowText(v);
                    else
                        b._unShadowText();
                }
            },
            hAlign:{
                ini:'right',
                listbox:['left','center','right'],
                action: function(v){
                    var self=this,c=self.getSubNode('BOX'),
                        d=self.getSubNode('SHADOW'),
                        t=self.properties;
                    switch(v){
                        case 'left':
                            c.css({left:0,right:'auto','marginLeft':'auto'});
                            d.css({left:t._textSshadowSize+'px',right:'auto','marginLeft':'auto'});
                            break;
                        case 'right':
                            c.css({left:'auto',right:t._textSshadowSize+'px','marginLeft':'auto'});
                            d.css({left:'auto',right:0,'marginLeft':'auto'});
                            break;
                        case 'center':
                            c.css({left:'50%',right:'auto','marginLeft':-1*c.get(0).offsetWidth/2+'px'});
                            d.css({left:'50%',right:'auto','marginLeft':-1*c.get(0).offsetWidth/2 + t._textSshadowSize+'px'});
                            break;
                    }
                }
            },
            vAlign:{
                ini:'top',
                listbox:['top','middle','bottom'],
                action: function(v){
                    var self=this,c=self.getSubNode('BOX'),
                        d=self.getSubNode('SHADOW'),
                        t=self.properties;
                    switch(v){
                        case 'top':
                            c.css({top:0,bottom:'auto','marginTop':'auto'});
                            d.css({top:t._textSshadowSize+'px',bottom:'auto','marginTop':'auto'});
                            break;
                        case 'bottom':
                            c.css({top:'auto',bottom:t._textSshadowSize+'px','marginTop':'auto'});
                            d.css({top:'auto',bottom:0,'marginTop':'auto'});
                            break;
                        case 'middle':
                            c.css({top:'50%',bottom:'auto','marginTop':-1*c.get(0).offsetHeight/2+'px'});
                            d.css({top:'50%',bottom:'auto','marginTop':-1*c.get(0).offsetHeight/2+ t._textSshadowSize+'px'});
                            break;
                    }
                }
            },
            'fontSize':{
                action: function(value){
                    var self=this;
                    self.getSubNodes(['CAPTION','SCAPTION'])
                        .css('fontSize', value);
                }
            },
            'fontWeight':{
                action: function(value){
                    var self=this;
                    self.getSubNodes(['CAPTION','SCAPTION'])
                        .css('fontWeight', value);
                }
            },
            width:120,
            height:20,

            _textSshadowSize:4
        },
        RenderTrigger:function(){
            var p = this.properties, o=this.boxing();
            if(p.fontSize)o.setFontSize(p.fontSize,true);
            if(p.fontWeight)o.setFontWeight(p.fontWeight,true);
            if(p.shadowText)o.setShadowText(true,true);
        },
        LayoutTrigger:function(){
            var p = this.properties, o=this.boxing(),s=p.shadowText;
            if(p.hAlign!='left' || s)o.setHAlign(p.hAlign,true);
            if(p.vAlign!='top'|| s)o.setVAlign(p.vAlign,true);
        }
    }
});Class("linb.UI.ProgressBar", ["linb.UI.Widget","linb.absValue"] ,{
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                profile.getSubNode('FILL').width(value+"%");
                profile.getSubNode('CAP').text(profile.properties.captionTpl.replace(/\{value\}/g,value));
            });
        }
    },
    Initialize:function(){
        var self=this,
            t = self.getTemplate();
        //modify
        _.merge(t.FRAME.BORDER,{
            FILL:{
                tagName:'div',
                style:'width:{value}%;',
                text:'{html}'+linb.UI.$childTag
            },
            INN:{
                $order:2,
                tagName:'div',
                CAP:{
                    tagName:'div'
                }
            }
        },'all');
        //set back
        self.setTemplate(t);

        //get default Appearance
        t = self.getAppearance();
        //modify
        _.merge(t,{
            BORDER:{
                border:'1px solid #91A7B4',
                'font-size':0,
                'line-height':0,
                //in ie6, if no overflow:hidden, children with height:100% will not work.
                overflow:'hidden'
            },
            INN:{
                display:'table',
                position:'absolute',
                left:0,
                top:0,
                width:'100%',
                height:'100%'
            },
            CAP:{
                display:'table-cell',
                'text-align':'center',
                'vertical-align':'middle'
            },
            FILL:{
                position:'absolute',

                width:'1px',
                left:0,
                top:0,
                height:'100%',
                background: linb.UI.$bg('accordion.gif', ' repeat-x 0 0', true),
                width:0
            }
        });
        //set back
        self.setAppearance(t);
    },
    Static:{
        DataModel:{
            //delete those properties
            value:0,
            width:300,
            height:22,
            captionTpl:{
                ini:'{value}%',
                action:function(){
                    this.boxing()._setCtrlValue(this.properties.$UIvalue);
                }
            },
            fillBG:{
                ini:'',
                action:function(v){
                    this.getSubNode('FILL').css('background',v);
                }
            },
            $border:1
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile);
            data.fillBG = data.fillBG?'background:'+data.fillBG:'';
            return data;
        },
        _ensureValue:function(profile,value){
            return parseInt(value)||0;
        }
    }
});

Class("linb.UI.Button", ["linb.UI.Widget","linb.absValue"],{
    Instance:{
        _border:function(key, args){
            args = args || {};
            args.borderActive=true;
            return arguments.callee.upper.call(this, key, args);
        },
        activate:function(){
            var profile = this.get(0);
            profile.getSubNode('FOCUS').focus();
            return this;
        },
        _setCtrlValue:function(value){
            if(_.isNull(value) || !_.exists(value))value=false;
            return this.each(function(profile){
                var pp=profile.properties;
                if(pp.type!='status')return;
                profile.getSubNode('BORDER').tagClass('-checked', value);

                if(pp.border){
                    var b = profile.getSubNode('BORDER').$getBorder();
                    if(b)b.get(0).root.tagClass('-checked', value);
                }
            });
        }
    },
    Initialize:function(){
        this.addTemplateKeys(['DROP']);
        //modify default template for shell
        var t = this.getTemplate();
        _.merge(t.FRAME.BORDER,{
            FOCUS:{
                tagName:'a',
                href :"{href}",
                tabindex: '{tabindex}',
                TB:{
                    cellpadding:"0",
                    cellspacing:"0",
                    width:'100%',
                    height:'100%',
                    border:'0',
                    tagName:'table',
                    TR:{
                        tagName:'tr',
                        TDL:{
                            tagName:'td'
                        },
                        TD:{
                            $order:1,
                            align:'{hAlign}',
                            valign:'{vAlign}',
                            tagName:'td',
                            width:'100%',
                            height:'100%',
                            BOX:{
                                ICON:{
                                    $order:1,
                                    className:'ui-icon',
                                    style:'background:url({image}) transparent no-repeat  {imagePos};{iconDisplay}'
                                },
                                CAPTION:{
                                    $order:2,
                                    text: '{caption}'
                                }
                            }
                        },
                        TDR:{
                            $order:2,
                            tagName:'td',
                            className:'{dropCls}',
                            TDRI:{}
                        }
                    }
                }
            }
        },'all');
        t.className='{customCls}';
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            KEY:{
                'font-size':'12px',
                'line-height':'12px'
            },
            'CUSTOM':{
                background:'transparent'
            },
            'CUSTOM BOX':{
                'white-space':'normal'
            },
            'CUSTOM td':{
                $order:20,
                background:'none'
            },
            BORDER:{
                'font-size':0,
                'line-height':0
            },
            TDL:{
                background: linb.UI.$bg('button.gif', ' no-repeat left top',true),
                'padding-left':'3px'
            },
            'TD':{
                background: linb.UI.$bg('button.gif', ' repeat-x left -25px',true)
            },
            TDR:{
                background: linb.UI.$bg('button.gif', ' no-repeat right -50px',true),
                'padding-left':'3px'
            },
            'DROP':{
                $order:10,
                background: linb.UI.$bg('button.gif', ' no-repeat right -225px',true),
                'padding-left':'16px'
            },
            'BORDER-mouseover DROP':{
                $order:11,
                'background-position':'right -250px'
            },
            'BORDER-mouseover DROP-mousedown':{
                $order:12,
                'background-position':'right -275px'
            },


            'BORDER-mouseover TDL':{
                $order:1,
                'background-position':'left -75px'
            },
            'BORDER-mouseover TD':{
                $order:1,
                'background-position':'left -100px'
            },
            'BORDER-mouseover TDR':{
                $order:1,
                'background-position':'right -125px'
            },
            'BORDER-mousedown TDL, BORDER-checked TDL':{
                $order:2,
                'background-position':'left -150px'
            },
            'BORDER-mousedown TD, BORDER-checked TD':{
                $order:2,
                'background-position':'left -175px'
            },
            'BORDER-mousedown TDR, BORDER-checked TDR':{
                $order:2,
                'background-position':'right -200px'
            },
            /*a*/
            FOCUS:{
                overflow:'hidden',
                display:'block',
                position:'absolute',
                left:0,
                top:0,
                'z-index':'20',
                width:'100%',
                height:'100%',
                '-moz-outline-offset':'-1px !important'
            },
            /*span*/
            BOX:{
                display:'inline',
                'white-space':'nowrap'
            },
            CAPTION:{
                cursor:'pointer',
                'vertical-align':'middle',
                display:'inline',
                'font-size':'12px',
                'line-height':'14px'
            }
        },
        Behaviors:{
            HoverEffected:{KEY:['BORDER']},
            ClickEffected:{KEY:['BORDER']},
            NavKeys:{FOCUS:1},
            onClick:function(profile, e, src){
                var p=profile.properties;
                if(p.disabled)return false;

                //before event
                profile.getSubNode('FOCUS').focus();

                var b=profile.boxing();

                if(p.type=='status'){
                    b.setUIValue(!p.$UIvalue);
                    if(profile.onChecked)
                        b.onChecked(profile, e, p.$UIvalue);
                }

                //onClick event
                if(profile.onClick)
                    b.onClick(profile, e, src, p.$UIvalue);

            },
            TDR:{
                onMousedown:function(profile){
                    if(profile.properties.type!='drop')return;
                    linb([this]).addClass(profile.getClass('DROP','-mousedown'));
                    return false;
                },
                onMouseup:function(profile){
                    if(profile.properties.type!='drop')return;
                    linb([this]).removeClass(profile.getClass('DROP','-mousedown'));
                    return false;
                },
                onClick:function(profile, e, src){
                    if(profile.properties.type!='drop')return;
                    profile.boxing().onClickDrop(profile, e, src);
                    return false;
                }
            }
        },
        DataModel:{
            caption:{
                ini:undefined,
                // ui update function when setCaption
                action: function(value){
                    this.getSubNode('CAPTION').get(0).innerHTML = value;
                }
            },
            image:{
                action: function(value){
                    this.getSubNode('ICON')
                        .css('display',value?'':'none')
                        .css('backgroundImage','url('+(value||'')+')');
                }
            },
            imagePos:{
                action: function(value){
                    this.getSubNode('ICON')
                        .css('backgroundPosition', value);
                }
            },
            hAlign:{
                ini:'center',
                listbox:['left','center','right'],
                action: function(v){
                    var self=this, c=self.getSubNode('TD'), t=self.properties;
                    c.attr('align',v);
                }
            },
            vAlign:{
                ini:'middle',
                listbox:['top','middle','bottom'],
                action: function(v){
                    var self=this, c=self.getSubNode('TD'), t=self.properties;
                    c.attr('valign',v);
                }
            },
            tabindex:{
                action:function(value){
                    this.getSubNode('FOCUS').attr('tabIndex',value);
                }
            },
            href:linb.$href,
            value:false,
            type:{
                ini:'normal',
                listbox:['normal','status','drop','custom'],
                action:function(value){
                    var self=this,
                        root=self.getRoot(),
                        tdr=self.getSubNode('TDR'),
                        drop=self.getClass('DROP'),custom=self.getClass('CUSTOM');
                    if(value=='drop')
                        tdr.addClass(drop);
                    else
                        tdr.removeClass(drop);
                    if(value=='custom')
                        root.addClass(custom);
                    else
                        root.removeClass(custom);
                }
            },
            width:120,
            height:22,
            $border:0
        },
        _ensureValue:function(profile,value){
            return !!value;
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile);
            data.customCls = data.type=='custom'?profile.getClass('CUSTOM'):'';
            data.dropCls = data.type=='drop'?profile.getClass('DROP'):'';
            return data;
        },
        RenderTrigger:function(){
            var p = this.properties, o=this.boxing();
            //set value later
            if(p.type=='status' && p.value)
                o.setValue(true, true);
        },
        EventHandlers:{
            onClick:function(profile, e, src, value){},
            onClickDrop:function(profile, e, src){},
            onChecked:function(profile, e, value){}
        }
    }
});Class("linb.UI.CheckBox", "linb.UI.Button",{
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
               profile.getSubNode('MARK').tagClass('-checked', !!value);
            });
        },
        //update UI face
        _setDirtyMark:function(){
            return this.each(function(profile){
                if(!profile.domNode)return;
                var properties = profile.properties,
                    o=profile.getSubNode('CAPTION'),
                    flag=properties.value !== properties.$UIvalue,
                    d = linb.UI.$css_tag_dirty;

                if(o.beforeDirtyMark && false===o.boxing().beforeDirtyMark(profile,flag))
                    return;

                if(flag)
                    o.addClass(d);
                else
                    o.removeClass(d);
            });
        }
    },
    Initialize:function(){
        //modify default template for shell
        var t = this.getTemplate();
        _.merge(t.FRAME.BORDER.FOCUS.TB.TR.TD.BOX,{
            MARK:{
                $order:0
            }
        },'all');
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            KEY:{
                'font-family': '"Verdana", "Helvetica", "sans-serif"',
                'font-size':'12px',
                border:0,
                cursor:'pointer'
            },
            BORDER:{},
            /*a*/
            FOCUS:{
                overflow:'hidden',
                display:'block',
                position:'absolute',
                left:0,
                top:0,
                'z-index':'200',
                width:'100%',
                height:'100%',
                '-moz-outline-offset':'-1px !important'
            },
            /*span*/
            BOX:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                'font-size':'12px',
                'line-height':'14px',
                overflow:'hidden',
                'vertical-align':'middle',
                'white-space':'nowrap'
            },
            TD:{
                background:'transparent'
            },
            TDR:{
                background:'transparent'
            },
            TDL:{
                background:'transparent'
            },
            MARK:{
               cursor:'pointer',
                'vertical-align':'middle',
               width:'16px',
               height:'16px',
               background: linb.UI.$bg('cmds.gif', ' no-repeat -112px top', true)
            },
            'MARK-mouseover':{
                $order:1,
                'background-position': '-112px -17px'
            },
            'MARK-mousedown':{
                $order:2,
                'background-position': '-112px -34px'
            },
            'MARK-checked':{
                $order:3,
                'background-position': '-96px top'
            },
            'MARK-checked-mouseover':{
                $order:4,
                'background-position': '-96px -17px'
            },
            'MARK-checked-mousedown':{
                $order:5,
                'background-position': '-96px -34px'
            },
            CAPTION:{
                display:'inline',
                'white-space':'normal',
                'vertical-align':'middle',
                cursor:'pointer',
                zoom:linb.browser.ie?0:null
            }
        },
        Behaviors:{
            HoverEffected:{KEY:'MARK'},
            ClickEffected:{KEY:'MARK'},
            onClick:function(profile, e, src){
                var p=profile.properties,b=profile.boxing();
                if(p.disabled)return false;
                //onClick event
                b.setUIValue(!p.$UIvalue);

                if(profile.onChecked)b.onChecked(profile, p.$UIvalue);
                profile.getSubNode('FOCUS').focus();
            },
            FOCUS:{
                onKeydown:function(profile, e, src){
                    var key = linb.Event.getKey(e)[0];
                    if(key ==' ' || key=='enter'){
                        profile.root.onClick(true);
                        return false;
                    }
                }
            }
        },
        DataModel:{
            type:null,
            value:false,
            hAlign:'left'
        },
        EventHandlers:{
            onClick:null
        },
        _ensureValue:function(profile, value){
            return !!value;
        }
    }
});
Class("linb.UI.Input", ["linb.UI.Widget","linb.absValue"] ,{
    Instance:{
        _setTB:function(type){
            var profile=this.get(0), p=profile.properties, o, t;
            if(!profile.host|| !p.tipsBinder)return;

            t = profile.tips = profile.tips||p.tips||'';
            o = profile.host[p.tipsBinder];
            if(o && o.KEY=='linb.UI.Div'){
                //use innerHTML, not setHtml
                o.get(0).domNode.innerHTML =  t.charAt(0)=='$'?linb.wrapRes(t):t;
                o.reBoxing().css('color', type==1?'gray':type==2?'red':'#000');
            }
        },
        activate:function(){
            var profile = this.get(0);
            if(profile.domNode){
                var node=profile.getSubNode('INPUT').get(0);
                node.focus();
                if(!node.readOnly && node.select)node.select();
            }
            return this;
        },
        _setCtrlValue:function(value){
            if(_.isNull(value) || !_.exists(value))value='';
            return this.each(function(profile){
                profile.getSubNode('INPUT').attr('value',value+"");
            });
        },
        _getCtrlValue:function(){
            var profile=this.get(0);
            return profile.getSubNode('INPUT').attr('value');
        },
        _setDirtyMark:function(){
            return this.each(function(profile){
                var properties = profile.properties,
                    o=profile.getSubNode('INPUT'),
                    cls=profile.box,
                    box=profile.boxing(),
                    d=linb.UI.$css_tag_dirty,
                    v=linb.UI.$css_tag_invalid,
                    flag=properties.value !== properties.$UIvalue;
                //dirty mark
                if(profile.beforeDirtyMark && false===box.beforeDirtyMark(profile,flag)){}
                else{
                    if(flag)
                        o.addClass(d);
                    else
                        o.removeClass(d);
                }
                //format statux
                if(profile.beforeFormatMark && false===box.beforeFormatMark(profile, profile.inValid==2)){}
                else{
                    var err = profile.getSubNode('ERROR');
                    if(profile.inValid==2){
                        o.addClass(v);
                        err.css('display','block');
                    }else{
                        o.removeClass(v);
                        err.css('display','none');
                    }
                }
                if(profile.inValid==2){
                    //display tips
                    profile.tips = properties.tipsErr || properties.tips;
                    if(properties.mask)
                        _.asyRun(function(){
                            box.setUIValue(o.get(0).value=profile.$Mask)
                        });
                }else{
                    if(profile.inValid==1)
                        profile.tips = properties.tips;
                    else{
                        profile.tips = properties.tipsOK || properties.tips;
                    }
                }
                box._setTB(profile.inValid);
            });
        }
    },
    Initialize:function(){
        //modify default template fro shell
        var t = this.getTemplate();
        _.merge(t.FRAME.BORDER,{
            BOX:{
                tagName : 'div',
                INPUT:{
                    tagName : 'input',
                    type : '{type}',
                    tabindex:'{tabindex}',
                    cursor:'{cursor}',
                    style:'{_css}'
                }
            }
        },'all');
        t.FRAME.ERROR = {};
        this.setTemplate(t)
    },
    Static:{
        _maskMap:{
            '~':'[+-]',
    		'1':'[0-9]',
    		'a':'[A-Za-z]',
    		'*':'[A-Za-z0-9]'
        },
        _maskSpace:'_',
        Appearances:{
            KEY:{
                'font-family': '"Verdana", "Helvetica", "sans-serif"',
                position:'relative'
            },
            BORDER:{
                'line-height':'0px',
                'font-size':'0px',
                'background-color':'#fff',
                border: '1px solid #7F9DB9'
            },
            'BORDER-focus, BORDER-mouseover':{
                $order:1,
                border: '1px solid #FFD700'
            },
            BOX:{
                left:0,
                top:0,

                //for firefox bug: cursor not show
                position:'absolute',
                overflow:linb.browser.gek?'auto':'',
                'z-index':'10'
            },
            INPUT:{
               border:0,
               padding:0,
               margin:0,
               'font-size':'12px',
               position:'relative',
               overflow:'auto',
               'background-color':'transparent',
               'overflow-y':(linb.browser.gek||linb.browser.ie)?'auto':'',
               'overflow-x':(linb.browser.gek||linb.browser.ie)?'hidden':''
            },
            ERROR:{
                width:'16px',
                height:'16px',
                position:'absolute',
                right:0,
                top:0,
                display:'none',
                'font-size':0,
                background: linb.UI.$bg('icon.gif', ' no-repeat left top', true),
                'z-index':'50'
            }
        },
        Behaviors:{
            HoverEffected:{KEY:['BORDER']},
            NavKeys:{INPUT:1},
            INPUT:{
                onChange:function(profile, e, src){
                    var o=profile.inValid;
                    profile.boxing().setUIValue(src.value);
                    //input/textarea is special, ctrl value will be set before the $UIvalue
                    profile.properties.$UIvalue=src.value;
                    if(o!==profile.inValid) if(profile.domNode)profile.boxing()._setDirtyMark();
                },
                //if properties.mask exists, onHotKeyxxx wont be tigger any more
                onKeydown:function(profile, e, src){
                    var p=profile.properties,
                        m=p.multiLines,
                        b=profile.box,
                        evt=linb.Event,
                        k=evt.getKey(e);
                    //fire onchange first
                    if(k[0]=='enter'&& (!m||k[3]))
                        linb([src]).onChange();
                    if(p.mask){
                        if(k[0].length>1)profile.$ignore=true;
                        else delete profile.$ignore;
                        switch(k[0]){
                            case 'backspace':
                                b._changeMask(profile,src,'',false);
                                return false;
                            case 'delete':
                                b._changeMask(profile,src,'');
                                return false;
                        }
                    }
                },
                onKeypress:function(profile, e, src){
                    var p=profile.properties,cls=profile.box,map=cls._maskMap;
                    if(p.mask){
                        if(profile.$ignore){
                            delete profile.$ignore;
                            return true;
                        }
                        var evt=linb.Event,
                            k=evt.getKey(e);
                        if(k[1]||k[3])return true;

                        cls._changeMask(profile,src,k[0],true);
                        return false;
                    }
                },
                onKeyup:function(profile, e, src){
                    var p=profile.properties;
                    if(p.dynCheck){
                        profile.box._checkValid(profile, src.value);
                        profile.boxing()._setDirtyMark();
                    }
                },
                onFocus:function(profile, e, src){
                    var p=profile.properties,b=profile.box;
                    if(p.disabled)return false;
                    if(profile.onFocus)profile.boxing().onFocus(profile);
                    profile.getSubNode('BORDER').tagClass('-focus');
                    //if no value, add mask
                    if(p.mask){
                        //ondrop in opera or safari will trigger onfocus event.
                        if(linb.browser.opr ||linb.browser.kde)
                             b._maskF(profile,src);
                        if(!src.value)
                            _.asyRun(function(){
                                profile.boxing().setUIValue(src.value=profile.$Mask);
                                b._setCaret(profile,src)
                            });
                    }
                    //show tips color
                    profile.boxing()._setTB(3);
                },
                onBlur:function(profile, e, src){
                    var p=profile.properties;
                    if(p.disabled)return false;
                    if(profile.onBlur)profile.boxing().onBlur(profile);

                    profile.getSubNode('BORDER').tagClass('-focus',false);
                    //onblur check it
                    if(p.$UIvalue==src.value)
                        profile.box._checkValid(profile, src.value);
                    profile.boxing()._setDirtyMark();
                }
            }
        },
        DataModel:{

            tipsErr:'',
            tipsOK:'',

            dynCheck:false,
            valueFormat:{
                helpinput:[
                    {caption : 'required', id: "[^.*]"},
                    {caption : 'email',id:"^[\\w\\.=-]+@[\\w\\.-]+\\.[\\w\\.-]{2,4}$"},
                    {caption : 'charOnly',id:"^[a-zA-Z]*$"},
                    {caption : 'words',id:"^[\\w ]*$"},
                    {caption : 'integer',id:"^-?\\d\\d*$"},
                    {caption : 'positiveInteger',id:"^\\d\\d*$"},
                    {caption : 'number',id:"^-?(\\d\\d*\\.\\d*$)|(^-?\\d\\d*$)|(^-?\\.\\d\\d*$)"},
                    {caption : 'filepath',id:"([\\/]?[\\w_]+)+\\.\\w{1,9}$"},
                    {caption : 'URL', id:"^(http|https|ftp)\\:\\/\\/[\\w\\-\\_\\.]+[\\w\\-\\_](:[\\w]*)?\\/?([\\w\\-\\._\\?\\,\\'\\/\\\\\\+&amp;%\\$#\\=~])*$"},
                    {caption : 'color',id:"^\\#[0-9A-Fa-f]{6}$"},
                    {caption : "HH:MM", id:"^\(\([0-1][0-9]\)|\([2][0-3])\)\:\([0-5][0-9]\)$"},
                    {caption : "HH:MM:SS", id:"^\(\([0-1][0-9]\)|\([2][0-3])\)\:\([0-5][0-9]\)\\:\([0-5][0-9]\)$"},
                    {caption : "YYYY-MM-DD",id:"^\([0-9]{4}\)\\-\(\([0][0-9]\)|\([1][0-2]\)\)\\-\([0-3][0-9]\)$"},
                    {caption : "DD/MM/YYYY",id:"^\(\([0-2][0-9]\)|\([3][0-1]\)\)\/\(\([0][0-9]\)|\([1][0-2]\)\)\/\([0-9]{4}\)$"}
                ]
            },
            mask:{
                action:function(value){
                    var ns=this,
                        b=ns.box;
                    if(value){
                        ns.$MaskFormat=function(ns, v){
                            var m=ns._maskMap,a=[],r=/[A-Za-z0-9]/;
                            _.arr.each(v.split(''),function(o,i){
                                a.push(m[o]||(r.test(o)?"":"\\")+o)
                            });
                            return '^'+a.join('')+'$';
                        }(b, value);
                        ns.$Mask = function(ns, v){
                            var m=ns._maskMap,a=[],s=ns._maskSpace;
                            _.arr.each(v.split(''),function(o,i){
                                a.push(m[o]?s:o);
                            });
                            return  a.join('');
                        }(b,value);

                        //add event for cut/paste text
                        if(ns.domNode){
                            var ie=linb.browser.ie,
                                src=ns.getSubNode('INPUT').get(0),
                                f=function(o){
                                    b._maskF(ns, src, ie&&o.propertyName);
                                };
                            if(ie){
                                src.attachEvent("onpropertychange",f);
                                src.attachEvent("ondrop",f);
                                ns.$ondestory=function(){
                                    src.detachEvent("onpropertychange",f);
                                    src.detachEvent("ondrop",f);
                                }
                            }else{
                                src.addEventListener("input",f,false);
                                //firefox drop
                                if(linb.browser.gek)
                                    src.addEventListener("dragdrop",f,false);

                                ns.$ondestory=function(){
                                    src.removeEventListener("input",f,false);
                                    src.addEventListener("dragdrop",f,false);
                                }
                            }
                        }
                   }else{
                        delete ns.$MaskFormat;
                        delete ns.$Mask;
                        if(ns.domNode)
                            _.tryF(ns.$ondestory);
                   }
                }
            },
            value:'',
            width:120,
            height:20,
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('INPUT').attr('tabIndex',value);
                }
            },
            disabled:{
                ini:false,
                action: function(v){
                    this.root.css('opacity',v?0.5:1);
                    this.getSubNode('INPUT').attr('disabled',v);
                }
            },
            readonly:{
                ini:false,
                action: function(v){
                    this.getSubNode('INPUT').attr('readonly',v).css('cursor',v?'default':'');
                }
            },
            type:{
                ini:'text',
                listbox:['text','password'],
                action: function(value){
                    this.getSubNode('INPUT').attr('type',value);
                }
            },
            multiLines:{
                ini:false,
                action: function(value){
                    var str = this.getSubNode('INPUT').outerHTML();
                    str = str.replace(/^(<)[a-zA-Z]+(\s)/i, '$1'+(value?'textarea':'input')+'$2');

                    var v = this.boxing().getValue();
                    this.getSubNode('INPUT').outerHTML(str);
                    this.boxing().setUIValue(v);
                }
            },
            tipsBinder:'',

            $border:1
        },
        EventHandlers:{
            onFocus:function(profile){},
            onBlur:function(profile){},
            beforeFormatCheck:function(profile, value){},
            beforeFormatMark:function(profile, formatErr){}
        },
        _prepareData:function(profile){
            var d=arguments.callee.upper.call(this, profile);
            d.cursor = d.readonly?'default':'';
            d.type = d.type || '';
            if(linb.browser.kde)
                d._css='resize:none;';
            return d;
        },
        _dynamicTemplate:function(profile){
            var properties = profile.properties,
                hash = profile._exhash = "$" +'multiLines:'+properties.multiLines,
                template = profile.box.getTemplate(hash);

            properties.$UIvalue = properties.value;

            // set template dynamic
            if(!template){
                template = _.clone(profile.box.getTemplate());
                if(properties.multiLines){
                    template.FRAME.BORDER.BOX.INPUT.tagName='textarea';
                    delete template.FRAME.BORDER.BOX.INPUT.type;
                }

                // set template
                profile.box.setTemplate(template, hash);
            }
            profile.template = template;
        },
        RenderTrigger:function(){
            var ns=this,p=ns.properties;
            _.asyRun(function(){
                ns.boxing()._setTB(1);
            });
            ns.getSubNode('BOX').$firfox2();
        },
        LayoutTrigger:function(){
            var p = this.properties;
            if(p.mask)this.boxing().setMask(p.mask,true);
        },
    //v=value.substr(0,caret);
    //i=v.lastIndexOf(ms);

        _changeMask:function(profile,src,v,dir){
            var ns=this,
                p=profile.properties,
                map=ns._maskMap,
                ms=ns._maskSpace,
                maskTxt=p.mask,
                maskStr = profile.$Mask,
                input = linb([src]),
                caret = input.caret();
            //for backspace
            if(dir===false && caret[0]==caret[1] && caret[0]>0)
                input.caret(caret[0]-1,caret[0]);

            //for delete
            if(dir===undefined && caret[0]==caret[1])
                input.caret(caret[0],caret[0]+1);

            //for caret is from a fix char, nav to the next 'input allow' char
            if(dir===true){
                if(maskStr.charAt(caret[0])!=ms){
                    var from = caret[0] + maskStr.substr(caret[0],maskStr.length).indexOf(ms);
                    input.caret(from,Math.max(caret[1],from))
                }
            }

            var caret = input.caret(),
                value=src.value,
                reg = ns._maskMap[p.mask.charAt(caret[0])],
                i,t;
            if(reg && new RegExp('^'+reg+'$').test(v) || v==''){
                t=value;
                //if select some text
                if(caret[0]!=caret[1])
                    t=t.substr(0,caret[0]) + maskStr.substr(caret[0],caret[1]-caret[0]) + t.substr(caret[1],t.length-caret[1]);
                //if any char input
                if(v)
                    t=t.substr(0,caret[0])+v+t.substr(caret[0]+1,t.length-caret[0]-1);

                //get corret string according to maskTxt
                var a=[];
                _.arr.each(maskTxt.split(''),function(o,i){
                    a.push( (new RegExp('^'+(map[o]?map[o]:'\\'+o)+'$').test(t.charAt(i))) ? t.charAt(i) : maskStr.charAt(i))
                });

                //if input visible char
                if(dir===true){
                    v=maskStr.substr(caret[0]+1,value.length-caret[0]-1);
                    i=v.indexOf(ms);
                    i=caret[0] + (i==-1?0:i) + 1;
                }else
                    i=caret[0];
                //in opera, delete/backspace cant be stopbubbled
                //add a dummy maskSpace
                if(linb.browser.opr){
                    //delete
                    if(dir===undefined)
                        _.arr.insertAny(a,ms,i);
                    //backspace
                    if(dir===false)
                        _.arr.insertAny(a,ms,i++);
                }
                profile.boxing().setUIValue(src.value=a.join(''));
                ns._setCaret(profile,src,i);
            }

        },
        _setCaret:function(profile, src, pos){
            if(profile.properties.mask){
                if(typeof pos !='number')
                    pos=src.value.indexOf(this._maskSpace);
                linb([src]).caret(pos,pos);
            }
        },
        //check valid manually
        _checkValid:function(profile, value){
            var p=profile.properties,
                vf1 = (p.mask&&profile.$MaskFormat) ,
                vf2 = p.valueFormat || profile.$valueFormat;
            if( (profile.beforeFormatCheck && (profile.boxing().beforeFormatCheck(profile, value)===false)) ||
                (vf1 && typeof vf1=='string' && !(new RegExp(vf1)).test(value||'')) ||
                (vf2 && typeof vf2=='string' && !(new RegExp(vf2)).test(value||''))
            ){
                profile.inValid=2;
                return false;
            }{
                profile.inValid=3;
                return true;
            }
        },
        _maskF:function(profile,src, pro){
            var id=src.id;
            _.resetRun(profile.$id+"_mask",function(){
                if(linb.browser.ie && pro!='value')return;
                var src=linb.Dom.byId(id);
                if(src.value.length != profile.$Mask.length)
                    profile.box._changeMask(profile,src,'',true);
            });
        },
        _onresize:function(profile,width,height){
            var size = arguments.callee.upper.apply(this,arguments),
                v=profile.getSubNodes(['INPUT','BOX']),
                b=linb.browser;

            if(null!==width)
                v.width(size.width);
            if(null!==height)
                v.height(size.height/* -(b.ie6?2:b.ie?1:b.kde?1:0)*/);

            return size;
        }
    }
});Class("linb.UI.ComboInput", "linb.UI.Input",{
    /*Instance*/
    Instance:{
        _setCtrlValue:function(value, flag){
            var me=arguments.callee, r1=me._r1||(me._r1=/\</),r2=me._r2||(me._r2=/\<\/?[^>]+\>/g);
            return this.each(function(profile){
                var o=profile.getSubNode('INPUT'), type=profile.properties.type;
                value=flag?value:profile.boxing()._getShowValue(value);
                if(type!=='none'&& !profile.properties.multiLines && typeof value=='string' && r1.test(value))value=value.replace(r2,'');
                o.attr('value',value);
                if(type=='colorpicker'){
                    profile.getSubNode('BORDER').css('backgroundColor',value);
                    o.css('color',linb.UI.ColorPicker.getTextColor(value));
                }
            })
        },
        _compareValue:function(v1,v2){
            var profile=this.get(0),t;
            if(t= profile.$compareValue|| profile.CF.compareValue)
                return t(profile, v1, v2);

            return v1===v2;
        },
        _getShowValue:function(value){
            var profile=this.get(0),
                pro=profile.properties,v,t;

            if(t= profile.$getShowValue|| profile.CF.getShowValue)
                v = t(profile, value);
            else{
                //get from items
                if('listbox'==pro.type || 'combobox' == pro.type){
                    if( (v=_.arr.subIndexOf(pro.items,'id',value))!=-1){
                        v=pro.items[v].caption;
                        v=v.charAt(0)=='$'?linb.getRes(v.slice(1)):v;
                    }else
                        v='';
                }else
                    v = profile.$showValue;
            }
            v=v||value||'';

            if(v!==value)profile.$caption=v;
            else delete profile.$caption;
            return v;
        },
        _getEditValue:function(value){
            var profile=this.get(0),
                pro=profile.properties,t;

                if(t= profile.$getEditValue|| profile.CF.getEditValue)
                    return t(profile, value);
            return value;
        },
        _fromEditValue:function(value){
            var profile=this.get(0),
                pro=profile.properties,t;

                if(t= profile.$fromEditValue|| profile.CF.fromEditValue)
                    return t(profile, value);
            return value;
        },
        _cache:function(){
            var profile=this.get(0),drop=profile.$drop;
            if(drop){
                if(linb.browser.opr)
                    drop.root.css('display','none');
                _.asyRun(function(){
                    profile.getSubNode('POOL').append(drop.root)
                });
            }
            delete profile.$poplink;
        },
        clearPopCache:function(){
            var profile=this.get(0);
            if(profile.domNode)
                profile.getSubNode('POOL').empty();
            delete profile.$drop;
            return this;
        },
        //for upload ,special must get the original node
        getUploadObj:function(){
            var profile=this.get(0);
            if(profile.domNode && profile.properties.type=='upload'){
                var o = profile.getSubNode('UPLOAD'),c=o.clone();

                //a special node, must delete if from cache here:
                delete profile.$_domid[profile.keys['UPLOAD']];
                o.addPrev(c).remove(false);
                this.setValue('',true);

                return o.get(0);
            }
        },
        resetValue:function(value){
            this.each(function(p){
                if(p.properties.type=='upload')
                    p.getSubNode('UPLOAD').attr('value','');
            });
            return arguments.callee.upper.apply(this,arguments);
        },
        _drop:function(e,src){
            return this.each(function(profile){
                var pro = profile.properties;
                if(pro.disabled)return;
                if(pro.type=='upload'||pro.type=='none'||pro.type=='spin')return;
                //open already
                if(profile.$poplink)return;

                var o,v,
                box = profile.boxing(),
                main = profile.root,
                pos = main.offset(),
                size = main.cssSize()
                ;
                size.width += 2;
                pos.top += main.offsetHeight();

                //get list
                //not normal pop
                switch(pro.type){
                    case 'getter':
                    case 'cmdbox':
                    case 'popbox':
                        box.onClickButton(profile, pos, e, src);
                        return;
                }

                //get cache key
                var cachekey;
                switch(pro.type){
                    case 'timepicker':
                    case 'datepicker':
                    case 'colorpicker':
                        cachekey=pro.type;
                        break;
                    default:
                        if(pro.listKey)
                            //function no cache
                            if(typeof _.get(linb.cache,['UIDATA', pro.listKey])=='function')
                                profile.$drop = cachekey = null;
                            else
                                cachekey = pro.listKey;
                        else
                            cachekey = profile.$id;
                }
                //get from global cache
                if(cachekey){
                    //filter first
                    _.filter(profile.box.$drop,function(o){
                        return !!o.domNode;
                    });
                    profile.$drop = profile.box.$drop[cachekey];
                }

                //cache pop
                if(!profile.$drop){
                    switch(pro.type){
                        case 'combobox':
                        case 'listbox':
                        case 'helpinput':
                            linb.SC('linb.UI.List');
                            o = linb.create('List');
                            o.host(profile).setItems(_.copy(pro.items)).setListKey(pro.listKey||'').adjustSize();
                            o.beforeUIValueSet(function(pro, ovalue, value){
                                var b2=this.boxing();
                                //update value
                                b2.setUIValue(value);
                                //cache pop
                                b2._cache();
                                //set activate
                                b2.activate();
                                return false;
                            });
                            break;
                        case 'timepicker':
                            linb.SC('linb.UI.TimePicker');
                            o = linb.create('TimePicker');
                            o.host(profile);
                            o.beforeClose(function(){this.boxing()._cache();return false});
                            o.beforeUIValueSet(function(p, o, v){
                                //update value
                                this.boxing().setUIValue(v)._cache();
                            });
                            break;
                        case 'datepicker':
                            linb.SC('linb.UI.DatePicker');
                            o = linb.create('DatePicker');
                            o.host(profile);
                            o.beforeClose(function(){this.boxing()._cache();return false});
                            o.beforeUIValueSet(function(p, o, v){
                                //update value
                                this.boxing().setUIValue(String(v.getTime()))._cache();
                            });

                            break;

                        case 'colorpicker':
                            linb.SC('linb.UI.ColorPicker');
                            o = linb.create('ColorPicker');
                            o.host(profile);
                            o.beforeClose(function(){this.boxing()._cache();return false});
                            o.beforeUIValueSet(function(p, o, v){
                                //update value
                                this.boxing().setUIValue('#'+v)._cache();
                            });
                            break;
                    }

                    profile.$drop = o.get(0);

                    //set to global cache
                    if(cachekey)
                        profile.box.$drop[cachekey]=profile.$drop;
                }

                o=profile.$drop.boxing();
                o.host(profile);

                //set pop
                switch(pro.type){
                    case 'combobox':
                    case 'listbox':
                    case 'helpinput':
                        o.setWidth(profile.root.width());
                    case 'timepicker':
                        o.setValue(box.getUIValue(), true);
                        break;
                    case 'datepicker':
                        var t = profile.$drop.properties;
                        t.WEEK_FIRST=pro.WEEK_FIRST;
                        if(t=box.getUIValue())
                            o.setValue(new Date( parseInt(t) ), true);
                        break;
                    case 'colorpicker':
                        o.setValue(box.getUIValue().replace('#',''), true);
                        break;
                }

                profile.$poplink = o.get(0);

                //pop
                var node=o.reBoxing();
                node.popToTop(profile.root);

                _.tryF(o.activate,[],o);

                //for on blur disappear
                node.setBlurTrigger(profile.key+":"+profile.$id, function(){
                    box._cache();
                }, null, profile.$id);

                //for esc
                linb.Event.keyboardHook('esc',0,0,0,function(){
                    box._cache();
                    box.activate();
                    //unhook
                    linb.Event.keyboardHook('esc');
                });
            });
        }
    },
    /*Initialize*/
    Initialize:function(){
        this.addTemplateKeys(['UPLOAD','BTN','TOP','MID','RBTN','R1','R1T','R1B','R2','R2T','R2B']);
        //modify default template for shell
        var t = this.getTemplate();
        _.merge(t.FRAME.BORDER,{
            SBTN:{
                $order:5,
                style:"{saveDisplay}",
                STOP:{},
                SMID:{}
            }
        },'all');
        t.FRAME.POOL={};
        this.setTemplate(t);
    },
    Static:{
        _iniType:function(profile){
            var pro=profile.properties, value=pro.type;
            if(value=='listbox'||value=='upload')
                profile.boxing().setReadonly(true);

            if(value!='listbox' && value!='combobox')
                if(!pro.items)
                    pro.items=[];

            if(value=='timepicker'){
                var  o=linb.SC('linb.UI.TimePicker');
                _.merge(profile,{
                    $compareValue : null,
                    $getShowValue : function(profile,value){
                        return value?o._ensureValue(profile,value):'';
                    },
                    $getEditValue : null,
                    $fromEditValue : function(profile,value){
                        return o._ensureValue(profile,value);
                    }
                },'all');
                if(pro.value)
                    pro.$UIvalue=pro.value=o._ensureValue(profile,pro.value);
            }else if(value=='datepicker'){
                var date=linb.Date;
                _.merge(profile,{
                    $compareValue : function(p,a,b){
                        return String(a)==String(b)
                    },
                    $getShowValue : function(profile,value){
                        return value?date.getText(new Date(parseInt(value)), 'ymd'):'';
                    },
                    $getEditValue : function(profile,value){
                        var v=new Date(parseInt(value));
                        return value?(date.get(v,'m')+1)+'/'+date.get(v,'d')+'/'+date.get(v,'y'):'';
                    },
                    $fromEditValue : function(profile,value){
                        //parse from local text mm/dd/yyyy
                        var v=linb.Date.parse(value);
                        if(v)v=linb.Date.getTimSpanStart(v,'d',1);
                        return v?String(v.getTime()):'0';
                    }
                },'all');
                if(pro.value){
                    var d=new Date(parseInt(pro.value)||0);
                    pro.$UIvalue=pro.value=String(date.getTimSpanStart(d,'d',1).getTime());
                }
            }else{
                delete profile.$compareValue;
                delete profile.$getShowValue;
                delete profile.$getEditValue;
                delete profile.$fromEditValue;
                if(_.isDate(pro.value))
                    pro.$UIvalue=pro.value=String(pro.value);
            }
        },
        $drop:{},
        Appearances:{
            POOL:{
                position:'absolute',
                left:0,
                top:0,
                width:0,
                height:0,
                display:'none',
                visibility:'hidden'
            },
            UPLOAD:{
                opacity:0,
                '*filter':'alpha(opacity=0)',

                'z-index':'3',
                border:0,
                height:'100%',
                position:'absolute',
                top:0,
                right:0,
                cursor:'pointer',
                'font-size':'12px',
                overflow:'hidden'
            },
            'RBTN,SBTN,BTN':{
                display:'block',
                'z-index':'1',
                cursor:'pointer',
                width:'13px',
                'font-size':0,
                'line-height':0,
                position:'relative',
                'float':'right'
            },
            'SBTN,BTN':{
                background: linb.UI.$bg('combo.gif', ' left bottom no-repeat',true)
            },
            'R1,R2':{
                display:'block',
                'font-size':0,
                'line-height':0,
                cursor:'pointer',
                width:'13px',
                position:'absolute',
                height:'50%',
                background: linb.UI.$bg('combo.gif', ' left bottom no-repeat',true)
            },
            R1:{
                top:0
            },
            R2:{
                bottom:0
            },

            'BTN-mouseover, SBTN-mouseover, R1-mouseover, R2-mouseover':{
                $order:1,
                'background-position': '-14px bottom'
            },
            'BTN-mousedown, SBTN-mousedown, R1-mousedown, R2-mousedown':{
                $order:2,
                'background-position': '-27px bottom'
            },
            'STOP, TOP, R1T, R2T':{
                cursor:'pointer',
                width:'13px',
                'font-size':0,
                'line-height':0,
                position:'absolute',
                top:0,
                left:0,
                height:'4px',
                background: linb.UI.$bg('combo.gif', ' left -104px no-repeat',true)
            },
            'BTN-mouseover TOP,SBTN-mouseover STOP, R1-mouseover R1T, R2-mouseover R2T':{
                $order:1,
                'background-position': '-14px -104px'
            },
            'BTN-mousedown TOP,SBTN-mousedown STOP, R1-mousedown R1T, R2-mousedown R2T':{
                $order:2,
                'background-position': '-27px -104px'
            },
            'R1B,R2B':{
                cursor:'pointer',
                width:'13px',
                'font-size':0,
                'line-height':0,
                position:'absolute',
                left:0,
                top:'50%',
                'margin-top':'-3px',
                height:'6px'
            },
            R1B:{
                background: linb.UI.$bg('combo.gif', ' -14px -31px no-repeat',true)
            },
            R2B:{
                background: linb.UI.$bg('combo.gif', ' left -5px no-repeat',true)
            },
            'SMID,MID':{
                cursor:'pointer',
                width:'13px',
                'font-size':0,
                'line-height':0,
                position:'absolute',
                bottom:'3px',
                left:0,
                height:'13px',
                background: linb.UI.$bg('combo.gif', ' left top no-repeat',true)
            },
            SMID:{
                $order:3,
                'background-position': '-14px -14px'
            }
        },
        Behaviors:{
            HoverEffected:{KEY:'BORDER',BTN:'BTN',SBTN:'SBTN',R1:'R1',R2:'R2'},
            ClickEffected:{BTN:'BTN',SBTN:'SBTN',R1:'R1',R2:'R2'},
            UPLOAD:{
                onClick : function(profile, e, src){
                    if(profile.onFileDlgOpen)profile.boxing().onFileDlgOpen(profile,src);
                },
                onChange:function(profile, e, src){
                    profile.getSubNode('INPUT').attr('value',src.value).onChange();
                }
            },
            BTN:{
                onClick : function(profile, e, src){
                    profile.boxing()._drop(e,src);
                }
            },
            SBTN:{
                onClick : function(profile, e, src){
                    if(profile.onSave)profile.boxing().onSave(profile,src);
                }
            },
            INPUT:{
                onChange:function(profile, e, src){
                    if(profile.$_onedit||profile.$_inner)return;

                    var o=profile.inValid,
                        instance=profile.boxing(),
                        v = instance._fromEditValue(src.value),
                        uiv=profile.properties.$UIvalue;
                    if(!instance._compareValue(uiv,v)){
                        profile.$_inner=1;
                        delete profile.$_inner;

                        //give a invalid value in edit mode
                        if(v===null)
                            instance._setCtrlValue(uiv);
                        else{
                            instance.setUIValue(v);
                            //input/textarea is special, ctrl value will be set before the $UIvalue
                            profile.properties.$UIvalue=v;
                            if(o!==profile.inValid) if(profile.domNode)instance._setDirtyMark();
                        }
                    }
                },
                onKeyup:function(profile, e, src){
                    var p=profile.properties;
                    if(p.dynCheck){
                        if(p.$UIvalue!=src.value)
                            profile.box._checkValid(profile, src.value);
                        profile.boxing()._setDirtyMark();
                    }
                },
                onFocus:function(profile, e, src){
                    var p=profile.properties, uiv=p.$UIvalue;
                    if(p.disabled)return false;

                    var instance=profile.boxing(),
                        v = instance._getEditValue(uiv);
                    //string compare
                    if(v!==uiv){
                        //here, dont use $valueFormat, valueFormat or onValueFormat
                        //use $getShowValue, $getEditValue, $fromEditValue related functions
                        profile.$_onedit=true;
                        src.value=v;
                        delete profile.$_onedit;
                    }

                    //set css class
                    if(profile.onFocus)profile.boxing().onFocus(profile);
                    profile.getSubNode('BORDER').tagClass('-focus');
                    //show tips color
                    profile.boxing()._setTB(3);
                },
                onBlur:function(profile, e, src){
                    var p=profile.properties,
                        instance=profile.boxing(),
                        uiv=p.$UIvalue,
                        v = instance._fromEditValue(src.value)
                        ;
                    if(p.disabled)return false;
                    if(profile.onFocus)instance.onFocus(profile);
                    profile.getSubNode('BORDER').tagClass('-focus',false);

                    //onblur check it
                    if(instance._compareValue(p.$UIvalue,v)){
                        profile.box._checkValid(profile, v);
                        instance._setCtrlValue(uiv);
                    }
                    instance._setDirtyMark();
                },
                onKeydown : function(profile, e, src){
                    var prop=profile.properties,
                        m=prop.multiLines,
                        key=linb.Event.getKey(e);
                    //fire onchange first
                    if(key[0]=='enter'&& (!m||key[3]))
                        linb([src]).onChange();
                    if(key[0]=='down'|| key[0]=='up'){
                        if(prop.type=='spin'){
                            profile.box._spin(profile, key[0]=='up');
                            return false;
                        }if(key[1] && prop.type){
                            profile.boxing()._drop(e,src);
                            return false;
                        }
                    }
                },
                onKeyup : function(profile, e, src){
                    var prop=profile.properties,
                        key=linb.Event.getKey(e);
                    if(key[0]=='down'|| key[0]=='up'){
                        if(prop.type=='spin'){
                            linb.Thread.abort(profile.$id+':spin');
                            return false;
                        }
                    }                    
                },
                onClick : function(profile, e, src){
                    if(src.readOnly)
                        profile.boxing()._drop(e, src);
                }
            },
            R1:{
                onMousedown:function(profile){
                    profile.box._spin(profile, true);
                },
                onMouseout:function(profile){
                    linb.Thread.abort(profile.$id+':spin');
                },
                onMouseup:function(profile){
                    linb.Thread.abort(profile.$id+':spin');
                }
            },
            R2:{
                onMousedown:function(profile){
                    profile.box._spin(profile, false);
                },
                onMouseout:function(profile){
                    linb.Thread.abort(profile.$id+':spin');
                },
                onMouseup:function(profile){
                    linb.Thread.abort(profile.$id+':spin');
                }
            }
        },
        EventHandlers:{
            onFileDlgOpen:function(profile, node){},
            onSave:function(profile, node){},
            onClickButton:function(profile, pos, e, src){}
        },
        _posMap:{
            none:'',
            combobox:'left top',
            listbox:'left top',
            upload:'-16px top',
            getter:'left -27px',
            helpinput:'left -91px',
            cmdbox:'left -14px',
            popbox:'left -40px',
            timepicker:'left -53px',
            datepicker:'left -66px',
            colorpicker:'left -79px'
        },
        DataModel:{
            listKey:{
                set:function(v){
                    var t = this.constructor.getCachedData(v);
                    return this.each(function(o){
                        o.boxing().setItems(t?t:o.properties.items);
                        o.properties.listKey = v;
                    });
                }
            },
            items:{
                ini:[],
                action:function(v){
                    var self=this;
                    self.boxing().setValue(null,true);
                    self.SubSerialIdMapItem={};
                    self.ItemIdMapSubSerialId={};
                    //for memory map
                    self.box._prepareItems(self, v);

                    if(v.domNode)
                        self.boxing().clearPopCache();
                }
            },
            readonly:{
                ini:false,
                action:function(v){
                    if(!v && this.properties.type=='listbox')return;
                    this.getSubNode('INPUT').css('cursor',v?'pointer':'default').attr('readonly',v);
                }
            },
            type:{
                ini:'combobox',
                listbox:_.toArr('none,combobox,listbox,upload,getter,helpinput,cmdbox,popbox,timepicker,datepicker,colorpicker,spin'),
                set:function(value, flag){
                    return this.each(function(pro){
                        if(pro.properties.type!=value||flag){
                            pro.properties.type=value;
                            pro.box._iniType(pro);
                            if(pro.domNode)
                                pro.boxing().refresh();
                        }
                    });
                }
            },
            scale:2,
            increment:0.01,
            min:0,
            max:1,
            saveBtn:{
                ini:false,
                action:function(v){
                    this.boxing().refresh();
                }
            },
            $border:1
        },
        RenderTrigger:function(){
            var self=this,
                instance=self.boxing(),
                p=self.properties;
            self.box._iniType(self);
            if(p.readonly)
                instance.setReadonly(true,true);
        },
        _spin:function(profile, flag){
            var id=profile.$id+':spin';
            if(linb.Thread.isAlive(id))return;
            var prop=profile.properties,
                off=prop.increment*(flag?1:-1),
                task={delay:300},
                fun=function(){
                    profile.boxing().setUIValue(String((+prop.$UIvalue||0)+off));
                    task.delay *=0.9;
                };
            task.task=fun;
            linb.Thread(id,[task],500,null,fun,null,true).start();
        },
        _dynamicTemplate:function(profile){
            var properties = profile.properties,
                hash = profile._exhash = "$" +
                    'multiLines:'+properties.multiLines+';'+
                    'type:'+properties.type+';',
                template = profile.box.getTemplate(hash);

            properties.$UIvalue = properties.value;

            // set template dynamic
            if(!template){
                template = _.clone(profile.box.getTemplate());
                var t=template.FRAME.BORDER;

                if(properties.multiLines){
                    t.BOX.INPUT.tagName='textarea';
                    delete t.BOX.INPUT.type;
                }

                switch(properties.type){
                case 'spin':
                    t.RBTN={
                        $order:5,
                        style:"{rDisplay}",
                        R1:{
                            R1T:{},
                            R1B:{}
                        },
                        R2:{
                            R2T:{},
                            R2B:{}
                        }
                    };
                break;
                case 'none':
                break;
                case 'upload':
                    t.UPLOAD={
                        $order:2,
                        tagName:'input',
                        type:'file',
                        size:'1'
                    };
                default:
                    t.BTN={
                        $order:4,
                        style:"{popbtnDisplay}",
                        TOP:{},
                        MID:{
                            style:'{typePos}'
                        }
                    };
                }

                // set template
                profile.box.setTemplate(template, hash);
            }
            profile.template = template;
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile),
                map=profile.box._posMap;
            if(map[data.type])
                data.typePos = 'background-position:'+map[data.type];

            data.saveDisplay = data.saveBtn?'':'display:none';
            data.popbtnDisplay = data.type!='none'?'':'display:none';
            return data;
        },
        _ensureValue:function(profile, value){
            var me=arguments.callee, reg=me._reg||(me._reg=/^#[\w]{6}$/),prop=profile.properties;
            switch(profile.properties.type){
                case 'datepicker':
                    return (value.constructor==Date?value.getTime():value) + "";
                case 'colorpicker':
                    return '#'+linb.UI.ColorPicker._ensureValue(null,value);
                case 'timepicker':
                    return linb.UI.TimePicker._ensureValue(null,value);
                case 'spin':
                    var n=Math.pow(10,prop.scale);
                    value=+value||0;
                    value=Math.ceil((value-0.0000000000003)*n)/n;
                    return String(value>prop.max?prop.max:value<prop.min?prop.min:value);
                default:
                    return String(value);
            }
        },
        _onresize:function(profile,width,height){
            var size=linb.UI.Widget._onresize.apply(this,arguments),
                prop=profile.properties,
                px='px',
                f=function(k){return k?profile.getSubNode(k)._nodes[0]:null},
                type=prop.type,
                input=f('INPUT'),
                save=f(prop.saveBtn?'SBTN':null),
                btn=f(type=='spin'?'RBTN':type=='none'?null:'BTN')
                ;

            if(!_.isNull(width))
                input.style.width = (size.width-(save?save.offsetWidth:0)-(btn?btn.offsetWidth:0))+px;

            if(!_.isNull(height)){
                height=size.height+px;
                /*-(linb.browser.ie6?2:linb.browser.ie?1:linb.browser.kde?1:0)*/
                input.style.height=height;
                if(save)save.style.height=height;
                if(btn)
                    btn.style.height=height;

                if(prop.type=='spin'){
                    height=size.height/2+px;
                    f('R1').style.height=height;
                    f('R2').style.height=height;
                }
            }
        }
    }
});
Class("linb.UI.Group", "linb.UI.Div",{
    Instance:{
        activate:function(){
            var profile = this.get(0);
            profile.getSubNode('HANDLE').focus();
            return this;
        }
    },
    Static:{
        Behaviors:{
            NavKeys:{CAPTION:1},
            DropableKeys:['PANEL'],
            DragableKeys:['HANDLE'],
            onSize:function(profile,e){
                //if fire onresize ,w/h must be set to style
                var style = profile.domNode.style ,w=null,h=null;
                if(e.width)
                    w=parseInt(style.width)||w;
                if(e.height)
                    h=parseInt(style.height)||h;
                linb.UI.$tryResize(profile, w, h);
            },
            HANDLE:{
                onClick:function(profile, e, src){
                    if(profile.properties.toggleBtn){
                        profile.box._toggle(profile, !profile.properties.toggle);
                        return false;
                    }
                }
            }
        },
        Templates:{
            tagName : 'div',
            style:'{_style}',
            FIELDSET:{
                tagName : 'fieldset',
                className: ' {toggleCls}',
                LEGEND:{
                    tagName : 'legend',
                    HANDLE:{
                        tagName: 'a',
                        href :linb.$href,
                        tabindex: '{tabindex}',
                        TOGGLE:{
                            className: 'uicmd-toggle {toggleCls}',
                            style:"{toggleDispplay}"
                        },
                        ICON:{
                            style:'background:url({image}) transparent  no-repeat {imagePos};{iconDisplay}',
                            className:'ui-icon',
                            $order:1
                        },
                        CAPTION : {
                            text:   '{caption}',
                            $order:2
                        }
                    }
                },
                PANEL:{
                    $order:1,
                    tagName:'div',
                    style:'{panelDisplay}',
                    text:'{html}'+linb.UI.$childTag
                }
            }
        },
        Appearances:{
            KEY:{
                zoom:linb.browser.ie6?"1":null
            },
            FIELDSET:{
                border:'1px solid #CCCCCC',
                position:'relative',
                overflow:'hidden',
                zoom:linb.browser.ie6?"1":null
            },
            'FIELDSET-checked':{
                $order:2,
                'padding-left':'2px',
                'border-left':'0',
                'border-right':'0',
                'border-bottom':'0'
            },
            LEGEND:{
                'margin-left':'3px'
            },
            HANDLE:{
                cursor:'default'
            },
            PANEL:{
                position:'relative',
                overflow:'auto',
                 background:linb.browser.ie?'url('+linb.ini.file_bg+') no-repeat left top':null
            },
            'FIELDSET-checked PANEL':{
                $order:4,
                display:'none'
            },
            CAPTION:{
                'vertical-align':'middle',
                'font-family': '"Verdana", "Helvetica", "sans-serif"',
                'font-size':'12px',
                'line-height':'18px'
            }
        },

        DataModel:{
            caption:{
                ini:undefined,
                // ui update function when setCaption
                action: function(value){
                    this.getSubNode('CAPTION').get(0).innerHTML = value;
                }
            },
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('HANDLE').attr('tabIndex',value);
                }
            },
            html:{
                action:function(v){
                    this.getSubNode('PANEL').html(v);
                }
            },
            toggleBtn:{
                ini:true,
                action:function(v){
                    this.getSubNode('TOGGLE').css('display',v?'':'none');
                }
            },
            toggle:{
                ini:true,
                action:function(v){
                    this.box._toggle(this, v);
                }
            },
            image:{
                action: function(value){
                    this.getSubNode('ICON')
                        .css('display',value?'':'none')
                        .css('backgroundImage','url('+(value||'')+')');
                }
            },
            imagePos:{
                action: function(value){
                    this.getSubNode('ICON')
                        .css('backgroundPosition', value);
                }
            }
        },
        LayoutTrigger:function(){
            var self=this, t=self.properties, b=self.box;
            if(t.toggle)
                b._toggle(self,t.toggle);
        },        
        EventHandlers:{
            onIniPanelView:function(profile){},
            onFold:function(profile){},
            onExpend:function(profile){}
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile),
                nodisplay='display:none';

            data.toggleDispplay=data.toggleBtn?'':nodisplay;

            data.panelDisplay = data.toggleBtn&&!data.toggle?nodisplay:'';
            data.toggleCls = data.toggleBtn&&!data.toggle?profile.getClass('FIELDSET','-checked'):'';
            data.toggleCls2 = data.toggleBtn&&!data.toggle?profile.getClass('TOGGLE','-checked'):'';
            return data;
        },
        _onresize:function(profile,width,height){
            if(height && parseInt(profile.domNode.style.height)){
                profile.getSubNode('FIELDSET').height(height);
                profile.getSubNode('PANEL').height(height-(profile.getSubNode('LEGEND').height()||18));
            }
            if(width && parseInt(profile.domNode.style.width))
                profile.getSubNode('PANEL').width(width-2);
        },
        _toggle:function(profile, value){
            var p=profile.properties, b=profile.boxing();
            //set toggle mark
            p.toggle = value;

            //event
            if(value &&!profile.$ini)
                if(b.onIniPanelView)
                    if(b.onIniPanelView(profile)!==false)
                        profile.$ini=true;

            if(value){
                if(false===b.onExpend(profile))return;
            }else{
                if(false===b.onFold(profile))return;
            }

            //show/hide/panel
            profile.getSubNode('PANEL').css('display',value?'':'none');
            //chang toggle button

            profile.getSubNodes(['TOGGLE','FIELDSET']).tagClass('-checked', !value);
        }
    }
});Class('linb.UI.ColorPicker', ['linb.UI',"linb.absValue"], {
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                if(!profile.domNode)return;
                var cls = profile.box,
                    p = profile.properties,
                    hex = profile.$hex = cls._to3(value),
                    hexs=profile.$hex.join(''),
                    rgb = profile.$rgb = cls.hex2rgb(value),
                    hsv = profile.$hsv = cls.rgb2hsv(rgb),
                    f=function(s,v){profile.getSubNode(s).get(0).firstChild.nodeValue=String(v)},
                    ff=function(v){return parseInt(v*100)};

                f('R',rgb[0]);
                f('G',rgb[1]);
                f('B',rgb[2]);
                f('H',hex[0]);
                f('E',hex[1]);
                f('X',hex[2]);

                //dont update hsv UI again, if hsv value is the newest
                if(profile.$hexinhsv != hexs){
                    f('HH',hsv[0]);
                    f('S',ff(hsv[1]));
                    f('V',ff(hsv[2]));
                    delete profile.$hexinhsv;
                }
                cls._setClrName(profile,hexs);
                cls._updateDftTip(profile);
                //dont update adv UI again, if adv value is the newest
                if(p.advance && profile.$hexinadv != hexs){
                    cls._updateMarks(profile, value, true, hsv[0]);
                    delete profile.$hexinadv;
                }
           });
        },
        getColorName:function(){
            return this.get(0).$clrN||'';
        }
    },
    Initialize:function(){
        var ns=this,
            e=linb.Event.$EVENTHANDLER,
            id=linb.UI.$ID,
            cls=linb.UI.$CLS,
            key=ns.KEY,
            list=ns._slist,
            l=list.length,
            i,data,
            arr=[],
            evs=' unselectable="on" onmousedown="'+e+'" ondrag="'+e+'" ondragstop="'+e+'" ';

        ns.addTemplateKeys(['TXT', 'DD1', 'DD2', 'DD3','R','G','B','HH','S','V','H','E','X']);

        //simple list
        for(i=0;i<l;i++)
            arr.push('<a  '+'id="'+key+'-SC:'+id+':'+list[i]+'" href='+linb.$href+' onmouseover="'+e+'"  onkeydown="'+e+'" onclick="'+e+'" style="background-color:#'+list[i]+'">'+list[i]+'</a>');

        //data
        data = '<div><span class="'+cls+'-txt">R: </span><span '+'id="'+key+'-R:'+id+':" class="'+cls+'-dd2 ui-dragable #DD2_CC#" '+evs+'>R</span><span style="width:8px;height:8px"  unselectable="on" ></span><span class="'+cls+'-txt">H: </span><span '+'id="'+key+'-HH:'+id+':" class="'+cls+'-dd2 ui-dragable #DD2_CC#" '+evs+'>H</span><span>\xB0</span></div>' +
               '<div><span class="'+cls+'-txt">G: </span><span '+'id="'+key+'-G:'+id+':" class="'+cls+'-dd2 ui-dragable #DD2_CC#" '+evs+'>G</span><span style="width:8px;height:8px"  unselectable="on" ></span><span class="'+cls+'-txt">S: </span><span '+'id="'+key+'-S:'+id+':" class="'+cls+'-dd2 ui-dragable #DD2_CC#"  '+evs+'>S</span><span>%</span></div>' +
               '<div><span class="'+cls+'-txt">B: </span><span '+'id="'+key+'-B:'+id+':" class="'+cls+'-dd2 ui-dragable #DD2_CC#" '+evs+'>B</span><span style="width:8px;height:8px"  unselectable="on" ></span><span class="'+cls+'-txt">V: </span><span '+'id="'+key+'-V:'+id+':" class="'+cls+'-dd2 ui-dragable #DD2_CC#" '+evs+'>V</span><span>%</span></div>' +
               '<div><span style="width:38px">HEX: #</span><span '+'id="'+key+'-H:'+id+':" class="'+cls+'-dd3 ui-dragable #DD3_CC#" '+evs+'>H</span><span '+'id="'+key+'-E:'+id+':" class="'+cls+'-dd3 ui-dragable #DD3_CC#" '+evs+'>E</span><span '+'id="'+key+'-X:'+id+':" class="'+cls+'-dd1 ui-dragable #DD1_CC#" '+evs+'>X</span></div>'
        ns.setTemplate({
            style:'{_style};width:{_width}px;',
            tagName : 'div',
            onselectstart:'return false',
            BORDER:{
                tagName : 'div',
                BAR:{
                    tagName:'div',
                    className:'uibar-bar',
                    style:'{barDisplay};height:22px',
                    BART:{
                        cellpadding:"0",
                        cellspacing:"0",
                        width:'100%',
                        height:'100%',
                        border:'0',
                        tagName:'table',
                        className:'uibar-t',
                        BARTR:{
                            tagName:'tr',
                            BARTDL:{
                                tagName:'td',
                                className:'uibar-tdl'
                            },
                            BARTDM:{
                                $order:1,
                                width:'100%',
                                tagName:'td',
                                className:'uibar-tdm'
                            },
                            BARTDR:{
                                $order:2,
                                tagName:'td',
                                className:'uibar-tdr'
                            }
                        }
                    },
                    BARCMDL:{
                        tagName: 'div',
                        className:'uibar-cmdl'
                    },
                    BARCMDR:{
                        tagName: 'div',
                        className:'uibar-cmdr',
                        onselectstart:'return false',
                        unselectable:'on',
                        CLOSE:{
                            className:'uicmd-close ',
                            style:'{closeDisplay}'
                        }
                    }
                },
                CON:{
                    $order:1,
                    tagName:'div',
                    className:'ui-content',
                    SIMPLE:{
                        tagName:'div',
                        TOP:{
                            $order:1,
                            tagName:'div',
                            DATA:{
                                $order:0,
                                tagName:'div',
                                onselectstart:'return false',
                                text:data
                            },
                            EXAM:{
                                $order:1,
                                tagName:'div'
                            }
                        },
                        LIST:{
                           $order:2,
                           tagName:'div',
                           text: arr.join('')
                        },
                        SUBMIT:{
                            $order:3,
                            tagName:'div',
                            OK:{
                                tagName:'a',
                                href:linb.$href,
                                className:'ui-btn',
                                style:'{submitDispay}',
                                text:linb.wrapRes('inline.ok')
                            },
                            CANCEL:{
                                $order:1,
                                className:'ui-btn',
                                style:'{submitDispay}',
                                tagName:'a',
                                href:linb.$href,
                                text:linb.wrapRes('inline.cancel')
                            },
                            TOGGLE:{
                                $order:2,
                                tagName:'a',
                                href:linb.$href,
                                className:'ui-btn',
                                text:'>>'
                            }
                        }
                    },
                    ADV:{
                        $order:2,
                        style:'{advDispay}',
                        tagName:'div',
                        ADVWHEEL:{
                            $order:0,
                            tagName:'div'
                        },
                        ADVCLR:{
                            $order:1,
                            tagName:'div'
                        },
                        ADVMARK1:{
                            $order:3,
                            tagName:'div'
                        },
                        ADVMARK2:{
                            $order:4,
                            tagName:'div'
                        }
                    }
                }
            }
        });
    },
    Static:{
        _radius:84,
        _square:100,
        _bigRadius:97,
        DataModel:{
            height:230,
            value:"FFFFFF",
            displayBar : {
                ini:true,
                action:function(v){
                    this.getSubNode('BAR').css('display',v?'':'none');
                }
            },
            closeBtn:{
                ini:true,
                action:function(v){
                    this.getSubNode('CLOSE').css('display',v?'':'none');
                }
            },
            advance:{
                ini:false,
                action:function(v){
                    var ns=this;
                    ns.getSubNode('ADV').css('display',v?'':'none');
                    ns.getSubNode('TOGGLE').text(v?"<<":">>");
                    ns.root.width(v?400:200);
                    if(v)
                        ns.box._updateMarks(ns,ns.properties.$UIvalue,true, ns.$hsv[0])
                }
            },
            cmdBtns:{
                ini:true,
                action:function(v){
                    var n=v?'':'none',ns=this;
                    ns.getSubNode('OK').css('display',n);
                    ns.getSubNode('CANCEL').css('display',n);
                }
            },
            $borderW:1
        },
        Appearances:{
            KEY:{
                '-moz-user-select': 'none'
            },
            BORDER:{
                overflow: 'visible',
                position: 'relative'
            },
            CON:{
                height:'200px',
                border: 'solid 1px #C1C1C1',
                padding:'3px',
                'margin-top':'-1px'
            },

            DATA:{
                'float':'left',
                width:'112px',
                height:'86px'
            },
            'DATA span':{
                'float':'left'
            },
            'DATA div':{
                'padding-top':'3px',
                'clear':'both'
            },
            TXT:{
                width:'16px'
            },
            EXAM:{
                'float':'left',
                height:'80px',
                width:'80px',
                background:'red',
                'padding-top':'2px',
                'white-space':'normal',
                'text-align':'center'
            },
            'DD1, DD2, DD3':{
                display:'block',
                height:'16px',
                border:'1px solid #7F9DB9',
                'padding-right':'2px',
                cursor:'e-resize',
                'text-align':'right',
                background:'#FFFACD'
            },
            DD1:{
                width:'16px',
                border:'1px solid #7F9DB9'
            },
            DD2:{
                width:'24px',
                border:'1px solid #7F9DB9'
            },
            DD3:{
                $order:2,
                width:'16px',
                'border-right':'none'
            },
            TOP:{
                width:'192px'
            },
            LIST :{
                width:'192px',
                overflow:'hidden',
                'padding-top':'4px',
                'line-height':linb.browser.ie6?'0':null,
                'clear':'both'
            },
            SIMPLE:{
                'float':'left'
            },
            ADV:{
                'float':'right',
                width:'195px',
                height:'195px',
                position:'relative'
            },
            'ADV div':{
                cursor:'crosshair',
                position:'absolute'
            },
            ADVCLR:{
                background: linb.browser.ie6?null:linb.UI.$bg('bg.png', 'no-repeat left top'),
                _filter: linb.UI.$ieBg('bg.png'),
                height:'101px',
                left:'47px',
                top:'47px',
                width:'101px'
            },
            ADVWHEEL:{
                background: linb.browser.ie6?null:linb.UI.$bg('clr.png', ' no-repeat left top'),
                _filter: linb.UI.$ieBg('clr.png'),
                height:'195px',
                width:'195px'
            },
            'ADVMARK1, ADVMARK2':{
                background:linb.browser.ie6?null:linb.UI.$bg('picker.png', ' no-repeat left top'),
                _filter: linb.UI.$ieBg('picker.png'),
                height:'17px',
                margin:'-8px 0pt 0pt -8px',
                overflow:'hidden',
                width:'17px'
            },
            'LIST a':{
                height: '9px',
                width: '9px',
                'font-size':linb.browser.ie6?'0':null,
                'float': 'left',
                display: 'block',
                overflow: 'hidden',
                'text-indent': '100px',
                margin: '0',
                cursor: 'pointer',
                border: '1px solid #F6F7EE'
            },
            'LIST a:hover':{
                border: '1px solid black'
            },
            SUBMIT:{
                'margin-top':'1px',
                'text-align':'right',
                padding:'4px'
            },
            'OK, CANCEL':{
                'margin-right':'5px'
            }
        },
        Behaviors:{
            HoverEffected:{CLOSE:'CLOSE'},
            ClickEffected:{CLOSE:'CLOSE'},
            KEY:{onClick:function(){return false}},
            SC:{
                onMouseover:function(p,e,s){
                    p.box._setTempUI(p,p.getSubId(s.id));
                },
                onClick:function(p,e,s){
                    var sid=p.getSubId(s.id);
                    p.boxing()._setCtrlValue(p.$tempValue=sid);
                    if(!p.properties.advance)
                        p.boxing().setUIValue(sid);
                    return false;
                }
            },
            LIST:{
                onMouseout:function(p,e,s){
                    p.box._updateDftTip(p);
                }
            },
            OK:{
                onClick:function(p,e,src){
                    p.boxing().setUIValue(p.$tempValue);
                }
            },
            CANCEL:{
                onClick:function(p,e,src){
                    p.getSubNode('CLOSE').onClick(true);
                }
            },
            TOGGLE:{
                onClick:function(p,e,src){
                    p.boxing().setAdvance(!p.properties.advance)
                }
            },
            R:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,0);
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,0);
                }
            },
            G:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,1);
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,1);
                }
            },
            B:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,2);
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,2);
                }
            },
            HH:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src,true);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,0,'hsv1');
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,0,true,'hsv1');
                }
            },
            S:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src,true);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,1,'hsv2');
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,1,true,'hsv2');
                }
            },
            V:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src,true);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,2,'hsv2');
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,2,true,'hsv2');
                }
            },
            H:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,0,'hex');
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,0);
                }
            },
            'E':{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,1,'hex');
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,1);
                }
            },
            X:{
                onMousedown:function(p, e, src){
                    p.box._dd1(p,e,src);
                },
                onDrag:function(p, e, src){
                    p.box._dd2(p,e,src,2,'hex');
                },
                onDragstop:function(p, e, src){
                    p.box._dd3(p,e,src,2);
                }
            },
            CLOSE:{
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        instance = profile.boxing();
                    if(properties.disabled)return;
                    if(false===instance.beforeClose(profile)) return;
                    instance.destroy();
                    //for design mode in firefox
                    return false;
                }
            },
            ADVWHEEL:{
                onMousedown:function(p, e, src){
                    var cls=p.box;
                    cls._prepareAdv(p,e);
                    cls._updateClrByPos(p,e,true);
                    p.getSubNode('ADVMARK1').startDrag(e, {
                        dragType:'none'
                    });
                }
            },
            ADVMARK1:{
                onMousedown:function(p, e, src){
                    var cls=p.box;
                    cls._prepareAdv(p,e);
                    cls._updateClrByPos(p,e,true);
                    p.getSubNode('ADVMARK1').startDrag(e, {
                        dragType:'none'
                    });
                },
                onDrag:function(p, e, src){
                    var cls=p.box;
                    cls._updateClrByPos(p,e,true);
                },
                onDragstop:function(p, e, src){
                    var cls=p.box;
                    cls._updateValueByPos(p, e);
                }
            },
            ADVCLR:{
                onMousedown:function(p, e, src){
                    var cls=p.box;
                    cls._prepareAdv(p,e);
                    cls._updateClrByPos(p,e);
                    p.getSubNode('ADVMARK2').startDrag(e, {
                        dragType:'none'
                    });
                    return false;
                }
            },
            ADVMARK2:{
                onMousedown:function(p, e, src){
                    var cls=p.box;
                    cls._prepareAdv(p,e);
                    cls._updateClrByPos(p,e);
                    p.getSubNode('ADVMARK2').startDrag(e, {
                        dragType:'none'
                    });
                    return false;
                },
                onDrag:function(p, e, src){
                    var cls=p.box;
                    cls._updateClrByPos(p, e);
                },
                onDragstop:function(p, e, src){
                    var cls=p.box;
                    cls._updateValueByPos(p, e,true);
                }
            }
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile);
            var nodisplay='display:none';
            data.displayBar= data.displayBar?'':nodisplay;
            data.closeDisplay = data.closeBtn?'':nodisplay;
            data._width = data.advance?'400':'200';
            data.advDispay = data.advance?'':'display:none;';
            data.submitDispay = data.cmdBtns?'':'display:none;';
            return data;
        },
        EventHandlers:{
            beforeClose:function(profile, src){}
        },
        RenderTrigger:function(){
            this.$onValueSet=this.$onValueUpdated=function(v){
                this.box._setClrName(this,v);
            };
        },
        _setClrName:function(profile,v){
            var p=profile,
                k='color.LIST.',
                vv=linb.getRes(k+v);
            if(vv==v)
                p.$clrN2 = p.$clrN = '#'+v;
            else{
                p.$clrN = vv;
                p.$clrN2 = linb.wrapRes(k+v);
            }
        },
        _slist:"FFFFFF,FFFFF0,FFFFE0,FFFF00,FFFAFA,FFFAF0,FFFACD,FFF8DC,FFF5EE,FFF0F5,FFEFD5,FFEBCD,FFE4E1,FFE4C4,FFE4B5,FFDEAD,FFDAB9,FFD700,FFC0CB,FFB6C1,FFA500,FFA07A,FF8C00,FF7F50,FF69B4,FF6347,FF4500,FF1493,FF00FF,FF00FF,FF0000,FDF5E6,FAFAD2,FAF0E6,FAEBD7,FA8072,F8F8FF,F5FFFA,F5F5F5,F5DEB3,F4A460,F0FFFF,F0FFF0,F0F8FF,F0E68C,F08080,EEE8AA,EE82EE,E9967A,E6E6FA,E1FFFF,DEB887,DDA0DD,DCDCDC,DC143C,DB7093,DAA520,DA70D6,D8BFD8,D3D3D3,D2B48C,D2691E,CD853F,CD5C5C,C71585,C0C0C0,BDB76B,BC8F8F,BA55D3,B22222,B0E0E6,B0C4DE,AFEEEE,ADFF2F,ADD8E6,A9A9A9,A52A2A,A0522D,9932CC,98FB98,9400D3,9370DB,90EE90,8FBC8F,8B4513,8B008B,8B0000,8A2BE2,87CEFA,87CEEB,808080,808000,800080,800000,7FFFAA,7FFF00,7CFC00,7B68EE,778899,708090,6B8E23,6A5ACD,696969,6495ED,5F9EA0,556B2F,4B0082,48D1CC,483D8B,4682B4,4169E1,40E0D0,3CB371,32CD32,2F4F4F,2E8B57,228B22,20B2AA,1E90FF,191970,00FFFF,00FFFF,00FF7F,00FF00,00FA9A,00CED1,00BFFF,008B8B,008080,008000,006400,0000FF,0000CD,00008B,000080,000000".split(','),
        _C16:"0123456789ABCDEF",
        //for drag rgb span
        _dd1:function(profile, e, src, hsv){
            var p=profile.properties,
                cls=profile.box,
                f=function(){var rgb = cls.hex2rgb(p.$UIvalue); return hsv?cls.rgb2hsv(rgb):rgb;};

            linb([src]).css('background','red').startDrag(e, {
                dragType:'blank',
                targetReposition:false,
                widthIncrement:2,
                dragCursor:true
            });
            profile.$temp=0;
            profile.$start = f();
            profile.$temp2 = f();
        },
        _dd2:function(profile, e, src, i, type){
            var count,
                off = linb.DragDrop.getProfile().offset,
                p=profile.properties,
                old=profile.$temp2,
                cls=profile.box,
                rate = type=='hsv1'?361:type=='hsv2'?101:256,
                v;

            count = (type=='hsv2'?parseInt(profile.$start[i]*100):parseInt(profile.$start[i]))+parseInt(off.x/2);

            count=(count%rate+rate)%rate;
            if(profile.$temp!=count){
                old[i]=profile.$temp = type=='hsv2'?count/100:count;
                v = (type=='hsv1'||type=='hsv2')?cls.hsv2rgb(old):old;
                v=cls.rgb2hex(v);
                cls._setTempUI(profile,v);
                linb([src]).text(type=='hex'?cls._toFF(count):count);
            }
        },
        _dd3:function(profile, e, src, i, hsv){
            if(profile.$start[i] !== profile.$temp){
                var p=profile.properties,
                    cls=profile.box,
                    old=profile.$start,
                    v;
                old[i]=profile.$temp;
                v=hsv?cls.hsv2rgb(old):old;
                v=cls.rgb2hex(v);

                //set the cur hex value of hsv for preventing update adv UI again
                if(hsv)profile.$hexinhsv=v;
                profile.boxing()._setCtrlValue(profile.$tempValue=v);
                delete profile.$hexinhsv;
            }
            linb([src]).css('background','');
            profile.$temp=profile.$start=0;
        },
        //set temp UI
        _setTempUI:function(p,v){
            var cls=this,
                rgb=cls.hex2rgb(v),
                b=p.boxing(),
                ex=b.getSubNode('EXAM'),
                hsv=cls.rgb2hsv(rgb),
                vv=linb.getRes('color.LIST.'+v);
            ex.css({backgroundColor:'#'+v, color:hsv[2]>0.6?'#000':'#FFF'});
            ex.text(p.show_color=vv==v?'#'+v:vv);
        },
        //reset example block
        _updateDftTip:function(p){
            var cls=p.box,
                ex=p.boxing().getSubNode('EXAM');
            ex.css({backgroundColor:'#'+p.$hex.join(''), color:p.$hsv[2]>0.6?'#000':'#FFF'});
            ex.html(p.$clrN2||'',false);
        },
        _to3:function(s){
            if(!s)s="FFFFFF";
            return [s.substr(0, 2), s.substr(2, 2), s.substr(4, 2)];
        },
        //0...255 to 00...FF
        _toFF: function(n) {
            var C16=this._C16;
            n = parseInt(n)||0;
            n = (n>255||n<0)?0:n;
            return C16.charAt((n-n%16)/16) + C16.charAt(n%16);
        },
        // 00...FF to 0...255
        _to255: function(str) {
            var C16=this._C16, s=str.split('');
            return C16.indexOf(s[0].toUpperCase())*16 + C16.indexOf(s[1].toUpperCase());
        },
        _webSafe:function(r, g, b){
            //safe divisor is 51, smart divisor is 17
            var me=arguments.callee,f=me.f||(me.f=function(n){
                return parseInt(n/51)*51;
            });
            if(typeof r=='object'){
                g=r[1];b=r[2];r=r[0];
            }
            return [f(r),f(g),f(b)];
        },
        _updateMarks:function(profile, hex, forcePos, hsv0){
            var cls=this,
                rgb=cls.hex2rgb(hex),
                hsv=cls.rgb2hsv(rgb),
                angle=(hsv[0]/360)*6.28,
                clr=profile.getSubNode('ADVCLR');
            if(forcePos){
                var m1=profile.getSubNode('ADVMARK1'),
                    m2=profile.getSubNode('ADVMARK2');
                m1.cssPos({
                  left: Math.round(Math.sin(angle)*cls._radius+cls._bigRadius),
                  top: Math.round(-Math.cos(angle)*cls._radius+cls._bigRadius)
                });
                m2.cssPos({
                  left: Math.round(cls._square*(hsv[1]-0.5)+cls._bigRadius),
                  top: Math.round(cls._square*(0.5-hsv[2])+cls._bigRadius)
                });
            }

            if(hsv0 !== undefined)
                clr.css('backgroundColor', '#'+cls.rgb2hex(cls.hsv2rgb([hsv0, 1, 1])));
            cls._setTempUI(profile, hex);
        },
        //flag:change h
        _updateClrByPos:function(profile, e, flag){
            var cls=this,
                mPos=linb.Event.getPos(e),
                pos=profile.$tpos,
                left=mPos.left-pos.left,
                top=mPos.top-pos.top,
                angle,m1,m2,
                h,s,v,hsv,rgb,hex;
            ;
            if(flag){
                m1=profile.getSubNode('ADVMARK1');
                angle=Math.atan2(left, -top);
                m1.cssPos({
                  left: Math.round(Math.sin(angle)*cls._radius+cls._bigRadius),
                  top: Math.round(-Math.cos(angle)*cls._radius+cls._bigRadius)
                });
                h=Math.floor((angle/6.28)*360);
                if(h<0)h +=360;
                hsv=[h, profile.$hsv[1], profile.$hsv[2]];
                rgb = cls.hsv2rgb(hsv);
                hex = cls.rgb2hex(rgb);
                cls._updateMarks(profile, profile.$t_hex=hex, false, h);
            }else{
                m2=profile.getSubNode('ADVMARK2');
                s=Math.max(0, Math.min(1, (left/cls._square) + 0.5));
                v=Math.max(0, Math.min(1, 0.5 - (top/cls._square)));
                m2.cssPos({
                  left: Math.round(cls._square*(s-0.5)+cls._bigRadius),
                  top: Math.round(cls._square*(0.5-v)+cls._bigRadius)
                });
                hsv=[profile.$hsv[0], s, v];
                rgb = cls.hsv2rgb(hsv);
                hex = cls.rgb2hex(rgb);
                cls._updateMarks(profile, profile.$t_hex=hex);
            }

        },
        _updateValueByPos:function(profile, e, flag){
            //set the cur hex value of adv for preventing update adv UI again
            profile.$hexinadv=profile.$t_hex;
            profile.boxing()._setCtrlValue(profile.$tempValue=profile.$t_hex);
            delete profile.$hexinadv;
        },
        _prepareAdv:function(profile,e){
            var cls=this,
                pos=profile.getSubNode('ADVWHEEL').offset();
            profile.$tpos= { left:pos.left+cls._bigRadius, top:pos.top+cls._bigRadius };
        },
        _ensureValue:function(profile,v){
            var ns=this,me=arguments.callee,map=me.map||(me.map=(function(){
                var h={};
                _.arr.each(ns._C16.split(''),function(o,i){
                    h[o]=1;
                });
                return h;
            }())),
            reg=me._r||(me._r=/rgb\(([^)]*)\)/);
            if(!v || typeof v !='string')return 'FFFFFF';
            if(reg.test(v)){
                v=v.replace(reg,'$1');
                v=v.split(',');
                v[0]=parseInt(v[0])||0;
                v[1]=parseInt(v[1])||0;
                v[2]=parseInt(v[2])||0;
                v=ns.rgb2hex(v);
            }
            if(v.charAt(0)=='#')v=v.substr(1,v.length);
            var a='',k;
            for(var i=0;i<6;i++){
                k=v.charAt(i).toUpperCase();
                a += (map[k]?k:'F');
            }
           return a;
        },
        //HSV (h[0-360], s[0-1]), v[0-1] to RGB [255,255,255]
        hsv2rgb: function(h, s, v) {
            if(h instanceof Array) {
                s=h[1]; v=h[2]; h=h[0];
            }
            var me=arguments.callee, f = me.f ||
                (me.f=function(n) {
                    return Math.min(255, Math.round(n*256));
                }),
                r, g, b, i, k, p, q, t;
            if(s==0)
                return [v=f(v),v,v];
            else{
                i = Math.floor((h/60)%6);
                k = (h/60)-i;
                p = v*(1-s);
                q = v*(1-k*s);
                t = v*(1-(1-k)*s);
                switch(i) {
                    case 0: r=v; g=t; b=p; break;
                    case 1: r=q; g=v; b=p; break;
                    case 2: r=p; g=v; b=t; break;
                    case 3: r=p; g=q; b=v; break;
                    case 4: r=t; g=p; b=v; break;
                    case 5: r=v; g=p; b=q; break;
                }
                return s==0?[v=f(v),v,v]:[f(r), f(g), f(b)];
            }
        },
        // RGB [255,255,255] to HSV (h[0-360], s[0-1]), v[0-1]
        rgb2hsv: function(r, g, b) {
            if(r instanceof Array) {
                g=r[1];b=r[2];r=r[0];
            }
            r=r/255;g=g/255;b=b/255;
            var min=Math.min(r,g,b),
                max=Math.max(r,g,b),
                delta = max-min,
                s = (max===0)?0:1-(min/max),
                v = max,
                h;
            switch (max) {
                case min:
                    h=0;
                    break;
                case r:
                    h=60*(g-b)/delta;
                    if(g<b)h+=360;
                    break;
                case g:
                    h=(60*(b-r)/delta)+120;
                    break;
                case b:
                    h=(60*(r-g)/delta)+240;
                    break;
            }
            return [Math.round(h), s, v];
        },
        //rgb values into a hex string; 255,255,255 -> FFFFFF
        rgb2hex: function(r, g, b) {
            var ns=this;
            if(r instanceof Array) {
                g=r[1];b=r[2];r=r[0];
            }
            return ns._toFF(r) + ns._toFF(g) + ns._toFF(b);
        },
        // Converts a hex string to rgb
        hex2rgb: function(hex) {
            var ns=this;
            if(!hex)hex="FFFFFF";
            if(hex.charAt(0)=='#')hex=hex.slice(1);
            return [ns._to255(hex.substr(0, 2)), ns._to255(hex.substr(2, 2)), ns._to255(hex.substr(4, 2))];
        },
        getTextColor:function(value){
            value=this.hex2rgb(value);
            value=this.rgb2hsv(value);
            return (value&&value[2])>0.6?'#000000':'#FFFFFF';
        }
    }
});Class('linb.UI.DatePicker', ['linb.UI',"linb.absValue"], {
    Dependency:['linb.Date'],
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                if(!profile.domNode)return;
                var cls = profile.box,
                    p = profile.properties,
                    date=linb.Date,
                    mfirst=date.getTimSpanStart(value,'m');
                cls._to(profile,mfirst,value);
                if(profile.keys.CAPTION)
                    profile.getSubNode('CAPTION').html(date.getText(value,'ymd',p.WEEK_FIRST),false);
            });
        },
        getDateFrom:function(){
            return this.get(0)._realstart;
        }
    },
    Initialize:function(){
        var self=this,
            e=linb.Event.$EVENTHANDLER,
            id=linb.UI.$ID,
            cls=linb.UI.$CLS,
            cls2=cls+'-td-free',
            key=self.KEY;
            
        self.addTemplateKeys(['H', 'W','TBODY', 'TD']);
        var colgroup = '<colgroup><col width="2%"/><col width="14%"/><col width="14%"/><col width="14%"/><col width="14%"/><col width="14%"/><col width="14%"/><col width="14%"/></colgroup>',
            thead1='<thead><tr height="1%"><th id="'+key+'-H:'+id+':7" class="'+cls+'-h #H_CC#"></th>',
            thead2='</tr></thead>',
            th='<th id="'+key+'-H:'+id+':@" class="'+cls+'-h #H_CC#">@</th>',
            tbody1 = '<tbody id="'+key+'-TBODY:'+id +':" >',
            tbody2 = '</tbody>',
            tr1='<tr>',
            tr2='</tr>',
            td1='<th id="'+key+'-W:'+id+':@"  class="'+cls+'-w #W_CC#">@</th>',
            td2='<td id="'+key+'-TD:'+id+':@" class="'+cls+'-td ! #TD_CC#"  unselectable="on" onmouseover="'+e+'" onmouseout="'+e+'" onclick="'+e+'" >'+
                '</td>',
            body,i,j,k,l,a=[],b=[];
        for(i=0;i<7;i++)
            b[b.length]= th.replace(/@/g,i);

        k=l=0;
        for(i=0;i<48;i++){
            j=i%8;
            a[a.length]= (j==0?tr1:'') + (j==0?td1:td2).replace(/@/g,j==0?l:k).replace('!',(j==1||j==7)?cls2:'') + (j==7?tr2:'');
            if(j!==0)k++;
            else l++;
        }

        body=colgroup+thead1+b.join('')+thead2+tbody1+a.join('')+tbody2;

        self.setTemplate({
            tagName : 'div',
            style:'{_style}',
            onselectstart:'return false',
            BORDER:{
                tagName : 'div',
                BAR:{
                    tagName:'div',
                    className:'uibar-bar',
                    style:'{barDisplay};height:22px;',
                    BART:{
                        cellpadding:"0",
                        cellspacing:"0",
                        width:'100%',
                        height:'100%',
                        border:'0',
                        tagName:'table',
                        className:'uibar-t',
                        BARTR:{
                            tagName:'tr',
                            BARTDL:{
                                tagName:'td',
                                className:'uibar-tdl'
                            },
                            BARTDM:{
                                $order:1,
                                width:'100%',
                                tagName:'td',
                                className:'uibar-tdm'
                            },
                            BARTDR:{
                                $order:2,
                                tagName:'td',
                                className:'uibar-tdr'
                            }
                        }
                    },
                    BARCMDL:{
                        tagName:'div',
                        className:'uibar-cmdl',
                        PRE2:{$order:0},
                        PRE:{$order:1},
                        YEAR:{$order:2,unselectable:'on',
                            className:'ui-dragable'},
//                        YTXT:{$order:3,style:'display:inline'},
                        MONTH:{$order:4,unselectable:'on',
                            className:'ui-dragable'},
                        MTXT:{$order:5,style:'display:inline'},
                        NEXT:{$order:6},
                        NEXT2:{$order:7}
                    },
                    BARCMDR:{
                        tagName: 'div',
                        className:'uibar-cmdr',
                        onselectstart:'return false',
                        unselectable:'on',
                        CLOSE:{
                            className:'uicmd-close ',
                            style:'{closeDisplay}'
                        }
                    }
                },
                CON:{
                    $order:2,
                    tagName:'div',
                    className:'ui-content',
                    BODY:{
                        $order:1,
                        tagName:'table',
                        cellpadding:"0",
                        cellspacing:"0",
                        width:'100%',
                        text:body
                    },
                    TAIL:{
                        $order:2,
                        tagName:'div',
                        CAPTION:{
                            text : '{caption}',
                            $order:1
                        },
                        TODAY:{
                            tagName:'button',
                            className:'ui-btn',
                            text:linb.wrapRes('inline.today')
                        }
                    }
                }
            }
        });
    },
    Static:{
        Appearances:{
            KEY:{
                overflow:'visible',
                '-moz-user-select': 'none'
            },
            BORDER:{
                overflow: 'visible',
                position: 'relative'
            },
            BODY:{
                position:'relative'
            },
            BARCMDL:{
                top:'1px',
                width:'150px'
            },
            TAIL:{
                height:'20px',
                'padding-top':'3px',
                position:'relative',
                'white-space':'nowrap',
                'text-align':'center',
                'border-right': 'solid 1px #C1C1C1'
            },
            TODAY:{
                position:'absolute',
                top:'2px',
                right:'2px'
            },
            'PRE,PRE2,NEXT,NEXT2':{
                $order:0,
                position:'relative',
                margin:'0 2px 0 2px',
                width:'15px',
                height:'15px',
                'vertical-align': 'middle',
                cursor:'default'
            },
            PRE:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  0 -65px', true)
            },
            'PRE-mouseover':{
                $order:2,
                'background-position': '0 -80px'
            },
            'PRE-mousedown':{
                $order:3,
                'background-position': '0 -95px'
            },
            PRE2:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -61px -65px', true)
            },
            'PRE2-mouseover':{
                $order:2,
                'background-position': '-61px -80px'
            },
            'PRE2-mousedown':{
                $order:3,
                'background-position': '-61px -95px'
            },
            NEXT:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -16px -65px', true)
            },
            'NEXT-mouseover':{
                $order:2,
                'background-position': '-16px -80px'
            },
            'NEXT-mousedown':{
                $order:3,
                'background-position': '-16px -95px'
            },
            NEXT2:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -76px -65px', true)
            },
            'NEXT2-mouseover':{
                $order:2,
                'background-position': '-76px -80px'
            },
            'NEXT2-mousedown':{
                $order:3,
                'background-position': '-76px -95px'
            },
            'YEAR,MONTH':{
                $order:4,
                margin:'2px',
                height:'15px',
                'font-weight':'bold',
                border:'1px solid #7F9DB9',
                'background-color':'#FFFACD',
                'padding-left':'2px',
                cursor:'e-resize'
            },
            YEAR:{
                width:'32px'
            },
            MONTH:{
                width:'16px'
            },
            CAPTION:{
            },
            CON:{
                border: 'solid 1px #C1C1C1',
                'border-right':0,
                'margin-top':'-1px'
            },
            BODY:{
                overflow: 'visible'
            },
            'BODY td,BODY th':{
                $order:1,
                border:0,
                'border-right':'solid 1px #C1C1C1',
                'border-bottom':'solid 1px #C1C1C1'
            },
            'TD .exday':{
                color:'#C1C1C1'
            },
            TD:{
                'text-align':'center'
            },
            'TD-free':{
                $order:1,
                'text-align':'center',
                'background-color': '#FFFACD'
            },
            'TD-mouseover':{
                $order:3,
                'background-color': '#d9e8fb'
            },
            'TD-checked':{
                $order:4,
                'background-color':'#316AC5',
                'font-weight':'bold',
                color:'#fff'
            },
            'W,H':{
                $order:3,
                'color':'#333333',
                'background-color':'#E8EEF7',
                'vertical-align':'middle',
                'text-align':'center'
            }
        },
        Behaviors:{
            HoverEffected:{CLOSE:'CLOSE',TD:'TD',PRE:'PRE',PRE2:'PRE2',NEXT:'NEXT',NEXT2:'NEXT2'},
            ClickEffected:{CLOSE:'CLOSE',TD:'TD',PRE:'PRE',PRE2:'PRE2',NEXT:'NEXT',NEXT2:'NEXT2'},
            KEY:{onClick:function(){return false}},
            TD:{
                onClick:function(profile, e, src){
                    var p=profile.properties,
                        id=profile.getSubId(src.id),
                        map=profile.$daymap,
                        v=map[id];
                    if(p.disabled)return false;

                    linb([src]).onMouseout(true,{$force:true});
                    //onClick event
                    profile.boxing().setUIValue(v);
                }
            },
            TODAY:{
                onClick:function(profile){
                    profile.boxing().setUIValue(new Date,true);
                }
            },
            CLOSE:{
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        instance = profile.boxing();
                    if(properties.disabled)return;
                    if(false===instance.beforeClose(profile, src)) return;
                    instance.destroy();
                    //for design mode in firefox
                    return false;
                }
            },
            PRE:{
                onClick:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    profile.box._to(profile, linb.Date.add(profile.$mfirst,'m',-1,p.WEEK_FIRST));
                }
            },
            NEXT:{
                onClick:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    profile.box._to(profile, linb.Date.add(profile.$mfirst,'m',1,p.WEEK_FIRST));
                }
            },
            PRE2:{
                onClick:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    profile.box._to(profile, linb.Date.add(profile.$mfirst,'y',-1,p.WEEK_FIRST));
                }
            },
            NEXT2:{
                onClick:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    profile.box._to(profile, linb.Date.add(profile.$mfirst,'y',1,p.WEEK_FIRST));
                }
            },
            YEAR:{
                onMousedown:function(profile, e, src){
                    linb(src).startDrag(e, {
                        dragType:'blank',
                        targetReposition:false,
                        widthIncrement:20,
                        dragCursor:true
                    });
                    profile.$temp=profile.$temp2=0;
                },
                onDrag:function(profile, e, src){
                    var count,off = linb.DragDrop.getProfile().offset;
                    count=parseInt(profile.$year)+(profile.$temp2=parseInt(off.x/20));
                    if(profile.$temp!=count){
                        profile.$temp=count;
                        profile.getSubNode('YEAR').html(count,false);
                    }
                },
                onDragstop:function(profile, e, src){
                    if(profile.$temp2){
                        var p=profile.properties,
                            v = linb.Date.add(profile.$mfirst,'y',profile.$temp2,p.WEEK_FIRST);
                        profile.box._to(profile,linb.Date.getTimSpanStart(v,'m'));
                    }
                    profile.$temp=profile.$temp2=0;
                }
            },
            MONTH:{
                onMousedown:function(profile, e, src){
                    linb(src).startDrag(e, {
                        dragType:'blank',
                        targetReposition:false,
                        widthIncrement:20,
                        dragCursor:true
                    });
                    profile.$temp=profile.$temp2=0;
                },
                onDrag:function(profile, e, src){
                    var count,off = linb.DragDrop.getProfile().offset;
                    count=parseInt(profile.$month)+(parseInt(off.x/20)%12);
                    count=(count%12+12)%12;
                    if(profile.$temp!=count){
                        profile.$temp=count;
                        profile.$temp2=count-profile.$month+1;
                        profile.getSubNode('MONTH').html(count+1,false);
                    }
                },
                onDragstop:function(profile, e, src){
                    if(profile.$temp2){
                        var p=profile.properties,
                            v = linb.Date.add(profile.$mfirst,'m',profile.$temp2,p.WEEK_FIRST);
                        profile.box._to(profile,linb.Date.getTimSpanStart(v,'m'));
                    }
                    profile.$temp=profile.$temp2=0;
                }
            }
        },
        DataModel:{
            height:152,
            width:200,
            value:new Date,
            closeBtn:{
                ini:true,
                action:function(v){
                    this.getSubNode('CLOSE').css('display',v?'':'none');
                }
            },
            $borderW:1
        },
        EventHandlers:{
            beforeClose:function(profile, src){}
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile);
            var nodisplay='display:none';
            data.closeDisplay = data.closeBtn?'':nodisplay;
            return data;
        },
        RenderTrigger:function(){
            var self=this, p=self.properties, o=self.boxing(), b=self.box;
            b._setWeekLabel(self);
//            self.getSubNode('YTXT').html(linb.wrapRes('date.Y'),false);
//            self.getSubNode('MTXT').html(linb.wrapRes('date.M'),false);
        },
        _getWeekNodes:function(profile){
            return profile.$week || (profile.$week=profile.getSubNode('W',true));
        },
        _getTDNodes:function(profile){
            return profile.$tds || (profile.$tds=profile.getSubNode('TD',true));
        },
        _getLabelNodes:function(profile){
            return profile.$day || (profile.$day=profile.getSubNode('TD',true));
        },
        _getHeaderNodes:function(profile){
            return profile.$header || (profile.$header=profile.getSubNode('H',true));
        },
        _setWeekLabel:function(profile){
            var o=linb.Date,f=profile.getSubId;
            profile.box._getHeaderNodes(profile).each(function(node,i){
                node.innerHTML=linb.wrapRes('date.WEEKS.'+f(node.id))
            });
        },
        _setBGV:function(profile, v, m){
            var date=linb.Date,
                p=profile.properties,
                daymap=profile.$daymap||(profile.$daymap=[]),
                t,n,
                fd=p.WEEK_FIRST;
            profile.box._getLabelNodes(profile).each(function(node,i){
                n=date.add(v,'d',i,fd);
                daymap[i]=n;
                t=date.get(n,'m',fd)==m?'#':'<p class="exday">#</p>';
                n=date.get(n,'d',fd);
                node.innerHTML = t.replace('#',n);
            });
            profile.box._getWeekNodes(profile).each(function(node,i){
                node.innerHTML=date.get(date.add(v,'ww',i,fd),'ww',fd);
            });
        },
        _to:function(profile, mfirst, value){
            var p = profile.properties,
                fd=p.WEEK_FIRST,
                date=linb.Date,
                keys=profile.keys,
                uiv=value||p.$UIvalue,
                md=date.get(uiv,'m',fd)+'-'+date.get(uiv,'d',fd),
                ym1=date.get(uiv,'y',fd)+'-'+date.get(uiv,'m',fd),
                ym2=date.get(mfirst,'y',fd)+'-'+date.get(mfirst,'m',fd),
                index=-1,
                node,
                temp,
                _realstart = date.getTimSpanStart(date.getTimSpanStart(mfirst,'m'),'ww',1,fd),
                m=date.get(mfirst,'m',fd);

            profile.$mfirst=mfirst;
            this._setBGV(profile, profile._realstart=_realstart, m);


            //remove checked css class
            if(profile.$selnode)
                profile.$selnode.tagClass('-checked',false);
            if(ym1==ym2){
                _.arr.each(profile.$daymap,function(o,i){
                    if(date.get(o,'m',fd)+'-'+date.get(o,'d',fd)==md){
                        index=i;
                        return false;
                    }
                });
                node=this._getTDNodes(profile).get()[index];
                (profile.$selnode=linb([node]).tagClass('-checked'));
            }

            if(keys.YEAR){
                temp=date.get(mfirst,'y',fd);
                if(profile.$year!=temp){
                    profile.$year=temp;
                    profile.getSubNode('YEAR').html(temp,false);
                }
            }
            if(keys.MONTH){
                temp=date.get(mfirst,'m',fd)+1;
                if(profile.$month!=temp){
                    profile.$month=temp;
                    profile.getSubNode('MONTH').html(temp,false);
                }
            }
        }
    }
});Class('linb.UI.TimePicker', ['linb.UI',"linb.absValue"], {
    Dependency:['linb.Date'],
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                if(!profile.domNode)return;

                var instance = profile.boxing(),
                    cls = profile.box,
                    p = profile.properties,
                    uiv = p.$UIvalue,
                    arr1=cls._v2a(uiv),
                    arr2=cls._v2a(value);
                profile.$hour=arr2[0];
                if(arr1[1])
                    cls._uncheck(profile.getSubNode('MI',arr1[1]).get(0));
                cls._check(profile.getSubNode('MI',arr2[1]).get(0));

                profile.getSubNode('HOUR').html(arr2[0],false);
                profile.getSubNode('CAPTION').html(profile.box._showV(profile,profile.box._v2a(arr2)),false);
            });
        }
    },
    Initialize:function(){
        this.addTemplateKeys(['MI']);

        var a=[],
            cls=this._excls,
            cls2=this._excls2,
            id=linb.UI.$ID,
            e=linb.Event.$EVENTHANDLER,
            t='<span id="'+this.KEY+'-MI:'+id+':@" class="'+cls+' !" onmouseover="'+e+'" onmouseout="'+e+'" onclick="'+e+'"   unselectable="on" >@</span>',
            i,m;

        for(i=0;i<60;i++)
            a[a.length]=t.replace(/@/g,i<10?'0'+i:i).replace('!',(i%5===0)?cls2:'');
        m=a.join('');
        a.length=0;

        this.setTemplate({
            tagName : 'div',
            onselectstart:'return false',
            style:'{_style}',
            BORDER:{
                tagName : 'div',
                BAR:{
                    tagName:'div',
                    className:'uibar-bar',
                    style:'{barDisplay};height:22px;',
                    BART:{
                        cellpadding:"0",
                        cellspacing:"0",
                        width:'100%',
                        height:'100%',
                        border:'0',
                        tagName:'table',
                        className:'uibar-t',
                        BARTR:{
                            tagName:'tr',
                            BARTDL:{
                                tagName:'td',
                                className:'uibar-tdl'
                            },
                            BARTDM:{
                                $order:1,
                                width:'100%',
                                tagName:'td',
                                className:'uibar-tdm'
                            },
                            BARTDR:{
                                $order:2,
                                tagName:'td',
                                className:'uibar-tdr'
                            }
                        }
                    },
                    BARCMDL:{
                        tagName: 'div',
                        className:'uibar-cmdl',
                        PRE:{$order:0},
                        HOUR:{
                            $order:1,
                            unselectable:'on',
                            className:'ui-dragable'
                        },
//                        HOURTXT:{$order:2,style:'display:inline'},
                        NEXT:{$order:3}
                    },
                    BARCMDR:{
                        tagName: 'div',
                        className:'uibar-cmdr',
                        onselectstart:'return false',
                        unselectable:'on',
                        CLOSE:{
                            className:'uicmd-close ',
                            style:'{closeDisplay}'
                        }
                    }
                },
                M:{
                    $order:1,
                    className:'ui-content',
                    tagName:'div',
                    text:m
                },
                TAIL:{
                    $order:2,
                    tagName:'div',
                    className:'ui-content',
                    CAPTION:{
                        text : '{caption}'
                    },
                    OK:{
                        tagName:'button',
                        className:'ui-btn',
                        text:linb.wrapRes('inline.ok')
                    }
                }
            }
        });
    },
    Static:{
        _excls:'linbex-timepicker',
        _excls2:'linbex-timepicker2',
        _excls_mo:'linbex-timepicker-mouseover',
        _excls_c:'linbex-timepicker-checked',
        _mover:function(src){
            var b=this,cn=src.className;
            if(cn.indexOf(b._excls_mo)==-1)
                src.className=cn + ' ' + b._excls_mo;
        },
        _mout:function(src){
            var b=this,cn=src.className;
            if(cn.indexOf(b._excls_mo)!=-1)
                src.className=cn.replace(b._excls_mo,'');
        },
        _check:function(src){
            var b=this,cn=src.className;
            if(cn.indexOf(b._excls_c)==-1)
                src.className=cn + ' ' + b._excls_c;
            b._mout(src);
        },
        _uncheck:function(src){
            var b=this,cn=src.className;
            if(cn.indexOf(b._excls_c)!=-1)
                src.className=cn.replace(b._excls_c,'');
        },
        Appearances:{
            KEY:{
                '-moz-user-select': 'none'
            },
            BAR:{
                position:'relative'
            },
            BART:{
                background: linb.UI.$bg('barvbg.gif', ' repeat-x left top', true),
                border: 'solid #C1C1C1',
                'border-collapse':'separate',
               'border-width': '0 1px 0 1px'
            },
            BARCMDL:{
                top:'1px'
            },
            PRE:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  0 -65px', true)
            },
            'PRE-mouseover':{
                $order:2,
                'background-position': '0 -80px'
            },
            'PRE-mousedown':{
                $order:3,
                'background-position': '0 -95px'
            },
            NEXT:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -16px -65px', true)
            },
            'NEXT-mouseover':{
                $order:2,
                'background-position': '-16px -80px'
            },
            'NEXT-mousedown':{
                $order:3,
                'background-position': '-16px -95px'
            },
            HOUR:{
                $order:3,
                margin:'2px',
                height:'15px',
                width:'16px',
                'font-weight':'bold',
                border:'1px solid #7F9DB9',
                'background-color':'#FFFACD',
                cursor:'e-resize',
                'padding-left':'2px'
            },
            'PRE, NEXT':{
                $order:0,
                position:'relative',
                margin:'2px',
                width:'15px',
                height:'15px',
                'vertical-align': 'middle',
                cursor:'default'
            },
            M: {
                position:'relative',
                'border-left':'1px solid #91A7B4',
                'border-top':'1px solid #91A7B4',
                width:'220px',
                'margin-top':'-1px'
            },
            OK:{
                position:'absolute',
                top:'2px',
                right:'2px'
            },
            TAIL:{
                height:'20px',
                'padding-top':'3px',
                position:'relative',
                'white-space':'nowrap',
                'text-align':'center',
                border: 'solid #C1C1C1',
                'border-width': '0 1px 1px 1px'
            },
            '.linbex-timepicker2':{
                'background-color':'#FFFACD'
            },
            '.linbex-timepicker':{
                'font-size':"12px",
                'padding-left':'3px',
                width:'18px',
                height:'16px',
                'border-right':'1px solid #91A7B4',
                'border-bottom':'1px solid #91A7B4'
            },
            '.linbex-timepicker-mouseover':{
                $order:1,
                'background-color': '#d9e8fb'
            },
            '.linbex-timepicker-checked':{
                $order:2,
                'background-color':'#316AC5',
                color:'#fff'
            }
        },
        Behaviors:{
            HoverEffected:{CLOSE:'CLOSE',PRE:'PRE',NEXT:'NEXT'},
            ClickEffected:{CLOSE:'CLOSE',PRE:'PRE',NEXT:'NEXT'},
            KEY:{onClick:function(){return false}},
            HOUR:{
                onMousedown:function(profile, e, src){
                    linb(src).startDrag(e, {
                        dragType:'blank',
                        targetReposition:false,
                        widthIncrement:5,
                        dragCursor:true
                    });
                    profile.$temp2=0;
                },
                onDrag:function(profile, e, src){
                    var count,off = linb.DragDrop.getProfile().offset,v=profile.properties.$UIvalue,a=v.split(':');
                    a[0]=(parseFloat(a[0])||0)+parseInt(off.x/10);
                    a[0]=(a[0]%24+24)%24;
                    profile.$temp2=(a[0]<=9?'0':'')+a[0];

                    if(v[0]!=profile.$temp2)
                        profile.getSubNode('HOUR').html(profile.$temp2,false);
                },
                onDragstop:function(profile, e, src){
                    if(profile.$temp2)
                        profile.$hour=profile.$temp2;
                    profile.$temp2=0;
                }
            },
            OK:{
                onClick:function(profile){
                    var pro=profile.properties,
                        v=pro.$UIvalue,
                        a=v.split(':');
                    a[0]=profile.$hour;
                    profile.boxing().setUIValue(a.join(':'),true);

                    if(pro.closeBtn)
                        profile.getSubNode('CLOSE').onClick();
                }
            },
            MI:{
                onMouseover:function(profile, e, src){
                    profile.box._mover(src);
                },
                onMouseout:function(profile, e, src){
                    profile.box._mout(src);
                },
                onClick:function(profile, e, src){
                    var a=[];
                    a[0]=profile.$hour;
                    a[1]=profile.getSubId(src.id);
                    profile.boxing().setUIValue(a.join(':'),true);
                }
            },
            PRE:{
                onClick:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    var v=profile.$hour;
                    v=(parseFloat(v)||0)-1;
                    v=(v%24+24)%24;
                    profile.$hour=v=(v<=9?'0':'')+v;
                    profile.getSubNode('HOUR').html(v,false);
                }
            },
            NEXT:{
                onClick:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    var v=profile.$hour;
                    v=(parseFloat(v)||0)+1;
                    v=(v%24+24)%24;
                    profile.$hour=v=(v<=9?'0':'')+v;
                    profile.getSubNode('HOUR').html(v,false);
                }
            },
            CLOSE:{
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        instance = profile.boxing();
                    if(properties.disabled)return;
                    if(false===instance.beforeClose(profile, src)) return;
                    instance.destroy();
                    //for design mode in firefox
                    return false;
                }
            }
        },
        DataModel:{
            width:221,
            value:'00:00',
            closeBtn:{
                ini:true,
                action:function(v){
                    this.getSubNode('CLOSE').css('display',v?'':'none');
                }
            }
        },
        EventHandlers:{
            beforeClose:function(profile, src){}
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile);
            var nodisplay='display:none';
            data.closeDisplay = data.closeBtn?'':nodisplay;
            return data;
        },
//        RenderTrigger:function(){
//            this.getSubNode('HOURTXT').html(linb.wrapRes('date.H'),false);
//        },
        _ensureValue:function(profile, value){
            var a,b=[];
            if(value&& typeof value == 'string')
                a=value.split(':')
            else if(value && typeof value=='object' && value.constructor==Array)
                a=value;
            else a=[];

            b[0]= parseFloat(a[0])||0;
            b[1]=parseFloat(a[1])||0;
            if(b[0]<0)b[0]=0;
            if(b[0]>23)b[0]=23;
            if(b[1]<0)b[1]=0;
            if(b[1]>59)b[1]=59;

            b[0]=(b[0]<=9?'0':'')+b[0];
            b[1]=(b[1]<=9?'0':'')+b[1];

            return b.join(':');
        },
        formatValue:function(value){
            return value.join(':');
        },        
        _v2a:function(v){
            return typeof v == 'string'? v.split(':') : v;
        },
        _showV:function(profile, a){
            var f=profile.CF;
            if(typeof f.formatCaption == 'function')
                return f.formatCaption(a);
            else
                return a.join(':');
        }
    }
});/*
*to do: background div
*to do: special div
*/

Class('linb.UI.TimeLine', ['linb.UI','linb.absList',"linb.absValue"], {
    Dependency:['linb.Date'],
    Instance:{
        _setCtrlValue:function(value){
            if(!value)return;
            if(value.indexOf(':')==-1)return;
            var profile=this.get(0),
                p=profile.properties,
                box=this.constructor,
                a=value.split(':'),
                from=new Date(parseInt(a[0])),
                to=new Date(parseInt(a[1])),
                pxStart=box._getX(profile,from),
                pxEnd=box._getX(profile,to),
                task;
            if(p.items.length===0)
                this.insertItems([{id:'$', caption:p.dftTaskName, from:from, to:to}],null,true);
            else
                box._resetItem(profile,{left:pxStart,width:pxEnd-pxStart},profile.getSubNodeByItemId('ITEM',p.items[0].id).get(0));
        },
        visibleTask:function(){
            var profile=this.get(0),
                p=profile.properties,
                date=linb.Date,
                items=p.items;
            if(items.length && !p.multiTasks){
                target=new Date(items[0].from);
                if(target<p.dateStart || target>date.add(p.dateStart,'ms',p.width*p._rate)){
                    p.dateStart=target;
                    var k=p.$UIvalue;
                    this.refresh().setUIValue(k);
                }
            }
            return this;
        },
        _afterInsertItems:function(profile){
           profile.box._reArrage(profile);
        },
        _afterRemoveItems:function(profile){
            profile.box._reArrage(profile);
        },
        _cache:function(){
            var profile=this.get(0),
                cls=this.constructor,
                picker=cls._picker;
            if(picker && picker.domNode)
                profile.getSubNode('POOL').append(picker.root.css('display','none'));
        },
        getTimeRange:function(){
            var profile=this.get(0), p=profile.properties;
            return [p._smallLabelStart, p._smallLabelEnd];
        },
        iniContent:function(){
            return this.each(function(profile){
                var p=profile.properties;
                profile.boxing()._getContent(p._smallLabelStart,p._smallLabelEnd,p._rate,'ini');
            });
        },

        addTasks:function(arr){
            return this.insertItems(arr,null,true);
        },
        removeTasks:function(ids){
            this.removeItems(ids);
            return this;
        },
        _getContent:function(from,to,rate,type){
            return this.each(function(profile){
                if(profile.onGetContent){
                    var p=profile.properties,
                        ins=profile.boxing(),
                        callback=function(arr){
                            profile.boxing().addTasks(arr);
                        };
                    linb.Thread(null,[
                        function(threadId){
                            var r = ins.onGetContent(profile, from, to, rate, type, callback, threadId);
                            if(r) callback(r);
                        }
                        ],null,null,
                        function(threadId){ins.busy()},
                        function(){ins.free()}
                    ).start();
                }
            });
        } 
    },
    Static:{
        Templates:{
            tagName:'div',
            style:'{_style}',
            BORDER:{
                tagName:'div',
                style:'height:{_bHeight}px;width:{_bWidth}px;',
                FOCUS:{tagName:'button'},
                POOL:{
                    tagName:'div',
                    style:'position:absolute;left:0;top:0;width:0;height:0;display:none;'
                },
                BAR:{
                    tagName:'div',
                    className:'uibar-bar',
                    style:'{_bardisplay};height:{_barHeight}px;',
                    BART:{
                        cellpadding:"0",
                        cellspacing:"0",
                        width:'100%',
                        height:'100%',
                        border:'0',
                        tagName:'table',
                        className:'uibar-t',
                        BARTR:{
                            tagName:'tr',
                            BARTDL:{
                                tagName:'td',
                                className:'uibar-tdl'
                            },
                            BARTDM:{
                                $order:1,
                                width:'100%',
                                tagName:'td',
                                className:'uibar-tdm'
                            },
                            BARTDR:{
                                $order:2,
                                tagName:'td',
                                className:'uibar-tdr'
                            }
                        }
                    },
                    BARCMDL:{
                        tagName:'div',
                        className:'uibar-cmdl',
                        DATE:{$order:0,style:'{dateDisplay}'},
                        PRE:{$order:2},
                        'ZOOMIN':{$order:3,style:'{zoomDisplay}'},
                        'ZOOMOUT':{$order:4,style:'{zoomDisplay}'},
                        NEXT:{$order:5}
                    },
                    BARCMDR:{
                        tagName: 'div',
                        className:'uibar-cmdr',
                        onselectstart:'return false',
                        unselectable:'on',
                        OPT:{
                            className:'uicmd-opt',
                            style:'{optDisplay}',
                            $order:0
                        },
                        CLOSE:{
                            $order:4,
                            className:'uicmd-close ',
                            style:'{closeDisplay}'
                        }
                    }
                },
                BAND:{
                    $order:2,
                    tagName:'div',
                    style:'left:{_band_left}px;width:{_band_width}px;',
                    BIGLABEL:{
                        tagName:'div',
                        style:'height:{_bigLabelHeight}px;z-index:3;{_showBigLabel}',
                        text:"{_bigMarks}"
                    },
                    SMALLLABEL:{
                        $order:1,
                        tagName:'div',
                        style:'height:{_smallLabelHeight}px;z-index:4;',
                        text:"{_smallMarks}"
                    }
                },
                VIEW:{
                    $order:3,
                        tagName:'div',
                        style:'height:{_viewHeight}px;',
                        ITEMS:{
                            tagName:'div',
                            style:'left:{_band_left}px;width:{_band_width}px;',
                            text:'{items}',
                            ACTIVE:{
                                $order:3,
                                tagName:'div'
                            }
                        },
                        SCROLL:{
                            tagName:'div',
                            SCROLLI:{
                                tagName:'div'
                            }
                        }
                },
                TIPS:{
                    $order:4,
                    style:'z-index:2;{_tipsdisplay};height:{_tipsHeight}px',
                    tagName:'div'
                }
            },
            $dynamic : {
                _bigMarks:{
                    LABELT:{
                        id:null,
                        className:null,
                        tagName:'div',
                        onselectstart:'return false',
                        unselectable:'on',
                        style:'width:{width}px;left:{left}px;',
                        text:'{text}'
                    }
                },
                _smallMarks:{
                    LABELB:{
                        id:null,
                        className:null,
                        tagName:'div',
                        onselectstart:'return false',
                        unselectable:'on',
                        style:'width:{width}px;left:{left}px;',
                        text:'{text}'
                    }
                },
                items:{
                    ITEM:{
                        tagName:'div',
                        className:'{itemClass}',
                        style:'left:{_left}px;width:{_width}px;{_top};{_height};{itemStyle}',
                        MIN:{
                            $order:0,
                            tagName:'div',
                            style:'{_minDisplay}'
                        },
                        NORMAL:{
                            $order:1,
                            tagName:'div',
                            style:'{_normalDisplay};{_height};{_border}{_background}',
                            LEFT:{
                                $order:1,
                                tagName:'div'
                            },
                            HEAD:{
                                $order:2,
                                tagName:'div'
                            },
                            CON:{
                                $order:3,
                                tagName:'div',
                                text:'{caption}'
                            },
                            RIGHT:{
                                $order:4,
                                tagName:'div'
                            }
                        }
                    }
                }
            }
        },
        Behaviors:{
            DropableKeys:['ITEMS'],
            HoverEffected:{PRE:'PRE',NEXT:'NEXT',ZOOMIN:'ZOOMIN',ZOOMOUT:'ZOOMOUT',DATE:'DATE',OPT:'OPT',CLOSE:'CLOSE',MIN:'MIN',NORMAL:'NORMAL'},
            ClickEffected:{PRE:'PRE',NEXT:'NEXT',ZOOMIN:'ZOOMIN',ZOOMOUT:'ZOOMOUT',DATE:'DATE',OPT:'OPT',CLOSE:'CLOSE',MIN:'MIN'},
            onSize:function(profile,e){
                var o = profile.domNode.style,f=parseInt, n=null, w=n, h=n;
                if(e.height)h=f(o.height)||n;
                if(e.width)w=f(o.width)||n;
                if(h)linb.UI.$tryResize(profile, w, h);
            },
            CLOSE:{
                onClick:function(profile, e, src){
                    if(profile.properties.disabled)return;
                    var instance = profile.boxing();

                    if(false===instance.beforeClose(profile, src)) return;

                    instance.destroy();

                    //for design mode in firefox
                    return false;
                }
            },
            OPT:{
                onClick:function(profile, e, src){
                    if(profile.properties.disabled)return;
                    profile.boxing().onShowOptions(profile, e, src);
                }
            },
            onClick:function(profile, e){
                profile.box._focus(profile);
            },
            BAND:{
                onMousedown:function(profile, e, src){
                    if(profile.pauseA||profile.pause)return;
                    var t=profile.properties,
                        r=-t._band_left,
                        date=linb.Date,
                        rate=t._rate,
                        ep=linb.Event.getPos(e),
                        l=t._band_width-r-t.width;
                    ;
                    if(t.minDate && t._smallLabelStart<t.minDate)
                        r-=date.diff(t._smallLabelStart,t.minDate,'ms')/rate;
                    if(t.maxDate && t._smallLabelEnd>t.maxDate)
                        l-=date.diff(t.maxDate,t._smallLabelEnd,'ms')/rate;
                    if(r<0)r=0;
                    if(l<0)l=0;

                    linb([src]).startDrag(e, {
                        targetReposition:false,
                        dragType:'blank',
                        horizontalOnly:true,
                        targetLeft:ep.left,
                        targetTop:ep.top,
                        maxLeftOffset:l,
                        maxRightOffset:r
                     });
                },
                onDragstop:function(profile, e, src){
                    profile.box._rePosition(profile);
                    profile.box._focus(profile);
                },
                onDrag:function(profile, e, src){
                    var ns=profile.box._getMoveNodes(profile),
                        dd=linb.DragDrop.getProfile();
                    ns.left(profile.properties._band_left +  dd.offset.x);
                }
            },
            SCROLL:{
                onScroll:function(profile, e, src){
                    profile.getSubNode('ITEMS').top(-linb([src]).scrollTop() );
                }
            },
            ITEMS:{
                onMouseover:function(profile,e,src){
                    if(linb.DragDrop.getProfile().isWorking)return;
                    profile.$itemspos = linb([src]).offset();
                },
                onMousemove:function(profile,e){
                    if(linb.DragDrop.getProfile().isWorking){
                        //ondrag add here, for performance of 'dont-use-dropable situation'.
                        if(profile.$$ondrag){
                            var d=linb.DragDrop.getProfile();
                            profile.box._moveActive(profile, profile.$active, d.x-profile.$dd_ox, profile.properties._unitPixs);
                        }
                    }else{
                        var t=profile.properties,
                            date=linb.Date,
                            s=t._smallLabelStart,
                            r=t._rate,
                            u=t._timeFormat,
                            p1=linb.Event.getPos(e),
                            p2=profile.$itemspos;
                        if(p2 && t.showTips)
                            profile.box._setTips(profile, date.getText(date.add(s, 'ms', (p1.left-p2.left)*r),u));
                    }
                },
                onMouseout:function(profile,e,src){
                    if(linb.DragDrop.getProfile().isWorking)return;
                    if(profile.properties.showTips)
                        profile.box._setTips(profile, '');
                },
                onMousedown:function(profile, e, src){
                    var pro=profile.properties;
                    if(pro.disabled || pro.readonly)return;
                    if(profile.pauseA||profile.pause)return;
                    if(linb.Event.getSrc(e)!=src)return;

                    var o = profile.getSubNode('ACTIVE'),
                        x = linb.Event.getPos(e).left;
                    o.css({
                        display:'block',
                        width:'0'
                    })
                    .offset({left :x,  top :null});
                    o.startDrag(e, {dragType:'none'});
                },
                onMouseup:function(profile, e, src){
                    profile.box._focus(profile);
                }
            },
            ACTIVE:{
                onDragbegin:function(profile, e, src){
                    profile.$dd_ox = linb.DragDrop.getProfile().x;
                    profile.$dd_oleft = parseInt(src.style.left)||0;
                    linb([src,src.parentNode]).css('cursor','e-resize');
                },
                onDrag:function(profile, e, src){
                    var x=profile.$dd_oleft,
                        ddx=linb.DragDrop.getProfile().x,
                        w,
                        offset;
                    if((offset =ddx-profile.$dd_ox)>=0){
                        w = offset;
                    }else{
                        x = x+offset; w = -offset;
                    }
                    profile.box._moveActive(profile, src, x, w);
                },
                onDragstop:function(profile, e, src){
                    var r = profile.box._deActive(profile);
                    linb([src,src.parentNode]).css('cursor','');

                    var box=profile.box,
                        from=box._getTime(profile, r.left),
                        to=box._getTime(profile, r.left+r.width),
                        p=profile.properties,
                        task,t,
                        b=profile.boxing();

                    if(profile.properties.multiTasks){
                        task={id:_.id(),caption:p.dftTaskName,from:from,to:to};
                        if(profile.beforeNewTasks && false===b.beforeNewTasks(profile, [task])){}else
                            b.addTasks([task]);
                    }else
                        b.setUIValue(from+":"+to);

                    profile.$dd_ox =profile.$dd_oleft=null;
                }
            },
            FOCUS:{
                onFocus:function(profile, e, src){
                    _.resetRun(profile.KEY+':focus',function(){
                        profile.getSubNode('BAR').tagClass('-focus');
                    });
                },
                onBlur:function(profile, e, src){
                    _.resetRun(profile.KEY+':focus',function(){
                        profile.getSubNode('BAR').tagClass('-focus',false);
                    });
                },
                onKeydown:function(profile, e, src){
                    if(profile.pauseA||profile.pause)return;
                    profile.pause=true;

                    // speed
                    var t=profile.properties,
                        date=linb.Date,
                        rate=t._rate,
                        maxOffset = 30,
                        o=profile.box._getMoveNodes(profile),
                        x=o.left(),
                        xx=t._band_left,
                        off=t._scroll_offset
                        ;

                    off = t._scroll_offset = off>maxOffset ? off :off*1.05;

                    switch(linb.Event.getKey(e)[0]){
                        case 'left':
                        case 'up':
                            if(t.minDate && date.add(t.dateStart,'ms',(xx-x-off)*rate)<t.minDate)
                                off=date.diff(t.minDate, t.dateStart,'ms')/rate + (xx-x);
                            if(off<0)off=0;
                            o.left(x + off);
                            break;
                        case 'right':
                        case 'down':
                            if(t.maxDate && date.add(t.dateStart,'ms',(xx-x+off+t.width)*rate)>t.maxDate)
                                off=date.diff(t.dateStart,t.maxDate,'ms')/rate - (xx-x+t.width);
                            if(off<0)off=0;
                            o.left(x - off);
                            break;
                    }

                    if((x + maxOffset > 0) || (x + o.width() - t.width - maxOffset < 0))
                        profile.box._rePosition(profile);
                    profile.pause=false;
                    return false;
                },
                onKeyup:function(profile, e){
                    var p=profile.properties;
                    p._scroll_offset = p._scrollRate;
                    profile.box._rePosition(profile);
                }
            },
            PRE:{
                onClick:function(profile, e){
                    if(profile.pauseA||profile.pause)return;

                    var t=profile.properties,
                        date=linb.Date,
                        rate=t._rate,
                        o=profile.box._getMoveNodes(profile),
                        x1=t._band_left,
                        x2=0;
                    ;
                    if(t.minDate && t._smallLabelStart<t.minDate)
                        x2-=date.diff(t._smallLabelStart,t.minDate,'ms')/rate;

                    profile.pause=true;
                    o.animate({left:[x1,x2]}, null, function(){
                        profile.box._rePosition(profile);
                        profile.pause=false;
                    },200,Math.max(5,(x2-x1)/100),'inoutsine').start();
                }
            },
            NEXT:{
                onClick:function(profile, e){
                    if(profile.pauseA||profile.pause)return;
                    var t=profile.properties,
                        date=linb.Date,
                        rate=t._rate,
                        o=profile.box._getMoveNodes(profile),
                        x1=t._band_left,
                        x2=t.width-t._band_width;
                    ;
                    if(t.maxDate && t._smallLabelEnd>t.maxDate)
                       x2+=date.diff(t.maxDate,t._smallLabelEnd,'ms')/rate;

                    if(x1>x2){
                        profile.pause=true;
                        o.animate({left:[x1,x2]}, null, function(){
                            profile.box._rePosition(profile);
                            profile.pause=false;
                        },200,Math.max(5,(x1-x2)/100),'inoutsine').start();
                    }
                }
            },
            ZOOMIN:{
                onClick:function(profile, e){
                    if(profile.pauseA||profile.pause)return;
                    var p=profile.properties,
                        box=profile.box,
                        z=box.$zoom,
                        index = _.arr.indexOf(z,p._unitParas),
                        o;
                    if(index > 0){
                        profile.pause=true;
                        p.timeSpanKey =  z[index- 1][0];

                        o = profile.getSubNodes(['VIEW','BAND']);
                        o.animate( {opacity:[1,0.2]}, null, function(){
                            profile.box._refresh(profile)._focus(profile);
                            profile.pause=false;
                        },200,5,'insine').start();
                    }
                }
            },
            ZOOMOUT:{
                onClick:function(profile, e){
                    if(profile.pauseA||profile.pause)return;
                    var p=profile.properties,
                        box=profile.box,
                        z=box.$zoom,
                        index = _.arr.indexOf(z,p._unitParas),
                        o;
                    if(index < z.length -1){
                        profile.pause=true;
                        p.timeSpanKey = z[index + 1][0];

                        o = profile.getSubNodes(['VIEW','BAND']);
                        o.animate( {opacity:[1,0.2]}, null, function(){
                            //if multiTasks, setUIValue will be ignored
                            profile.box._refresh(profile)._focus(profile);
                            profile.pause=false;
                        },200,5,'insine').start();
                    }
                }
            },
            DATE:{
                onClick:function(profile, e, src){
                    if(profile.pauseA||profile.pause)return;
                    var cls=profile.box,
                        box=profile.boxing(),
                        from=profile.properties.dateStart,
                        o,node;

                    if(cls._picker && cls._picker.domNode){
                       o=cls._picker.boxing();
                    }else{
                        o=linb.create('DatePicker');
                        cls._picker=o.get(0);
                        o.beforeClose(function(){
                            this.boxing()._cache();
                            return false;
                        })
                        .beforeUIValueSet(function(p, ov, v){
                            var profile=this,
                                obj = profile.getSubNodes(['VIEW','BAND']),
                                box=profile.boxing(),
                                p=profile.properties;
                            p.dateStart=v;
                            //obj.animate( {opacity:[1,0.2]}, null, function(){
                                //if multiTasks, setUIValue will be ignored
                                profile.box._refresh(profile)._focus(profile);
                            //    profile.pause=false;
                            //},200,5,'insine').start()
                            box._cache();
                        });
                    }
                    o.setValue(from,true).host(profile);
                    node=o.reBoxing();
                    node.popToTop(src);

                    //for on blur disappear
                    node.setBlurTrigger(profile.key+" - "+profile.$id, function(){
                        box._cache();
                    });

                    //for esc
                    linb.Event.keyboardHook('esc',0,0,0,function(){
                        box._cache();
                        cls._focus(profile);
                        //unhook
                        linb.Event.keyboardHook('esc');
                    });
                }
            },
            ITEM:{
                onClick:function(profile, e, src){
                    if(profile.onClickTask)
                        profile.boxing().onClickTask(profile, profile.getItemByDom(src), e, src);
                },
                onDragbegin:function(profile, e, src){
                    var t=profile.getItemByDom(src),
                        type=profile.$dd_type,
                        cursor=type?'e-resize':'move',
                        ac=profile.$active;
                    profile.$dd_ox = linb.DragDrop.getProfile().x;
                    profile.$dd_oleft = parseInt(src.style.left);
                    profile.$dd_owidth = parseInt(src.style.width);
                    linb([ac]).css('display','block').cssPos({left :profile.$dd_oleft,  top :null}).width(profile.$dd_owidth-2);
                    linb([ac,ac.parentNode]).css('cursor',cursor);
                },
                onDrag:function(profile, e, src){
                    var x,w,
                        offset =linb.DragDrop.getProfile().x-profile.$dd_ox,
                        ddl=profile.$dd_oleft,
                        ddw=profile.$dd_owidth,
                        type=profile.$dd_type;
                    if(type=="left"){
                        if(offset < ddw){
                            x = ddl + offset;
                            w = ddl + ddw - x;
                        }else{
                            x = ddl + ddw;
                            w = offset - ddw;
                        }
                    }else if(type == "right"){
                        if(-offset < ddw){
                            x = ddl;
                            w = ddw + offset;
                        }else{
                            x = ddl + offset + ddw;
                            w = -offset - ddw;
                        }
                    }else{
                        x = ddl + offset;
                        w = ddw;
                    }
                    profile.box._moveActive(profile, profile.$active, x, w);
                },
                onDragstop:function(profile, e, src){
                    var box=profile.box,
                        r = profile.box._deActive(profile),
                        ac=profile.$active;

                        var from=box._getTime(profile, r.left),
                            to=box._getTime(profile,r.left+r.width);
                    if(profile.properties.multiTasks){
                        if(profile.beforeTaskUpdated && false===profile.boxing().beforeTaskUpdated(profile, profile.getItemByDom(src), from, to)){}else
                            box._resetItem(profile,r,src);
                    }else
                        profile.boxing().setUIValue(from+":"+to);

                    profile.$dd_type = null;

                    linb([ac,ac.parentNode]).css('cursor','');
                }
            },
            HEAD:{
                onMousedown:function(profile, e, src){
                    var ps=profile.properties, item=profile.getItemByDom(src);
                    if(ps.disabled  || item.disabled)return;
                    if(profile.beforeDragTask && false===profile.boxing().beforeDragTask(profile, item, e, src))
                        return;
                    if(ps.readonly||item.readonly)return;
                    linb([src]).parent(2).startDrag(e, {
                        dragDefer:1,
                        dragType:'none'
                    });
                }
            },
            LEFT:{
                onMousedown:function(profile, e, src){
                    var ps=profile.properties, item=profile.getItemByDom(src);
                    if(ps.disabled || ps.readonly || item.readonly || item.disabled)return;
                    profile.$dd_type='left';
                    linb([src]).parent(2).startDrag(e, {
                        dragDefer:1,
                        dragType:'none'
                    });
                }
            },
            RIGHT:{
                onMousedown:function(profile, e, src){
                    var ps=profile.properties, item=profile.getItemByDom(src);
                    if(ps.disabled || ps.readonly || item.readonly || item.disabled)return;
                    profile.$dd_type='right';
                    linb([src]).parent(2).startDrag(e, {
                        dragDefer:1,
                        dragType:'none'
                    });
                }
            }
        },
        DataModel:{
            $borderW : 1,
            readonly:false,
            // control width and height
            width : 400,
            height : 200,
            //invisible band count (left,right)
            //if it's zero, leftSpanCount will be equal to the visible span count(based on widget width)
            leftSpanCount:{
                ini:0,
                inner:1
            },
            rightSpanCount:{
                ini:0,
                inner:1
            },
            increment:0,
            zoomable:{
                ini:true,
                action:function(v){
                    if(this.properties.timeSpanKey)
                        this.getSubNodes(['ZOOMIN','ZOOMOUT']).css('display',v?'':'none');
                }
            },
            dftTaskName:'task',
            taskHeight:{
                ini:16,
                action:function(v){
                    this.getSubNode('ITEM',true).height(v);
                }
            },

            //time span key
            timeSpanKey : {
                ini:'1 d',
                action:function(){
                    this.box._refresh(this);
                }
            },
            // how much px to represent a unit
            // defalut value is from timeSpanKey
            unitPixs : {
                action:function(){
                    this.box._refresh(this);
                }
            },

/*
*inner properties
*defalut value is from timeSpanKey
*/
            //time span count
            smallLabelCount:{
                inner:1
            },
            //time span unit
            smallLabelUnit:{
                inner:1,
                listbox:_.toArr(linb.Date.$TIMEUNIT,true)
            },
            //small label format
            smallLabelFormat:{
                inner:1,
                listbox:_.toArr(linb.Date.$TEXTFORMAT,true)
            },
            bigLabelCount:{
                inner:1
            },
            //time span unit
            bigLabelUnit:{
                inner:1,
                listbox:_.toArr(linb.Date.$TIMEUNIT,true)
            },

            //big label format
            bigLabelFormat:{
                inner:1,
                listbox:_.toArr(linb.Date.$TEXTFORMAT,true)
            },
            //time format
            timeFormat:{
                inner:1,
                listbox:_.toArr(linb.Date.$TEXTFORMAT,true)
            },
/*inner properties*/
            //bar
            showBar:{
                ini:true,
                action:function(v){
                    this.getSubNode('BAR').css('display',v?'':'none');
                    var p=this.properties,w=p.width,h=p.height;
                    p.width=p.height=0;
                    linb.UI.$tryResize(this,w,h);
                    p.width=w,p.height=h;
                }
            },
            //tips
            showTips:{
                ini:true,
                action:function(v){
                    this.getSubNode('TIPS').css('display',v?'':'none');
                    var p=this.properties,w=p.width,h=p.height;
                    p.width=p.height=0;
                    linb.UI.$tryResize(this,w,h);
                    p.width=w,p.height=h;
                }
            },
            //big label
            showBigLabel: {
                ini:true,
                action:function(v){
                    this.getSubNode('BIGLABEL').css('display',v?'':'none');
                    var p=this.properties,w=p.width,h=p.height;
                    p.width=p.height=0;
                    linb.UI.$tryResize(this,w,h);
                    p.width=w,p.height=h;
                }
            },

            _barHeight : 22,
            _tipsHeight : 16,
            _bigLabelHeight : 16,
            _smallLabelHeight : 14,
            _scrollRate:5,

            multiTasks: {
                ini:false,
                action:function(){
                    this.box._refresh(this);
                }
            },

            minDate:{
                ini:null,
                action:function(value){
                    if(value>this.properties.dateStart)
                        this.box._refresh(this);
                }
            },
            maxDate:{
                ini:null,
                action:function(value){
                    var p=this.properties;
                    if(value<linb.Date.add(p.dateStart,'ms',p.width*p._rate))
                        this.box._refresh(this);
                }
            },
            
            dateBtn:{
                ini:true,
                action:function(v){
                    this.getSubNode('DATE').css('display',v?'':'none');
                }
            },
            closeBtn:{
                ini:false,
                action:function(v){
                    this.getSubNode('CLOSE').css('display',v?'':'none');
                }
            },
            optBtn:{
                ini:false,
                action:function(v){
                    this.getSubNode('OPT').css('display',v?'':'none');
                }
            },
 
            fixWidth:true,
            dateStart : {
                ini:new Date,
                action:function(){
                    this.box._refresh(this);
                }
            }
        },
        EventHandlers:{
            beforeClose:function(profile, src){},
            onShowOptions:function(profile, e, src){},
            onGetContent:function(profile, from, to, minMs, type, callback, threadid){},
            beforeTaskUpdated:function(profile, task, from, to){},
            beforeNewTasks:function(profile, tasks){},
            beforeDelTasks:function(profile, arr){},
            beforeDragTask:function(profile, task, e, src){},
            onClickTask:function(profile, task, e, src){}
        },
        Appearances:{
            BORDER:{
                overflow: 'hidden',
                position: 'relative',
                'border-bottom':'solid 1px #C1C1C1'
            },
            'BAR-focus BART':{
                $order:2,
                'background-position' : 'right -22px'
            },
            'BART':{
                border:0
            },
            'BARCMDL span':{
                $order:0,
                position:'relative',
                width:'15px',
                height:'15px',
                'vertical-align': 'middle',
                cursor:'default'
            },
            TIPS:{
                'background-color':'#ECE9D8'
            },
            FOCUS:{
                position:'absolute',
                'font-size':'0',
                width:'1px',
                height:'1px',
                left:'-100px',
                top:'-100px',
                'line-height':'0',
                border:'0'
            },
            'BAND, VIEW, BIGLABEL, SMALLLABEL, TIPS':{
                position:'relative'
            },
            'BAND, VIEW, TIPS':{
                'border-left': 'solid 1px #C1C1C1',
                'border-right': 'solid 1px #C1C1C1'
            },
            VIEW:{
                width:linb.browser.ie6?'100%':null,
                overflow:'hidden'
            },
            SCROLL:{
                'z-index':500,
                position:'absolute',
                'font-size':'0',
                'line-height':'0',
                right:0,
                top:0,
                height:'100%',
                width:'18px',
                overflow:'auto',
                'overflow-x':linb.browser.opr?null:'hidden'
            },
            SCROLLI:{
                height:'1000px',
                width:'1px'
            },
            'BIGLABEL, SMALLLABEL':{
                'background-color':'#ECE9D8',
                cursor:'move'
            },
            'BIGLABEL,SMALLLABEL':{
                'border-bottom':'solid 1px #505050'
            },
            ITEMS:{
                position:'relative',
                background: linb.UI.$bg('bars.gif',' left top')
            },
            'BIGLABEL div, SMALLLABEL div':{
                'border-left':'solid 1px #505050',
                'text-align':'center',
                position:'absolute',
                cursor:'move',
                "-moz-user-select":linb.browser.gek?'none':'',
                top:0,
                overflow:'visible',
                height:'100%'
            },
            'BIGLABEL div':{
                $order:2,
                'text-align':'left',
                'padding-left':'4px'
            },

            ACTIVE:{
                'z-index':300,
                position:'relative',
                'border-left': '1px dashed',
                'border-right': '1px dashed',
                left:'-100px',
                width:'0',
                background:0,
                height:'100%'
            },

            ZOOMIN:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -271px top', true)
            },
            'ZOOMIN-mouseover':{
                $order:2,
                'background-position': '-271px -16px'
            },
            'ZOOMIN-mousedown':{
                $order:3,
                'background-position': '-271px -31px'
            },
            ZOOMOUT:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -256px top', true)
            },
            'ZOOMOUT-mouseover':{
                $order:2,
                'background-position': '-256px -16px'
            },
            'ZOOMOUT-mousedown':{
                $order:3,
                'background-position': '-256px -31px'
            },
            DATE:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -46px -65px', true)
            },
            'DATE-mouseover':{
                $order:2,
                'background-position':' -46px -80px'
            },
            'DATE-mousedown':{
                $order:3,
                'background-position':' -46px -95px'
            },
            MIN:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -31px -65px', true)
            },
            PRE:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat  0 -65px', true),
                top:'0'
            },
            'PRE-mouseover':{
                $order:2,
                'background-position': '0 -80px'
            },
            'PRE-mousedown':{
                $order:3,
                'background-position': '0 -95px'
            },
            NEXT:{
                position:'absolute',
                background: linb.UI.$bg('cmds.gif', ' no-repeat  -16px -65px', true),
                top:'0'
            },
            'NEXT-mouseover':{
                $order:2,
                'background-position': '-16px -80px'
            },
            'NEXT-mousedown':{
                $order:3,
                'background-position': '-16px -95px'
            },
            ITEM:{
                position:'absolute',
                overflow:'visible'
            },
            'MIN, NORMAL':{
                //position:'absolute',
                //top:0,
                //left:0,
                position:'relative',
                height:'16px',
                overflow:'hidden',
                'z-index':'1'
            },
            'MIN':{
                width:'16px',
                background: linb.UI.$bg('cmds.gif', ' no-repeat -30px -65px', true),
                cursor:'pointer'
            },
            'MIN-mouseover':{
                'background-position': '-30px -80px'
            },
            'MIN-mousedown':{
                'background-position': '-30px -95px'
            },
            NORMAL:{
                cursor:'pointer',
                'background-color': '#C6D6F7',
                border:'solid 1px #203A83'
            },
            'NORMAL-mouseover':{
                $order:2,
                'border-color': 'red'
            },
            'LEFT, HEAD, RIGHT':{
                position:'absolute',
                top:0,
                height:'100%'
            },
            HEAD:{
                background: linb.UI.$bg('handler.gif', ' left top', true),
                width:'6px',
                left:'3px',
                cursor:'move',
                'z-index':5
            },
            'LEFT, RIGHT':{
                width:'2px',
                'z-index':10
            },
            'LEFT':{
                cursor:'e-resize',
                left:0
            },
            'RIGHT':{
                cursor:'w-resize',
                right:0
            },
            CON:{
                'padding-left':'12px',
                position:'relative',
                height:'100%',
                overflow:'hidden'
            }
        },
        RenderTrigger:function(){
            var self=this, p=self.properties,cls=self.box;
            self.$active = self.getSubNode('ACTIVE').get(0);
            cls._ajustHeight(self);
            self.boxing().iniContent();
        },
        _onDropMarkShow:function(){linb.DragDrop.setDragIcon('add');return false},
        _onDropMarkClear:function(){linb.DragDrop.setDragIcon();return false},
        _onDragEnter:function(profile,e,src){
            var t=profile.properties,
                ep=linb.Event.getPos(e),
                _left = t._unitPixs/2
            ;
            linb(profile.$active).css('display','block');
            profile.$dd_ox =linb([src]).offset().left+_left;

            profile.$$ondrag=true;
        },
        _onDragLeave:function(profile){
            profile.$$ondrag=profile.$dd_ox=null;

            profile.box._deActive(profile);
        },
        _onDrop:function(profile){
            profile.$$ondrag=profile.$dd_ox=null;

            var r = profile.box._deActive(profile),
                task={id:_.id(),caption:profile.properties.dftTaskName},
                box=profile.box,
                b=profile.boxing();

            task.from = box._getTime(profile, r.left);
            task.to = box._getTime(profile, r.left+r.width);
            task._dropData=linb.DragDrop.getProfile().dragData;

            if(profile.beforeNewTasks && false===b.beforeNewTasks(profile, [task])){}else
                b.addTasks([task]);
        },
        _prepareData:function(profile){
            var p=profile.properties,
                d={},
                date=linb.Date,
                us=date.$TIMEUNIT,
                nodisplay='display:none',
                zoom=profile.box.$zoom,
                m=0,u,
                i,t,label,temp,_date,width,rate,
                _unitParas,
                _dateStart,
                _barCount,_leftBarCount,_rightBarCount,_barCountall,

                smallMarks,smallLabelStart,smallLabelEnd,smallLabelUnit,smallLabelCount,smallLabelFormat
                ;


            d.dateDisplay = p.dateBtn?'':nodisplay;
            d.closeDisplay = p.closeBtn?'':nodisplay;
            d.optDisplay = p.optBtn?'':nodisplay;
            d._showBigLabel=p.showBigLabel?'':nodisplay;

            // for quick move
            p._scroll_offset = p._scrollRate;

            p._lines=[{}];

            //border
            d._bWidth = p.width - 2*p.$borderW;
            d._bHeight = p.height - 2*p.$borderW;
            //view
            p._viewHeight = d._bHeight - (p.showTips&&p._tipsHeight) - (p.showBigLabel?p._bigLabelHeight:0) - p._smallLabelHeight - (p.showBar&&p._barHeight);
            d._tipsdisplay=p.showTips?'':nodisplay;
            d._bardisplay = p.showBar?'':nodisplay;

            //get unitparas from timespan key
            if(p.timeSpanKey){
                _.arr.each(zoom,function(o){
                    if(o[0]===p.timeSpanKey){
                        _unitParas=p._unitParas=o;
                        return false;
                    }
                });
                //give a default key
                if(!_unitParas)
                    _unitParas=p._unitParas=zoom[p.timeSpanKey='1 d'];
            }
            //if no timeSpanKey( _unitParas) input,
            d.zoomDisplay = (p.zoomable && _unitParas)?'':nodisplay

            if(_unitParas){
                p._unitPixs = p.unitPixs||_unitParas[1];
                p._smallLabelCount = p.smallLabelCount||_unitParas[2];
                p._smallLabelUnit = p.smallLabelUnit||_unitParas[3];
                p._smallLabelFormat = p.smallLabelFormat||_unitParas[4];
                p._bigLabelCount = p.bigLabelCount||_unitParas[5];
                p._bigLabelUnit = p.bigLabelUnit||_unitParas[6];
                p._bigLabelFormat = p.bigLabelFormat||_unitParas[7];
                p._timeFormat = p.timeFormat||_unitParas[8];
            }
            u=p._unitPixs;
            smallLabelCount = p._smallLabelCount;
            smallLabelUnit = p._smallLabelUnit;
            smallLabelFormat = p._smallLabelFormat;

            // get bar count in view
            _barCount = (Math.ceil(p.width / u)||0);
            _leftBarCount = p.leftSpanCount?p.leftSpanCount:_barCount;
            _rightBarCount = p.rightSpanCount?p.rightSpanCount:_barCount;
            _barCountall =  _barCount + _leftBarCount + _rightBarCount;

            // ms per px
            rate = p._rate = us[smallLabelUnit]*smallLabelCount/u;

            //adjust dateStart
            if(p.maxDate&& date.add(p.dateStart,'ms',p.width*rate) > p.maxDate)
                p.dateStart=date.add(p.maxDate,'ms',-p.width*rate);
            if(p.minDate&& p.dateStart<p.minDate)
                p.dateStart=p.minDate;

            // get the round start from the approximate start
            _dateStart = date.getTimSpanStart(p.dateStart, smallLabelUnit, smallLabelCount);
            // rel start in band
            smallLabelStart=p._smallLabelStart = date.add(_dateStart, smallLabelUnit, -_leftBarCount*smallLabelCount);
            // rel to in band
            smallLabelEnd = p._smallLabelEnd = date.add(smallLabelStart, smallLabelUnit, _barCountall*smallLabelCount);

            // get band with
            p._band_width = Math.ceil(date.diff(smallLabelStart,smallLabelEnd, 'ms')/rate);

            // set band left
            p._band_left_fix = p._band_left = - Math.ceil(date.diff(smallLabelStart, p.dateStart, 'ms')/rate);

            // build bars
            smallMarks = p._smallMarks = [];

            temp=0;
            label=date.get(smallLabelStart, smallLabelFormat);
            for(i=0; i< _barCountall; i++){
                _date = date.add(smallLabelStart, smallLabelUnit, smallLabelCount*(i+1));
                width = Math.ceil(date.diff(smallLabelStart, _date, 'ms')/rate);
                smallMarks.push({
                    left : temp,
                    width : width - temp,
                    text : label
                });
                temp=width;
                label=date.getText(_date, smallLabelFormat);
            }


            if(p.showBigLabel){
                var _barCount2,off,
                    bigMarks,bigLabelStart,bigLabelEnd,

                    bigLabelCount = p._bigLabelCount,
                    bigLabelUnit = p._bigLabelUnit,
                    bigLabelFormat = p._bigLabelFormat
                    ;

                bigMarks = p._bigMarks = [];
                bigLabelStart=p._bigLabelStart =date.getTimSpanStart(smallLabelStart, bigLabelUnit, bigLabelCount);
                bigLabelEnd=p._bigLabelEnd = date.getTimSpanEnd(smallLabelEnd, bigLabelUnit, bigLabelCount);
                _barCount2 = date.diff(bigLabelStart, bigLabelEnd, bigLabelUnit)/bigLabelCount;
                off=date.diff(smallLabelStart, bigLabelStart, 'ms')/rate;
                label=date.getText(bigLabelStart, bigLabelFormat);
                temp=0;
                for(i=0; i< _barCount2; i++){
                    _date = date.add(bigLabelStart, bigLabelUnit, bigLabelCount*(i+1));
                    width = date.diff(bigLabelStart, _date, 'ms')/rate;
                    bigMarks.push({
                        left : Math.ceil(temp + off),
                        width : Math.ceil(width - temp),
                        text : label
                    });
                    temp=width;
                    label=date.getText(_date, bigLabelFormat);
                }
            }
            return arguments.callee.upper.call(this, profile, d);
        },
        _prepareItem:function(profile, item, oitem, pid){
            var self=this,
                t=profile.properties,
                index;
            if(!item.id)item.id=_.id();
            if(!item.caption)item.caption=t.dftTaskName;
            item._min=false;
            // caculate left and width
            item._left = self._getX(profile, item.from);
            item._width=Math.max(self._getX(profile, item.to) - item._left, 0);
            if(t.multiTasks){
                if(item._width<=16){
                    item._width=16;
                    item._min=true;
                }
            }
            item._minDisplay=item._min?'':'display:none';
            item._normalDisplay=item._min?'display:none':'';

            // caculate top and set task to lines cache
            index = self._getLinePos(profile, item);
//min region is alway 16 + 3
            item._top = t.multiTasks? 'top:' + (item._min?0:((t.taskHeight+3) * (index-1) + 16 + 3)) + 'px' : '';

            item._height = 'height:' + (t.multiTasks?item._min?'16px':t.taskHeight+'px':'100%');
            item._border = t.multiTasks?'':'border-top:0;border-bottom:0';

            item._background = item.background?'background:'+item.background+';':'';

            t._lines = t._lines || [{}];

            //set double link
            t._lines[index][item.id]=item;
            item._line = index;

            oitem._left=item._left;
            oitem._width=item._width;
            oitem._min=item._min;
            oitem._line=item._line;
        },
        $zoom:[
            /*
            *[
            *  id,
            *  small span unit count,
            *  small span unit,
            *  small span to big span function,
            *  small span lable format,
            *  big span lable format,
            *  value format
            *]
            */
            ['10 ms', 54, 10, 'ms', 'ms', 100, 'ms','hnsms','hnsms'],
            ['100 ms',54,  100, 'ms', 'ms', 1, 's','hns','hnsms'],
            ['1 s',30,  1, 's','s', 10, 's','hns','hnsms'],
            ['10 s', 30, 10, 's', 's',60, 's','hns','hnsms'],
            ['1 n',30,  1, 'n','n', 10, 'n','dhn','hns'],
            ['5 n', 30, 5, 'n','n', 30, 'n','mdhn','hns'],
            ['10 n', 30, 10, 'n','n', 60, 'n','mdhn','hns'],
            ['30 n', 30, 30, 'n','n', 4, 'h','ymdh','mdhn'],
            ['1 h', 30, 1, 'h','h',  6, 'h','ymdh','mdhn'],
            ['2 h', 30, 2, 'h','h', 12, 'h','ymdh','mdhn'],
            ['6 h', 30, 6, 'h','h', 24, 'h','ymd','mdhn'],
            ['1 d', 24, 1, 'd','w', 1, 'ww','ymd','ymdh'],
            ['1 w', 30, 1, 'ww','ww', 4, 'ww','ymd','ymd'],
            ['15 d', 30, 15, 'd','d', 2, 'm','ymd','ymd'],

//Not every unit width is the same value:
            ['1 m',  30,1, 'm','m', 1, 'q','yq','ymd'],
            ['1 q',  30,1, 'q','q', 1, 'y','y','ymd'],
            ['1 y',  48,1, 'y','y', 10, 'y','y','ym'],
            ['1 de',  48, 1, 'de','de', 100, 'y','y','ym'],
            ['1 c',  48, 1, 'c', 'c', 1000, 'y','y','y']

        ],
        _focus:function(profile){
            profile.getSubNode('FOCUS').focus(1);
        },
        _getTips:function(profile){
            var t,s='$dd_tooltip';
            if(t = profile[s] || (profile[s] = profile.getSubNode('TIPS').get(0).childNodes[0]))
                return t.nodeValue;
            else
                return profile.getSubNode('TIPS').get(0).innerHTML;
        },
        _rr:/\<[^>]*\>/g,
        _setTips:function(profile, text, force){
            if(!force && profile.pauseA)return;
            var t,s='$dd_tooltip';
            text=text.replace(this._rr,'');
            if(t = profile[s] || (profile[s] = profile.getSubNode('TIPS').get(0).childNodes[0])){
                if(t.nodeValue!=text)t.nodeValue=text;
            }else
                profile.getSubNode('TIPS').get(0).innerHTML=text;
        },
        _getX:function(profile, time){
            var t=profile.properties,d=new Date;
            d.setTime(time);
            return (Math.ceil(linb.Date.diff(t._smallLabelStart, d, 'ms')||0) / t._rate);
        },
        _getTime:function(profile, x, flag){
            var t=profile.properties;
            t = linb.Date.add(t._smallLabelStart, 'ms', x*t._rate);
            return flag?t:t.getTime();
        },
        _moveActive:function(profile, src, x, w){
            var p=Math.ceil,
                t=profile.properties,
                d=linb.Date,
                s=t._smallLabelStart,
                r=t._rate,
                u=t._timeFormat,
                ms='ms',
                y=src.style,
                z='px',
                m,n,increment;

            if(increment=t.increment){
                m=x;
                x=Math.floor(x/increment)*increment;
                w=Math.floor((w-x+m+increment-1)/increment)*increment;
            }

            m = (p(x)||0);
            n = ((p(w)||0)-2);
            if(n>0){
                y.left= m+z;
                y.width= n+z;
                if(t.showTips)
                    profile.box._setTips(profile, d.getText(d.add(s, ms, x*r),u)
                        + " - "
                        + d.getText(d.add(s, ms, (x+w)*r),u)
                    )
            }
        },
        _deActive:function(profile){
            var t=profile.$active.style, x=parseInt(t.left)||0, w=(parseInt(t.width)||0)+2;
            t.left='-1000px';
            if(profile.properties.showTips)
                profile.box._setTips(profile, '');
            return {left :x, width :w};
        },
        _minusLeft:function(profile,marks,node,offsetCount){
            var t=profile.properties;
            while((offsetCount--)>0){
                node.first().remove();
                temp=marks.shift();
            }
        },
        _minusRight:function(profile,marks,node,offsetCount){
            var t=profile.properties;
            while((offsetCount--)>0){
                node.last().remove();
                temp=marks.pop();
            }
        },
        _addLeft:function(profile, tag, node, offsetCount,  offset){
            // get additional bars
            var t=profile.properties,
                date=linb.Date,
                key=tag+'Marks',
                marks=t[key],
                labelStart=t[tag+'LabelStart'],
                labelUnit=t[tag+'LabelUnit'],
                labelCount=t[tag+'LabelCount'],
                labelFormat=t[tag+'LabelFormat'],
                rate=t._rate,
                addLb=[],
                temp,label,_date,i;

            temp=0;
            label=date.getText(labelStart, labelFormat);
            for(i=0; i< offsetCount; i++){
                _date = date.add(labelStart, labelUnit, labelCount*(i+1));
                width = date.diff(labelStart, _date, 'ms')/rate;
                addLb.push({
                    left : Math.ceil(temp + (offset||0)-0.0000000000003),
                    width : Math.ceil(width - temp),
                    text : label
                });
                temp=width;
                label=date.getText(_date, labelFormat);
            }
            addLb.reverse();
            // add to band UI
            node.prepend(_.str.toDom(profile.buildItems(key, addLb)));
            // add to memory list
            _.arr.insertAny(marks,addLb.reverse(),0);
        },
        _addRight:function(profile, labelEnd, tag, node, offsetCount,  offset){
            var t=profile.properties,
                date=linb.Date,
                key=tag+'Marks',
                marks=t[key],
                labelStart=t[tag+'LabelStart'],
                labelUnit=t[tag+'LabelUnit'],
                labelCount=t[tag+'LabelCount'],
                labelFormat=t[tag+'LabelFormat'],
                rate=t._rate,
                addLb=[],_d1,
                _date,i;
            _d1=labelEnd;
            for(i=0; i<offsetCount; i++){
                _date = date.add(labelEnd, labelUnit, labelCount*(i+1));
                addLb.push({
                    left : Math.ceil(date.diff(labelStart,_d1,'ms')/rate+ (offset||0)-0.0000000000003),
                    width : Math.ceil(date.diff(_d1, _date, 'ms')/rate),
                    text : date.getText(_d1, labelFormat)
                });
                _d1=_date;
            }
            // build
            // add to band UI
            node.append(_.str.toDom(profile.buildItems(key, addLb)));
            // add to memory list
            _.arr.insertAny(marks,addLb,-1);
        },
        _getMoveNodes:function(profile){
            return profile.$moveban = profile.$moveban || profile.getSubNodes(['BAND','ITEMS']);
        },
        //if left is numb, force to move
        _rePosition:function(profile, left){
            profile.pause=true;
            var self=this,
                date = linb.Date,
                t=profile.properties,
                rate=t._rate,
                label,m,n,
                labelsBottom = profile.getSubNode('SMALLLABEL'),
                band = self._getMoveNodes(profile),
                x = left || band.left(),
                //ralated to the fix position
                offset = x - t._band_left_fix;

            // if offset out a bar width
            if(Math.abs(offset)/t._unitPixs >=1 || left){
                var offsetCount = parseInt(offset/t._unitPixs),
                    bak_s = t._smallLabelStart,
                    bak_e = t._smallLabelEnd,
                    _c=-offsetCount*t._smallLabelCount,
                    offsetPxs,
                    _smallLabelStart,
                    _smallLabelEnd;

                _smallLabelStart=t._smallLabelStart = date.add(t._smallLabelStart, t._smallLabelUnit, _c);
                _smallLabelEnd=t._smallLabelEnd = date.add(t._smallLabelEnd, t._smallLabelUnit, _c);
                offsetPxs = Math.ceil(date.diff(_smallLabelStart, bak_s, 'ms')/rate);

                band.left(x - offsetPxs);

                // reset band paras
                t._band_width = Math.ceil(date.diff(_smallLabelStart, _smallLabelEnd, 'ms')/rate);

                //reset tasks position var
                _.arr.each(t.items,function(o){
                    o._left += offsetPxs;
                    profile.box._trimTask(profile,o);
                });
                labelsBottom.children().each(function(o){
                    o.style.left = (parseFloat(o.style.left)||0) + offsetPxs + "px";
                });
                _.arr.each(t._smallMarks,function(o){
                    o.left += offsetPxs;
                });

                // delete out, andd add to blank
                if(offsetCount>0){
                    self._minusRight(profile,t._smallMarks, labelsBottom,offsetCount);
                    self._addLeft(profile, '_small', labelsBottom, offsetCount);
                }else{
                    self._minusLeft(profile,t._smallMarks, labelsBottom, -offsetCount);
                    self._addRight(profile, bak_e, '_small', labelsBottom, -offsetCount);
                }

                if(t.multiTasks){
                    var arr=[];
                    // remove tasks
                    _.arr.each(t.items,function(o){
                        if(o._left >= t._band_width ||  (o._left+o._width) <= 0){
                            //delete from lines
                            delete t._lines[o._line][o.id];
                            arr.push(o.id);
                        }
                    });
                    profile.boxing().removeItems(arr);

                    if(profile.onGetContent)
                        profile.boxing()._getContent(offsetCount>0 ? _smallLabelStart : bak_e,
                            offsetCount>0 ? bak_s : _smallLabelEnd,
                            t._rate,
                            offsetCount>0 ? 'left' : 'right');
                    
                    //adjust the items
                    self._reArrage(profile);
                }

                if(t.showBigLabel){
                    var labelsTop = profile.getSubNode('BIGLABEL'),
                        bigLabelUnit=t._bigLabelUnit,
                        bigLabelCount=t._bigLabelCount,
                        off,
                        offsetCount2,offsetCount3,
                        bigLabelStart,bigLabelEnd;
                    bak_e=t._bigLabelEnd;

                    labelsTop.children().each(function(o){
                        o.style.left = (parseFloat(o.style.left)||0) + offsetPxs + "px";
                    });
                    _.arr.each(t._bigMarks,function(o){
                        o.left += offsetPxs;
                    });
                    bigLabelStart=date.getTimSpanStart(_smallLabelStart, bigLabelUnit, bigLabelCount);

                    offsetCount2 = Math.ceil(date.diff(_smallLabelStart, t._bigLabelStart, bigLabelUnit)/bigLabelCount);
                    offsetCount3 = Math.ceil(date.diff(t._bigLabelEnd, _smallLabelEnd, bigLabelUnit)/bigLabelCount);

                    //reset offset of big and small
                    if(offsetCount2){
                        off = date.diff(_smallLabelStart, bigLabelStart, 'ms')/rate;
                        t._bigLabelStart=bigLabelStart;
                        if(offsetCount2>0)
                            self._addLeft(profile, '_big',labelsTop, offsetCount2, off);
                        else
                            self._minusLeft(profile,t._bigMarks, labelsTop, -offsetCount2);
                    }
                    //reset offset of big and small
                    if(offsetCount3){
                        off = date.diff(_smallLabelStart, bigLabelStart, 'ms')/rate;
                        t._bigLabelEnd=date.add(t._bigLabelEnd, bigLabelUnit, offsetCount3*bigLabelCount);
                        if(offsetCount3<0)
                            self._minusRight(profile,t._bigMarks, labelsTop, -offsetCount3);
                        else
                            self._addRight(profile, bak_e, '_big',labelsTop, offsetCount3, off);
                    }
                }
            }
            // reset date start point
            t._band_left = band.left();
            t.dateStart = self._getTime(profile, -t._band_left, 1);

            profile.pause = false;
        },
        _trimTask:function(profile, o){
            //****
            // if too long, cut left
            var l=-12,
                x=o._left,
                w=o._width,
                bw=profile.properties._band_width;
            if(x < l){
                if(x+w<l)
                    w=0;
                else
                    w = w + x - l;
                x = l;
            }
            if(x>bw+12)x=bw+12;
            this._setItemNode(profile, o,'left',x+'px');
            // if too long, cut right
            if(x + w > bw - l)
                w = bw - l - x;
            if(w>=0)
                this._setItemNode(profile, o,'width',w+'px');
        },
        _setItemNode:function(profile, item, key, value){
            var t=profile.getSubNodeByItemId('ITEM',item.id).get(0);
            t.style[key]=value;
        },
        _getLinePos:function(profile,o){
            if(o._min)return 0;

            var t=profile.properties,
                b=false,
                index=0;
            _.arr.each(t._lines,function(v,i){
                if(i===0)return;
                b=true;
                _.each(v,function(v){
                    if(o.id!==v.id)
                        if(((o._left + o._width)>=v._left) && ((v._left + v._width)>=o._left))
                            return b=false;
                });
                if(b){index=i;return false;}
            });
            if(!b)
                index = t._lines.push({})-1;
            return index;
        },
        // _reArrage tasks for top position
        _reArrage:function(profile){
            var self=this, o, h,
                t=profile.properties;
            t._lines.length = 1;
            t.items.sort(function(x,y){
                return x.from>y.from?1:x.from==y.from?0:-1;
            });
            //re caculate from current line
            _.arr.each(t.items,function(v){
                if(v._line===0)return;

                //get pos from current line
                index = self._getLinePos(profile, v);
                t._lines[index][v.id]=v;
                // if has space, reset position
                if(v._line !== index){
                    // reset double link
                    v._line = index;
                    // set top
                    if(t.multiTasks)
                        self._setItemNode(profile, v,'top',((t.taskHeight+3) * (index-1) + 16 + 3) +'px');
                };
            });

            h = t._linesHeight =  (t._lines.length+1) * (t.taskHeight);

            self._ajustHeight(profile);
        },
        _resetItem:function(profile,o,src){
            var p=profile.properties,
                t=profile.getItemByDom(src),
                bandW=p._band_width + 12,
                f=function(k,i){return profile.getSubNodeByItemId(k,i)},
                timeline=profile.box,
                max=Math.max;

            if(o.left){
                t._left=o.left;
                t.from = timeline._getTime(profile,o.left);
                src.style.left=o.left+'px';
            }
            if(o.width){
                t._width=max(o.width, 0);
                t.to = timeline._getTime(profile,o.left+o.width);
                if(p.multiTasks){
                    // if too small, show min
                    if(t._width<=16){
                        t._width=o.width=16;
                        if(!t._min){
                            t._min=true;
                            f('NORMAL',t.id).css('display','none');
                            f('MIN',t.id).css('display','block');
                        }
                    // else show normal
                    }else{
                        if(t._min){
                            delete t._line;
                            t._min=false;
                            f('NORMAL',t.id).css('display','block');
                            f('MIN',t.id).css('display','none');
                        }
                        // if too long ,cut right
                        if(o.left + o.width > bandW)
                            o.width = bandW - o.left;
                    }
                }
                src.style.width=o.width+'px';
                if(linb.browser.ie && !p.multiTasks)
                    linb([src.parentNode]).ieRemedy();
            }
            // _reArrage top position
            timeline._reArrage(profile);
        },
        _ajustHeight:function(profile){
            var p=profile.properties,
                f=function(p){return profile.getSubNode(p)},
                view = f('VIEW'),
                items = f('ITEMS'),
                scroll = f('SCROLL'),
                scrolli= f('SCROLLI'),
                h,b,
                ih=p._linesHeight||0,
                vh=view.height();

            h=Math.max(ih,vh);
            items.height(h);
            scrolli.height(h);
            b=ih>vh;
            scroll.css('display',b?'block':'none');
            items.top(b?-scroll.scrollTop():0);
        },
        _showTips:function(profile, node, pos){
            if(profile.onShowTips)
                return profile.boxing().onShowTips(profile, node, pos);
             
             var t=profile.properties,
                id=node.id,
                format=t._timeFormat,
                sid=profile.getSubId(id),
                map=profile.SubSerialIdMapItem,
                item=map&&map[sid],
                date=linb.Date;

            if(t.disabled)return;
            if(item && item.disabled)return;
            if(item){
                item.tips = '<p style="font-weight:bold">'+item.caption +'</p>'+ date.getText(new Date(item.from),format)+" - "+date.getText(new Date(item.to),format);
                linb.Tips.show(pos, item);
                return true;
            }else
                return false;
        },
        _beforeSerialized:function(profile){
            var w=profile.properties.width,
                o=arguments.callee.upper.call(this, profile);
            o.properties.width=w;
            return o;
        },
        _onresize:function(profile,width,height){
            var p=profile.properties,
                f=function(k){return profile.getSubNode(k)},
                off1=2*p.$borderW,
                off2=3,
                t;
            //for border, view and items
            if(height && height!=p.height && parseInt(profile.domNode.style.height)){
                f('BORDER').height(t=height-off1);
                f('VIEW').height(t=t - (p.showTips&&p._tipsHeight) -off2 - (p.showBigLabel?p._bigLabelHeight:0) - p._smallLabelHeight - (p.showBar&&p._barHeight));
                this._ajustHeight(profile);

                if(p.height!=height)p.height=height;
            }
            if(width && width!=p.width){
                f('BORDER').width(width-off1);
                p.width=width;

                //if width changed, refresh the timeline
                if(!p.fixWidth){
                    _.resetRun(profile.$id+":refresh",function(){
                        //if multiTasks, setUIValue will be ignored
                        profile.box._refresh(profile)._focus(profile);
                    });
                }
            }
        },
        _refresh:function(profile){
            //if multiTasks, setUIValue will be ignored
            profile.boxing().clearItems().refresh().setUIValue(profile.properties.$UIvalue);
            return this;
        }
    }
});Class("linb.UI.List", ["linb.UI", "linb.absList","linb.absValue" ],{
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                if(!profile.domNode)return;

                var box = profile.boxing(),
                    uiv = box.getUIValue(),
                    p = profile.properties,
                    k = 'ITEM',
                    getN = function(k,i){return profile.getSubNode(k,i)},
                    getI = function(i){return profile.getSubIdByItemId(i)}
                    ;
                if(p.selMode=='single'){
                    var itemId = getI(uiv);
                    if(uiv!==null && itemId)
                        getN(k,itemId).tagClass('-checked',false);

                    itemId = getI(value);
                    if(itemId)
                        getN(k,itemId).tagClass('-checked');

                    //scroll
                    if(itemId){
                        var o = getN(k,itemId);
                        if(o){
                            var top = o.offsetTop(),
                            items = getN('ITEMS'),
                            sh=items.scrollHeight(),
                            st=items.scrollTop(),
                            hh=items.height()
                            ;
                            if(sh > hh)
                                if(top<st || top>st+hh)
                                    items.scrollTop(top);

                        }
                    }
                }else if(p.selMode=='multi'){
                    uiv = uiv?uiv.split(';'):[];
                    value = value?value.split(';'):[];
                    //check all
                    _.arr.each(uiv,function(o){
                        if(_.arr.indexOf(value,o)==-1)
                            getN(k, getI(o)).tagClass('-checked',false)
                    });
                    _.arr.each(value,function(o){
                        if(_.arr.indexOf(uiv,o)==-1)
                            getN(k, getI(o)).tagClass('-checked')
                    });
                }
            });
        },
        adjustSize:function(){
            return this.each(function(profile){
                var items = profile.getSubNode('ITEMS'),pp=profile.properties;
                items.height('auto');
                var h = Math.min(pp.maxHeight, items.offsetHeight());
                pp.height=h;
                items.height(h);
                profile.root.height(h);
            });
        },
        activate:function(){
            return linb.absList.prototype.activate.call(this);
        },
        _setDirtyMark:function(){
            return this.each(function(profile){
                var id=profile.domId,
                    p=profile.properties,
                    flag=p.value !== p.$UIvalue,
                    d=linb.UI.$css_tag_dirty;

                //dirty mark
                if(profile.beforeDirtyMark && false===profile.boxing().beforeDirtyMark(profile,flag)){}
                else{
                    var o = profile.getSubNode('ITEMS');
                    if(flag)
                        o.addClass(d);
                    else
                        o.removeClass(d);
                }
            });
        }
    },
    Static:{
        Templates:{
            tagName : 'div',
            style:'{_style}',
            ITEMS:{
               $order:10,
               tagName:'div',
               className:'ui-content',
               text:"{items}"
            },
            $dynamic:{
                items:{
                    ITEM:{
                        className:'{itemClass}',
                        style:'{itemStyle}',
                        tagName : 'a',
                        href :linb.$href,
                        tabindex:'{_tabindex}',
                        ICON:{
                            style:'background:url({image}) transparent  no-repeat {imagePos};{iconDisplay}',
                            className:'ui-icon',
                            $order:0
                        },
                        CAPTION:{
                            tagName : 'text',
                            text : '{caption}&nbsp;',
                            $order:1
                        }
                    }
                }
            }
        },
        Appearances:{
            KEY:{
                'font-size':'12px'
            },
            ITEMS:{
                position:'relative',
                border:'1px solid #91A7B4',
                overflow:'auto',
                'overflow-x': (linb.browser.ie || linb.browser.gek)?'hidden':''
            },
            ITEM:{
                display:'block',
                zoom:linb.browser.ie?1:null,
                'font-family': '"Verdana", "Helvetica", "sans-serif"',
                border:0,
                cursor:'pointer',
                'font-size':'12px',
                padding:'0 2px 0 2px',
                position:'relative'
            },
            'ITEM-mouseover':{
                $order:1,
                'background-color': '#d9e8fb'
            },
            'ITEM-checked':{
                $order:2,
                'background-color':'#316AC5',
                color:'#fff'
            }
        },
        Behaviors:{
            HoverEffected:{ITEM:'ITEM'},
            ClickEffected:{ITEM:'ITEM'},
            DragableKeys:["ITEM"],
            DropableKeys:["ITEM","ITEMS"],
            onSize:function(profile,e){
                var o = profile.domNode.style,w=null,h=null;
                if(e.height)h = parseInt(o.height)||w;
                if(e.width)w = parseInt(o.width)||h;
                linb.UI.$tryResize(profile, w, h);
            },
            ITEM:{
                onDblclick:function(profile, e, src){
                    var properties = profile.properties,
                        item = profile.getItemByDom(src);
                    profile.boxing().onDblclick(profile, item, src);
                },
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        item = profile.getItemByDom(src),
                        itemId =profile.getSubId(src.id),
                        box = profile.boxing(),
                        ks=linb.Event.getKey(e),
                        rt,rt2;

                    if(properties.disabled|| item.disabled)return false;

                    switch(properties.selMode){
                    case 'none':
                        rt=box.onItemSelected(profile, item, src);
                        break;
                    case 'multi':
                        var value = box.getUIValue(),
                            arr = value?value.split(';'):[];

                        if(arr.length&&(ks[1]||ks[2]||properties.$checkbox)){
                            //for select
                            rt2=false;
                            if(ks[2]){
                                var items=properties.items,
                                    i1=_.arr.subIndexOf(items,'id',profile.$firstV.id),
                                    i2=_.arr.subIndexOf(items,'id',item.id),
                                    i;
                                arr.length=0;
                                for(i=Math.min(i1,i2);i<=Math.max(i1,i2);i++)
                                    arr.push(items[i].id);
                            }else{
                                if(_.arr.indexOf(arr,item.id)!=-1)
                                    _.arr.removeValue(arr,item.id);
                                else
                                    arr.push(item.id);
                            }

                            arr.sort();
                            value = arr.join(';');

                            //update string value only for setCtrlValue
                            if(box.getUIValue() != value){
                                box.setUIValue(value);
                                if(box.getUIValue() == value)
                                    rt=box.onItemSelected(profile, item, src)||rt2;
                            }
                            break;
                        }
                    case 'single':
                        if(box.getUIValue() == item.id)
                            rt=false;
                        else{
                            profile.$firstV=item;
                            box.setUIValue(item.id);
                            if(box.getUIValue() == item.id)
                                rt=box.onItemSelected(profile, item, src);
                        }
                        break;
                    }
                    linb(src).focus();
                    return rt;
                },
                onKeydown:function(profile, e, src){
                    var keys=linb.Event.getKey(e), key = keys[0], shift=keys[2],
                    cur = linb(src),
                    first = profile.root.nextFocus(true, true, false),
                    last = profile.root.nextFocus(false, true, false);

                    switch(linb.Event.getKey(e)[0]){
                        case 'tab':
                            if(shift){
                                if(src!=first.get(0)){
                                    first.focus();
                                    return false;
                                }
                            }else{
                                if(src!=last.get(0)){
                                    last.focus();
                                    return false;
                                }
                            }
                            break;
                        case 'left':
                        case 'up':
                            var next = cur.nextFocus(false, true, false);
                            if(cur.get(0)==first.get(0))
                                last.focus();
                            else
                                cur.nextFocus(false);
                            return false;
                            break;
                        case 'right':
                        case 'down':
                            var next = cur.nextFocus(true, false, false);
                            if(cur.get(0)==last.get(0))
                                first.focus();
                            else
                                cur.nextFocus();
                            return false;
                            break;
                        case 'enter':
                            linb(src.id).onClick();
                            return false;
                            break;
                    }
                }
            }
        },
        DataModel:({
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('ITEM',true).attr('tabIndex',value);
                }
            },
            selMode:{
                ini:'single',
                listbox:['single','none','multi']
            },
            width:120,
            height:150,
            maxHeight:300
        }),
        EventHandlers:{
            onDblclick:function(profile, item, src){},
            onItemSelected:function(profile, item, src){}
        },
        _ensureValue:function(profile,value){
            if(profile.properties.selMode=='multi'){
                var arr = (value||"").split(';');
                arr.sort();
                return arr.join(';');
            }else
                return value;
        },
        _onStartDrag:function(profile, e, src, pos){
            var pos=linb.Event.getPos(e);
            linb([src]).startDrag(e, {
                dragType:'icon',
                shadowFrom:src,
                targetLeft:pos.left+12,
                targetTop:pos.top+12,
                dragCursor:'pointer',
                dragDefer:1,
                dragKey: profile.box.getDragKey(profile, src),
                dragData: profile.box.getDragData(profile, src)
            });
            return false;
        },
        _onDropTest:function(profile, e, src, key, data, item){
            var fid=data&&data.domId, tid=src.id;
            if(fid){
                if(fid==tid)return false;
                if(_.get(src,['previousSibling','id'])==fid)return false;
            }
        },
        _onDrop:function(profile, e, src, key, data, item){
            linb.DragDrop.setDragIcon('none');

            var k=profile.getKey(src.id),
                po=data.profile,
                ps=data.domId,
                oitem,
                t=linb.absObj.$specialChars;
            //remove
            oitem=_.clone(po.getItemByDom(ps),function(o,i){return !t[(i+'').charAt(0)]});
            po.boxing().removeItems([oitem.id]);

            if(k==profile.keys.ITEM)
                profile.boxing().insertItems([oitem], item.id, true);
            else
                profile.boxing().insertItems([oitem],null,false);

            return false;
        },
        _onresize:function(profile,width,height){
            var t=profile.properties,
                temp,
                l=profile.getSubNode('ITEMS')
            ;
            //no height set
            if(!parseInt(profile.domNode.style.height))
                return;
            l.height(height);
        }
    }
});
Class("linb.UI.LinkList", ["linb.UI.List"],{
    Initialize:function(){
        //modify default template fro shell
        var t = this.getTemplate();
        t.$dynamic={
            items:{
                ITEM:{
                    className:'{itemClass}',
                    style:'margin:{itemMargin}px;{itemStyle}',
                    LINK:{
                        $order:1,
                        tagName : 'a',
                        href :"{href1}",
                        tabindex: '{_tabindex}',
                        text:'{caption}'
                    }
                }
            }
        };
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            ITEMS:{
                position:'relative',
                overflow:'auto',
                'overflow-x': (linb.browser.ie || linb.browser.gek)?'hidden':''
            },
            ITEM:{
                'vertical-align':'middle',
                position:'relative',
                background: linb.UI.$bg('cmds.gif', ' no-repeat left -202px', true),
                'border-right':'solid 1px #C2C1C1',
                height:'16px',
                'white-space':'nowrap'
            },
            'ITEM-mouseover':{},
            'ITEM-checked':{},
            LINK:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                'vertical-align':'middle',
                padding:'1pt 4px 1pt 12px'
            }
        },
        DataModel:({
            itemMargin:{
                ini:0,
                action:function(value){
                    this.getSubNode('ITEM',true).css('margin',value+'px');
                }
            },
            tabindex:{
                action:function(value){
                    var self=this,
                        keys = self.keys,
                        fun = function(l,v){self.getSubNode(l,true).attr('tabIndex',v)}
                    if(self.domNode)
                        fun('LINK', value);
                }
            }
        }),
        Behaviors:{
            ITEM:{onClick:null,onKeydown:null},
            LINK:{
                onClick:function(profile, e){return !!linb.Event.getKey(e)[2]},
                onMousedown:function(profile, e, src){
                    if(linb.Event.getBtn(e)!='left')return;
                    var properties = profile.properties,
                        item = profile.getItemByDom(src),
                        box = profile.boxing();
                    if(properties.disabled|| item.disabled)return false;
                        box.onItemClick(profile, item, src);
                }
            }
        },
        EventHandlers:{
            onItemSelected:null,
            onItemClick:function(profile, item, src){}
        },
        _prepareItem:function(profile, item){
            var p = profile.properties;
            item._tabindex = p.tabindex;
            item.itemMargin = p.itemMargin;
        }
    }
});
Class("linb.UI.Gallery", "linb.UI.List",{
    Instance:{
        getStatus:function(id){
            var item=this.get(0).getItemByItemId(id);
            return (item && item._status)||'ini';
        }
    },
    Initialize:function(){
        //modify default template fro shell
        var t = this.getTemplate();
        t.$dynamic={
            items:{
                ITEM:{
                    className:'{itemClass}',
                    style:'padding:{itemPadding}px;margin:{itemMargin}px;{itemStyle}',
                    ITEMFRAME:{
                        style:'width:{itemWidth}px;height:{itemHeight}px;',
                        CAPTION:{
                            tagName : 'div',
                            text: '{caption}',
                            $order:0
                        },
                        CONTENT:{
                                tagName : 'div',
                                $order:1,
                                //for firefox2 image in -moz-inline-box cant change height bug
                                ICONWRAP:{
                                    tagName : 'div',
                                    IMAGE:{
                                        tagName : 'img',
                                        src:'{image}'
                                    }
                                }
                        },
                        COMMENT:{
                            tagName : 'a',
                            href:'{href}',
                            text: '{comment}',
                            $order:2
                        }
                    }
                }
            }
        };
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            KEY:{
                overflow:'auto',
                'overflow-x': (linb.browser.ie || linb.browser.gek)?'hidden':''
            },
            ITEMS:{
                position:'relative',
                overflow:'visible',
                zoom:linb.browser.ie6?1:null,
                background: 'url('+linb.ini.file_bg+') no-repeat left top'
            },
            ITEM:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                position:'relative',
                overflow:'hidden',
                'vertical-align':'top',
                /*opera must be 0 not 'none'*/
                border:0,
                padding:0,
                margin:0
            },
            ITEMFRAME:{
                display:linb.browser.ie?'inline-block':'block',
                position:'relative',
                overflow:'hidden',
                border:0,
                padding:0,
                margin:0,
                width:'100%',
                height:'100%',
                '-moz-box-flex':'1',
                '-moz-user-select':'none',
                border:'1px solid #A7A6AA'
            },
            'ITEM-mouseover':{
            },
            'ITEM-checked':{
            },
            'ITEM-mouseover CAPTION':{
                $order:1 ,
                'background-color': '#d9e8fb'
            },
            'ITEM-checked CAPTION':{
                $order:2,
                'background-color':'#316AC5',
                color:'#fff'
            },
            'CONTENT, CAPTION':{
            	'text-align': 'center',
                overflow:'hidden',
                'white-space':'nowrap'
            },
            CAPTION:{
                'font-weight':'bold',
                'border-bottom':'1px solid #A7A6AA'
            },
            IMAGE:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
            	'vertical-align': 'middle'
            },
            'COMMENT':{
                display:'block',
                margin:'0 2px 0 2px'
            }
        },
        Behaviors:{
            IMAGE:{
                onLoad:function(profile,e,src){
                    var item=profile.getItemByDom(src);
                    item._status='loaded';
                },
                onError:function(profile,e,src){
                    var item=profile.getItemByDom(src);
                    item._status='error';
                }
            }
        },
        DataModel:({
            itemMargin:{
                ini:6,
                action:function(v){
                    if(typeof v!='object')
                        this.getSubNode('ITEM',true).css('margin', (''+parseFloat(v))==(''+v)?v+'px':v);
                    else
                        this.getSubNode('ITEM',true).css(v);
                }
            },
            itemPadding:{
                ini:2,
                action:function(v){
                    if(typeof v!='object')
                        this.getSubNode('ITEM',true).css('padding',(''+parseFloat(v))==(''+v)?v+'px':v);
                    else
                        this.getSubNode('ITEM',true).css(v);
                }
            },
            itemWidth:{
                ini:32,
                action:function(v){
                    this.getSubNode('ITEMFRAME',true).width(v);
                }
            },
            itemHeight:{
                ini:32,
                action:function(v){
                    this.getSubNode('ITEMFRAME',true).height(v);
                }
            },
            imgWidth:{
                ini:16,
                action:function(v){
                    this.getSubNode('IMAGE',true).width(v);
                }
            },
            imgHeight:{
                ini:16,
                action:function(v){
                    this.getSubNode('IMAGE',true).height(v);
                }
            },
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('ITEM',true).attr('tabIndex',value);
                }
            },
            width:200,
            height:200
        }),
        _prepareItem:function(profile, item){
            var p = profile.properties;

            _.arr.each(_.toArr('itemWidth,itemHeight,imgWidth,imgHeight,itemPadding,itemMargin'),function(i){
                item[i] = item[i] || p[i];
            });
            item.href = item.href||linb.$href;
            item.capition = item.capition || '';
            item.comment = item.comment || '';
            item._tabindex = p.tabindex;
        },
        _onresize:function(){}
    }
});
Class("linb.UI.IconList", "linb.UI.List",{
    Instance:{
        getStatus:function(id){
            var item=this.get(0).getItemByItemId(id);
            return (item && item._status)||'ini';
        }
    },
    Initialize:function(){
        //modify default template fro shell
        var t = this.getTemplate();
        t.$dynamic={
            items:{
                ITEM:{
                    className:'{itemClass}',
                    style:'padding:{itemPadding}px;margin:{itemMargin}px;{itemStyle}',
                    //for firefox2 image in -moz-inline-box cant change height bug
                    IBWRAP:{
                        tagName:'div',
                        IMAGE:{
                            tagName:'img',
                            src:'{image}',
                            width:'{itemWidth}',
                            height:'{itemHeight}'
                        }
                    }
                }
            }
        };
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            KEY:{
                overflow:'auto',
                'overflow-x': (linb.browser.ie || linb.browser.gek)?'hidden':''
            },
            ITEMS:{
                overflow:'auto',
                'overflow-x': (linb.browser.ie || linb.browser.gek)?'hidden':'',
                position:'relative',
                'line-height':'14px',
                zoom:linb.browser.ie6?1:null,
                background: 'url('+linb.ini.file_bg+') no-repeat left top'
            },
            ITEM:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                position:'relative',
                overflow:'hidden',
                cursor:'pointer',
                'vertical-align':'top'
            },
            IMAGE:{
                border:'1px solid #CDCDCD'
            }
        },
        Behaviors:{
            IMAGE:{
                onLoad:function(profile,e,src){
                    var item=profile.getItemByDom(src);
                    item._status='loaded';
                },
                onError:function(profile,e,src){
                    var item=profile.getItemByDom(src);
                    item._status='error';
                }
            }
        },
        DataModel:({
            itemMargin:{
                ini:6,
                action:function(v){
                    if(typeof v!='object')
                        this.getSubNode('ITEM',true).css('margin',(''+parseFloat(v))==(''+v)?v+'px':v);
                    else
                        this.getSubNode('ITEM',true).css(v);
                }
            },
            itemPadding:{
                ini:2,
                action:function(v){
                    if(typeof v!='object')
                        this.getSubNode('ITEM',true).css('padding',(''+parseFloat(v))==(''+v)?v+'px':v);
                    else
                        this.getSubNode('ITEM',true).css(v);
                }
            },
            itemWidth:{
                ini:16,
                action:function(v){
                    this.getSubNode('IMAGE',true).width(v);
                }
            },
            itemHeight:{
                ini:16,
                action:function(v){
                    this.getSubNode('IMAGE',true).height(v);
                }
            },
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('ITEM',true).attr('tabIndex',value);
                }
            },
            width:200,
            height:200
        }),
        _prepareItem:function(profile, item){
            var p = profile.properties;
            _.arr.each(_.toArr('itemWidth,itemHeight,itemPadding,itemMargin'),function(i){
                item[i] = item[i] || p[i];
            });
            item._tabindex = p.tabindex;
        },
        _onresize:function(){}
    }
});
Class("linb.UI.Poll", "linb.UI.List",{
    Instance:{
        fillContent:function(id, obj){
            var profile=this.get(0),t,item;
            if(profile.domNode){
                if(item=profile.getItemByItemId(id)){
                    t=profile.getSubNodeByItemId('BODY',id).html('');
                    if(obj){
                        item._obj = obj;
                        item._fill=true;
                        if(typeof obj=='string')t.html(obj);
                        else t.append(obj.render(true));
                    }else
                        item._obj=item._fill=null;
                }
            }
            return this;
        },
        _setOptCap:function(item, value){
            return this.each(function(pro){
                var items = pro.properties.items,
                i = pro.queryItems(pro.properties.items, function(o){
                    return o.id==item.id;
                },false,true);
                if(i && (i=i[0])){
                    i.caption=value;
                    if(pro.domNode)
                        pro.getSubNodeByItemId('CAPTION',i.id).html(value);
                }
            });
        },
        getBindEditor:function(){
            return this.get(0)._bind;
        },
        _insertOpt:function(opt){
            if(!opt.id)opt.id='$'+_();
            this.insertItems([opt],null, false);
            return this;
        },
        _removeOpt:function(id){
            this.removeItems([id],'OUTER');
            return this;
        },
        _setDirtyMark:function(){return this}
    },
    Initialize:function(){
        var self=this;
        self.addTemplateKeys(['MARK2','MARK3','EDIT']);
        //modify default template fro shell
        var t = self.getTemplate();
        t.TITLE={
            $order:'0',
            tagName : 'DIV',
            style:'{titleDisplay}',
            text : '{title}',
            className:"{disabled} {_cls}"
        };
        t.TAIL={
            $order:'20',
            tagName : 'DIV',
            className:"{disabled} ",
            text:"{cmds}"
        };
        t.$dynamic={
            items:{
                OUTER:{
                    tagName:'div',
                    TOGGLE:{
                        className:'uicmd-toggle',
                        style:'{_togdisplay}'
                    },
                    ITEM:{
                        tagName: 'a',
                        href :linb.$href,
                        tabindex: '{_tabindex}',
                        className:'{itemClass}',
                        style:'{itemStyle}',
                        OPTION:{
                            $order:0,
                            tagName : 'DIV',
                            MARK:{$order:1,className:'{_optclass}'}
                        },
                        CAPTION:{
                            $order:1,
                            tagName : 'DIV',
                            text : '{caption}',
                            className:"{disabled} {_itemcls}"
                        },
                        CHART:{
                            $order:2,
                            tagName : 'DIV',
                            style:'{_display}',
                            CAST:{
                                $order:0,
                                text:'{message}'
                            },
                            BAR:{
                                $order:1,
                                style:'background-position: -{_per}px -190px;',
                                BARI:{}
                            },
                            DEL:{
                                $order:2,
                                tagName : 'BUTTON',
                                className:'ui-btn',
                                style:'{_del}',
                                text:'{removeText}'
                            }
                        },
                        CLEAR:{
                            $order:3,
                            tagName : 'DIV'
                        }
                    },
                    BODY:{
                        $order:1,
                        tagName : 'DIV',
                        text:'{_body}'
                    }
                }
            },
            cmds:{
                CMD:{
                    tagName: '{tagName}',
                    tabindex: '{_tabindex}',
                    className:'ui-btn',
                    text:'{caption}'
                }
            }
        };
        self.setTemplate(t);

        //for modify
        var inlineEdit=function(profile,node,flag,value,item){
            var o,useC,prop=profile.properties,
                callback=function(v){
                    var b=profile.boxing();
                    switch(flag){
                        //edit option
                        case '1':
                            if(b.beforeItemChanged(profile, item, v)!==false)
                                b._setOptCap(item,v);
                        break;
                        //new option
                        case '2':
                            if(b.beforeOptionAdded(profile, v)!==false ){
                                var id="["+v.replace(/[^\w_]*/g,'')+"]";
                                b._insertOpt({caption:v,id:id});
                                if(!profile.properties.editable){
                                    profile.boxing().fireItemClickEvent(id);
                                }
                            }
                        break;
                        //edit title
                        default:
                            if(b.beforeTitleChanged(profile, v)!==false)
                                b.setTitle(v);
                    }
                };

            if(profile.onCustomEdit)
                if(o=profile._bind=profile.boxing().onCustomEdit(profile, node, flag, value, item, callback))
                    useC=true;
            if(!useC){
                o=profile._bind;
                if(!o){
                    var pp={type:prop.editorType,saveBtn:true,left:-10000,top:-10000};
                    profile._bind=o=linb.create('ComboInput', pp);
                    o.onHotKeydown(function(p,key){
                        if(key=='enter'){
                            p.boxing().onSave(p);
                            return false;
                        }else if(key=='esc'){
                            o.hide();
                            return false;
                        }
                    })
                    profile.root.append(o);
                }

                var r=node.cssRegion(true,profile.root);
                if(r.height>o.getHeight())
                    o.setHeight(r.height);
                else
                    r.top-=3;
                if(r.top<0)r.top=0;

                o.setValue(value||'',true)
                .setWidth(r.width + (parseInt(node.css('paddingLeft'))||0)+ (parseInt(node.css('paddingRight'))||0))
                .show(r.left+'px',r.top+'px')
                .onSave(function(p){
                    var pro=p.properties,v=pro.$UIvalue, ov=pro.value;
                    if(v!=ov)
                        callback(v);
                    _.asyRun(function(){
                        o.hide();
                    });
                })
                .reBoxing().setBlurTrigger(o.KEY+":"+o.$id, function(){
                    o.hide();
                });
                _.asyRun(function(){
                    o.activate()
                });
            }
        };

        t = self.getBehavior();
        var old=t.ITEM.onClick;
        t.ITEM.onClick = function(profile, e, src){
            var p = profile.properties,
                item = profile.getItemByDom(src),
                editable=item.id=='$custom' || item.editable;
            if(p.disabled)return;

            if(p.editable)
                inlineEdit(profile, profile.getSubNodeByItemId('CAPTION',item.id), editable?'2':'1', editable?'':item.caption, item);
            else{
                if(editable)
                    inlineEdit(profile, profile.getSubNodeByItemId('CAPTION',item.id), '2');
                else
                    old.apply(this, arguments);
            }
        };
        t.TITLE={
            onClick : function(profile, e, src){
                var p = profile.properties,
                    item = profile.getItemByDom(src);
                if(p.disabled)return;

                if(p.editable)
                    inlineEdit(profile, profile.getSubNode('TITLE'), '3', p.title);
            }
        };
        t.DEL={
            onClick : function(profile, e, src){
                var p = profile.properties,
                    b = profile.boxing(),
                    item = profile.getItemByDom(src);
                if(p.disabled)return;
                if(b.beforeOptionRemoved(profile, item)!==false )
                    b._removeOpt(item.id);
                return false;
            }
        }
        t.CMD={
            onClick : function(profile, e, src){
                var p = profile.properties,
                    key = profile.getSubId(src.id);
                if(p.disabled)return;
                profile.boxing().onClickButton(profile, key, src);
            }
        };
        t.TOGGLE={
            onClick:function(profile, e, src){
                var properties = profile.properties,
                    items=properties.items,
                    item = profile.getItemByDom(src),
                    itemId = profile.getSubId(src.id),
                    node = linb([src]),
                    body = profile.getSubNode('BODY',itemId),t
                    ;
                if(item._show){
                    node.tagClass('-checked',false);
                    body.css('display','none');
                }else{
                    node.tagClass('-checked');
                    body.css('display','block');
                    //fill value
                    if(!item._fill){
                        item._fill=true;
                        var callback=function(o){
                            profile.boxing().fillContent(item.id, item._body=o);
                        };
                        if(profile.onGetContent)
                            linb.Thread.observableRun(
                                function(threadId){
                                    var r = profile.boxing().onGetContent(profile, item, callback, threadId);
                                    if(r) callback(r);
                                });
                        else
                            callback(profile.box._buildBody(profile, item));
                    }
                }

                item._show=!item._show;

                //prevent href default action
                //return false;
            }
        };

        self.setBehavior(t);
    },
    Static:{
        ITEMKEY:'OUTER',
        Appearances:{
            KEY:{
                'font-size':'12px',
                zoom:linb.browser.ie?1:null
            },
            'TITLE, ITEMS, TAIL':{
                position:'relative',
                overflow:'auto',
                'line-height':'12px'
            },
            TAIL:{
                zoom:linb.browser.ie?1:null,
                'padding':'5px 0 5px 40px'
            },
            CMD:{
                margin:'3px',
                'white-space':'nowrap',
                'vertical-align':'middle'
            },
            TITLE:{
                'font-weight':'bold',
                padding:'4px',
                'border-bottom':'1px solid #CDCDCD'
            },
            ITEMS:{
                'overflow-x': (linb.browser.ie || linb.browser.gek)?'hidden':'',
                zoom:linb.browser.ie?1:null,
                margin:'4px 4px 4px 5px'
            },
            OUTER:{
                position:'relative',
                zoom:linb.browser.ie?1:null,
                'padding-left':'15px',
                'border-bottom':'1px dashed #CDCDCD'
            },
            TOGGLE:{
                position:'absolute',
                left:0,
                top:'4px'
            },
            BODY:{
                display:'none',
                'padding-left':'27px'
            },
            ITEM:{
                display:'block',
                position:'relative',
                zoom:linb.browser.ie?1:null,
                padding:'4px 2px 4px 2px'
            },
            'ITEM-checked':{},
            OPTION:{
                position:'absolute',
                left:'2px',
                top:'4px'
            },
            CAPTION:{
                'float':'left',
                zoom:linb.browser.ie?1:null,
                'margin-left':'24px',
                //{*1*}for: ie6 double margin bug
                display:linb.browser.ie6?'inline':null
            },
            'EDIT, EDITS':{
                $order:2,
                'float':'none',
                'background-color':'#EBEADB',
                cursor:'pointer',
                //{*1*}for: ie6 double margin bug
                display:linb.browser.ie6?'block':null
            },

            CHART:{
                'float':'right'
            },
            CLEAR:{
                clear:'both',
                'text-align':'right'
            },
            'BAR, BARI':{
                width:'150px',
                height:'12px',
                border:0,
                'line-height':0,
                'font-size':0
            },
            BAR:{
                'margin-left':'2px',
                background: linb.UI.$bg('cmds.gif', ' no-repeat -130px -190px', true)
            },
            BARI:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat -150px -225px ', true)
            },
            'MARK, MARK2, MARK3' : {
               cursor:'pointer',
               width:'16px',
               height:'16px',
                'vertical-align':'middle',
               'margin-right':'6px'
            },
            MARK:{
               background: linb.UI.$bg('cmds.gif', ' no-repeat -144px top', true)
            },
           'ITEM-mouseover MARK':{
                $order:1,
                'background-position':' -144px -17px'
           },
           'ITEM-mousedown MARK':{
                $order:2,
                'background-position':' -144px -34px'
           },
           'ITEM-checked MARK':{
                $order:3,
                'background-position':' -128px top'
           },
           'ITEM-checked-mouseover MARK':{
                $order:4,
                'background-position':' -128px -17px'
           },
           'ITEM-checked-mousedown MARK':{
                $order:5,
                'background-position':' -128px -34px'
            },
            MARK2:{
               background: linb.UI.$bg('cmds.gif', ' no-repeat -112px top', true)
            },
           'ITEM-mouseover MARK2':{
                $order:1,
                'background-position':' -112px -17px'
           },
           'ITEM-mousedown MARK2':{
                $order:2,
                'background-position':' -112px -34px'
           },
           'ITEM-checked MARK2':{
                $order:3,
                'background-position':' -96px top'
           },
           'ITEM-checked-mouseover MARK2':{
                $order:4,
                'background-position':' -96px -17px'
           },
           'ITEM-checked-mousedown MARK2':{
                $order:5,
                'background-position':' -96px -34px'
            },
            MARK3:{
                $order:11,
               background: linb.UI.$bg('cmds.gif', ' no-repeat -56px -222px', true)
            },
           'ITEM-mouseover MARK3':{
                $order:11,
                'background-position':' -56px -222px'
           },
           'ITEM-mousedown MARK3':{
                $order:11,
                'background-position':' -56px -222px'
           },
            DEL:{
                margin:'0 0 0 4px'
            }
        },
        DataModel:{
            $checkbox:1,
            title:{
                action:function(v){
                    this.getSubNode('TITLE').html(v);
                }
            },
            selMode:{
                ini:'single',
                listbox:['single','multi'],
                action:function(){
                    this.boxing().refresh();
                }
            },
            cmds:{
                ini:null
            },
            noTitle:{
              ini:false,
              action:function(v){
                 this.getSubNode('TITLE').css('display',v?'none':'');
              }
            },
            toggle:{
                ini:false,
                action:function(v){
                    this.getSubNode('TOGGLE',true).css('display',v?'':'none');
                }
            },
            removeText:{
                ini:'remove',
                action:function(v){
                    this.getSubNode('DEL',true).text(v);
                }
            },
            editable:{
                ini:false,
                action:function(v){
                    var self=this,t,cls;
                    self.getSubNode('DEL',true).css('display',v?'':'none');
                    t=self.getSubNode('CAPTION',true).merge(self.getSubNode('TITLE'));
                    cls=self.getClass('EDIT');
                    if(v)
                        t.addClass(cls);
                    else
                        t.removeClass(cls);
                }
            },
            newOption:{
                ini:'',
                action:function(v){
                    var self=this,
                        id='$custom',
                        sid='_special',
                        t,
                        cs=self._cs;
                    if(!v){
                        if(cs)
                            cs.remove();
                    }else{
                        if(!cs){
                            t={
                                id:id,
                                caption:v
                            };
                            t[linb.UI.$tag_subId]=sid;
                            cs=self.buildItems('items',self.box._prepareItems(self,[t]));
                            self.getSubNode('ITEMS').addNext(self._cs=_.str.toDom(cs));
                        }else
                            self.getSubNodeByItemId('CAPTION',sid).html(v);
                    }
                }
            },
            editorType:'none'
        },
        EventHandlers:{
            beforeTitleChanged:function(profile, value){},
            beforeOptionAdded:function(profile, value){},
            beforeOptionRemoved:function(profile, item){},
            beforeOptionChanged:function(profile, item, value){},
            onCustomEdit:function(profile, node, flag, value, item, callback){},
            onClickButton:function(profile, key, src){},
            onGetContent:function(profile,item,callback){}
        },
        RenderTrigger:function(){
            var self=this,t=self.properties.newOption;
            if(t)
                self.boxing().setNewOption(t,true);
        },
        _dynamicTemplate:function(profile){
            var properties = profile.properties,
                hash = profile._exhash = "$" + 'selMode:'+properties.selMode+';',
                template = profile.box.getTemplate(hash);

            properties.$UIvalue = properties.value;

            // set template dynamic
            if(!template){
                template = _.clone(profile.box.getTemplate());
                if(properties.selMode=='multi'){
                    template.$dynamic.items.OUTER.ITEM.OPTION.MARK2={$order:1,className:'{_optclass}'};
                    delete template.$dynamic.items.OUTER.ITEM.OPTION.MARK;
                }
                // set template
                profile.box.setTemplate(template, hash);
            }
            profile.template = template;
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile),
                p=profile.properties
            if(p.editable)
                data._cls = profile.getClass('EDIT');
            data.titleDisplay=p.noTitle?'display:none':'';

            var cmds = p.cmds, o;
            if(cmds && cmds.length){
                var sid=linb.UI.$tag_subId,a;
                a=data.cmds=[];
                for(var i=0,t=cmds,l=t.length;i<l;i++){
                    o=linb.UI.adjustData(profile,t[i]);
                    o.tagName = o.tagName||'button';
                    a.push(o);
                    o._tabindex=p.tabindex;
                    o[sid]=o.id;
                }
            }
            return data;
        },
        _prepareItem:function(profile, item){
            var p = profile.properties, f=profile.CF;
            item._tabindex = p.tabindex;

            if(typeof f.formatCaption == 'function')
                item.caption = f.formatCaption(item.caption);

            item._body= item._body || 'Loading...'
            if(item.id!='$custom'){
                item._togdisplay=((p.toggle && item.toggle!==false) || item.toggle)?'':'display:none;';

                item._display='';
                item.percent = parseFloat(item.percent)||0;
                if(item.percent<0)item.percent=0;
                if(item.percent>1)item.percent=1;
                item._per = 150*(1-item.percent);
            }else{
                item._optclass=profile.getClass('MARK3');
                item._togdisplay=item._display='display:none;';
                item._per = 0;
                item._itemcls=profile.getClass('EDITS');
            }
            item.removeText=p.removeText;
            item._del='display:none;';
            if((('editable' in item) && item.editable)||p.editable){
                item._itemcls=profile.getClass('EDIT');
                item._del = '';
            }


        },
        _buildBody:function(profile,item){
            return item.text?'<pre>'+item.text.replace(/</g,"&lt;")+'</pre>':'';
        }
    }
});
Class("linb.UI.Panel", "linb.UI.Div",{
    Static:{
        Templates:{
            tagName : 'div',
            style:'{_style}',
            BORDER:{
                tagName : 'div',
                BAR:{
                    tagName:'div',
                    className:'uibar-bar',
                    style:'{barDisplay};height:{barHeight}px',
                    BART:{
                        cellpadding:"0",
                        cellspacing:"0",
                        width:'100%',
                        height:'100%',
                        border:'0',
                        tagName:'table',
                        className:'uibar-t',
                        BARTR:{
                            tagName:'tr',
                            BARTDL:{
                                tagName:'td',
                                className:'uibar-tdl'
                            },
                            BARTDM:{
                                $order:1,
                                width:'100%',
                                tagName:'td',
                                className:'uibar-tdm'
                            },
                            BARTDR:{
                                $order:2,
                                tagName:'td',
                                className:'uibar-tdr'
                            }
                        }
                    },
                    BARCMDL:{
                        tagName: 'div',
                        className:'uibar-cmdl',
                        TOGGLE:{
                            className: 'uicmd-toggle {toggleCls}',
                            style:'{toggleDisplay}',
                            $order:0
                        },
                        ICON:{
                            style:'background:url({image}) transparent  no-repeat {imagePos}; {iconDisplay}',
                            className:'ui-icon',
                            $order:0
                        },
                        CAPTION:{
                            tagName: 'a',
                            href :"{href}",
                            tabindex: '{tabindex}',
                            text : '{caption}',
                            $order:1
                        }
                    },
                    BARCMDR:{
                        tagName: 'div',
                        className:'uibar-cmdr',
                        onselectstart:'return false',
                        unselectable:'on',
                        OPT:{
                            className:'uicmd-opt',
                            style:'{optDisplay}',
                            $order:1
                        },
                        LAND:{
                            className:'uicmd-land',
                            style:'{landDisplay}',
                            $order:1
                        },
                        CLOSE:{
                            className:'uicmd-close ',
                            style:'{closeDisplay}',
                            $order:2
                        }
                    }
                },
                PANEL:{
                    $order:1,
                    tagName : 'div',
                    className:'ui-content',
                    style:'{panelDisplay}',
                    text:'{html}'+linb.UI.$childTag
                }
            }
        },
        Appearances:{
            KEY:{
                overflow:'hidden',
                background:'transparent'
            },
            'KEY BORDER':{
                zoom:linb.browser.ie6?1:null
            },
            PANEL:{
                position:'relative',
                left:0,
                top:0,
                overflow:'auto',
                zoom:linb.browser.ie6?1:null
            },

            CAPTION:{
                'font-size':'12px',
                display:'inline',
                'vertical-align':'middle'
            }
        },
        Behaviors:{
            DropableKeys:['PANEL'],
            DragableKeys:['BAR'],
            HoverEffected:{OPT:'OPT', CLOSE:'CLOSE',LAND:'LAND', TOGGLE:'TOGGLE'},
            ClickEffected:{CLOSE:'CLOSE', OPT:'OPT', LAND:'LAND', TOGGLE:'TOGGLE'},
            onSize:function(profile,e){
                var o = profile.root,w=null,h=null;
                if(e.height)h=o.height();
                if(e.width)w=o.width();
                linb.UI.$tryResize(profile, w, h);
            },
            OPT:{
                onClick:function(profile, e, src){
                    profile.boxing().onShowOptions(profile, e, src);
                }
            },
            TOGGLE:{
                onClick:function(profile, e, src){
                    profile.box._toggle(profile, !profile.properties.toggle);
                    return false;
                }
            },
            CAPTION:{
                onClick:function(profile, e, src){
                    if(!profile.onClickBar || false===profile.boxing().onClickBar(profile,src))
                        return !!linb.Event.getKey(e)[2];
                }
            },
            CLOSE:{
                onClick:function(profile, e, src){
                    var properties = profile.properties;
                    if(properties.disabled)return;
                    var instance = profile.boxing();

                    if(false===instance.beforeClose(profile)) return;

                    instance.destroy();

                    //for design mode in firefox
                    return false;
                }
            },
            LAND:{
                onClick:function(profile, e, src){
                    var properties=profile.properties;
                    if(properties.disabled)return;
                    var pos = profile.root.offset(), size=profile.root.cssSize();

                    var pro = _.copy(linb.UI.Dialog.$DataStruct);
                    _.merge(pro, properties, 'with');
                    _.merge(pro,{
                        dock:'none',
                        width:Math.max(size.width,200),
                        height:Math.max(size.height,100),
                        left:pos.left,
                        top:pos.top
                    },'all');
                    var dialog = new linb.UI.Dialog(pro),arr=[];
                    linb('body').append(dialog);

                    _.arr.each(profile.children,function(o){
                        arr.push(o[0]);
                    });
                    dialog.append(linb.UI.pack(arr,false));

                    profile.boxing().destroy();

                    //for design mode in firefox
                    return false;
                }
            }
        },
        DataModel:{
            position:'absolute',
            zIndex:0,
            dock:'fill',
            // setCaption and getCaption
            caption:{
                ini:undefined,
                // ui update function when setCaption
                action: function(value){
                    this.getSubNode('CAPTION').get(0).innerHTML = value;
                }
            },
            image:{
                action: function(value){
                    this.getSubNode('ICON')
                        .css('display',value?'':'none')
                        .css('backgroundImage','url('+(value||'')+')');
                }
            },
            imagePos:{
                action: function(value){
                    this.getSubNode('ICON')
                        .css('backgroundPosition', value);
                }
            },
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('CAPTION').attr('tabIndex',value);
                }
            },
            href:{
                ini:linb.$href,
                action:function(v){
                    if(this.domNode)
                        this.getSubNode('CAPTION').attr('href',v);
                }
            },
            html:{
                action:function(v){
                    this.getSubNode('PANEL').html(v);
                }
            },
            barHeight:{
                ini:22,
                action:function(v){
                    this.getSubNode('TB').height(v);
                    this.getSubNode('BAR').css('display',v?'':'none');
                }
            },
            toggle:{
                ini:true,
                action:function(v){
                    this.box._toggle(this, v);
                }
            },
            optBtn:{
                ini:false,
                action:function(v){
                    this.getSubNode('OPT').css('display',v?'':'none');
                }
            },
            toggleBtn:{
                ini:false,
                action:function(v){
                    this.getSubNode('TOGGLE').css('display',v?'':'none');
                }
            },
            closeBtn:{
                ini:false,
                action:function(v){
                    this.getSubNode('CLOSE').css('display',v?'':'none');
                }
            },
            landBtn:{
                ini:false,
                action:function(v){
                    this.getSubNode('LAND').css('display',v?'':'none');
                }
            }
        },
        EventHandlers:{
            beforeClose:function(profile, src){},
            onIniPanelView:function(profile){},
            onFold:function(profile){},
            onExpend:function(profile){},
            onShowOptions:function(profile, e, src){},
            onClickBar:function(profile, src){}
        },
        LayoutTrigger:function(){
            var self=this, t=self.properties, b=self.box;
            if(t.toggle)
                b._toggle(self,t.toggle);
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile);
            var nodisplay='display:none';

            data.panelDisplay = data.toggle?'':nodisplay;
            data.toggleCls = data.toggle?'':profile.getClass('TOGGLE','-checked');

            data.toggleDisplay = data.toggleBtn?'':nodisplay;
            data.optDisplay = data.optBtn?'':nodisplay;
            data.closeDisplay = data.closeBtn?'':nodisplay;
            data.landDisplay = data.landBtn?'':nodisplay;
            data.barDisplay = data.barHeight?'':nodisplay;
            return data;
        },
        _onresize:function(profile,width,height){
            if(height && parseInt(profile.domNode.style.height)){
                profile.getSubNode('BORDER').height(height);
                profile.getSubNode('PANEL').height(height-profile.properties.barHeight);
            }
            //for performance
            if(width && parseInt(profile.domNode.style.width))
                profile.getSubNode('PANEL').width(width);
        },

        _toggle:function(profile, value){
            var p=profile.properties, b=profile.boxing();
            //set toggle mark
            p.toggle = value;

            //event
            if(value &&!profile.$ini)
                if(b.onIniPanelView)
                    if(b.onIniPanelView(profile)!==false)
                        profile.$ini=true;

            if(value){
                if(false===b.onExpend(profile))return;
            }else{
                if(false===b.onFold(profile))return;
            }

            //show/hide/panel
            profile.getSubNode('PANEL').css('display',value?'':'none');
            //chang toggle button
            if(p.toggleBtn)
                profile.getSubNode('TOGGLE').tagClass('-checked', !value);
        }
    }
});
Class("linb.UI.PageBar",["linb.UI","linb.absValue"] ,{
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                if(!profile.domNode)return;
                var t,
                    prop = profile.properties,
                    arr = profile.box._v2a(value),
                    min=arr[0],
                    cur=arr[1],
                    max=arr[2],
                    keys = profile.keys,
                    fun = function(p,k){return p.getSubNode(k)},

                    first = fun(profile, 'FIRST'),
                    prev = fun(profile, 'PREV'),
                    prehide = fun(profile, 'PREM'),
                    current = fun(profile, 'CUR'),
                    next = fun(profile, 'NEXT'),
                    nexthide = fun(profile, 'NEXTM'),
                    last = fun(profile, 'LAST'),

                    change = function(n,i,j){if(i)n.attr('href',prop.uriTpl.replace('*',i));if(j)n.text(prop.textTpl.replace('*',j))},
                    display = function(n,f){n.css('display',f?'':'none')}
                    ;
                //change href and text
                change(first, min, min);
                change(prehide, '','..' + _.str.repeat('.',String(cur-1-min).length) );
                change(prev, cur-1);
                change(current, cur, cur);
                change(next, cur+1);
                change(nexthide, '','..' + _.str.repeat('.',String(max-cur-1).length) );
                change(last, max, max);

                //show or hide
                if((t=cur-min)<=0){
                    display(first,0);display(prehide,0);display(prev,0);
                }else if(t==1){
                    display(first,1);display(prehide,0);display(prev,0);
                }else if(t==2){
                    display(first,1);display(prehide,0);display(prev,1);
                }else{
                    display(first,1);display(prehide,1);display(prev,1);
                }
                if((t=max-cur)<=0){
                    display(last,0);display(nexthide,0);display(next,0);
                }else if(t==1){
                    display(last,1);display(nexthide,0);display(next,0);
                }else if(t==2){
                    display(last,1);display(nexthide,0);display(next,1);
                }else{
                    display(last,1);display(nexthide,1);display(next,1);
                }
            });
        },
        setPage:function(value){
            return this.each(function(o){
                var v=o.properties.value,
                    a=v.split(':');
                a[1]=value;
                o.boxing().setValue(a.join(':'));
            });
        }
    },
    Static:{
        Templates:{
            style:'{_style}',
            POOL:{
                style:'position:absolute;display:none;',
                POP:{
                    tagName:'div',
                    className:'ui-content'
                }
            },
            LABEL:{
                text:'{caption}'
            },
            FIRST:{
                tagName:'a',
                tabindex: '{tabindex}',
                $order:1
            },
            PREM:{
                tagName:'a',
                tabindex: '{tabindex}',
                href:'#',
                $order:2
            },
            PREV:{
                tagName:'a',
                tabindex: '{tabindex}',
                text:'{prevMark}',
                $order:3
            },
            CUR:{
                tagName:'a',
                tabindex: '{tabindex}',
                $order:4
            },
            NEXT:{
                tagName:'a',
                tabindex: '{tabindex}',
                text:'{nextMark}',
                $order:5
            },
            NEXTM:{
                tagName:'a',
                tabindex: '{tabindex}',
                href:'#',
                $order:6
            },
            LAST:{
                tagName:'a',
                tabindex: '{tabindex}',
                $order:7
            }
        },
        Appearances:{
            LABEL:{
                display:'inline',
                'white-space':'nowrap'
            },
            KEY:{
                padding: linb.browser.ie?'3px':'',
                display:'inline'
            },
            'KEY a:focus, POP a:focus':{
                '-moz-outline-offset': ''
            },
            'KEY a, POP a':{
                $order:1,
                'font-size':'12px',
                border:'solid 1px gray',
                'padding':'0 3px 0 3px',
                'vertical-align':'middle',
                margin: '3px'
            },
            'PREV,CUR,NEXT':{
                'font-weight' : 'bold'
            },
            CUR:{
                $order:1,
                background:'#316AC5',
                color:'#fff'
            },
            POP:{
                border:'dotted 1px gray',
                background:'#fff',
                position:'absolute',
                padding:'3px',
                'line-height':'22px'
            }
        },
        Behaviors:{
            POP:{
                onClick:function(profile, e, src){
                    var o=linb(src),
                        r = linb.Event.getSrc(e)
                        ;
                    o.setBlurTrigger(profile.key+":"+profile.$id, null);
                    profile.getSubNode('POOL').append(o);
                    if(r.tagName.toLowerCase()=='a')
                        return profile.box._click(profile,r);
                }
            },
            FIRST:{
                onClick:function(profile, e, src){
                    return profile.box._click(profile,src);
                }
            },
            PREM:{
                onClick:function(profile, e){return !!linb.Event.getKey(e)[2]},
                onMousedown:function(profile, e, src){
                    profile.box._show(profile,e,src,0);
                    return false;
                }
            },
            PREV:{
                onClick:function(profile, e, src){
                    return profile.box._click(profile,src);
                }
            },
            CUR:{
                onClick:function(profile, e, src){
                    return profile.box._click(profile,src);
                }
            },
            NEXT:{
                onClick:function(profile, e, src){
                    return profile.box._click(profile,src);
                }
            },
            NEXTM:{
                onClick:function(profile, e){return !!linb.Event.getKey(e)[2]},
                onMousedown:function(profile, e, src){
                    profile.box._show(profile,e,src,1);
                    return false;
                }
            },
            LAST:{
                onClick:function(profile, e, src){
                    return profile.box._click(profile,src);
                }
            }
        },
        DataModel:{
            dataField:null,
            dataBinder:null,

            caption:' Page: ',
            value:"1:1:1",
            uriTpl:"#*",
            textTpl:"*",
            prevMark:'&lt;',
            nextMark:'&gt;',
            _moreStep:100,

            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.root.query('a').attr('tabIndex',value);
                }
            }
        },
        EventHandlers:{
            onClick:function(profile, src){}
        },
        _ensureValue:function(profile,value){
            var a = value.split(':'),
                b=[],
                fun=function(a){return parseInt(a)||1};
            b[0]=fun(a[0]);
            b[1]=fun(a[1]);
            b[2]=fun(a[2]);

            b[0] = Math.max(b[0],1);
            b[0] = Math.min(b[0],b[1]);
            b[2] = Math.max(b[1],b[2]);

            return b.join(':');
        },
        _v2a:function(v){
            v = typeof v == 'string'? v.split(':') : v;
            v[0]=parseInt(v[0]);v[1]=parseInt(v[1]);v[2]=parseInt(v[2]);
            return v;
        },
        _click:function(profile, src){
            var r = profile.boxing().onClick(profile, src);
            return typeof r=="boolean"?r:false;
        },
        _show:function(profile, e, src, flag){
            var prop = profile.properties,
                arr = profile.box._v2a(prop.value),
                min=arr[0],
                cur=arr[1],
                max=arr[2],

                keys = profile.keys,
                fun = function(p,k){return p.getSubNode(k)},
                pool = fun(profile, 'POOL'),
                pop = fun(profile, 'POP'),
                ceil = function(n){return Math.ceil((n+1)/10)*10},
                a=[],
                t,m,n,i,l
                ;

            if(flag){
                if((t=max-1-cur)<=0)return;
                n=cur + 1;
                l=max;
            }else{
                if((t=cur-1-min)<=0)return;
                n=1;
                l=cur-1;
            }
            m=Math.ceil(t/prop._moreStep);
            if(m>10){
                n=ceil(n);
                l=ceil(l)-1;
                m=ceil(m);
            }else
                n=n+m;
            while(n<l){
                a.push('<a href="'+prop.uriTpl.replace('*',n)+'">'+prop.textTpl.replace('*',n)+'</a>')
                n=n+m;
            }
            pop.width('auto');
            pop.html(a.join(' '));
            linb('body').append(pop);
            if(pop.width()>300)pop.width(300);
            pop.popToTop(src);
            pop.setBlurTrigger(profile.key+":"+profile.$id, function(){
                pool.append(pop);
            });
        }
    }
});
Class("linb.UI.Tabs", ["linb.UI", "linb.absList","linb.absValue"],{
    Instance:{
        _setCtrlValue:function(value){
            this.each(function(profile){
                var id=profile.domId,
                    box = profile.boxing(),
                    uiv = box.getUIValue(),
                    properties = profile.properties,
                    itemId = profile.getSubIdByItemId(uiv),
                    temp,t
                    ;
                    if(uiv && profile.getSubIdByItemId(uiv)){
                        profile.getSubNodes(['ITEM','BOX'],itemId).tagClass('-checked',false);

                        if(box.KEY!='linb.UI.Tabs'||properties.hasPanel)
                            // hide pane
                            box.getPanel(uiv).hide();
                    }
                    itemId = profile.getSubIdByItemId(value);
                    if(itemId){
                        profile.getSubNodes(['ITEM','BOX'],itemId).tagClass('-checked');
                        if(box.KEY!='linb.UI.Tabs'||properties.hasPanel){
                            // show pane
                            box.getPanel(value).show('auto',profile.getSubNode('LIST').offsetHeight()+'px');
                            t=profile.root.cssSize();
                            //reset width and height
                            linb.UI.$tryResize(profile, parseInt(t.width)||null, parseInt(t.height)||null, value);

                            //dynamic render
                            if(properties.dynRender){
                                var arr=profile.children,a=[];
                                _.arr.each(arr,function(o){
                                    if(o[1]==value && !o[0]['parent:'+profile.$id]){
                                        a.push(o[0]);
                                        o[0]['parent:'+profile.$id]=1;
                                    }
                                });
                                if(a.length)
                                    box.append(linb.UI.pack(a),value);
                            }
                        }
                    }
            });
        },
        append:function(target,subId){
            var p=this.get(0).properties;
            if(subId=subId||p.$UIvalue||p.value)
                arguments.callee.upper.call(this, target, subId);
            return this;
        },
        getCurPanel:function(){
            var profile = this.get(0);
            return this.getPanel(profile.properties.$UIvalue);
        },
        // get pane in page views
        getPanel:function(subId){
            var profile = this.get(0);
            return profile.getSubNodeByItemId('PANEL', subId);
        },
        ////
        addPanel:function(para, children, item){
            var i={}, id = item&&item.id;
            if(!id){
                var items = this.getItems();
                if(items.length)
                    id = items[items.length-1].id;
            }

            _.merge(i, {
                caption:para.caption,
                image:para.image,
                closeBtn:para.closeBtn || false,
                landBtn:para.landBtn || false,
                optBtn:para.optBtn || false,
                imagePos:para.imagePos,
                dragKey:para.dragKey,
                dropKeys:para.dropKeys,
                id : para.id || para.tag || _.id()
            });

            this.insertItems([i], id);
            var arr=[];
            _.arr.each(children,function(o){
                arr.push(o[0]);
            });
            this.append(linb.UI.pack(arr,false), i.id);
        },
        removePanel:function(domId){
            var self=this,
                item = self.getItemByDom(domId);
            return self.removeItems([item.id]);
        },
        getPanelPara:function(domId){
            var profile=this.get(0),
                pp=profile.properties,
                item = profile.getItemByDom(domId),
                para = _.clone(item);
            if(!para.dragKey)para.dragKey=pp.dragKey;
            if(!para.dropKeys)para.dropKeys=pp.dropKeys;
            return para;
        },
        getPanelChildren:function(domId){
            var profile=this.get(0),
                id = profile.getItemIdByDom(domId),
                arr=[];
            if(id)
                _.arr.each(profile.children,function(o){
                    if(o[1]==id)arr.push(o);
                });
            return arr;
        },

        ////
        fireItemClickEvent:function(subId){
            var profile = this.get(0),
            //fire dom event
                node =profile.getSubNodeByItemId('ITEM', subId);

            //no this one, set to null
            if(node.isEmpty()){
                profile.boxing().setUIValue(null);
            }else
                node.onMousedown();
            return this;
        },
        /* insert some views to pageView widgets
            arr: hash(view properties) or array of hash
            before: views will insert before it, string
        */
        _afterInsertItems:function(profile, data, base, before){
            var box=profile.box,obj,v,pp=profile.properties;
            if(pp.hasPanel && (obj=profile.root)){
                obj.append(_.str.toDom(profile.buildItems('panels', data)));

                if(!(v=this.getUIValue()))
                    this.fireItemClickEvent((v=pp.items[0]) && (v=v.id));

                var t=profile.domNode.style;

                linb.UI.$tryResize(profile, parseInt(t.width)||null, parseInt(t.height)||null, v);
            }
        },
        /*  remove some views from pageView
            arr: array for id
        */
        removeItems:function(arr){
            var self=this,
                obj,serialId;
            if(!_.isArr(arr))arr=[arr];

            self.each(function(profile){
                if(profile.properties.hasPanel)
                    _.arr.each(arr,function(o){
                        // get ui serial id
                        serialId=profile.getSubIdByItemId(o);
                        if(serialId && !(obj = profile.getSubNode('PANEL', serialId) ).isEmpty() ){
                            // remove ui
                            obj.remove();
                        }
                    });
            });
            arguments.callee.upper.apply(self,arguments);

            self.each(function(profile){
                if(profile.properties.hasPanel){
                    if(_.arr.indexOf(arr,profile.boxing().getUIValue())!=-1){
                        var i;
                        profile.boxing().fireItemClickEvent((i=profile.properties.items[0]) && i.id);
                    }
                    linb.UI.$tryResize(profile, profile.root.width(), profile.root.height(), profile.boxing().getUIValue());
                }
            });

            return self;
        },
        clearItems:function(){
            var self=this;
            self.each(function(profile){
                if(profile.properties.hasPanel)
                    profile.getSubNode('PANEL',true).remove();
            });
            self.setValue(null,true);
            arguments.callee.upper.apply(self,arguments);
            return self;
        },
        markItemCaption:function(subId, mark, force){
            var profile = this.get(0);
            subId=profile.getItemByItemId(subId);

            if((subId._dirty !=mark) || force){
                var id = subId.id,
                    caption = profile.getItemByItemId(id).caption;
                profile.getSubNodeByItemId('CAPTION', id).html(
                    profile.getItemByItemId(id).caption=mark?('*'+caption):caption.replace(/^\*/,'')
                ).css('fontStyle',mark?'italic':'normal');
                subId._dirty=mark;
            }
            return this;
        }
    },
    Static:{
        Templates:{
            tagName : 'div',
            style:'{_style};',
            LIST:{
                $order:0,
                tagName : 'div',
                ITEMS:{
                    tagName : 'div',
                    text:"{items}",
                    style:'{HAlign}'
                }
            },
            PNAELS:{
                $order:1,
                tagName:'text',
                text:'{panels}'
            },
            $dynamic:{
                items:{
                    ITEM:{
                        className:'{itemClass}',
                        style:'{itemStyle}',
                        BOX:{
                            HANDLE:{
                                tagName: 'a',
                                href :"{href}",
                                tabindex: '{_tabindex}',
                                IBWRAP:{
                                    tagName:'div',
                                    style:"white-space:nowrap;",
                                    RULER:{},
                                    ICON:{
                                        style:'background:url({image}) transparent  no-repeat {imagePos};{iconDisplay}',
                                        className:'ui-icon',
                                        $order:0
                                    },
                                    CAPTION:{
                                        text: '{caption}',
                                        $order:1
                                    },
                                    CMDS:{
                                        $order:2,
                                        OPT:{
                                            $order:1,
                                            className:'uicmd-opt',
                                            style:'{_opt}'
                                        },
                                        LAND:{
                                            className:'uicmd-land',
                                            style:'{landDisplay}',
                                            $order:1
                                        },
                                        CLOSE:{
                                            className:'uicmd-close ',
                                            style:'{closeDisplay}',
                                            $order:2
                                        }
                                    }
                                }
                            }
                        }
                    }
                },
                panels:{
                    PANEL:{
                        tagName : 'div',
                        className:'ui-content',
                        text:linb.UI.$childTag
                    }
                }
            }
        },
        Appearances:{
            KEY:{
                position:'absolute',
                overflow:'hidden'
            },
            LIST:{
                position:'relative'
            },
            ITEMS:{
                'padding-left':'4px',
                'padding-right':'4px',
                position:'relative',
                background: linb.UI.$bg('dot.gif', ' repeat-x center bottom', true)
            },
            ITEM:{
                $order:0,
                'font-family': '"Verdana", "Helvetica", "sans-serif"',
                cursor:'pointer',
                'padding-right':'6px',
                'vertical-align':'top',
                'border-bottom':'1px solid #91A7B4',
                background: linb.UI.$bg('top.gif', ' no-repeat right top')
            },
            'ITEM-mouseover':{
                $order:1,
                'background-position' : 'right -100px'
            },
            'ITEM-mousedown':{
                $order:2,
                'background-position' : 'right -200px',
                'border-bottom':'1px solid #fff'
            },
            'ITEM-checked':{
                $order:3,
                'background-position' : 'right -200px',
                'border-bottom':'1px solid #fff'
            },
            BOX:{
                $order:0,
                padding:'6px 0 2px 6px',
                border:0,
                //keep this same with ITEM
                'vertical-align':'top',
                'text-align': 'center',
                background: linb.UI.$bg('top.gif', ' no-repeat left -50px')
            },
            'BOX-mouseover':{
                $order:1,
                'background-position' : 'left -150px'
            },
            'BOX-mousedown':{
                $order:2,
                'background-position' : 'left -250px'
            },
            'BOX-checked':{
                $order:3,
                'background-position' : 'left -250px'
            },
            HANDLE:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                cursor:'pointer',
                'vertical-align':'middle',
                'font-size':'12px'
            },
            RULER:{
                height:'18px',
                width:'1px',
                'vertical-align':'middle'
            },
            PANEL:{
                position:'absolute',
                visibility:'hidden',
                top:'-10000px',
                left:'-10000px',
                width:'100%',
                overflow:'auto'
            },
            CAPTION:{
                'vertical-align':'middle'
            },
            CMDS:{
                'vertical-align':'top'
            },
            'CMDS  span':{
                'margin-left':'4px'
            }
        },
        Behaviors:{
            DropableKeys:['PANEL','KEY', 'ITEM'],
            DragableKeys:['ITEM'],
            HoverEffected:{ITEM:['ITEM','BOX'],OPT:'OPT',CLOSE:'CLOSE',LAND:'LAND'},
            ClickEffected:{ITEM:['ITEM','BOX'],OPT:'OPT',CLOSE:'CLOSE',LAND:'LAND'},
            onSize:function(profile,e){
                var o = profile.domNode.style,w=null,h=null;
                if(e.height)h = parseInt(o.height)||null;
                if(e.width)w = parseInt(o.width)||null;
                linb.UI.$tryResize(profile, w, h, profile.properties.$UIvalue);
            },
            OPT:{
                onMousedown:function(){
                    return false;
                },
                onClick:function(profile, e, src){
                    profile.boxing().onShowOptions(profile, profile.getItemByDom(src), e, src);
                    return false;
                }
            },
            CAPTION:{
                onMousedown:function(profile, e, src){
                    if(linb.Event.getBtn(e)!='left')return;
                    var properties = profile.properties,
                        item = profile.getItemByDom(src),
                        box = profile.boxing();

                    if(properties.disabled)return false;
                    if(box.getUIValue() == item.id){
                         if(profile.onCaptionActive)
                            profile.boxing().onCaptionActive(profile, profile.getItemByDom(src), src);
                    }
                }
            },
            ITEM:{
                onClick:function(profile, e, src){
                    return false;
                },
                onMousedown:function(profile, e, src){
                    if(linb.Event.getBtn(e)!='left')return false;
                    if(profile.getKey(linb.Event.getSrc(e).parentNode.id)==profile.keys.CMDS)return false;

                    var properties = profile.properties,
                        itemId = profile.getSubId(src.id),
                        item = profile.getItemByDom(src),
                        box = profile.boxing();

                    if(properties.disabled)return false;
                    if(box.getUIValue() == item.id)return;

                    //for some input onblur event
                    profile.getSubNode('HANDLE', itemId).focus();

                    box.setUIValue(item.id);

                    //if success
                    if(box.getUIValue() == item.id){
                        box.onItemSelected(profile, item, src);
                        return false;
                    }
                }
            },
            HANDLE:{
                onClick:function(profile, e, src){
                    return !!linb.Event.getKey(e)[2];
                },
                onKeydown:function(profile, e, src){
                    var keys=linb.Event.getKey(e), key = keys[0], shift=keys[2];
                    if(key==' '||key=='enter'){
                        profile.getSubNode('ITEM',profile.getSubId(src.id)).onMousedown();
                        return false;
                    }

                    var cur = linb([src]),
                    target = profile.getSubNode('ITEMS'),
                    first = target.nextFocus(true, true, false),
                    last = target.nextFocus(false, true, false);

                    switch(key){
                        case 'tab':
                            if(shift){
                                if(src!=first.get(0)){
                                    first.focus();
                                    return false;
                                }
                            }else{
                                if(src!=last.get(0)){
                                    last.focus();
                                    return false;
                                }
                            }
                            break;
                        case 'left':
                        case 'up':
                            var next = cur.nextFocus(false, true, false);
                            if(cur.get(0)==first.get(0))
                                last.focus();
                            else
                                cur.nextFocus(false);
                            return false;
                            break;
                        case 'right':
                        case 'down':
                            var next = cur.nextFocus(true, false, false);
                            if(cur.get(0)==last.get(0))
                                first.focus();
                            else
                                cur.nextFocus();
                            return false;
                            break;
                    }
                }
            },
            CLOSE:{
                onMousedown:function(){
                    return false;
                },
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        item = profile.getItemByDom(src),bak;

                    if(properties.disabled)return;
                    var instance = profile.boxing();

                    if(false===instance.beforePageClose(profile, item, src)) return;

                    bak=_.copy(item);

                    instance.removeItems(item.id);

                    instance.afterPageClose(profile, bak);

                    linb.UI.$tryResize(profile, profile.root.width(), profile.root.height(), properties.$UIvalue);
                    //for design mode in firefox
                    return false;
                }
            },
            LAND:{
                onMousedown:function(){
                    return false;
                },
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        item = profile.getItemByDom(src),
                        id=item.id;

                    if(properties.disabled)return;

                    var panel = profile.boxing().getPanel(id),
                        pos = profile.root.offset(),
                        size=profile.root.cssSize(),
                        pro = _.copy(linb.UI.Dialog.$DataStruct);
                    _.merge(pro, item, 'with');
                    _.merge(pro,{
                        dragKey: item.dragkey || properties.dragKey ,
                        dock:'none',
                        tag:item.tag||item.id,
                        width:Math.max(size.width,200),
                        height:Math.max(size.height,100),
                        left:pos.left,
                        top:pos.top
                    },'all');
                    var dialog = new linb.UI.Dialog(pro);
                    linb('body').append(dialog);

                    var arr=[];
                    _.arr.each(profile.children,function(o){
                        if(o[1]==id)
                            arr.push(o[0]);
                    },null,true);

                    if(arr.length)
                        dialog.append(linb.UI.pack(arr,false));

                    profile.boxing().removeItems(id);

                    //for design mode in firefox
                    return false;
                }
            }
        },
        DataModel:{
            dataBinder:null,
            dataField:null,

            dock:'fill',
            hasPanel:true,
            width:200,
            height:200,
            position:'absolute',
            HAlign:{
                ini:'left',
                listbox:['left','center','right'],
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('ITEMS').css('textAlign',value);
                }
            },
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('HANDLE',true).attr('tabIndex',value);
                }
            },
            dynRender:true,
            dropKeysPanel:'',
            value:{
                ini:''
            },
            //use ilist defualt items
            items:{
                set:function(value){
                    return this.each(function(o){
                        if(o.domNode){
                            var box = o.boxing(),
                                p,
                                temp = linb.Dom.getEmptyDiv(),
                                children = _.copy(o.children);
                            o.children.length=0;
                            _.arr.each(children,function(o){
                                //for flush dock
                                delete o[0].$dockParent;
                                //keep it in dom
                                temp.append(o[0].root);
                            });

                            //bak value
                            var bv = o.properties.value;

                            //clear all
                            box.clearItems();
                            //call gc to clear onresize setting
                            linb.Dom.__gc();

                            //inset items
                            box.insertItems(value);

                            //restore children
                            _.arr.each(children,function(v){
                                box.append.apply(box,v);
                            });

                            //clear
                            temp.empty();

                            //set value
                            box.setValue(bv,true);

                            //resize
                            var size = o.root.cssSize();
                            linb.UI.$tryResize(o, size.width, size.height, o.properties.$UIvalue);
                        }else
                            o.properties.items = value;
                    });
                }
            }
        },
        EventHandlers:{
            beforePageClose:function(profile, item, src){},
            afterPageClose:function(profile, item){},
            onShowOptions:function(profile,item,e,src){},
            onItemSelected:function(profile, item, src){},
            onCaptionActive:function(profile, item, src){}
        },
        RenderTrigger:function(){
            var self=this,v,i,ins;
            // set default value
            if(v=self.properties.value){
                (ins=self.boxing()).setUIValue(v);
                if(i=self.getItemByItemId(v))
                    ins.onItemSelected(self, i);
            }
        },
        _getChildren:function(profile){
            if(!profile.properties.dynRender)
                return profile.children;
        },
        _prepareData:function(profile){
            var data = arguments.callee.upper.call(this, profile);
            data.panels = data.items;
            data.HAlign = 'text-align:'+data.HAlign+';';
            return data;
        },
        _prepareItem:function(profile, item){
            var dpn = 'display:none';
            item.closeDisplay = item.closeBtn?'':dpn;
            item.landDisplay = item.landBtn?'':dpn;
            item._opt = item.optBtn?'':dpn;
            item.href = item.href || linb.$href;
        },
        getDropKeys:function(profile,node){
            return profile.properties[profile.getKey(node.id)==profile.keys.PANEL?'dropKeys':'dropKeysPanel'];
        },
        _showTips:function(profile, node, pos){
            var id=node.id,
                p=profile.properties,
                keys=profile.keys,
                key=profile.getKey(id);
            if(!id)return false;

            if(profile.onShowTips)
                return profile.boxing().onShowTips(profile, node, pos);
            else
                return arguments.callee.upper.apply(this,arguments);
        },
        //for tabs only
        _onresize:function(profile,width,height,key){
            var t=profile.properties,
                o = profile.boxing().getPanel(key),
                item = profile.getItemByItemId(key),
                l=profile.getSubNode('LIST'),
                forceH=0,
                listH;
            ;
            if(!o || o.isEmpty())return;

            //no height set
            if(!parseInt(profile.domNode.style.height))
                height=null;

            var wc=null,hc=null;
            if(width && item._w!=width){
                height=profile.domNode.offsetHeight || profile.getRoot().offsetHeight();
                forceH=1;
            }
            if((height && item._h!=height) || forceH){
                item._h=height;
                listH = l.get(0).offsetHeight ||
                    //for opear 9.0 get height bug, get offsetheight in firefox is slow
                    l.offsetHeight();

                height = height-listH+(linb.browser.ie6?2:1);
                if(height>0)hc=height;
            }
            if(listH)o.top(listH);
            //force to trigger onSze event, whatever width or height was changed.
            if(hc)o.height(hc).onSize();
        }
    }
});Class("linb.UI.Stacks", "linb.UI.Tabs",{
    Static:{
        Appearances:{
            KEY:{
                overflow:'visible'
            },
            LIST:{
                position:'static'
            },
            ITEMS:{
                position:'static'
            },
            ITEM:{
                $order:0,
                display:'block',
                position:'absolute',
                cursor:'pointer',
                background: linb.UI.$bg('barvbg.gif', ' repeat-x left top', true),
                height:'22px',
                width:'100%',
                left:0
            },
            BOX:{
                display:'block'
            },
            'ITEM-mouseover':{
                $order:1,
                'background-position' : 'right -22px'
            },
            'ITEM-mousedown':{
                $order:1,
                'background-position' : 'right -44px'
            },
            'ITEM-checked':{
                $order:1,
                'background-position' : 'right -44px'
            },
            HANDLE:{
                cursor:'pointer',
                display:'block',
                'font-size':'12px',
                height:'100%',
                'padding-left':'6px',
                'white-space':'nowrap'
            },
            CAPTION:{
                margin: '2px'
            },
            PANEL:{
                position:'absolute',
                visibility:'hidden',
                top:'-10000px',
                left:'-10000px',
                overflow:'auto'
            },
            CMDS:{
                position:'absolute',
                top:'3px',
                right:'2px',
                'text-align':'right',
                'vertical-align': 'middle'
            }
        },
        _onresize:function(profile,width,height,key){
            var t=profile.properties, temp,t1,t2,obj,top,
                wc=null,hc=null,
                o = profile.boxing().getPanel(key);
            if(!o || o.isEmpty())return;

            // change value
            if(height){
                t2=t1=0;
                _.arr.each(t.items,function(o){
                    obj = profile.getSubNodeByItemId('ITEM', o.id);
                    obj.cssRegion({bottom:'auto',top:t1});

                    // offsetHeight maybe not set here
                    t1 += obj.height();
                    if(o.id == key)return false;
                });
                _.arr.each(t.items,function(o){
                    if(o.id == key)return false;
                    obj = profile.getSubNodeByItemId('ITEM', o.id);
                    obj.cssRegion({top:'auto',bottom:t2});
                    t2+= obj.height();
                },null,true);

                temp = height - t1 - t2;
                if(temp>0){
                    top=t1;
                    hc=temp;
                }
            }
            if(width)wc=width;

            o.cssRegion({width:wc?wc:null,height:hc?hc:null,top:top,left:0},true);
            if(wc)profile.getSubNode('LIST').width(wc);
        }
    }
});
Class("linb.UI.ButtonViews", "linb.UI.Tabs",{
    Static:{
        Appearances:{
            LIST:{
                'z-index':'2',
                position:'absolute',
                'background-color': '#EBEADB'
            },
            ITEMS:{
                'z-index':'2',
                position:'absolute',
                left:0,
                top:0
            },
            ITEM:{
                margin:'2px',
                position:'relative'
            },
            'ITEM-checked':{
                //clear tabs ITEM-checked
            },
            LEFT:{
                'border-right': '1px solid #A7A6AA'
            },
            RIGHT:{
                'border-left': '1px solid #A7A6AA'
            },
            TOP:{
                'border-bottom': '1px solid #A7A6AA'
            },
            BOTTOM:{
                'border-top': '1px solid #A7A6AA'
            },
            BOX:{
                $order:0,
                border:'solid 1px #cdcdcd',
                'vertical-align':'top'
            },
            'BOX-mouseover':{
                $order:1,
                'background-color':'#FFFFE0'
            },
            'BOX-mousedown, BOX-checked':{
                $order:2,
                'border-color':'#A7A6AA #FFF #FFF #A7A6AA',
                'background-color':'#C4C4C4'
            },
            HANDLE:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                cursor:'pointer',
                'vertical-align':'middle',
                'font-size':'12px',
                margin:'1px'
            }
        },
        DataModel:{
            barLocation:{
                ini:'top',
                listbox:['top','bottom','left','right'],
                action:function(v){
                    var self=this,
                        hs = self.getSubNode('LIST'),
                        h = self.getSubNode('ITEM',true),
                        b = self.getSubNode('BOX',true);
                    switch(v){
                        case 'left':
                        case 'top':
                            hs.cssRegion({left:0,top:0,right:'auto',bottom:'auto'});
                        break;
                        case 'right':
                        case 'bottom':
                            hs.cssRegion({left:'auto',top:'auto',right:0,bottom:0});
                       break;
                    }
                    switch(v){
                        case 'left':
                        case 'right':
                            h.css('display','block');
                            b.css('display','block');
                            break;
                        case 'top':
                        case 'bottom':
                            h.setInlineBlock();
                            b.setInlineBlock();
                            hs.height('auto');
                            break;
                    }
                    self.boxing().setBarSize(self.properties.barSize,true);
                }
            },
            barHAlign:{
                ini:'left',
                listbox:['left','center', 'right'],
                action:function(v){
                    var hl = this.getSubNode('ITEMS');
                    hl.css('textAlign',v);
                }
            },
            barVAlign:{
                ini:'top',
                listbox:['top','bottom'],
                action:function(v){
                    var hl = this.getSubNode('ITEMS');
                    if(v=='top')
                        hl.cssRegion({top:0,bottom:'auto'});
                    else
                        hl.cssRegion({bottom:0,top:'auto'});
                }
            },
            barSize:{
                ini:50,
                action:function(v){
                    var self=this,
                        t=self.properties,
                        hs = self.getSubNode('LIST'),
                        hl = self.getSubNode('ITEMS');
                    if(t.barLocation=='left'||t.barLocation=='right'){
                        hs.merge(hl).width(v);
                    }else{
                        hs.height(v);
                    }
                    linb.UI.$tryResize(self,self.root.width(), self.root.height(), self.properties.$UIvalue );
                }
            }
        },
        LayoutTrigger:function(){
            var pro = this.properties;
            this.boxing().setBarLocation(pro.barLocation,true)
            .setBarHAlign(pro.barHAlign,true)
            .setBarVAlign(pro.barVAlign,true);
        },
        _onresize:function(profile,width,height,key){
            var o = profile.boxing().getPanel(key),
                t=profile.properties,  top, left,
                hs = profile.getSubNode('LIST'),
                hl = profile.getSubNode('ITEMS'),
                wc=null,hc=null;

            if(t.barLocation=='top'||t.barLocation=='bottom'){
                if(width){
                    hs.width(width);
                    hl.width(width);
                    left = 0;
                    wc=width;
                }
                if(height-t.barSize>0)hc=height-t.barSize;
                top = t.barLocation=='top'?t.barSize:0;
            }else{
                if(height){
                    hs.height(height);
                    top=0;
                    hc=height;
                }
                if(width){
                    left = t.barLocation=='left'?t.barSize:0;
                    wc=width-t.barSize;
                }
            }
            if(o && !o.isEmpty())o.cssRegion({width:wc?wc:null,height:hc?hc:null,left:left,top:top},true);
        }
    }
});Class("linb.UI.RadioBox", "linb.UI.List",{
    Initialize:function(){
        //modify default template for shell
        var t = this.getTemplate();
        t.$dynamic={
            items:{
                ITEM:{
                    className:'{itemClass}',
                    style:'{itemStyle}',
                    tagName: 'a',
                    href :linb.$href,
                    tabindex: '{_tabindex}',
                    MARK:{
                        $order:0
                    },
                    ICON:{
                        style:'background:url({image}) transparent  no-repeat {imagePos};{iconDisplay}',
                        className:'ui-icon',
                        $order:1
                    },
                    CAPTION:{
                        text : '{caption}',
                        $order:2
                    }
                }
            }
        };
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            ITEM:{
               display:linb.$inlineBlock,
               zoom:linb.browser.ie6?1:null,
               'font-family':' "Verdana", "Helvetica", "sans-serif"',
               border:0,
               margin:'2px',
               padding:'0 0 0 4px',
               position:'relative',
               zoom:linb.browser.ie?1:null,
               cursor:'pointer',
               overflow:'hidden',
               'vertical-align':'middle',
               'font-size':'12px'
            },
            'ITEM-checked':{},
            MARK:{
               cursor:'pointer',
               width:'16px',
               height:'16px',
               'vertical-align':'middle',
               background: linb.UI.$bg('cmds.gif', ' no-repeat -144px top', true)
           },
           'ITEM-mouseover MARK':{
                $order:1,
                'background-position':' -144px -17px'
           },
           'ITEM-mousedown MARK':{
                $order:2,
                'background-position':' -144px -34px'
           },
           'ITEM-checked MARK':{
                $order:3,
                'background-position':' -128px top'
           },
           'ITEM-checked-mouseover MARK':{
                $order:4,
                'background-position':' -128px -17px'
           },
           'ITEM-checked-mousedown MARK':{
                $order:5,
                'background-position':' -128px -34px'
            },
            CAPTION:{
                'vertical-align':'middle'
            },
            ITEMS:{
                overflow:'auto',
                'overflow-x': (linb.browser.ie || linb.browser.gek)?'hidden':'',
                position:'relative',
                'line-height':'14px',
                background: 'url('+linb.ini.file_bg+') no-repeat left top'
            }
        }
    }
});
Class("linb.UI.FoldingList", ["linb.UI.List"],{
    Instance:{
        fillContent:function(id, obj){
            var profile=this.get(0),t,item;
            if(profile.domNode){
                if(item=profile.getItemByItemId(id)){                    
                    t=profile.getSubNodeByItemId('BODYI',id).html('');
                    if(obj){
                        item._obj = obj;
                        item._fill=true;
                        if(typeof obj=='string')t.html(obj);
                        else t.append(obj.render(true));
                    }else
                        item._obj=item._fill=null;
                }
            }
            return this;
        },
        toggle:function(id){
            var profile=this.get(0);
            if(profile.domNode){
                var properties = profile.properties,
                    items=properties.items,
                    item = profile.getItemByItemId(id),
                    subId = profile.getSubIdByItemId(id),
                    node = profile.getSubNode('ITEM',subId),
                    toggle = profile.getSubNode('TOGGLE',subId),
                    nodenext = node.next(),t
                    ;
                if(item._show){
                    if(properties.activeLast && items.length)
                        if(items[items.length-1].id==item.id)
                            return false;
    
                    node.tagClass('-checked',false);
                    toggle.tagClass('-checked',false);
                    if(nodenext)
                        nodenext.tagClass('-prechecked',false);
                }else{
                    node.tagClass('-checked');
                    toggle.tagClass('-checked');
                    if(nodenext)
                        nodenext.tagClass('-prechecked');
                    //fill value
                    if(!item._fill){
                        var callback=function(o){
                            profile.boxing().fillContent(item.id, item._body=o);
                        };
                        if(profile.onGetContent)
                            linb.Thread.observableRun(
                                function(threadId){
                                    var r = profile.boxing().onGetContent(profile, item, callback, threadId);
                                    if(r) callback(r);
                                }
                            );
                        else
                            callback(profile.box._buildBody(profile, item));
                    }
                }
                item._show=!item._show
             }
            return this;
        }
    },
    Initialize:function(){
        //modify default template fro shell
        var t = this.getTemplate();
        t.$dynamic={
            items:{
                ITEM:{
                    tagName : 'div',
                    className:'{_checked} {_precheked} {itemClass}',
                    style:'{itemStyle}',
                    HEAD:{
                        tagName : 'div',
                        HL:{tagName : 'div'},
                        HR:{tagName : 'div'},
                        TITLE:{
                            tagName : 'a',
                            href:linb.$href,
                            TLEFT:{
                                $order:0,
                                tagName:'div',
                                TOGGLE:{
                                    $order:0,
                                    className:'uicmd-toggle {_tlgchecked}'
                                },
                                CAP1:{
                                    $order:1,
                                    text:'{title}'
                                }
                            },
                            TRIGHT:{
                                $order:1,
                                tagName:'div',
                                style:'{_capDisplay}',
                                CAP2:{
                                    $order:0,
                                    text:'{caption}'
                                },
                                OPT:{
                                    $order:1,
                                    className:'uicmd-opt',
                                    style:'{_opt}'
                                }
                            }/*,
                            TCLEAR:{
                                $order:2,
                                tagName:'div'
                            }*/
                        }
                    },
                    BODY:{
                        $order:1,
                        tagName : 'div',
                        className:'ui-content',
                        BODYI:{
                            $order:0,
                            tagName : 'div',
                            text:'{_body}'
                        },
                        CMDS:{
                            $order:1,
                            tagName : 'div',
                            text:"{cmds}"
                        }
                    },
                    TAIL:{
                        $order:4,
                        tagName : 'div',
                        TL:{tagName : 'div'},
                        TR:{tagName : 'div'}
                    }
                }
            },
            'items.cmds':{
                $order:2,
                CMD:{
                    //tagName:'button',
                    tagName:'a',
                    href:linb.$href,
                    text:'{caption}'
                }
            }
        };
        this.setTemplate(t);
    },
    Static:{
        Appearances:{
            KEY:{
                padding:'2px'
            },
            ITEMS:{
                border:0,
                position:'relative',
                zoom:linb.browser.ie?1:null,
                'padding-top':'8px'//,
                //for ie6 1px bug,  HR/TR(position:absolute;right:0;)
                //'margin-right':linb.browser.ie6?'expression(this.parentNode.offsetWidth?(this.parentNode.offsetWidth-(parseInt(this.parentNode.style.paddingLeft)||0)-(parseInt(this.parentNode.style.paddingRight)||0) )%2+"px":"auto")':null
            },
            ITEM:{
                border:0,
                //for ie6 bug
                zoom:linb.browser.ie?1:null,
                'margin-top':'-9px',
                padding:0,
                'font-family': '"Verdana", "Helvetica", "sans-serif"',
                position:'relative',
                overflow:'hidden'
            },
            'HEAD, BODY, BODYI, TAIL':{
                position:'relative'
            },

            CMDS:{
                padding:'2px 8px 4px 14px',
                'font-weight':'bold',
                position:'relative',
                background: linb.UI.$bg('l.gif', 'repeat-y left top #EEE')
            },
            CMD:{
                margin:'2px 4px 2px 4px',
                padding:'0 3px 0 3px'
            },
            BODY:{
                display:'none',
                'border-right': 'solid 1px #CCC',
                zoom:linb.browser.ie?1:null,
                position:'relative',
                overflow:'auto',
                background: linb.UI.$bg('l.gif', 'repeat-y left top')
            },
            BODYI:{
                padding:'2px 8px 0 8px',
                background: linb.UI.$bg('l.gif', 'repeat-y left top'),
                position:'relative'
            },
            'ITEM-checked':{
                $order:2,
                'margin-bottom':'12px'
             },
            'ITEM-checked BODY':{
                $order:2,
                display:'block'
            },
            'HL, HR, TL, TR':{
                position:'absolute',
                '_font-size':0,
                '_line-height':0,
                width:'8px'
            },
            'HL, HR':{
                height:'30px'
            },
            'ITEM-prechecked HL':{
                'background-position': 'left top'
            },
            'ITEM-prechecked HR':{
                'background-position': 'right top'
            },
            'TL, TR':{
                height:'20px'
            },
            HL:{
                top:0,
                left:0,
                background: linb.UI.$bg('corner.gif', ' no-repeat left -37px')
            },
            HR:{
                top:0,
                right:0,
                background: linb.UI.$bg('corner.gif', ' no-repeat right -37px')
            },
            TL:{
                bottom:0,
                left:0,
                background: linb.UI.$bg('corner.gif', ' no-repeat left bottom')
            },
            TR:{
                bottom:0,
                right:0,
                background: linb.UI.$bg('corner.gif', ' no-repeat right bottom')
            },
            HEAD:{
                position:'relative',
                zoom:linb.browser.ie?1:null,
                background: linb.UI.$bg('t.gif', '#fff repeat-x left top'),
                overflow:'hidden'
            },
            TITLE:{
                $order:1,
                height:'24px',
                display:'block',
                position:'relative',
                'white-space':'nowrap',
                overflow:'hidden'
            },
            TAIL:{
                '_font-size':0,
                '_line-height':0,
                position:'relative',
                height:'5px',
                background: linb.UI.$bg('b.gif', ' repeat-x left bottom #EEE')
            },
            'CAP1, CAP2':{
                padding:'3px'
            },
            CAP1:{
                color:'#666',
                'white-space':'nowrap',
            	font: 'bold 12px arial,sans-serif',
            	color: '#00681C'
            },
            'ITEM-checked CAP1':{
                $order:2,
                'font-weight':'normal'
            },
            TLEFT:{
                //position:linb.browser.ie6?'relative':null,
                //'float':'left',
                position:'absolute',
                left:'4px',
                top:'2px',

                'white-space':'nowrap',
                overflow:'hidden'
            },
            TRIGHT:{
                //position:linb.browser.ie6?'relative':null,
                //'float':'right',

                position:'absolute',
                right:'4px',
                top:'2px',

                'white-space':'nowrap',
                overflow:'hidden'
            }
        },
        Behaviors:{
            HoverEffected:{ITEM:null,HEAD:'HEAD',OPT:'OPT'},
            ClickEffected:{ITEM:null,HEAD:'HEAD'},
            ITEM:{onClick:null,onKeydown:null},
            HEAD:{
                onClick:function(profile, e, src){
                    profile.boxing().toggle(profile.getItemIdByDom(src));
                    return false;
                }
            },
            CMD:{
                onClick:function(profile,e,src){
                    if(profile.onClickButton)
                        profile.boxing().onClickButton(profile,profile.getItemByDom(src.parentNode),src.id.split('_')[1],src);
                    return false;
                }
            },
            OPT:{
                onMousedown:function(){
                    return false;
                },
                onClick:function(profile, e, src){
                    profile.boxing().onShowOptions(profile, profile.getItemByDom(src), e, src);
                    return false;
                }
            }
        },
        DataModel:({
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('HEAD',true).attr('tabIndex',value);
                }
            },
            cmds:{
                ini:[]
            },
            activeLast:false
        }),
        EventHandlers:{
            onGetContent:function(profile,item,onEnd){},
            onClickButton:function(profile,item,cmdkey,src){},
            onShowOptions:function(profile,item,e,src){}
        },
         RenderTrigger:function(){
            var self=this, pro=self.properties, items=pro.items, item;
            if(pro.activeLast && items.length>0){
                item=items[items.length-1];
                self.boxing().fillContent(item.id, item._body);
            }
        },
        _prepareItems:function(profile, arr, pid){
            if(arr.length){
                arr[0]._precheked = profile.getClass('ITEM','-prechecked');
                if(profile.properties.activeLast){
                    //for properties.data
                    var item = arr[arr.length-1];
                    item._show = true;
                    item._fill = true;
                    item._body = profile.onGetContent?profile.boxing().onGetContent(profile,item) : profile.box._buildBody(profile, item);
                }
            }
            return arguments.callee.upper.apply(this, arguments);
        },
        _prepareItem:function(profile, item){
            var p = profile.properties,o,
                dpn = 'display:none';
            item._tabindex = p.tabindex;
            if(!item.caption)
                item._capDisplay=dpn;
            else
                item.caption = item.caption.replace(/</g,"&lt;");
            item._opt = item.optBtn?'':dpn;
            item._body= item._body || 'Loading...'

            if(item._show){
                item._checked = profile.getClass('ITEM','-checked');
                item._tlgchecked = profile.getClass('TOGGLE','-checked');
            }
            var cmds = item.cmds || p.cmds;
            if(cmds && cmds.length){
                var sid=linb.UI.$tag_subId,a;
                a=item.cmds=[];
                for(var i=0,t=cmds,l=t.length;i<l;i++){
                    o=linb.UI.adjustData(profile,t[i]);
                    a.push(o);
                    o[sid]=item[sid] + '_' + o.id;
                }
            }
        },
        _buildBody:function(profile,item){
            return item.text?'<pre>'+item.text.replace(/</g,"&lt;")+'</pre>':'';
        }
    }
});
Class("linb.UI.TreeBar",["linb.UI","linb.absList","linb.absValue"],{
    Instance:{
        _setCtrlValue:function(value, flag){
            return this.each(function(profile){
                if(!profile.domNode)return;

                var box = profile.boxing(),
                    uiv = box.getUIValue(),
                    properties = profile.properties,
                    fun=function(key,o,b){
                        profile.getSubNodeByItemId(key, o).tagClass('-checked', b);
                    },
                    selmode=properties.selMode
                    ;
                if(selmode=='single'){
                    var itemId = profile.getSubIdByItemId(uiv);
                    if(uiv && itemId)
                        profile.getSubNodes(['BAR','MARK2'],itemId).tagClass('-checked',false);

                    itemId = profile.getSubIdByItemId(value);
                    if(itemId)
                        profile.getSubNodes(['BAR','MARK2'],itemId).tagClass('-checked');
                }else if(selmode=='multi'){
                    uiv = uiv?uiv.split(';'):[];
                    value = value?value.split(';'):[];
                    if(flag){
                        _.arr.each(value,function(o){
                            fun('BAR', o);
                            fun('MARK2', o);
                        });
                    }else{
                        //check all
                        _.arr.each(uiv,function(o){
                            if(_.arr.indexOf(value,o)==-1){
                                fun('BAR', o, false);
                                fun('MARK2', o, false);
                            }
                        });
                        _.arr.each(value,function(o){
                            if(_.arr.indexOf(uiv,o)==-1){
                                fun('BAR', o);
                                fun('MARK2', o);
                            }
                        });
                    }
                }
            });
        },
        insertItems:function(arr, pid, base ,before){
            var node;
            return this.each(function(profile){
                // prepare properties format
                var tar,r,k;

                if(!pid){
                    k=profile.properties;
                    tar = k.items ||(k.items=[])
                }else{
                    k=profile.getItemByItemId(pid);
                    tar = k.sub || (k.sub= []);
                }
                if(!base)
                    _.arr.insertAny(tar,arr, before?0:-1);
                else{
                    var index = _.arr.subIndexOf(tar, 'id', base);
                    _.arr.insertAny(tar,arr, before?index:(index+1));
                }
                if(profile.domNode){
                    if(!base){
                        if(!pid)
                            node=profile.getSubNode('ITEMS');
                        else if(pid && k._created)
                            node=profile.getSubNodeByItemId('SUB', pid);
                        if(node){
                            r=_.str.toDom(profile.buildItems('items', profile.box._prepareItems(profile, arr, pid)));
                            if(before)
                                node.prepend(r);
                            else
                                node.append(r);
                        }
                    }else{
                        node=profile.getSubNodeByItemId('ITEM', base);
                        if(node){
                            r=_.str.toDom(profile.buildItems('items', profile.box._prepareItems(profile, arr, pid)));
                            if(before)
                                node.addPrev(r);
                            else
                                node.addNext(r);
                        }
                    }
                }
                var obj;
                if(pid)
                    if((obj=profile.getSubNodeByItemId('TOGGLE', pid)).css('display')=='none')
                        obj.setInlineBlock();

                //open parent node
                if(!(('iniFold' in k)?k.iniFold:profile.properties.iniFold))
                    if(!pid || profile.getItemByItemId(pid)._created)
                        profile.boxing()._toggleNodes(arr, true);

            });
        },
        _toggleNodes:function(items, expend, recursive){
            var self=this;
            _.arr.each(items,function(o){
                self.toggleNode(o.id, expend, recursive)
            });
            return self;
        },
        /*
        *expend:true->expend false->fold
        *recursive:true open recursively
        */
        toggleNode:function(id, expend, recursive){
            var profile=this.get(0),
                o=profile.getItemByItemId(id);
            if(o.sub && o.sub.length && ((expend&&!o._checked)||(!expend&&o._checked)))
                profile.box._setSub(profile, o, expend, recursive);
            return self;
        },
        /*
        *open to deep node
        */
        openToNode:function(id){
            return this.each(function(profile){
                var res=false, a=[],
                    fun=function(arr, catId, layer){
                        layer = layer || 0;
                        var me=arguments.callee;
                        _.arr.each(arr,function(o){
                            if(o.id==catId){
                                a.push(o);
                                res=true;
                                return false;
                            }
                            if(o.sub){
                                res = me.call(me, o.sub, catId, ++layer)
                                if(res){
                                    a.push(o);
                                    return false;
                                }
                            }
                        });
                        return res;
                    }
                fun(profile.properties.items, id);
                if(res){
                    a.reverse();
                    _.arr.each(a,function(o){
                        if(o.sub){
                            if(!o._checked)
                                profile.box._setSub(profile, o, true);
                        }else
                            profile.boxing().selectItem(o.id);
                    });
                }
            });
        },
        selectItem:function(id){
            var profile = this.get(0);
            //fire dom event
            var node =profile.getSubNodeByItemId('BAR', id);
            //no this one, set to null
            if(!node.isEmpty()){
                node.onClick();
                return this;
            }else return false;
        }
    },
    Initialize:function(){
        this.addTemplateKeys(['DISABLED']);
    },
    Static:{
        Templates:{
            tagName : 'div',
            style:'{_style}',
            ondrag:'return false',
            onselectstart:'return false',
            BORDER:{
                tagName : 'div',
                BOX:{
                    tagName : 'div',
                    onselectstart:'return false',
                    ITEMS:{
                        tagName : 'div',
                        text:"{items}"
                    }
                }
            },
            $dynamic:{
                items:{
                    ITEM:{
                        className:'{itemClass}',
                        style:'{itemStyle}',
                        tagName : 'div',
                        onselectstart:'return false',
                        unselectable:'on',
                        BAR:{
                            $order:0,
                            tagName: 'a',
                            href :"{href}",
                            tabindex: '{_tabindex}',
                            className:'{cls_group} ',
                            onselectstart:'return false',
                            unselectable:'on',
                            TOGGLE:{
                                $order:0,
                                className:'uicmd-toggle',
                                style:'{mark}'
                            },
                            MARK2:{
                                $order:1,
                                style:'{mark2Display}'
                            },
                            ITEMICON:{
                                style:'background:url({image}) transparent  no-repeat   {imagePos}; {iconDisplay}',
                                className:'ui-icon',
                                $order:2
                            },
                            ITEMCAPTION:{
                                text : '&nbsp;{caption}',
                                className:"{disabled} ",
                                $order:3
                            }
                        },
                        SUB:{
                            $order:1,
                            tagName : 'div',
                            text:linb.UI.$childTag
                        }
                    }
                }
            }
        },
        Appearances:{
            KEY: {
                'font-family': 'Verdana, Helvetica, sans-serif',
                'border':0
            },
            BOX:{
                left:0,
                overflow: 'auto',
                'overflow-x':(linb.browser.ie ||linb.browser.gek)?'hidden':'',
                position:'relative'
            },
            ITEMS:{
                overflow: 'hidden',
                'border-bottom': '1px solid #e5e5e5',
                'border-right': '1px solid #e5e5e5'
            },
            ITEM:{
                'border-left': '1px solid #e5e5e5',
                'white-space': 'nowrap',
                position:'relative',
                overflow:'hidden'
            },
            BAR:{
               cursor:'pointer',
               zoom:linb.browser.ie?1:null,
               position:'relative',
               display:'block',
               overflow: 'hidden',
               'font-size':'12px',
               'border-top': '1px solid #e5e5e5'
            },
            DISABLED:{
                color:'#808080'
            },
            'BAR-mouseover':{
                $order:1,
               'background-color': '#d9e8fb'
            },
            'BAR-checked':{
                $order:2,
               'background-color': '#f6f6f6'
            },
            'BAR-GROUP':{
                $order:2,
                background: linb.UI.$bg('accordion.gif',' repeat-x left top', true)
            },
            'BAR-GROUP-mouseover':{
                $order:3,
                'background-position': 'left -30px'
            },
            'BAR-GROUP-checked':{
                $order:4,
                'background-position': 'left -60px'
            },
            SUB:{
                display:'none',
                overflow:'hidden',
                'margin-left':'12px'
            },

            MARK2:{
                'vertical-align':'middle',
                cursor:'pointer',
                width:'16px',
                height:'16px',
                margin:'0 4px 0 0'
            },
            'MARK2-checked':{
                $order:2,
                background: linb.UI.$bg('icon.gif', ' no-repeat -50px 0', true)
            },
            ITEMCAPTION:{
                'vertical-align':'middle',
                padding:'2px'
            }
        },
        Behaviors:{
            HoverEffected:{TOGGLE:'TOGGLE', BAR:'BAR'},
            ClickEffected:{TOGGLE:'TOGGLE', BAR:'BAR'},
            DragableKeys:["BAR"],
            DropableKeys:["BAR","TOGGLE","BOX"],
            onSize:function(profile,e){
                var o = profile.root,w=null,h=null;
                if(e.height)h=o.height();
                if(e.width)w=o.width();
                linb.UI.$tryResize(profile, w, h);
            },
            TOGGLE:{
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        item = profile.getItemByDom(src);

                    if(properties.disabled || item.disabled)return false;
                    if(!('sub' in item))return false;
                    profile.box._setSub(profile, item, !item._checked);

                    // not to fire BAR's onclick event;
                    return false;
                }
            },
            BAR:{
                onClick:function(profile, e, src){
                    var properties = profile.properties,
                        item = profile.getItemByDom(src),
                        itemId =profile.getSubId(src.id),
                        box = profile.boxing(),
                        ks=linb.Event.getKey(e),
                        rt,rt2;

                    if(properties.disabled|| item.disabled)return false;
                    //group not fire event
                    if(item.sub && (item.group!==undefined?item.group:properties.group)){
                        profile.getSubNode('TOGGLE', itemId).onClick();
                        return false;
                    }

                    switch(properties.selMode){
                    case 'none':
                        rt=box.onItemSelected(profile, item, src);
                        break;
                    case 'multi':
                        var value = box.getUIValue(),
                            arr = value?value.split(';'):[];
                        if(arr.length&&(ks[1]||ks[2])){
                            //for select
                            rt2=false;
                            if(ks[2]){
                                if(profile.$firstV._pid!=item._pid)return false;
                                var items=properties.items;
                                if(item._pid){
                                    var pitem=profile.getItemByItemId(item._pid);
                                    if(pitem)items=pitem.sub;
                                }
                                var i1=_.arr.subIndexOf(items,'id',profile.$firstV.id),
                                    i2=_.arr.subIndexOf(items,'id',item.id),
                                    i;
                                arr.length=0;
                                for(i=Math.min(i1,i2);i<=Math.max(i1,i2);i++)
                                    arr.push(items[i].id);
                            }else{
                                if(_.arr.indexOf(arr,item.id)!=-1)
                                    _.arr.removeValue(arr,item.id);
                                else
                                    arr.push(item.id);
                            }
                            arr.sort();
                            value = arr.join(';');

                            //update string value only for _setCtrlValue
                            if(box.getUIValue() == value)
                                rt=false;
                            else{
                                box.setUIValue(value);
                                if(box.getUIValue() == value)
                                    rt=box.onItemSelected(profile, item, src)||rt2;
                            }
                            break;
                        }
                    case 'single':
                        if(box.getUIValue() == item.id)
                            rt=false;
                        else{
                            profile.$firstV=item;
                            box.setUIValue(item.id);
                            if(box.getUIValue() == item.id)
                                rt=box.onItemSelected(profile, item, src);
                        }
                        break;
                    }

                    profile.getSubNode('BAR', itemId).focus();
                    return rt;
                },
                onKeydown:function(profile, e, src){
                    var keys=linb.Event.getKey(e), key = keys[0], shift=keys[2],
                    cur = linb(src),
                    first = profile.root.nextFocus(true, true, false),
                    last = profile.root.nextFocus(false, true, false);

                    switch(linb.Event.getKey(e)[0]){
                        case 'tab':
                            if(shift){
                                if(src!=first.get(0)){
                                    first.focus();
                                    return false;
                                }
                            }else{
                                if(src!=last.get(0)){
                                    last.focus();
                                    return false;
                                }
                            }
                            break;
                        case 'up':
                            var next = cur.nextFocus(false, true, false);
                            if(cur.get(0)==first.get(0))
                                last.focus();
                            else
                                cur.nextFocus(false);
                             return false;
                             break;
                        case 'down':
                            var next = cur.nextFocus(true, false, false);
                             if(cur.get(0)==last.get(0))
                                first.focus();
                             else
                                cur.nextFocus();
                             return false;
                             break;
                        case 'right':
                        case 'left':
                            profile.getSubNode('TOGGLE',profile.getSubId(src.id)).onClick();
                            return false;
                    }
                }
            },
            BOX:{
                onScroll:function(profile, e, src){
                    //for ie 'href focus' will scroll view
                    if(linb([src]).scrollLeft()!==0)
                        linb([src]).scrollLeft(0);
                }
            }
        },
        EventHandlers:{
            onGetContent:function(profile, item, callback, threadid){},
            onItemSelected:function(profile, item, src){}
        },
        DataModel:{
            listKey:null,
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('BAR', true).attr('tabIndex',value);
                }
            },
            iniFold:true,
            animCollapse:false,
            dock:'fill',
            group:{
                ini:false,
                action:function(v){
                    var self = this,
                        items = self.properties.items,
                        results = self.queryItems(items, function(o){return o.sub && o.group===undefined }),
                        nodes=linb();
                    _.arr.each(results,function(o){
                        nodes.merge( self.getSubNodeByItemId('BAR', o.id) );
                    });
                    var cls1=self.getClass('BAR'), cls2 = self.getClass('BAR', '-group');
                    if(v)
                       nodes.replaceClass(new RegExp('(\\b)' + cls1 + '([^b]*\\b)','g'), '$1'+cls2+'$2');
                    else
                       nodes.replaceClass(new RegExp('(\\b)' + cls2 + '([^b]*\\b)','g'), '$1'+cls1+'$2');
                }
            },
            selMode:{
                ini:'single',
                listbox:['single','none','multi'],
                action:function(v,ov){
                    var n=this.getSubNode('MARK2',true);
                    if(ov=='none')
                        n.setInlineBlock();
                    if(v=='none')
                        n.css('display','none');
                }
            },
            singleOpen:false,
            dynDestory:false,
            position:'absolute'

        },
        RenderTrigger:function(){
            var self=this, pro=self.properties;
            if(!pro.iniFold)
                self.boxing()._toggleNodes(pro.items, true);
        },
        _onStartDrag:function(profile, e, src, pos){
            var pos=linb.Event.getPos(e);
            linb([src]).startDrag(e, {
                dragType:'icon',
                shadowFrom:src,
                targetLeft:pos.left+12,
                targetTop:pos.top+12,
                dragCursor:'pointer',
                dragDefer:1,
                dragKey: profile.box.getDragKey(profile, src),
                dragData: profile.box.getDragData(profile, src)
            });
            return false;
        },
        _onDropTest:function(profile, e, src, key, data, item){
            var fid=data&&data.domId, tid=src.id;
            if(fid){
                if(fid==tid)return false;
                if(_.get(src,['parentNode','previousSibling','firstChild','id'])==fid)return false;
            }
        },
        _onDrop:function(profile, e, src, key, data, item){
            linb.DragDrop.setDragIcon('none');

            var k=profile.getKey(src.id),
                po=data.profile,
                ps=data.domId,
                oitem,
                ks=profile.keys,
                t=linb.absObj.$specialChars,
                b=profile.boxing();
            //remove
            oitem=_.clone(po.getItemByDom(ps),function(o,i){return !t[(i+'').charAt(0)]});
            po.boxing().removeItems([oitem.id]);

            //add
            if(k==ks.BOX)
                b.insertItems([oitem], null, null, false);
            else if(k==ks.BAR)
                b.insertItems([oitem], item._pid, item.id, true);
            else if(k==ks.TOGGLE)
                b.insertItems([oitem], item.id, null, false);

            return false;
        },
        _ensureValue:function(profile,value){
            if(profile.properties.selMode=='multi'){
                var arr = (value||"").split(';');
                arr.sort();
                return arr.join(';');
            }else
                return value;
        },
        _prepareItem:function(profile, item, oitem, pid){
            var p=profile.properties;

            if(pid)oitem._pid=pid;
            // set 'visible' will show when parent call .height()
            item.mark = item.sub?'':'display:none';
            item.disabled = item.disabled?profile.getClass('KEY', '-disabled'):'';
            item.mark2Display = (p.selMode=='none')?'display:none':'';
            item._tabindex = p.tabindex;
            item.href = item.href || linb.$href;
            //change css class
            if(item.sub && (item.group!==undefined?item.group:p.group)){
                item.cls_group = profile.getClass('BAR', '-group');
                item.mark2Display = 'display:none';
            }
        },
        _setSub:function(profile, item, flag, recursive){
            var id=profile.domId,
                itemId = profile.getSubIdByItemId(item.id),
                properties = profile.properties,
                barNode = profile.getSubNode('BAR', itemId),
                markNode = profile.getSubNode('TOGGLE', itemId),
                subNs = profile.getSubNode('SUB', itemId);
                ;

            if(linb.Thread.isAlive(profile.key+profile.id)) return;
            //close
            if(item._checked){
                if(!flag){
                    var h=subNs.height(),fun=function(){
                        subNs.css('display','none').height('auto');
                    };
                    if(properties.animCollapse)
                        subNs.animate({'height':[h,0]},function(){subNs.height(h)},function(){fun()}, 100, 5, 'inexp', profile.key+profile.id).start();
                    else
                        fun();

                    markNode.tagClass('-checked', false);
                    item._checked = false;

                    if(item.group || properties.group)
                        barNode.tagClass('-checked', false);
                    if(properties.dynDestory){
                        var s=item.sub, arr=[];
                        for(var i=0,l=s.length;i<l;i++)
                            arr.push(s[i].id);
                        profile.boxing().removeItems(arr);
                        item.sub=true;
                        delete item._created;
                    }
                }
                if(recursive && item.sub && !properties.dynDestory){
                    _.arr.each(item.sub,function(o){
                        if(o.sub && o.sub.length)
                            profile.box._setSub(profile, o, false, true);
                    });
                }
            }else{
                //open
                if(flag){
                    var openSub = function(profile, item, id, markNode, subNs, barNode, sub, recursive){
                            var b=profile.boxing(),
                                p=profile.properties;
                            //created
                            if(!item._created){
                                delete item.sub;
                                //before insertRows
                                item._created=true;
                                subNs.css('display','none');
                                if(typeof sub=='string')
                                    subNs.html(item.sub=sub,false);
                                else if(sub.constructor==Array)
                                    b.insertItems(sub, item.id);
                                else if(sub['linb.Template']||sub['linb.UI'])
                                    subNs.append(item.sub=sub.render(true));

                                //set checked items
                                b._setCtrlValue(b.getUIValue(), true);
                            }

                            if(p.singleOpen)
                                b._toggleNodes(item._pid?profile.getItemByItemId(item._pid).sub:p.items, false)

                            if(!recursive){
                                var h = subNs.height(true);
                                if(p.animCollapse)
                                    subNs.animate({'height':[0,h]},function(){subNs.height('0').css('display','block')},function(){subNs.height('auto')}, 100, 5, 'outexp', profile.key+profile.id).start();
                                else
                                    subNs.css('display','block').height('auto');
                            }else
                                subNs.css('display','block');

                            markNode.tagClass('-checked');
                            if(item.group || properties.group)
                                barNode.tagClass('-checked');

                            item._checked = true;
                        },
                        sub=item.sub,
                        callback=function(sub){
                            openSub(profile, item, id, markNode, subNs, barNode, sub, recursive)
                        },
                        t;
                    if((t=typeof sub)=='string'||t=='object')
                        callback(sub);
                    else if(profile.onGetContent){
                        linb.Thread(null,[
                            function(threadId){
                                var r = profile.boxing().onGetContent(profile, item, callback, threadId);
                                if(r) callback(r);
                            }
                        ],null,null,
                        //set busy status to UI
                        function(threadId){markNode.tagClass('-busy')},
                        //set free status to UI
                        function(){markNode.tagClass('-busy',false)}
                        ).start();
                    }
                }
                if(recursive && item.sub){
                    _.arr.each(item.sub,function(o){
                        if(o.sub && o.sub.length && !o._checked)
                            profile.box._setSub(profile, o, true, true);
                    });
                }
            }
        },
        _onresize:function(profile,width,height){
            profile.getSubNode('BORDER').cssSize({ width :width?width:null, height :height?height:null});
            profile.getSubNode('BOX').cssSize({ width :width?width:null, height : height?height:null});
        }
    }
});
Class("linb.UI.PopMenu",["linb.UI.Widget","linb.absList"],{
    Instance:{
        _adjustSize:function(){
            this.each(function(profile){
                var
                root = profile.root,
                items = profile.getSubNode('ITEMS'),
                border = profile.getSubNode('BORDER'),
                size1 = root.cssSize(),
                size2 = border.cssSize(),
                pro=profile.properties,
                h = Math.min(pro._maxHeight, items.height() + size1.height - size2.height+1),
                w = Math.min(pro._maxWidth, items.width() + size1.width - size2.width+1)
                ;

                pro.width=w;
                pro.height=h;
                //set size first, for adding shadow later
                root.cssSize({width:w,height:h});

                //avoid blazing(shadow elements) when resize the border
                linb.UI.$tryResize(profile,w,h,null,true);
                if(pro.shadow){
                    profile.$noS=true;
                    var ins=profile.boxing();
                    if(ins._shadow)
                        ins._shadow(true);
                 }
            });
            return this._setScroll();
        },
        _setScroll:function(){
            return this.each(function(profile){
                var
                o=profile.getSubNode('ITEMS'),
                t=o.offsetTop(),
                h=o.offsetHeight(),
                b = profile.getSubNode('BORDER'),
                hh=b.offsetHeight();
                profile.getSubNode('TOP').css('display',t===0?'none':'block');
                profile.getSubNode('BOTTOM').css('display',(hh>h+t)?'none':'block');
            })
        },
        _scrollToBottom:function(){
            return this.each(function(profile){
                var o = profile.getSubNode('ITEMS'),
                border = profile.getSubNode('BORDER'),
                y = o.offsetTop(),
                offset,
                h = o.offsetHeight(),
                b=false,
                bh = border.height();
                if(bh<h+y){
                    if(!profile.$scrollStep)profile.$scrollStep=1;

                    if(profile.$scrollStep<30)
                        profile.$scrollStep = profile.$scrollStep*1.1;

                    y -= profile.$scrollStep;
                    if(bh>h+y){
                        y=bh-h;
                        b=true;
                    }
                    o.top(y);
                    if(b){
                        profile.getSubNode('BOTTOM').css('display','none');
                        profile.$scrollTobottom=false;
                        profile.$scrollStep=null;
                    }else{
                        profile.getSubNode('TOP').css('display','block');
                        if(profile.$scrollTobottom)
                            _.asyRun(arguments.callee, 0, [profile], this);
                    }
                }
            });
        },
        _scrollToTop:function(){
            return this.each(function(profile){
                var o = profile.getSubNode('ITEMS'),
                y = o.offsetTop(),
                b=false;

                if(y<0){
                    if(!profile.$scrollStep)profile.$scrollStep=1;

                    if(profile.$scrollStep<10)
                        profile.$scrollStep = profile.$scrollStep*1.03;

                    y += profile.$scrollStep;
                    if(y>=-1){
                        y=0;
                        b=true;
                    }
                    o.top(y);
                    if(b){
                        profile.getSubNode('TOP').css('display','none');
                        profile.$scrollToTop=false;
                        profile.$scrollStep=null;
                    }else{
                        profile.getSubNode('BOTTOM').css('display','block');
                        if(profile.$scrollToTop)
                            _.asyRun(arguments.callee, 0, [profile], this);
                    }
                }
            });
        },
        pop:function(obj, type, parent){
            var profile=this.get(0);
            //ensure rendered
            if(!profile.rendered){
                var o=profile.boxing().render(true);
                //LayoutTrigger
                linb.Dom.getEmptyDiv().append(o);
            }
            var root = profile.root;

            //clear highLight first
            if(profile.$highLight)
                linb([profile.$highLight]).tagClass('-mouseover',false);
            profile._conainer=parent;

            root.popToTop(obj, type, parent);

            var f=function(){
                var p=arguments.callee.profile;
                p.boxing().hide();
                p.$popGrp.length=0;
            };
            f.profile=profile;

            if(!profile.$popGrp || !profile.$popGrp.length){
                profile.$popGrp = [root.get(0)];
                //group blur trigger
                root.setBlurTrigger(profile.$id, null);
                root.setBlurTrigger(profile.$id, f, profile.$popGrp);
            }
            return this;
        },
        hide:function(triggerEvent){
            var t,
                profile=this.get(0),
                root=profile.root,
                sms='$subPopMenuShowed',
                cm='$childPopMenu';

            if(false!==triggerEvent)
                if(false===profile.boxing().beforeHide(profile))
                    return this;

            if(!root || root.css('display')=='none')return;

            //remove trigger
            root.setBlurTrigger(profile.$id,null);

            if(profile.$hideMenuPool)
                profile.$hideMenuPool.append(root);
            else
                root.css('display','none');

            //hide all parent pop
            var p=profile[cm],q;
            if(t=profile[sms])t.hide();
            while(p){
                p.boxing().hide();
                p=(q=p)[cm];
                q[cm] = q[sms] = null;
            }
            profile[cm]=profile[sms]=null;
            if(t=profile.$parentPopMenu)t[sms]=null;

            _.arr.removeValue(profile.$popGrp,root.get(0));

            if(false!==triggerEvent)
                profile.boxing().onHide(profile);
            return this;
        }
    },
    Initialize:function(){
        //modify default template fro shell
        var t = this.getTemplate();
        _.merge(t.FRAME.BORDER,{
             TOP:{},
             BOTTOM:{},
             BOX:{
                tagName:'div',
                 ITEMS:{
                    tagName:'div',
                    className:'{itemClass}',
                    style:'{itemStyle}',
                    text:"{items}"
                 }
             },
             POOL:{
                tagName : 'div',
                style:'display:none;'
             }
        },'all');
        t.$dynamic = {
            'items':function(profile,template,v,tag,result){
                var t;
                tag = tag+'.'+v.type;
                //for linb.UI or linb.Template
                if(t=v.object){
                    //[v] is for linb.Template
                    result[result.length]=t.build(v);
                }else{
                    if(template[tag])
                        linb.UI.$doTemplate(profile,template,v,tag,result);
                }
             },
            'items.split':{
                ITEMSPLIT:{
                    tagName : 'a'
                }
            },
            'items.button':{
                ITEM:{
                    tagName : 'a',
                    href :linb.$href,
                    tabindex: 1,
                    className: '{cls} {disabled}',
                    ICON:{
                        style:'background:url({image}) transparent  no-repeat {imagePos};',
                        className:'ui-icon',
                        $order:0
                    },
                    CAPTION:{
                        text : '{caption}',
                        $order:1
                    },
                    RULER:{
                        style:'{displayAdd}',
                        $order:2
                    },
                    ADD:{
                        tagName : 'div',
                        style:'{displayAdd}',
                        text : '{add}',
                        $order:2
                    },
                    SUB:{style:'{tagClass}'}
                }
            },
            'items.checkbox':{
                ITEM:{
                    tagName : 'a',
                    href :linb.$href,
                    tabindex: 1,
                    className: '{cls}',
                    CHECKBOX:{
                        $order:0,
                         className:'ui-icon {checkboxCls}'
                    },
                    CAPTION:{
                        text : '{caption}',
                        $order:1
                    },
                    RULER:{
                        style:'{displayAdd}',
                        $order:2
                    },
                    ADD:{
                        tagName : 'div',
                        style:'{displayAdd}',
                        text : '{add}',
                        $order:2
                    }
                }
            }
        };
        this.setTemplate(t);
    },
    Static:{
        $noDomRoot:true,
        Appearances:{
            KEY:{
                'font-size':'12px',
                visibility:'hidden'
            },
            BORDER:{
                border:'1px solid',
                'border-color':'#FFF #ACA899 #ACA899 #FFF'
            },
            BOX:{
                'background-color':'#EBEADB',
                overflow:'hidden',
                position:'absolute',
                left:0,
                top:0,
                'font-size':'12px',
                'z-index':'3'
            },
            ITEMS:{
                position:'absolute',
                top:0,
                left:0,
                overflow:'visible',
                background: linb.UI.$bg('bg.gif', ' repeat-y left top')
            },
            ITEM:{
                display:'block',
                position:'relative',
                overflow:'visible',
                'white-space': 'nowrap',
                color:'#000',
                'font-family': '"Verdana", "Helvetica", "sans-serif"',
                cursor:'pointer',
                padding:'2px 20px 2px 2px'
            },
            ITEMSPLIT:{
                display:'block',
                position:'relative',
                overflow:'visible',
                'white-space': 'nowrap',
                'font-size':'1px',
                'line-height':'1px',
                padding:'1px',
                margin:'2px 2px 2px 26px',
                background: linb.UI.$bg('hsplit.gif', ' repeat-x left top', true)
            },
            'ITEM-mouseover':{
                $order:1,
                'background-color':'#B6BDD2'
            },
            'ITEM-checked':{
                $order:2,
                'background-color':'#B6BDD2'
            },
            CHECKBOX:{
               background: linb.UI.$bg('cmds.gif', ' no-repeat -112px 1px', true),
               margin:0
            },
            ICON:{
                margin:0
            },
            'CHECKBOX-checked':{
               $order:1,
               background: linb.UI.$bg('cmds.gif', ' no-repeat -96px 1px', true)
            },
            TOP:{
                cursor:'pointer',
                display:'none',
                position:'absolute',
                'margin-left':'-8px',
                right:0,
                height:'16px',
                width:'16px',
                'z-index':'10',
                top:0,
                background: linb.UI.$bg('icon.gif', ' no-repeat -33px 0', true)
            },
            BOTTOM:{
                cursor:'pointer',
                display:'none',
                position:'absolute',
                'margin-left':'-8px',
                right:0,
                height:'16px',
                width:'16px',
                'z-index':'10',
                bottom:0,
                background: linb.UI.$bg('icon.gif', ' no-repeat -33px -17px', true)
            },
            'CHECKBOX, CHECKBOX-checked':{
                cursor:'pointer',
                'vertical-align':'middle',
                width:'16px',
                height:'16px'
            },
            CAPTION:{
                'vertical-align':'middle',
                'padding-left':'6px'
            },
            RULER:{
                width:'100px',
                'font-size':0,
                'line-height':0
            },
            ADD:{
                position:'absolute',
                top:'3px',
                right:0,
                width:'80px',
                'padding-right':'20px',
                'text-align':'right',
                'z-index':'10'
            },
            SUB:{
                position:'absolute',
                top:'4px',
                right:0,
                width:'8px',
                height:'16px',
                background: linb.UI.$bg('icon.gif', ' no-repeat left -16px', true)
            }
        },
        Behaviors:{
            ITEM:{
                onMouseover:function(profile, e, src){
                    var sms='$subPopMenuShowed',
                        all='$allPops',
                        hl='$highLight',
                        showp='$showpops',
                        popgrp='$popGrp';
                    //for stop second trigger by focus event
                    if(profile[hl] == src)return;

                    var properties = profile.properties,
                        item = profile.getItemByDom(src),
                        itemId = item.id,
                        Cancel = false,
                        pop,popp,t;
                    //if sub pop menu showed
                    if(t=profile[sms]){
                        //if the showed menu is self
                        if(t == _.get(profile,[all,itemId]))
                            Cancel=true;
                        else{
                            t.hide();
                            profile[sms] = null;
                        }
                    }
                    if(!Cancel){
                        if(t=profile[hl])
                            linb([t]).tagClass( '-mouseover',false);
                        profile[hl] = src;
                        linb([src]).tagClass('-mouseover');
                        //don't fire events here
                        try{src.focus()}catch(e){}
                    }

                    if(!Cancel && item.sub){
                        if(item.sub.constructor==Array && item.sub.length){
                            profile[all] = profile[all] || {};

                            //no create
                            if(!(pop = profile[all][itemId])){
                                pop = (new linb.UI.PopMenu({position:'absolute', items:item.sub, autoHide:profile.properties.autoHide})).render(true);
                                pop.onMenuSelected(function(pro, item, src){
                                    profile.boxing().onMenuSelected(profile, item, src);
                                });
                                popp=pop.get(0);
                                //set pool to parent
                                popp.$hideMenuPool = profile.$hideMenuPool || profile.getSubNode('POOL');

                                profile[all][itemId] = pop;

                                //collect
                                profile[showp] = profile[showp] || [profile];
                                popp[showp] = profile[showp];
                                profile[showp].push(popp);
                            }else popp=pop.get(0);

                            //input a copy of root for group trigger
                            profile[popgrp].push(popp.root.get(0));
                            popp[popgrp] = profile[popgrp];

                            //set parent pop
                            popp.$parentPopMenu = profile;
                            profile.$childPopMenu = popp;

                            pop.pop(src, 2);
                            profile[sms] = pop;
                        }else
                            if(profile.onShowSubMenu){
                                var r=profile['$sub:'+item.id];
                                if(r && r['linb.UI'] && !r.isEmpty()){}
                                else
                                    r=profile.boxing().onShowSubMenu(profile, item, src);
                                if(r && r['linb.UI'] && !r.isEmpty()){
                                    profile[sms] = r;
                                    r=r.reBoxing();
                                    r.onMouseout(function(p,e,src){
                                        profile.box._mouseout(profile, e, src);
                                    },null,-1);
                                    profile[popgrp].push(r.get(0));

                                    r.popToTop(src,2,profile._conainer);
                                }
                            }
                    }
                },
                onMouseout:function(profile, e, src){
                    var properties = profile.properties,
                        item = profile.getItemByDom(src),
                        itemId = item.id,
                        action = true,
                        t;
                    //if cursor move to submenu, keep the hover face
                    if(t=profile.$subPopMenuShowed){
                        var node = e.toElement||e.relatedTarget,
                            target = t.get(0).root.get(0);
                        try{
                            do{
                                if(node==target)
                                    return;
                            }while((node && (node=node.parentNode)))
                        }catch(a){}
                    }
                    linb([src]).tagClass('-mouseover',false);
                    profile.$highLight = null;
                },
                onClick:function(profile, e, src){
                    var prop = profile.properties,
                        item = profile.getItemByDom(src),
                        itemId = item.id;
                    if(prop.disabled || item.disabled)return false;

                    if(!item.sub){
                        if(item.type=='checkbox')
                            profile.getSubNodeByItemId('CHECKBOX',item.id).tagClass('-checked', item.value = !item.value);

                        if(profile.onMenuSelected)profile.boxing().onMenuSelected(profile, item, src);

                        if(prop.hideAfterClick){
                            linb([src]).tagClass('-mouseover',false);
                            //hide all parent pop
                            _.asyRun(function(){
                                var p=profile,q;
                                while(p){
                                    p.boxing().hide();
                                    p=(q=p).$parentPopMenu;
                                    q.$parentPopMenu = q.$subPopMenuShowed = null;
                                }
                                //reset
                                profile.$subPopMenuShowed = null;
                                profile.$popGrp.length=0;
                            },100);
                        }
                    }
                    return false;
                },
                onFocus:function(profile, e, src){
                    var box = profile.getSubNode('BOX'),
                        top=box.scrollTop(), h=box.scrollHeight(),
                        n = linb([src]).offsetTop();

                    if(n<top || n>top+h)
                        linb(src).offsetTop(top);

                    linb(src).onMouseover();
                },
                onKeydown : function(profile, e, src){
                    var item = profile.getItemByDom(src),
                        items = profile.properties.items,
                        key = linb.Event.getKey(e)[0],
                        itemId = item.id,
                        flag,r,tid,node,t;

                    switch(key){
                        case 'up':
                            r=true;
                            flag=false;
                            _.arr.each(items,function(o,i){
                                if(o.type == 'split')return;
                                if(flag){
                                    tid=o.id;
                                    return r=false;
                                }
                                if(o.id == itemId)flag=true;
                            },null,true);
                            //last
                            if(r)tid=items[items.length-1].id;
                            node = profile.getSubNodeByItemId('ITEM', tid).get(0);
                            break;
                        case 'down':
                            r=true;
                            flag=false;
                            _.arr.each(items,function(o,i){
                                if(o.type == 'split')return;
                                if(flag){
                                    tid=o.id;
                                    return r=false;
                                }
                                if(o.id == itemId)flag=true;
                            });
                            //first
                            if(r)tid=items[0].id;
                            node = profile.getSubNodeByItemId('ITEM', tid).get(0);
                            break;
                        case 'left':
                            if(t=profile.$parentPopMenu){
                                if(t=profile.$parentPopMenu.$highLight)
                                    node = t;
                            }
                            break;
                        case 'right':
                            if((t=profile.$subPopMenuShowed) && t == profile.$allPops[itemId])
                                t.activate();
                            break;
                    }
                     if(node&&node.tagName)try{node.focus()}catch(e){}
                }
            },
            TOP:{
                onMouseover:function(profile, e, src){
                    profile.$scrollToTop=true;
                    profile.boxing()._scrollToTop();
                },
                onMouseout:function(profile, e, src){
                    profile.$scrollToTop=false;
                    profile.$scrollStep=null;
                },
                onClick:function(profile, e, src){
                    profile.$scrollStep=1000;
                }
            },
            BOTTOM:{
                onMouseover:function(profile, e, src){
                    profile.$scrollTobottom=true;
                    profile.boxing()._scrollToBottom();
                },
                onMouseout:function(profile, e, src){
                    profile.$scrollTobottom=false;
                    profile.$scrollStep=null;
                },
                onClick:function(profile, e, src){
                    profile.$scrollStep=1000;
                }
            },
            ITEMS:{
                beforeKeydown:function(profile, e){
                    var key=linb.Event.getKey(e)[0];
                    if(key=='tab' || key=='enter')
                        return true;
                    else if(key=='esc'){
                        //top
                        do{
                            profile.boxing().hide();
                        }while(profile = profile.$parentPopMenu)

                        return false;
                    }else return false;
                }
            },
            BORDER:{
                onMouseout:function(profile, e, src){
                    profile.box._mouseout(profile, e, src);
                }
            }
        },
        DataModel:({
            dock:null,
            tabindex:null,
            tips:null,
            border:null,
            resizer:null,

            $fix:true,

            shadow:true,
            _maxHeight:260,
            _maxWidth:300,
            left:-10000,

            hideAfterClick:true,

            autoHide:false,

            height:100,
            //opera needs more space for initialize
            width:300,
            position:'absolute',
            $border:1
        }),
        EventHandlers:{
            onShowSubMenu:function(profile, item, src){},
            beforeHide:function(profile){},
            onHide:function(profile){},
            onMenuSelected:function(profile, item, src){}
        },
        RenderTrigger:function(){
            this.boxing()._adjustSize();
        },
        _mouseout:function(profile, e, src){
            if(profile.properties.autoHide){
                var p1=linb.Event.getPos(e),
                    size, p2, b;
                _.arr.each(profile.$popGrp,function(o){
                    o=linb([o]);
                    p2=o.offset();
                    size=o.cssSize();
                    if(p1.left>p2.left && p1.top>p2.top && p1.left<p2.left+size.width && p1.top<p2.top+size.height)
                        return b=1;
                });
                if(!b){
                    while(b=profile.$parentPopMenu)profile=b;
                    profile.boxing().hide();
                    profile.$popGrp.length=0;
                }
            }
        },
        _prepareItem:function(profile, item){
            item.add = item.add || '';
            item.displayAdd = item.add?'':'display:none';
            item.tagClass = item.sub?'':'display:none';

            item.type=item.type||'button';
            if(item.type=='checkbox'){
                item.checkboxCls =profile.getClass('CHECKBOX', item.value?'-checked':'');
            }
        },

        _onresize:function(profile,width,height){
            var size = arguments.callee.upper.apply(this,arguments);
            profile.getSubNode('BOX').cssSize(size);
        }
    }
});
Class("linb.UI.MenuBar",["linb.UI","linb.absList" ],{
    Instance:{
        _pop:function(id,src){
            var menu, 
                self=this,
                profile=self.get(0),
                pro=profile.properties,
                all='$allPops';
            //hide first
            if(profile.$curPop)self.hide();

            linb([src]).tagClass('-mousedown');

            profile[all] = profile[all] || {};
            if(!(menu = profile[all][id])){
                var item=profile.getItemByItemId(id),
                    sub = item.sub;
                sub  = sub ||[];

                menu = linb.create('PopMenu',{position:'absolute', items:sub, autoHide:!!pro.autoShowTime});
                profile.getSubNode('POOL').append(menu);

                menu.onHide(function(pro){
                    self.hide(false);
                }).onMenuSelected(function(pro, item, src){
                    return profile.boxing().onMenuSelected(profile, pro, item, src);
                }).onShowSubMenu(function(pro, item, src){
                    return profile.boxing().onShowSubMenu(profile, pro, item, src);
                });
                menu.get(0).$hideMenuPool = profile.getSubNode('POOL');
                menu.get(0)[all] = profile[all];

                profile[all][id] = menu;
            }
            var target = linb(src);
            menu.pop(target, 1, linb(pro.parentID));

            profile.$curPop=id;
            profile.$curElem=src;
        },
        hide:function(){
            var profile=this.get(0),menu,
            id = profile.$curPop,
            node = profile.$curElem;

            if(menu = profile.$allPops[id]){
                //To avoid trigger recursive call
                if(false!==arguments[0])
                    menu.hide(false);
                // collect
                profile.getSubNode('POOL').append(menu.reBoxing());
                linb([node]).tagClass('-mousedown',false);
            }
            profile.$menuPop=profile.$curPop=profile.$curElem=null;
        },
        clearPopCache:function(){
            var profile=this.get(0);
            profile.getSubNode('POOL').empty();
            profile.$allPops=profile.$curPop=profile.$curElem=null;
        }
    },
    Initialize:function(){
        linb.SC('linb.UI.PopMenu');
    },
    Static:{
        Templates:{
            tagName:'div',
            POOL:{
                tagName:'div'
            },
            BORDER:{
                tagName:'div',
                LIST:{
                    tagName:'div',
                    HANDLER:{
                        style:'{handler}'
                    },
                    ITEMS:{
                        $order:1,
                        text:"{items}"
                    }
                }
            },
            $dynamic:{
                items:{
                    ITEM:{
                        tagName:'a',
                        href :linb.$href,
                        tabindex: '{_tabindex}',
                        className:' {typeCls} ',
                        ICON:{
                            $order:1,
                            className:'ui-icon',
                            style:'background:url({image}) transparent no-repeat  {imagePos}; {iconDisplay}'
                        },
                        CAPTION:{
                            $order:2,
                            text : '{caption}',
                            style:'{captionDisplay}'
                        }
                    }
                }
            }
        },
        Appearances:{
            KEY:{
                'font-size':0,
                'line-height':0,
                position:'absolute',
                'background-color':'#EBEADB',
                left:0,
                top:0
            },
            POOL:{
                width:0,
                height:0,
                visibility:'hidden',
                position:'absolute',
                left:'-10000px'
            },
            BORDER:{
                left:0,
                top:0,
                border: 'solid 1px',
                'border-color':'#fff #A7A6AA #A7A6AA #fff',
                'font-size':0,
                'line-height':0
            },
            HANDLER:{
                height:'22px',
                width:'6px',
                'vertical-align':'middle',
                background: linb.UI.$bg('handler.gif', ' left top #EBEADB ', true),
                cursor:'move'
            },
            LIST:{
                'padding':'1px 4px 1px 2px'
            },
            'LIST-disabled':{
                'background-color':'#E4E4E4'
            },
            ITEM:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                'vertical-align':'baseline',
                margin:'0  4px 0 4px',
                padding:'1px 2px',
                cursor:'default',
                border:'solid 1px #EBEADB'
            },
            'ITEM-mouseover':{
                $order:2,
                'border-color':'#cdcdcd' ,
                'background-color':'#FFFFE0'
            },
            'ITEM-mousedown':{
                $order:2,
                'border-color':'#A7A6AA #FFF #FFF #A7A6AA',
                'background-color':'#FFFFE0'
            },
            CAPTION:{
                height:'16px',
                'margin-left':'1px',
                'font-size':'12px',
                'line-height':'14px',
                'vertical-align':'middle'
            }
        },
        Behaviors:{
            ITEM:{
                onMouseover:function(profile, e, src){
                    var p = profile.properties, ns=this;
                    if(p.disabled)return;
                    var item = profile.getItemByDom(src),
                        itemId = item.id;
                    if(profile.$menuPop){
                        if(profile.$menuPop != itemId){
                            linb([ns]).tagClass('-mousedown');
                            //show current popmenu
                            profile.boxing()._pop(itemId, ns);
                            profile.$menuPop = itemId;
                        }
                    }else{
                        linb([ns]).tagClass('-mouseover');

                        if(p.autoShowTime)
                            _.resetRun(profile.$id+':autoShowTime', function(){
                                profile.boxing()._pop(itemId, ns);
                            },p.autoShowTime);
                    }
                },
                onMouseout:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    linb([this]).tagClass('-mouseover',false);

                    if(p.autoShowTime){
                        var pop = profile.$allPops;
                        if(pop=pop && pop[profile.$curPop]){
                            var node=pop.get(0).root,
                                p1=linb.Event.getPos(e),
                                size=node.cssSize(),
                                add=3,
                                p2=node.offset();

                            if(p1.left>p2.left && p1.top>p2.top-add && p1.left<p2.left+size.width && p1.top<p2.top+size.height){}else
                                pop.hide();
                        }
                        _.resetRun(profile.$id+':autoShowTime', null);
                    }
                },
                onMousedown:function(profile, e, src){
                    var p = profile.properties;
                    if(p.disabled)return;
                    var item = profile.getItemByDom(src),
                        itemId = item.id;
                     if(profile.$menuPop){
                        profile.$menuPop=null;
                        profile.boxing().hide(itemId);
                     }else{
                        profile.$menuPop=itemId;
                        profile.boxing()._pop(itemId, this);

                        //stop bubble to document.body
                        //popmenu will add blue trigger to document.body.beforeMousedown
                        return false;
                     }
                },
                onKeydown:function(profile, e, src){
                    var keys=linb.Event.getKey(e), key = keys[0], shift=keys[2],
                    cur = linb(src),
                    first = profile.root.nextFocus(true, true, false),
                    last = profile.root.nextFocus(false, true, false);

                    switch(linb.Event.getKey(e)[0]){
                        case 'tab':
                            if(shift){
                                if(src!=first.get(0)){
                                    first.focus();
                                    return false;
                                }
                            }else{
                                if(src!=last.get(0)){
                                    last.focus();
                                    return false;
                                }
                            }
                            break;
                        case 'left':
                        case 'up':
                            var next = cur.nextFocus(false, true, false);
                            if(cur.get(0)==first.get(0))
                                last.focus();
                            else
                                cur.nextFocus(false);
                            return false;
                            break;
                        case 'right':
                        case 'down':
                            var next = cur.nextFocus(true, false, false);
                            if(cur.get(0)==last.get(0))
                                first.focus();
                            else
                                cur.nextFocus();
                            return false;
                            break;
                        case 'enter':
                            linb(src).onMousedown();
                            return false;
                            break;
                    }
                },
                onClick:function(){
                    return false;
                }
            }
        },
        DataModel:{
            listKey:null,

            //can't change height
            height:null,
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('ITEM', true).attr('tabIndex',value);
                }
            },
            parentID:'',
            $border:1,
            left:0,
            top:0,

            autoShowTime:200,

            handler:{
                ini:true,
                action:function(v){
                    this.getSubNode('HANDLER').css('display',v?'':'none');
                }
            },
            position:'absolute',
            dock:{
                ini:'top',
                listbox:['top','bottom']
            }
        },
        EventHandlers:{
            onShowSubMenu:function(profile, popProfile, item, src){},
            onMenuSelected:function(profile, popProfile, item, src){}
        },
        RenderTrigger:function(){
            if(this.properties.disabled)this.boxing().setDisabled(true,true);
        },
        _prepareData:function(profile){
            var data=arguments.callee.upper.call(this, profile);
            data.handler = data.handler?'':'display:none';
            return data;
        }
    }
});

Class("linb.UI.ToolBar",["linb.UI","linb.absList"],{
    Instance:{
        updateItem:function(subId,options){
            return arguments.callee.upper.apply(this,[subId,options,'items.sub',]);
        },
        showItem:function(itemId, value){
            return this.each(function(profile){
                profile.getItemByItemId(itemId).visible=value!==false;
                profile.getSubNodeByItemId('ITEM', itemId).css('display',value===false?'none':'');
            });
        },
        showGroup:function(grpId, value){
            return this.each(function(profile){
                _.arr.each(profile.properties.items,function(o){
                    if(o.id==grpId){
                        o.visible=value!==false;
                        return false;
                    }
                });
                profile.getSubNodeByItemId('GROUP', grpId).css('display',value===false?'none':'');
            });
        }
    },
    Static:{
        Templates:{
            tagName:'div',
            ITEMS:{
                tagName:'div',
                style:'{mode}',
                text:'{items}'
            },
            $dynamic:{
                items:{
                    GROUP:{
                        className:'{groupClass}',
                        style:'{grpDisplay} {groupStyle}',
                        HANDLER:{
                            style:'{mode2}'
                        },
                        LIST:{
                            $order:1,
                            tagName:'text',
                            text:'{sub}'
                        }
                    }
                },
                'items.sub':{
                    ITEM:{
                        style:'{itemDisplay}',
                    //for firefox2 image in -moz-inline-box cant change height bug
                        IBWRAP:{
                            tagName:'div',
                            SPLIT:{
                                style:'{splitDisplay}'
                            },
                            LABEL:{
                                className:" {disabled}",
                                style:'{labelDisplay}',
                                text:'{label}'
                            },
                            BOX:{
                                tagName:'a',
                                href :linb.$href,
                                tabindex: '{_tabindex}',
                                className:'{itemClass}',
                                style:'{itemStyle} {boxDisplay}',
                                ICON:{
                                    $order:1,
                                    className:'ui-icon',
                                    style:'background:url({image}) transparent no-repeat  {imagePos}; {iconDisplay}'
                                },
                                CAPTION:{
                                    $order:2,
                                    text : '{caption}',
                                    className:" {disabled}",
                                    style:'{captionDisplay}'
                                },
                                DROP:{
                                    $order:3,
                                    style:'{dropDisplay}'
                                }
                            }
                        }
                    }
                }
            }
        },
        Appearances:{
            KEY:{
                'font-size':0,
                'line-height':0,
                position:'absolute',
                'background-color':'#EBEADB',
                left:0,
                top:0
            },
            ICON:{margin:0},
            ITEMS:{
                display:'block',
                border: 'solid 1px',
                'padding-bottom':'1px',
                'border-color':'#fff #A7A6AA #A7A6AA #fff',
                'font-size':0,
                'line-height':0
            },
            HANDLER:{
                height:'20px',
                width:'6px',
                background: linb.UI.$bg('handler.gif', ' left top #EBEADB ', true),
                cursor:'move',
                'vertical-align':'middle'
            },
            GROUP:{
                'font-size':0,
                'line-height':0,
                position:'relative',
                padding:'2px 4px 0px 2px',
                'vertical-align':'baseline'
            },
            ITEM:{
                'vertical-align':'middle'
            },
            BOX:{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                'vertical-align':'middle',
                cursor:'default',
                margin:'0 2px 1px 2px',
                padding:'1px',
                height:'16px',
                'font-size':'12px',
                'line-height':'14px',
                 border:'solid 1px #cdcdcd',
                 'white-space':'nowrap'
            },
            'BOX-mouseover':{
                $order:2,
                'background-color':'#FFFFE0'
            },
            'BOX-mousedown, BOX-checked':{
                $order:2,
                'border-color':'#A7A6AA #FFF #FFF #A7A6AA',
                'background-color':'#C4C4C4'
            },
            'SPLIT':{
                $order:1,
                width:'6px',
                height:'19px',
                'vertical-align':'middle',
                background: linb.UI.$bg('vsplit.gif', ' repeat-y left top', true)
            },
            DROP:{
                width:'7px',
                height:'16px',
                'vertical-align':'middle',
                background: linb.UI.$bg('icon.gif', ' no-repeat left bottom', true)
            },
            'LABEL, CAPTION':{
                height:'16px',
                'vertical-align':'middle',
                'margin-left':'2px',
                'margin-right':'2px',
                 cursor:'default',
                 'font-size':'12px'
            },
            LABEL:{
                'padding-top':'3px'
            }
        },
        Behaviors:{
            HoverEffected:{BOX:['BOX']},
            ClickEffected:{BOX:['BOX']},
            BOX:{
                onClick:function(profile, e, src){
                    if(profile.properties.disabled)return;
                    var id2=src.parentNode.parentNode.parentNode.id,
                        item2 = profile.getItemByDom(id2);
                    if(item2.disabled)return;

                    var id=src.id,
                        item = profile.getItemByDom(id);
                    if(item.disabled)return;

                    linb(src).focus();
                    if(item.statusButton)
                        linb(src).tagClass('-checked',item.value=!item.value);

                    profile.boxing().onClick(profile, item, item2, e, src);
                    return false;
                }
            }
        },
        DataModel:{
            listKey:null,
            tabindex:{
                action:function(value){
                    if(this.domNode)
                        this.getSubNode('ITEM',false).attr('tabIndex',value);
                }
            },

            height:null,

            left:0,
            top:0,

            handler:{
                ini:true,
                action:function(v){
                    this.getSubNode('HANDLER',true).css('display',v?'':'none');
                }
            },
            position:'absolute',
            hAlign:{
                ini:'left',
                listbox:['left','center','right'],
                action:function(v){
                    this.getSubNode('ITEMS', true).css('textAlign', v);
                }
            },
            dock:{
                ini:'top',
                listbox:['top','bottom']
            }
        },
        EventHandlers:{
            onClick:function(profile, item, group, e, src){}
        },
        _prepareData:function(profile){
            var d=arguments.callee.upper.call(this, profile);
            var p = profile.properties;

            d.mode = p.hAlign=='right'?'text-align:right;':'';

            return d;
        },
        _prepareItem:function(profile, oitem, sitem, pid,  mapCache, serialId){
            var dn='display:none', fun=function(profile, dataItem, item, pid, mapCache,serialId){
                var id=dataItem[linb.UI.$tag_subId]=typeof serialId=='string'?serialId:('a_'+profile.pickSubId('aitem')), t;
                if(typeof item=='string')
                    item={caption:item};

                if(false!==mapCache){
                    profile.ItemIdMapSubSerialId[item.id] = id;
                    profile.SubSerialIdMapItem[id] = item;
                }

                if(t=item.object){
                    t=dataItem.object=t['linb.absBox']?t.get(0):t;
                    //relative it.
                    if(t['linb.UIProfile']){
                        t.properties.position='relative';
                        if(!t.CS.KEY)t.CS.KEY='';
                        t.CS.KEY ='vertical-align:middle;margin-left:4px;' + t.CS.KEY;
                    }
                    item.$id=t.$id;
                    t.$item=item;
                    t.$holder=profile;
                    if(!profile.$attached)profile.$attached=[];
                    profile.$attached.push(t);
                }else{
                    if(item.type=='split')item.split=true;
                    linb.UI.adjustData(profile,item, dataItem);

                    dataItem.splitDisplay=dataItem.split?'':dn;
                    dataItem.labelDisplay=dataItem.label?'':dn;
                    dataItem.captionDisplay=dataItem.caption?'':dn;
                    dataItem.dropDisplay=item.dropButton?'':dn;
                    dataItem.boxDisplay= (!dataItem.split && (dataItem.caption || dataItem.image))?'':dn;
                }
                dataItem.itemDisplay=item.visible===false?dn:'';
                item._pid=pid;
            };

            if(pid){
                fun(profile,oitem,sitem,pid,mapCache,serialId);
            }else{
                var arr=[],
                dataItem,
                a=sitem.sub||[];

                pid=sitem.id;
                oitem.mode2 = profile.properties.handler ? '' : dn;
                oitem.grpDisplay=sitem.visible===false?dn:'';
                oitem.sub = arr;
                _.arr.each(a,function(item){
                    dataItem={id: item.id};
                    fun(profile,dataItem,item,pid,mapCache,serialId);
                    arr.push(dataItem);
                });
            }
        }
    }
});
/*
300: ruler width
30: ruler height
15: ruler shadow height

15: indicator width => 8: indicator offset
14: indicator height
*/
Class("linb.UI.Range", ["linb.UI","linb.absValue"],{
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                var p=profile.properties,
                    tpl=p.captionTpl,
                    fun=function(k){return profile.getSubNode(k)},
                    fun1=function(a,i){a.cssPos({left:profile[i], top: box._x2y(profile[i])}) },
                    fun2=function(o,v){o.get(0).style.width = v +'px'},
                    title = fun('CAPTION'),
                    a=fun('IND1'),
                    b=fun('IND2'),
                    r1 = fun('RULER1'),
                    r3 = fun('RULER3'),
                    box = profile.box,
                    arr = box._v2a(value);

                profile._rate= 300/(p.max-p.min);
                //use Math.round
                profile._v1= Math.round((arr[0]-p.min) /  (p.max-p.min) *300) ;
                profile._v2= Math.round((1-(p.max - arr[1]) /  (p.max-p.min)) *300);

                //text value
                title.html(box._buildTpl(p.singleValue,tpl, arr,p.unit),false);
                //indicator position
                fun1(a, '_v1');
                fun1(b,'_v2');
                //background div width
                fun2(r1, profile._v1+8);
                fun2(r3, 300 - profile._v2+8);
            });
        },
        _setDirtyMark:function(){
            return this.each(function(profile){
                if(!profile.domNode)return;
                var properties = profile.properties,
                    o=profile.getSubNode('BOX'),
                    flag=properties.value !== properties.$UIvalue,
                    cls=linb.UI.$css_tag_dirty;

                if(profile.beforeDirtyMark && false===profile.boxing().beforeDirtyMark(profile,flag))
                    return;

                if(flag)
                    o.addClass(cls);
                else
                    o.removeClass(cls);
            });
        }
    },
    Static:{
        Templates:{
            style:'{_style}',
            BOX:{
                tagName:'div',
                RULER:{
                    tagName:'div',
                    IND1:{
                        tagName:'a',
                        href:linb.$href,
                        tabindex:'{tabIndex}',
                        style:'{_single}'
                    },
                    IND2:{
                        tagName:'a',
                        href:linb.$href,
                        tabindex:'{tabIndex}'
                    },
                    RULER1:{
                        style:'{_single}'
                    },
                    RULER3:{}
                },
                TAIL:{
                    tagName:'div',
                    CAPTION:{
                        tagName:'div'
                    },
                    MIN:{
                        text:'{min}'
                    },
                    MAX:{
                        text:'{max}'
                    }
                }
            }
        },
        Appearances:{
            'KEY, RULER, IND1, IND1':{
                'font-size':0,
                'line-height':0,
                position:'relative'
            },
            BOX:{
                position:'absolute',
                left:0,
                top:0,
                width:'316px'
            },
            'CAPTION, IND1, TAIL, MIN':{
                'font-size':'12px',
                'line-height':'12px'
            },
            RULER:{
                $order:1,
                position:'relative',
                height:'30px',
                overflow:'visible',
                'margin-bottom':'3px',
                background: linb.UI.$bg('cmds.gif', ' no-repeat left -241px', true)
            },
            'RULER1, RULER3':{
                position:'absolute',
                top:0,
                height:'30px',
                width:'300px'
            },
            RULER1:{
                left:0,
                background: linb.UI.$bg('cmds.gif', ' no-repeat left -271px', true)
            },
            RULER3:{
                right:0,
                background: linb.UI.$bg('cmds.gif', ' no-repeat right -271px', true)
            },
            'IND1,IND2':{
                display:linb.$inlineBlock,
                zoom:linb.browser.ie6?1:null,
                'z-index':'2',
                width:'15px',
                height:'14px',
                position:'absolute'
            },
            IND1:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat left -225px', true),
                left:'0px',
                top:'11px'
            },
            IND2:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat -15px -225px', true),
                left:'300px',
                top:'1px'
            },
            TAIL:{
                $order:2,
                width:'300px',
                position:'relative'
            },
            CAPTION:{
                position:'relative',
                'text-align':'center'
            },
            MIN:{
                position:'absolute',
                left:0,
                top:0
            },
            MAX:{
                position:'absolute',
                right:0,
                top:0
            }
        },
        Behaviors:{
            IND1:{
                onKeydown:function(profile, e, src){
                    profile.box._keydown.apply(profile.box,[profile, e, src,0]);
                },
                onMousedown:function(profile, e, src){
                    var p=profile.properties,
                        box=profile.box,
                        arr = box._v2a(p.$UIvalue);

                    linb([src]).startDrag(e,{
                        widthIncrement:p.steps?p.width/p.steps:null,
                        dragType:'move',
                        targetReposition:true,
                        horizontalOnly:true,
                        maxLeftOffset: Math.floor(profile._v1),
                        maxRightOffset: Math.floor(profile._v2-profile._v1),
                        dragCursor:'default'
                    });
                    linb([src]).css('zIndex',10).focus();
                    profile.getSubNode('IND2').css('zIndex',5);
                },
                onDrag:function(profile, e, src){
                    var d=linb.DragDrop.getProfile();
                    profile.box._ondrag.apply(profile.box,[profile,d.curPos.left,src,0]);
                },
                onDragstop:function(profile, e, src){
                    var p=profile.properties,
                        box=profile.boxing(),
                        rate = profile._rate,
                        d=linb.DragDrop.getProfile(),
                        f,
                        arr = p.$UIvalue.split(':');
                    profile._v1=d.curPos.left;
                    arr[0]= Math.floor((profile._v1)/rate + p.min);
                    box.setUIValue(arr.join(':'));

                    if(profile._v1==profile._v2){
                        linb([src]).css('zIndex',10);
                        profile.getSubNode('IND2').css('zIndex',5);
                    }
                }
            },
            IND2:{
                onKeydown:function(profile, e, src){
                    profile.box._keydown.apply(profile.box,[profile, e, src,1]);
                },
                onMousedown:function(profile, e, src){
                    var p=profile.properties,
                        box=profile.box,
                        arr = box._v2a(p.$UIvalue);

                    linb([src]).startDrag(e,{
                        widthIncrement:p.steps?p.width/p.steps:null,
                        dragType:'move',
                        targetReposition:true,
                        horizontalOnly:true,
                        maxLeftOffset: Math.floor(profile._v2-profile._v1),
                        maxRightOffset: Math.floor(300 - profile._v2),
                        dragCursor:'default'
                    });
                    linb([src]).css('zIndex',10).focus();
                    profile.getSubNode('IND1').css('zIndex',5);
                },
                onDrag:function(profile, e, src){
                    var d=linb.DragDrop.getProfile();
                    profile.box._ondrag.apply(profile.box,[profile,d.curPos.left,src,1]);
                },
                onDragstop:function(profile, e, src){
                    var p=profile.properties,
                        box=profile.boxing(),
                        rate = profile._rate,
                        d=linb.DragDrop.getProfile(),
                        f,
                        arr = p.$UIvalue.split(':');
                    profile._v2=d.curPos.left;
                    arr[1]= Math.floor((profile._v2)/rate + p.min);
                    box.setUIValue(arr.join(':'));
                }
            }
        },
        DataModel:{
            position:'absolute',
            width:300,
            height:46,
            min:{
                ini:0,
                action:function(){
                    var self=this,t,pro=self.properties,b=self.boxing();
                    b.refresh();
                    if(pro.$UIvalue!=(t=this.box._ensureValue(self,pro.$UIvalue)))
                        b.setValue(t);
                }
            },
            max:{
                ini:100,
                action:function(){
                    var self=this,t,pro=self.properties,b=self.boxing();
                    b.refresh();
                    if(pro.$UIvalue!=(t=this.box._ensureValue(self,pro.$UIvalue)))
                        b.setValue(t);
                }
            },
            unit:{
                ini:'',
                action:function(){
                    this.boxing()._setCtrlValue(this.properties.$UIvalue);
                }
            },
            steps:0,
            captionTpl:{
                ini:'{fromvalue}{unit} - {tovalue}{unit}',
                action:function(){
                    this.boxing()._setCtrlValue(this.properties.$UIvalue);
                }
            },
            value:'0:100',
            singleValue:{
                ini:false,
                action:function(v){
                    this.boxing().refresh();
                }
            }
        },
        _prepareData:function(profile){
            var d=arguments.callee.upper.call(this, profile);
            var p=profile.properties,
                arr=profile.box._v2a(p.value);
            d._single = p.singleValue?'display:none':'';

            p.min=parseFloat(p.min);
            p.max=parseFloat(p.max);

            d.min = d.min + p.unit;
            d.max = d.max + p.unit;
            return d;
        },
        _ensureValue:function(profile, value){
            var p = profile.properties,
                a = value.split(':'),
                min=p.min,
                max=p.max,
                b=[],
                f1=function(a){return parseFloat(a)},
                f2=function(a){return Math.min(max, Math.max(min,a))};
            
            b[0]= f1(a[0]);
            b[1]= f1(a[1]);
            b[0] = Math.min(b[0],b[1]);
            if(!min)min=b[0];
            if(!max)max=b[1];
            b[0]= f2(b[0]);
            b[1]= f2(b[1]);            
            return b.join(':');
        },
        _v2a:function(value){
            return typeof value == 'string'? value.split(':') : value;
        },
        _buildTpl:function(single,tpl,arr,unit){
            return single?
              arr[1] + unit
            : tpl.replace(/\{fromvalue\}/g,arr[0]).replace(/\{tovalue\}/g,arr[1]).replace(/\{unit\}/g,unit);
        },
        _x2y:function(x){
            return Math.floor(15 + 1 - (x) * (15/300));
        },
        _keydown:function(profile, e, src,type){
            var key=linb.Event.getKey(e);
            if(key[0]=='left' || key[0]=='right'){
                var s=src.style, left=parseInt(s.left), pro=profile.properties, steps=pro.steps, span=300/steps, v,f=function(key){
                    return parseInt(profile.getSubNode(key).get(0).style.left);
                };
                left += key[0]=='left'?-1:1;
                if(steps){
                    left = left-left%span;
                    if(key[0]=='right')
                        left += span;
                }
                if(!pro.singleValue)
                    if(type===0){
                        v=f('IND2');
                        if(left>v)left=v;
                    }else{
                        v=f('IND1');
                        if(left<v)left=v;
                    }
                if(left<0)left=0;
                if(left>300)left=300;
                
                s.left=left+'px';

                profile.box._ondrag.apply(profile.box,[profile,left,src,1]);

                var  rate = profile._rate,
                    arr = pro.$UIvalue.split(':');
                if(type===0){
                    profile._v1=left;
                    arr[0]= Math.floor((profile._v1)/rate + pro.min);
                }else{
                    profile._v2=left;
                    arr[1]= Math.floor((profile._v2)/rate + pro.min);
                }
                profile.boxing().setUIValue(arr.join(':'));                
            }
        },
        _ondrag:function(profile, left, src, tag){
            var p=profile.properties,
                d=linb.DragDrop.getProfile(),
                box=profile.box,
                fun=function(k){return profile.getSubNode(k)},
                fun2=function(o,v){o.get(0).style.width = v +'px'},
                cap = fun('CAPTION'),
                r1 = fun('RULER1'),
                r3 = fun('RULER3'),
                t,f,
                arr=this._v2a(p.$UIvalue);

             //adjust top
            src.style.top = this._x2y(left) + 'px';

            t = Math.floor((left)/profile._rate + p.min);

            if(tag){
                arr[1] = t;
                fun2(r3, 300 - left + 8);
            }else{
                arr[0] = t;
                fun2(r1, left + 8);
            }
             cap.html(box._buildTpl(p.singleValue, p.captionTpl, arr,p.unit),false);
        }
    }
});Class("linb.UI.Layout",["linb.UI", "linb.absList"],{
    Instance:{
        getPanel:function(subId){
            return this.get(0).getSubNodeByItemId('PANEL', subId);
        },
        append:function(target, subId){
            var pro=this.get(0);
            return arguments.callee.upper.call(this, target, subId||'main');
        }
    },
    Static:{
        Templates:{
            tagName:'div',
            style:'{_style}',
            text:"{items}",
            $dynamic:{
                items:{
                    ITEM:{
                        tagName:'div',
                        className:'{cls1} {itemClass}',
                        style:'{size};{itemStyle}',
                        MOVE:{
                            $order:0,
                            tagName:'div',
                            className:'{cls2} ',
                            style:'{display}'
                        },
                        CMD:{
                            $order:1,
                            tagName:'div',
                            style:'{cmdDisplay}',
                            className:'{cls3} '
                        },
                        PANEL:{
                            tagName:'div',
                            className:'ui-content',
                            style:'position:absolute;left:0;top:0;',
                            text:linb.UI.$childTag
                        }
                    }
                }
            }
        },
        Appearances:{
            KEY:{
                position:'absolute',
                overflow:'hidden',
                left:0,
                top:0,
                'font-size':linb.browser.ie?0:null,
                'line-height':linb.browser.ie?0:null
            },
            MOVE:{
                $order:0,
                position:'absolute',
                'background-color':'#EBEADB',
                'z-index':'10',
                'font-size':linb.browser.ie?0:null,
                'line-height':linb.browser.ie?0:null
            },
            'MOVE-mouseover':{
                $order:1,
                'background-color':'#f8f8f8'
            },
            CMD:{
                position:'absolute',
                border:'solid 1px #cdcdcd',
                cursor:'pointer',
                'z-index':'20',
                'font-size':linb.browser.ie?0:null,
                'line-height':linb.browser.ie?0:null
            },
            ITEM:{
                position:'absolute',
                overflow:'hidden',
                'border-width':linb.browser.opr?'0px':null,
                'font-size':linb.browser.ie?0:null,
                'line-height':linb.browser.ie?0:null
            },
            PANEL:{
                position:'absolute',
                overflow:'hidden',
                /*for opera, opera defalut set border to 3 ;( */
                'border-width':linb.browser.opr?'0px':null,
                'font-size':linb.browser.ie?0:null,
                'line-height':linb.browser.ie?0:null
            },
            'ITEM-MAIN':{
                left:0,
                right:0,
                top:0,
                bottom:0
            },
            'ITEM-TOP, ITEM-BOTTOM':{
                left:0,
                right:0
            },
            'ITEM-LEFT, ITEM-RIGHT':{
                top:0,
                bottom:0
            },
            'MOVE-TOP':{
                'border-top':'solid 1px #fff',
                'border-bottom':'solid 1px #cdcdcd',
                width:'100%',
                bottom:0,
                height:'4px',
                cursor:'n-resize'
            },
            'MOVE-BOTTOM':{
                'border-top':'solid 1px #fff',
                'border-bottom':'solid 1px #cdcdcd',
                width:'100%',
                top:0,
                height:'4px',
                cursor:'n-resize'
            },
            'MOVE-LEFT':{
                'border-left':'solid 1px #fff',
                'border-right':'solid 1px #cdcdcd',
                height:'100%',
                right:0,
                width:'4px',
                cursor:'w-resize'
            },
            'MOVE-RIGHT':{
                'border-left':'solid 1px #fff',
                'border-right':'solid 1px #cdcdcd',
                height:'100%',
                left:0,
                width:'4px',
                cursor:'w-resize'
            },
            'MOVE-TOP-checked, MOVE-BOTTOM-checked, MOVE-LEFT-checked, MOVE-RIGHT-checked':{
                $order:1,
                'background-color':'#cdcdcd'
            },
            'CMD-TOP':{
                $order:0,
                left:'50%',
                'margin-left':'-15px',
                bottom:0,
                width:'30px',
                height:'4px',
                background: linb.UI.$bg('icon.gif', ' no-repeat left -52px', true)
            },
            'CMD-TOP-mouseover, CMD-BOTTOM-mouseover, CMD-LEFT-mouseover, CMD-RIGHT-mouseover':{
                $order:1,
                'background-color':'#ffff00'
            },
            'CMD-TOP-mouseover, CMD-BOTTOM-mouseover, CMD-LEFT-mouseover, CMD-RIGHT-mouseover':{
                $order:2,
                'background-color':'#ffff00'
            },
            'CMD-BOTTOM':{
                $order:0,
                left:'50%',
                'margin-left':'-15px',
                top:0,
                width:'30px',
                height:'4px',
                background: linb.UI.$bg('icon.gif', ' no-repeat left -60px', true)
            },
            'CMD-LEFT':{
                $order:0,
                top:'50%',
                'margin-top':'-15px',
                right:0,
                height:'30px',
                width:'4px',
                background: linb.UI.$bg('icon.gif', ' no-repeat -84px 0px', true)

            },
            'CMD-RIGHT':{
                $order:0,
                top:'50%',
                'margin-top':'-15px',
                left:0,
                height:'30px',
                width:'4px',
                background: linb.UI.$bg('icon.gif', ' no-repeat -92px -0px', true)

            },
            'MOVE-MAIN':{
                $order:5,
                display:'none'
            },
            'CMD-MAIN':{
                $order:5,
                display:'none'
            }
        },
        Behaviors:{
            DropableKeys:['PANEL'],
            HoverEffected:{MOVE:'MOVE',CMD:'CMD'},
            onSize:function(profile,e){
                var o=profile.root;
                linb.UI.$tryResize(profile, e.width?o.width():null, e.height?o.height():null);
            },
            MOVE:{
                onMousedown:function(profile, e, src){
                    var id=src.id,
                        itemId = profile.getSubId(id),
                        item = profile.getItemByDom(src);
                    if(item.hide)return;

                    var main = profile.getItemByItemId('main'),
                        o=profile.getSubNode('ITEM', itemId),
                        m=profile.getSubNodeByItemId('ITEM', 'main'),
                        cursor=linb([src]).css('cursor'),
                        t=profile.properties,
                        h,w,mh,mw,offset1,offset2;

                    profile.pos=item.pos;

                    if(t.type=='vertical'){
                        h = profile._cur = o.height();
                        mh = m.height();
                        if(item.pos=='before'){
                            offset1 = h - item.min;
                            offset2 = item.max?Math.min(parseInt(item.max)-h, (mh-main.min)):(mh-main.min);
                        }else{
                            offset1 = item.max?Math.min(parseInt(item.max)-h, (mh-main.min)):(mh-main.min);
                            offset2 = h - item.min;
                        }

                        linb([src]).startDrag(e,{
                            dragType:'copy',
                            targetReposition:false,
                            verticalOnly:true,
                            maxTopOffset:offset1,
                            maxBottomOffset:offset2,
                            dragCursor:cursor
                        });
                    }else{
                        w = profile._cur = o.width();
                        mw = m.width();
                        if(item.pos=='before'){
                            offset1 = w - item.min;
                            offset2 = item.max?Math.min(parseInt(item.max)-w, (mw-main.min)):(mw-main.min);
                        }else{
                            offset1 = item.max?Math.min(parseInt(item.max)-w, (mw-main.min)):(mw-main.min);
                            offset2 = w - item.min;
                        }

                        linb([src]).startDrag(e,{
                            dragType:'copy',
                            targetReposition:false,
                            horizontalOnly:true,
                            maxLeftOffset:offset1,
                            maxRightOffset:offset2,
                            dragCursor:cursor
                        });
                    }

                    profile._limited=0;
                },
                onDrag:function(profile, e, src){
                    var t=profile.properties,
                        d=linb.DragDrop,
                        p=linb.DragDrop._profile,
                        b=0;
                    if(t.type=='vertical'){
                        if((p.y<=p.restrictedTop) || (p.y>=p.restrictedBottom))b=true;
                    }else{
                        if(p.x<=p.restrictedLeft || p.x>=p.restrictedRight)b=true;
                    }

                    if(b){
                        if(!profile._limited){
                            profile._bg=p.proxyNode.css('backgroundColor');
                            p.proxyNode.css('backgroundColor','#ff6600');
                            profile._limited=true;
                        }
                    }else{
                        if(profile._limited){
                            p.proxyNode.css('backgroundColor',profile._bg);
                            profile._limited=0;
                        }
                    }

                },
                onDragstop:function(profile, e, src){
                    var t=profile.properties,
                        o=linb([src]).parent(),
                        r=profile.root,
                        item = profile.getItemByDom(src);

                    //add offset and refresh
                    if(t.type=='vertical'){
                        //use size to ignore onresize event once
                        o.height(item.size =  profile._cur + (profile.pos=='before'?1:-1)*linb.DragDrop.getProfile().offset.y);
                        linb.UI.$tryResize(profile,null,r.height());
                    }else{
                        o.width(item.size = profile._cur + (profile.pos=='before'?1:-1)*linb.DragDrop.getProfile().offset.x);
                        //use size to ignore onresize event once
                        linb.UI.$tryResize(profile,r.width(),null);
                    }
                    profile._limited=0;
                }
            },
            CMD:{
                onMousedown:function(profile, e, src){
                    var t=profile.properties,
                        id=src.id,
                        self=linb([src]),
                        itemId = profile.getSubId(id),
                        item = profile.getItemByDom(src),
                        r=profile.root,
                        main = profile.getItemByItemId('main'),
                        m=profile.getSubNodeByItemId('ITEM', 'main'),
                        o = profile.getSubNode('ITEM',itemId),
                        panel = profile.getSubNode('PANEL',itemId),
                        move = profile.getSubNode('MOVE',itemId);

                    if(t.type=='vertical'){
                        // restore resize mode
                        if(item.hide){
                            if(item.size <= m.height() - main.min + t._handlerSize){
                                //restore h
                                o.height(item.size);
                                panel.show();

                                item.hide=false;
                                //set appearance
                                if(item.pos=='before')
                                    self.replaceClass(/bottom/g,'top');
                                else
                                    self.replaceClass(/top/g,'bottom');

                                //hidden 'move'
                                if(!item.locked)move.css('cursor','n-resize');
                                profile.getSubNode('MOVE').tagClass('-checked',false);
                            }else
                                linb.message('no enough space!');
                        // to min and fix mode
                        }else{
                            o.height(t._handlerSize);
                            panel.hide();

                            item.hide=true;
                            if(item.pos=='before')
                                self.replaceClass(/top/g,'bottom');
                            else
                                self.replaceClass(/bottom/g,'top');

                            if(!item.locked)
                                move.css('cursor','default');
                            profile.getSubNode('MOVE').tagClass('-checked');
                        }
                        linb.UI.$tryResize(profile,null,r.height());
                    }else{
                        if(item.hide){
                            if(item.size <= m.width()-main.min + t._handlerSize){
                                o.width(item.size);
                                panel.show();
                                item.hide=false;
                                if(item.pos=='before')
                                    self.replaceClass(/right/g,'left');
                                else
                                    self.replaceClass(/left/g,'right');

                                if(!item.locked)move.css('cursor','w-resize');
                                profile.getSubNode('MOVE').tagClass('-checked',false);
                            }else
                                linb.message('no enough space!');
                        }else{
                            o.width(t._handlerSize);
                            panel.hide();
                            item.hide=true;
                            if(item.pos=='before')
                                self.replaceClass(/left/g,'right');
                            else
                                self.replaceClass(/right/g,'left');


                            if(!item.locked)
                                move.css('cursor','default');
                            profile.getSubNode('MOVE').tagClass('-checked');
                        }
                        linb.UI.$tryResize(profile,r.width(),null);
                    }

                    return false;
                }
            }
        },
        DataModel:{
            disabled:null,
            position:'absolute',
            type:{
                listbox:['vertical', 'horizontal'],
                ini:'vertical',
                action:function(value, ovalue){
                    if(value != ovalue){
                        var self=this, auto='auto',
                        nodes2 = self.getSubNode('ITEM',true),
                        nodes1 = self.getSubNode('MOVE',true),
                        nodes3 = self.getSubNode('CMD',true);
                        nodes1.merge(nodes2).merge(nodes3);

                        if(value=='vertical'){
                            nodes1.replaceClass(/(-left)(\b)/ig,'-top$2');
                            nodes1.replaceClass(/(-right)(\b)/ig,'-bottom$2');
                            nodes2.each(function(o){
                                linb(o).height(linb(o).width());
                            })
                            .cssRegion({left:0,top:auto,right:auto,bottom:auto})
                            ;
                        }else{
                            nodes1.replaceClass(/(-top)(\b)/ig,'-left$2');
                            nodes1.replaceClass(/(-bottom)(\b)/ig,'-right$2');
                            nodes2.each(function(o){
                                linb(o).width(linb(o).height());
                            })
                            .cssRegion({left:auto,top:0,right:auto,bottom:auto})
                            ;

                        }

                        var size = self.root.cssSize();
                        linb.UI.$tryResize(self, size.width, size.height);
                    }
                }
            },
            dock:'fill',
            listKey:null,
            width:200,
            height:200,
            _handlerSize:6,

            items:{
                ini:[],
                set:function(value){
                    return this.each(function(o){
                        if(o.domNode){
                            var box = o.boxing(),
                                temp = linb.Dom.getEmptyDiv(),
                                //keep children
                                children = _.copy(o.children),
                                p,vv
                            ;
                            o.children.length=0;
                            _.arr.each(children,function(o){
                                //for flush dock
                                delete o[0].$dockParent;
                                //keep it in dom
                                temp.append(o[0].root);
                            });

                            //bak value

                            //clear all
                            box.clearItems();
                            //call gc to clear onresize setting
                            linb.Dom.__gc();

                            //set items
                            //for adjust 'main'
                            vv = o.box._prepareV(o, value);
                            //inset items
                            box.insertItems(vv);

                            //restore children
                            _.arr.each(children,function(v){
                                box.append.apply(box,v);
                            });

                            //clear
                            temp.empty();
                            //set value

                            //resize
                            var size = o.root.cssSize();
                            linb.UI.$tryResize(o, size.width, size.height);
                        }else
                            o.properties.items = _.copy(value);
                    });
                }
            }
        },
        _prepareV:function(profile, items){
            var main, before=[], after=[];
            //arrage items
            _.arr.each(items,function(o){
                if(o.id=='main'){
                    main=o
                }else{
                    if(o.pos=='before')
                        before.push(o);
                    else{
                        o.pos='after';
                        after.push(o);
                    }
                }
            });

            main = main || {};
            main.id = 'main';
            main.min = main.min || 10;

            //reset items
            items.length = 0;
            _.arr.insertAny(items, before,0);
            _.arr.insertAny(items, main);
            _.arr.insertAny(items, after);

            //set the items to default value
            _.arr.each(items,function(o){
                o.id = _.isStr(o.id)?o.id:profile.$id+':'+_.id();
                o.min = o.min || 10;
                if(o.id!='main'){
                    o.size = parseInt(o.size) || 20;
                    o.locked= typeof o.locked=='boolean'?o.locked:false;
                    o.hide = typeof o.hide=='boolean'?o.hide:false;
                    o.cmd = typeof o.cmd=='boolean'?o.cmd:false;
                }
            });
            return items;
        },
        _prepareData:function(profile){
            var prop=profile.properties;
            if(!prop.items || prop.items.constructor != Array)
            prop.items = _.clone([
                {id:'before', pos:'before', locked:false, size:60, min: 50, max:200},
                {id:'after',pos:'after', locked:false, size:60, min: 50, max:200}
            ]);

            prop.items = this._prepareV(profile, prop.items);
            return arguments.callee.upper.call(this, profile);
        },
        _prepareItem:function(profile, item){
            var pp=profile.properties;
            if(item.id=='main'){
                item.cls1=profile.getClass('ITEM', '-main');
                item.cls2  = profile.getClass('MOVE', '-main');
                item.cls3  = profile.getClass('CMD', '-main' );
                return;
            }

            if(pp.type=='vertical')
                item.size = 'height:'+item.size+'px';
            else
                item.size = 'width:'+item.size+'px';

            var pos;
            if(pp.type=='vertical'){
                if(item.pos=='before')
                    pos='top';
                else
                    pos='bottom';
            }else{
                if(item.pos=='before')
                    pos='left';
                else
                    pos='right';
            }

            item.cls1  = profile.getClass('ITEM', '-' + pos );
            item.cls2  = profile.getClass('MOVE', '-' + pos );
            item.cls3  = profile.getClass('CMD', '-' + pos );
            item.display = item.locked?'display:none':'';
            item.cmdDisplay = item.cmd?'':'display:none';
        },
        RenderTrigger:function(){
            var t, profile=this;
            _.arr.each(profile.properties.items,function(item){
                if(item.id!='main'){
                    if(item.hide && (t=profile.getSubIdByItemId(item.id))){
                            item.hide=false;
                            profile.getSubNode('CMD',t).onMousedown();
                        }
                }
            });
        },
        _onresize:function(profile,width,height){
            var _t,t=profile.properties, m,n, itemId, temp1,temp2,temp, key=profile.keys.ITEM, panel=profile.keys.PANEL;

            var obj={}, obj2={};
            _.arr.each(t.items,function(o){
                itemId = profile.getSubIdByItemId(o.id);
                obj[itemId] = {};
                obj2[itemId] = {};
            });
            if(t.type!='vertical'){
                if(!_.isNull(width)){
                    //get left
                    temp=temp1=temp2=0;
                    _.arr.each(t.items,function(o){
                        if(o.id=='main')return;
                        itemId = profile.getSubIdByItemId(o.id);
                        if(o.pos=='before'){
                            n=profile.getSubNode('ITEM', itemId);
                            m= n.width();//offsetWidth();

                            obj2[itemId].left=temp1;
                            temp1 +=m;
                            obj2[itemId].right='auto';
                            obj[itemId].right='auto';
                            obj[itemId].left=0;
                            obj[itemId].width = m - (o.locked?0:t._handlerSize);
                        }
                    });
                    _.arr.each(t.items,function(o){
                        if(o.id=='main')return;
                        itemId = profile.getSubIdByItemId(o.id);
                        if(o.pos=='after'){
                            n =profile.getSubNode('ITEM', itemId);
                            m= n.width();//offsetWidth();

                            obj2[itemId].right=temp2;
                            temp2 +=m;
                            obj2[itemId].left='auto';
                            obj[itemId].right=0;
                            obj[itemId].left='auto';
                            obj[itemId].width = m-(o.locked?0:t._handlerSize);
                        }
                    },null,true);
                    temp = temp1+temp2;

                    //set main
                    //specify widht/height first,
                    if(width-temp>=0){
                        _t=profile.getSubIdByItemId('main');
                        obj[_t].width=width-temp;
                        obj2[_t].width=width-temp;
                        obj2[_t].left=temp1;
                    }
                }
                if(!_.isNull(height)){
                    _.each(obj,function(o,id){
                        o.height=height;
                        obj2[id].height=height;
                    });
                }
            }else{
                if(!_.isNull(height)){
                    //get top
                    temp=temp1=temp2=0;
                    _.arr.each(t.items,function(o){
                        if(o.id=='main')return;
                        itemId=profile.getSubIdByItemId(o.id);
                        if(o.pos=='before'){
                            n=profile.getSubNode('ITEM', itemId);
                            m = n.height();//offsetHeight();

                            obj2[itemId].top=temp1;
                            temp1 += m;
                            obj2[itemId].bottom='auto';
                            obj[itemId].top=0;
                            obj[itemId].bottom='auto';
                            obj[itemId].height=m-(o.locked?0:t._handlerSize);
                        }
                    });
                    _.arr.each(t.items,function(o){
                        if(o.id=='main')return;
                        itemId=profile.getSubIdByItemId(o.id);
                        if(o.pos=='after'){
                            n=profile.getSubNode('ITEM', itemId);
                            m=n.height();//offsetHeight();

                            obj2[itemId].bottom=temp2;
                            temp2 += m;
                            obj2[itemId].top='auto';
                            obj[itemId].bottom=0;
                            obj[itemId].top='auto';
                            obj[itemId].height=m-(o.locked?0:t._handlerSize);
                        }
                    },null,true);

                    temp =temp1+temp2;
                    //set main
                    if(height-temp>=0){
                        _t=profile.getSubIdByItemId('main');

                        obj[_t].height=height-temp;
                        obj2[_t].height=height-temp;
                        obj2[_t].top=temp1;
                    }
                }
                if(!_.isNull(width)){
                    _.each(obj,function(o, id){
                        o.width=width;
                        obj2[id].width=width;
                    });
                }
            }
            //collect width/height in size
            _.each(obj, function(o, id){
                profile.getSubNode('PANEL', id).cssRegion(o, true);
            });
            _.each(obj2, function(o, id){
                profile.getSubNode('ITEM', id).cssRegion(o);
            });
        }
    }
});
//rowMap => row_SerialIdMapItem
//rowMap2 => row_ItemIdMapSerialId
//colMap => header_SerialIdMapItem
//colMap2 => header_ItemIdMapSerialId
//cellMap => cells_SerialIdMapItem
Class("linb.UI.TreeGrid",["linb.UI","linb.absValue"],{
    Instance:{
        _setCtrlValue:function(value){
            return this.each(function(profile){
                if(!profile.domNode)return;

                var box = profile.boxing(),
                    uiv = box.getUIValue(),
                    p = profile.properties,
                    k = p.activeMode=='row'?'CELLS':'CELL',
                    getN = function(k,i){return profile.getSubNode(k,i)},
                    getI = function(i){
                        var map1=profile.rowMap2;
                        if(p.activeMode=='row')
                            return map1[i];
                        else{
                            if(!i)return;
                            var r=i.split('|');
                            return _.get(profile.rowMap,[map1[r[0]],'_cells',r[1]]);
                        }
                    };

                if(p.selMode=='single'){
                    var itemId = getI(uiv);
                    if(uiv && itemId)
                        getN(k,itemId).tagClass('-checked',false);

                    itemId = getI(value);
                    if(itemId)
                        getN(k,itemId).tagClass('-checked');

                    //scroll
                    if(itemId){
                        var o = getN(k,itemId);
                        if(o){
                            var top = o.offsetTop(),
                            items = getN('SCROLL'),
                            sh=items.scrollHeight(),
                            st=items.scrollTop(),
                            hh=items.height()
                            ;
                            if(sh > hh)
                                if(top<st || top>st+hh)
                                    items.scrollTop(top);

                        }
                    }
                }else if(p.selMode=='multi'){
                    uiv = uiv?uiv.split(';'):[];
                    value = value?value.split(';'):[];
                    //check all
                    _.arr.each(uiv,function(o){
                        if(_.arr.indexOf(value,o)==-1)
                            getN(k, getI(o)).tagClass('-checked',false)
                    });
                    _.arr.each(value,function(o){
                        if(_.arr.indexOf(uiv,o)==-1)
                            getN(k, getI(o)).tagClass('-checked')
                    });
                }
            });
        },
        /*insert rows to dom
        arr is formatted properties
        pid,base are item id
        before: insert before?
        */
        _insertRowsToDom:function(profile, arr, pid, base, before){
            //if parent not open, return
            if(pid){
                var parent = profile.rowMap[pid];
                if(parent && !parent._created)return;
            }

            var obj,hw,
                hw=profile.getSubNode('HCELL0').width();
            //give width at here
            _.arr.each(arr,function(o){
                o._row0DfW = hw-o._layer*profile.properties.$subMargin;
                _.arr.each(o.cells,function(v,i){
                    v.width=v._col.width;
                })
            });

            //build dom
            var nodes = _.str.toDom(profile.buildItems('rows', arr));
            //get base dom
            if(!base){
                //no base add to parent
                if(pid){
                    obj = profile.getSubNode('SUB', pid);
                }else{
                    obj = profile.getSubNode('BODY');
                }
                if(before)
                    obj.prepend(nodes);
                else
                    obj.append(nodes);
            }else{
                //
                obj = profile.getSubNode('ROW', base);
                if(before)
                    obj.addPrev(nodes);
                else{
                    nodes.get().reverse();
                    obj.addNext(nodes);
                }
            }

            //add sub
            _.arr.each(arr,function(o){
                o.open=false;
            });

            //clear rows cache
            delete profile.$allrowscache;
        },
        _refreshHeader:function(header){
            var profile=this.get(0),
                pro=profile.properties,
                rows = _.copy(pro.rows),
                arr = profile.box._prepareHeader(profile, header),
                nodes = _.str.toDom(profile.buildItems('header', arr));

            pro.header = header;
            this.removeAllRows();
            profile.getSubNode('HCELL', true).remove(false);
            profile.getSubNode('HCELLS').append(nodes);
            this.insertRows(rows);
            profile.box._ajdustBody(profile);
        },
        //pid,base are id
        insertRows:function(arr, pid, base ,before){
            var c=this.constructor, profile=this.get(0), pro=profile.properties, row_m=profile.rowMap2, t;
            base = row_m[base];
            if(base){
                t=profile.rowMap[base];
                if(t)pid=t._pid;
            }
            //prepareData(add links)
            var rows = c._prepareItems(profile, arr, pid),
                tar,
                b=profile.rowMap;

            pid = row_m[pid];
            if(!pid)
                tar = (pro.rows || (pro.rows=[]));
            else
                tar = (b[pid].sub || (b[pid].sub=[]));
            if(!base)
                _.arr.insertAny(tar,arr, before?0:-1);
            else{
                var index = _.arr.subIndexOf(tar,'_serialId', base);
                _.arr.insertAny(tar,arr, before?index:(index+1));
            }

            //insert
            this._insertRowsToDom(profile, rows, pid, base, before);

            if(!pro.iniFold)
                profile.boxing()._toggleRows(rows, true);

            profile.box._asy(profile,false);
            return this;
        },
        //delete row according to id
        /*
            linb.UI.TreeGrid.getAll().removeRows(['2','5'])
        */
        removeRows:function(ids){
            var self=this,
                profile=self.get(0),
                p=profile.properties,
                cell=profile.cellMap,
                nodes=[],v;

            //get array
            ids = _.isArr(ids)?ids:[ids];
            _.arr.each(ids,function(id){
                //get item id
                if(!(id=profile.rowMap2[id]))return;

                //get row
                var row;
                if(row = profile.rowMap[id]){
                    var tdids = row._cells,
                        rowid = row.id,
                        temp;
                    //for sub delete
                    if(row.sub){
                        var arr=[];
                        _.arr.each(row.sub,function(o){
                            arr.push(o.id)
                        });
                        self.removeRows(arr);
                    }

                    ////delete and clear links
                    _.each(tdids,function(o,i){
                        //clear colMap/properties.header
                        delete cell[o]._col._cells[rowid];
                        //clear cellMap
                        delete cell[o];
                        profile.reclaimSubId(o.slice(2), 'cell');
                    });

                    //clear properties.row array
                    if(temp= row._pid?(temp=profile.rowMap[profile.rowMap2[row._pid]])?temp.sub:null:profile.properties.rows)
                        _.filter(temp,function(o){
                            return o._serialId != id;
                        });

                    //clear profile.rowMap2
                    delete profile.rowMap2[rowid];
                    //clear rowMap
                    delete profile.rowMap[id];

                    nodes.push(profile.getSubNode('ROW', id).get(0));
                }
                    profile.reclaimSubId(id.slice(2), 'row');
            });
            // clear value
            if(v=p.value){
                if((v=v.split(';')).length>1){
                    _.filter(v,function(o){
                        return _.arr.indexOf(arr,o)==-1;
                    });
                    p.value=v.join(';');
                }else{
                    if(_.arr.indexOf(arr,p.value)!=-1)
                        p.value=null;
                }
            }
            linb(nodes).remove();
            profile.box._asy(profile,false);
            return self;
        },
        removeAllRows:function(){
            var profile=this.get(0);
            for(var i in profile.cellMap)
                profile.reclaimSubId(i.slice(2), 'cell');
            for(var i in profile.rowMap)
                profile.reclaimSubId(i.slice(2), 'row');
            _.each(profile.colMap,function(o){
                o._cells={};
            });

            profile.rowMap={};
            profile.cellMap={};
            profile.rowMap2={};

            profile.properties.rows.length=0;

            profile.getSubNode('BODY').empty();
            profile.getSubNode('SCROLL').scrollTop(0).scrollLeft(0);

            return this;
        },

        updateCellByRowCol:function(rowId, colId, hash){
            var t,self=this,con=self.constructor;
            if(t=con._getCellId(self.get(0), rowId, colId))
                con._updCell(self.get(0), t, hash);
            return self;
        },
        updateCell:function(cellId, hash){
            var self=this;
            self.constructor._updCell(self.get(0),cellId,hash);
            return self;
        },
        _toggleRows:function(rows, expend){
            var self=this;
            if(rows && rows.length)
                _.arr.each(rows,function(o){
                    if(o.sub && o.sub.length && !o.iniFold && !o._checked)
                        self.toggleRow(o.id, expend);
                });
        },
        toggleRow:function(id, expend){
            var profile = this.get(0),
            row = profile.rowMap[profile.rowMap2[id]];
            if(row && !row._checked)
                profile.box._setSub(profile, row, expend);
        },
        editCellbyRowCol:function(rowId, colId){
            var profile=this.get(0),con=profile.box;
            return con._editCell(profile, con._getCellId(profile, rowId, colId));
        },
        getCellbyRowCol:function(rowId, colId){
            var profile=this.get(0),v;
            v=_.get(profile.rowMap,[profile.rowMap2[rowId], '_cells',colId]);
            return v?profile.cellMap[v]:null;
        },
        getRowbyRowId:function(rowId){
            var profile=this.get(0),v=profile.rowMap2[rowId];
            return v?profile.rowMap[v]:null;
        },
        resetGridValue:function(){
            return this.each(function(profile){
                _.each(profile.cellMap,function(v){
                    v.$value=v.value;
                });
                profile.getSubNode('CELLA',true).removeClass('ui-dirty');
            })
        },
        resetRowValue:function(rowId){
            var profile=this.get(0),row=this.getRowbyRowId(rowId),arr=[];
            _.each(row.cells,function(o){
                if(o.$value!==o.value){
                    o.$value=o.value;
                    arr.push(profile.getSubNode('CELLA',o._serialId).get(0));
                }
            });
            linb(arr).removeClass('ui-dirty');
        },
        showColumn:function(colId, flag){
            return this.each(function(profile){
                var map=profile.colMap2,
                    cols=profile.colMap,
                    col,
                    sid,
                    cells,
                    n=[];
                if(col=cols[sid=map[colId]]){
                    n.push(profile.getSubNode('HCELL',sid).get(0));
                    _.each(col._cells,function(id){
                        n.push(profile.getSubNode('CELL',id).get(0));
                    });
                    linb(n).css('display',(col.visibility=(flag===false?false:true))?'':'none');
                }
            });
        }
    },
    Initialize:function(){
        this.addTemplateKeys(['ALT','PROGRESS']);
    },
    Static:{
        Templates:{
            tagName : 'div',
            style:'{_style}',
            BORDER:{
                tagName : 'div',
                BOX:{
                    tagName:'div',
                    HEADER:{
                        $order:0,
                        tagName:'div',
                        style:"{showHeader}",
                        //for scroll performance
                        HI:{
                            tagName:'div',
                            style:'width:10000px;',
                            HCELLS:{
                                tagName:'div',
                                style:'height:{headerHeight}px;',
                                /*the first col (row handler) in table header*/
                                HCELL0:{
                                    $order:0,
                                    style:'{rowHandlerDisplay};width:{_row0DfW}px;',
                                    HCELL0A:{
                                        HHANDLER:{
                                            tagName:'div',
                                            style:'{colDDDisplay}'
                                        },
                                        ROWHANDLER:{
                                            tagName:'div',
                                            style:'{rowDDDisplay}'
                                        }
                                    }
                                },
                                OTHERHCELLS:{
                                    $order:1,
                                    tagName:'text',
                                    text:'{header}'
                                }
                            }
                        }
                    },
                    SCROLL:{
                        $order:1,
                        tagName:'div',
                        className:'ui-content ',
                        BODY:{
                            tagName:'div',
                            text:'{rows}'
                        }
                    },
                    FOOTER:{
                        $order:2
                    },
                    COLLIST:{
                        tagName:'div'
                    }
                }
            },
            $dynamic : {
                /*the other header in table header*/
                header:{
                    HCELL:{
                        className:'{headerClass}',
                        style:"width:{width}px;{headerStyle}",
                        HCELLA:{
                            text:"{caption}",
                            SORT:{
                                style:'{sortDisplay}'
                            },
                            HHANDLER : {
                                $order:2,
                                tagName:'div',
                                style:'{colDDDisplay}'
                            }
                        }
                    }
                },
                rows:{
                    ROW:{
                        tagName:'div',
                        PREVIEW:{
                            $order:1,
                            tagName:'div',
                            style:'{previewDisplay}',
                            text:'{preview}'
                        },
                        CELLS:{
                            $order:2,
                            tagName:'div',
                            className:'{rowCls} {rowClass}',
                            style:'height:{rowHeight}px;{rowStyle}',
                            FIRSTCELL:{
                                $order:0,
                                style:'{rowHandlerDisplay};width:{_row0DfW}px;',
                                FIRSTCELLA:{
                                    TOGGLE:{$order:1,
                                        className:'uicmd-toggle',
                                        style:'{display}'
                                    },
                                    ROWHANDLER:{
                                        tagName:'div',
                                        style:'{rowDDDisplay}'
                                    },
                                    FIRSTCELLNO:{
                                        text:' '
                                    }
                                }
                            },
                            OTHERCELLS:{
                                tagName:'text',
                                $order: 1,
                                text:'{caption}{cells}'
                            }
                        },
                        SUB:{
                            $order:3,
                            tagName:'div'
                        },
                        SUMMARY:{
                            $order:4,
                            tagName:'div',
                            style:'{summaryDisplay}',
                            text:'{summary}'
                        }
                    }
                },
                'rows.cells':function(profile,template,v,tag,result){
                    var me=arguments.callee,map=me._m||(me._m={'checkbox':'.checkbox','button':'.button','progress':'.progress'});
                    linb.UI.$doTemplate(profile,template,v,tag+(map[v.type]||'.input'),result)
                 },
                'rows.cells.input':{
                    CELL:{
                        style:'width:{width}px;{cellDisplay};{cellStyle}',
                        className:'{cellCls} {cellClass}',
                        CELLA:{
                            tagName:'a',
                            style:'{bgcolor};{color};',
                            href :linb.$href,
                            tabindex: '{_tabindex}',
                            text:"{caption}"
                        }
                    }
                },
                'rows.cells.button':{
                    CELL:{
                        style:'width:{width}px;{cellDisplay};{cellStyle}',
                        className:'{cellCls} {cellClass}',
                        CELLA:{
                            tagName:'button',
                            tabindex: '{_tabindex}',
                            text:"{caption}"
                        }
                    }
                },
                'rows.cells.checkbox':{
                    CELL:{
                        style:'width:{width}px;{cellDisplay};{cellStyle}',
                        className:'{cellCls} {cellClass}',
                        CELLA:{
                            tagName:'a',
                            href :linb.$href,
                            tabindex: '{_tabindex}',
                            CHECKBOX:{
                                className:'{checkboxCls}'
                            }
                        }
                    }
                },
                'rows.cells.progress':{
                    CELL:{
                        style:'width:{width}px;{cellDisplay};{cellStyle}',
                        className:'{cellCls} {cellClass}',
                        CELLA:{
                            tagName:'a',
                            href :linb.$href,
                            tabindex: '{_tabindex}',
                            PROGRESS:{
                                tagName:'div',
                                style:'width:{progress};',
                                text:'{caption}'
                            }
                        }
                    }
                }
            }
        },
        Appearances:{
            KEY:{
                //in firefox, a can focused with display:block
                display:'block',
                position:'absolute',
                overflow:'hidden'
            },
            BOX:{
                display:'block',
                position:'relative',
                overflow:'hidden'
            },

            HEADER:{
                background:  linb.UI.$bg('head.gif', ' #EBEADB repeat-x left bottom'),
                position:'relative',
                overflow:'hidden'
            },
            HI:{
                position:'relative'
            },
            SCROLL:{
                overflow:'auto',
                position:'relative'
            },
            COLLIST:{
                position:'absolute',
                'z-index':'10',
                left:0,
                top:0,
                cursor:'pointer',
                visibility:'hidden',
                background:  linb.UI.$bg('collist.gif', ' #EBEADB no-repeat center bottom'),
                border:'1px solid',
                'border-color':  '#fff #ACA899 #ACA899 #fff'
            },
            BODY:{
                overflow:'visible',
                position:'absolute',
                'background-color':' #fff',
                left:0,
                top:'0',
                'font-size':0,
                'line-height':0,
                'border-bottom': '1px solid #ACA899'
            },
            'SORT, SORT-checked':{
                width:'15px',
                height:'15px'
            },
            SORT:{
                background: linb.UI.$bg('cmds.gif', ' no-repeat -191px top', true),
                position:'absolute',
                right:'2px',
                bottom:'2px'
            },
            'HCELL-mouseover SORT':{
                $order:1,
                'background-position': '-191px -15px'
            },
            'HCELL-mousedown SORT':{
                $order:2,
                'background-position': '-191px -30px'
            },
            'SORT-checked':{
                $order:3,
                'background-position': '-206px top'
            },
            'HCELL-mouseover SORT-checked':{
                $order:4,
                'background-position': '-206px -15px'
            },
            'HCELL-mousedown SORT-checked':{
                $order:5,
                'background-position': '-206px -30px'
            },
            HHANDLER:{
                position:'absolute',
                //if set z-index, disappearing in opera
                //'z-index':'10',
                background: linb.browser.ie?'url('+linb.ini.file_bg+')':null,
                width:'4px',
                top:'0',
                right:'0',
                height:'100%',
                cursor:'e-resize',
                'font-size':0,
                'line-height':0
            },
            'HCELLS, CELLS':{
                //for ie6 height change trigger
                'overflow-y': linb.browser.ie6 ?'hidden':'',
                position:'relative',
                'white-space': 'nowrap',
                'font-size':'12px',
                'line-height':'18px'
            },
            HCELLS:{
                'padding-bottom':'2px'
            },
            'CELLS-group':{
                $order:1,
                'font-weight':'bold',
                color:'#3764A0',
                'border-right': '1px solid #ACA899'
            },
            'PREVIEW,SUMMARY':{
                position:'relative',
                display:'none',
                'padding-left':'16px',
                'border-right': '1px solid #ACA899'
            },
            PREVIEW:{
                'border-bottom': '1px dashed #ACA899'
            },
            SUMMARY:{
                'border-top': '1px dashed #ACA899'
            },
           'CELLS-mouseover':{
                $order:4,
                'background':linb.UI.$bg('row-over.gif', ' #D9E8FB repeat-x left top')
            },
            'CELL-disabled':{
                 $order:8,
                 'background-color':'#EBEADB'
            },
            'CELL-disabled CELLA':{
                 $order:8,
                 color:'#999'
            },
            'CELLS-active, CELL-active':{
                 $order:5,
                 background:linb.UI.$bg('row-active.gif', ' #FDFDFD repeat-x left top')
            },
            'CELLS-checked, CELL-checked':{
                 $order:6,
                background:linb.UI.$bg('row-checked.gif', ' #A7F2FE repeat-x left top')
            },
            'HCELL0, FIRSTCELL, GROUPCAP':{
               height:'100%',
                'font-weight':'bold',
                'font-size':'12px',
                'line-height':'20px',
                'vertical-align':'top'
            },
            FIRSTCELL:{
                'padding-left':'1px',
                'padding-right':'1px'
            },
            'HCELL0A, FIRSTCELLA':{
                '-moz-box-flex':'1',
                '-moz-user-select':'none',
                display:'block',
                position:'relative',
                overflow:'hidden',
                height:'100%'
            },
            FIRSTCELLA:{
                'text-align': 'left',
                'padding-left':'4px'
            },
            TDFCAPTION:{
                'font-weight':'bold'
            },
            ROWHANDLER:{
                position:'absolute',
                'height':'4px',
                left:'0px',
                width:'100%',
                bottom:'0px',
                cursor:'n-resize',
                'z-index':10,
                'font-size':0,
                'line-height':0
            },
            'HCELL0, HCELL':{
               height:'100%',
               'border-left':'1px solid #fff',
               'border-right':'1px solid #ACA899',
               padding:0,
               'vertical-align':'top',
                'font-size':'12px',
                'line-height':'14px'
            },
            'HCELL-mouseover':{
                background:  linb.UI.$bg('head-over.gif', ' #FAF9F4 repeat-x left bottom')
            },
            ROW:{
                '_position':'relative',
                zoom:linb.browser.ie?1:null,
                'border-top': '1px solid #ACA899',
                'font-size':0,
                'line-height':0
            },
           CELL:{
                //firefox:height:100% without overflow:hidden
                'padding-left':'1px',
                'border-right':'1px solid #ACA899',
                height:'100%',
                position:'relative',
                overflow:linb.browser.ie6?'hidden':'',
                'font-size':'12px',
                'line-height':'20px',
                'vertical-align':'top'
            },
            'ALT':{
                'background-color':'#f1f1f1'
            },
            //
            'CELL-label a':{
                color: '#000'
            },
            'CELL-input':{
            },
            'CELL-number':{
                'text-align':'right'
            },
            'CELL-checkbox':{
                'text-align':'center'
            },
            'CELL-button CELLA':{
                width:'100%'
            },
            'CELL-mouseover':{
                $order:5,
                background:linb.UI.$bg('row-over.gif', ' #D9E8FB repeat-x left top')
            },
            HCELLA:{
                position:'relative'
            },
            'HCELLA, CELLA':{
                display:'block',
                overflow:'hidden',
                '-moz-box-flex':'1',
                '-moz-user-select':'none',
                height:'100%',
                //ie need this
                width:linb.browser.ie?'100%':''
            },
            'CELLA-inline':{
                $order:5,
                display:'inline',
                '-moz-box-flex':0
            },
            'HCELLA, HCELL0A':{
                'text-align': 'center',
                'font-weight': 'bold'
            },
            CHECKBOX:{
               cursor:'pointer',
               width:'16px',
               height:'16px',
               background: linb.UI.$bg('cmds.gif', ' no-repeat -112px top', true)
            },
            PROGRESS:{
                height:'100%',
                'background-color':'#00ffff',
                'text-align':'center',
                overflow:'visible',
                opacity:0.7,
                '*filter':'alpha(opacity=70)'
            },
            'CELL-mouseover CHECKBOX':{
                $order:1,
                'background-position': '-112px -17px'
            },
            'CELL-mousedown CHECKBOX':{
                $order:2,
                'background-position': '-112px -34px'
            },
            'CHECKBOX-checked':{
                $order:3,
                'background-position': '-96px top'
            },
            'CELL-mouseover CHECKBOX-checked':{
                $order:4,
                'background-position': '-96px -17px'
            },
            'CELL-mousedown CHECKBOX-checked':{
                $order:5,
                'background-position': '-96px -34px'
            },
            SUB:{
                //for ie bug: relative , height='auto' will disppear
                '*zoom':'1',
                '_position':'relative',
                'border-left': '1px solid #ACA899',
                'margin-left':'15px',
                display:'none'
            },
            FIRSTCELLNO:{
                'font-weight':'normal'
            }
        },
        Behaviors:{
            HoverEffected:{TOGGLE:'TOGGLE', HCELL:'HCELL'},
            ClickEffected:{TOGGLE:'TOGGLE', CELL:'CELL', HCELL:'HCELL'},
            DropableKeys:['SCROLL','CELLS','TOGGLE'],
            DragableKeys:['FIRSTCELL'],

            onSize:function(profile,e){
                var o = profile.root;
                linb.UI.$tryResize(profile, e.width?o.width():null, o.height?o.height():null);
            },
            HCELL0A:{
                onClick:function(profile,e,src){
                    profile.getSubNode('COLLIST').onClick(true);
                }
            },
            //key navigator
            SCROLL:{
                onScroll:function(profile, e, src){
                    var l=src.scrollLeft||0;
                    if(profile.$sl!=l)
                        profile.getSubNode('HEADER').get(0).scrollLeft=profile.$sl=l;
                }
            },
            //colomn resizer
            HHANDLER:{
                onMousedown:function(profile, e, src){
                    var p=profile.properties,
                    o=linb(src),
                    minW =o.parent(2).width()-p._minColW,
                    scroll = profile.getSubNode('SCROLL'),
                    maxW = scroll.offset().left + scroll.width() - linb.Event.getPos(e).left - 4,
                    id = profile.getSubId(src.id),
                    col = profile.colMap[id];

                    if(p.disabled)return false;
                    if(col && col.disabled)return false;

                    o.startDrag(e, {
                        horizontalOnly:true,
                        dragType:'blank',
                        dragDefer:2,
                        maxLeftOffset:minW,
                        maxRightOffset:maxW,
                        targetReposition:false
                    });
                    linb([src.parentNode.parentNode]).onMouseout(true,{$force:true}).onMouse