<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 控制器
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
abstract class PHPnowAction extends PHPnowClass {
	public function __set($name, $value) {
		$this->assign ( $name, $value );
	}
	/**
	 * 存取值
	 * Order of precedence: 1. GET, 2. POST, 3. COOKIE, 4. SERVER, 5. ENV
	 * @param string $key
	 * @return mixed
	 */
	public function get($key) {
		return $this->PHPnowRequest->get ( $key );
	}
	/**
	 * 检索$_GET
	 * @param string $key
	 * @param mixed $defaul
	 * @return mixed
	 */
	public function getQuery($key = null, $default = null) {
		return $this->PHPnowRequest->getQuery ( $key, $default );
	}
	
	/**
	 * 设置$_POST
	 * @param  string|array $spec
	 * @param  null|mixed $value
	 * @return PHPnowRequest
	 */
	public function setPost($spec, $value = null) {
		return $this->PHPnowRequest->setPost ( $spec, $value );
	}
	
	/**
	 * 返回$_POST
	 * @param string $key
	 * @param mixed $default
	 * @return mixed Returns
	 */
	public function getPost($key = null, $default = null) {
		return $this->PHPnowRequest->getPost ( $key, $default );
	}
	
	/**
	 *返回$_COOKIE
	 * @param string $key
	 * @param mixed
	 * @return mixed
	 */
	public function getCookie($key = null, $default = null) {
		return $this->PHPnowRequest->getCookie ( $key, $default );
	}
	
	/**
	 * 返回$_SERVER
	 * @param string $key
	 * @param mixed $default
	 * @return mixed Returns
	 */
	public function getServer($key = null, $default = null) {
		return $this->PHPnowRequest->getServer ( $key, $default );
	}
	
	/**
	 * 返回$_ENV
	 * @param string $key
	 * @param mixed $default
	 * @return mixed
	 */
	public function getEnv($key = null, $default = null) {
		return $this->PHPnowRequest->getEnv ( $key, $default );
	}
	/**
	 * 检查模板缓存是否存在
	 * @param string $template   模板名称
	 * @param mixed  $cache_id   缓存ID
	 * @param mixed  $compile_id 编译ID
	 * @param object $parent
	 */
	public function isCached($template = null, $cache_id = null, $compile_id = null, $parent = null) {
		return $this->PHPnowView->isCached ( $template, $cache_id, $compile_id, $parent );
	}
	/**
	 * 加载模板
	 * @param string $template   模板名称
	 * @param mixed  $cache_id   缓存ID
	 * @param mixed  $compile_id 编译ID
	 * @param object $parent
	 */
	public function display($template = null, $cache_id = null, $compile_id = null, $parent = null) {
		$this->PHPnowView->display ( $template, $cache_id, $compile_id, $parent );
	}
	/**
	 * 模板变量
	 * @param array|string 变量名称
	 * @param mixed        值
	 * @param boolean      是否缓存
	 */
	public function assign($tpl_var, $value = null, $nocache = false) {
		$this->PHPnowView->assign ( $tpl_var, $value, $nocache );
	}
	/**
	 * 操作成功跳转的快捷方法
	 * @param 消息  $message
	 * @param 关闭 $closeWin
	 * @param 地址 $url
	 * @param  返回方法 $ajax
	 */
	protected function success($message, $url = 0, $closeWin = 0, $ajax = false) {
		$this->PHPnowReturns->success ( $message, $url, $closeWin, $ajax );
	}
	/**
	 * 操作错误跳转的快捷方法
	 * @param 消息  $message
	 * @param 关闭 $closeWin
	 * @param 地址 $url
	 * @param  返回方法 $ajax
	 */
	protected function error($message, $url = 0, $closeWin = 0, $ajax = false) {
		$this->PHPnowReturns->error ( $message, $url, $closeWin, $ajax );
	}
	/**
	 * Ajax方式返回数据到客户端
	 * @param string $status 状态
	 * @param string $info 消息
	 * @param array $data 数据
	 * @param JSON|XML|EVAL $type 类型
	 */
	protected function ajaxReturn($status, $info, $data = '', $type = 'JSON') {
		$this->PHPnowReturns->ajaxReturn ( $status, $info, $data, $type );
	}
}
