<?php

/**
 * 应用配制目录名称
 */
defined ( 'APP_CONFIGS_DIR_NAME' ) or define ( 'APP_CONFIGS_DIR_NAME', 'configs' );
/**
 * 应用语言目录名称
 */
defined ( 'APP_LANGS_NAME' ) or define ( 'APP_LANGS_NAME', 'langs' );
/**
 * 应用控制器目录名称
 */
defined ( 'APP_CONTROLLERS_DIR_NAME' ) or define ( 'APP_CONTROLLERS_DIR_NAME', 'controllers' );
/**
 * 应用模型目录名称
 */
defined ( 'APP_MODELS_DIR_NAME' ) or define ( 'APP_MODELS_DIR_NAME', 'models' );
/**
 * 应用视图(模板)目录名称
 */
defined ( 'APP_VIEWS_DIR_NAME' ) or define ( 'APP_VIEWS_DIR_NAME', 'views' );
/**
 * 应用函数目录名称
 */
defined ( 'APP_FUNCTION_DIR_NAME' ) or define ( 'APP_FUNCTION_DIR_NAME', 'function' );
/**
 * 应用插件目录名称
 */
defined ( 'APP_PLUGINS_DIR_NAME' ) or define ( 'APP_PLUGINS_DIR_NAME', 'plugins' );
require_once (PHPNOW_CORE_DIR . 'PHPnowException.class.php');
require_once (PHPNOW_CORE_DIR . 'PHPnowLoader.class.php');
require_once (PHPNOW_CORE_DIR . 'PHPnowClass.class.php');
/**
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowApp extends PHPnowClass {
	
	/**
	 * 最底运行PHP版本
	 */
	const PHP_VERSION = '5.2.0';
	/**
	 * @var 注册的应用程序的命名空间。
	 */
	public $_loader;
	
	/**
	 * @var string 应用程序的名称
	 */
	public $app;
	
	/**
	 * @var string 应用路径
	 */
	public $appPath;
	/**
	 * 应用实例
	 */
	protected $_bootstrap;
	
	/**
	 * 实例项目
	 */
	public function __construct($options = '') {
		if (! self::checkPHP ())
			throw new PHPnowException ( '请使用PHP' . self::PHP_VERSION . '及以上版本运行' );
		$this->_loader = new PHPnowLoader ();
		$this->_loader->registerNamespace ( 'PHPnow', PHPNOW_CORE_DIR, '.class.php' ); //注册系统空间
		
		$this->app = ! empty ( $options ['default_project_name'] ) ? $options ['default_project_name'] : PHPnowConfig::get ( 'default_project_name' );
		$this->appPath = ! empty ( $options ['default_project_path'] ) ? $options ['default_project_path'] : PHPnowConfig::get ( 'default_project_path' );
		$this->appPath=PHPnowDir::path($this->appPath);
		if (! is_dir ( $this->appPath )) {
			throw new PHPnowException ( '项目 "' . $this->app . '" 的路径 "' . $this->appPath . '" 出错 请检查是否存在' );
		}
		defined ( 'APP_PATH' ) or define( 'APP_PATH', $this->appPath );
		$this->_loader->registerNamespace ( 'Controller', $this->AppPath () . APP_CONTROLLERS_DIR_NAME . DS ); //注册应用控制器
		$this->_loader->registerNamespace ( 'Model', $this->AppPath () . APP_MODELS_DIR_NAME . DS ); //注册应用模型
		$this->_loader->registerNamespace ( 'Plugin', PHPNOW_PLUGINS_DIR ); //注册插件
	

	}
	/**
	 * 运行项目
	 * @return mixed
	 */
	public function run() {
		$this->Bootstrap ()->run ();
	}
	/**
	 * 返回的应用实例
	 *
	 * @return PHPnowBootstrap
	 */
	public function Bootstrap() {
		if (! $this->_bootstrap) {
			$this->_bootstrap = PHPnowClass::Instance ( 'PHPnowBootstrap', array ($this ) );
		}
		return $this->_bootstrap;
	}
	/**
	 * 返回项目名称
	 * @return string
	 */
	public function App() {
		return $this->app;
	}
	/**
	 * 返回项目路径
	 */
	public function AppPath() {
		return $this->appPath;
	}
	/**
	 * @return bool 检查当前环境是否可运行PHPnow
	 */
	public static function checkPHP() {
		return version_compare ( PHP_VERSION, self::PHP_VERSION, '>' );
	}

}
