<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 运行类
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowBootstrap extends PHPnowAction {
	protected $resourceList = array ();
	
	/**
	 * 已注册的资源的中的所有状态的属性
	 *
	 * @var array
	 */
	protected $resourceStatus = array ();
	
	/**
	 * PHPnow应用实例
	 *
	 * @var PHPnowApp
	 */
	protected $application;
	
	public function __construct(PHPnowApp $application) {
		$this->setApplication ( $application );
		parent::__construct ();
	
	}
	/**
	 * 内部应用程序的属性设置成应用程序实例
	 * @param  PHPnowApp $application
	 * @return PHPnowBootstrap
	 */
	public function setApplication(PHPnowApp $application) {
		$this->application = $application;
		return $this;
	}
	
	/**
	 * 返回应用程序的实例
	 * @return PHPnowApp
	 */
	public function Application() {
		return $this->application;
	}
	
	/**
	 * 运行
	 * @return mixed
	 */
	public function run() {
		date_default_timezone_set ( Config ( 'default_timezone' ) ); //设置时区
		if (Config ( 'url_router' ))
			$this->PathInfo ();
		else
			$this->RouteGet ();
		
		//使用原始数据，入库需要转义！
		if (get_magic_quotes_gpc ()) {
			$_GET = $this->PHPnowInput->stripslashes ( $_GET );
			$_POST = $this->PHPnowInput->stripslashes ( $_POST );
			$_COOKIE = $this->PHPnowInput->stripslashes ( $_COOKIE );
			$_REQUEST = $this->PHPnowInput->stripslashes ( $_REQUEST );
		}
		$m = ucfirst ( strtolower ( $_GET [Config ( 'url_module' )] ) );
		$c = ucfirst ( strtolower ( $_GET [Config ( 'url_controller' )] ) );
		$a = $_GET [Config ( 'url_action' )];
		define ( 'MODULE_NAME', $m );
		define ( 'CONTROLLER_NAME', $c );
		define ( 'ACTION_NAME', $a );
		$File = $this->application->appPath . APP_CONTROLLERS_DIR_NAME . DS . $m . DS . $c . 'Controller' . '.php';
		if (! PHPnowLoader::checkFile ( $File )) {
			$this->PHPnowView->assign ( 'message', Lang ( 'PAGE_DOES_NOT_EXIST' ) ); //安全检查：文件名中有非法字符
			$this->PHPnowView->display ( Config ( 'view_error' ) );
		}
		$this->application->_loader->registerNamespace ( 'Controller', $this->application->appPath . APP_CONTROLLERS_DIR_NAME . DS . MODULE_NAME . DS ); //注册应用控制器
		

		if (! PHPnowImport::import ( $File )) {
			$this->error(Lang ( 'PAGE_DOES_NOT_EXIST' ));
		}
		$a .= 'Action';
		$className = $c . 'Controller';
		if (class_exists ( $className )) {
			$className = new $className ();
			if (is_callable ( array ($className, $a ) )) {
				if (Config('default_auto_function')){
				foreach (explode('@',Config('default_auto_function')) as $row){
					impFun($row);
				}
				}
				$className->$a ();
			} else {
				$this->error(Lang ( 'PAGE_DOES_NOT_EXIST' ));
			}
		} else {
			$this->error(Lang ( 'PAGE_DOES_NOT_EXIST' ));
		}
	
	}
	public function PathInfo() {
		$PathInfo = PHPnowClass::InstanceStatic ( 'PHPnowRequest' )->getPathInfo ();
		$paths = explode ( Config ( 'url_pathinfo_depr' ), trim ( trim ( preg_replace ( '/' . Config ( 'url_suffix' ) . '$/', '', $PathInfo ), '/' ), '/' ) );
		if (empty ( $paths [0] )) {
			$paths [0] = Config ( 'default_module' );
		}
		if (empty ( $paths [1] )) {
			$paths [1] = Config ( 'default_controller' );
		}
		if (empty ( $paths [2] )) {
			$paths [2] = Config ( 'default_action' );
		}
		$_GET [Config ( 'url_module' )] = $paths [0];
		$_GET [Config ( 'url_controller' )] = $paths [1];
		$_GET [Config ( 'url_action' )] = $paths [2];
		array_shift ( $paths );
		array_shift ( $paths );
		array_shift ( $paths );
		if (count ( $paths ) > 1) {
			preg_replace ( '@(\w+),([^,\/]+)@e', '$_GET[\'\\1\']="\\2";', implode ( ',', $paths ) );
		}
		return $_GET;
	}
	/**
	 * 获取模型
	 */
	public function RouteGet() {
		if (empty ( $_GET [Config ( 'url_module' )] )) {
			$_GET [Config ( 'url_module' )] = Config ( 'default_module' );
		}
		if (empty ( $_GET [Config ( 'url_controller' )] )) {
			$_GET [Config ( 'url_controller' )] = Config ( 'default_controller' );
		}
		if (empty ( $_GET [Config ( 'url_action' )] )) {
			$_GET [Config ( 'url_action' )] = Config ( 'default_action' );
		}
		return $_GET;
	}
	/**
	 * 解析出地址
	 * @param string $m
	 * @param string $get 格式如id.1
	 */
	public function url($url = MODULE_NAME, $get = '') {
		// 解析URL
		$info = parse_url ( $url );
		$url = ! empty ( $info ['path'] ) ? $info ['path'] : MODULE_NAME;
		$u = Config ( 'url_router' );
		if (substr ( $url, 0, 1 ) != '/') {
			if (substr ( $url, - 1 ) == '/')
				$url = '/' . MODULE_NAME . '/' . $url;
			else
				$url = '/' . MODULE_NAME . '/' . CONTROLLER_NAME . '/' . $url;
		} elseif (substr ( $url, - 1 ) == '/') {
			$url = substr ( $url, 0, - 1 );
		}
		$url = explode ( '/', $url );
		$m = ! empty ( $url [1] ) ? $url [1] : MODULE_NAME;
		$c = ! empty ( $url [2] ) ? $url [2] : '';
		$a = ! empty ( $url [3] ) ? $url [3] : '';
		if (! empty ( $get )) {
			if (empty ( $c )) {
				$c = Config ( 'default_controller' );
			}
			if (empty ( $a )) {
				$a = Config ( 'default_action' );
			}
		}
		if (! empty ( $u )) {
			if (! empty ( $c ))
				$c = Config ( 'url_pathinfo_depr' ) . $c;
			if (! empty ( $a ))
				$a = Config ( 'url_pathinfo_depr' ) . $a;
			$url = '/' . $m . $c . $a;
		} else {
			$url = '/' . Config ( 'default_run' ) . '?' . Config ( 'url_module' ) . '=' . $m;
			if (! empty ( $c ))
				$url .= '&' . Config ( 'url_controller' ) . '=' . $c;
			if (! empty ( $a ))
				$url .= '&' . Config ( 'url_action' ) . '=' . $a;
		}
		if (! empty ( $get )) {
			if (is_string ( $get )) {
				$paths = explode ( '.', $get );
				for($i = 0; $i < count ( $paths ); $i += 2) {
					$c = $i + 1;
					$d = isset ( $paths [$c] ) ? $paths [$c] : '';
					if ($u) {
						$url .= Config ( 'url_pathinfo_depr' ) . $paths [$i] . Config ( 'url_pathinfo_depr' ) . $d;
					} else {
						$url .= '&' . $paths [$i] . '=' . $d;
					}
				}
			}
		}
		if (! empty ( $u ))
			$url .= Config ( 'url_suffix' );
		return $url;
	}

}