<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 缓存方法
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowCache extends PHPnowClass {
	/**
	 * 返回驱动
	 * @param string $method
	 */
	public function drive($method) {
		static $drive = array ();
		if (empty ( $method ))
			$method = Config ( 'cache_type' );
		if (empty ( $drive [$method] )) {
			if (! $this->PHPnowImport->import ( PHPNOW_DRIVE_DIR . 'cache' . DS . $method ))
				throw new PHPnowException ( Lang ( 'DRIVE' ) . '"' . $method . '"' . Lang ( 'FAILED_TO_LOAD' ) );
			$drive [$method] = $this->InstanceStatic ( 'Cache' . $method );
		}
		return $drive [$method];
	}
	/**
	 * 读取一条Cache
	 * @param string $file	缓存的key 可以是数组
	 * @param string $method	缓存方法
	 * @return mix
	 */
	public function get($key, $method = null) {
		return $this->drive ( $method )->get ( $key );
	}
	/**
	 * 写入一条Cache
	 * @param string $key 缓存的Key
	 * @param mix $data 缓存的数据
	 * @param number $expire 超时时间，单位秒
	 * @param string $method 缓存方法
	 */
	public function set($key, $data, $expire = null, $method = null) {
		if (empty ( $expire ))
			$expire = Config ( 'cache_lifetime' );
		return $this->drive ( $method )->set ( $key, $data, $expire );
	}
	/**
	 * 
	 * 删除一条Cache
	 *
	 * @param string $key 缓存Key
	 * @param string $method	缓存方法
	 */
	public function delete($key, $method = null) {
		return $this->drive ( $method )->delete ( $key );
	}
	/**
	 * 清空缓存
	 * @param string $method	缓存方法
	 */
	public function flush($method = null) {
		return $this->drive ( $method )->flush ();
	}
}
/**
 * 数据库接口
 * @author jiaodu
 *
 */
interface CacheImplements {
	/**
	 * 读取一条Cache
	 * @param string $file	缓存的key 可以是数组
	 * @return mix
	 */
	public function get($key);
	/**
	 * 写入一条Cache
	 * @param string $key 缓存的Key
	 * @param mix $data 缓存的数据
	 * @param number $expire 超时时间，单位秒
	 */
	public function set($key, $data, $expire);
	/**
	 * 
	 * 删除一条Cache
	 *
	 * @param string $key 缓存Key
	 */
	public function delete($key);
	/**
	 * 清空缓存
	 */
	public function flush();
}