<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 类加载
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
abstract class PHPnowClass {
	
	protected static $instances = array ();
	
	/**
	 * 
	 * 防止初始化
	 */
	public function __construct() {
		$class = get_class ( $this );
		if (! isset ( self::$instances [$class] )) {
			self::$instances [$class] = $this;
		} else {
			throw new PHPnowException ( Lang('CLASS').' "' . get_class ( $this ) . '" '.Lang('HAS_BEEN_INSTANTIATED') );
		}
		if (method_exists ( $this, 'init' )) {
			if (func_num_args ()) {
				call_user_func_array ( array ($this, 'init' ), func_get_args () );
			} else {
				$this->init ();
			}
		}
	}
	
	/**
	 * 返回类名称
	 * @param mixed $class
	 * @return string
	 */
	public static function getClassName($class = null) {
		if (empty ( $class )) {
			if (function_exists ( 'get_called_class' )) {
				$class = get_called_class ();
			} else {
				throw new PHPnowException ( 'get_called_class ' .Lang('DOES_NOT_EXIST'));
			}
		}
		if (is_object ( $class )) {
			$class = get_class ( $class );
		} elseif (! class_exists ( $class )) {
			throw new PHPnowException ( Lang('CLASS') . $class . Lang('FAILED_TO_LOAD') );
		}
		
		return $class;
	}
	
	/**
	 * 类的实例。如果类已经存在了将返回
	 * @param   string $class
	 * @param   array $args
	 * @return  Class
	 */
	static public function Instance($class = null, $args = null) {
		$class = self::getClassName ( $class );
		if (isset ( self::$instances [$class] )) {
			return self::$instances [$class];
		}
		$rc = new ReflectionClass ( $class );
		if (isset ( $args )) {
			$instance = $rc->newInstanceArgs ( $args );
		} else {
			$instance = $rc->newInstance ();
		}
		return $instance;
	}
	/**
	 * 静态类的实例。如果类已经存在了将返回
	 * @param   string $class
	 * @param   array $args
	 * @return  Class
	 */
	static public function InstanceStatic($class) {
		$class = self::getClassName ( $class );
		if (isset ( self::$instances [$class] ))
			return self::$instances [$class];
		self::$instances [$class] = new $class ();
		return self::$instances [$class];
	}
	/**
	 * 重设类的实例
	 * @param   mixed $class
	 */
	static public function resetInstance($class = null) {
		$class = self::getClassName ( $class );
		unset ( self::$instances [$class] );
	}
	
	/**
	 * 魔术处理
	 * @param   string $name
	 * @param   array $args
	 */
	public function __call($name, $args = null) {
		return $this->aut_ins ( $name );
	}
	
	/**
	 * 魔术处理
	 * @param   string $name
	 * @param   array $args
	 */
	static public function __callStatic($name, $args = null) {
		throw new PHPnowException ( Lang('METHOD').' "' . get_called_class () . '::' . $name . '" '.Lang('DOES_NOT_EXIST'), PHPnowException::METHOD_NOT_FOUND );
	}
	
	/**
	 * 魔术处理
	 * @param   string $name
	 */
	public function __get($name) {
		return $this->aut_ins ( $name );
	}
	
	/**
	 * 魔术处理
	 * @param   string $name
	 * @param   mixed $value
	 */
	public function __set($name, $value = null) {
		throw new PHPnowException ( Lang('PROPERTY').' "' . $name . '" '.Lang('DOES_NOT_EXIST'), PHPnowException::PROPERTY_NOT_FOUND );
	}
	/**
	 * 自动实例化类
	 * @param string $method
	 */
	private function aut_ins($method, $args = '') {
		if (substr ( $method, 0, 7 ) != 'PHPnow') {
			return $this->InstanceStatic ( $method );
		}
		
		throw new PHPnowException ( Lang('METHOD').' "' . $method . '" '.Lang('DOES_NOT_EXIST'), PHPnowException::METHOD_NOT_FOUND );
	
	}
}