<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 配制类 静态方法
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowConfig extends PHPnowClass {
	/**
	 * 配制
	 * @var array
	 */
	protected static $_data = array ();
	/**
	 * 统计配制
	 * @var integer
	 */
	protected static $_count;
	/**
	 * 取得配制
	 * @param string $name
	 * @param string $File
	 * @param mixed $default
	 * @return mixed
	 */
	static public function get($name, $File = 'common', $default = null) {
		if (empty ( self::$_data [$File] ) || empty ( self::$_data [$File] [$name] )) {
			$con = self::getPHPnowConfigs ( $File );
			if (is_array ( $con )) {
				self::$_data [$File] = ! empty ( self::$_data [$File] ) ? array_merge ( self::$_data [$File], $con ) : $con;
			}
			$con = self::getAppConfigs ( $File );
			
			if (is_array ( $con )) {
				self::$_data [$File] = ! empty ( self::$_data [$File] ) ? array_merge ( self::$_data [$File], $con ) : $con;
			}
		}
		return ! empty ( self::$_data [$File] [$name] ) ? self::$_data [$File] [$name] : $default;
	}
	/**
	 * 导入系统配制
	 * @param string $File
	 */
	static function getPHPnowConfigs($File = 'common') {
		return PHPnowImport::import ( PHPNOW_CONFIGS_DIR . $File );
	}
	/**
	 * 导入项目配制
	 * @param string $File
	 */
	static function getAppConfigs($File = 'common') {
		if (! empty ( self::$_data ['common'] ['default_project_path'] ))
			return PHPnowImport::import ( self::$_data ['common'] ['default_project_path'] .APP_CONFIGS_DIR_NAME.DS. $File);
		else
			return false;
	}
	/**
	 * 魔术取得配制
	 * @param string $name
	 * @return mixed
	 */
	public function __get($name) {
		return self::get ( $name );
	}
	/**
	 * 设置配制
	 * @param  string $name
	 * @param  mixed  $value
	 * @param string $File
	 */
	static public function set($name, $value, $File = 'common') {
		self::$_data [$File] [$name] = $value;
		self::$_count [$File] = count ( self::$_data [$File] );
	}
	/**
	 * 检查配制
	 * @param string $name
	 * @return boolean
	 */
	static public function isConfig($name, $File = 'common') {
		return isset ( self::$_data [$File] [$name] );
	}
	/**
	 * 返回配制总个数
	 * @return int
	 */
	static public function count($File = 'common') {
		return self::$_count [$File];
	}

} 