<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * Cookie管理类
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowCookie extends PHPnowClass {
	/**
	 * 判断Cookie是否存在
	 * @param string $name
	 */
	static function is_set($name) {
		return isset ( $_COOKIE [Config ( 'cookie_pre' ) . $name] );
	}
	/**
	 * 获取某个Cookie值
	 * @param string $name
	 */
	static function get($name) {
		$value = self::is_set ( $name ) ? unserialize ( base64_decode ( $_COOKIE [Config ( 'cookie_pre' ) . $name] ) ) : null;
		return $value;
	}
	/**
	 * 设置某个Cookie值
	 * @param string $name 名称
	 * @param string $value 值
	 * @param string $expire 时间
	 * @param string $path 目录
	 * @param string $domain 域名
	 */
	static function set($name, $value, $expire = '', $path = '', $domain = '') {
		if ($expire == '') {
			$expire = Config ( 'cookie_expire' );
		}
		if (empty ( $path )) {
			$path = Config ( 'cookie_path' );
		}
		if (empty ( $domain )) {
			$domain = Config ( 'cookie_domain' );
		}
		$expire = ! empty ( $expire ) ? time () + $expire : 0;
		$value = base64_encode ( serialize ( $value ) );
		setcookie ( Config ( 'cookie_pre' ) . $name, $value, $expire, $path, $domain );
		$_COOKIE [Config ( 'cookie_pre' ) . $name] = $value;
	}
	/**
	 * 删除某个Cookie值
	 * @param string $name
	 */
	static function delete($name) {
		self::set ( $name, '', time () - 3600 );
		unset ( $_COOKIE [Config ( 'cookie_pre' ) . $name] );
	}

}