<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 数据库操作
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowDatabase extends PHPnowClass {
	const SQL_SELECT = 'SELECT';
	const SQL_DISTINCT = 'DISTINCT';
	const SQL_WHERE = 'WHERE';
	const SQL_AND = 'AND';
	const SQL_OR = 'OR';
	const SQL_ORDER_BY = 'ORDER BY';
	const SQL_INSERT = 'INSERT';
	const SQL_INTO = 'INTO';
	const SQL_SET = 'SET';
	const SQL_VALUES = 'VALUES';
	const SQL_UPDATE = 'UPDATE';
	const SQL_DELETE = 'DELETE';
	const SQL_WILDCARD = '*';
	const SQL_UNION = 'UNION';
	const SQL_UNION_ALL = 'UNION ALL';
	const SQL_FROM = 'FROM';
	const SQL_GROUP_BY = 'GROUP BY';
	const SQL_HAVING = 'HAVING';
	const SQL_FOR_UPDATE = 'FOR UPDATE';
	const SQL_AS = 'AS';
	const SQL_ON = 'ON';
	const SQL_ASC = 'ASC';
	const SQL_DESC = 'DESC';
	const SQL_TOP = 'TOP';
	const SQL_LIKE = 'LIKE';
	const SQL_IN = 'IN';
	const SQL_BETWEEN = 'BETWEEN';
	const SQL_ALIASES = 'ALIASES';
	const SQL_JOIN = 'JOIN';
	const SQL_INNER_JOIN = 'INNER JOIN';
	const SQL_LEFT_JOIN = 'LEFT JOIN';
	const SQL_RIGHT_JOIN = 'RIGHT JOIN';
	const SQL_FULL_JOIN = 'FULL JOIN';
	const SQL_LIMIT = 'LIMIT';
	
	const SQL_AVG = 'AVG';
	const SQL_COUNT = 'COUNT';
	const SQL_FIRST = 'FIRST';
	const SQL_LAST = 'LAST';
	const SQL_MAX = 'MAX';
	const SQL_MIN = 'MIN';
	const SQL_SUM = 'SUM';
	const SQL_UCASE = 'UCASE';
	const SQL_LCASE = 'LCASE';
	const SQL_MID = 'MID';
	const SQL_LEN = 'LEN';
	const SQL_ROUND = 'ROUND';
	const SQL_NOW = 'NOW';
	const SQL_FORMAT = 'FORMAT';
	const SQL_REPLACE = 'REPLACE';
	const SQL_ALTER = 'ALTER';
	const SQL_CREATE = 'CREATE';
	const SQL_DROP = 'DROP';
	const SQL_RENAME = 'RENAME';
	const SQL_TRUNCATE = 'TRUNCATE';
	
	public static $action = array ('field', 'top', 'distinct', 'table', 'join', 'set', 'values', 'where', 'group', 'having', 'order', 'limit' );
	/**
	 * 查询连接
	 * @var mixed
	 */
	public $db_query;
	/**
	 * 写入连接
	 * @var mixed
	 */
	public $db_exec;
	
	public $query;
	public $exec;
	
	public $db_query_prefix;
	public $db_exec_prefix;
	/**
	 * 数据库表名
	 * @var string
	 */
	public $tableName;
	/**
	 * 所对应的数据表名的前缀
	 * @var string
	 */
	public $prefix = "##__";
	/**
	 * 所对应的数据表名的名称
	 * @var string
	 */
	public $table = "__##__";
	/**
	 * SQL语句容器，用于存放SQL语句，为SQL语句组装函数提供SQL语句片段的存放空间。
	 *
	 * @var array
	 */
	public $parts;
	/**
	 * 查询表达式参数
	 * @var array
	 */
	public $options = array ();
	
	public $querys = array ();
	public $last_sql;
	public $cache = false;
	/**
	 * 利用__call方法实现一些特殊的Model方法
	 * @param string $method 方法名称
	 * @param array $args 调用参数
	 * @return mixed
	 */
	public function __call($method, $args) {
		
		if (in_array ( strtolower ( $method ), self::$action, true )) {
			//简化操作
			$sql = 'sql_' . strtolower ( $method );
			$this->$sql ( $args [0] );
			return $this;
		} elseif (in_array ( strtoupper ( $method ), array (self::SQL_COUNT, self::SQL_SUM, self::SQL_MIN, self::SQL_MAX, self::SQL_AVG ), true )) {
			// 统计查询的实现
			$field = isset ( $args [0] ) ? $args [0] : '*';
			$field = $this->limit(1)->field ( strtoupper ( $method ) . '(' . $field . ') ' . self::SQL_AS . ' PHPnow_' . $method )->find ();
			return $field ['PHPnow_' . $method];
		}
		return $this;
	}
	public function table($table = '') {
		if (! empty ( $table ))
			$this->sql_table ( $table );
		return $this;
	}
	/**
	 * 分析出SQl.
	 * @param string $sql
	 */
	public function replaceSql(&$sql, $prefix) {
		$sql = trim ( ( string ) $sql );
		if (strpos ( $sql, $this->table ))
			$sql = str_replace ( $this->table, $this->tableName, $sql );
		if (strpos ( $sql, $this->prefix ))
			$sql = str_replace ( $this->prefix, $prefix, $sql );
		return $sql;
	}
	/**
	 * 根据SQL语句返回相应的数据库连接
	 * @param $sql string SQL语句
	 * @return resource mysql连接
	 */
	public function autoConnect($sql = null) {
		static $database = '';
		static $select = array (self::SQL_SELECT );
		if (! empty ( $sql )) {
			$s = explode ( ' ', trim ( ( string ) $sql ) );
		}
		unset ( $sql );
		if (empty ( $database )) {
			$database = Config ( 'connection', 'database' );
			$database = explode ( '|', $database );
		}
		if (count ( $database ) == 2) {
			if (! empty ( $s [0] ) && strtoupper ( trim ( $s [0] ) ) == self::SQL_SELECT) {
				if (empty ( $this->db_query )) {
					//读
					$query = explode ( ',', $database [0] );
					$query = Config ( $query [array_rand ( $query )], 'database' );
					$this->query = $this->initialize ( $query, 'db_query' );
					$this->db_query_prefix = $query ['db_prefix'];
				}
				return $this->query;
			} else {
				//写
				if (empty ( $this->db_exec )) {
					$exec = explode ( ',', $database [1] );
					$exec = Config ( $exec [array_rand ( $exec )], 'database' );
					$this->exec = $this->initialize ( $exec, 'db_exec' );
					$this->db_exec_prefix = $exec ['db_prefix'];
				}
				return $this->exec;
			}
		} else {
			if (empty ( $this->db_exec ) || empty ( $this->db_query )) {
				//读写随机
				$query = explode ( ',', $database [0] );
				$query = Config ( $query [array_rand ( $query )], 'database' );
				$this->query = $this->exec = $this->initialize ( $query, 'db_query.db_exec' );
				$this->db_exec_prefix = $this->db_query_prefix = $query ['db_prefix'];
			}
			if (! empty ( $s [0] ) && in_array ( strtolower ( $s [0] ), $select ))
				return $this->query;
			else
				return $this->exec;
		}
	}
	public function initialize($query, $db) {
		if (! $this->PHPnowImport->import ( PHPNOW_DRIVE_DIR . 'database' . DS . $query ['db_drive'] ))
			throw new PHPnowException ( Lang ( 'DRIVE' ) . '"' . $query ['db_drive'] . '"' . Lang ( 'FAILED_TO_LOAD' ) );
		return $this->InstanceStatic ( $query ['db_drive'] . 'Database' )->initialize ( $this )->connection ( $query, $db );
	}
	/**
	 * 执行查询SQL
	 * @param string $sql
	 */
	public function sql($sql = '') {
		return $this->query ( $sql );
	}
	/**
	 * 执行查询一条
	 * @param string $sql
	 */
	public function find($sql = '') {
		return $this->fetch ( $sql );
	}
	/**
	 * 执行查询多条
	 * @param string $sql
	 */
	public function findAll($sql = '') {
		return $this->fetchAll ( $sql );
	}
	/**
	 * 返回上次插入操作最后一条ID
	 */
	public function addId() {
		return $this->lastInsertId ();
	}
	/**
	 * 删除
	 * @param string $sql
	 */
	public function del($sql = '') {
		return $this->delete ( $sql );
	}
	/**
	 * 更新
	 * @param string|array $set
	 * @param string $sql
	 */
	public function up($set = '', $sql = '') {
		return $this->update ( $set, $sql );
	}
	/**
	 * 插入
	 * @param string|array $values
	 * @param string $sql
	 */
	public function add($values = '', $sql = '') {
		return $this->insert ( $values, $sql );
	}
	
	/**
	 * 执行查询SQL
	 * @param string $sql
	 */
	public function query($sql = '') {
		$this->parseSql ( $sql );
		return $this->autoConnect ( $sql )->query ( $sql );
	}
	/**
	 * 执行查询一条
	 * @param string $sql
	 */
	public function fetch($sql = '') {
		if (empty ( $this->parts ['limit'] ))
			$this->limit ( 1 );
		$this->parseSql ( $sql );
		return $this->autoConnect ( $sql )->fetch ( $sql );
	}
	/**
	 * 执行查询多条
	 * @param string $sql
	 */
	public function fetchAll($sql = '') {
		$this->parseSql ( $sql );
		return $this->autoConnect ( $sql )->fetchAll ( $sql );
	}
	/**
	 * 执行SQL
	 * @param string $sql
	 */
	public function exec($sql = '') {
		$this->parseSql ( $sql );
		return $this->autoConnect ( $sql )->exec ( $sql );
	}
	/**
	 * 返回上次插入操作最后一条ID
	 */
	public function lastInsertId() {
		return $this->db_exec->lastInsertId ();
	}
	/**
	 * 删除
	 * @param string $sql
	 */
	public function delete($sql = '') {
		$this->parseSql ( $sql, self::SQL_DELETE );
		return $this->autoConnect ( $sql )->exec ( $sql );
	}
	/**
	 * 更新
	 * @param string $sql
	 */
	public function update($set = '', $sql = '') {
		if (! empty ( $set ))
			$this->set ( $set );
		$this->parseSql ( $sql, self::SQL_UPDATE );
		return $this->autoConnect ( $sql )->exec ( $sql );
	}
	/**
	 * 插入
	 * @param string|array $values
	 * @param string $sql
	 * @return int|bool
	 */
	public function insert($values = '', $sql = '') {
		if (! empty ( $values ))
			$this->values ( $values );
		$this->parseSql ( $sql, self::SQL_INSERT );
		return $this->autoConnect ( $sql )->exec ( $sql ) ? $this->lastInsertId () : false;
	}
	/**
	 * 分析出SQL
	 * @param string $sql
	 */
	public function parseSql(&$sql, $action = self::SQL_SELECT) {
		if (empty ( $sql )) {
			if (strtoupper ( $action ) == self::SQL_SELECT) { //查询
				if (empty ( $this->parts ['field'] ))
					$this->sql_field ();
				$sql = strtoupper ( $action ) . ' ' . $this->parts ['field'] . ' ' . self::SQL_FROM;
				unset ( $this->parts ['field'] );
			} elseif (strtoupper ( $action ) == self::SQL_DELETE) { //删除
				$sql = self::SQL_DELETE . ' ' . self::SQL_FROM;
			} elseif (strtoupper ( $action ) == self::SQL_INSERT) { //插入
				$sql = self::SQL_INSERT . ' ' . self::SQL_INTO;
			} elseif (strtoupper ( $action ) == self::SQL_UPDATE) { //更新
				$sql = self::SQL_UPDATE;
			}
			if (! empty ( $sql )) {
				for($i = 0; $i < count ( self::$action ); $i ++) {
					if (! empty ( $this->parts [self::$action [$i]] ))
						$sql .= $this->parts [self::$action [$i]];
				}
			}
		}
		$table = $this->parts ['table'];
		$this->parts = null;
		$this->parts ['table'] = $table;
		return $sql;
	}
	/**
	 * 分页
	 * @param int $a
	 * @param int $b
	 */
	public function page($a = 1, $b = 1) {
		if (is_numeric ( $a ) && is_numeric ( $b )) {
			$a --;
			$this->limit ( "{$a},{$b}" );
		}
		return $this;
	}
	/**
	 * 缓存查询
	 * @param int $time 缓存时间
	 */
	public function cache($time = 30) {
		if (is_numeric ( $time ) || $time === null)
			$this->cache = $time;
		return $this;
	}
	/**
	 * 查询表名称
	 * @param string $table
	 */
	public function sql_table($table) {
		if (! empty ( $table ))
			$table = $this->prefix . $table;
		$this->parts ['table'] = ! empty ( $table ) ? ' ' . $this->parseKey ( $table ) : '';
		return $this;
	}
	/**
	 * field分析
	 */
	public function sql_field($fields = '*') {
		if (is_array ( $fields )) {
			$array = array ();
			foreach ( $fields as $key => $field ) {
				$array [] = ! is_numeric ( $key ) ? $this->parseKey ( $key ) . ' ' . self::SQL_AS . ' ' . $this->parseKey ( $field ) : $this->parseKey ( $field );
			}
			$fieldsStr = implode ( ',', $array );
		} elseif (is_string ( $fields ) && ! empty ( $fields )) {
			$fieldsStr = $this->parseKey ( $fields );
		} else {
			$fieldsStr = '*';
		}
		$this->parts ['field'] = $fieldsStr;
		return $this;
	}
	/**
	 * values分析用于插入数据
	 * @param string|array $data 数据
	 */
	public function sql_values($data) {
		if (is_array ( $data )) {
			foreach ( $data as $key => $val ) {
				$value = $this->parseValue ( $val );
				if (is_scalar ( $value )) { // 过滤非标量数据
					$k [] = $this->parseKey ( $key );
					$v [] = $value;
				}
			}
			if (! empty ( $k ))
				$this->parts ['values'] = ' (' . implode ( ',', $k ) . ') ' . self::SQL_VALUES . ' (' . implode ( ',', $v ) . ')';
		} else {
			$this->parts ['values'] = ' ' . $data;
		}
		return $this;
	}
	/**
	 * set分析用于更新数据
	 * @param string|array $data 数据
	 */
	public function sql_set($data) {
		if (is_array ( $data )) {
			foreach ( $data as $key => $val ) {
				$value = $this->parseValue ( $val );
				if (is_scalar ( $value )) // 过滤非标量数据
					$set [] = $this->parseKey ( $key ) . '=' . $value;
			}
			$this->parts ['set'] = ' ' . self::SQL_SET . ' ' . implode ( ',', $set );
		} else {
			$this->parts ['set'] = ' ' . self::SQL_SET . ' ' . $data;
		}
		return $this;
	}
	/**
	 * value分析
	 */
	public function parseValue(&$value) {
		if (is_string ( $value )) {
			$value = '\'' . $this->escapeString ( $value ) . '\'';
		} elseif (isset ( $value [0] ) && is_string ( $value [0] )) {
			$value = $this->escapeString ( $value [1] );
		} elseif (is_null ( $value )) {
			$value = 'null';
		}
		return $value;
	}
	/**
	 * where 条件地从表中选取数据
	 * @param string|array $where
	 */
	public function sql_where($where) {
		if (! empty ( $where )) {
			if (is_array ( $where )) {
				foreach ( $where as $key => $row ) {
					$w [] = "`$key`='" . $this->escapeString ( $row ) . "'";
				}
				if (empty ( $w ))
					return false;
				$where = "(" . trim ( implode ( ' ' . self::SQL_AND . ' ', $w ) ) . ") ";
				unset ( $w );
			}
		}
		$this->parts ['where'] = $where == '' ? '' : ' ' . self::SQL_WHERE . ' ' . $where;
		return $this;
	}
	/**
	 * 用于规定要返回的记录的数目
	 * @param string $number
	 */
	public function sql_top($number) {
		if (! empty ( $number )) {
			$this->parts ['top'] = stripos ( $number, self::SQL_TOP ) ? $number : self::SQL_TOP . ' ' . $number;
		}
		return $this;
	}
	
	/**
	 * 用于规定要返回的记录的数目
	 * @param string $limit
	 */
	public function sql_limit($limit) {
		$this->parts ['limit'] = ! empty ( $limit ) ? ' ' . self::SQL_LIMIT . ' ' . $limit . ' ' : '';
		return $this;
	}
	
	/**
	 * DISTINCT 用于返回唯一不同的值
	 * @param string $distinct
	 */
	public function sql_distinct($distinct) {
		$this->parts ['distinct'] = ! empty ( $distinct ) ? ' ' . self::SQL_DISTINCT . ' ' . $distinct : '';
		return $this;
	}
	/**
	 * join 表中的列之间的关系
	 * @param string|array $join
	 */
	public function sql_join($join) {
		$joinStr = '';
		if (! empty ( $join )) {
			if (is_array ( $join )) {
				foreach ( $join as $key => $_join ) {
					$joinStr .= stripos ( $_join, self::SQL_JOIN ) ? ' ' . $_join : ' ' . self::SQL_LEFT_JOIN . ' ' . $_join;
				}
			} elseif (is_string ( $join )) {
				$joinStr .= stripos ( $join, self::SQL_JOIN ) ? ' ' . $join : ' ' . self::SQL_LEFT_JOIN . ' ' . $join;
			}
		}
		$this->parts ['join'] = $joinStr;
		return $this;
	}
	/**
	 * group用于结合合计函数
	 * @param string $group
	 */
	public function sql_group($group) {
		$this->parts ['group'] = ! empty ( $group ) ? ' ' . self::SQL_GROUP_BY . ' ' . $group : '';
		return $this;
	}
	
	/**
	 * having
	 * @param string $having
	 */
	public function sql_having($having) {
		$this->parts ['having'] = ! empty ( $having ) ? ' ' . self::SQL_HAVING . ' ' . $having : '';
		return $this;
	}
	/**
	 * order分析  DESC|ASC
	 * @param 可以是数组 $order
	 */
	public function sql_order($order) {
		if (is_array ( $order )) {
			$array = array ();
			foreach ( $order as $key => $val ) {
				if (is_numeric ( $key )) {
					$array [] = $this->parseKey ( $val );
				} else {
					$array [] = $this->parseKey ( $key ) . ' ' . $val;
				}
			}
			$order = implode ( ',', $array );
		}
		$this->parts ['order'] = ! empty ( $order ) ? ' ' . self::SQL_ORDER_BY . ' ' . $order : '';
		return $this;
	}
	/**
	 * SQL指令安全过滤
	 * @access public
	 * @param string $str  SQL字符串
	 * @return string
	 */
	public function escapeString($str) {
		return addslashes ( ( string ) $str );
	}
	/**
	 * 字段和表名处理添加`
	 * @access public
	 * @param string $key
	 * @return string
	 */
	public function parseKey(&$key) {
		$key = trim ( $key );
		if (! preg_match ( '/[,\'\"\*\(\)`.\s]/', $key )) {
			$key = '`' . $key . '`';
		}
		return $key;
	}
	/**
	 * 记录调用的SQL
	 * @param  string $sqlSQL语句
	 */
	public function pushSql($sql, $time) {
		$push = array ($sql, $time );
		array_push ( $this->querys, $push );
		return $this->last_sql = $push;
	}
	/**
	 * 得到最后一次执行的SQL语句
	 * @return string 最后一次执行的SQL语句
	 */
	public function lastSql() {
		return $this->last_sql;
	}
	/**
	 * 以数组的方式返回所有执行过的的mysql语句
	 * @return array
	 */
	public function sqls() {
		return $this->querys;
	}

}
/**
 * 数据库接口
 * @author jiaodu
 *
 */
interface DatabaseImplements {
	/**
	 * 初始化
	 * @param array $database
	 */
	public function initialize(PHPnowDatabase $database);
	/**
	 * 连接
	 */
	public function connection($con, $db);
	/**
	 * 执行查询SQL
	 * @param string $sql
	 */
	public function query($sql);
	/**
	 * 执行查询一条
	 * @param string $sql
	 */
	public function fetch($sql);
	/**
	 * 执行查询多条
	 * @param string $sql
	 */
	public function fetchAll($sql);
	/**
	 * 执行SQL
	 * @param string $sql
	 */
	public function exec($sql);
	/**
	 * 返回上次插入操作最后一条ID
	 */
	public function lastInsertId();
}