<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 文件夹管理
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowDir extends PHPnowClass {
	/**
	 * 转化文件夹追加DS
	 * @param	string	$path	路径
	 * @return	string	路径
	 */
	static public function path($path) {
		$path = self::dir_path ( $path );
		if (substr ( $path, - 1 ) != DS) {
			$path .= DS;
		}
		return $path;
	}
	/**
	 * 转化 \/ 为 DS 考虑兼容
	 * @param	string	$path	路径
	 * @return	string	路径
	 */
	static public function dir_path($path) {
		$path = str_replace ( '\\', DS, $path );
		$path = str_replace ( '/', DS, $path );
		return $path;
	}
	/**
	 * 创建目录
	 * 
	 * @param	string	$path	路径
	 * @param	string	$mode	属性
	 * @return	string	如果已经存在则返回true，否则为flase
	 */
	static public function create($path, $mode = 0777) {
		if (is_dir ( $path ))
			return true;
		$ftp_enable = 0;
		$path = self::path ( $path );
		$temp = explode ( DS, $path );
		$cur_dir = '';
		$max = count ( $temp ) - 1;
		for($i = 0; $i < $max; $i ++) {
			$cur_dir .= $temp [$i] . DS;
			if (@is_dir ( $cur_dir ))
				continue;
			@mkdir ( $cur_dir, 0777, true );
			@chmod ( $cur_dir, 0777 );
		}
		return is_dir ( $path );
	}
	/**
	 * 拷贝目录及下面所有文件
	 * 
	 * @param	string	$fromdir	原路径
	 * @param	string	$todir		目标路径
	 * @return	string	如果目标路径不存在则返回false，否则为true
	 */
	static public function copy($fromdir, $todir) {
		$fromdir = self::path ( $fromdir );
		$todir = self::path ( $todir );
		if (! is_dir ( $fromdir ))
			return FALSE;
		if (! is_dir ( $todir ))
			self::create ( $todir );
		$list = glob ( $fromdir . '*' );
		if (! empty ( $list )) {
			foreach ( $list as $v ) {
				$path = $todir . basename ( $v );
				if (is_dir ( $v )) {
					self::copy ( $v, $path );
				} else {
					copy ( $v, $path );
					@chmod ( $path, 0777 );
				}
			}
		}
		return true;
	}
	/**
	 * 转换目录下面的所有文件编码格式
	 * 
	 * @param	string	$in_charset		原字符集
	 * @param	string	$out_charset	目标字符集
	 * @param	string	$dir			目录地址
	 * @param	string	$fileexts		转换的文件格式
	 * @return	string	如果原字符集和目标字符集相同则返回false，否则为true
	 */
	static public function iconv($in_charset, $out_charset, $dir, $fileexts = 'php|html|htm|shtml|shtm|js|txt|xml') {
		if ($in_charset == $out_charset)
			return false;
		$list = self::dirlist ( $dir );
		foreach ( $list as $v ) {
			if (pathinfo ( $v, PATHINFO_EXTENSION ) == $fileexts && is_file ( $v )) {
				PHPnowFile::set ( $v, iconv ( $in_charset, $out_charset, PHPnowFile::get ( $v ) ) );
			}
		}
		return true;
	}
	/**
	 * 列出目录下所有文件
	 * 
	 * @param	string	$path		路径
	 * @param	string	$exts		扩展名
	 * @param	array	$list		增加的文件列表
	 * @return	array	所有满足条件的文件
	 */
	static public function dirlist($path, $exts = '', $list = array()) {
		$path = self::path ( $path );
		$files = glob ( $path . '*' );
		foreach ( $files as $v ) {
			if (! $exts || pathinfo ( $v, PATHINFO_EXTENSION ) == $exts) {
				$list [] = $v;
				if (is_dir ( $v )) {
					$list = self::dirlist ( $v, $exts, $list );
				}
			}
		}
		return $list;
	}
	/**
	 * 设置目录下面的所有文件的访问和修改时间
	 * @param	string	$path		路径
	 * @param	int		$mtime		修改时间
	 * @param	int		$atime		访问时间
	 * @return	array	不是目录时返回false，否则返回 true
	 */
	static public function touch($path, $mtime = '', $atime = '') {
		if (! is_dir ( $path ))
			return false;
		$path = self::path ( $path );
		if (! is_dir ( $path ))
			touch ( $path, $mtime, $atime );
		$files = glob ( $path . '*' );
		foreach ( $files as $v ) {
			is_dir ( $v ) ? self::touch ( $v, $mtime, $atime ) : touch ( $v, $mtime, $atime );
		}
		return true;
	}
	/**
	 * 目录列表
	 * 
	 * @param	string	$dir		路径
	 * @param	int		$parentid	父id
	 * @param	array	$dirs		传入的目录
	 * @return	array	返回目录列表
	 */
	static public function tree($dir, $parentid = 0, $dirs = array()) {
		global $id;
		if ($parentid == 0)
			$id = 0;
		$list = glob ( $dir . '*' );
		foreach ( $list as $v ) {
			if (is_dir ( $v )) {
				$id ++;
				$dirs [$id] = array ('id' => $id, 'parentid' => $parentid, 'name' => basename ( $v ), 'dir' => $v . '/' );
				$dirs = self::tree ( $v . '/', $id, $dirs );
			}
		}
		return $dirs;
	}
	
	/**
	 * 删除目录及目录下面的所有文件
	 * 
	 * @param	string	$dir		路径
	 * @return	bool	如果成功则返回 TRUE，失败则返回 FALSE
	 */
	static public function delete($dir) {
		$dir = self::path ( $dir );
		if (! is_dir ( $dir ))
			return FALSE;
		$list = glob ( $dir . '*' );
		foreach ( $list as $v ) {
			is_dir ( $v ) ? self::delete ( $v ) : PHPnowFile::delete ( $v );
		}
		return @rmdir ( $dir );
	}
}