<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 异常处理
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowException extends Exception {
	/**
	 * 无法找到一个类
	 */
	const CLASS_NOT_FOUND = 1000;
	
	/**
	 * 无法找到一个方法
	 */
	const METHOD_NOT_FOUND = 1100;
	
	/**
	 * 无法找到一个类的属性
	 */
	const PROPERTY_NOT_FOUND = 1200;
	
	/**
	 * @var 抛出的异常
	 */
	protected $previous;
	
	/**
	 * 实例
	 * @param string $message
	 * @param int $code
	 * @param Exception|null $previous
	 */
	public function __construct($message = '', $code = 0, Exception $previous = null) {
		if ($previous !== null) {
			$this->previous = $previous;
		}
		
		parent::__construct ( $message, $code );
		
		if (in_array ( $code, array (self::CLASS_NOT_FOUND, self::METHOD_NOT_FOUND, self::PROPERTY_NOT_FOUND ) )) {
			$trace = debug_backtrace ( false );
			foreach ( $trace as $i => $var ) {
				if (! $i || $var ['function'] == '__call' || ! isset ( $var ['line'] )) {
					unset ( $trace [$i] );
					continue;
				}
				$this->file = $var ['file'];
				$this->line = $var ['line'];
				break;
			}
		}
	}
	
	/**
	 * 作为字符串返回的异常类
	 * @return string
	 */
	public function __toString() {
		header ( 'Content-Type:text/html; charset=utf-8' );
		if (version_compare ( PHP_VERSION, '5.3.0', '<' )) {
			if ($this->previous !== null) {
				return $this->previous->__toString () . "\n\nNext " . parent::__toString ();
			}
		}
		return parent::__toString ();
	}
}