<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 文件操作类
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowFile extends PHPnowClass {
	/**
	 * 创建目录，可以创建子目录
	 * @param string $dir	目录路径，绝对路径
	 */
	static public function makeDir($dir) {
		return PHPnowDir::create ( $dir );
	}
	
	/**
	 * 向一个文件写入数据
	 * @param string $file	写入的文件
	 * @param string $data	写入的数据
	 */
	static private function _write($file, $data) {
		file_put_contents ( PHPnowDir::dir_path ( $file ), $data, LOCK_EX );
		chmod ( $file, 0777 );
	}
	/**
	 * 向一个文件写入数据
	 * 在目录/文件不存在的时候，自动创建
	 * @param string $file	写入的文件
	 * @param string $data	写入的数据
	 */
	static public function set($file, $data) {
		return self::write ( $file, $data );
	}
	/**
	 * 向一个文件写入数据
	 * 在目录/文件不存在的时候，自动创建
	 * @param string $file	写入的文件
	 * @param string $data	写入的数据
	 */
	static public function write($file, $data) {
		try {
			$_updir = dirname ( $file );
			if (self::makeDir ( $_updir ))
				self::_write ( $file, $data );
		} catch ( Exception $e ) {
			throw new PHPnowException ( '文件 "' . $file . '" 写入失败' );
		}
	}
	/**
	 * 读取文件内容
	 * @param string $file	文件地址，绝对路径
	 * @param number $offset	起始位置
	 * @param number $len	读取长度，默认读取所有
	 */
	static public function get($file, $offset = 0, $len = null) {
		return self::read ( $file, $offset, $len );
	}
	/**
	 * 读取文件内容
	 * @param string $file	文件地址，绝对路径
	 * @param number $offset	起始位置
	 * @param number $len	读取长度，默认读取所有
	 */
	static public function read($file, $offset = 0, $len = null) {
		if ($len) {
			return file_get_contents ( PHPnowDir::dir_path ( $file ), true, null, $offset, $len );
		}
		return file_get_contents ( PHPnowDir::dir_path ( $file ), true, null, $offset );
	}
	/**
	 * 删除一个文件
	 * @param string $file	文件名，绝对地址
	 */
	static public function delete($file) {
		return self::remove ( $file );
	}
	
	/**
	 * 删除一个文件
	 * @param string $file	文件名，绝对地址
	 */
	static public function remove($file) {
		return @unlink ( PHPnowDir::dir_path ( $file ) );
	}

}