<?php
class PHPnowInput extends PHPnowClass {
	/**
	 * 删除html标签
	 * @param $string 字符或数组
	 */
	public function strip_tags($string) {
		if (is_string ( $string )) {
			return trim ( strip_tags ( $string ) );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->strip_tags ( $val );
			}
		}
		return $string;
	}
	/**
	 * 安全过滤
	 * @param $string 字符或数组
	 */
	public function safe($string) {
		if (is_string ( $string )) {
			return $this->xss ( $string );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->safe ( $val );
			}
		}
		return $string;
	}
	/**
	 * 字符转换为 HTML 实体
	 * @param  $string
	 */
	public function safe_html($string) {
		if (is_string ( $string )) {
			return trim ( htmlspecialchars ( $this->xss ( $string ) ) );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->safe_html ( $val );
			}
		}
		return $string;
	}
	/**
	 * 转义变量 用于安全调用，如SQL值
	 * @param $string 字符或数组
	 */
	public function addslashes($string) {
		if (! is_array ( $string )) {
			return addslashes ( $string );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->addslashes ( $val );
			}
		}
		return $string;
	}
	/**
	 * 对变量进行反转义到原始数据
	 * @param $string 字符或数组
	 */
	public function stripslashes($string) {
		if (! is_array ( $string )) {
			return stripslashes ( $string );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->stripslashes ( $val );
			}
		}
		return $string;
	}
	/**
	 * 删除html标签，得到纯文本
	 * @param string $string 字符或数组
	 * @param true|false $n 是否删除回车及多于的空格
	 */
	public function deleteHtmlTags($string, $n = true) {
		if (is_string ( $string )) {
			//过滤换行符
			if ($n) {
				$string = $this->nl2 ( $string, false );
				$string = str_replace ( '  ', ' ', $string );
			}
			$string = trim ( $this->safe ( strip_tags ( $string ) ) );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->deleteHtmlTags ( $val );
			}
		}
		return $string;
	}
	/**
	 * 处理文本中的换行
	 * @param string $string 要处理的字符串
	 * @param mixed $br 对换行的处理，
	 * false：去除换行；true：保留原样；string：替换成string
	 */
	public function nl2($string, $br = '<br/>') {
		if (! $br) {
			$string = preg_replace ( "/(\015\012)|(\015)|(\012)/", '', $string );
		} else {
			$string = preg_replace ( "/(\015\012)|(\015)|(\012)/", $br, $string );
		}
		return trim ( $string );
	}
	/**
	 * base64 加密
	 * @param string $string 字符或数组
	 */
	public function base64_encode($string) {
		if (! is_array ( $string )) {
			return base64_encode ( $string );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->base64_encode ( $val );
			}
		}
		return $string;
	}
	/**
	 * base64 解密
	 * @param string $string 字符或数组
	 */
	public function base64_decode($string) {
		if (! is_array ( $string )) {
			return base64_decode ( $string );
		} elseif (is_array ( $string )) {
			foreach ( $string as $key => $val ) {
				$string [$key] = $this->base64_decode ( $val );
			}
		}
		return $string;
	}
	/**
	 * 精简代码
	 * @param string $Content
	 */
	public function CompressedCode($Content) {
		return str_replace ( '  ', ' ', trim ( preg_replace ( array ('~>\s+<~', '~>(\s+\n|\r)~' ), array ("><", ">" ), $Content ) ) );
	}
	public function xss($val) {
		if (empty ( $val ))
			return $val;
		
		// remove all non-printable characters. CR(0a) and LF(0b) and TAB(9) are allowed
		// this prevents some character re-spacing such as <java\0script>
		// note that you have to handle splits with \n, \r, and \t later since they *are* allowed in some inputs
		$val = preg_replace ( '/([\x00-\x08,\x0b-\x0c,\x0e-\x19])/', '', $val );
		// straight replacements, the user should never need these since they're normal characters
		// this prevents like <IMG SRC=@avascript:alert('XSS')>
		$search = 'abcdefghijklmnopqrstuvwxyz';
		$search .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$search .= '1234567890!@#$%^&*()';
		$search .= '~`";:?+/={}[]-_|\'\\';
		for($i = 0; $i < strlen ( $search ); $i ++) {
			// ;? matches the ;, which is optional
			// 0{0,7} matches any padded zeros, which are optional and go up to 8 chars
			// @ @ search for the hex values
			$val = preg_replace ( '/(&#[xX]0{0,8}' . dechex ( ord ( $search [$i] ) ) . ';?)/i', $search [$i], $val ); // with a ;
			// @ @ 0{0,7} matches '0' zero to seven times
			$val = preg_replace ( '/(&#0{0,8}' . ord ( $search [$i] ) . ';?)/', $search [$i], $val ); // with a ;
		}
		
		// now the only remaining whitespace attacks are \t, \n, and \r
		$ra1 = array ('javascript', 'vbscript', 'expression', 'applet', 'meta', 'xml', 'blink', 'link', 'style', 'script', 'embed', 'object', 'iframe', 'frame', 'frameset', 'ilayer', 'layer', 'bgsound', 'title', 'base' );
		$ra2 = array ('onabort', 'onactivate', 'onafterprint', 'onafterupdate', 'onbeforeactivate', 'onbeforecopy', 'onbeforecut', 'onbeforedeactivate', 'onbeforeeditfocus', 'onbeforepaste', 'onbeforeprint', 'onbeforeunload', 'onbeforeupdate', 'onblur', 'onbounce', 'oncellchange', 'onchange', 'onclick', 'oncontextmenu', 'oncontrolselect', 'oncopy', 'oncut', 'ondataavailable', 'ondatasetchanged', 'ondatasetcomplete', 'ondblclick', 'ondeactivate', 'ondrag', 'ondragend', 'ondragenter', 'ondragleave', 'ondragover', 'ondragstart', 'ondrop', 'onerror', 'onerrorupdate', 'onfilterchange', 'onfinish', 'onfocus', 'onfocusin', 'onfocusout', 'onhelp', 'onkeydown', 'onkeypress', 'onkeyup', 'onlayoutcomplete', 'onload', 'onlosecapture', 'onmousedown', 'onmouseenter', 'onmouseleave', 'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup', 'onmousewheel', 'onmove', 'onmoveend', 'onmovestart', 'onpaste', 'onpropertychange', 'onreadystatechange', 'onreset', 'onresize', 'onresizeend', 'onresizestart', 'onrowenter', 'onrowexit', 'onrowsdelete', 'onrowsinserted', 'onscroll', 'onselect', 'onselectionchange', 'onselectstart', 'onstart', 'onstop', 'onsubmit', 'onunload' );
		$ra = array_merge ( $ra1, $ra2 );
		
		$found = true; // keep replacing as long as the previous round replaced something
		while ( $found == true ) {
			$val_before = $val;
			for($i = 0; $i < sizeof ( $ra ); $i ++) {
				$pattern = '/';
				for($j = 0; $j < strlen ( $ra [$i] ); $j ++) {
					if ($j > 0) {
						$pattern .= '(';
						$pattern .= '(&#[xX]0{0,8}([9ab]);)';
						$pattern .= '|';
						$pattern .= '|(&#0{0,8}([9|10|13]);)';
						$pattern .= ')*';
					}
					$pattern .= $ra [$i] [$j];
				}
				$pattern .= '/i';
				$replacement = substr ( $ra [$i], 0, 2 ) . '<x>' . substr ( $ra [$i], 2 ); // add in <> to nerf the tag
				$val = preg_replace ( $pattern, $replacement, $val ); // filter out the hex tags
				if ($val_before == $val) {
					// no replacements were made, so exit the loop
					$found = false;
				}
			}
		}
		return $val;
	}
	/**
	 * * 输出安全的html，用于过滤危险代码
	 * @param string $text 要处理的字符串
	 * @param mixed $tags 允许的标签列表，如 table|td|th|td
	 */
	public function html($text, $tags = null) {
		if (empty ( $text ))
			return $text;
		$text = trim ( $text );
		//完全过滤注释
		$text = preg_replace ( '/<!--?.*-->/', '', $text );
		//完全过滤动态代码
		$text = preg_replace ( '/<\?|\?' . '>/', '', $text );
		//完全过滤js
		$text = preg_replace ( '/<script?.*\/script>/', '', $text );
		
		$text = str_replace ( '[', '&#091;', $text );
		$text = str_replace ( ']', '&#093;', $text );
		$text = str_replace ( '|', '&#124;', $text );
		//过滤换行符
		$text = preg_replace ( '/\r?\n/', '', $text );
		//br
		$text = preg_replace ( '/<br(\s\/)?' . '>/i', '[br]', $text );
		$text = preg_replace ( '/(\[br\]\s*){10,}/i', '[br]', $text );
		
		//过滤危险的属性，如：过滤on事件lang js
		while ( preg_match ( '/(<[^><]+)( lang|on|action|background|codebase|dynsrc|lowsrc)[^><]+/i', $text, $mat ) ) {
			$text = str_replace ( $mat [0], $mat [1], $text );
		}
		
		while ( preg_match ( '/(<[^><]+)(window\.|javascript:|js:|about:|file:|document\.|vbs:|cookie)([^><]*)/i', $text, $mat ) ) {
			$text = str_replace ( $mat [0], $mat [1] . $mat [3], $text );
		}
		if (empty ( $tags )) {
			$tags = 'table|td|th|tr|i|b|u|pre|strong|img|p|br|div|strong|em|ul|ol|li|dl|dd|dt|a';
		}
		
		//允许的HTML标签
		$text = preg_replace ( '/<(' . $tags . ')( [^><\[\]]*)>/i', '[\1\2]', $text );
		//过滤多余html
		$text = preg_replace ( '/<\/?(html|head|meta|link|base|basefont|body|bgsound|title|style|script|form|iframe|frame|frameset|applet|id|ilayer|layer|name|script|style|xml)[^><]*>/i', '', $text );
		//过滤合法的html标签
		while ( preg_match ( '/<([a-z]+)[^><\[\]]*>[^><]*<\/\1>/i', $text, $mat ) ) {
			$text = str_replace ( $mat [0], str_replace ( '>', ']', str_replace ( '<', '[', $mat [0] ) ), $text );
		}
		//转换引号
		while ( preg_match ( '/(\[[^\[\]]*=\s*)(\"|\')([^\2=\[\]]+)\2([^\[\]]*\])/i', $text, $mat ) ) {
			$text = str_replace ( $mat [0], $mat [1] . '|' . $mat [3] . '|' . $mat [4], $text );
		}
		//过滤错误的单个引号
		while ( preg_match ( '/\[[^\[\]]*(\"|\')[^\[\]]*\]/i', $text, $mat ) ) {
			$text = str_replace ( $mat [0], str_replace ( $mat [1], '', $mat [0] ), $text );
		}
		//转换其它所有不合法的 < >
		//$text = str_replace ( '<', '&lt;', $text );
		//$text = str_replace ( '>', '&gt;', $text );
		//$text = str_replace ( '"', '&quot;', $text );
		//反转换
		$text = str_replace ( '[', '<', $text );
		$text = str_replace ( ']', '>', $text );
		$text = str_replace ( '|', '"', $text );
		//过滤多余空格
		//$text = str_replace ( '  ', ' ', $text );
		return $text;
	}
}