<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 检查类
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowIs extends PHPnowClass {
	/**
	 * 验证数据 支持 in between equal length regex expire ip_allow ip_deny
	 * @param string $value 验证数据
	 * @param mixed $rule 验证表达式
	 * @param string $type 验证方式 默认为正则验证
	 * @return boolean
	 */
	public function check($value, $rule, $type = 'regex') {
		switch (strtolower ( $type )) {
			case 'in' : // 验证是否在某个指定范围之内 逗号分隔字符串或者数组
				$range = is_array ( $rule ) ? $rule : explode ( ',', $rule );
				return in_array ( $value, $range );
			case 'between' : // 验证是否在某个范围
				list ( $min, $max ) = explode ( ',', $rule );
				return $value >= $min && $value <= $max;
			case 'equal' : // 验证是否等于某个值
				return $value == $rule;
			case 'length' : // 验证长度
				$length = mb_strlen ( $value, 'utf-8' ); // 当前数据长度
				if (strpos ( $rule, ',' )) { // 长度区间
					list ( $min, $max ) = explode ( ',', $rule );
					return $length >= $min && $length <= $max;
				} else { // 指定长度
					return $length == $rule;
				}
			case 'expire' :
				list ( $start, $end ) = explode ( ',', $rule );
				if (! is_numeric ( $start ))
					$start = strtotime ( $start );
				if (! is_numeric ( $end ))
					$end = strtotime ( $end );
				return $_SERVER ['REQUEST_TIME'] >= $start && $_SERVER ['REQUEST_TIME'] <= $end;
			case 'ip_allow' : // IP 操作许可验证
				return in_array ( $this->PHPnowRequest->getClientIp (), explode ( ',', $rule ) );
			case 'ip_deny' : // IP 操作禁止验证
				return ! in_array ( $this->PHPnowRequest->getClientIp (), explode ( ',', $rule ) );
			case 'regex' :
			default : // 默认使用正则验证 可以使用验证类中定义的验证名称
				return preg_match ( $rule, $value );
		}
	}
	
	/**
	 * 验证邮箱
	 * @param string $string
	 */
	public function isEmail($string) {
		return preg_match ( '/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/', $string );
	}
	/**
	 * 验证URL
	 * @param string $string
	 */
	public function isUrl($string) {
		return preg_match ( '/^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/', $string );
	}
	/**
	 * 必填
	 * @param string $string
	 */
	public function isRequire($string) {
		return preg_match ( '/.+/', $string );
	}
	/**
	 * 货币
	 * @param string $string
	 */
	public function isCurrency($string) {
		return preg_match ( '/^\d+(\.\d+)?$/', $string );
	}
	/**
	 * 验证颜色
	 * @param string $string
	 */
	public function isColor($string) {
		return preg_match ( '/^[a-fA-F0-9]{6}$/', $string );
	}
	/**
	 * 验证中文
	 * @param string $string
	 */
	public function isChinese($string) {
		return preg_match ( '/^[\x{4e00}-\x{9fa5}]+$/u', $string );
	}
	/**
	 * 英文字母
	 * @param string $string
	 */
	public function isEnglish($string) {
		return preg_match ( '/^[A-Za-z]+$/', $string );
	}
	/**
	 * 验证手机
	 * @param string $string
	 */
	public function isMobile($string) {
		return preg_match ( '/^13[0-9]{9}|15[012356789][0-9]{8}|18[0256789][0-9]{8}|147[0-9]{8}$/', $string );
	}
	/**
	 * 验证电话
	 * @param string $string
	 */
	public function isTel($string) {
		return preg_match ( '/^(([0\\+]\\d{2,3}-)?(0\\d{2,3})-)?(\\d{7,8})(-(\\d{3,}))?$/', $string );
	}
	/**
	 * 是否包含不安全SQL语句
	 * @param string $string
	 */
	public function isSql($string) {
		return preg_match ( '/^(select|drop|delete|create|update|insert).*$/', $string );
	}
	/**
	 * * 验证ip
	 * @param string $string
	 * @param 4|6 $type IP类型
	 */
	public function isIp($string, $type = 4) {
		$type = $type == 6 ? FILTER_FLAG_IPV6 : FILTER_FLAG_IPV4;
		return filter_var ( $string, FILTER_VALIDATE_IP,$type );
	}
	/**
	 * 是否为URL XSS
	 */
	function isXss() {
		$temp = strtoupper ( urldecode ( urldecode ( $_SERVER ['REQUEST_URI'] ) ) );
		if (strpos ( $temp, '<' ) !== false || strpos ( $temp, '"' ) !== false || strpos ( $temp, 'CONTENT-TRANSFER-ENCODING' ) !== false) {
			return true;
		}
		return false;
	}
	/**
	 * 检查字符串是否是UTF8编码
	 */
	public function isUtf8($str) {
		$c = 0;
		$b = 0;
		$bits = 0;
		$len = strlen ( $str );
		for($i = 0; $i < $len; $i ++) {
			$c = ord ( $str [$i] );
			if ($c > 128) {
				if (($c >= 254))
					return false;
				elseif ($c >= 252)
					$bits = 6;
				elseif ($c >= 248)
					$bits = 5;
				elseif ($c >= 240)
					$bits = 4;
				elseif ($c >= 224)
					$bits = 3;
				elseif ($c >= 192)
					$bits = 2;
				else
					return false;
				if (($i + $bits) > $len)
					return false;
				while ( $bits > 1 ) {
					$i ++;
					$b = ord ( $str [$i] );
					if ($b < 128 || $b > 191)
						return false;
					$bits --;
				}
			}
		}
		return true;
	}
	/**
	 * 检查日期是否合法日期 
	 * @param 0000:00:00 $string
	 */
	public function isDate($string) {
		$dateArr = explode ( "-", $string );
		if (! empty ( $dateArr [0] ) && ! empty ( $dateArr [1] ) && ! empty ( $dateArr [2] ) && is_numeric ( $dateArr [0] ) && is_numeric ( $dateArr [1] ) && is_numeric ( $dateArr [2] )) {
			return checkdate ( $dateArr [1], $dateArr [2], $dateArr [0] );
		}
		return false;
	}
	/**
	 * 检查时间是否合法时间 
	 * @param 00:00:00 $string
	 */
	public function isTime($string) {
		$timeArr = explode ( ":", $string );
		if (is_numeric ( $timeArr [0] ) && is_numeric ( $timeArr [1] ) && is_numeric ( $timeArr [2] )) {
			return ($timeArr [0] >= 0 && $timeArr [0] <= 23) && ($timeArr [1] >= 0 && $timeArr [1] <= 59) && ($timeArr [2] >= 0 && $timeArr [2] <= 59) ? true : false;
		}
		return false;
	}
	/**
	 * 验证日期时间 
	 * @param yyyy-mm-dd hh:mm:ss $string
	 */
	public function isDateTime($string) {
		$string = explode ( ' ', $string );
		if (! empty ( $string [0] ) || ! empty ( $string [1] )) {
			if ($this->isDate ( $string [0] ) && $this->isTime ( $string [1] )) {
				return true;
			}
		}
		return false;
	}
	/**
	 * POST 请求
	 * @return boolean
	 */
	public function isPost() {
		return $this->PHPnowRequest->isPost ();
	}
	
	/**
	 * GET 请求
	 * @return boolean
	 */
	public function isGet() {
		return $this->PHPnowRequest->isGet ();
	}
	
	/**
	 * PUT 请求
	 * @return boolean
	 */
	public function isPut() {
		return $this->PHPnowRequest->isPut ();
	}
	
	/**
	 * DELETE 请求
	 * @return boolean
	 */
	public function isDelete() {
		return $this->PHPnowRequest->isDelete ();
	}
	
	/**
	 * HEAD请求
	 * @return boolean
	 */
	public function isHead() {
		return $this->PHPnowRequest->isHead ();
	}
	
	/**
	 * OPTIONS请求
	 * @return boolean
	 */
	public function isOptions() {
		return $this->PHPnowRequest->isOptions ();
	}
	/**
	 * 是否是jQuery ajax请求
	 * @return boolean
	 */
	public function isAjax() {
		return $this->PHPnowRequest->isXmlHttpRequest ();
	}
	/**
	 * 是否是Javascript XMLHttpRequest请求
	 * @return boolean
	 */
	public function isXmlHttpRequest() {
		return $this->PHPnowRequest->isXmlHttpRequest ();
	}
	
	/**
	 * 这是一个Flash请求
	 * @return boolean
	 */
	public function isFlashRequest() {
		return $this->PHPnowRequest->isFlashRequest ();
	}
	
	/**
	 * 是不HTTPS的安全要求
	 * @return boolean
	 */
	public function isSecure() {
		return $this->PHPnowRequest->isSecure ();
	}
}