<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 语言
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowLang extends PHPnowClass {
	/**
	 * 语言
	 * @var array
	 */
	protected static $_data = array ();
	/**
	 * 统计语言
	 * @var integer
	 */
	protected static $_count;
	/**
	 * 取得语言
	 * @param string $name
	 * @param mixed $default
	 * @return mixed
	 */
	static public function get($name, $default = null) {
		if (empty ( self::$_data [$name] )) {
			
			$lang = self::getPHPnowLangs ();
			if (is_array ( $lang )) {
				self::$_data = ! empty ( self::$_data [$name] ) ? array_merge ( self::$_data, $lang ) : $lang;
			}
			$lang = self::getAppLangs ();
			if (is_array ( $lang )) {
				self::$_data = ! empty ( self::$_data [$name] ) ? array_merge ( self::$_data, $lang ) : $lang;
			}
			self::$_count = count ( self::$_data);
		}
		return ! empty ( self::$_data [$name] ) ? self::$_data [$name] : $default;
	}
	/**
	 * 导入系统语言
	 * @param string $File
	 */
	static function getPHPnowLangs() {
		return PHPnowImport::import ( PHPNOW_LANGS_DIR . PHPnowConfig::get ( 'default_language' ) );
	}
	/**
	 * 导入项目语言
	 * @param string $File
	 */
	static function getAppLangs() {
		return PHPnowImport::import ( APP_PATH . APP_LANGS_NAME . DS . PHPnowConfig::get ( 'default_language' ) );
	}
	/**
	 * 魔术取得语言
	 * @param string $name
	 * @return mixed
	 */
	public function __get($name) {
		return self::get ( $name );
	}
	/**
	 * 设置语言
	 * @param  string $name
	 * @param  mixed  $value
	 * @param string $File
	 */
	static public function set($name, $value) {
		self::$_data [$name] = $value;
		self::$_count = count ( self::$_data);
	}
	/**
	 * 检查语言
	 * @param string $name
	 * @return boolean
	 */
	static public function isConfig($name) {
		return isset ( self::$_data [$name] );
	}
	/**
	 * 返回语言总个数
	 * @return int
	 */
	static public function count() {
		return self::$_count;
	}
}