<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 请求处理
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowRequest extends PHPnowClass {
	/**
	 * Scheme for http
	 *
	 */
	const SCHEME_HTTP = 'http';
	
	/**
	 * Scheme for https
	 *
	 */
	const SCHEME_HTTPS = 'https';
	
	/**
	 * Allowed parameter sources
	 * @var array
	 */
	protected $_paramSources = array ('_GET', '_POST' );
	
	/**
	 * REQUEST_URI
	 * @var string;
	 */
	protected $_requestUri;
	
	/**
	 * Base URL of request
	 * @var string
	 */
	protected $_baseUrl = null;
	
	/**
	 * Base path of request
	 * @var string
	 */
	protected $_basePath = null;
	
	/**
	 * PATH_INFO
	 * @var string
	 */
	protected $_pathInfo = '';
	
	/**
	 * Instance parameters
	 * @var array
	 */
	protected $_params = array ();
	
	/**
	 * Raw request body
	 * @var string|false
	 */
	protected $_rawBody;
	
	/**
	 * Alias keys for request parameters
	 * @var array
	 */
	protected $_aliases = array ();
	
	public function __construct() {
		$this->setRequestUri ();
	}
	
	/**
	 * 存取值
	 * Order of precedence: 1. GET, 2. POST, 3. COOKIE, 4. SERVER, 5. ENV
	 * @param string $key
	 * @return mixed
	 */
	public function __get($key) {
		switch (true) {
			case isset ( $this->_params [$key] ) :
				return $this->_params [$key];
			case isset ( $_GET [$key] ) :
				return $this->getQuery ( $key );
			case isset ( $_POST [$key] ) :
				return $this->getPost ( $key );
			case isset ( $_COOKIE [$key] ) :
				return $this->getCookie ( $key );
			case ($key == 'REQUEST_URI') :
				return $this->getRequestUri ();
			case ($key == 'PATH_INFO') :
				return $this->getPathInfo ();
			case isset ( $_SERVER [$key] ) :
				return $_SERVER [$key];
			case isset ( $_ENV [$key] ) :
				return $_ENV [$key];
			default :
				return null;
		}
	}
	
	/**
	 * 魔术 __get
	 *
	 * @param string $key
	 * @return mixed
	 */
	public function get($key) {
		return $this->__get ( $key );
	}
	
	public function __set($key, $value) {
	
	}
	
	/**
	 * 魔术设计 __set()
	 * @param string $key
	 * @param mixed $value
	 * @return void
	 */
	public function set($key, $value) {
		return $this->__set ( $key, $value );
	}
	
	/**
	 * 检查，是否设置属性
	 * @param string $key
	 * @return boolean
	 */
	public function __isset($key) {
		switch (true) {
			case isset ( $this->_params [$key] ) :
				return true;
			case isset ( $_GET [$key] ) :
				return true;
			case isset ( $_POST [$key] ) :
				return true;
			case isset ( $_COOKIE [$key] ) :
				return true;
			case isset ( $_SERVER [$key] ) :
				return true;
			case isset ( $_ENV [$key] ) :
				return true;
			default :
				return false;
		}
	}
	
	/**
	 * Alias to __isset()
	 *
	 * @param string $key
	 * @return boolean
	 */
	public function has($key) {
		return $this->__isset ( $key );
	}
	
	/**
	 * 设置GET
	 * @param  string|array $spec
	 * @param  null|mixed $value
	 * @return 
	 */
	public function setQuery($spec, $value = null) {
		if ((null === $value) && is_array ( $spec )) {
			foreach ( $spec as $key => $value ) {
				$this->setQuery ( $key, $value );
			}
			return $this;
		}
		$_GET [( string ) $spec] = $value;
		return $this;
	}
	
	/**
	 * 检索$_GET
	 * @param string $key
	 * @param mixed $default
	 * @return mixed
	 */
	public function getQuery($key = null, $default = null) {
		if (null === $key) {
			return $this->PHPnowInput ()->safe ( $_GET );
		}
		return (isset ( $_GET [$key] )) ? $this->PHPnowInput ()->safe ( $_GET [$key] ) : $default;
	}
	
	/**
	 * 设置$_POST
	 * @param  string|array $spec
	 * @param  null|mixed $value
	 * @return PHPnowRequest
	 */
	public function setPost($spec, $value = null) {
		if ((null === $value) && is_array ( $spec )) {
			foreach ( $spec as $key => $value ) {
				$this->setPost ( $key, $value );
			}
			return $this;
		}
		$_POST [( string ) $spec] = $value;
		return $this;
	}
	
	/**
	 * 返回$_POST
	 * @todo How to retrieve from nested arrays
	 * @param string $key
	 * @param mixed $default Default value to use if key not found
	 * @return mixed Returns null if key does not exist
	 */
	public function getPost($key = null, $default = null) {
		if (null === $key) {
			return $this->PHPnowInput ()->safe ( $_POST );
		}
		
		return (isset ( $_POST [$key] )) ? $this->PHPnowInput ()->safe ( $_POST [$key] ) : $default;
	}
	
	/**
	 *返回$_COOKIE
	 * @todo How to retrieve from nested arrays
	 * @param string $key
	 * @param mixed $default Default value to use if key not found
	 * @return mixed Returns null if key does not exist
	 */
	public function getCookie($key = null, $default = null) {
		if (null === $key) {
			return $this->PHPnowInput ()->safe ( $_COOKIE );
		}
		
		return (isset ( $_COOKIE [$key] )) ? $this->PHPnowInput ()->safe ( $_COOKIE [$key] ) : $default;
	}
	
	/**
	 * 返回$_SERVER
	 * @param string $key
	 * @param mixed $default Default value to use if key not found
	 * @return mixed Returns null if key does not exist
	 */
	public function getServer($key = null, $default = null) {
		if (null === $key) {
			return $_SERVER;
		}
		
		return (isset ( $_SERVER [$key] )) ? $_SERVER [$key] : $default;
	}
	
	/**
	 * 返回$_ENV
	 * @param string $key
	 * @param mixed $default Default value to use if key not found
	 * @return mixed Returns null if key does not exist
	 */
	public function getEnv($key = null, $default = null) {
		if (null === $key) {
			return $_ENV;
		}
		
		return (isset ( $_ENV [$key] )) ? $_ENV [$key] : $default;
	}
	
	/**
	 * 设置REQUEST_URI
	 *
	 * If no request URI is passed, uses the value in $_SERVER['REQUEST_URI'],
	 * $_SERVER['HTTP_X_REWRITE_URL'], or $_SERVER['ORIG_PATH_INFO'] + $_SERVER['QUERY_STRING'].
	 *
	 * @param string $requestUri
	 * @return PHPnowRequest
	 */
	public function setRequestUri($requestUri = null) {
		if ($requestUri === null) {
			if (isset ( $_SERVER ['HTTP_X_REWRITE_URL'] )) { // check this first so IIS will catch
				$requestUri = $_SERVER ['HTTP_X_REWRITE_URL'];
			} elseif (// IIS7 with URL Rewrite: make sure we get the unencoded url (double slash problem)
isset ( $_SERVER ['IIS_WasUrlRewritten'] ) && $_SERVER ['IIS_WasUrlRewritten'] == '1' && isset ( $_SERVER ['UNENCODED_URL'] ) && $_SERVER ['UNENCODED_URL'] != '') {
				$requestUri = $_SERVER ['UNENCODED_URL'];
			} elseif (isset ( $_SERVER ['REQUEST_URI'] )) {
				$requestUri = $_SERVER ['REQUEST_URI'];
				// Http proxy reqs setup request uri with scheme and host [and port] + the url path, only use url path
				$schemeAndHttpHost = $this->getScheme () . '://' . $this->getHttpHost ();
				if (strpos ( $requestUri, $schemeAndHttpHost ) === 0) {
					$requestUri = substr ( $requestUri, strlen ( $schemeAndHttpHost ) );
				}
			} elseif (isset ( $_SERVER ['ORIG_PATH_INFO'] )) { // IIS 5.0, PHP as CGI
				$requestUri = $_SERVER ['ORIG_PATH_INFO'];
				if (! empty ( $_SERVER ['QUERY_STRING'] )) {
					$requestUri .= '?' . $_SERVER ['QUERY_STRING'];
				}
			} else {
				return $this;
			}
		} elseif (! is_string ( $requestUri )) {
			return $this;
		} else {
			// Set GET items, if available
			if (false !== ($pos = strpos ( $requestUri, '?' ))) {
				// Get key => value pairs and set $_GET
				$query = substr ( $requestUri, $pos + 1 );
				parse_str ( $query, $vars );
				$this->setQuery ( $vars );
			}
		}
		
		$this->_requestUri = $requestUri;
		return $this;
	}
	
	/**
	 * 考虑返回REQUEST_URI
	 * 考虑 Apache and IIS
	 *
	 * @return string
	 */
	public function getRequestUri() {
		if (empty ( $this->_requestUri )) {
			$this->setRequestUri ();
		}
		
		return $this->_requestUri;
	}
	
	/**
	 * 设置基础URL的请求
	 * @param mixed $baseUrl
	 * @return PHPnowRequest
	 */
	public function setBaseUrl($baseUrl = null) {
		if ((null !== $baseUrl) && ! is_string ( $baseUrl )) {
			return $this;
		}
		
		if ($baseUrl === null) {
			$filename = (isset ( $_SERVER ['SCRIPT_FILENAME'] )) ? basename ( $_SERVER ['SCRIPT_FILENAME'] ) : '';
			
			if (isset ( $_SERVER ['SCRIPT_NAME'] ) && basename ( $_SERVER ['SCRIPT_NAME'] ) === $filename) {
				$baseUrl = $_SERVER ['SCRIPT_NAME'];
			} elseif (isset ( $_SERVER ['PHP_SELF'] ) && basename ( $_SERVER ['PHP_SELF'] ) === $filename) {
				$baseUrl = $_SERVER ['PHP_SELF'];
			} elseif (isset ( $_SERVER ['ORIG_SCRIPT_NAME'] ) && basename ( $_SERVER ['ORIG_SCRIPT_NAME'] ) === $filename) {
				$baseUrl = $_SERVER ['ORIG_SCRIPT_NAME']; // 1and1 shared hosting compatibility
			} else {
				// Backtrack up the script_filename to find the portion matching
				// php_self
				$path = isset ( $_SERVER ['PHP_SELF'] ) ? $_SERVER ['PHP_SELF'] : '';
				$file = isset ( $_SERVER ['SCRIPT_FILENAME'] ) ? $_SERVER ['SCRIPT_FILENAME'] : '';
				$segs = explode ( '/', trim ( $file, '/' ) );
				$segs = array_reverse ( $segs );
				$index = 0;
				$last = count ( $segs );
				$baseUrl = '';
				do {
					$seg = $segs [$index];
					$baseUrl = '/' . $seg . $baseUrl;
					++ $index;
				} while ( ($last > $index) && (false !== ($pos = strpos ( $path, $baseUrl ))) && (0 != $pos) );
			}
			
			// Does the baseUrl have anything in common with the request_uri?
			$requestUri = $this->getRequestUri ();
			
			if (0 === strpos ( $requestUri, $baseUrl )) {
				// full $baseUrl matches
				$this->_baseUrl = $baseUrl;
				return $this;
			}
			
			if (0 === strpos ( $requestUri, dirname ( $baseUrl ) )) {
				// directory portion of $baseUrl matches
				$this->_baseUrl = rtrim ( dirname ( $baseUrl ), '/' );
				return $this;
			}
			
			$truncatedRequestUri = $requestUri;
			if (($pos = strpos ( $requestUri, '?' )) !== false) {
				$truncatedRequestUri = substr ( $requestUri, 0, $pos );
			}
			
			$basename = basename ( $baseUrl );
			if (empty ( $basename ) || ! strpos ( $truncatedRequestUri, $basename )) {
				// no match whatsoever; set it blank
				$this->_baseUrl = '';
				return $this;
			}
			
			// If using mod_rewrite or ISAPI_Rewrite strip the script filename
			// out of baseUrl. $pos !== 0 makes sure it is not matching a value
			// from PATH_INFO or QUERY_STRING
			if ((strlen ( $requestUri ) >= strlen ( $baseUrl )) && ((false !== ($pos = strpos ( $requestUri, $baseUrl ))) && ($pos !== 0))) {
				$baseUrl = substr ( $requestUri, 0, $pos + strlen ( $baseUrl ) );
			}
		}
		
		$this->_baseUrl = rtrim ( $baseUrl, '/' );
		return $this;
	}
	
	/**
	 * 返回文件名称
	 * @return string
	 */
	public function getBaseUrl($raw = false) {
		if (null === $this->_baseUrl) {
			$this->setBaseUrl ();
		}
		
		return (($raw == false) ? urldecode ( $this->_baseUrl ) : $this->_baseUrl);
	}
	
	/**
	 *设置为URL的基本路径
	 * @param string|null $basePath
	 * @return PHPnowRequest
	 */
	public function setBasePath($basePath = null) {
		if ($basePath === null) {
			$filename = (isset ( $_SERVER ['SCRIPT_FILENAME'] )) ? basename ( $_SERVER ['SCRIPT_FILENAME'] ) : '';
			
			$baseUrl = $this->getBaseUrl ();
			if (empty ( $baseUrl )) {
				$this->_basePath = '';
				return $this;
			}
			
			if (basename ( $baseUrl ) === $filename) {
				$basePath = dirname ( $baseUrl );
			} else {
				$basePath = $baseUrl;
			}
		}
		
		if (substr ( PHP_OS, 0, 3 ) === 'WIN') {
			$basePath = str_replace ( '\\', '/', $basePath );
		}
		
		$this->_basePath = rtrim ( $basePath, '/' );
		return $this;
	}
	
	/**
	 * 前PATH_INFO的REQUEST_URI一切不包括文件名
	 * @return string
	 */
	public function getBasePath() {
		if (null === $this->_basePath) {
			$this->setBasePath ();
		}
		
		return $this->_basePath;
	}
	
	/**
	 * 设置PATH_INFO的字符串
	 *
	 * @param string|null $pathInfo
	 * @return PHPnowRequest
	 */
	public function setPathInfo($pathInfo = null) {
		if ($pathInfo === null) {
			$baseUrl = $this->getBaseUrl (); // this actually calls setBaseUrl() & setRequestUri()
			$baseUrlRaw = $this->getBaseUrl ( false );
			$baseUrlEncoded = urlencode ( $baseUrlRaw );
			
			if (null === ($requestUri = $this->getRequestUri ())) {
				return $this;
			}
			
			//从查询字符串REQUEST_URI
			$pos = strpos ( $requestUri, '?' );
			if ($pos) {
				$requestUri = substr ( $requestUri, 0, $pos );
			}
			
			if (! empty ( $baseUrl ) || ! empty ( $baseUrlRaw )) {
				if (strpos ( $requestUri, $baseUrl ) === 0) {
					$pathInfo = substr ( $requestUri, strlen ( $baseUrl ) );
				} elseif (strpos ( $requestUri, $baseUrlRaw ) === 0) {
					$pathInfo = substr ( $requestUri, strlen ( $baseUrlRaw ) );
				} elseif (strpos ( $requestUri, $baseUrlEncoded ) === 0) {
					$pathInfo = substr ( $requestUri, strlen ( $baseUrlEncoded ) );
				} else {
					$pathInfo = $requestUri;
				}
			} else {
				$pathInfo = $requestUri;
			}
		
		}
		
		$this->_pathInfo = ( string ) $pathInfo;
		return $this;
	}
	
	/**
	 * 返回的PATH_INFO
	 * @return string
	 */
	public function getPathInfo() {
		if (empty ( $this->_pathInfo )) {
			$this->setPathInfo ();
		}
		
		return $this->_pathInfo;
	}
	
	/**
	 * 设置允许的参数来源
	 * @param  array $paramSoures
	 * @return PHPnowRequest
	 */
	public function setParamSources(array $paramSources = array()) {
		$this->_paramSources = $paramSources;
		return $this;
	}
	
	/**
	 * 获取允许的参数
	 * @return array
	 */
	public function getParamSources() {
		return $this->_paramSources;
	}
	
	/**
	 * 设置一个参数
	 * @param mixed $key
	 * @param mixed $value
	 * @return PHPnowRequest
	 */
	public function setParam($key, $value) {
		$key = (null !== ($alias = $this->getAlias ( $key ))) ? $alias : $key;
		parent::setParam ( $key, $value );
		return $this;
	}
	
	/**
	 * 检索一个参数
	 *
	 * @param mixed $key
	 * @param mixed $default
	 * @return mixed
	 */
	public function getParam($key, $default = null) {
		$keyName = (null !== ($alias = $this->getAlias ( $key ))) ? $alias : $key;
		
		$paramSources = $this->getParamSources ();
		if (isset ( $this->_params [$keyName] )) {
			return $this->_params [$keyName];
		} elseif (in_array ( '_GET', $paramSources ) && (isset ( $_GET [$keyName] ))) {
			return $_GET [$keyName];
		} elseif (in_array ( '_POST', $paramSources ) && (isset ( $_POST [$keyName] ))) {
			return $_POST [$keyName];
		}
		
		return $default;
	}
	
	/**
	 * 检索参数
	 * @return array
	 */
	public function getParams() {
		$return = $this->_params;
		$paramSources = $this->getParamSources ();
		if (in_array ( '_GET', $paramSources ) && isset ( $_GET ) && is_array ( $_GET )) {
			$return += $_GET;
		}
		if (in_array ( '_POST', $paramSources ) && isset ( $_POST ) && is_array ( $_POST )) {
			$return += $_POST;
		}
		return $return;
	}
	
	/**
	 * 设置参数
	 *
	 * @param array $params
	 * @return PHPnowRequest
	 */
	public function setParams(array $params) {
		foreach ( $params as $key => $value ) {
			$this->setParam ( $key, $value );
		}
		return $this;
	}
	
	/**
	 * 设置一个别名
	 *
	 * @param string $name
	 * @param string $target
	 * @return PHPnowRequest
	 */
	public function setAlias($name, $target) {
		$this->_aliases [$name] = $target;
		return $this;
	}
	
	/**
	 * 检索别名
	 * @param string $name
	 * @return string|null
	 */
	public function getAlias($name) {
		if (isset ( $this->_aliases [$name] )) {
			return $this->_aliases [$name];
		}
		
		return null;
	}
	
	/**
	 * 检索所有的别名列表
	 * @return array
	 */
	public function getAliases() {
		return $this->_aliases;
	}
	
	/**
	 * 返回请求的方法
	 * @return string
	 */
	public function getMethod() {
		return $this->getServer ( 'REQUEST_METHOD' );
	}
	
	/**
	 * POST 请求
	 * @return boolean
	 */
	public function isPost() {
		if ('POST' == $this->getMethod ()) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * GET 请求
	 * @return boolean
	 */
	public function isGet() {
		if ('GET' == $this->getMethod ()) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * PUT 请求
	 * @return boolean
	 */
	public function isPut() {
		if ('PUT' == $this->getMethod ()) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * DELETE 请求
	 * @return boolean
	 */
	public function isDelete() {
		if ('DELETE' == $this->getMethod ()) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * HEAD请求
	 * @return boolean
	 */
	public function isHead() {
		if ('HEAD' == $this->getMethod ()) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * OPTIONS请求
	 * @return boolean
	 */
	public function isOptions() {
		if ('OPTIONS' == $this->getMethod ()) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * 是否是Javascript XMLHttpRequest请求
	 * @return boolean
	 */
	public function isXmlHttpRequest() {
		return ($this->getHeader ( 'X_REQUESTED_WITH' ) == 'XMLHttpRequest');
	}
	
	/**
	 * 这是一个Flash请求
	 * @return boolean
	 */
	public function isFlashRequest() {
		$header = strtolower ( $this->getHeader ( 'USER_AGENT' ) );
		return (strstr ( $header, ' flash' )) ? true : false;
	}
	
	/**
	 * 是不HTTPS的安全要求
	 * @return boolean
	 */
	public function isSecure() {
		return ($this->getScheme () === self::SCHEME_HTTPS);
	}
	
	/**
	 * 返回数据流
	 * @return string|false
	 */
	public function getRawBody() {
		if (null === $this->_rawBody) {
			$body = file_get_contents ( 'php://input' );
			
			if (strlen ( trim ( $body ) ) > 0) {
				$this->_rawBody = $body;
			} else {
				$this->_rawBody = false;
			}
		}
		return $this->_rawBody;
	}
	
	/**
	 * 返回给定的HTTP头的值
	 * @param string $header HTTP header name
	 * @return string|false HTTP header value, or false if not found
	 */
	public function getHeader($header) {
		if (empty ( $header )) {
			throw new PHPnowException ( '需要一个HTTP头的名称' );
		}
		
		// 尝试它首先从数组$ _SERVER
		$temp = 'HTTP_' . strtoupper ( str_replace ( '-', '_', $header ) );
		if (isset ( $_SERVER [$temp] )) {
			return $_SERVER [$temp];
		}
		
		// Apache
		if (function_exists ( 'apache_request_headers' )) {
			$headers = apache_request_headers ();
			if (isset ( $headers [$header] )) {
				return $headers [$header];
			}
			$header = strtolower ( $header );
			foreach ( $headers as $key => $value ) {
				if (strtolower ( $key ) == $header) {
					return $value;
				}
			}
		}
		
		return false;
	}
	
	/**
	 * 请求协议
	 * @return string
	 */
	public function getScheme() {
		return ($this->getServer ( 'HTTPS' ) == 'on') ? self::SCHEME_HTTPS : self::SCHEME_HTTP;
	}
	
	/**
	 * 取得HTTP host
	 * @return string
	 */
	public function getHttpHost() {
		$host = $this->getServer ( 'HTTP_HOST' );
		if (! empty ( $host )) {
			return $host;
		}
		
		$scheme = $this->getScheme ();
		$name = $this->getServer ( 'SERVER_NAME' );
		$port = $this->getServer ( 'SERVER_PORT' );
		
		if (null === $name) {
			return '';
		} elseif (($scheme == self::SCHEME_HTTP && $port == 80) || ($scheme == self::SCHEME_HTTPS && $port == 443)) {
			return $name;
		} else {
			return $name . ':' . $port;
		}
	}
	
	/**
	 * 返回客户端IP
	 * @param  boolean $checkProxy
	 * @return string
	 */
	public function getClientIp($checkProxy = true) {
		if ($this->getServer ( 'HTTP_X_FORWARDED_FOR' ) != null) {
			$ip = $this->getServer ( 'HTTP_X_FORWARDED_FOR' );
		} elseif ($this->getServer ( 'HTTP_X_REAL_IP' ) != null) {
			$ip = $this->getServer ( 'HTTP_X_REAL_IP' );
		} elseif ($checkProxy && $this->getServer ( 'HTTP_CLIENT_IP' ) != null) {
			$ip = $this->getServer ( 'HTTP_CLIENT_IP' );
		} elseif ($checkProxy && $this->getServer ( 'HTTP_X_FORWARDED_FOR' ) != null) {
			$ip = $this->getServer ( 'HTTP_X_FORWARDED_FOR' );
		} else {
			$ip = $this->getServer ( 'REMOTE_ADDR' );
		}
		return $ip;
	}
	/**
	 * 找到IP的物理详情信息
	 * @param ip $ip 不提供时默认客户端IP
	 */
	public function ipArea($ip = '') {
		static $IpInfo = array ();
		if (empty ( $ip ) || ! isIp ( $ip )) {
			$ip = $this->getClientIp ();
		}
		$key = $ip;
		if (empty ( $IpInfo [$key] )) {
			$data = F ( $key );
			if (empty ( $data )) {
				$Iparea = $this->InstanceStatic ( 'ipareaPlugins' );
				$Info ['area'] = $Iparea->get ( $ip ); //地区名
				$Info ['getcity'] = $Iparea->getcity ( $ip ); //城市名和拼音，数组
				$Info ['ip'] = $ip;
				F ( $key, $Info );
				$IpInfo [$key] = $Info;
				unset ( $Iparea );
				unset ( $Info );
			} else {
				$IpInfo [$key] = $data;
			}
		}
		return ! empty ( $IpInfo [$key] ) ? $IpInfo [$key] : '';
	}
}