<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 返回类
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class PHPnowReturns extends PHPnowClass {
	/**
	 * Ajax方式返回数据到客户端
	 * @param string $status 状态
	 * @param string $info 消息
	 * @param array $data 数据
	 * @param JSON|XML|EVAL $type 类型
	 */
	public function ajaxReturn($status, $info, $data = '', $type = 'JSON') {
		$result ['status'] = $status;
		$result ['info'] = $info;
		$result ['data'] = $data;
		if (strtoupper ( $type ) == 'JSON') {
			// 返回JSON数据格式到客户端 包含状态信息
			exit ( json_encode ( $result ) );
		} elseif (strtoupper ( $type ) == 'XML') {
			// 返回xml格式数据
			exit ( $this->string->xml_encode ( $result ) );
		} elseif (strtoupper ( $type ) == 'EVAL') {
			// 返回可执行的js脚本
			exit ( $data );
		}
	}
	/**
	 * 操作成功跳转的快捷方法
	 * @param 消息  $message
	 * @param 关闭 $closeWin
	 * @param 地址 $url
	 * @param  返回方法 $ajax
	 */
	public function success($message, $url = 0, $closeWin = 0, $ajax = false) {
		$this->_dispatch_jump ( $message, 1, $closeWin, $url, $ajax );
	}
	/**
	 * 操作错误跳转的快捷方法
	 * @param 消息  $message
	 * @param 关闭 $closeWin
	 * @param 地址 $url
	 * @param  返回方法 $ajax
	 */
	public function error($message, $url = 0, $closeWin = 0, $ajax = false) {
		$this->_dispatch_jump ( $message, 0, $closeWin, $url, $ajax );
	}
	private function _dispatch_jump($message, $status = 1, $closeWin = 0, $url = 0, $ajax = false) {
		// 判断是否为AJAX返回
		if ($ajax || isAjax ()) {
			$this->ajaxReturn ( $status, $message );
		}
		// 提示标题
		$this->PHPnowView->assign ( 'msgTitle', $status ? Lang('OPERATION_WAS_SUCCESSFUL') : Lang('OPERATION_WAS_FAILURE') );
		$this->PHPnowView->assign ( 'status', $status ); // 状态
		$this->PHPnowView->assign ( 'message', $message ); // 提示信息
		if ($status) {
			// 成功操作后默认停留1秒
			$this->PHPnowView->assign ( 'waitSecond', "1" );
			// 默认操作成功自动返回操作前页面
			$this->PHPnowView->assign ( "url", $url );
		} else {
			//发生错误时候默认停留3秒
			$this->PHPnowView->assign ( 'waitSecond', "3" );
			// 默认发生错误的话自动返回上页
			if (empty ( $url )) {
				$url = 'javascript:history.back();';
			}
			empty ( $closeWin ) ? $this->PHPnowView->assign ( 'url', $url ) : $this->PHPnowView->assign ( 'url', 'javascript:window.close();' );
			$this->PHPnowView->assign ( 'closeWin', $closeWin );
		}
		$this->PHPnowView->display ( Config ( 'view_error' ) );
		exit ();
	}
}