<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 模板引擎
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */

class PHPnowView extends PHPnowClass {
	private static $View;
	public function __construct() {
		if (empty ( self::$View )) {
			defined ( 'VIEW_DRIVE_DIR' ) or define ( 'VIEW_DRIVE_DIR', 'smarty' );
			if (! PHPnowImport::import ( PHPNOW_DRIVE_DIR . 'view' . DS . VIEW_DRIVE_DIR ))
				throw new PHPnowException ( '模板驱动 "' . VIEW_DRIVE_DIR . '" 不存在' );
			$classname = VIEW_DRIVE_DIR . 'View';
			self::$View = new $classname ();
			self::$View->construct ();
		}
	}
	public function view(){
		return self::$View;
	}
	public function isCached($template = null, $cache_id = null, $compile_id = null, $parent = null) {
		$this->view_template ( $template );
		if (! empty ( $template ))
			return self::$View->isCached ( $template, $cache_id, $compile_id, $parent );
		else
			throw new PHPnowException ( PHPnowLang::get ( 'VIEW_DOES NOT EXIST' ) );
	}
	public function assign($tpl_var, $value = null, $nocache = false) {
		self::$View->assign ( $tpl_var, $value, $nocache );
	}
	public function display($template = null, $cache_id = null, $compile_id = null, $parent = null) {
		$this->assign('MODULE_NAME',MODULE_NAME);
		$this->assign('CONTROLLER_NAME',CONTROLLER_NAME);
		$this->assign('ACTION_NAME',ACTION_NAME);
		$this->view_template ( $template );
		//header ( 'Content-Type:text/html; charset=utf-8' );
		//header ( 'Cache-control:private' );
		//header ( 'X-Powered-By:www.phpnow.cn' );
		if (! empty ( $template )) {
			$output = self::$View->fetch ( $template, $cache_id, $compile_id, $parent );
			
			echo $output;
		} else
			throw new PHPnowException ( PHPnowLang::get ( 'VIEW_DOES NOT EXIST' ) );
	}
	public function format_tags(&$content) {
		if (Config ( 'view_strip_space' ))
			$content = $this->PHPnowInput->CompressedCode ( $content );
		return $content;
	}
	/**
	 * 解析出编译地址
	 * @param string $template_name
	 * @return string
	 */
	public function view_template(&$template_name) {
		if (! empty ( $template_name )) {
			$template_name = PHPnowDir::dir_path ( str_replace ( '.', DS, $template_name ) );
		}
		if (empty ( $template_name )) {
			$template_name = MODULE_NAME . DS . CONTROLLER_NAME . DS . ACTION_NAME;
		} elseif (! strrchr ( $template_name, DS )) {
			$template_name = MODULE_NAME . DS . CONTROLLER_NAME . DS . $template_name;
		}
		$template_name = APP_PATH . APP_VIEWS_DIR_NAME . DS . Config ( 'view_default' ) . DS . $template_name . Config ( 'view_suffix' );
		
		if (! is_file ( $template_name ))
			$template_name = null;
		return $template_name;
	}
}
/**
 * 数据库接口
 * @author jiaodu
 *
 */
interface ViewImplements {
	/**
	 * 实例模板引擎
	 */
	public function construct();
	
	public function isCached($template = null, $cache_id = null, $compile_id = null, $parent = null);
	
	public function assign($tpl_var, $value = null, $nocache = false);
	
	public function fetch($template = null, $cache_id = null, $compile_id = null, $parent = null);
}