<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 文件缓存类
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class CacheFile implements CacheImplements {
	/**
	 * 返回缓存目录
	 * @param string $key
	 */
	public function Directory(&$key) {
		$k = md5 ( ( string ) $key );
		$key = str_split ( $k, 2 );
		$key = $key [0] . DS . $key [1] . DS . $key [2] . DS . $k . '.Cache.php';
		$key = PHPnowDir::path ( Config ( 'cache_directory' ) ) . $key;
		return $key;
	}
	/**
	 * 读取一条Cache
	 * @param string $file	缓存的key 可以是数组
	 * @param string $method	缓存方法
	 * @return mix
	 */
	public function get($key) {
		$this->Directory ( $key );
		if (is_array ( $key )) {
			$rt = array ();
			foreach ( $key as $ck ) {
				$cv = $this->get ( $ck );
				if (null !== $cv) {
					$rt [$ck] = $cv;
				}
			}
			return $rt;
		} else {
			if (! is_readable ( $key ) || intval ( filemtime ( $key ) ) < time ()) {
				return null;
			}
			return include ($key);
		}
	}
	/**
	 * 写入一条Cache
	 * @param string $key 缓存的Key
	 * @param mix $data 缓存的数据
	 * @param number $expire 超时时间，单位秒
	 */
	public function set($key, $data, $expire) {
		if (is_array ( $key )) {
			foreach ( $key as $ck => $cv ) {
				$this->set ( $ck, $cv, $expire );
			}
		} else {
			$data = "<?php\r\ndefined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );\r\n/**\r\n 缓存由PHPnow创建 创建时区:" . Config ( 'default_timezone' ) . ' ' . strftime ( "%Y-%m-%d %H:%M:%S", time () ) . " , 不要删除!\r\n*/ \r\nreturn " . var_export ( $data, true ) . ";";
			! $expire && $expire = mt_rand ( 24, 48 ) * 3600;
			$this->Directory ( $key );
			PHPnowFile::set ( $key, $data );
			unset ( $data );
			@touch ( $key, time () + $expire );
		}
	}
	/**
	 * 
	 * 删除一条Cache
	 *
	 * @param string $key 缓存Key
	 */
	public function delete($key) {
		if (is_array ( $key )) {
			foreach ( $key as $ck ) {
				$this->delete ( $ck );
			}
		} else {
			$this->Directory ( $key );
			PHPnowFile::delete ( $key );
		}
	}
	/**
	 * 清空缓存
	 * @param string $method	缓存方法
	 */
	public function flush() {
		return PHPnowDir::delete ( Config ( 'cache_directory' ) );
	}

}