<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * Memcached 缓存类
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2010-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class CacheMemcache implements CacheImplements {
	private $memType = null;
	private $mem = null;
	private $cfg = null;
	/**
	 * 载入配置文件
	 */
	private function loadcfg() {
		if (! isset ( $this->cfg )) {
			$memcached = array (0 => array (0 => config ( 'memcache_server' ), 1 => config ( 'memcache_port' ), 2 => 1 ) );
			$this->cfg = $memcached;
			unset ( $memcached );
		}
	}
	/**
	 * 获取Memcached Client
	 * 支持Memcached扩展的情况下使用Memcached
	 * 否则使用memcache扩展
	 * 如果memcache扩展也不支持，则放弃
	 */
	private function getMemcached() {
		if (null === $this->memType) {
			$this->loadcfg ();
			if (class_exists ( 'Memcached', false )) {
				if ($this->cfg) {
					$this->mem = new Memcached ();
					$this->memType = 'memcached';
					$this->mem->addServers ( $this->cfg );
					return $this->mem;
				} else {
					throw new PHPnowException ( 'Memcached ' . Lang ( 'FAILED_TO_START' ) );
				}
			} elseif (class_exists ( 'Memcache', false )) {
				if ($this->cfg) {
					$this->mem = new Memcache ();
					$this->memType = 'memcache';
					foreach ( $this->cfg as $server ) {
						$this->mem->addServer ( $server [0], $server [1], false, $server [2] );
					}
					return $this->mem;
				} else {
					throw new PHPnowException ( 'Memcache ' . Lang ( 'FAILED_TO_START' ) );
				}
			} else {
				throw new PHPnowException ( Lang ( 'CACHE_FAILED_TO_START' ) );
			}
		}
		return $this->mem;
	}
	/**
	 * 读取一条Cache
	 * @param string $file	缓存的key 可以是数组
	 * @return mix
	 */
	public function get($key) {
		$mem = $this->getMemcached ();
		if ($mem) {
			switch ($this->memType) {
				//使用Memcached扩展
				case 'memcached' :
					if (is_array ( $key )) {
						$cas = array ();
						return $mem->getMulti ( $key, $cas, Memcached::GET_PRESERVE_ORDER );
					} else {
						return $mem->get ( $key );
					}
					break;
				case 'memcache' :
					return $mem->get ( $key );
					break;
			}
		}
		return null;
	}
	/**
	 * 写入一条Cache
	 * @param string $key 缓存的Key
	 * @param mix $data 缓存的数据
	 * @param number $expire 超时时间，单位秒
	 */
	public function set($key, $data, $expire) {
		$mem = $this->getMemcached ();
		if ($mem) {
			switch ($this->memType) {
				case 'memcached' :
					if (is_array ( $key )) {
						//批量设置
						$mem->setMulti ( $key, time () + $expire );
					} else {
						//单个
						$mem->set ( $key, $data, time () + $expire );
					}
					break;
				case 'memcache' :
					if (is_array ( $key )) {
						//批量设置
						foreach ( $key as $mk => $mv ) {
							$mem->set ( $mk, $mv, false, $expire );
						}
					} else {
						//单个
						$mem->set ( $key, $data, false, $expire );
					}
					break;
			}
		}
	}
	/**
	 * 
	 * 删除一条Cache
	 *
	 * @param string $key 缓存Key
	 */
	public function delete($key) {
		$mem = $this->getMemcached ();
		if ($mem) {
			switch ($this->memType) {
				case 'memcached' :
					if (is_array ( $key )) {
						//Memcached 扩展2.0新增 deleteMulti
						if (method_exists ( $mem, 'deleteMulti' )) {
							$mem->deleteMulti ( $key );
						} else {
							foreach ( $key as $mk ) {
								$mem->delete ( $mk );
							}
						}
					} else {
						$mem->delete ( $key );
					}
					break;
				case 'memcache' :
					if (is_array ( $key )) {
						foreach ( $key as $mk ) {
							$mem->delete ( $mk );
						}
					} else {
						$mem->delete ( $key );
					}
					break;
			}
		}
	}
	/**
	 * 清空缓存
	 */
	public function flush() {
		$mem = $this->getMemcached ();
		if ($mem) {
			$mem->flush ();
		}
	}
}