<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * PDO数据库操作
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class pdoDatabase implements DatabaseImplements {
	private $Database;
	
	public function initialize(PHPnowDatabase $database) {
		$this->Database = $database;
		return $this;
	}
	/**
	 * 返回连接
	 */
	public function connection($con, $db) {
		$db_dsn = ! empty ( $con ['db_dsn'] ) ? $con ['db_dsn'] : '';
		$db_user = ! empty ( $con ['db_user'] ) ? $con ['db_user'] : '';
		$db_pwd = ! empty ( $con ['db_pwd'] ) ? $con ['db_pwd'] : '';
		$db_options = ! empty ( $con ['db_options'] ) && is_array ( $con ['db_options'] ) ? $con ['db_options'] : '';
		try {
			$db = explode ( '.', $db );
			$this->Database->$db [0] = new PDO ( $db_dsn, $db_user, $db_pwd, $db_options );
			if (! empty ( $db [1] ))
				$this->Database->$db [1] = $this->Database->$db [0];
		} catch ( PDOException $e ) {
			throw new PHPnowException ( Lang ( 'DATABASE_CONNECTION_FAILED' ) . $e->getMessage () );
		}
		return $this;
	}
	/**
	 * 执行查询SQL
	 * @param string $sql
	 */
	public function query($sql) {
		$time = microtime ();
		$this->Database->replaceSql ( $sql, $this->Database->db_query_prefix );
		$query = $this->Database->db_query->query ( ( string ) $sql );
		if (! $query)
			$this->errorMessage ( $this->Database->db_query );
		$this->Database->pushSql ( $sql, microtime () - $time );
		$this->Database->cache =false;
		return $query;
	}
	/**
	 * 执行查询一条
	 * @param string $sql
	 */
	public function fetch($sql) {
		return $this->get ( $sql, true );
	}
	/**
	 * 执行查询多条
	 * @param string $sql
	 */
	public function fetchAll($sql) {
		return $this->get ( $sql, false );
	}
	private function get($sql, $one = true) {
		if ($this->Database->cache === null)
			F ( $sql, null );
		if (is_numeric ( $this->Database->cache ))
			$query = F ( $sql );
		if (empty ( $query )) {
			if (! empty ( $one ))
				$query = $this->query ( $sql )->fetch ();
			else
				$query = $this->query ( $sql )->fetchAll ();
			if (is_numeric ( $this->Database->cache ))
				F ( $sql, $query, $this->Database->cache );
		}
		
		return $query;
	}
	/**
	 * 执行SQL
	 * @param string $sql
	 */
	public function exec($sql) {
		$time = microtime ();
		$this->Database->replaceSql ( $sql, $this->Database->db_exec_prefix );
		$exec = $this->Database->db_exec->exec ( ( string ) $sql );
		if (! $exec)
			$this->errorMessage ( $this->Database->db_exec );
		$this->Database->pushSql ( $sql, microtime () - $time );
		return $exec;
	}
	/**
	 * 返回上次插入操作最后一条ID
	 */
	public function lastInsertId() {
		return $this->Database->db_exec->lastInsertId ();
	}
	/**
	 * 抛出错误
	 */
	public function errorMessage($db) {
		$msg = $db->errorInfo ();
		if (! empty ( $msg [2] )) {
			throw new PHPnowException ( 'SQL' . Lang ( 'ERROR' ) . '：' . $msg [2] );
		}
	}
}