<?php
class smartyView implements ViewImplements {
	private static $Smarty;
	/**
	 * (实例模板引擎)
	 * @see ViewImplements::construct()
	 */
	public function construct() {
		if (empty ( self::$Smarty )) {
			PHPnowImport::import ( dirname ( __FILE__ ) . DS . 'Smarty' . DS . 'SmartyBC.class' );
			self::$Smarty = new SmartyBC ();
			self::$Smarty->left_delimiter = Config ( 'view_left_delimiter' );
			self::$Smarty->right_delimiter = Config ( 'view_right_delimiter' );
			self::$Smarty->template_dir = APP_PATH . APP_VIEWS_DIR_NAME . DS . Config ( 'view_default' );
			self::$Smarty->compile_dir = PHPnowDir::path ( Config ( 'view_compile_dir' ) ) . Config ( 'view_default' );
			self::$Smarty->cache_dir = PHPnowDir::path ( Config ( 'view_cache_dir' ) ) . Config ( 'view_default' );
			self::$Smarty->debugging = Config ( 'default_debugging' );
			self::$Smarty->use_sub_dirs = true;
			self::$Smarty->config_dir = APP_PATH . APP_VIEWS_DIR_NAME . DS . Config ( 'view_default' ) . DS . 'config';
		}
		return self::$Smarty;
	}
	public function isCached($template = null, $cache_id = null, $compile_id = null, $parent = null) {
		self::$Smarty->caching = true;
		self::$Smarty->cache_lifetime = Config ( 'view_cache_lifetime' );
		return self::$Smarty->isCached ( $template, $cache_id, $compile_id, $parent );
	}
	public function assign($tpl_var, $value = null, $nocache = false) {
		self::$Smarty->assign ( $tpl_var, $value, $nocache );
	}
	public function fetch($template = null, $cache_id = null, $compile_id = null, $parent = null) {
		//self::$Smarty->display ( $template, $cache_id, $compile_id, $parent );
		return self::$Smarty->fetch ( $template, $cache_id, $compile_id, $parent );
	}
}