<?php
/**
 * 公共函数
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
/**
 * 运行项目
 * @param array $options 实例选项
 */
function PHPnowRun($options = '') {
	PHPnowApp ( $options )->run ();
}
/**
 * 实例项目
 * @param array $options 实例选项例
 */
function PHPnowApp($options = '') {
	static $PHPnowApp = '';
	if (empty ( $PHPnowApp ))
		$PHPnowApp = new PHPnowApp ( $options );
	return $PHPnowApp;
}
/**
 * 取得配制
 * @param string $name 配制名称
 * @param string $File 文件
 * @param mixed $default 默认返回|值
 * @param bool $set 是否设置
 * @return mixed
 */
function Config($name, $File = 'common', $default = null, $set = false) {
	static $PHPnowConfig = '';
	if (empty ( $PHPnowConfig ))
		$PHPnowConfig = PHPnowApp ()->PHPnowConfig;
	return empty ( $set ) ? $PHPnowConfig->get ( $name, $File, $default ) : $PHPnowConfig->set ( $name, $File, $default );
}
/**
 * 设置配制
 * @param string $name 配制名称
 * @param mixed $value 值
 * @param string $File 文件
 */
function ConfigSet($name, $value, $File = 'common') {
	return Config ( $name, $value, $File, true );
}
/**
 * * 取得语言
 * @param string $name
 * @param mixed $default 默认返回|值
 * @param bool $set 是否设置
 * @return mixed
 */
function Lang($name, $default = '', $set = false) {
	static $PHPnowLang = '';
	if (empty ( $PHPnowLang ))
		$PHPnowLang = PHPnowApp ()->PHPnowLang;
	return empty ( $set ) ? $PHPnowLang->get ( $name, $default ) : $PHPnowLang->set ( $name, $default );
}
/**
 * 设置语言
 * @param  string $name
 * @param  mixed  $value
 * @param string $File
 */
function LangSet($name, $value) {
	return Lang ( $name, $value, true );
}
/**
 * 快速缓存操作
 * @param string $key 缓存的Key
 * @param mix $data 缓存的数据 默认读取  null则删除
 * @param number $expire 超时时间，单位秒
 * @param string $method 缓存方法
 */
function F($key, $data = '', $expire = null, $method = null) {
	static $PHPnowCache = '';
	if (empty ( $PHPnowCache ))
		$PHPnowCache = PHPnowApp ()->PHPnowCache;
	if ($key === null) {
		//清空数据
		return $PHPnowCache->flush ( $method );
	} elseif ($data === '') {
		//读取
		return $PHPnowCache->get ( $key, $method );
	} elseif ($data === null) {
		//删除
		return $PHPnowCache->delete ( $key, $method );
	} else {
		//写入
		return $PHPnowCache->set ( $key, $data, $expire, $method );
	}
}
/**
 * URL解析
 * @param string $url
 * @param string $get
 * @return string
 */
function Url($url, $get = null) {
	static $PHPnowBootstrap = '';
	if (empty ( $PHPnowBootstrap ))
		$PHPnowBootstrap = PHPnowApp ()->PHPnowBootstrap;
	return $PHPnowBootstrap->url ( $url, $get );
}
/**
 * 实例PHPnowString
 */
function PHPnowString() {
	static $PHPnowString = '';
	if (empty ( $PHPnowString ))
		$PHPnowString = PHPnowApp ()->PHPnowString;
	return $PHPnowString;
}
/**
 * 汉字转拼音
 * @param string $string
 * @param string $code UTF8 OR gb2312
 * @return array
 */
function Pinyin($string, $code = 'UTF8') {
	return PHPnowString ()->Pinyin ( $string, $code );
}
/**
 * 简繁转换
 * @param string $data
 * @param string $charset utf-8|gb2312
 * @param string $type 1简体转繁体：0繁体转简体
 */
function CnHk($data, $type = 1, $charset = 'utf-8') {
	return PHPnowString ()->CnHk ( $data, $type, $charset );
}
/**
 * 导入文件
 * @param string $file
 * @param bool $once 是否防重复导入
 */
function Import($file, $once = false) {
	return PHPnowImport ()->import ( $file, $once = false );
}
/**
 * 导入函数
 * @param string $file
 */
function impFun($file) {
	return PHPnowImport ()->impFun ( $file );
}
/**
 * 导入插件
 * @param string $file
 */
function impPlu($file) {
	return PHPnowImport ()->impPlu ( $file );
}

function PHPnowImport() {
	static $PHPnowImport = '';
	if (empty ( $PHPnowImport ))
		$PHPnowImport = PHPnowApp ()->PHPnowImport;
	return $PHPnowImport;
}
/**
 * 实例数据库操作
 * @param string $table 表
 */
function D($table = '') {
	static $PHPnowDatabase = '';
	static $TableDatabase = array ();
	if (empty ( $PHPnowDatabase ))
		$PHPnowDatabase = PHPnowApp ()->PHPnowDatabase;
	if (empty ( $TableDatabase [$table] ))
		$TableDatabase [$table] = $PHPnowDatabase->table ( $table );
	return $TableDatabase [$table];
}
/**
 * 实例模型
 * @param string $name 名称
 */
function M($name) {
	static $Model = array ();
	$name .= 'Model';
	if (empty ( $Model [$name] ))
		$Model [$name] = PHPnowApp ()->$name;
	return $Model [$name];
}
/**
 * 实例插件
 * @param string $name
 * @return bool
 */
function P($name) {
	static $Plu = array ();
	if (impPlu ( $name )) {
		if (empty ( $Plu [$name] ))
			$Plu [$name] = new $name ();
		return $Plu [$name];
	}
	return false;
}
/**
 * 检查
 */
function Is() {
	static $PHPnowIs = '';
	if (empty ( $PHPnowIs ))
		$PHPnowIs = PHPnowApp ()->PHPnowIs;
	return $PHPnowIs;
}
/**
 * 验证邮箱
 * @param string $string
 */
function isEmail($string) {
	return Is ()->isEmail ( $string );
}
/**
 * 验证URL
 * @param string $string
 */
function isUrl($string) {
	return Is ()->isUrl ( $string );
}
/**
 * 必填
 * @param string $string
 */
function isRequire($string) {
	return Is ()->isRequire ( $string );
}
/**
 * 货币
 * @param string $string
 */
function isCurrency($string) {
	return Is ()->isCurrency ( $string );
}
/**
 * 验证颜色
 * @param string $string
 */
function isColor($string) {
	return Is ()->isColor ( $string );
}
/**
 * 验证中文
 * @param string $string
 */
function isChinese($string) {
	return Is ()->isChinese ( $string );
}
/**
 * 英文字母
 * @param string $string
 */
function isEnglish($string) {
	return Is ()->isEnglish ( $string );
}
/**
 * 验证手机
 * @param string $string
 */
function isMobile($string) {
	return Is ()->isMobile ( $string );
}
/**
 * 验证电话
 * @param string $string
 */
function isTel($string) {
	return Is ()->isTel ( $string );
}
/**
 * 是否包含不安全SQL语句
 * @param string $string
 */
function isSql($string) {
	return Is ()->isSql ( $string );
}
/**
 * * 验证ip
 * @param string $string
 * @param 4|6 $type IP类型
 */
function isIp($string, $type = 4) {
	return Is ()->isIp ( $string, $type );
}
/**
 * 是否为URL XSS
 */
function isXss() {
	return Is ()->isXss ();
}
/**
 * 检查字符串是否是UTF8编码
 */
function isUtf8($string) {
	return Is ()->isUtf8 ( $string );
}
/**
 * 检查日期是否合法日期 
 * @param 0000:00:00 $string
 */
function isDate($string) {
	return Is ()->isDate ( $string );
}
/**
 * 检查时间是否合法时间 
 * @param 00:00:00 $string
 */
function isTime($string) {
	return Is ()->isTime ( $string );
}
/**
 * 验证日期时间 
 * @param yyyy-mm-dd hh:mm:ss $string
 */
function isDateTime($string) {
	return Is ()->isDateTime ( $string );
}
/**
 * POST 请求
 * @return boolean
 */
function isPost() {
	return Is ()->isPost ();
}

/**
 * GET 请求
 * @return boolean
 */
function isGet() {
	return Is ()->isGet ();
}

/**
 * PUT 请求
 * @return boolean
 */
function isPut() {
	return Is ()->isPut ();
}

/**
 * DELETE 请求
 * @return boolean
 */
function isDelete() {
	return Is ()->isDelete ();
}

/**
 * HEAD请求
 * @return boolean
 */
function isHead() {
	return Is ()->isHead ();
}

/**
 * OPTIONS请求
 * @return boolean
 */
function isOptions() {
	return Is ()->isOptions ();
}
/**
 * 是否是jQuery ajax请求
 * @return boolean
 */
function isAjax() {
	return Is ()->isAjax ();
}
/**
 * 是否是Javascript XMLHttpRequest请求
 * @return boolean
 */
function isXmlHttpRequest() {
	return Is ()->isXmlHttpRequest ();
}

/**
 * 这是一个Flash请求
 * @return boolean
 */
function isFlashRequest() {
	return Is ()->isFlashRequest ();
}

/**
 * 是不HTTPS的安全要求
 * @return boolean
 */
function isSecure() {
	return Is ()->isSecure ();
}
function PHPnowRequest() {
	static $PHPnowRequest = '';
	if (empty ( $PHPnowRequest ))
		$PHPnowRequest = PHPnowApp ()->PHPnowRequest;
	return $PHPnowRequest;
}
/**
 * 返回客户端IP
 * @param  boolean $checkProxy
 * @return string
 */
function getClientIp($checkProxy = true) {
	return PHPnowRequest ()->getClientIp ( $checkProxy );
}
/**
 * 返回IP信息
 * @param string $ip
 * @return array
 * [area] => 广东省珠海市
    	[getcity] => Array
       			 (
          			[city] => 珠海
          			[pinyin] => zhuhai
       			 )

    	[ip] => 61.143.50.9
 */
function getIparea($ip = '') {
	return PHPnowRequest ()->ipArea ( $ip );
}