<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * Session操作
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2011-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class Session extends PHPnowClass {
	static function start() {
		if (! defined ( 'SESSION_START' )) {
			session_set_cookie_params ( PHPnowConfig::get ( 'cookie_expire' ), PHPnowConfig::get ( 'cookie_path' ), PHPnowConfig::get ( 'cookie_domain' ) );
			ini_set ( 'session.gc_maxlifetime', PHPnowConfig::get ( 'cookie_expire' ) );
			@session_start ();
			define ( 'SESSION_START', true );
		}
	}
	/**
	 * 判断Session是否存在
	 * @param string $name
	 */
	static function is_set($name) {
		self::start ();
		return isset ( $_SESSION [$name] );
	}
	/**
	 * 获取某个Session值
	 * @param string $name
	 */
	static function get($name) {
		self::start ();
		return self::is_set ( $name ) ? $_SESSION [$name] : null;
	}
	/**
	 * 设置某个Session值
	 * @param string $name 名称
	 * @param string $value 值
	 */
	static function set($name, $value) {
		self::start ();
		$_SESSION [$name] = $value;
	}
	/**
	 * 删除某个Session值
	 * @param string $name
	 */
	static function delete($name) {
		self::start ();
		unset ( $_SESSION [$name] );
	}
	/**
	 * 清空Session值
	 */
	static function clear() {
		self::start ();
		session_destroy ();
	}
}
