<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * 验证码
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2010-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class Vcode extends PHPnowClass {
	//验证码的宽度
	public $width;
	//验证码的高
	public $height;
	//设置字体的地址
	private $font;
	//设置字体色
	public $font_color;
	//设置背景色
	public $background;
	//生成验证码字符数
	public $code_len = 6;
	//字体大小
	public $font_size;
	private $code;
	//图片内存
	private $img;
	//文字X轴开始的地方
	private $x_start;
	private $r = Array (225, 255, 255, 223 );
	private $g = Array (225, 236, 237, 255 );
	private $b = Array (225, 236, 166, 125 );
	private $audioPath; //语音文件存放目录'/'结尾
	private $audioFormat = 'mp3'; //音频格式
	private $interference = 0; //是否干扰, 1-是, 0-否
	public $session = 'verify';
	/**
	 * 生成图像验证码
	 * @param num $font_size 大小
	 * @param num $code_len 字符数
	 * @param num $width 长
	 * @param num $height 高
	 */
	public function doimage($font_size = '', $code_len = '', $width = '', $height = '') {
		$this->font_size = is_numeric ( $font_size ) ? $font_size : '12';
		$this->code_len = is_numeric ( $code_len ) ? $code_len : '5';
		$this->width = is_numeric ( $width ) ? $width : '100';
		$this->height = is_numeric ( $height ) ? $height : '30';
		if (empty ( $this->font ))
			$this->font = dirname ( __FILE__ ) . DS . 'font' . DS . 'elephant.ttf';
		$this->creat_code ();
		$this->img = imagecreatetruecolor ( $this->width, $this->height );
		$this->font_color = imagecolorallocate ( $this->img, rand ( 0, 156 ), rand ( 0, 156 ), rand ( 0, 156 ) );
		$key = mt_rand ( 0, 3 );
		//设置背景色
		$background = imagecolorallocate ( $this->img, $this->r [$key], $this->g [$key], $this->b [$key] );
		//画一个柜形，设置背景颜色。
		imagefilledrectangle ( $this->img, 0, $this->height, $this->width, 0, $background );
		$this->creat_font ();
		$this->creat_line ();
		$this->output ();
	}
	/**
	 * 生成随机验证码。
	 */
	private function creat_code($type = 5) {
		$this->code = $this->string->rand_string ( $this->code_len, $type );
		Session::set ( $this->session, md5 ( strtolower ( $this->code ) ) );
	}
	/**
	 * 检查验证码是否正确
	 * @param string $string
	 * @return bool
	 */
	public function check_code($string) {
		if (! empty ( $string ) && Session::is_set ( $this->session )) {
			if (md5 ( strtolower ( ( string ) $string ) ) == Session::get ( $this->session )) {
				Session::delete ( $this->session );
				return true;
			}
		}
		return false;
	}
	/**
	 * 生成文字
	 */
	private function creat_font() {
		$x = $this->width / $this->code_len;
		for($i = 0; $i < $this->code_len; $i ++) {
			imagettftext ( $this->img, $this->font_size, rand ( - 30, 30 ), $x * $i + rand ( 0, 5 ), $this->height / 1.4, $this->font_color, $this->font, $this->code [$i] );
			if ($i == 0)
				$this->x_start = $x * $i + 5;
		}
	}
	/**
	 * 画线
	 */
	private function creat_line() {
		imagesetthickness ( $this->img, 3 );
		$xpos = ($this->font_size * 2) + rand ( - 5, 5 );
		$width = $this->width / 2.66 + rand ( 3, 10 );
		$height = $this->font_size * 2.14;
		if (rand ( 0, 100 ) % 2 == 0) {
			$start = rand ( 0, 66 );
			$ypos = $this->height / 2 - rand ( 10, 30 );
			$xpos += rand ( 5, 15 );
		} else {
			$start = rand ( 180, 246 );
			$ypos = $this->height / 2 + rand ( 10, 30 );
		}
		$end = $start + rand ( 75, 110 );
		imagearc ( $this->img, $xpos, $ypos, $width, $height, $start, $end, $this->font_color );
		if (rand ( 1, 75 ) % 2 == 0) {
			$start = rand ( 45, 111 );
			$ypos = $this->height / 2 - rand ( 10, 30 );
			$xpos += rand ( 5, 15 );
		} else {
			$start = rand ( 200, 250 );
			$ypos = $this->height / 2 + rand ( 10, 30 );
		}
		$end = $start + rand ( 75, 100 );
		imagearc ( $this->img, $this->width * .75, $ypos, $width, $height, $start, $end, $this->font_color );
	}
	/**
	 * 输出图片
	 */
	private function output() {
		header ( "content-type:image/png" );
		imagepng ( $this->img );
		imagedestroy ( $this->img );
	}
	/**
	 * 设置音频格式
	 * @param $audioFormat	音频格式
	 * @return bool			true-成功, false-失败
	 */
	private function setAudioFormat($audioFormat = 'mp3', $type = 1) {
		$this->creat_code ( $type, 'verify_audio' );
		$this->audioPath = dirname ( __FILE__ ) . DS . 'audio' . DS;
		if (! in_array ( ( string ) $audioFormat, array ('wav', 'mp3' ) ))
			return false;
		$this->audioFormat = $audioFormat;
		return true;
	}
	
	/**
	 * 设置是否干扰
	 * @param $state		1-是, 0-否
	 * @return bool			true-成功
	 */
	private function setInterference($state = 0) {
		if ($state !== 1 && $state !== 0)
			return false;
		$this->interference = $state;
		return true;
	}
	
	/**
	 * 输出语音
	 * @param string $Format 生成格式
	 * @param string $type 类型
	 * @param 1|0 $state 是否干扰
	 * @param int $code_len 验证码长度
	 */
	public function outputAudio($Format = 'mp3', $type = 1, $state = 0, $code_len = 6) {
		$this->code_len = $code_len;
		$this->setAudioFormat ( $Format, $type );
		$this->setInterference ( $state );
		if ($this->audioFormat == 'wav') {
			$contentType = 'audio/x-wav';
			$type = 'wav';
		} elseif ($this->audioFormat == 'mp3') {
			$contentType = 'audio/mpeg';
			$type = 'mp3';
		}
		if (empty ( $contentType ))
			return false;
		header ( "Content-type: $contentType" );
		$audioContent = ($type == 'wav') ? $this->getWavAudio () : $this->getMp3Audio ();
		$this->interference == 1 && $audioContent = $this->addInterference ( $audioContent );
		header ( 'Content-Length: ' . strlen ( $audioContent ) );
		echo $audioContent;
		exit ();
	}
	
	/**
	 * 生成wav格式的语音验证码
	 * @return $outputData	语音数据
	 */
	private function getWavAudio() {
		if (empty ( $this->code ))
			return false;
		$audioData = array ();
		$totalDataLength = '';
		for($i = 0; $i < strlen ( $this->code ); $i ++) {
			$wavFile = $this->audioPath . strtoupper ( $this->code [$i] ) . '.wav';
			$wavData = $this->file->get ( $wavFile );
			$headerInfo = substr ( $wavData, 0, 36 );
			$data = unpack ( 'Nriffid/Vfilesize/Nfiletype/Nfmtid/Vfmtsize/vformattag/vchannels/Vsamplespersec/Vbytespersec/vblockalign/vbitspersample', $headerInfo );
			$data ['filesize'] = $data ['filesize'] + 8;
			$trunkLength = $data ['fmtsize'] == 18 ? 46 : 44;
			$data ['datainfo'] = substr ( $wavData, $trunkLength );
			if (($position = strpos ( $data ['datainfo'], 'LIST' )) !== false) {
				$data ['filesize'] = $data ['filesize'] - (strlen ( $data ['datainfo'] ) - $position);
				$data ['datainfo'] = substr ( $data ['datainfo'], 0, $position );
			}
			$totalDataLength += strlen ( $data ['datainfo'] );
			$audioData [] = $data;
		}
		$outputData = '';
		foreach ( $audioData as $key => $value ) {
			if ($key == 0) {
				$wavHeader = pack ( 'C4VC4', ord ( 'R' ), ord ( 'I' ), ord ( 'F' ), ord ( 'F' ), $totalDataLength + 36, ord ( 'W' ), ord ( 'A' ), ord ( 'V' ), ord ( 'E' ) );
				$wavHeader .= pack ( 'C4VvvVVvv', ord ( 'f' ), ord ( 'm' ), ord ( 't' ), ord ( ' ' ), 16, $value ['formattag'], $value ['channels'], $value ['samplespersec'], $value ['bytespersec'], $value ['blockalign'], $value ['bitspersample'] );
				$wavHeader .= pack ( 'C4V', ord ( 'd' ), ord ( 'a' ), ord ( 't' ), ord ( 'a' ), $totalDataLength );
				$outputData .= $wavHeader;
			}
			$outputData .= $value ['datainfo'];
		}
		return $outputData;
	}
	
	/**
	 * 生成mp3格式的语音验证码
	 * @return $outputData	语音数据
	 */
	private function getMp3Audio() {
		if (empty ( $this->code ))
			return false;
		$outputData = '';
		for($i = 0; $i < strlen ( $this->code ); $i ++) {
			$wavFile = $this->audioPath . strtoupper ( $this->code [$i] ) . '.mp3';
			$wavData = $this->file->get ( $wavFile );
			$outputData .= $wavData;
		}
		return $outputData;
	}
	
	/**
	 * 加干扰
	 * @param 	$audioData	音频数据
	 * @return 	$audioData	处理后的数据
	 */
	private function addInterference($audioData) {
		if ($this->audioFormat == 'wav') {
			$startpos = strpos ( $audioData, 'data' ) + 8;
			$startpos += rand ( 1, 32 );
		} elseif ($this->audioFormat == 'mp3') {
			$startpos = 4;
			if (stripos ( $audioData, 'ID3' ) !== false) {
				$startpos = 24;
				($pos = stripos ( $audioData, '3DI' )) !== false && $startpos = $pos + 14;
			}
		}
		$dataLength = strlen ( $audioData ) - $startpos - 128;
		for($i = $startpos; $i < $dataLength; $i += 256) {
			$ord = ord ( $audioData [$i] );
			if ($ord < 17 || $ord > 111)
				continue;
			$audioData [$i] = chr ( $ord + rand ( - 16, 16 ) );
		}
		return $audioData;
	}
}