<?php
defined ( 'PHPNOW_DIR' ) or exit ( '非法访问' );
/**
 * IP物理操作
 * PHPnow中文应用框架 PHPnow framework 1.0
 * @copyright	(C) 2010-2012 PHPnow
 * @license		http://www.phpnow.cn
 * @author		jiaodu QQ:1286522207
 */
class ipareaPlugins extends PHPnowClass {
	public $fp = NULL; //定义文件指针
	private function open() {
		if (file_exists ( dirname ( __FILE__ ) . DS . 'ipdata' . DS . 'ip.dat' )) {
			$this->fp = fopen ( dirname ( __FILE__ ) . DS . 'ipdata' . DS . 'ip.dat', 'rb' );
		}
	}
	/**
	 * 取得地区名
	 * @param  string $ip IP地址
	 * @ return string/null
	 */
	public function get($ip = '') {
		if (empty ( $ip )) {
			$ip = getClientIp ();
		}
		$return = '';
		if (isIp ( $ip )) {
			$iparray = explode ( '.', $ip );
			if ($iparray [0] == 10 || $iparray [0] == 127 || ($iparray [0] == 192 && $iparray [1] == 168) || ($iparray [0] == 172 && ($iparray [1] >= 16 && $iparray [1] <= 31))) {
				$return = 'LAN';
			} elseif ($iparray [0] > 255 || $iparray [1] > 255 || $iparray [2] > 255 || $iparray [3] > 255) {
				$return = '无效的IP地址';
			} else {
				$return = $this->data_full ( $ip );
				if (strpos ( $return, ' ' ) !== false)
					$return = substr ( $return, 0, strpos ( $return, ' ' ) );
			}
		} else {
			$return = '无效的IP地址';
		}
		return ! empty ( $return ) ? $this->PHPnowString->Charset ( $return ) : '';
	}
	/**
	 *获取城市名称
	 */
	public function getcity($ip = '') {
		if (empty ( $ip )) {
			$ip = getClientIp ();
		}
		$localinfo = '';
		$address = $this->get ( $ip );
		if (strpos ( $address, '省' ) !== false && strpos ( $address, '市' ) !== false) {
			$address = explode ( '省', $address );
			$address = $address [1];
		}
		$address = str_replace ( '市', '', $address );
		$localinfo ['city'] = trim ( $address );
		$name = $localinfo ['city'];
		$name = str_replace ( '市', '', $name );
		$letters = Pinyin( $name );
		$localinfo ['pinyin'] = strtolower ( implode ( '', $letters ) );
		return $localinfo;
	}
	/**
	 * 使用ip.Dat ip数据包获取地区
	 * @param  string $ip IP地址
	 */
	public function data_full($ip = '') {
		if (empty ( $ip )) {
			$ip = getClientIp ();
		}
		$this->open ();
		rewind ( $this->fp );
		$ip = explode ( '.', $ip );
		$ipNum = $ip [0] * 16777216 + $ip [1] * 65536 + $ip [2] * 256 + $ip [3];
		if (! ($DataBegin = fread ( $this->fp, 4 )) || ! ($DataEnd = fread ( $this->fp, 4 )))
			return;
		@$ipbegin = implode ( '', unpack ( 'L', $DataBegin ) );
		if ($ipbegin < 0)
			$ipbegin += pow ( 2, 32 );
		@$ipend = implode ( '', unpack ( 'L', $DataEnd ) );
		if ($ipend < 0)
			$ipend += pow ( 2, 32 );
		$ipAllNum = ($ipend - $ipbegin) / 7 + 1;
		$BeginNum = $ip2num = $ip1num = 0;
		$ipAddr1 = $ipAddr2 = '';
		$EndNum = $ipAllNum;
		while ( $ip1num > $ipNum || $ip2num < $ipNum ) {
			$Middle = intval ( ($EndNum + $BeginNum) / 2 );
			fseek ( $this->fp, $ipbegin + 7 * $Middle );
			$ipData1 = fread ( $this->fp, 4 );
			if (strlen ( $ipData1 ) < 4) {
				fclose ( $this->fp );
				return 'System Error';
			}
			$ip1num = implode ( '', unpack ( 'L', $ipData1 ) );
			if ($ip1num < 0)
				$ip1num += pow ( 2, 32 );
			if ($ip1num > $ipNum) {
				$EndNum = $Middle;
				continue;
			}
			$DataSeek = fread ( $this->fp, 3 );
			if (strlen ( $DataSeek ) < 3) {
				fclose ( $this->fp );
				return 'System Error';
			}
			$DataSeek = implode ( '', unpack ( 'L', $DataSeek . chr ( 0 ) ) );
			fseek ( $this->fp, $DataSeek );
			$ipData2 = fread ( $this->fp, 4 );
			if (strlen ( $ipData2 ) < 4) {
				fclose ( $this->fp );
				return 'System Error';
			}
			$ip2num = implode ( '', unpack ( 'L', $ipData2 ) );
			if ($ip2num < 0)
				$ip2num += pow ( 2, 32 );
			if ($ip2num < $ipNum) {
				if ($Middle == $BeginNum) {
					fclose ( $this->fp );
					return 'Unknown';
				}
				$BeginNum = $Middle;
			}
		}
		$ipFlag = fread ( $this->fp, 1 );
		if ($ipFlag == chr ( 1 )) {
			$ipSeek = fread ( $this->fp, 3 );
			if (strlen ( $ipSeek ) < 3) {
				fclose ( $this->fp );
				return 'System Error';
			}
			$ipSeek = implode ( '', unpack ( 'L', $ipSeek . chr ( 0 ) ) );
			fseek ( $this->fp, $ipSeek );
			$ipFlag = fread ( $this->fp, 1 );
		}
		if ($ipFlag == chr ( 2 )) {
			$AddrSeek = fread ( $this->fp, 3 );
			if (strlen ( $AddrSeek ) < 3) {
				fclose ( $this->fp );
				return 'System Error';
			}
			$ipFlag = fread ( $this->fp, 1 );
			if ($ipFlag == chr ( 2 )) {
				$AddrSeek2 = fread ( $this->fp, 3 );
				if (strlen ( $AddrSeek2 ) < 3) {
					fclose ( $this->fp );
					return 'System Error';
				}
				$AddrSeek2 = implode ( '', unpack ( 'L', $AddrSeek2 . chr ( 0 ) ) );
				fseek ( $this->fp, $AddrSeek2 );
			} else {
				fseek ( $this->fp, - 1, SEEK_CUR );
			}
			while ( ($char = fread ( $this->fp, 1 )) != chr ( 0 ) )
				$ipAddr2 .= $char;
			$AddrSeek = implode ( '', unpack ( 'L', $AddrSeek . chr ( 0 ) ) );
			fseek ( $this->fp, $AddrSeek );
			while ( ($char = fread ( $this->fp, 1 )) != chr ( 0 ) )
				$ipAddr1 .= $char;
		} else {
			fseek ( $this->fp, - 1, SEEK_CUR );
			while ( ($char = fread ( $this->fp, 1 )) != chr ( 0 ) )
				$ipAddr1 .= $char;
			$ipFlag = fread ( $this->fp, 1 );
			if ($ipFlag == chr ( 2 )) {
				$AddrSeek2 = fread ( $this->fp, 3 );
				if (strlen ( $AddrSeek2 ) < 3) {
					fclose ( $this->fp );
					return 'System Error';
				}
				$AddrSeek2 = implode ( '', unpack ( 'L', $AddrSeek2 . chr ( 0 ) ) );
				fseek ( $this->fp, $AddrSeek2 );
			} else {
				fseek ( $this->fp, - 1, SEEK_CUR );
			}
			while ( ($char = fread ( $this->fp, 1 )) != chr ( 0 ) )
				$ipAddr2 .= $char;
		}
		if (preg_match ( '/http/i', $ipAddr2 ))
			$ipAddr2 = '';
		$ipaddr = "$ipAddr1 $ipAddr2";
		$ipaddr = preg_replace ( '/CZ88\.NET/is', '', $ipaddr );
		$ipaddr = preg_replace ( '/^\s*/is', '', $ipaddr );
		$ipaddr = preg_replace ( '/\s*$/is', '', $ipaddr );
		if (preg_match ( '/http/i', $ipaddr ) || $ipaddr == '')
			$ipaddr = 'Unknown';
		
		$this->close ();
		return $ipaddr;
	}
	
	private function close() {
		@fclose ( $this->fp );
	}
}