<?php

namespace Addons\Wechat;
use Common\Controller\Addon;

/**
 * 微信插件
 * @author huay1
 */

    class WechatAddon extends Addon{

        public $info = array(
            'name'=>'Wechat',
            'title'=>'微信',
            'description'=>'微信插件',
            'status'=>1,
            'author'=>'huay1',
            'version'=>'0.2'
        );

        public $custom_config = 'Wechat_config.html';

        public $admin_list = array(
            'model'=>'Example',		//要查的表
			'fields'=>'*',			//要查的字段
			'map'=>'',				//查询条件, 如果需要可以再插件类的构造方法里动态重置这个属性
			'order'=>'id desc',		//排序,
			'listKey'=>array( 		//这里定义的是除了id序号外的表格里字段显示的表头名
				'字段名'=>'表头显示名'
			),
        );

        public $custom_adminlist = 'Wechat_list.html';
		//缓存变量 - 用于更新配置时清空微信缓存
		public $saveconfig_cache_list = array('WECHATADDONS_MENU','WECHATADDONS_TOKEN');

        public function install(){
			//创建接口文件
			$module = C("DEFAULT_MODULE");
			$file = APP_PATH.'/'.C("DEFAULT_MODULE").'/Controller/WechatController.class.php';
			$WechatController = <<<str
<?php
namespace $module\Controller;

class WechatController extends AddonsController {
	public function index(){
		\$this->setmemu();
		\$weixin = A("Addons://Wechat/Wechatclass");
		\$data = \$weixin->request();
		list(\$content, \$type) = \$this->reply(\$data);
		\$weixin->response(\$content, \$type);
	}
	private function reply(\$data){
		\$weixin = A("Addons://Wechat/Wechatclass");
		\$users = \$weixin->user(\$data['FromUserName']);
		// 消息类型
		switch (\$data ['MsgType']) {
			case 'text': // 类型是文本的
				switch (\$data ['Content']) {
					case '1' : //
						\$reply = array(\$users['nickname'].'你好!'.\$weixin->getconf('msgset/default/content'), \$weixin->getconf('msgset/default/msgtype'));
						break;
					default :						
						if (strpos ( \$data ['Content'], '刘华' ) !== false) {
							\$html = '刘华是个好人！';
							\$reply = array ( \$html, 'text' );
						} else {
							if(\$users['errcode']){
								\$reply = array(\$users['errmsg'], 'text');
							}else{
								\$reply = array(\$users['nickname'].'你好!'.\$data['Content'], 'text');
							}
						}
						break;
				}
				break;
			case 'event' : // 类型是事件的			              
				// 事件类型
				switch (\$data ['Event']) {					
					case 'subscribe': // 刚刚关注的
					\$reply = array(\$users['nickname'].'你好!'.\$weixin->getconf('msgset/subscribe/content'), $weixin->getconf('msgset/subscribe/msgtype'));
						break;
					case 'CLICK': // 点击的事件
						\$reply = array ( \$data ['EventKey'].\$data ['FromUserName'],	'text' );
						break;
					default :
						\$reply = array ( '没有相关事件',	'text' );	
						break;
				}
				break;
			default :
				\$reply = array(\$weixin->getconf('msgset/default/content'), \$weixin->getconf('msgset/default/msgtype'));
				break;
		}
		return \$reply;
	}
	/**
	 * 生成菜单
	 */	
	public function setmemu(){
		\$data = array();
		\$weixin = A("Addons://Wechat/Wechatclass");
		\$data = \$weixin->jsencode(\$weixin->getconf('menu'));
		/* 加载微信SDK */
		echo \$weixin->setMenu(\$data);		
		
	}
}
str;
            if(file_put_contents($file, $WechatController) < 1){
				session('addons_install_error',$file.'创建失败！');
				return false;
			}
			//添加钩子
			$Hooks = M("Hooks");
			$WechatHooksList = array(array(
				'name' => 'WechatAdminLogin',
				'description' => '后台登陆页面钩子，用于微信二维码登陆',
				'type' => 1,
				'update_time' => NOW_TIME,
				'addons' => 'Wechat'
			),array(
				'name' => 'WechatIndexLogin',
				'description' => '前台登陆页面钩子，用于微信二维码登陆',
				'type' => 1,
				'update_time' => NOW_TIME,
				'addons' => 'Wechat'
			));
			$Hooks->addAll($WechatHooksList,array(),true);
			if ( $Hooks->getDbError() ) {
				session('addons_install_error',$Hooks->getError());
				return false;
			}
			return true;          
        }

        public function uninstall(){
			//删除生成的文件
			$file = APP_PATH.'/'.C("DEFAULT_MODULE").'/Controller/WechatController.class.php';
			if (!unlink($file)){
				session('addons_install_error',$file.'删除失败，请手动删除！');
				return false;
			}
			$Hooks = M("Hooks");
			$map['name']  = array('in','WechatAdminLogin,WechatIndexLogin');
			$res = $Hooks->where($map)->delete();
			if($res == false){
				session('addons_install_error',$Hooks->getError());
				return false;
			}
			return true;
        }

        //实现的WechatAdminLogin钩子方法
        public function WechatAdminLogin($param){
			$this->assign('addons_Wechatconfig', $this->getConfig());
			$this->display(T('Addons://Wechat@Admin/login'));
        }
		//实现的WechatIndexLogin钩子方法
        public function WechatIndexLogin($param){
			echo 123;
        }

    }