<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: huajie <banhuajie@163.com>
// +----------------------------------------------------------------------
namespace Admin\Controller;

/**
 * 后台公共账号控制器
 * @author huajie <banhuajie@163.com>
 */
class SiteAccessController extends AdminController {


    /**
     * 解决方案权限列表页
     * @author 景博
     */
    public function index(){
        $list = $this->lists('Site_access');
        int_to_string($list);
        foreach ($list as $key=>$value){
            //odel_id                  =   get_document_field($value['model'],"name","id");
            //$list[$key]['model_id']    =   $model_id ? $model_id : 0;
        }
        $this->assign('list', $list);
        //print_r($list);
        $this->meta_title = '权限列表';
        $this->display();
    }

    /**
     * 文档新增页面初始化
     * @author huajie <banhuajie@163.com>
     */
    public function add(){
        $Site_access = D('Site_access');
        if(IS_POST){ //提交表单
            if(false !== $Site_access->update()){
                $this->success('新增成功！', U('index'));
            } else {
                $error = $Site_access->getError();
                $this->error(empty($error) ? '未知错误！' : $error);
            }
        } else {
            $this->meta_title = '新增权限';
            $this->display('edit');
        }
    }

    /* 编辑权限 */
    public function edit($id = null){
        $Site_access = D('Site_access');

        if(IS_POST){ //提交表单
            if(false !== $Site_access->update()){
                $this->success('编辑成功！', U('index'));
            } else {
                $error = $Site_access->getError();
                $this->error(empty($error) ? '未知错误！' : $error);
            }
        } else {
            $info = $id ? $Site_access->info($id) : '';            
            $this->assign('info',       $info);
            $this->meta_title = '编辑权限';
            $this->display();
        }
    }

    /**
     * 设置一条或者多条数据的状态
     * @author huajie <banhuajie@163.com>
     */
    public function setStatus($model='Document'){
        return parent::setStatus('Document');
    }

    

    /**
     * 删除一个解决方案
     * @author huajie <banhuajie@163.com>
     */
    public function remove(){
        $id = I('id');
        if(empty($id)){
            $this->error('参数错误!');
        }

        //删除
        $res = M('Site_access')->delete($id);
        if($res !== false){
            //记录行为
            action_log('update_site_access', 'site_access', $id, UID);
            $this->success('删除权限成功！');
        }else{
            $this->error('删除权限失败！');
        }
    }


    
}
