<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: huajie <banhuajie@163.com>
// +----------------------------------------------------------------------
namespace Admin\Controller;
use Admin\Model\SiteGroupModel;
use Think\Page;

/**
 * 后台公共账号控制器
 * @author huajie <banhuajie@163.com>
 */
class SiteController extends AdminController {

	/* 保存允许访问的公共方法 */
	static protected $allow = array( 'draftbox','mydocument');

    private $cate_id        =   null; //文档分类id

    /**
     * 检测需要动态判断的文档类目有关的权限
     *
     * @return boolean|null
     *      返回true则表示当前访问有权限
     *      返回false则表示当前访问无权限
     *      返回null，则会进入checkRule根据节点授权判断权限
     *
     */
   

    /**
     * 公共账号列表页
     * @author 景博
     */
    public function index(){
        /* 查询条件初始化 */
        $map = array();
        if(isset($wxname)){
            $map['wxname']   =   array('like', '%'.$wxname.'%');
        }
        if(isset($status)){
            $map['status']  =   $status;
        }
        if ( isset($_GET['time-start']) ) {
            $map['update_time'][] = array('egt',strtotime(I('time-start')));
        }
        if ( isset($_GET['time-end']) ) {
            $map['update_time'][] = array('elt',24*60*60 + strtotime(I('time-end')));
        }
        $list = $this->lists('Site',$map);
        int_to_string($list);
        foreach ($list as $key=>$value){
            //odel_id                  =   get_document_field($value['model'],"name","id");
            //$list[$key]['model_id']    =   $model_id ? $model_id : 0;
        }
        $this->assign('list', $list);
        $this->meta_title = '公共账号列表';
        $this->display();
    }

    

    /* 编辑分类 */
    public function edit($id = null){
        $Site = D('Site');

        if(IS_POST){ //提交表单
            if(false !== $Site->update()){
                $this->success('编辑成功！', U('index'));
            } else {
                $error = $Site->getError();
                $this->error(empty($error) ? '未知错误！' : $error);
            }
            
            // $data['wxname'] = I('post.wxname');
            // $data['wxid'] = I('post.wxid');
            // $data['weixin'] = I('post.weixin');
            // $data['access'] = implode(',',I('post.access'));;
            //  // 根据条件保存修改的数据
            // //if(false !== $Site_group->update()){
            // if(false !== $Site->where('id='.I('post.id'))->data($data)->save()){
            //     $this->success('编辑成功！', U('index'));
            // } else {
            //     $error = $Site->getError();
            //     $this->error(empty($error) ? '未知错误！' : $error);
            // }
        } else {           

            /* 获取账户信息 */
            $info = $id ? $Site->info($id) : '';
            $access = D('Site_access')->order('sort')->select();
            $this->assign('access',     $access);
            $this->assign('info',       $info);
            $this->meta_title = '编辑公共账号';
            $this->display();
        }
    }

    /* 更换方案 */
    public function changeGroup($id = null){
        $Site = D('Site');

        if(IS_POST){ //提交表单
            $data['groupid'] = I('post.newgroupid');
            $access = D('Site_group')->where('id='.$data['groupid'])->find();
            $data['access'] = $access['access'];
             // 根据条件保存修改的数据
            if(false !== $Site->where('id='.I('post.id'))->data($data)->save()){
                $this->success('更换成功！', U('index'));
            } else {
                $error = $Site->getError();
                $this->error(empty($error) ? '未知错误！' : $error);
            }
        } else {           

            /* 获取账户信息 */
            $info = $id ? $Site->info($id) : '';
            $newgroup = D('Site_group')->order('id')->select();
            $groupid = I('get.groupid');
            if(empty($groupid)){
                $groupid = 1;
            }
            $access = D('Site_group')->where('id='.$groupid)->find();    
            //print_r($access);        
            $this->assign('info',       $info);
            $this->assign('newgroup',       $newgroup);
            $this->assign('access',       $access);
            $this->meta_title = '更换方案';
            $this->display();
        }
    }


    /**
     * 设置一条或者多条数据的状态
     * @author huajie <banhuajie@163.com>
     */
    public function setStatus($model='Site'){
        return parent::setStatus('Site');
    }

    

    


    
}
