<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: huajie <banhuajie@163.com>
// +----------------------------------------------------------------------
namespace Admin\Controller;

/**
 * 后台公共账号控制器
 * @author huajie <banhuajie@163.com>
 */
class SiteGroupController extends AdminController {


    /**
     * 解决方案列表页
     * @author 景博
     */
    public function index(){
        $list = $this->lists('Site_group');
        int_to_string($list);
        foreach ($list as $key=>$value){
            //odel_id                  =   get_document_field($value['model'],"name","id");
            //$list[$key]['model_id']    =   $model_id ? $model_id : 0;
        }
        $this->assign('list', $list);
        $this->meta_title = '解决方案列表';
        $this->display();
    }

    /**
     * 文档新增页面初始化
     * @author huajie <banhuajie@163.com>
     */
    public function add(){
        $Site_group = D('Site_group');
        if(IS_POST){ //提交表单
            if(false !== $Site_group->update()){
                $this->success('新增成功！', U('index'));
            } else {
                $error = $Site_group->getError();
                $this->error(empty($error) ? '未知错误！' : $error);
            }
        } else {
            $this->meta_title = '新增解决方案';
            $this->display('edit');
        }
    }

    /* 编辑分类 */
    public function edit($id = null){
        $Site_group = D('Site_group');

        if(IS_POST){ //提交表单
            //print_r(I('post.access'));
            //exit;
            $data['name'] = I('post.name');
            $data['price'] = I('post.price');
            $data['create_card_num'] = I('post.create_card_num');
            $data['activitynum'] = I('post.activitynum');
            $data['iscopyright'] = I('post.iscopyright');
            $data['access'] = implode(',',I('post.access'));;
             // 根据条件保存修改的数据

            //if(false !== $Site_group->update()){
            if(false !== $Site_group->where('id='.I('post.id'))->data($data)->save()){
                //echo $Site_group->getLastSql();
                //exit;
                $this->success('编辑成功！', U('index'));
            } else {
                $error = $Site_group->getError();
                $this->error(empty($error) ? '未知错误！' : $error);
            }
        } else {
            /* 获取分类信息 */
            $info = $id ? $Site_group->info($id) : '';
            $access = D('Site_access')->order('sort')->select();
            $this->assign('access',     $access);
            $this->assign('info',       $info);
            $this->meta_title = '编辑解决方案';
            $this->display();
        }
    }

    /**
     * 设置一条或者多条数据的状态
     * @author huajie <banhuajie@163.com>
     */
    public function setStatus($model='Document'){
        return parent::setStatus('Document');
    }

    

    /**
     * 删除一个解决方案
     * @author huajie <banhuajie@163.com>
     */
    public function remove(){
        $id = I('id');
        if(empty($id)){
            $this->error('参数错误!');
        }

        //判断该方案下有没有账户，有则不允许删除
        $child = M('Site')->where(array('groupid'=>$id))->field('id')->select();
        if(!empty($child)){
            $this->error('请先删除该解决方案下的账户');
        }

        //删除该解决方案
        $res = M('Site_group')->delete($id);
        if($res !== false){
            //记录行为
            action_log('update_site_group', 'site_group', $id, UID);
            $this->success('删除解决方案成功！');
        }else{
            $this->error('删除解决方案失败！');
        }
    }


    
}
