<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Admin\Model;
use Think\Model;

/**
 * 分类模型
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
class SiteModel extends Model{

    protected $_validate = array(
        array('wxname', 'require', '账号名称不能为空', self::EXISTS_VALIDATE, 'regex', self::MODEL_BOTH),
        array('wxid', 'require', '原始ID不能为空', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
        array('wxid', '', '原始ID已经存在', self::VALUE_VALIDATE, 'unique', self::MODEL_BOTH),        
    	array('weixin', 'require', '微信号不能为空', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
    );

    protected $_auto = array(
        // array('model', 'arr2str', self::MODEL_BOTH, 'function'),
        // array('model', null, self::MODEL_BOTH, 'ignore'),
        // array('type', 'arr2str', self::MODEL_BOTH, 'function'),
        // array('type', null, self::MODEL_BOTH, 'ignore'),
        // array('reply_model', 'arr2str', self::MODEL_BOTH, 'function'),
        // array('reply_model', null, self::MODEL_BOTH, 'ignore'),
        // array('extend', 'json_encode', self::MODEL_BOTH, 'function'),
        // array('extend', null, self::MODEL_BOTH, 'ignore'),
        // array('create_time', NOW_TIME, self::MODEL_INSERT),
        // array('update_time', NOW_TIME, self::MODEL_BOTH),
        //array('status', '1', self::MODEL_BOTH),
        //array('status', 'getStatus', self::MODEL_BOTH, 'callback'),
    );


    /**
     * 获取公共账号详细信息
     * @param  milit   $id 分类ID或标识
     * @param  boolean $field 查询字段
     * @return array     分类信息
     * @author 麦当苗儿 <zuojiazi@vip.qq.com>
     */
    public function info($id, $field = true){
        /* 获取分类信息 */
        $map = array();
        if(is_numeric($id)){ //通过ID查询
            $map['id'] = $id;
        } else { //通过标识查询
            $map['wxname'] = $id;
        }
        return $this->field($field)->where($map)->find();
    }

    /**
     * 更新账号信息
     * @return boolean 更新状态
     * @author 麦当苗儿 <zuojiazi@vip.qq.com>
     */
    public function update(){
        $data = $this->create();
        if(!$data){ //数据对象创建错误
            return false;
        }

        /* 添加或更新数据 */
        if(empty($data['id'])){
            $res = $this->add();
        }else{
            $res = $this->save();
        }

        //记录行为
        action_log('update_site', 'site', $data['id'] ? $data['id'] : $res, UID);

        return $res;
    }
}
