/*
SQLyog Enterprise - MySQL GUI v8.12 
MySQL - 5.5.23 : Database - vpower
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

/*Table structure for table `v_access` */

DROP TABLE IF EXISTS `v_access`;

CREATE TABLE `v_access` (
  `role_id` smallint(6) unsigned NOT NULL,
  `node_id` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) NOT NULL,
  `pid` smallint(6) DEFAULT NULL,
  `module` varchar(50) DEFAULT NULL,
  KEY `groupId` (`role_id`),
  KEY `nodeId` (`node_id`)
) ENGINE=MyISAM COMMENT='权限分配表';

/*Data for the table `v_access` */

insert  into `v_access`(`role_id`,`node_id`,`level`,`pid`,`module`) values (2,8,3,14,''),(2,14,2,1,''),(2,10,3,4,''),(2,4,2,1,''),(2,7,3,3,''),(2,3,2,1,''),(2,6,3,2,''),(2,5,3,2,''),(2,2,2,1,''),(2,1,1,0,''),(3,14,2,1,''),(3,13,3,4,''),(3,12,3,4,''),(3,11,3,4,''),(3,10,3,4,''),(3,4,2,1,''),(3,9,3,3,''),(3,8,3,3,''),(3,7,3,3,''),(3,3,2,1,''),(3,6,3,2,''),(3,5,3,2,''),(3,2,2,1,''),(3,1,1,0,''),(4,7,3,3,''),(4,3,2,1,''),(4,6,3,2,''),(4,5,3,2,''),(4,2,2,1,''),(4,1,1,0,''),(2,9,3,14,''),(2,15,3,14,''),(2,16,3,14,''),(2,17,3,14,''),(2,18,3,14,''),(2,19,3,14,''),(2,20,3,14,''),(2,21,3,14,''),(2,22,3,14,''),(2,23,3,14,''),(2,24,3,14,''),(2,25,3,14,''),(2,26,2,1,''),(2,27,3,26,''),(2,28,3,26,''),(2,29,3,26,''),(2,30,3,26,''),(2,31,3,26,'');

/*Table structure for table `v_action` */

DROP TABLE IF EXISTS `v_action`;

CREATE TABLE `v_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '行为唯一标识',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '行为说明',
  `remark` char(140) NOT NULL DEFAULT '' COMMENT '行为描述',
  `rule` text NOT NULL COMMENT '行为规则',
  `log` text NOT NULL COMMENT '日志规则',
  `type` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 ROW_FORMAT=DYNAMIC COMMENT='系统行为表';

/*Data for the table `v_action` */

insert  into `v_action`(`id`,`name`,`title`,`remark`,`rule`,`log`,`type`,`status`,`update_time`) values (1,'user_login','用户登录','积分+10，每天一次','table:member|field:score|condition:uid={$self} AND status>-1|rule:score+10|cycle:24|max:1;','[user|get_nickname]在[time|time_format]登录了后台',1,1,1387181220),(2,'add_article','发布文章','积分+5，每天上限5次','table:member|field:score|condition:uid={$self}|rule:score+5|cycle:24|max:5','',2,0,1380173180),(3,'review','评论','评论积分+1，无限制','table:member|field:score|condition:uid={$self}|rule:score+1','',2,1,1383285646),(4,'add_document','发表文档','积分+10，每天上限5次','table:member|field:score|condition:uid={$self}|rule:score+10|cycle:24|max:5','[user|get_nickname]在[time|time_format]发表了一篇文章。\r\n表[model]，记录编号[record]。',2,0,1386139726),(5,'add_document_topic','发表讨论','积分+5，每天上限10次','table:member|field:score|condition:uid={$self}|rule:score+5|cycle:24|max:10','',2,0,1383285551),(6,'update_config','更新配置','新增或修改或删除配置','','',1,1,1383294988),(7,'update_model','更新模型','新增或修改模型','','',1,1,1383295057),(8,'update_attribute','更新属性','新增或更新或删除属性','','',1,1,1383295963),(9,'update_channel','更新导航','新增或修改或删除导航','','',1,1,1383296301),(10,'update_menu','更新菜单','新增或修改或删除菜单','','',1,1,1383296392),(11,'update_category','更新分类','新增或修改或删除分类','','',1,1,1383296765);

/*Table structure for table `v_action_log` */

DROP TABLE IF EXISTS `v_action_log`;

CREATE TABLE `v_action_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `action_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '行为id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '执行用户id',
  `action_ip` bigint(20) NOT NULL COMMENT '执行行为者ip',
  `model` varchar(50) NOT NULL DEFAULT '' COMMENT '触发行为的表',
  `record_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '触发行为的数据id',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '日志备注',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '执行行为的时间',
  PRIMARY KEY (`id`),
  KEY `action_ip_ix` (`action_ip`),
  KEY `action_id_ix` (`action_id`),
  KEY `user_id_ix` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=269 ROW_FORMAT=FIXED COMMENT='行为日志表';

/*Data for the table `v_action_log` */

insert  into `v_action_log`(`id`,`action_id`,`user_id`,`action_ip`,`model`,`record_id`,`remark`,`status`,`create_time`) values (1,1,1,2130706433,'member',1,'admin在2014-01-20 14:50登录了后台',1,1390200650),(2,1,1,2130706433,'member',1,'admin在2014-01-20 22:42登录了后台',1,1390228956),(3,1,1,2130706433,'member',1,'admin在2014-01-21 16:05登录了后台',1,1390291510),(4,1,1,2130706433,'member',1,'admin在2014-01-21 16:46登录了后台',1,1390293995),(5,1,1,2130706433,'member',1,'admin在2014-01-21 21:12登录了后台',1,1390309924),(6,1,1,2130706433,'member',1,'admin在2014-01-22 09:50登录了后台',1,1390355406),(7,1,1,2130706433,'member',1,'admin在2014-01-22 11:38登录了后台',1,1390361889),(8,1,2,2130706433,'member',2,'boy119在2014-01-22 14:30登录了后台',1,1390372238),(9,1,1,2130706433,'member',1,'admin在2014-01-22 14:32登录了后台',1,1390372364),(10,10,1,2130706433,'Menu',93,'操作url：/index.php/admin/menu/edit.html',1,1390372712),(11,10,1,2130706433,'Menu',122,'操作url：/index.php/admin/menu/add.html',1,1390372789),(12,10,1,2130706433,'Menu',122,'操作url：/index.php/admin/menu/edit.html',1,1390372832),(13,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/add.html',1,1390377734),(14,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/add.html',1,1390377854),(15,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390377896),(16,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390377913),(17,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390377947),(18,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390377962),(19,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390378123),(20,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390378184),(21,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390378192),(22,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390379065),(23,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390379073),(24,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390379276),(25,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390381867),(26,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390381876),(27,10,1,2130706433,'Menu',125,'操作url：/index.php/admin/menu/add.html',1,1390382596),(28,10,1,2130706433,'Menu',125,'操作url：/index.php/admin/menu/edit.html',1,1390382629),(29,10,1,2130706433,'Menu',125,'操作url：/index.php/admin/menu/edit.html',1,1390382662),(30,10,1,2130706433,'Menu',68,'操作url：/index.php/admin/menu/edit.html',1,1390382698),(31,10,1,2130706433,'Menu',122,'操作url：/index.php/admin/menu/edit.html',1,1390382728),(32,10,1,2130706433,'Menu',0,'操作url：/index.php/admin/menu/del/id/125.html',1,1390383403),(33,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390383422),(34,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390383435),(35,10,1,2130706433,'Menu',126,'操作url：/index.php/admin/menu/add.html',1,1390383554),(36,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390384388),(37,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390384409),(38,10,1,2130706433,'Menu',123,'操作url：/index.php/admin/menu/edit.html',1,1390385935),(39,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390387116),(40,1,1,2130706433,'member',1,'admin在2014-01-23 21:53登录了后台',1,1390485209),(41,10,1,2130706433,'Menu',126,'操作url：/index.php/admin/menu/edit.html',1,1390486962),(42,10,1,2130706433,'Menu',126,'操作url：/index.php/admin/menu/edit.html',1,1390487001),(43,10,1,2130706433,'Menu',124,'操作url：/index.php/admin/menu/edit.html',1,1390489504),(44,10,1,2130706433,'Menu',126,'操作url：/index.php/admin/menu/edit.html',1,1390489791),(45,1,1,2130706433,'member',1,'admin在2014-01-24 15:45登录了后台',1,1390549553),(46,10,1,2130706433,'Menu',127,'操作url：/index.php/admin/menu/add.html',1,1390550537),(47,1,1,2130706433,'member',1,'admin在2014-01-24 21:43登录了后台',1,1390570984),(48,1,1,2130706433,'member',1,'admin在2014-01-24 23:08登录了后台',1,1390576088),(49,1,1,2130706433,'member',1,'admin在2014-01-26 10:42登录了后台',1,1390704156),(50,1,1,2130706433,'member',1,'admin在2014-01-27 16:54登录了后台',1,1390812878),(51,1,1,2130706433,'member',1,'admin在2014-01-28 10:16登录了后台',1,1390875401),(52,1,1,2130706433,'member',1,'admin在2014-01-29 11:08登录了后台',1,1390964897),(53,1,1,2130706433,'member',1,'admin在2014-02-06 14:15登录了后台',1,1391667356),(54,1,1,2130706433,'member',1,'admin在2014-02-06 21:12登录了后台',1,1391692326),(55,1,1,2130706433,'member',1,'admin在2014-02-07 09:57登录了后台',1,1391738230),(56,1,1,2130706433,'member',1,'admin在2014-02-07 21:58登录了后台',1,1391781514),(57,1,1,2130706433,'member',1,'admin在2014-02-08 09:41登录了后台',1,1391823717),(58,1,1,2130706433,'member',1,'admin在2014-02-08 10:56登录了后台',1,1391828177),(59,1,1,2130706433,'member',1,'admin在2014-02-08 12:02登录了后台',1,1391832137),(60,1,1,2130706433,'member',1,'admin在2014-02-08 16:42登录了后台',1,1391848972),(61,1,1,2130706433,'member',1,'admin在2014-02-10 09:22登录了后台',1,1391995378),(62,1,1,2130706433,'member',1,'admin在2014-02-10 09:24登录了后台',1,1391995466),(63,1,1,2130706433,'member',1,'admin在2014-02-11 10:13登录了后台',1,1392084831),(64,1,1,2130706433,'member',1,'admin在2014-02-11 10:32登录了后台',1,1392085962),(65,1,1,2130706433,'member',1,'admin在2014-02-11 14:31登录了后台',1,1392100272),(66,1,1,2130706433,'member',1,'admin在2014-02-11 14:49登录了后台',1,1392101353),(67,1,1,2130706433,'member',1,'admin在2014-02-12 09:16登录了后台',1,1392167790),(68,1,1,2130706433,'member',1,'admin在2014-02-12 09:19登录了后台',1,1392167945),(69,1,1,2130706433,'member',1,'admin在2014-02-12 16:39登录了后台',1,1392194392),(70,1,1,2130706433,'member',1,'admin在2014-02-12 19:47登录了后台',1,1392205646),(71,1,1,2130706433,'member',1,'admin在2014-02-12 22:10登录了后台',1,1392214246),(72,1,1,2130706433,'member',1,'admin在2014-02-13 09:39登录了后台',1,1392255563),(73,1,1,2130706433,'member',1,'admin在2014-02-13 22:53登录了后台',1,1392303228),(74,1,1,2130706433,'member',1,'admin在2014-02-14 09:34登录了后台',1,1392341676),(75,1,1,2130706433,'member',1,'admin在2014-02-14 09:55登录了后台',1,1392342958),(76,1,1,2130706433,'member',1,'admin在2014-02-14 12:35登录了后台',1,1392352529),(77,1,1,2130706433,'member',1,'admin在2014-02-15 09:12登录了后台',1,1392426776),(78,1,1,2130706433,'member',1,'admin在2014-02-18 21:35登录了后台',1,1392730559),(79,1,1,2130706433,'member',1,'admin在2014-02-19 10:11登录了后台',1,1392775907),(80,1,1,2130706433,'member',1,'admin在2014-02-19 14:27登录了后台',1,1392791252),(81,1,1,2130706433,'member',1,'admin在2014-02-19 14:54登录了后台',1,1392792853),(82,1,1,2130706433,'member',1,'admin在2014-02-19 17:54登录了后台',1,1392803673),(83,1,1,2130706433,'member',1,'admin在2014-02-20 00:26登录了后台',1,1392827181),(84,1,1,2130706433,'member',1,'admin在2014-02-20 10:09登录了后台',1,1392862177),(85,1,1,2130706433,'member',1,'admin在2014-02-21 10:03登录了后台',1,1392948222),(86,1,1,2130706433,'member',1,'admin在2014-02-21 21:30登录了后台',1,1392989415),(87,1,1,2130706433,'member',1,'admin在2014-02-22 17:01登录了后台',1,1393059700),(88,1,1,2130706433,'member',1,'admin在2014-02-22 17:43登录了后台',1,1393062181),(89,1,1,2130706433,'member',1,'admin在2014-02-22 17:43登录了后台',1,1393062218),(90,1,1,2130706433,'member',1,'admin在2014-02-22 22:25登录了后台',1,1393079141),(91,10,1,2130706433,'Menu',128,'操作url：/index.php/admin/menu/add.shtml',1,1393082073),(92,1,1,2130706433,'member',1,'admin在2014-02-23 08:49登录了后台',1,1393116583),(93,1,1,2130706433,'member',1,'admin在2014-02-23 11:08登录了后台',1,1393124891),(94,1,1,2130706433,'member',1,'admin在2014-02-24 09:24登录了后台',1,1393205062),(95,10,1,2130706433,'Menu',129,'操作url：/index.php/admin/menu/add.shtml',1,1393210928),(96,1,1,2130706433,'member',1,'admin在2014-02-24 16:42登录了后台',1,1393231374),(97,1,1,2130706433,'member',1,'admin在2014-02-24 22:06登录了后台',1,1393250769),(98,1,1,2130706433,'member',1,'admin在2014-02-25 09:00登录了后台',1,1393290044),(99,1,1,2130706433,'member',1,'admin在2014-02-25 09:33登录了后台',1,1393292037),(100,11,1,2130706433,'category',2,'操作url：/index.php/admin/category/edit',1,1393292187),(101,10,1,2130706433,'Menu',130,'操作url：/index.php/admin/menu/add',1,1393293451),(102,11,1,2130706433,'category',1,'操作url：/index.php/admin/category/edit',1,1393294515),(103,11,1,2130706433,'category',1,'操作url：/index.php/admin/category/edit',1,1393295132),(104,10,1,2130706433,'Menu',131,'操作url：/index.php/admin/menu/add',1,1393296736),(105,10,1,2130706433,'Menu',132,'操作url：/index.php/admin/menu/add',1,1393296750),(106,11,1,2130706433,'category',2,'操作url：/index.php/admin/category/edit',1,1393298182),(107,11,1,2130706433,'category',1,'操作url：/index.php/admin/category/edit',1,1393298984),(108,11,1,2130706433,'category',1,'操作url：/index.php/admin/category/edit',1,1393299011),(109,11,1,2130706433,'category',1,'操作url：/index.php/admin/category/edit',1,1393299019),(110,1,1,2130706433,'member',1,'admin在2014-02-25 11:58登录了后台',1,1393300725),(111,1,1,-1062731412,'member',1,'admin在2014-02-25 15:15登录了后台',1,1393312511),(112,1,1,-1062731419,'member',1,'admin在2014-02-25 15:15登录了后台',1,1393312527),(113,1,1,-1062731412,'member',1,'admin在2014-02-25 17:01登录了后台',1,1393318901),(114,1,1,2130706433,'member',1,'admin在2014-02-25 20:17登录了后台',1,1393330673),(115,1,1,2130706433,'member',1,'admin在2014-02-25 20:19登录了后台',1,1393330767),(116,1,1,2056193238,'member',1,'admin在2014-02-25 23:27登录了后台',1,1393342031),(117,1,1,2056193238,'member',1,'admin在2014-02-25 23:27登录了后台',1,1393342069),(118,1,1,2095887336,'member',1,'admin在2014-02-26 09:03登录了后台',1,1393376615),(119,1,1,2056193236,'member',1,'admin在2014-02-26 09:12登录了后台',1,1393377166),(120,1,1,2095887336,'member',1,'admin在2014-02-26 10:12登录了后台',1,1393380775),(121,1,1,2095887336,'member',1,'admin在2014-02-26 10:41登录了后台',1,1393382482),(122,1,1,2056193236,'member',1,'admin在2014-02-26 10:56登录了后台',1,1393383360),(123,1,1,1785910260,'member',1,'admin在2014-02-26 12:20登录了后台',1,1393388405),(124,1,1,2095887336,'member',1,'admin在2014-02-26 15:06登录了后台',1,1393398372),(125,1,1,2095887336,'member',1,'admin在2014-02-26 15:07登录了后台',1,1393398430),(126,1,1,2056193235,'member',1,'admin在2014-02-26 20:18登录了后台',1,1393417127),(127,1,1,1786059348,'member',1,'admin在2014-02-27 09:31登录了后台',1,1393464671),(128,1,1,2031888650,'member',1,'admin在2014-02-27 13:41登录了后台',1,1393479685),(129,1,1,1786059348,'member',1,'admin在2014-02-27 13:55登录了后台',1,1393480549),(130,1,1,2031888650,'member',1,'admin在2014-02-27 14:02登录了后台',1,1393480926),(131,1,1,1786059348,'member',1,'admin在2014-02-27 14:44登录了后台',1,1393483456),(132,1,1,1786059348,'member',1,'admin在2014-02-27 14:59登录了后台',1,1393484357),(133,1,1,1786059348,'member',1,'admin在2014-02-27 14:59登录了后台',1,1393484369),(134,1,1,2031888650,'member',1,'admin在2014-02-27 15:02登录了后台',1,1393484562),(135,1,1,1786059348,'member',1,'admin在2014-02-27 15:10登录了后台',1,1393485034),(136,1,1,1786058945,'member',1,'admin在2014-02-28 09:26登录了后台',1,1393550786),(137,1,1,1786058945,'member',1,'admin在2014-02-28 09:26登录了后台',1,1393550786),(138,1,1,1786058945,'member',1,'admin在2014-02-28 13:39登录了后台',1,1393565997),(139,1,1,465073755,'member',1,'admin在2014-02-28 19:58登录了后台',1,1393588683),(140,1,1,1786060485,'member',1,'admin在2014-03-01 09:38登录了后台',1,1393637936),(141,1,1,2056193233,'member',1,'admin在2014-03-01 17:41登录了后台',1,1393666893),(142,1,1,2095886893,'member',1,'admin在2014-03-03 09:29登录了后台',1,1393810143),(143,1,1,-555761998,'member',1,'admin在2014-03-03 14:54登录了后台',1,1393829661),(144,1,1,-555761998,'member',1,'admin在2014-03-03 14:54登录了后台',1,1393829695),(145,1,1,-555761998,'member',1,'admin在2014-03-03 15:07登录了后台',1,1393830448),(146,6,1,-555761998,'config',40,'操作url：/index.php/admin/config/edit',1,1393830719),(147,6,1,-555761998,'config',41,'操作url：/index.php/admin/config/edit',1,1393830731),(148,1,1,2095885786,'member',1,'admin在2014-03-04 10:08登录了后台',1,1393898893),(149,1,2,2056193233,'member',2,'boy119在2014-03-04 11:09登录了后台',1,1393902599),(150,1,1,2056193233,'member',1,'admin在2014-03-04 11:10登录了后台',1,1393902645),(151,1,1,2095885786,'member',1,'admin在2014-03-04 14:47登录了后台',1,1393915662),(152,1,1,2095885786,'member',1,'admin在2014-03-04 15:22登录了后台',1,1393917727),(153,1,1,2095885786,'member',1,'admin在2014-03-04 18:41登录了后台',1,1393929708),(154,1,1,2095885786,'member',1,'admin在2014-03-04 19:07登录了后台',1,1393931244),(155,1,1,2095885874,'member',1,'admin在2014-03-05 09:16登录了后台',1,1393982166),(156,1,1,2095885874,'member',1,'admin在2014-03-05 09:41登录了后台',1,1393983677),(157,1,1,1785910260,'member',1,'admin在2014-03-05 13:29登录了后台',1,1393997352),(158,1,1,2095885874,'member',1,'admin在2014-03-05 13:48登录了后台',1,1393998524),(159,1,1,2056193233,'member',1,'admin在2014-03-05 19:23登录了后台',1,1394018633),(160,1,1,2095885965,'member',1,'admin在2014-03-06 09:25登录了后台',1,1394069107),(161,1,1,2031888650,'member',1,'admin在2014-03-06 09:44登录了后台',1,1394070250),(162,1,1,1786060725,'member',1,'admin在2014-03-07 08:59登录了后台',1,1394153958),(163,1,1,2031888650,'member',1,'admin在2014-03-07 09:27登录了后台',1,1394155667),(164,1,3,1786060725,'member',3,'aaa在2014-03-07 10:00登录了后台',1,1394157659),(165,1,3,1786060725,'member',3,'aaa在2014-03-07 11:33登录了后台',1,1394163221),(166,1,3,2031888650,'member',3,'aaa在2014-03-07 12:03登录了后台',1,1394165018),(167,1,3,2031888650,'member',3,'aaa在2014-03-07 12:04登录了后台',1,1394165067),(168,1,3,1786060725,'member',3,'aaa在2014-03-07 13:22登录了后台',1,1394169744),(169,1,3,1786060725,'member',3,'aaa在2014-03-07 13:22登录了后台',1,1394169778),(170,1,3,2031888650,'member',3,'aaa在2014-03-07 15:05登录了后台',1,1394175911),(171,1,1,2031888650,'member',1,'admin在2014-03-07 16:04登录了后台',1,1394179448),(172,10,1,2031888650,'Menu',133,'操作url：/index.php/admin/menu/add',1,1394184886),(173,10,1,2031888650,'Menu',134,'操作url：/index.php/admin/menu/add',1,1394184905),(174,10,1,2031888650,'Menu',134,'操作url：/index.php/admin/menu/edit',1,1394184926),(175,1,1,2095885338,'member',1,'admin在2014-03-08 09:17登录了后台',1,1394241421),(176,1,1,1786058989,'member',1,'admin在2014-03-10 13:51登录了后台',1,1394430714),(177,1,1,2031888650,'member',1,'admin在2014-03-10 18:56登录了后台',1,1394449002),(178,1,1,1786058847,'member',1,'admin在2014-03-11 09:53登录了后台',1,1394502812),(179,1,1,465120067,'member',1,'admin在2014-03-12 09:42登录了后台',1,1394588543),(180,1,1,2068387377,'member',1,'admin在2014-03-12 16:38登录了后台',1,1394613493),(181,1,1,2031888650,'member',1,'admin在2014-03-13 10:03登录了后台',1,1394676203),(182,1,1,2095886433,'member',1,'admin在2014-03-15 11:10登录了后台',1,1394853054),(183,1,1,1786059903,'member',1,'admin在2014-03-18 09:34登录了后台',1,1395106444),(184,1,1,2072688673,'member',1,'admin在2014-03-18 21:58登录了后台',1,1395151099),(185,1,1,2031888650,'member',1,'admin在2014-03-20 12:14登录了后台',1,1395288888),(186,1,1,2031888650,'member',1,'admin在2014-03-20 12:35登录了后台',1,1395290156),(187,1,1,2095886006,'member',1,'admin在2014-03-20 15:19登录了后台',1,1395299990),(188,1,1,1786060463,'member',1,'admin在2014-03-21 09:20登录了后台',1,1395364826),(189,1,4,1786060463,'member',4,'啊在2014-03-21 10:04登录了后台',1,1395367490),(190,1,1,1786060463,'member',1,'admin在2014-03-21 10:08登录了后台',1,1395367728),(191,1,1,1786060463,'member',1,'admin在2014-03-21 10:09登录了后台',1,1395367755),(192,1,1,1786060463,'member',1,'admin在2014-03-21 10:24登录了后台',1,1395368694),(193,1,1,1785797797,'member',1,'admin在2014-03-21 12:22登录了后台',1,1395375764),(194,1,1,1786060463,'member',1,'admin在2014-03-21 13:35登录了后台',1,1395380106),(195,1,1,1786060463,'member',1,'admin在2014-03-21 13:36登录了后台',1,1395380161),(196,1,1,1786060463,'member',1,'admin在2014-03-21 13:54登录了后台',1,1395381250),(197,1,1,2031888650,'member',1,'admin在2014-03-21 14:29登录了后台',1,1395383380),(198,1,1,2095885509,'member',1,'admin在2014-03-22 10:44登录了后台',1,1395456264),(199,1,1,2095885509,'member',1,'admin在2014-03-22 11:04登录了后台',1,1395457477),(200,1,1,2095885509,'member',1,'admin在2014-03-22 16:24登录了后台',1,1395476666),(201,1,1,2095885509,'member',1,'admin在2014-03-22 16:36登录了后台',1,1395477384),(202,1,1,2095885509,'member',1,'admin在2014-03-22 16:37登录了后台',1,1395477443),(203,1,1,2095885509,'member',1,'admin在2014-03-22 16:40登录了后台',1,1395477612),(204,1,1,2095885509,'member',1,'admin在2014-03-22 16:43登录了后台',1,1395477827),(205,1,1,2095885509,'member',1,'admin在2014-03-22 16:47登录了后台',1,1395478053),(206,1,1,2095885509,'member',1,'admin在2014-03-22 16:48登录了后台',1,1395478109),(207,1,1,2095885509,'member',1,'admin在2014-03-22 17:03登录了后台',1,1395478995),(208,1,1,2095885509,'member',1,'admin在2014-03-22 17:04登录了后台',1,1395479064),(209,1,1,2095885509,'member',1,'admin在2014-03-22 17:15登录了后台',1,1395479731),(210,1,1,2072688701,'member',1,'admin在2014-03-23 21:13登录了后台',1,1395580394),(211,1,1,2095886823,'member',1,'admin在2014-03-24 09:12登录了后台',1,1395623575),(212,1,1,2095886823,'member',1,'admin在2014-03-24 14:24登录了后台',1,1395642244),(213,1,1,2031888650,'member',1,'admin在2014-03-25 09:00登录了后台',1,1395709215),(214,1,1,2095886197,'member',1,'admin在2014-03-25 09:43登录了后台',1,1395711814),(215,1,1,2095886197,'member',1,'admin在2014-03-25 17:14登录了后台',1,1395738878),(216,1,5,1786060387,'member',5,'00在2014-03-26 08:56登录了后台',1,1395795389),(217,1,1,1786060387,'member',1,'admin在2014-03-26 08:56登录了后台',1,1395795410),(218,1,5,1786060387,'member',5,'00在2014-03-26 08:59登录了后台',1,1395795580),(219,1,1,-621795206,'member',1,'admin在2014-03-26 20:11登录了后台',1,1395835898),(220,1,1,1786059844,'member',1,'admin在2014-04-01 17:34登录了后台',1,1396344841),(221,1,1,1786059844,'member',1,'admin在2014-04-01 17:38登录了后台',1,1396345138),(222,1,1,1786059844,'member',1,'admin在2014-04-01 17:46登录了后台',1,1396345613),(223,1,1,2072688682,'member',1,'admin在2014-04-02 09:08登录了后台',1,1396400897),(224,1,1,2072688682,'member',1,'admin在2014-04-02 09:08登录了后台',1,1396400929),(225,1,1,2095885662,'member',1,'admin在2014-04-02 09:14登录了后台',1,1396401269),(226,1,1,2095885662,'member',1,'admin在2014-04-02 15:12登录了后台',1,1396422722),(227,1,1,2095885662,'member',1,'admin在2014-04-02 16:54登录了后台',1,1396428881),(228,1,1,1786060675,'member',1,'admin在2014-04-03 09:06登录了后台',1,1396487172),(229,1,6,2031888650,'member',6,'sjzsyjxh在2014-04-03 11:19登录了后台',1,1396495175),(230,1,1,2031888650,'member',1,'admin在2014-04-03 11:20登录了后台',1,1396495247),(231,10,1,-555761998,'Menu',122,'操作url：/index.php/admin/menu/edit',1,1396496123),(232,10,1,-555761998,'Menu',123,'操作url：/index.php/admin/menu/edit',1,1396496237),(233,10,1,-555761998,'Menu',124,'操作url：/index.php/admin/menu/edit',1,1396496247),(234,10,1,-555761998,'Menu',130,'操作url：/index.php/admin/menu/edit',1,1396496255),(235,1,7,2071165474,'member',7,'bjrzynz在2014-04-03 11:54登录了后台',1,1396497268),(236,1,1,1786060675,'member',1,'admin在2014-04-03 15:11登录了后台',1,1396509108),(237,1,1,2031888650,'member',1,'admin在2014-04-03 16:36登录了后台',1,1396514188),(238,1,1,1786060675,'member',1,'admin在2014-04-03 17:09登录了后台',1,1396516193),(239,1,1,2072688688,'member',1,'admin在2014-04-03 21:59登录了后台',1,1396533554),(240,1,1,465120357,'member',1,'admin在2014-04-04 09:55登录了后台',1,1396576532),(241,1,1,465120357,'member',1,'admin在2014-04-04 10:08登录了后台',1,1396577290),(242,1,1,2031888650,'member',1,'admin在2014-04-04 10:31登录了后台',1,1396578688),(243,6,1,2031888650,'config',42,'操作url：/index.php/admin/config/edit',1,1396578713),(244,1,5,465120357,'member',5,'00在2014-04-04 10:32登录了后台',1,1396578734),(245,1,1,465120357,'member',1,'admin在2014-04-04 13:31登录了后台',1,1396589473),(246,1,6,2031888650,'member',6,'sjzsyjxh在2014-04-04 15:30登录了后台',1,1396596656),(247,1,1,2072688699,'member',1,'admin在2014-04-07 15:57登录了后台',1,1396857474),(248,1,1,465119852,'member',1,'admin在2014-04-08 09:00登录了后台',1,1396918848),(249,1,1,2031888650,'member',1,'admin在2014-04-08 09:24登录了后台',1,1396920284),(250,11,1,2031888650,'category',2,'操作url：/index.php/admin/category/remove/id/2',1,1396920921),(251,11,1,2031888650,'category',1,'操作url：/index.php/admin/category/edit',1,1396920949),(252,11,1,2031888650,'category',39,'操作url：/index.php/admin/category/add',1,1396920974),(253,11,1,2031888650,'category',1,'操作url：/index.php/admin/category/edit',1,1396920994),(254,1,1,465119852,'member',1,'admin在2014-04-08 09:45登录了后台',1,1396921523),(255,1,1,2072688681,'member',1,'admin在2014-04-08 20:54登录了后台',1,1396961657),(256,1,1,1786059855,'member',1,'admin在2014-04-09 14:41登录了后台',1,1397025706),(257,11,1,1786059855,'category',40,'操作url：/index.php/admin/category/add',1,1397025879),(258,9,1,1786059855,'channel',2,'操作url：/index.php/admin/channel/edit',1,1397026054),(259,9,1,1786059855,'channel',3,'操作url：/index.php/admin/channel/edit',1,1397026075),(260,9,1,1786059855,'channel',4,'操作url：/index.php/admin/channel/edit',1,1397026115),(261,9,1,1786059855,'channel',5,'操作url：/index.php/admin/channel/edit',1,1397026121),(262,9,1,1786059855,'channel',6,'操作url：/index.php/admin/channel/edit',1,1397026147),(263,1,5,2095886267,'member',5,'00在2014-04-10 09:23登录了后台',1,1397093028),(264,1,5,2095886267,'member',5,'00在2014-04-10 09:28登录了后台',1,1397093315),(265,1,1,2095886267,'member',1,'admin在2014-04-10 09:45登录了后台',1,1397094305),(266,1,8,2031888650,'member',8,'zhangyu在2014-04-10 09:54登录了后台',1,1397094862),(267,1,1,2031888650,'member',1,'admin在2014-04-10 09:54登录了后台',1,1397094882),(268,1,1,2031888650,'member',1,'admin在2014-04-10 09:55登录了后台',1,1397094951);

/*Table structure for table `v_addons` */

DROP TABLE IF EXISTS `v_addons`;

CREATE TABLE `v_addons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL COMMENT '插件名或标识',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '中文名',
  `description` text COMMENT '插件描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `config` text COMMENT '配置',
  `author` varchar(40) DEFAULT '' COMMENT '作者',
  `version` varchar(20) DEFAULT '' COMMENT '版本号',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '安装时间',
  `has_adminlist` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有后台列表',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 COMMENT='插件表';

/*Data for the table `v_addons` */

insert  into `v_addons`(`id`,`name`,`title`,`description`,`status`,`config`,`author`,`version`,`create_time`,`has_adminlist`) values (15,'EditorForAdmin','后台编辑器','用于增强整站长文本的输入和显示',1,'{\"editor_type\":\"2\",\"editor_wysiwyg\":\"1\",\"editor_height\":\"500px\",\"editor_resize_type\":\"1\"}','thinkphp','0.1',1383126253,0),(2,'SiteStat','站点统计信息','统计站点的基础信息',1,'{\"title\":\"\\u7cfb\\u7edf\\u4fe1\\u606f\",\"width\":\"1\",\"display\":\"1\",\"status\":\"0\"}','thinkphp','0.1',1379512015,0),(3,'DevTeam','开发团队信息','开发团队成员信息',1,'{\"title\":\"OneThink\\u5f00\\u53d1\\u56e2\\u961f\",\"width\":\"2\",\"display\":\"1\"}','thinkphp','0.1',1379512022,0),(4,'SystemInfo','系统环境信息','用于显示一些服务器的信息',1,'{\"title\":\"\\u7cfb\\u7edf\\u4fe1\\u606f\",\"width\":\"2\",\"display\":\"1\"}','thinkphp','0.1',1379512036,0),(5,'Editor','前台编辑器','用于增强整站长文本的输入和显示',1,'{\"editor_type\":\"2\",\"editor_wysiwyg\":\"1\",\"editor_height\":\"300px\",\"editor_resize_type\":\"1\"}','thinkphp','0.1',1379830910,0),(6,'Attachment','附件','用于文档模型上传附件',1,'null','thinkphp','0.1',1379842319,1),(9,'SocialComment','通用社交化评论','集成了各种社交化评论插件，轻松集成到系统中。',1,'{\"comment_type\":\"1\",\"comment_uid_youyan\":\"\",\"comment_short_name_duoshuo\":\"\",\"comment_data_list_duoshuo\":\"\"}','thinkphp','0.1',1380273962,0);

/*Table structure for table `v_album` */

DROP TABLE IF EXISTS `v_album`;

CREATE TABLE `v_album` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `title` varchar(20) NOT NULL,
  `picurl` varchar(100) NOT NULL,
  `isshoinfo` tinyint(1) NOT NULL,
  `num` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `create_time` int(11) NOT NULL,
  `info` varchar(150) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `v_album` */

/*Table structure for table `v_album_list` */

DROP TABLE IF EXISTS `v_album_list`;

CREATE TABLE `v_album_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `pid` int(11) NOT NULL,
  `title` varchar(20) NOT NULL,
  `sort` tinyint(3) NOT NULL,
  `picurl` varchar(100) NOT NULL,
  `create_time` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `info` varchar(120) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `v_album_list` */


/*Table structure for table `v_alipay_config` */

DROP TABLE IF EXISTS `v_alipay_config`;

CREATE TABLE `v_alipay_config` (
  `token` varchar(60) NOT NULL,
  `name` varchar(40) NOT NULL DEFAULT '',
  `pid` varchar(40) NOT NULL DEFAULT '',
  `key` varchar(60) NOT NULL DEFAULT '',
  `open` tinyint(1) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '0',
  KEY `token` (`token`)
) ENGINE=MyISAM COMMENT='支付宝支付接口配置';

/*Data for the table `v_alipay_config` */

/*Table structure for table `v_appointment` */

DROP TABLE IF EXISTS `v_appointment`;

CREATE TABLE `v_appointment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` varchar(100) NOT NULL,
  `title` varchar(200) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `longitude` varchar(100) DEFAULT NULL,
  `latitude` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `topic` varchar(200) DEFAULT NULL,
  `info` varchar(500) DEFAULT NULL,
  `statdate` date DEFAULT NULL,
  `enddate` date DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `copyright` varchar(30) DEFAULT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=154 DEFAULT CHARSET=utf8;

/*Data for the table `v_appointment` */


/*Table structure for table `v_appointment_order` */

DROP TABLE IF EXISTS `v_appointment_order`;

CREATE TABLE `v_appointment_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `name` varchar(20) DEFAULT NULL,
  `phone` varchar(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `memo` varchar(200) DEFAULT NULL,
  `type` smallint(4) NOT NULL DEFAULT '0',
  `wecha_id` varchar(200) NOT NULL,
  `or_date` date DEFAULT NULL,
  `time` varchar(50) DEFAULT NULL,
  `nums` varchar(20) DEFAULT NULL,
  `fieldsigle` varchar(100) DEFAULT NULL,
  `fielddownload` varchar(100) DEFAULT NULL,
  `price` varchar(10) DEFAULT NULL,
  `kind` varchar(20) DEFAULT NULL,
  `siteid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;

/*Data for the table `v_appointment_order` */


/*Table structure for table `v_appointment_setcin` */

DROP TABLE IF EXISTS `v_appointment_setcin`;

CREATE TABLE `v_appointment_setcin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `yuanjia` varchar(10) DEFAULT NULL,
  `youhui` varchar(10) DEFAULT NULL,
  `memo` varchar(100) DEFAULT NULL,
  `messages` text,
  `type` varchar(20) DEFAULT NULL,
  `pic1` varchar(100) DEFAULT NULL,
  `pic2` varchar(100) DEFAULT NULL,
  `pic3` varchar(100) DEFAULT NULL,
  `pic4` varchar(100) DEFAULT NULL,
  `pic5` varchar(100) DEFAULT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;

/*Data for the table `v_appointment_setcin` */


/*Table structure for table `v_areply` */

DROP TABLE IF EXISTS `v_areply`;

CREATE TABLE `v_areply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `uid` int(11) NOT NULL,
  `uname` varchar(90) NOT NULL,
  `createtime` varchar(13) NOT NULL,
  `updatetime` varchar(13) NOT NULL,
  `token` char(30) NOT NULL,
  `home` varchar(1) NOT NULL DEFAULT '0',
  `is_home` tinyint(1) NOT NULL DEFAULT '1',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `v_areply` */


/*Table structure for table `v_attachment` */

DROP TABLE IF EXISTS `v_attachment`;

CREATE TABLE `v_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` char(30) NOT NULL DEFAULT '' COMMENT '附件显示名',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '附件类型',
  `source` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '资源ID',
  `record_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '关联记录ID',
  `download` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下载次数',
  `size` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '附件大小',
  `dir` int(12) unsigned NOT NULL DEFAULT '0' COMMENT '上级目录ID',
  `sort` int(8) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`),
  KEY `idx_record_status` (`record_id`,`status`)
) ENGINE=MyISAM COMMENT='附件表';

/*Data for the table `v_attachment` */

/*Table structure for table `v_attribute` */

DROP TABLE IF EXISTS `v_attribute`;

CREATE TABLE `v_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '字段名',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '字段注释',
  `field` varchar(100) NOT NULL DEFAULT '' COMMENT '字段定义',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '数据类型',
  `value` varchar(100) NOT NULL DEFAULT '' COMMENT '字段默认值',
  `remark` varchar(100) NOT NULL DEFAULT '' COMMENT '备注',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `extra` varchar(255) NOT NULL DEFAULT '' COMMENT '参数',
  `model_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '模型id',
  `is_must` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `validate_rule` varchar(255) NOT NULL,
  `validate_time` tinyint(1) unsigned NOT NULL,
  `error_info` varchar(100) NOT NULL,
  `validate_type` varchar(25) NOT NULL,
  `auto_rule` varchar(100) NOT NULL,
  `auto_time` tinyint(1) unsigned NOT NULL,
  `auto_type` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 COMMENT='模型属性表';

/*Data for the table `v_attribute` */

insert  into `v_attribute`(`id`,`name`,`title`,`field`,`type`,`value`,`remark`,`is_show`,`extra`,`model_id`,`is_must`,`status`,`update_time`,`create_time`,`validate_rule`,`validate_time`,`error_info`,`validate_type`,`auto_rule`,`auto_time`,`auto_type`) values (1,'uid','用户ID','int(10) unsigned NOT NULL ','num','0','',0,'',1,0,1,1384508362,1383891233,'',0,'','','',0,''),(2,'name','标识','char(40) NOT NULL ','string','','同一根节点下标识不重复',1,'',1,0,1,1383894743,1383891233,'',0,'','','',0,''),(3,'title','标题','char(80) NOT NULL ','string','','文档标题',1,'',1,0,1,1383894778,1383891233,'',0,'','','',0,''),(4,'category_id','所属分类','int(10) unsigned NOT NULL ','string','','',0,'',1,0,1,1384508336,1383891233,'',0,'','','',0,''),(5,'description','描述','char(140) NOT NULL ','textarea','','',1,'',1,0,1,1383894927,1383891233,'',0,'','','',0,''),(6,'root','根节点','int(10) unsigned NOT NULL ','num','0','该文档的顶级文档编号',0,'',1,0,1,1384508323,1383891233,'',0,'','','',0,''),(7,'pid','所属ID','int(10) unsigned NOT NULL ','num','0','父文档编号',0,'',1,0,1,1384508543,1383891233,'',0,'','','',0,''),(8,'model_id','内容模型ID','tinyint(3) unsigned NOT NULL ','num','0','该文档所对应的模型',0,'',1,0,1,1384508350,1383891233,'',0,'','','',0,''),(9,'type','内容类型','tinyint(3) unsigned NOT NULL ','select','2','',1,'1:目录\r\n2:主题\r\n3:段落',1,0,1,1384511157,1383891233,'',0,'','','',0,''),(10,'position','推荐位','smallint(5) unsigned NOT NULL ','checkbox','0','多个推荐则将其推荐值相加',1,'1:列表推荐\r\n2:频道页推荐\r\n4:首页推荐',1,0,1,1383895640,1383891233,'',0,'','','',0,''),(11,'link_id','外链','int(10) unsigned NOT NULL ','num','0','0-非外链，大于0-外链ID,需要函数进行链接与编号的转换',1,'',1,0,1,1383895757,1383891233,'',0,'','','',0,''),(12,'cover_id','封面','int(10) unsigned NOT NULL ','picture','0','0-无封面，大于0-封面图片ID，需要函数处理',1,'',1,0,1,1384147827,1383891233,'',0,'','','',0,''),(13,'display','可见性','tinyint(3) unsigned NOT NULL ','radio','1','',1,'0:不可见\r\n1:所有人可见',1,0,1,1386662271,1383891233,'',0,'','regex','',0,'function'),(14,'deadline','截至时间','int(10) unsigned NOT NULL ','datetime','0','0-永久有效',1,'',1,0,1,1387163248,1383891233,'',0,'','regex','',0,'function'),(15,'attach','附件数量','tinyint(3) unsigned NOT NULL ','num','0','',0,'',1,0,1,1387260355,1383891233,'',0,'','regex','',0,'function'),(16,'view','浏览量','int(10) unsigned NOT NULL ','num','0','',1,'',1,0,1,1383895835,1383891233,'',0,'','','',0,''),(17,'comment','评论数','int(10) unsigned NOT NULL ','num','0','',1,'',1,0,1,1383895846,1383891233,'',0,'','','',0,''),(18,'extend','扩展统计字段','int(10) unsigned NOT NULL ','num','0','根据需求自行使用',0,'',1,0,1,1384508264,1383891233,'',0,'','','',0,''),(19,'level','优先级','int(10) unsigned NOT NULL ','num','0','越高排序越靠前',1,'',1,0,1,1383895894,1383891233,'',0,'','','',0,''),(20,'create_time','创建时间','int(10) unsigned NOT NULL ','datetime','0','',1,'',1,0,1,1383895903,1383891233,'',0,'','','',0,''),(21,'update_time','更新时间','int(10) unsigned NOT NULL ','datetime','0','',0,'',1,0,1,1384508277,1383891233,'',0,'','','',0,''),(22,'status','数据状态','tinyint(4) NOT NULL ','radio','0','',0,'-1:删除\r\n0:禁用\r\n1:正常\r\n2:待审核\r\n3:草稿',1,0,1,1384508496,1383891233,'',0,'','','',0,''),(23,'parse','内容解析类型','tinyint(3) unsigned NOT NULL ','select','0','',0,'0:html\r\n1:ubb\r\n2:markdown',2,0,1,1384511049,1383891243,'',0,'','','',0,''),(24,'content','文章内容','text NOT NULL ','editor','','',1,'',2,0,1,1383896225,1383891243,'',0,'','','',0,''),(25,'template','详情页显示模板','varchar(100) NOT NULL ','string','','参照display方法参数的定义',1,'',2,0,1,1383896190,1383891243,'',0,'','','',0,''),(26,'bookmark','收藏数','int(10) unsigned NOT NULL ','num','0','',1,'',2,0,1,1383896103,1383891243,'',0,'','','',0,''),(27,'parse','内容解析类型','tinyint(3) unsigned NOT NULL ','select','0','',0,'0:html\r\n1:ubb\r\n2:markdown',3,0,1,1387260461,1383891252,'',0,'','regex','',0,'function'),(28,'content','下载详细描述','text NOT NULL ','editor','','',1,'',3,0,1,1383896438,1383891252,'',0,'','','',0,''),(29,'template','详情页显示模板','varchar(100) NOT NULL ','string','','',1,'',3,0,1,1383896429,1383891252,'',0,'','','',0,''),(30,'file_id','文件ID','int(10) unsigned NOT NULL ','file','0','需要函数处理',1,'',3,0,1,1383896415,1383891252,'',0,'','','',0,''),(31,'download','下载次数','int(10) unsigned NOT NULL ','num','0','',1,'',3,0,1,1383896380,1383891252,'',0,'','','',0,''),(32,'size','文件大小','bigint(20) unsigned NOT NULL ','num','0','单位bit',1,'',3,0,1,1383896371,1383891252,'',0,'','','',0,'');

/*Table structure for table `v_auth_extend` */

DROP TABLE IF EXISTS `v_auth_extend`;

CREATE TABLE `v_auth_extend` (
  `group_id` mediumint(10) unsigned NOT NULL COMMENT '用户id',
  `extend_id` mediumint(8) unsigned NOT NULL COMMENT '扩展表中数据的id',
  `type` tinyint(1) unsigned NOT NULL COMMENT '扩展类型标识 1:栏目分类权限;2:模型权限',
  UNIQUE KEY `group_extend_type` (`group_id`,`extend_id`,`type`),
  KEY `uid` (`group_id`),
  KEY `group_id` (`extend_id`)
) ENGINE=MyISAM COMMENT='用户组与分类的对应关系表';

/*Data for the table `v_auth_extend` 后加的*/
INSERT INTO `v_auth_extend` VALUES ('1', '1', '1');
INSERT INTO `v_auth_extend` VALUES ('1', '1', '2');
INSERT INTO `v_auth_extend` VALUES ('1', '2', '1');
INSERT INTO `v_auth_extend` VALUES ('1', '2', '2');
INSERT INTO `v_auth_extend` VALUES ('1', '3', '1');
INSERT INTO `v_auth_extend` VALUES ('1', '3', '2');
INSERT INTO `v_auth_extend` VALUES ('1', '4', '1');
INSERT INTO `v_auth_extend` VALUES ('1', '37', '1');


/*Table structure for table `v_auth_group` */

DROP TABLE IF EXISTS `v_auth_group`;

CREATE TABLE `v_auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `module` varchar(20) NOT NULL COMMENT '用户组所属模块',
  `type` tinyint(4) NOT NULL COMMENT '组类型',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '用户组中文名称',
  `description` varchar(80) NOT NULL DEFAULT '' COMMENT '描述信息',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '用户组状态：为1正常，为0禁用,-1为删除',
  `rules` varchar(500) NOT NULL DEFAULT '' COMMENT '用户组拥有的规则id，多个规则 , 隔开',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `v_auth_group` */
insert  into `v_auth_group`(`id`,`module`,`type`,`title`,`description`,`status`,`rules`) values (1,'admin',1,'默认用户组','',1,'1,2,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,79,80,81,82,83,84,86,87,88,89,90,91,92,93,94,95,100,102,103,217,218,219'),(2,'admin',1,'测试用户','测试用户',1,'1,2,5,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,79,80,82,83,84,88,89,90,91,92,93,100,102,103,195,217,218,219');

/*Table structure for table `v_auth_group_access` */

DROP TABLE IF EXISTS `v_auth_group_access`;

CREATE TABLE `v_auth_group_access` (
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `group_id` mediumint(8) unsigned NOT NULL COMMENT '用户组id',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `v_auth_group_access` */

/*Table structure for table `v_auth_rule` */

DROP TABLE IF EXISTS `v_auth_rule`;

CREATE TABLE `v_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id,自增主键',
  `module` varchar(20) NOT NULL COMMENT '规则所属module',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1-url;2-主菜单',
  `name` char(80) NOT NULL DEFAULT '' COMMENT '规则唯一英文标识',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '规则中文描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否有效(0:无效,1:有效)',
  `condition` varchar(300) NOT NULL DEFAULT '' COMMENT '规则附加条件',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`module`,`name`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=222 DEFAULT CHARSET=utf8;

/*Data for the table `v_auth_rule` */
insert  into `v_auth_rule`(`id`,`module`,`type`,`name`,`title`,`status`,`condition`) values (1,'admin',2,'Admin/Index/index','首页',1,''),(2,'admin',2,'Admin/Article/mydocument','内容',1,''),(3,'admin',2,'Admin/User/index','用户',1,''),(4,'admin',2,'Admin/Addons/index','扩展',1,''),(5,'admin',2,'Admin/Config/group','系统',1,''),(6,'admin',1,'Admin/Index/index','首页',-1,''),(7,'admin',1,'Admin/article/add','新增',1,''),(8,'admin',1,'Admin/article/edit','编辑',1,''),(9,'admin',1,'Admin/article/setStatus','改变状态',1,''),(10,'admin',1,'Admin/article/update','保存',1,''),(11,'admin',1,'Admin/article/autoSave','保存草稿',1,''),(12,'admin',1,'Admin/article/move','移动',1,''),(13,'admin',1,'Admin/article/copy','复制',1,''),(14,'admin',1,'Admin/article/paste','粘贴',1,''),(15,'admin',1,'Admin/article/permit','还原',1,''),(16,'admin',1,'Admin/article/clear','清空',1,''),(17,'admin',1,'Admin/article/index','文档列表',1,''),(18,'admin',1,'Admin/article/recycle','回收站',1,''),(19,'admin',1,'Admin/User/addaction','新增用户行为',1,''),(20,'admin',1,'Admin/User/editaction','编辑用户行为',1,''),(21,'admin',1,'Admin/User/saveAction','保存用户行为',1,''),(22,'admin',1,'Admin/User/setStatus','变更行为状态',1,''),(23,'admin',1,'Admin/User/changeStatus?method=forbidUser','禁用会员',1,''),(24,'admin',1,'Admin/User/changeStatus?method=resumeUser','启用会员',1,''),(25,'admin',1,'Admin/User/changeStatus?method=deleteUser','删除会员',1,''),(26,'admin',1,'Admin/User/index','用户信息',1,''),(27,'admin',1,'Admin/User/action','用户行为',1,''),(28,'admin',1,'Admin/AuthManager/changeStatus?method=deleteGroup','删除',1,''),(29,'admin',1,'Admin/AuthManager/changeStatus?method=forbidGroup','禁用',1,''),(30,'admin',1,'Admin/AuthManager/changeStatus?method=resumeGroup','恢复',1,''),(31,'admin',1,'Admin/AuthManager/createGroup','新增',1,''),(32,'admin',1,'Admin/AuthManager/editGroup','编辑',1,''),(33,'admin',1,'Admin/AuthManager/writeGroup','保存用户组',1,''),(34,'admin',1,'Admin/AuthManager/group','授权',1,''),(35,'admin',1,'Admin/AuthManager/access','访问授权',1,''),(36,'admin',1,'Admin/AuthManager/user','成员授权',1,''),(37,'admin',1,'Admin/AuthManager/removeFromGroup','解除授权',1,''),(38,'admin',1,'Admin/AuthManager/addToGroup','保存成员授权',1,''),(39,'admin',1,'Admin/AuthManager/category','分类授权',1,''),(40,'admin',1,'Admin/AuthManager/addToCategory','保存分类授权',1,''),(41,'admin',1,'Admin/AuthManager/index','权限管理',1,''),(42,'admin',1,'Admin/Addons/create','创建',1,''),(43,'admin',1,'Admin/Addons/checkForm','检测创建',1,''),(44,'admin',1,'Admin/Addons/preview','预览',1,''),(45,'admin',1,'Admin/Addons/build','快速生成插件',1,''),(46,'admin',1,'Admin/Addons/config','设置',1,''),(47,'admin',1,'Admin/Addons/disable','禁用',1,''),(48,'admin',1,'Admin/Addons/enable','启用',1,''),(49,'admin',1,'Admin/Addons/install','安装',1,''),(50,'admin',1,'Admin/Addons/uninstall','卸载',1,''),(51,'admin',1,'Admin/Addons/saveconfig','更新配置',1,''),(52,'admin',1,'Admin/Addons/adminList','插件后台列表',1,''),(53,'admin',1,'Admin/Addons/execute','URL方式访问插件',1,''),(54,'admin',1,'Admin/Addons/index','插件管理',1,''),(55,'admin',1,'Admin/Addons/hooks','钩子管理',1,''),(56,'admin',1,'Admin/model/add','新增',1,''),(57,'admin',1,'Admin/model/edit','编辑',1,''),(58,'admin',1,'Admin/model/setStatus','改变状态',1,''),(59,'admin',1,'Admin/model/update','保存数据',1,''),(60,'admin',1,'Admin/Model/index','模型管理',1,''),(61,'admin',1,'Admin/Config/edit','编辑',1,''),(62,'admin',1,'Admin/Config/del','删除',1,''),(63,'admin',1,'Admin/Config/add','新增',1,''),(64,'admin',1,'Admin/Config/save','保存',1,''),(65,'admin',1,'Admin/Config/group','网站设置',1,''),(66,'admin',1,'Admin/Config/index','配置管理',1,''),(67,'admin',1,'Admin/Channel/add','新增',1,''),(68,'admin',1,'Admin/Channel/edit','编辑',1,''),(69,'admin',1,'Admin/Channel/del','删除',1,''),(70,'admin',1,'Admin/Channel/index','导航管理',1,''),(71,'admin',1,'Admin/Category/edit','编辑',1,''),(72,'admin',1,'Admin/Category/add','新增',1,''),(73,'admin',1,'Admin/Category/remove','删除',1,''),(74,'admin',1,'Admin/Category/index','分类管理',1,''),(75,'admin',1,'Admin/file/upload','上传控件',-1,''),(76,'admin',1,'Admin/file/uploadPicture','上传图片',-1,''),(77,'admin',1,'Admin/file/download','下载',-1,''),(94,'admin',1,'Admin/AuthManager/modelauth','模型授权',1,''),(79,'admin',1,'Admin/article/batchOperate','导入',1,''),(80,'admin',1,'Admin/Database/index?type=export','备份数据库',1,''),(81,'admin',1,'Admin/Database/index?type=import','还原数据库',1,''),(82,'admin',1,'Admin/Database/export','备份',1,''),(83,'admin',1,'Admin/Database/optimize','优化表',1,''),(84,'admin',1,'Admin/Database/repair','修复表',1,''),(86,'admin',1,'Admin/Database/import','恢复',1,''),(87,'admin',1,'Admin/Database/del','删除',1,''),(88,'admin',1,'Admin/User/add','新增用户',1,''),(89,'admin',1,'Admin/Attribute/index','属性管理',1,''),(90,'admin',1,'Admin/Attribute/add','新增',1,''),(91,'admin',1,'Admin/Attribute/edit','编辑',1,''),(92,'admin',1,'Admin/Attribute/setStatus','改变状态',1,''),(93,'admin',1,'Admin/Attribute/update','保存数据',1,''),(95,'admin',1,'Admin/AuthManager/addToModel','保存模型授权',1,''),(96,'admin',1,'Admin/Category/move','移动',-1,''),(97,'admin',1,'Admin/Category/merge','合并',-1,''),(98,'admin',1,'Admin/Config/menu','后台菜单管理',-1,''),(99,'admin',1,'Admin/Article/mydocument','内容',-1,''),(100,'admin',1,'Admin/Menu/index','菜单管理',1,''),(102,'admin',1,'Admin/Menu/add','新增',1,''),(103,'admin',1,'Admin/Menu/edit','编辑',1,''),(104,'admin',1,'Admin/Think/lists?model=article','文章管理',-1,''),(105,'admin',1,'Admin/Think/lists?model=download','下载管理',1,''),(106,'admin',1,'Admin/Think/lists?model=config','配置管理',1,''),(107,'admin',1,'Admin/Action/actionlog','行为日志',1,''),(108,'admin',1,'Admin/User/updatePassword','修改密码',1,''),(109,'admin',1,'Admin/User/updateNickname','修改昵称',1,''),(110,'admin',1,'Admin/action/edit','查看行为日志',1,''),(205,'admin',1,'Admin/think/add','新增数据',1,''),(111,'admin',2,'Admin/article/index','文档列表',-1,''),(112,'admin',2,'Admin/article/add','新增',-1,''),(113,'admin',2,'Admin/article/edit','编辑',-1,''),(114,'admin',2,'Admin/article/setStatus','改变状态',-1,''),(115,'admin',2,'Admin/article/update','保存',-1,''),(116,'admin',2,'Admin/article/autoSave','保存草稿',-1,''),(117,'admin',2,'Admin/article/move','移动',-1,''),(118,'admin',2,'Admin/article/copy','复制',-1,''),(119,'admin',2,'Admin/article/paste','粘贴',-1,''),(120,'admin',2,'Admin/article/batchOperate','导入',-1,''),(121,'admin',2,'Admin/article/recycle','回收站',-1,''),(122,'admin',2,'Admin/article/permit','还原',-1,''),(123,'admin',2,'Admin/article/clear','清空',-1,''),(124,'admin',2,'Admin/User/add','新增用户',-1,''),(125,'admin',2,'Admin/User/action','用户行为',-1,''),(126,'admin',2,'Admin/User/addAction','新增用户行为',-1,''),(127,'admin',2,'Admin/User/editAction','编辑用户行为',-1,''),(128,'admin',2,'Admin/User/saveAction','保存用户行为',-1,''),(129,'admin',2,'Admin/User/setStatus','变更行为状态',-1,''),(130,'admin',2,'Admin/User/changeStatus?method=forbidUser','禁用会员',-1,''),(131,'admin',2,'Admin/User/changeStatus?method=resumeUser','启用会员',-1,''),(132,'admin',2,'Admin/User/changeStatus?method=deleteUser','删除会员',-1,''),(133,'admin',2,'Admin/AuthManager/index','权限管理',-1,''),(134,'admin',2,'Admin/AuthManager/changeStatus?method=deleteGroup','删除',-1,''),(135,'admin',2,'Admin/AuthManager/changeStatus?method=forbidGroup','禁用',-1,''),(136,'admin',2,'Admin/AuthManager/changeStatus?method=resumeGroup','恢复',-1,''),(137,'admin',2,'Admin/AuthManager/createGroup','新增',-1,''),(138,'admin',2,'Admin/AuthManager/editGroup','编辑',-1,''),(139,'admin',2,'Admin/AuthManager/writeGroup','保存用户组',-1,''),(140,'admin',2,'Admin/AuthManager/group','授权',-1,''),(141,'admin',2,'Admin/AuthManager/access','访问授权',-1,''),(142,'admin',2,'Admin/AuthManager/user','成员授权',-1,''),(143,'admin',2,'Admin/AuthManager/removeFromGroup','解除授权',-1,''),(144,'admin',2,'Admin/AuthManager/addToGroup','保存成员授权',-1,''),(145,'admin',2,'Admin/AuthManager/category','分类授权',-1,''),(146,'admin',2,'Admin/AuthManager/addToCategory','保存分类授权',-1,''),(147,'admin',2,'Admin/AuthManager/modelauth','模型授权',-1,''),(148,'admin',2,'Admin/AuthManager/addToModel','保存模型授权',-1,''),(149,'admin',2,'Admin/Addons/create','创建',-1,''),(150,'admin',2,'Admin/Addons/checkForm','检测创建',-1,''),(151,'admin',2,'Admin/Addons/preview','预览',-1,''),(152,'admin',2,'Admin/Addons/build','快速生成插件',-1,''),(153,'admin',2,'Admin/Addons/config','设置',-1,''),(154,'admin',2,'Admin/Addons/disable','禁用',-1,''),(155,'admin',2,'Admin/Addons/enable','启用',-1,''),(156,'admin',2,'Admin/Addons/install','安装',-1,''),(157,'admin',2,'Admin/Addons/uninstall','卸载',-1,''),(158,'admin',2,'Admin/Addons/saveconfig','更新配置',-1,''),(159,'admin',2,'Admin/Addons/adminList','插件后台列表',-1,''),(160,'admin',2,'Admin/Addons/execute','URL方式访问插件',-1,''),(161,'admin',2,'Admin/Addons/hooks','钩子管理',-1,''),(162,'admin',2,'Admin/Model/index','模型管理',-1,''),(163,'admin',2,'Admin/model/add','新增',-1,''),(164,'admin',2,'Admin/model/edit','编辑',-1,''),(165,'admin',2,'Admin/model/setStatus','改变状态',-1,''),(166,'admin',2,'Admin/model/update','保存数据',-1,''),(167,'admin',2,'Admin/Attribute/index','属性管理',-1,''),(168,'admin',2,'Admin/Attribute/add','新增',-1,''),(169,'admin',2,'Admin/Attribute/edit','编辑',-1,''),(170,'admin',2,'Admin/Attribute/setStatus','改变状态',-1,''),(171,'admin',2,'Admin/Attribute/update','保存数据',-1,''),(172,'admin',2,'Admin/Config/index','配置管理',-1,''),(173,'admin',2,'Admin/Config/edit','编辑',-1,''),(174,'admin',2,'Admin/Config/del','删除',-1,''),(175,'admin',2,'Admin/Config/add','新增',-1,''),(176,'admin',2,'Admin/Config/save','保存',-1,''),(177,'admin',2,'Admin/Menu/index','菜单管理',-1,''),(178,'admin',2,'Admin/Channel/index','导航管理',-1,''),(179,'admin',2,'Admin/Channel/add','新增',-1,''),(180,'admin',2,'Admin/Channel/edit','编辑',-1,''),(181,'admin',2,'Admin/Channel/del','删除',-1,''),(182,'admin',2,'Admin/Category/index','分类管理',-1,''),(183,'admin',2,'Admin/Category/edit','编辑',-1,''),(184,'admin',2,'Admin/Category/add','新增',-1,''),(185,'admin',2,'Admin/Category/remove','删除',-1,''),(186,'admin',2,'Admin/Category/move','移动',-1,''),(187,'admin',2,'Admin/Category/merge','合并',-1,''),(188,'admin',2,'Admin/Database/index?type=export','备份数据库',-1,''),(189,'admin',2,'Admin/Database/export','备份',-1,''),(190,'admin',2,'Admin/Database/optimize','优化表',-1,''),(191,'admin',2,'Admin/Database/repair','修复表',-1,''),(192,'admin',2,'Admin/Database/index?type=import','还原数据库',-1,''),(193,'admin',2,'Admin/Database/import','恢复',-1,''),(194,'admin',2,'Admin/Database/del','删除',-1,''),(195,'admin',2,'Admin/other','其他',1,''),(196,'admin',2,'Admin/Menu/add','新增',-1,''),(197,'admin',2,'Admin/Menu/edit','编辑',-1,''),(198,'admin',2,'Admin/Think/lists?model=article','应用',-1,''),(199,'admin',2,'Admin/Think/lists?model=download','下载管理',-1,''),(200,'admin',2,'Admin/Think/lists?model=config','应用',-1,''),(201,'admin',2,'Admin/Action/actionlog','行为日志',-1,''),(202,'admin',2,'Admin/User/updatePassword','修改密码',-1,''),(203,'admin',2,'Admin/User/updateNickname','修改昵称',-1,''),(204,'admin',2,'Admin/action/edit','查看行为日志',-1,''),(206,'admin',1,'Admin/think/edit','编辑数据',1,''),(207,'admin',1,'Admin/Menu/import','导入',1,''),(208,'admin',1,'Admin/Model/generate','生成',1,''),(209,'admin',1,'Admin/Addons/addHook','新增钩子',1,''),(210,'admin',1,'Admin/Addons/edithook','编辑钩子',1,''),(211,'admin',1,'Admin/Article/sort','文档排序',1,''),(212,'admin',1,'Admin/Config/sort','排序',1,''),(213,'admin',1,'Admin/Menu/sort','排序',1,''),(214,'admin',1,'Admin/Channel/sort','排序',1,''),(215,'admin',1,'Admin/Category/operate/type/move','移动',1,''),(216,'admin',1,'Admin/Category/operate/type/merge','合并',1,''),(217,'admin',2,'Admin/Account/index','公共账号',1,''),(218,'admin',1,'Admin/Account/index','公共账号',1,''),(219,'admin',1,'Admin/AccountGroup/index','解决方案',-1,''),(220,'admin',1,'Admin/Account/group','解决方案',1,''),(221,'admin',1,'Admin/AccountGroup','添加',1,'');

/*Table structure for table `v_category` */

DROP TABLE IF EXISTS `v_category`;

CREATE TABLE `v_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(30) NOT NULL COMMENT '标志',
  `title` varchar(50) NOT NULL COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `list_row` tinyint(3) unsigned NOT NULL DEFAULT '10' COMMENT '列表每页行数',
  `meta_title` varchar(50) NOT NULL DEFAULT '' COMMENT 'SEO的网页标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `template_index` varchar(100) NOT NULL COMMENT '频道页模板',
  `template_lists` varchar(100) NOT NULL COMMENT '列表页模板',
  `template_detail` varchar(100) NOT NULL COMMENT '详情页模板',
  `template_edit` varchar(100) NOT NULL COMMENT '编辑页模板',
  `model` varchar(100) NOT NULL DEFAULT '' COMMENT '关联模型',
  `type` varchar(100) NOT NULL DEFAULT '' COMMENT '允许发布的内容类型',
  `link_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '外链',
  `allow_publish` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许发布内容',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `reply` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许回复',
  `check` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '发布的文章是否需要审核',
  `reply_model` varchar(100) NOT NULL DEFAULT '',
  `extend` text NOT NULL COMMENT '扩展设置',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `icon` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类图标',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=41 COMMENT='分类表';

/*Data for the table `v_category` */
insert  into `v_category`(`id`,`name`,`title`,`pid`,`sort`,`list_row`,`meta_title`,`keywords`,`description`,`template_index`,`template_lists`,`template_detail`,`template_edit`,`model`,`type`,`link_id`,`allow_publish`,`display`,`reply`,`check`,`reply_model`,`extend`,`create_time`,`update_time`,`status`,`icon`) values (1,'fc','功能介绍',0,2,10,'','','','','','','','2','2,1',0,1,1,0,0,'1','',1379474947,1396920994,1,0),(39,'casepage','成功案例',0,0,10,'','','','','','','','2','2,3',0,1,1,1,0,'','',1396920974,1396920974,1,0),(40,'about','关于我们',0,0,10,'','','','','','','','2','2,1,3',0,1,1,1,0,'','',1397025879,1397025879,1,0);

/*Table structure for table `v_channel` */

DROP TABLE IF EXISTS `v_channel`;

CREATE TABLE `v_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '频道ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级频道ID',
  `title` char(30) NOT NULL COMMENT '频道标题',
  `url` char(100) NOT NULL COMMENT '频道连接',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `target` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '新窗口打开',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*Data for the table `v_channel` */

insert  into `v_channel`(`id`,`pid`,`title`,`url`,`sort`,`create_time`,`update_time`,`status`,`target`) values (1,0,'首页','Index/index',1,1379475111,1379923177,1,0),(2,0,'功能介绍','Index/fc',2,1379475131,1397026054,1,0),(3,0,'产品价格','Index/price',3,1379475154,1397026075,1,0),(4,0,'客户案例','Index/casepage',4,1397026091,1397026115,1,0),(5,0,'管理中心','User/Index/index',5,1397026103,1397026121,1,0),(6,0,'帮助中心','Index/help',6,1397026138,1397026147,1,0),(7,0,'关于我们','Index/content?id=10',7,1397026157,1397026157,1,0),(8,0,'联系方式','Index/content?id=11',8,1397026171,1397026171,1,0);

/*Table structure for table `v_classify` */

DROP TABLE IF EXISTS `v_classify`;

CREATE TABLE `v_classify` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `info` varchar(90) NOT NULL COMMENT '分类描述',
  `sorts` varchar(6) NOT NULL COMMENT '显示顺序',
  `img` char(255) NOT NULL,
  `url` char(255) NOT NULL,
  `status` varchar(1) NOT NULL,
  `token` varchar(30) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  `type` varchar(20) DEFAULT NULL,
  `itemid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

/*Data for the table `v_classify` */


/*Table structure for table `v_company` */

DROP TABLE IF EXISTS `v_company`;

CREATE TABLE `v_company` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `shortname` varchar(50) NOT NULL DEFAULT '',
  `mp` varchar(11) NOT NULL DEFAULT '',
  `tel` varchar(20) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `latitude` double NOT NULL,
  `longitude` double NOT NULL,
  `intro` text NOT NULL,
  `catid` mediumint(3) NOT NULL DEFAULT '0',
  `taxis` int(10) NOT NULL DEFAULT '0',
  `isbranch` tinyint(1) NOT NULL DEFAULT '0',
  `logourl` varchar(80) NOT NULL DEFAULT '',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `v_company` */


/*Table structure for table `v_config` */

DROP TABLE IF EXISTS `v_config`;

CREATE TABLE `v_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '配置名称',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '配置类型',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '配置说明',
  `group` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '配置分组',
  `extra` varchar(255) NOT NULL DEFAULT '' COMMENT '配置值',
  `remark` varchar(100) NOT NULL COMMENT '配置说明',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `value` text NOT NULL COMMENT '配置值',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

/*Data for the table `v_config` */

insert  into `v_config`(`id`,`name`,`type`,`title`,`group`,`extra`,`remark`,`create_time`,`update_time`,`status`,`value`,`sort`) values (1,'WEB_SITE_TITLE',1,'网站标题',1,'','网站标题前台显示标题',1378898976,1379235274,1,'网人微动力',0),(2,'WEB_SITE_DESCRIPTION',2,'网站描述',1,'','网站搜索引擎描述',1378898976,1379235841,1,'网人微信管理系统',1),(3,'WEB_SITE_KEYWORD',2,'网站关键字',1,'','网站搜索引擎关键字',1378898976,1381390100,1,'网人微信管理系统,微信公共账号',8),(4,'WEB_SITE_CLOSE',4,'关闭站点',1,'0:关闭,1:开启','站点关闭后其他用户不能访问，管理员可以正常访问',1378898976,1379235296,1,'1',1),(9,'CONFIG_TYPE_LIST',3,'配置类型列表',4,'','主要用于数据解析和页面表单的生成',1378898976,1379235348,1,'0:数字\r\n1:字符\r\n2:文本\r\n3:数组\r\n4:枚举',2),(10,'WEB_SITE_ICP',1,'网站备案号',1,'','设置在网站底部显示的备案号，如“沪ICP备12007941号-2',1378900335,1379235859,1,'',9),(11,'DOCUMENT_POSITION',3,'文档推荐位',2,'','文档推荐位，推荐到多个位置KEY值相加即可',1379053380,1379235329,1,'1:列表页推荐\r\n2:频道页推荐\r\n4:网站首页推荐',3),(12,'DOCUMENT_DISPLAY',3,'文档可见性',2,'','文章可见性仅影响前台显示，后台不收影响',1379056370,1379235322,1,'0:所有人可见\r\n1:仅注册会员可见\r\n2:仅管理员可见',4),(13,'COLOR_STYLE',4,'后台色系',1,'default_color:默认\r\nblue_color:紫罗兰','后台颜色风格',1379122533,1379235904,1,'default_color',10),(20,'CONFIG_GROUP_LIST',3,'配置分组',4,'','配置分组',1379228036,1384418383,1,'1:基本\r\n2:内容\r\n3:用户\r\n4:系统\r\n5:支付\r\n6:模板\r\n7:邮件',4),(21,'HOOKS_TYPE',3,'钩子的类型',4,'','类型 1-用于扩展显示内容，2-用于扩展业务处理',1379313397,1379313407,1,'1:视图\r\n2:控制器',6),(22,'AUTH_CONFIG',3,'Auth配置',4,'','自定义Auth.class.php类配置',1379409310,1379409564,1,'AUTH_ON:1\r\nAUTH_TYPE:2',8),(23,'OPEN_DRAFTBOX',4,'是否开启草稿功能',2,'0:关闭草稿功能\r\n1:开启草稿功能\r\n','新增文章时的草稿功能配置',1379484332,1379484591,1,'0',1),(24,'DRAFT_AOTOSAVE_INTERVAL',0,'自动保存草稿时间',2,'','自动保存草稿的时间间隔，单位：秒',1379484574,1386143323,1,'60',2),(25,'LIST_ROWS',0,'后台每页记录数',2,'','后台数据每页显示记录数',1379503896,1380427745,1,'10',10),(26,'USER_ALLOW_REGISTER',4,'是否允许用户注册',3,'0:关闭注册\r\n1:允许注册','是否开放用户注册',1379504487,1379504580,1,'1',3),(27,'CODEMIRROR_THEME',4,'预览插件的CodeMirror主题',4,'3024-day:3024 day\r\n3024-night:3024 night\r\nambiance:ambiance\r\nbase16-dark:base16 dark\r\nbase16-light:base16 light\r\nblackboard:blackboard\r\ncobalt:cobalt\r\neclipse:eclipse\r\nelegant:elegant\r\nerlang-dark:erlang-dark\r\nlesser-dark:lesser-dark\r\nmidnight:midnight','详情见CodeMirror官网',1379814385,1384740813,1,'ambiance',3),(28,'DATA_BACKUP_PATH',1,'数据库备份根路径',4,'','路径必须以 / 结尾',1381482411,1381482411,1,'./Data/',5),(29,'DATA_BACKUP_PART_SIZE',0,'数据库备份卷大小',4,'','该值用于限制压缩后的分卷最大长度。单位：B；建议设置20M',1381482488,1381729564,1,'20971520',7),(30,'DATA_BACKUP_COMPRESS',4,'数据库备份文件是否启用压缩',4,'0:不压缩\r\n1:启用压缩','压缩备份文件需要PHP环境支持gzopen,gzwrite函数',1381713345,1381729544,1,'1',9),(31,'DATA_BACKUP_COMPRESS_LEVEL',4,'数据库备份文件压缩级别',4,'1:普通\r\n4:一般\r\n9:最高','数据库备份文件的压缩级别，该配置在开启压缩时生效',1381713408,1381713408,1,'9',10),(32,'DEVELOP_MODE',4,'开启开发者模式',4,'0:关闭\r\n1:开启','是否开启开发者模式',1383105995,1383291877,1,'1',11),(33,'ALLOW_VISIT',3,'不受限控制器方法',0,'','',1386644047,1386644741,1,'0:article/draftbox\r\n1:article/mydocument\r\n2:Category/tree\r\n3:Index/verify\r\n4:file/upload\r\n5:file/download\r\n6:user/updatePassword\r\n7:user/updateNickname\r\n8:user/submitPassword\r\n9:user/submitNickname',0),(34,'DENY_VISIT',3,'超管专限控制器方法',0,'','仅超级管理员可访问的控制器方法',1386644141,1386644659,1,'0:Addons/addhook\r\n1:Addons/edithook\r\n2:Addons/delhook\r\n3:Addons/updateHook\r\n4:Admin/getMenus\r\n5:Admin/recordList\r\n6:AuthManager/updateRules\r\n7:AuthManager/tree',0),(35,'REPLY_LIST_ROWS',0,'回复列表每页条数',2,'','',1386645376,1387178083,1,'10',0),(36,'ADMIN_ALLOW_IP',2,'后台允许访问IP',4,'','多个用逗号分隔，如果不配置表示不限制IP访问',1387165454,1387165553,1,'',12),(37,'SHOW_PAGE_TRACE',4,'是否显示页面Trace',4,'0:关闭\r\n1:开启','是否显示页面Trace信息',1387165685,1387165685,1,'0',1),(38,'WEB_SITE_URL',1,'网址',1,'','以http://开头',1393377307,1393377307,1,'http://demo.china800.net',0),(39,'ALIPAY_NAME',1,'支付宝账号',5,'','',1393830613,1393830613,1,'pay@china800.net',0),(40,'ALIPAY_PID',1,'支付宝pid',5,'','',1393830632,1393830719,1,'',0),(41,'ALIPAY_KEY',1,'支付宝key',5,'','',1393830665,1393830731,1,'',0),(42,'TEMPLATE',4,'选择模板',6,'default:默认模板\r\ndefault2:模板2号\r\ndefault3:模板3号','请选择模板',1394449093,1396578713,1,'default',0),(43,'MAIL_TYPE',4,'邮件类型',7,'smtp:SMTP模块发送','',1394613583,1394613583,1,'smtp',0),(44,'MAIL_SMTP_HOST',1,'SMTP服务器',7,'','',1394613609,1394613609,1,'smtp.exmail.sina.com',0),(45,'MAIL_SMTP_PORT',0,'SMTP服务器端口',7,'','',1394613627,1394613627,1,'25',0),(46,'MAIL_SMTP_USER',1,'SMTP服务器用户名',7,'','',1394613643,1394613643,1,'noreply@china800.net',0),(47,'MAIL_SMTP_PASS',1,'SMTP服务器密码',7,'','',1394613659,1394613659,1,'zhuanke163',0),(48,'DOMAIN_ROOT',1,'二级域名的根域名',3,'','例如：.163er.com请注意前面的点',1396345226,1396345226,1,'.163er.com',0);

/*Table structure for table `v_default_response` */

DROP TABLE IF EXISTS `v_default_response`;

CREATE TABLE `v_default_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `keyword` varchar(60) NOT NULL,
  `info` varchar(200) NOT NULL,
  `test` varchar(1) DEFAULT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

/*Data for the table `v_default_response` */

/*Table structure for table `v_diymenu` */

DROP TABLE IF EXISTS `v_diymenu`;

CREATE TABLE `v_diymenu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `pid` int(11) NOT NULL,
  `title` varchar(30) NOT NULL,
  `keyword` varchar(30) NOT NULL,
  `is_show` tinyint(1) NOT NULL,
  `sort` tinyint(3) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `type` varchar(30) NOT NULL DEFAULT 'click',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

/*Data for the table `v_diymenu` */


/*Table structure for table `v_dmpage` */

DROP TABLE IF EXISTS `v_dmpage`;

CREATE TABLE `v_dmpage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `token` varchar(60) NOT NULL,
  `url` varchar(100) NOT NULL,
  `copyright` varchar(50) NOT NULL,
  `info` varchar(120) NOT NULL,
  `title` varchar(60) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `v_dmpage` */


/*Table structure for table `v_document` */

DROP TABLE IF EXISTS `v_document`;

CREATE TABLE `v_document` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '标识',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '标题',
  `category_id` int(10) unsigned NOT NULL COMMENT '所属分类',
  `description` char(140) NOT NULL DEFAULT '' COMMENT '描述',
  `root` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '根节点',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属ID',
  `model_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '内容模型ID',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '2' COMMENT '内容类型',
  `position` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '推荐位',
  `link_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '外链',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '封面',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '可见性',
  `deadline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '截至时间',
  `attach` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '附件数量',
  `view` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `comment` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '评论数',
  `extend` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '扩展统计字段',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '优先级',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_category_status` (`category_id`,`status`),
  KEY `idx_status_type_pid` (`status`,`type`,`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=21 COMMENT='文档模型基础表';

/*Data for the table `v_document` */

insert  into `v_document`(`id`,`uid`,`name`,`title`,`category_id`,`description`,`root`,`pid`,`model_id`,`type`,`position`,`link_id`,`cover_id`,`display`,`deadline`,`attach`,`view`,`comment`,`extend`,`level`,`create_time`,`update_time`,`status`) values (8,1,'','微留言',1,'',0,0,2,2,0,0,101,1,0,0,0,0,0,0,2014,1396939342,1),(7,1,'','微活动',1,'',0,0,2,2,0,0,102,1,0,0,0,0,0,0,2014,1396939373,1),(6,1,'','微信会员卡',1,'',0,0,2,2,0,0,103,1,0,0,0,0,0,0,2014,1396939398,1),(5,1,'','微官网',1,'',0,0,2,2,0,0,87,1,0,0,0,0,0,0,1396922367,1396922367,1),(9,1,'','微相册',1,'',0,0,2,2,0,0,104,1,0,0,0,0,0,0,2014,1396939437,1),(10,1,'','自定义菜单',1,'',0,0,2,2,0,0,92,1,0,0,0,0,0,0,1396923539,1396923539,1),(11,1,'','微喜帖',1,'',0,0,2,2,0,0,105,1,0,0,0,0,0,0,2014,1396939645,1),(12,1,'','LBS回复',1,'',0,0,2,2,0,0,106,1,0,0,0,0,0,0,2014,1396939672,1),(13,1,'','微餐饮',1,'',0,0,2,2,0,0,107,1,0,0,0,0,0,0,2014,1396939702,1),(14,1,'','微商城',1,'',0,0,2,2,0,0,108,1,0,0,0,0,0,0,2014,1396939751,1),(15,1,'','微预约',1,'',0,0,2,2,0,0,109,1,0,0,0,0,0,0,2014,1396939781,1),(16,1,'','微生活',1,'',0,0,2,2,0,0,110,1,0,0,0,0,0,0,2014,1396939803,1),(17,1,'','数据魔方',1,'',0,0,2,2,0,0,99,1,0,0,0,0,0,0,1396925554,1396925554,1),(18,1,'','微团购',1,'',0,0,2,2,0,0,100,1,0,0,0,0,0,0,1396925803,1396925803,1),(19,1,'','关于我们',40,'',0,0,2,2,0,0,0,1,0,0,0,0,0,0,1397025932,1397025932,1),(20,1,'','联系方式',40,'',0,0,2,2,0,0,0,1,0,0,0,0,0,0,1397025952,1397025952,1);

/*Table structure for table `v_document_article` */

DROP TABLE IF EXISTS `v_document_article`;

CREATE TABLE `v_document_article` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `parse` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '内容解析类型',
  `content` text NOT NULL COMMENT '文章内容',
  `template` varchar(100) NOT NULL DEFAULT '' COMMENT '详情页显示模板',
  `bookmark` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '收藏数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM COMMENT='文档模型文章表';

/*Data for the table `v_document_article` */

insert  into `v_document_article`(`id`,`parse`,`content`,`template`,`bookmark`) values (6,0,'<p class=\"guidep\">\r\n	微信会员卡通过在微信内植入会员卡，基于全国4亿微信用户，帮助企业建立集品牌推广、会员管理、营销活动、统计报表于一体的微信会员管理平台。清晰记录企业用户的消费行为并进行数据分析；还可根据用户特征进行精细分类，从而实现各种模式的精准营销。\r\n</p>','',0),(7,0,'<p class=\"guidep\">\r\n	我们将利用微信的强交互性，让您通过对互动流程、环节和方式的设计，运用各种设计活动从而实现与用户的互动交流,，微整合系统互动符合微信娱乐性强的产品本质，微动力内置了专为商家定制的“商家营销服务模块”，包括优惠券推广模块、幸运大转盘推广模块、刮刮卡抽奖模块、微投票、一战到底等功能模块，商家通过发起营销活动，对已有客户进行再营销，通过不断更新补充主题，用户可以反复参与，并可带动周边朋友一起分享，从而形成极强的口碑营销效果。\r\n</p>','',0),(8,0,'<p class=\"guidep\">\r\n	“微留言”是一种能为商家带来巨大的社会化流量的功能，允许留言可以被分享于留言者的朋友圈、腾讯微博和发送给好友，这意味着留言可以被无数的粉丝分享，用户对商家进行实时且客观的评价，真实的社交环境保证了留言的客观性和有效性。“微留言”的使用商家只需做好产品和用户服务即可，随着口碑的传播，消费者将源源不断。\r\n</p>','',0),(9,0,'<p class=\"guidep\">\r\n	微相册作为微动力平台的一项主打基本功能，为微动力用户提供图片的存储和展示服务，是基于图片兴趣分享的社区型产品。在微相册里，您可以方便的创建相册，轻松地发布您需要展示的照片，还可以拓展为商家开展活动的一种展现方式。\r\n</p>','',0),(10,0,'<p class=\"guidep\">\r\n	微动力提供微信公众号自定义菜单管理功能，用户无需再通过输入关键词触发回复，直接点击菜单就可以看相关的内容，微动力可与企业原有Wap进行打通，复用企业APP原有功能，同时可定制个性化功能、使用HTML5新技术进行无限拓展，帮助企业打造最便捷、易推广的微信内置APP，此功能如果结合微信3G网站可以使您的公众号用户体验更好，带给粉丝不一样的感受。\r\n</p>','',0),(5,0,'<p class=\"guidep\">\r\n	微动力全国首创微信3G网站，用户只要通过简单的设置，就能快速生成属于您自己的微信3G网站，并且有各种精美模板，可供选择，还有自定义模版，可以设计出自己的风格，让您的粉丝有种惊艳的感觉。在微动力官方微信号输入\"首页\"体验微信3G网站。\r\n</p>','',0),(11,0,'<p class=\"guidep\">\r\n	微喜帖是针对结婚庆典而推出的一款行业产品，主要是为计划结婚的用户们，通过使用微喜帖应用来向亲朋好友传播自己即将结婚的动态，可以展现用户想要表达的话、结婚日期、地址、导航、接待电话，同时亲朋好友可以在微喜帖平台上提交赴宴通知、送上祝福，并且转发喜帖。\r\n</p>','',0),(12,0,'<p class=\"guidep\">\r\n	LBS图文回复是由商家设置店铺位置，用户提交当前所在位置后，可以找到最近的商家店铺，并进行一键导航、一键拨号，如果店铺当前有进行的活动（如：优惠券、刮刮卡），也可把活动显示出来。\r\n</p>','',0),(13,0,'<p class=\"guidep\">\r\n	微动力后台可以实时统计微信公众号的粉丝关注情况和用户语音请求数，根据统计对相关推广营销活动效果及某些敏感因素对您的影响作出判断，并对相关市场行为作出相应调整，从一定程度上实现了对市场的监控与及时应对。\r\n</p>','',0),(14,0,'<p class=\"guidep\">\r\n	“微商城”（又名Vshop）是由上海晖硕信息科技有限公司推出的，一款基于移动互联网的商城应用服务产品，以时下最热门的互动应用微信为媒介，配合微信5.0微信支付功能，实现商家与客户的在线互动，即时推送最新商品信息给微信用户，实现微信在线的购物功能。 其主要功能包括：支持商品管理、支持会员管理、支持购物车、支持商品分类管理、支持订单管理、支持店铺设置、支持支付方式管理、支持配送方式管理。\r\n</p>','',0),(15,0,'<p class=\"guidep\">\r\n	微预约是商家利用微动力平台实现在线预约的一种服务，可以运用于汽车、房产、酒店、医疗、餐饮等一系列行业，给用户的出行办事、购物、消费带来了极大的便利！且操作简单，响应速度非常快，受到业界的一致好评！\r\n</p>','',0),(16,0,'随着微信等新媒介的兴起，生活方式正在发生“微”“秒”的变化，微生活是通过微动力平台打造的一款彻底专为用户提供全方位生活服务的移动网站，通过微生活服务，用户可以时时刻刻享受在线购物、点餐、定机票、预约酒店等多项服务的功能，彻底改变了用户传统的生活模式。<br />\r\n1、商户管理：微生活支持商户管理功能，其中包括商户的基础设置、商户信息设置、会员设置、优惠设置以及商品的展示功能，让用户通过微盟平台可以浏览整个商圈。<br />\r\n2、会员管理：用户通过在手机端领取会员卡，商家就可以在微动力后台查询到用户的会员记录，包括会员卡号、用户姓名、手机号、领取卡的时间、所属用户以及会员卡的状态设置，让用户资源随手可得。','',0),(17,0,'<p class=\"guidep\">\r\n	通过数据魔方，商家可轻松了解买家，诊断微网信息，不错过任何一个潜在客户。数据魔方将包括：用户分析、图文内容分析、渠道分析、关键词分析等功能。\r\n</p>','',0),(18,0,'<p class=\"guidep\">\r\n	微团购商家管理分为后台管理及门店管理两个部分。后台管理分为团购管理、订单管理、团购券管理以及会员管理、退款管理：团购管理包括新建团购、复制团购、上架管理、添加通知等功能；订单管理及团购券管理主要功能为查询与导出；会员管理中可以看到会员消费总数据；退款管理中可以查看用户的退款信息。门店管理分为团购券验证及团购券管理两部分：团购券验证可以验证适用门店已选择当前门店的团购券；团购券管理仅支持已被授权的团购。\r\n</p>','',0),(19,0,'<span>&nbsp; &nbsp; 网人微动力志在帮助那些不懂技术的个人或企业建立属于自己的微信运营管理平台，让完全不懂技术的个人或企业通过简单的配置，即可拥有强大的功能。企业使用微动力可以用低廉的成本实现智能客服机器人功能，淘宝店家可以轻松实现店铺商品和粉丝的关联与互动，我们也即将为微信地方号运维人员提供强大的地方运维的管理功能模块（如商家管理,店铺管理,会员管理,活动管理,优惠券管理,以及基于LBS的各种服务的开发!）</span><br />\r\n<span>&nbsp; &nbsp; 微动力</span><span>提供微信公众平台开发、微信接口开发、微信3G网站建设、微信营销、等微信领域外包服务与营销服务。网人微动力</span><span>为个人或企业提供了强大的自定义回复及图文信息分类功能，通过此功能能更好做出属于自己或企业特色的内容，并自动建立一个个人或企业手机3G网站，更好的服务于您的客户。</span>','',0),(20,0,'公司名称：石家庄网人信息技术有限公司<br />\r\n电话：0311-80729380<br />\r\nＱＱ：1026078316 / 932808027 / 2292747690 / 1816405051 / 16416648<br />\r\n咨询邮箱：sales@china800.net<br />\r\n投诉邮箱：support@china800.net<br />\r\n地址：中国河北省石家庄市青园街182号<br />','',0);

/*Table structure for table `v_document_download` */

DROP TABLE IF EXISTS `v_document_download`;

CREATE TABLE `v_document_download` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `parse` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '内容解析类型',
  `content` text NOT NULL COMMENT '下载详细描述',
  `template` varchar(100) NOT NULL DEFAULT '' COMMENT '详情页显示模板',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件ID',
  `download` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下载次数',
  `size` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM COMMENT='文档模型下载表';

/*Data for the table `v_document_download` */

/*Table structure for table `v_file` */

DROP TABLE IF EXISTS `v_file`;

CREATE TABLE `v_file` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文件ID',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '原始文件名',
  `savename` char(20) NOT NULL DEFAULT '' COMMENT '保存名称',
  `savepath` char(30) NOT NULL DEFAULT '' COMMENT '文件保存路径',
  `ext` char(5) NOT NULL DEFAULT '' COMMENT '文件后缀',
  `mime` char(40) NOT NULL DEFAULT '' COMMENT '文件mime类型',
  `size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `location` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '文件保存位置',
  `create_time` int(10) unsigned NOT NULL COMMENT '上传时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_md5` (`md5`)
) ENGINE=MyISAM COMMENT='文件表';

/*Data for the table `v_file` */

/*Table structure for table `v_flash` */

DROP TABLE IF EXISTS `v_flash`;

CREATE TABLE `v_flash` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) NOT NULL,
  `img` char(255) NOT NULL,
  `url` char(255) NOT NULL,
  `info` varchar(90) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

/*Data for the table `v_flash` */


/*Table structure for table `v_freeform` */

DROP TABLE IF EXISTS `v_freeform`;

CREATE TABLE `v_freeform` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `keyword` varchar(100) NOT NULL DEFAULT '',
  `intro` varchar(400) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  `successtip` varchar(60) NOT NULL DEFAULT '',
  `failtip` varchar(60) NOT NULL DEFAULT '',
  `endtime` int(10) NOT NULL DEFAULT '0',
  `logourl` varchar(100) NOT NULL DEFAULT '',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE,
  KEY `endtime` (`endtime`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `v_freeform` */


/*Table structure for table `v_freeform_input` */

DROP TABLE IF EXISTS `v_freeform_input`;

CREATE TABLE `v_freeform_input` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `formid` int(10) NOT NULL DEFAULT '0',
  `displayname` varchar(30) NOT NULL DEFAULT '',
  `fieldname` varchar(30) NOT NULL DEFAULT '',
  `inputtype` varchar(20) NOT NULL DEFAULT '',
  `options` varchar(200) NOT NULL DEFAULT '',
  `require` tinyint(1) NOT NULL DEFAULT '0',
  `regex` varchar(100) NOT NULL DEFAULT '',
  `taxis` mediumint(4) NOT NULL DEFAULT '0',
  `errortip` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `formid` (`formid`,`taxis`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `v_freeform_input` */


/*Table structure for table `v_freeform_value` */

DROP TABLE IF EXISTS `v_freeform_value`;

CREATE TABLE `v_freeform_value` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `formid` int(10) NOT NULL DEFAULT '0',
  `wecha_id` varchar(50) NOT NULL DEFAULT '',
  `values` varchar(2000) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `formid` (`formid`,`wecha_id`,`time`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `v_freeform_value` */


/*Table structure for table `v_goldegg` */

DROP TABLE IF EXISTS `v_goldegg`;

CREATE TABLE `v_goldegg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `joinnum` int(11) NOT NULL COMMENT '参与人数',
  `click` int(11) NOT NULL COMMENT '浏览人数',
  `token` varchar(255) NOT NULL COMMENT '微信TOKEN',
  `keyword` varchar(255) NOT NULL COMMENT '关键词',
  `startpicurl` varchar(255) NOT NULL COMMENT '填写活动开始图片网址',
  `title` varchar(255) NOT NULL COMMENT '活动名称',
  `txt` varchar(255) NOT NULL COMMENT '用户输入兑奖时候的显示信息',
  `summary` varchar(255) NOT NULL COMMENT '简介',
  `startdate` int(11) NOT NULL COMMENT '活动开始时间',
  `enddate` int(11) NOT NULL COMMENT '活动结束时间',
  `info` varchar(255) NOT NULL COMMENT '活动说明',
  `aginfo` varchar(255) NOT NULL COMMENT '重复抽奖回复',
  `endtite` varchar(255) NOT NULL COMMENT '活动结束公告主题',
  `endpicurl` varchar(255) NOT NULL COMMENT '活动结束回复图片',
  `endinfo` varchar(255) NOT NULL COMMENT '活动结束回复',
  `allpeople` int(11) NOT NULL COMMENT '预计活动的人数',
  `canrqnums` int(22) NOT NULL COMMENT '个人限制抽奖次数',
  `parssword` int(15) NOT NULL COMMENT '兑奖密码',
  `snimport` tinyint(1) NOT NULL COMMENT 'SN码生成设置',
  `renamesn` varchar(60) NOT NULL DEFAULT 'SN码' COMMENT 'SN码重命名为',
  `renametel` varchar(60) NOT NULL DEFAULT '手机号' COMMENT '手机号重命名',
  `displayjpnums` int(1) NOT NULL COMMENT '抽奖页面是否显示奖品数量',
  `createtime` int(11) NOT NULL COMMENT '活动创建时间',
  `status` int(1) NOT NULL COMMENT '活动状态,0未开始,1进行中,2已关闭',
  `verify` int(1) NOT NULL COMMENT '是否需要验证码',
  `verifynum` int(11) NOT NULL DEFAULT '0' COMMENT '验证码次数',
  `verifycode` varchar(255) NOT NULL COMMENT '验证码列表',
  `type` varchar(10) NOT NULL COMMENT '活动类型',
  `first` varchar(50) NOT NULL COMMENT '一等奖奖品设置',
  `firstnums` int(4) NOT NULL COMMENT '一等奖奖品数量',
  `firstlucknums` int(11) NOT NULL COMMENT '一等奖中奖号码',
  `second` varchar(50) NOT NULL COMMENT '二等奖奖品设置',
  `secondnums` int(4) NOT NULL COMMENT '二等奖奖品数量',
  `secondlucknums` int(11) NOT NULL COMMENT '二等奖中奖号码',
  `third` varchar(50) NOT NULL COMMENT '三等奖',
  `thirdnums` int(4) NOT NULL COMMENT '二等奖',
  `thirdlucknums` int(11) NOT NULL COMMENT '二等奖',
  `four` varchar(50) NOT NULL COMMENT '四等奖奖品设置',
  `fournums` int(11) NOT NULL COMMENT '四等奖奖品数量',
  `fourlucknums` int(11) NOT NULL COMMENT '四等奖中奖号码',
  `five` varchar(50) NOT NULL COMMENT '五等奖',
  `fivenums` int(11) NOT NULL COMMENT '五等奖',
  `fivelucknums` int(11) NOT NULL COMMENT '五等奖',
  `six` varchar(50) NOT NULL COMMENT '六等奖奖品设置',
  `sixnums` int(11) NOT NULL COMMENT '六等奖奖品数量',
  `sixlucknums` int(11) NOT NULL COMMENT '六等奖中奖号码',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 COMMENT='砸金蛋';

/*Data for the table `v_goldegg` */


/*Table structure for table `v_goldegg_record` */

DROP TABLE IF EXISTS `v_goldegg_record`;

CREATE TABLE `v_goldegg_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lid` int(11) NOT NULL COMMENT '关联ID',
  `usenums` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户使用次数',
  `wecha_id` varchar(60) NOT NULL COMMENT '微信唯一识别码',
  `token` varchar(60) NOT NULL COMMENT '微信TOKEN',
  `islucky` int(1) NOT NULL COMMENT '是否中奖',
  `wecha_name` varchar(60) NOT NULL COMMENT '微信号',
  `phone` varchar(20) NOT NULL COMMENT '手机号',
  `sn` varchar(60) NOT NULL COMMENT '中奖后序列号',
  `time` int(11) NOT NULL COMMENT '时间',
  `prize` varchar(60) NOT NULL DEFAULT '' COMMENT '已中奖项',
  `sendstutas` int(11) NOT NULL DEFAULT '0' COMMENT '领取状态',
  `sendtime` int(11) NOT NULL COMMENT '领取时间',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`lid`)
) ENGINE=MyISAM AUTO_INCREMENT=12 COMMENT='砸金蛋记录';

/*Data for the table `v_goldegg_record` */


/*Table structure for table `v_guestbook` */

DROP TABLE IF EXISTS `v_guestbook`;

CREATE TABLE `v_guestbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(30) NOT NULL,
  `nickname` varchar(30) DEFAULT NULL,
  `content` varchar(500) DEFAULT NULL,
  `createtime` int(20) DEFAULT NULL,
  `uptatetime` int(20) DEFAULT NULL,
  `reply` varchar(500) DEFAULT NULL,
  `wecha_id` varchar(200) DEFAULT NULL,
  `siteid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=108 DEFAULT CHARSET=utf8;

/*Data for the table `v_guestbook` */


/*Table structure for table `v_hooks` */

DROP TABLE IF EXISTS `v_hooks`;

CREATE TABLE `v_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text NOT NULL COMMENT '描述',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `addons` varchar(255) NOT NULL DEFAULT '' COMMENT '钩子挂载的插件 ''，''分割',
  PRIMARY KEY (`id`),
  UNIQUE KEY `搜索索引` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

/*Data for the table `v_hooks` */

insert  into `v_hooks`(`id`,`name`,`description`,`type`,`update_time`,`addons`) values (1,'pageHeader','页面header钩子，一般用于加载插件CSS文件和代码',1,0,''),(2,'pageFooter','页面footer钩子，一般用于加载插件JS文件和JS代码',1,0,'ReturnTop'),(3,'documentEditForm','添加编辑表单的 扩展内容钩子',1,0,'Attachment'),(4,'documentDetailAfter','文档末尾显示',1,0,'Attachment,SocialComment'),(5,'documentDetailBefore','页面内容前显示用钩子',1,0,''),(6,'documentSaveComplete','保存文档数据后的扩展钩子',2,0,'Attachment'),(7,'documentEditFormContent','添加编辑表单的内容显示钩子',1,0,'Editor'),(8,'adminArticleEdit','后台内容编辑页编辑器',1,1378982734,'EditorForAdmin'),(13,'AdminIndex','首页小格子个性化显示',1,1382596073,'SiteStat,SystemInfo,DevTeam'),(14,'topicComment','评论提交方式扩展钩子。',1,1380163518,'Editor'),(16,'app_begin','应用开始',2,1384481614,'');

/*Table structure for table `v_img` */

DROP TABLE IF EXISTS `v_img`;

CREATE TABLE `v_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `uname` varchar(90) NOT NULL,
  `keyword` char(255) NOT NULL,
  `type` varchar(1) NOT NULL COMMENT '关键词匹配类型',
  `text` text NOT NULL COMMENT '简介',
  `classid` int(11) NOT NULL,
  `classname` varchar(60) NOT NULL,
  `pic` char(255) NOT NULL COMMENT '封面图片',
  `showpic` varchar(1) NOT NULL COMMENT '图片是否显示封面',
  `info` text NOT NULL COMMENT '图文详细内容',
  `url` char(255) NOT NULL COMMENT '图文外链地址',
  `createtime` varchar(13) NOT NULL,
  `uptatetime` varchar(13) NOT NULL,
  `click` int(11) NOT NULL,
  `token` char(30) NOT NULL,
  `title` varchar(60) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `classid` (`classid`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

/*Data for the table `v_img` */


/*Table structure for table `v_keyword` */

DROP TABLE IF EXISTS `v_keyword`;

CREATE TABLE `v_keyword` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` char(255) NOT NULL,
  `pid` int(11) NOT NULL,
  `token` varchar(60) NOT NULL,
  `module` varchar(15) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE,
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;

/*Data for the table `v_keyword` */


/*Table structure for table `v_lottery` */

DROP TABLE IF EXISTS `v_lottery`;

CREATE TABLE `v_lottery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `joinnum` int(11) NOT NULL COMMENT '参与人数',
  `click` int(11) NOT NULL,
  `token` varchar(30) NOT NULL,
  `keyword` varchar(10) NOT NULL,
  `startpicurl` varchar(100) NOT NULL COMMENT '填写活动开始图片网址',
  `title` varchar(60) NOT NULL COMMENT '活动名称',
  `txt` varchar(60) NOT NULL COMMENT '用户输入兑奖时候的显示信息',
  `sttxt` varchar(200) NOT NULL COMMENT '简介',
  `startdate` int(11) NOT NULL COMMENT '活动开始时间',
  `enddate` int(11) NOT NULL COMMENT '活动结束时间',
  `info` varchar(200) NOT NULL COMMENT '活动说明',
  `aginfo` varchar(200) NOT NULL COMMENT '重复抽奖回复',
  `endtite` varchar(60) NOT NULL COMMENT '活动结束公告主题',
  `endpicurl` varchar(100) NOT NULL,
  `endinfo` varchar(60) NOT NULL,
  `fist` varchar(50) NOT NULL COMMENT '一等奖奖品设置',
  `fistnums` int(4) NOT NULL COMMENT '一等奖奖品数量',
  `fistlucknums` int(1) NOT NULL COMMENT '一等奖中奖号码',
  `second` varchar(50) NOT NULL COMMENT '二等奖奖品设置',
  `type` tinyint(1) NOT NULL,
  `secondnums` int(4) NOT NULL,
  `secondlucknums` int(1) NOT NULL,
  `third` varchar(50) NOT NULL,
  `thirdnums` int(4) NOT NULL,
  `thirdlucknums` int(1) NOT NULL,
  `allpeople` int(11) NOT NULL,
  `canrqnums` int(2) NOT NULL COMMENT '个人限制抽奖次数',
  `parssword` int(15) NOT NULL,
  `renamesn` int(20) NOT NULL,
  `renametel` varchar(60) NOT NULL,
  `displayjpnums` int(1) NOT NULL,
  `createtime` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  `four` varchar(50) NOT NULL,
  `fournums` int(11) NOT NULL,
  `fourlucknums` int(11) NOT NULL,
  `five` varchar(50) NOT NULL,
  `fivenums` int(11) NOT NULL,
  `fivelucknums` int(11) NOT NULL,
  `six` varchar(50) NOT NULL COMMENT '六等奖',
  `sixnums` int(11) NOT NULL,
  `sixlucknums` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*Data for the table `v_lottery` */


/*Table structure for table `v_lottery_record` */

DROP TABLE IF EXISTS `v_lottery_record`;

CREATE TABLE `v_lottery_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lid` int(11) NOT NULL,
  `usenums` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户使用次数',
  `wecha_id` varchar(60) NOT NULL COMMENT '微信唯一识别码',
  `token` varchar(30) NOT NULL,
  `islottery` int(1) NOT NULL COMMENT '是否中奖',
  `wecha_name` varchar(60) NOT NULL COMMENT '微信号',
  `phone` varchar(15) NOT NULL,
  `sn` varchar(13) NOT NULL COMMENT '中奖后序列号',
  `time` int(11) NOT NULL,
  `prize` varchar(50) NOT NULL DEFAULT '' COMMENT '已中奖项',
  `sendstutas` int(11) NOT NULL DEFAULT '0',
  `sendtime` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`lid`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

/*Data for the table `v_lottery_record` */


/*Table structure for table `v_marrycard` */

DROP TABLE IF EXISTS `v_marrycard`;

CREATE TABLE `v_marrycard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `joinnum` int(11) NOT NULL COMMENT '有效参与人数',
  `click` int(11) NOT NULL COMMENT '浏览数',
  `token` varchar(255) NOT NULL COMMENT '微信TOKEN',
  `keyword` varchar(255) NOT NULL COMMENT '关键词',
  `title` varchar(255) NOT NULL COMMENT '回复标题',
  `info` varchar(255) NOT NULL COMMENT '内容介绍',
  `picurl` varchar(255) NOT NULL COMMENT '回复图片',
  `husband` varchar(255) NOT NULL DEFAULT 'AI9' COMMENT '新郎',
  `wife` varchar(255) NOT NULL DEFAULT '微信' COMMENT '新娘',
  `contents` varchar(255) NOT NULL COMMENT '要说的话',
  `startdate` int(11) NOT NULL COMMENT '活动开始时间',
  `enddate` int(11) NOT NULL COMMENT '活动结束时间',
  `partytime` int(11) NOT NULL COMMENT '宴会时间',
  `readytitle` varchar(255) NOT NULL COMMENT '活动未开始公告主题',
  `readyinfo` varchar(255) NOT NULL COMMENT '活动未开始提示信息',
  `endtite` varchar(255) NOT NULL COMMENT '活动结束公告主题',
  `endpicurl` varchar(255) NOT NULL COMMENT '活动结束回复图片',
  `endinfo` varchar(255) NOT NULL COMMENT '活动结束提示信息',
  `address` varchar(255) NOT NULL COMMENT '宴会地址',
  `tel` varchar(255) NOT NULL COMMENT '接待电话',
  `thumbpic` varchar(255) NOT NULL COMMENT '封面合照',
  `video` varchar(255) NOT NULL COMMENT '婚礼视频',
  `bgmusic` varchar(255) NOT NULL COMMENT '背景音乐',
  `photo_1` varchar(255) NOT NULL COMMENT '照片1',
  `photo_2` varchar(255) NOT NULL COMMENT '照片2',
  `photo_3` varchar(255) NOT NULL COMMENT '照片3',
  `photo_4` varchar(255) NOT NULL COMMENT '照片4',
  `photo_5` varchar(255) NOT NULL COMMENT '照片5',
  `createtime` int(11) NOT NULL COMMENT '创建时间',
  `status` int(1) NOT NULL COMMENT '活动状态,0:未开始,1:开始,大于等于2:结束',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `v_marrycard` */


/*Table structure for table `v_marrycard_wish` */

DROP TABLE IF EXISTS `v_marrycard_wish`;

CREATE TABLE `v_marrycard_wish` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `imcid` int(11) NOT NULL COMMENT '微喜帖ID',
  `type` varchar(60) NOT NULL DEFAULT 'wish' COMMENT '类型,join:赴宴,wish:祝福',
  `wecha_id` varchar(60) NOT NULL COMMENT '微信唯一识别码',
  `token` varchar(60) NOT NULL COMMENT '微信TOKEN',
  `wecha_name` varchar(60) NOT NULL COMMENT '微信号',
  `guestname` varchar(60) NOT NULL COMMENT '宾客姓名',
  `wishcontent` varchar(255) NOT NULL COMMENT '祝福语',
  `mobilephone` varchar(60) NOT NULL COMMENT '宾客手机',
  `num` int(11) NOT NULL DEFAULT '0' COMMENT '赴宴人数',
  `creattime` int(11) NOT NULL COMMENT '创建时间',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`imcid`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

/*Data for the table `v_marrycard_wish` */


/*Table structure for table `v_member` */

DROP TABLE IF EXISTS `v_member`;

CREATE TABLE `v_member` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `nickname` char(16) NOT NULL DEFAULT '' COMMENT '昵称',
  `sex` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '性别',
  `birthday` date NOT NULL DEFAULT '0000-00-00' COMMENT '生日',
  `qq` char(10) NOT NULL DEFAULT '' COMMENT 'qq号',
  `score` mediumint(8) NOT NULL DEFAULT '0' COMMENT '用户积分',
  `login` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `reg_ip` bigint(20) NOT NULL DEFAULT '0' COMMENT '注册IP',
  `reg_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `last_login_ip` bigint(20) NOT NULL DEFAULT '0' COMMENT '最后登录IP',
  `last_login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '会员状态',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=9 COMMENT='会员表';

/*Data for the table `v_member` */


/*Table structure for table `v_menu` */

DROP TABLE IF EXISTS `v_menu`;

CREATE TABLE `v_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `tip` varchar(255) NOT NULL DEFAULT '' COMMENT '提示',
  `group` varchar(50) DEFAULT '' COMMENT '分组',
  `is_dev` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否仅开发者模式可见',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=135 DEFAULT CHARSET=utf8;

/*Data for the table `v_menu` */

insert  into `v_menu`(`id`,`title`,`pid`,`sort`,`url`,`hide`,`tip`,`group`,`is_dev`) values (1,'首页',0,1,'Index/index',0,'','',0),(2,'内容',0,2,'Article/mydocument',0,'','',0),(3,'文档列表',2,0,'article/index',1,'','内容',0),(4,'新增',3,0,'article/add',0,'','',0),(5,'编辑',3,0,'article/edit',0,'','',0),(6,'改变状态',3,0,'article/setStatus',0,'','',0),(7,'保存',3,0,'article/update',0,'','',0),(8,'保存草稿',3,0,'article/autoSave',0,'','',0),(9,'移动',3,0,'article/move',0,'','',0),(10,'复制',3,0,'article/copy',0,'','',0),(11,'粘贴',3,0,'article/paste',0,'','',0),(12,'导入',3,0,'article/batchOperate',0,'','',0),(13,'回收站',2,0,'article/recycle',1,'','内容',0),(14,'还原',13,0,'article/permit',0,'','',0),(15,'清空',13,0,'article/clear',0,'','',0),(16,'用户',0,3,'User/index',0,'','',0),(17,'用户信息',16,0,'User/index',0,'','用户管理',0),(18,'新增用户',17,0,'User/add',0,'添加新用户','',0),(19,'用户行为',16,0,'User/action',0,'','行为管理',0),(20,'新增用户行为',19,0,'User/addaction',0,'','',0),(21,'编辑用户行为',19,0,'User/editaction',0,'','',0),(22,'保存用户行为',19,0,'User/saveAction',0,'\"用户->用户行为\"保存编辑和新增的用户行为','',0),(23,'变更行为状态',19,0,'User/setStatus',0,'\"用户->用户行为\"中的启用,禁用和删除权限','',0),(24,'禁用会员',19,0,'User/changeStatus?method=forbidUser',0,'\"用户->用户信息\"中的禁用','',0),(25,'启用会员',19,0,'User/changeStatus?method=resumeUser',0,'\"用户->用户信息\"中的启用','',0),(26,'删除会员',19,0,'User/changeStatus?method=deleteUser',0,'\"用户->用户信息\"中的删除','',0),(27,'权限管理',16,0,'AuthManager/index',0,'','用户管理',0),(28,'删除',27,0,'AuthManager/changeStatus?method=deleteGroup',0,'删除用户组','',0),(29,'禁用',27,0,'AuthManager/changeStatus?method=forbidGroup',0,'禁用用户组','',0),(30,'恢复',27,0,'AuthManager/changeStatus?method=resumeGroup',0,'恢复已禁用的用户组','',0),(31,'新增',27,0,'AuthManager/createGroup',0,'创建新的用户组','',0),(32,'编辑',27,0,'AuthManager/editGroup',0,'编辑用户组名称和描述','',0),(33,'保存用户组',27,0,'AuthManager/writeGroup',0,'新增和编辑用户组的\"保存\"按钮','',0),(34,'授权',27,0,'AuthManager/group',0,'\"后台 \\ 用户 \\ 用户信息\"列表页的\"授权\"操作按钮,用于设置用户所属用户组','',0),(35,'访问授权',27,0,'AuthManager/access',0,'\"后台 \\ 用户 \\ 权限管理\"列表页的\"访问授权\"操作按钮','',0),(36,'成员授权',27,0,'AuthManager/user',0,'\"后台 \\ 用户 \\ 权限管理\"列表页的\"成员授权\"操作按钮','',0),(37,'解除授权',27,0,'AuthManager/removeFromGroup',0,'\"成员授权\"列表页内的解除授权操作按钮','',0),(38,'保存成员授权',27,0,'AuthManager/addToGroup',0,'\"用户信息\"列表页\"授权\"时的\"保存\"按钮和\"成员授权\"里右上角的\"添加\"按钮)','',0),(39,'分类授权',27,0,'AuthManager/category',0,'\"后台 \\ 用户 \\ 权限管理\"列表页的\"分类授权\"操作按钮','',0),(40,'保存分类授权',27,0,'AuthManager/addToCategory',0,'\"分类授权\"页面的\"保存\"按钮','',0),(41,'模型授权',27,0,'AuthManager/modelauth',0,'\"后台 \\ 用户 \\ 权限管理\"列表页的\"模型授权\"操作按钮','',0),(42,'保存模型授权',27,0,'AuthManager/addToModel',0,'\"分类授权\"页面的\"保存\"按钮','',0),(43,'扩展',0,7,'Addons/index',0,'','',0),(44,'插件管理',43,1,'Addons/index',0,'','扩展',0),(45,'创建',44,0,'Addons/create',0,'服务器上创建插件结构向导','',0),(46,'检测创建',44,0,'Addons/checkForm',0,'检测插件是否可以创建','',0),(47,'预览',44,0,'Addons/preview',0,'预览插件定义类文件','',0),(48,'快速生成插件',44,0,'Addons/build',0,'开始生成插件结构','',0),(49,'设置',44,0,'Addons/config',0,'设置插件配置','',0),(50,'禁用',44,0,'Addons/disable',0,'禁用插件','',0),(51,'启用',44,0,'Addons/enable',0,'启用插件','',0),(52,'安装',44,0,'Addons/install',0,'安装插件','',0),(53,'卸载',44,0,'Addons/uninstall',0,'卸载插件','',0),(54,'更新配置',44,0,'Addons/saveconfig',0,'更新插件配置处理','',0),(55,'插件后台列表',44,0,'Addons/adminList',0,'','',0),(56,'URL方式访问插件',44,0,'Addons/execute',0,'控制是否有权限通过url访问插件控制器方法','',0),(57,'钩子管理',43,2,'Addons/hooks',0,'','扩展',0),(58,'模型管理',68,3,'Model/index',0,'','系统设置',0),(59,'新增',58,0,'model/add',0,'','',0),(60,'编辑',58,0,'model/edit',0,'','',0),(61,'改变状态',58,0,'model/setStatus',0,'','',0),(62,'保存数据',58,0,'model/update',0,'','',0),(63,'属性管理',68,0,'Attribute/index',1,'网站属性配置。','',0),(64,'新增',63,0,'Attribute/add',0,'','',0),(65,'编辑',63,0,'Attribute/edit',0,'','',0),(66,'改变状态',63,0,'Attribute/setStatus',0,'','',0),(67,'保存数据',63,0,'Attribute/update',0,'','',0),(68,'系统',0,5,'Config/group',0,'','',0),(69,'网站设置',68,1,'Config/group',0,'','系统设置',0),(70,'配置管理',68,4,'Config/index',0,'','系统设置',0),(71,'编辑',70,0,'Config/edit',0,'新增编辑和保存配置','',0),(72,'删除',70,0,'Config/del',0,'删除配置','',0),(73,'新增',70,0,'Config/add',0,'新增配置','',0),(74,'保存',70,0,'Config/save',0,'保存配置','',0),(75,'菜单管理',68,5,'Menu/index',0,'','系统设置',0),(76,'导航管理',68,6,'Channel/index',0,'','系统设置',0),(77,'新增',76,0,'Channel/add',0,'','',0),(78,'编辑',76,0,'Channel/edit',0,'','',0),(79,'删除',76,0,'Channel/del',0,'','',0),(80,'分类管理',68,2,'Category/index',0,'','系统设置',0),(81,'编辑',80,0,'Category/edit',0,'编辑和保存栏目分类','',0),(82,'新增',80,0,'Category/add',0,'新增栏目分类','',0),(83,'删除',80,0,'Category/remove',0,'删除栏目分类','',0),(84,'移动',80,0,'Category/operate/type/move',0,'移动栏目分类','',0),(85,'合并',80,0,'Category/operate/type/merge',0,'合并栏目分类','',0),(86,'备份数据库',68,0,'Database/index?type=export',0,'','数据备份',0),(87,'备份',86,0,'Database/export',0,'备份数据库','',0),(88,'优化表',86,0,'Database/optimize',0,'优化数据表','',0),(89,'修复表',86,0,'Database/repair',0,'修复数据表','',0),(90,'还原数据库',68,0,'Database/index?type=import',0,'','数据备份',0),(91,'恢复',90,0,'Database/import',0,'数据库恢复','',0),(92,'删除',90,0,'Database/del',0,'删除备份文件','',0),(93,'其他',0,5,'other',0,'','',0),(96,'新增',75,0,'Menu/add',0,'','系统设置',0),(98,'编辑',75,0,'Menu/edit',0,'','',0),(104,'下载管理',102,0,'Think/lists?model=download',0,'','',0),(105,'配置管理',102,0,'Think/lists?model=config',0,'','',0),(106,'行为日志',16,0,'Action/actionlog',0,'','行为管理',0),(108,'修改密码',16,0,'User/updatePassword',1,'','',0),(109,'修改昵称',16,0,'User/updateNickname',1,'','',0),(110,'查看行为日志',106,0,'action/edit',1,'','',0),(112,'新增数据',58,0,'think/add',1,'','',0),(113,'编辑数据',58,0,'think/edit',1,'','',0),(114,'导入',75,0,'Menu/import',0,'','',0),(115,'生成',58,0,'Model/generate',0,'','',0),(116,'新增钩子',57,0,'Addons/addHook',0,'','',0),(117,'编辑钩子',57,0,'Addons/edithook',0,'','',0),(118,'文档排序',3,0,'Article/sort',1,'','',0),(119,'排序',70,0,'Config/sort',1,'','',0),(120,'排序',75,0,'Menu/sort',1,'','',0),(121,'排序',76,0,'Channel/sort',1,'','',0),(122,'公共账号',0,4,'Site/index',0,'','',0),(123,'公共账号',122,0,'Site/index',0,'','公共账号',0),(124,'解决方案',122,0,'SiteGroup/index',0,'','公共账号',0),(127,'编辑',124,0,'AccountGroup/edit',0,'','',0),(126,'添加',124,0,'AccountGroup/add',0,'','',0),(128,'编辑',123,0,'Account/edit',0,'','',0),(129,'更换方案',123,0,'Account/changeGroup',0,'','',0),(130,'权限列表',122,0,'SiteAccess/index',0,'','公共账号',0),(131,'添加',130,0,'AccountAccess/add	',0,'','',0),(132,'编辑',130,0,'AccountAccess/edit',0,'','',0),(133,'入款',16,0,'User/addmoney',0,'','财务管理',0),(134,'财务记录',16,0,'User/paylog',0,'','财务管理',0);

/*Table structure for table `v_menuplus` */

DROP TABLE IF EXISTS `v_menuplus`;

CREATE TABLE `v_menuplus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `url` varchar(20) DEFAULT NULL,
  `sort` smallint(2) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `picurl` varchar(100) DEFAULT NULL,
  `link` varchar(20) DEFAULT NULL COMMENT '内部链接',
  `itemid` int(11) NOT NULL DEFAULT '0' COMMENT '指定id',
  `siteid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

/*Data for the table `v_menuplus` */


/*Table structure for table `v_model` */

DROP TABLE IF EXISTS `v_model`;

CREATE TABLE `v_model` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '模型ID',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '模型标识',
  `title` char(30) NOT NULL DEFAULT '' COMMENT '模型名称',
  `extend` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '继承的模型',
  `relation` varchar(30) NOT NULL DEFAULT '' COMMENT '继承与被继承模型的关联字段',
  `need_pk` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '新建表时是否需要主键字段',
  `field_sort` text NOT NULL COMMENT '表单字段排序',
  `field_group` varchar(255) NOT NULL DEFAULT '1:基础' COMMENT '字段分组',
  `attribute_list` text NOT NULL COMMENT '属性列表（表的字段）',
  `template_list` varchar(100) NOT NULL DEFAULT '' COMMENT '列表模板',
  `template_add` varchar(100) NOT NULL DEFAULT '' COMMENT '新增模板',
  `template_edit` varchar(100) NOT NULL DEFAULT '' COMMENT '编辑模板',
  `list_grid` text NOT NULL COMMENT '列表定义',
  `list_row` smallint(2) unsigned NOT NULL DEFAULT '10' COMMENT '列表数据长度',
  `search_key` varchar(50) NOT NULL DEFAULT '' COMMENT '默认搜索字段',
  `search_list` varchar(255) NOT NULL DEFAULT '' COMMENT '高级搜索的字段',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `engine_type` varchar(25) NOT NULL DEFAULT 'MyISAM' COMMENT '数据库引擎',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 COMMENT='文档模型表';

/*Data for the table `v_model` */

insert  into `v_model`(`id`,`name`,`title`,`extend`,`relation`,`need_pk`,`field_sort`,`field_group`,`attribute_list`,`template_list`,`template_add`,`template_edit`,`list_grid`,`list_row`,`search_key`,`search_list`,`create_time`,`update_time`,`status`,`engine_type`) values (1,'document','基础文档',0,'',1,'{\"1\":[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"19\",\"20\",\"21\",\"22\"]}','1:基础','','','','','id:编号\r\ntitle:标题:article/index?cate_id=[category_id]&pid=[id]\r\ntype|get_document_type:类型\r\nlevel:优先级\r\nupdate_time|time_format:最后更新\r\nstatus_text:状态\r\nview:浏览\r\nid:操作:[EDIT]&cate_id=[category_id]|编辑,article/setstatus?status=-1&ids=[id]|删除',0,'','',1383891233,1384507827,1,'MyISAM'),(2,'article','文章',1,'',1,'{\"1\":[\"3\",\"24\",\"2\",\"5\"],\"2\":[\"9\",\"13\",\"19\",\"10\",\"12\",\"16\",\"17\",\"26\",\"20\",\"14\",\"11\",\"25\"]}','1:基础,2:扩展','','','','','id:编号\r\ntitle:标题:article/edit?cate_id=[category_id]&id=[id]\r\ncontent:内容',0,'','',1383891243,1387260622,1,'MyISAM'),(3,'download','下载',1,'',1,'{\"1\":[\"3\",\"28\",\"30\",\"32\",\"2\",\"5\",\"31\"],\"2\":[\"13\",\"10\",\"27\",\"9\",\"12\",\"16\",\"17\",\"19\",\"11\",\"20\",\"14\",\"29\"]}','1:基础,2:扩展','','','','','id:编号\r\ntitle:标题',0,'','',1383891252,1387260449,1,'MyISAM');

/*Table structure for table `v_node` */

DROP TABLE IF EXISTS `v_node`;

CREATE TABLE `v_node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `title` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `remark` varchar(255) DEFAULT NULL,
  `sort` smallint(6) unsigned DEFAULT NULL,
  `pid` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `level` (`level`),
  KEY `pid` (`pid`),
  KEY `status` (`status`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=45 COMMENT='权限节点表';

/*Data for the table `v_node` */

insert  into `v_node`(`id`,`name`,`title`,`status`,`remark`,`sort`,`pid`,`level`) values (1,'Admin','后台管理',1,'网站后台管理项目',10,0,1),(2,'Index','管理首页',1,'',1,1,2),(3,'Member','注册会员管理',1,'',3,1,2),(4,'Webinfo','系统管理',1,'',4,1,2),(5,'index','默认页',1,'',5,2,3),(6,'myInfo','我的个人信息',1,'',6,2,3),(7,'index','会员首页',1,'',7,3,3),(8,'index','管理员列表',1,'',8,14,3),(9,'addAdmin','添加管理员',1,'',9,14,3),(10,'index','系统设置首页',1,'',10,4,3),(11,'setEmailConfig','设置系统邮件',1,'',12,4,3),(12,'testEmailConfig','发送测试邮件',1,'',0,4,3),(13,'setSafeConfig','系统安全设置',1,'',0,4,3),(14,'Access','权限管理',1,'权限管理，为系统后台管理员设置不同的权限',0,1,2),(15,'nodeList','查看节点',1,'节点列表信息',0,14,3),(16,'roleList','角色列表查看',1,'角色列表查看',0,14,3),(17,'addRole','添加角色',1,'',0,14,3),(18,'editRole','编辑角色',1,'',0,14,3),(19,'opNodeStatus','便捷开启禁用节点',1,'',0,14,3),(20,'opRoleStatus','便捷开启禁用角色',1,'',0,14,3),(21,'editNode','编辑节点',1,'',0,14,3),(22,'addNode','添加节点',1,'',0,14,3),(23,'addAdmin','添加管理员',1,'',0,14,3),(24,'editAdmin','编辑管理员信息',1,'',0,14,3),(25,'changeRole','权限分配',1,'',0,14,3),(26,'News','资讯管理',1,'',0,1,2),(27,'index','新闻列表',1,'',0,26,3),(28,'category','新闻分类管理',1,'',0,26,3),(29,'add','发布新闻',1,'',0,26,3),(30,'edit','编辑新闻',1,'',0,26,3),(31,'del','删除信息',0,'',0,26,3),(32,'SysData','数据库管理',1,'包含数据库备份、还原、打包等',0,1,2),(33,'index','查看数据库表结构信息',1,'',0,32,3),(34,'backup','备份数据库',1,'',0,32,3),(35,'restore','查看已备份SQL文件',1,'',0,32,3),(36,'restoreData','执行数据库还原操作',1,'',0,32,3),(37,'delSqlFiles','删除SQL文件',1,'',0,32,3),(38,'sendSql','邮件发送SQL文件',1,'',0,32,3),(39,'zipSql','打包SQL文件',1,'',0,32,3),(40,'zipList','查看已打包SQL文件',1,'',0,32,3),(41,'unzipSqlfile','解压缩ZIP文件',1,'',0,32,3),(42,'delZipFiles','删除zip压缩文件',1,'',0,32,3),(43,'downFile','下载备份的SQL,ZIP文件',1,'',0,32,3),(44,'repair','数据库优化修复',1,'',0,32,3);

/*Table structure for table `v_order` */

DROP TABLE IF EXISTS `v_order`;

CREATE TABLE `v_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '用户',
  `phone` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `come_time` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `old_price` int(11) DEFAULT NULL,
  `now_price` int(11) DEFAULT NULL,
  `info` text,
  `add_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `v_order` */

/*Table structure for table `v_ordering_class` */

DROP TABLE IF EXISTS `v_ordering_class`;

CREATE TABLE `v_ordering_class` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `name` varchar(10) NOT NULL,
  `sort` tinyint(2) NOT NULL,
  `info` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `v_ordering_class` */

/*Table structure for table `v_ordering_set` */

DROP TABLE IF EXISTS `v_ordering_set`;

CREATE TABLE `v_ordering_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `keyword` varchar(10) NOT NULL,
  `title` varchar(60) NOT NULL,
  `info` varchar(120) NOT NULL,
  `picurl` varchar(100) NOT NULL,
  `flash` text NOT NULL,
  `create_time` tinyint(1) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `v_ordering_set` */

/*Table structure for table `v_panoramic` */

DROP TABLE IF EXISTS `v_panoramic`;

CREATE TABLE `v_panoramic` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '全景相册展示',
  `picurl` varchar(255) NOT NULL,
  `sort` int(10) NOT NULL DEFAULT '1',
  `click` int(10) NOT NULL DEFAULT '0',
  `frontpic` varchar(255) NOT NULL,
  `rightpic` varchar(255) NOT NULL,
  `backpic` varchar(255) NOT NULL,
  `leftpic` varchar(255) NOT NULL,
  `toppic` varchar(255) NOT NULL,
  `bottompic` varchar(255) NOT NULL,
  `intro` varchar(255) NOT NULL,
  `createtime` int(10) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 COMMENT='全景相册';

/*Data for the table `v_panoramic` */


/*Table structure for table `v_paylog` */

DROP TABLE IF EXISTS `v_paylog`;

CREATE TABLE `v_paylog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `gid` tinyint(2) NOT NULL,
  `uname` varchar(60) NOT NULL,
  `title` varchar(60) NOT NULL,
  `info` int(11) NOT NULL,
  `indent_id` char(20) NOT NULL,
  `widtrade_no` int(20) NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `create_time` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `income` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

/*Data for the table `v_paylog` */


/*Table structure for table `v_picture` */

DROP TABLE IF EXISTS `v_picture`;

CREATE TABLE `v_picture` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id自增',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片链接',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `siteid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8;

/*Data for the table `v_picture` */


/*Table structure for table `v_product` */

DROP TABLE IF EXISTS `v_product`;

CREATE TABLE `v_product` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `catid` mediumint(4) NOT NULL DEFAULT '0',
  `storeid` mediumint(4) NOT NULL DEFAULT '0',
  `name` varchar(150) NOT NULL DEFAULT '',
  `price` float NOT NULL DEFAULT '0',
  `oprice` float NOT NULL DEFAULT '0',
  `discount` float NOT NULL DEFAULT '10',
  `intro` text NOT NULL,
  `token` varchar(50) NOT NULL,
  `keyword` varchar(100) NOT NULL DEFAULT '',
  `salecount` mediumint(4) NOT NULL DEFAULT '0',
  `logourl` varchar(150) NOT NULL DEFAULT '',
  `dining` tinyint(1) NOT NULL DEFAULT '0',
  `groupon` tinyint(1) NOT NULL DEFAULT '0',
  `endtime` int(10) NOT NULL DEFAULT '0',
  `fakemembercount` mediumint(4) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`,`storeid`) USING BTREE,
  KEY `catid_2` (`catid`) USING BTREE,
  KEY `storeid` (`storeid`) USING BTREE,
  KEY `token` (`token`) USING BTREE,
  KEY `price` (`price`) USING BTREE,
  KEY `oprice` (`oprice`) USING BTREE,
  KEY `discount` (`discount`) USING BTREE,
  KEY `dining` (`dining`) USING BTREE,
  KEY `groupon` (`groupon`,`endtime`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

/*Data for the table `v_product` */


/*Table structure for table `v_product_cart` */

DROP TABLE IF EXISTS `v_product_cart`;

CREATE TABLE `v_product_cart` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(50) NOT NULL DEFAULT '',
  `wecha_id` varchar(60) NOT NULL DEFAULT '',
  `info` varchar(300) NOT NULL DEFAULT '',
  `total` mediumint(4) NOT NULL DEFAULT '0',
  `price` float NOT NULL DEFAULT '0',
  `truename` varchar(20) NOT NULL DEFAULT '',
  `tel` varchar(14) NOT NULL DEFAULT '',
  `address` varchar(100) NOT NULL DEFAULT '',
  `diningtype` mediumint(2) NOT NULL DEFAULT '0',
  `tableid` mediumint(4) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `buytime` varchar(100) NOT NULL DEFAULT '',
  `groupon` tinyint(1) NOT NULL DEFAULT '0',
  `dining` tinyint(1) NOT NULL DEFAULT '0',
  `year` mediumint(4) NOT NULL DEFAULT '0',
  `month` mediumint(4) NOT NULL DEFAULT '0',
  `day` mediumint(4) NOT NULL DEFAULT '0',
  `hour` smallint(4) NOT NULL DEFAULT '0',
  `printed` tinyint(1) NOT NULL DEFAULT '0',
  `handled` tinyint(1) NOT NULL DEFAULT '0',
  `paid` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态,0为未付款,1为已付款',
  `sn` varchar(60) NOT NULL COMMENT '订单号',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`,`time`) USING BTREE,
  KEY `groupon` (`groupon`) USING BTREE,
  KEY `dining` (`dining`) USING BTREE,
  KEY `printed` (`printed`) USING BTREE,
  KEY `year` (`year`,`month`,`day`,`hour`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

/*Data for the table `v_product_cart` */


/*Table structure for table `v_product_cart_list` */

DROP TABLE IF EXISTS `v_product_cart_list`;

CREATE TABLE `v_product_cart_list` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cartid` int(10) NOT NULL DEFAULT '0',
  `productid` int(10) NOT NULL DEFAULT '0',
  `price` float NOT NULL DEFAULT '0',
  `total` mediumint(4) NOT NULL DEFAULT '0',
  `wecha_id` varchar(60) NOT NULL DEFAULT '',
  `token` varchar(50) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cartid` (`cartid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

/*Data for the table `v_product_cart_list` */


/*Table structure for table `v_product_cat` */

DROP TABLE IF EXISTS `v_product_cat`;

CREATE TABLE `v_product_cat` (
  `id` mediumint(4) NOT NULL AUTO_INCREMENT,
  `token` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL,
  `des` varchar(500) NOT NULL DEFAULT '',
  `parentid` mediumint(4) NOT NULL,
  `logourl` varchar(100) NOT NULL,
  `dining` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parentid` (`parentid`) USING BTREE,
  KEY `token` (`token`) USING BTREE,
  KEY `dining` (`dining`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*Data for the table `v_product_cat` */


/*Table structure for table `v_product_diningtable` */

DROP TABLE IF EXISTS `v_product_diningtable`;

CREATE TABLE `v_product_diningtable` (
  `id` mediumint(4) NOT NULL AUTO_INCREMENT,
  `token` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `intro` varchar(500) NOT NULL DEFAULT '',
  `taxis` mediumint(4) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `v_product_diningtable` */


/*Table structure for table `v_reply_info` */

DROP TABLE IF EXISTS `v_reply_info`;

CREATE TABLE `v_reply_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `title` varchar(30) NOT NULL DEFAULT '',
  `picurl` varchar(120) NOT NULL DEFAULT '',
  `info` varchar(120) NOT NULL DEFAULT '',
  `infotype` varchar(20) NOT NULL DEFAULT '',
  `diningyuding` tinyint(1) NOT NULL DEFAULT '1',
  `diningwaimai` tinyint(1) NOT NULL DEFAULT '1',
  `config` text NOT NULL,
  `if_pay` tinyint(1) NOT NULL COMMENT '支付方式,0为关闭,1为开启',
  `pay_type` tinyint(1) NOT NULL COMMENT '支付方式,0为在线支付,1为货到付款',
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*Data for the table `v_reply_info` */


/*Table structure for table `v_role` */

DROP TABLE IF EXISTS `v_role`;

CREATE TABLE `v_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `pid` smallint(6) DEFAULT NULL,
  `status` tinyint(1) unsigned DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 COMMENT='权限角色表';

/*Data for the table `v_role` */

insert  into `v_role`(`id`,`name`,`pid`,`status`,`remark`) values (1,'超级管理员',0,1,'系统内置超级管理员组，不受权限分配账号限制'),(2,'管理员',1,1,'拥有系统仅此于超级管理员的权限'),(3,'领导',1,1,'拥有所有操作的读权限，无增加、删除、修改的权限'),(4,'测试组',1,1,'测试');

/*Table structure for table `v_role_user` */

DROP TABLE IF EXISTS `v_role_user`;

CREATE TABLE `v_role_user` (
  `role_id` mediumint(9) unsigned DEFAULT NULL,
  `user_id` char(32) DEFAULT NULL,
  KEY `group_id` (`role_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM COMMENT='用户角色表';

/*Data for the table `v_role_user` */

/*Table structure for table `v_room` */

DROP TABLE IF EXISTS `v_room`;

CREATE TABLE `v_room` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(50) NOT NULL,
  `keyword` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `address` varchar(50) NOT NULL,
  `tel` varchar(13) NOT NULL,
  `tel2` varchar(13) NOT NULL,
  `ppicurl` varchar(250) NOT NULL,
  `headpic` varchar(250) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sort` int(11) NOT NULL,
  `picurl` varchar(100) NOT NULL,
  `url` varchar(50) NOT NULL,
  `info` text NOT NULL,
  `info2` text NOT NULL,
  `creattime` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

/*Data for the table `v_room` */


/*Table structure for table `v_room_list_add` */

DROP TABLE IF EXISTS `v_room_list_add`;

CREATE TABLE `v_room_list_add` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hid` int(11) NOT NULL,
  `token` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `typeinfo` varchar(100) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `yhprice` decimal(10,2) NOT NULL,
  `name` varchar(50) NOT NULL,
  `picurl` varchar(110) NOT NULL,
  `url` varchar(100) NOT NULL,
  `info` text NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `v_room_list_add` */


/*Table structure for table `v_room_order` */

DROP TABLE IF EXISTS `v_room_order`;

CREATE TABLE `v_room_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(50) NOT NULL,
  `wecha_id` varchar(50) NOT NULL,
  `book_people` varchar(50) NOT NULL,
  `tel` varchar(13) NOT NULL,
  `check_in` int(11) NOT NULL,
  `check_out` int(11) NOT NULL,
  `room_type` varchar(50) NOT NULL,
  `book_time` int(11) NOT NULL,
  `book_num` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL COMMENT ' ',
  `order_status` int(11) NOT NULL COMMENT ' ',
  `hid` int(11) NOT NULL,
  `remarks` varchar(250) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `v_room_order` */


/*Table structure for table `v_site` */

DROP TABLE IF EXISTS `v_site`;

CREATE TABLE `v_site` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `wxname` varchar(60) NOT NULL COMMENT '公众号名称',
  `wxid` varchar(20) NOT NULL COMMENT '公众号原始ID',
  `weixin` char(20) NOT NULL COMMENT '微信号',
  `headerpic` char(255) NOT NULL COMMENT '头像地址',
  `token` char(255) NOT NULL,
  `province` varchar(30) NOT NULL COMMENT '省',
  `city` varchar(60) NOT NULL COMMENT '市',
  `qq` char(25) NOT NULL COMMENT '公众号邮箱',
  `wxfans` int(11) NOT NULL COMMENT '微信粉丝',
  `typeid` int(11) NOT NULL COMMENT '分类ID',
  `typename` varchar(90) NOT NULL DEFAULT '0' COMMENT '分类名',
  `tongji` text NOT NULL,
  `createtime` varchar(13) NOT NULL,
  `tpltypeid` varchar(2) NOT NULL DEFAULT '1' COMMENT '默认首页模版ID',
  `updatetime` varchar(13) NOT NULL,
  `tpltypename` varchar(20) NOT NULL DEFAULT 'index_1' COMMENT '首页模版名',
  `tpllistid` varchar(2) NOT NULL DEFAULT '1' COMMENT '列表模版ID',
  `tpllistname` varchar(20) NOT NULL DEFAULT 'list_1' COMMENT '列表模版名',
  `tplcontentid` varchar(2) NOT NULL DEFAULT '1' COMMENT '内容模版ID',
  `tplcontentname` varchar(20) NOT NULL DEFAULT 'content_1' COMMENT '内容模版名',
  `allcardnum` int(11) NOT NULL,
  `yetcardnum` int(11) NOT NULL,
  `cardisok` int(11) NOT NULL,
  `totalcardnum` int(11) NOT NULL,
  `phone` text NOT NULL,
  `smsstatus` text NOT NULL,
  `smsuser` text NOT NULL,
  `smspassword` text NOT NULL,
  `email` text NOT NULL,
  `emailstatus` text NOT NULL,
  `emailuser` text NOT NULL,
  `emailpassword` text NOT NULL,
  `headpicurl` varchar(255) DEFAULT NULL COMMENT '相册头部',
  `qrcode` varchar(255) DEFAULT NULL COMMENT '二维码',
  `groupid` tinyint(2) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` int(11) DEFAULT NULL,
  `end_date` int(11) DEFAULT NULL,
  `access` varchar(500) NOT NULL,
  `activitynum` int(11) NOT NULL DEFAULT '0',
  `color_id` smallint(2) NOT NULL DEFAULT '0',
  `wx_appid` varchar(20) DEFAULT NULL,
  `wx_appsecret` varchar(50) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `picurl` varchar(100) DEFAULT NULL,
  `info` varchar(500) DEFAULT NULL,
  `homebgurl` varchar(100) DEFAULT NULL,
  `menupluscolor` varchar(50) DEFAULT NULL,
  `copyright` varchar(100) DEFAULT NULL,
  `menuplusstyle` tinyint(2) DEFAULT NULL,
  `domain` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `uid_2` (`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*Data for the table `v_site` */
insert  into `v_site`(`id`,`uid`,`wxname`,`wxid`,`weixin`,`headerpic`,`token`,`province`,`city`,`qq`,`wxfans`,`typeid`,`typename`,`tongji`,`createtime`,`tpltypeid`,`updatetime`,`tpltypename`,`tpllistid`,`tpllistname`,`tplcontentid`,`tplcontentname`,`allcardnum`,`yetcardnum`,`cardisok`,`totalcardnum`,`phone`,`smsstatus`,`smsuser`,`smspassword`,`email`,`emailstatus`,`emailuser`,`emailpassword`,`headpicurl`,`qrcode`,`groupid`,`status`,`start_date`,`end_date`,`access`,`activitynum`,`color_id`,`wx_appid`,`wx_appsecret`,`title`,`picurl`,`info`,`homebgurl`,`menupluscolor`,`copyright`,`menuplusstyle`,`domain`) values (1,1,'网人公司','test','iwangren','/Template/User/Public/images/portrait.jpg','apitoken','河北','石家庄','web@china800.net',0,4,'','','1385608765','14','1387423006','index_14','2','list_2','1','content_1',10000,301,1,301,'','','','','','0','756613544','WR123456','/Uploads/User/1/1/532bf1b10047f.jpg',NULL,5,1,NULL,NULL,'Areply,Text,Voiceresponse,Company,Stats,DefaultResponse,Home,Tmpls,Classify,Img,Diymenu,Flash,Album,Preview,Product,Lottery,Coupon,Tuan,Ordering,Guajiang,Goldegg,Room,Marrycard,Freeform,Dmpage,Panoramic,ReplyInfo,VuserCard,Vuser',5,4,'','','欢迎进入微官方','/Uploads/User/1/1/532c0cdbadc56.png','网人互联提供微营销、网站建设、系统开发、域名主机等',NULL,'#FFFFFF','© 2013-2014 网人 版权所有',3,'v');

/*Table structure for table `v_site_access` */

DROP TABLE IF EXISTS `v_site_access`;

CREATE TABLE `v_site_access` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `ename` varchar(50) NOT NULL,
  `cname` varchar(50) NOT NULL,
  `module` varchar(50) DEFAULT NULL,
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0',
  `isclass` tinyint(1) NOT NULL DEFAULT '0',
  KEY `groupId` (`id`),
  KEY `nodeId` (`ename`)
) ENGINE=MyISAM AUTO_INCREMENT=39 COMMENT='账户权限表';

/*Data for the table `v_site_access` */

insert  into `v_site_access`(`id`,`ename`,`cname`,`module`,`sort`,`isclass`) values (1,'Album','相册',NULL,17,1),(2,'Areply','关注回复',NULL,1,0),(3,'Classify','网站分类',NULL,13,0),(4,'Company','LBS回复',NULL,4,0),(5,'Coupon','优惠券',NULL,22,1),(7,'DefaultResponse','默认回复',NULL,6,0),(8,'Diymenu','DIY菜单',NULL,15,0),(9,'Dmpage','宣传页',NULL,27,0),(11,'Flash','幻灯片',NULL,16,0),(12,'Freeform','自由表单',NULL,26,1),(14,'Goldegg','砸金蛋',NULL,24,1),(15,'Guajiang','刮刮卡',NULL,23,1),(16,'Home','微网站',NULL,11,0),(17,'Img','图文回复',NULL,14,0),(19,'Lottery','转大盘',NULL,21,1),(21,'Marrycard','微喜帖',NULL,25,1),(22,'Ordering','微餐饮',NULL,23,1),(23,'Panoramic','360全景',NULL,28,1),(25,'Preview','预览',NULL,17,0),(26,'Product','微商城',NULL,21,1),(28,'ReplyInfo','回复设置',NULL,29,0),(29,'Room','酒店KTV',NULL,24,1),(30,'Stats','统计',NULL,5,0),(31,'Text','文字回复',NULL,2,0),(32,'Tmpls','网站模板',NULL,12,0),(33,'Tuan','微团购',NULL,22,1),(36,'Voiceresponse','语音回复',NULL,3,0),(37,'VuserCard','会员卡',NULL,31,1),(38,'Vuser','微会员',NULL,32,1);

/*Table structure for table `v_site_group` */

DROP TABLE IF EXISTS `v_site_group`;

CREATE TABLE `v_site_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `diynum` int(11) NOT NULL,
  `connectnum` int(11) NOT NULL,
  `iscopyright` tinyint(1) NOT NULL,
  `activitynum` int(3) NOT NULL,
  `price` int(11) NOT NULL,
  `statistics_user` int(11) NOT NULL,
  `create_card_num` int(4) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `wechat_card_num` int(4) NOT NULL DEFAULT '4',
  `year_price` decimal(10,2) DEFAULT '0.00',
  `access` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

/*Data for the table `v_site_group` */

insert  into `v_site_group`(`id`,`name`,`diynum`,`connectnum`,`iscopyright`,`activitynum`,`price`,`statistics_user`,`create_card_num`,`status`,`wechat_card_num`,`year_price`,`access`) values (1,'基础套餐',100,1000,1,1,2000,0,0,1,1,'200.00','Areply,Text,Voiceresponse,Company,Stats,DefaultResponse,Home,Tmpls,Classify,Img,Diymenu,Flash,Album'),(2,'专业套餐',150,1500,1,3,3000,0,3000,1,1,'3000.00','Areply,Text,Voiceresponse,Company,Stats,DefaultResponse,Home,Tmpls,Classify,Img,Diymenu,Flash,Album'),(3,'电商套餐',300,3000,0,6,6000,0,6000,1,1,'6000.00','Areply,Text,Voiceresponse,Company,Stats,DefaultResponse,Home,Tmpls,Classify,Img,Diymenu,Flash,Album'),(4,'行业套餐',600,6000,0,10,8000,0,8000,1,2,'8000.00','Areply,Text,Voiceresponse,Company,Stats,DefaultResponse,Home,Tmpls,Classify,Img,Diymenu,Flash,Album'),(5,'全能套餐',1000,10000,1,200,10000,0,10000,1,3,'1300.00','Areply,Text,Voiceresponse,Company,Stats,DefaultResponse,Home,Tmpls,Classify,Img,Diymenu,Flash,Album,Preview,Product,Lottery,Coupon,Tuan,Ordering,Guajiang,Goldegg,Room,Marrycard,Freeform,Dmpage,Panoramic,ReplyInfo,VuserCard,Vuser');

/*Table structure for table `v_sncode` */

DROP TABLE IF EXISTS `v_sncode`;

CREATE TABLE `v_sncode` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(1) NOT NULL,
  `status` int(1) NOT NULL,
  `wechaname` varchar(60) NOT NULL,
  `caeatetime` int(11) NOT NULL,
  `phone` int(11) NOT NULL,
  `token` varchar(30) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `v_sncode` */


/*Table structure for table `v_stat` */

DROP TABLE IF EXISTS `v_stat`;

CREATE TABLE `v_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `year` int(4) NOT NULL,
  `month` int(2) NOT NULL,
  `day` int(2) NOT NULL,
  `time` int(11) NOT NULL,
  `textnum` int(5) NOT NULL,
  `imgnum` int(5) NOT NULL,
  `videonum` int(5) NOT NULL,
  `other` int(5) NOT NULL,
  `follownum` int(5) NOT NULL,
  `unfollownum` int(5) NOT NULL,
  `3g` int(5) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8;

/*Data for the table `v_stat` */


/*Table structure for table `v_text` */

DROP TABLE IF EXISTS `v_text`;

CREATE TABLE `v_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `uname` varchar(90) NOT NULL,
  `keyword` char(255) NOT NULL,
  `type` varchar(1) NOT NULL,
  `text` text NOT NULL,
  `createtime` varchar(13) NOT NULL,
  `updatetime` varchar(13) NOT NULL,
  `click` int(11) NOT NULL,
  `token` char(30) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

/*Data for the table `v_text` */


/*Table structure for table `v_ucenter_admin` */

DROP TABLE IF EXISTS `v_ucenter_admin`;

CREATE TABLE `v_ucenter_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '管理员ID',
  `member_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员用户ID',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '管理员状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM COMMENT='管理员表';

/*Data for the table `v_ucenter_admin` */

/*Table structure for table `v_ucenter_app` */

DROP TABLE IF EXISTS `v_ucenter_app`;

CREATE TABLE `v_ucenter_app` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '应用ID',
  `title` varchar(30) NOT NULL COMMENT '应用名称',
  `url` varchar(100) NOT NULL COMMENT '应用URL',
  `ip` char(15) NOT NULL COMMENT '应用IP',
  `auth_key` varchar(100) NOT NULL COMMENT '加密KEY',
  `sys_login` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '同步登陆',
  `allow_ip` varchar(255) NOT NULL COMMENT '允许访问的IP',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '应用状态',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM COMMENT='应用表';

/*Data for the table `v_ucenter_app` */

/*Table structure for table `v_ucenter_member` */

DROP TABLE IF EXISTS `v_ucenter_member`;

CREATE TABLE `v_ucenter_member` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `username` char(16) NOT NULL COMMENT '用户名',
  `password` char(32) NOT NULL COMMENT '密码',
  `email` char(32) NOT NULL COMMENT '用户邮箱',
  `mobile` char(15) NOT NULL COMMENT '用户手机',
  `reg_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `reg_ip` bigint(20) NOT NULL DEFAULT '0' COMMENT '注册IP',
  `last_login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `last_login_ip` bigint(20) NOT NULL DEFAULT '0' COMMENT '最后登录IP',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) DEFAULT '0' COMMENT '用户状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=9 COMMENT='用户表';

/*Data for the table `v_ucenter_member` */


/*Table structure for table `v_ucenter_setting` */

DROP TABLE IF EXISTS `v_ucenter_setting`;

CREATE TABLE `v_ucenter_setting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '设置ID',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '配置类型（1-用户配置）',
  `value` text NOT NULL COMMENT '配置数据',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM COMMENT='设置表';

/*Data for the table `v_ucenter_setting` */

/*Table structure for table `v_url` */

DROP TABLE IF EXISTS `v_url`;

CREATE TABLE `v_url` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '链接唯一标识',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `short` char(100) NOT NULL DEFAULT '' COMMENT '短网址',
  `status` tinyint(2) NOT NULL DEFAULT '2' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_url` (`url`)
) ENGINE=MyISAM COMMENT='链接表';

/*Data for the table `v_url` */

/*Table structure for table `v_user_request` */

DROP TABLE IF EXISTS `v_user_request`;

CREATE TABLE `v_user_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(30) NOT NULL,
  `uid` varchar(32) NOT NULL,
  `keyword` varchar(100) NOT NULL,
  `msgtype` varchar(15) NOT NULL DEFAULT 'text',
  `time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `msgtype` (`msgtype`) USING BTREE,
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `v_user_request` */

/*Table structure for table `v_userdata` */

DROP TABLE IF EXISTS `v_userdata`;

CREATE TABLE `v_userdata` (
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(3) unsigned NOT NULL COMMENT '类型标识',
  `target_id` int(10) unsigned NOT NULL COMMENT '目标id',
  UNIQUE KEY `uid` (`uid`,`type`,`target_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `v_userdata` */

/*Table structure for table `v_voiceresponse` */

DROP TABLE IF EXISTS `v_voiceresponse`;

CREATE TABLE `v_voiceresponse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `uname` varchar(90) NOT NULL,
  `createtime` varchar(13) NOT NULL,
  `uptatetime` varchar(13) NOT NULL,
  `keyword` char(255) NOT NULL,
  `title` varchar(60) NOT NULL,
  `musicurl` char(255) NOT NULL,
  `hqmusicurl` char(255) NOT NULL,
  `description` char(255) NOT NULL,
  `token` char(30) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `v_voiceresponse` */


/*Table structure for table `v_vuser` */

DROP TABLE IF EXISTS `v_vuser`;

CREATE TABLE `v_vuser` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `wecha_id` varchar(60) NOT NULL,
  `wechaname` varchar(60) NOT NULL,
  `truename` varchar(60) NOT NULL,
  `tel` varchar(11) NOT NULL,
  `qq` int(11) NOT NULL,
  `sex` tinyint(1) NOT NULL,
  `age` int(3) NOT NULL,
  `birthday` varchar(11) NOT NULL,
  `address` varchar(100) NOT NULL,
  `info` varchar(200) NOT NULL,
  `continuous` int(11) NOT NULL DEFAULT '0',
  `sign_score` varchar(100) NOT NULL DEFAULT '0',
  `expend_score` varchar(100) NOT NULL DEFAULT '0',
  `total_score` varchar(100) NOT NULL DEFAULT '0',
  `add_expend_time` int(1) DEFAULT NULL,
  `add_expend` varchar(100) NOT NULL DEFAULT '0',
  `getcardtime` int(1) DEFAULT NULL,
  `live_time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser` */


/*Table structure for table `v_vuser_card_contact` */

DROP TABLE IF EXISTS `v_vuser_card_contact`;

CREATE TABLE `v_vuser_card_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `cname` varchar(30) NOT NULL,
  `tel` varchar(12) NOT NULL,
  `sort` tinyint(1) NOT NULL,
  `info` varchar(60) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_contact` */

/*Table structure for table `v_vuser_card_coupon` */

DROP TABLE IF EXISTS `v_vuser_card_coupon`;

CREATE TABLE `v_vuser_card_coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `title` varchar(60) NOT NULL,
  `group` tinyint(1) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `price` int(11) NOT NULL,
  `people` int(3) NOT NULL,
  `startdate` int(11) NOT NULL,
  `enddate` int(11) NOT NULL,
  `info` varchar(200) NOT NULL,
  `create_time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_coupon` */


/*Table structure for table `v_vuser_card_create` */

DROP TABLE IF EXISTS `v_vuser_card_create`;

CREATE TABLE `v_vuser_card_create` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `number` varchar(20) NOT NULL,
  `wecha_id` varchar(60) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=302 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_create` */


/*Table structure for table `v_vuser_card_exchange` */

DROP TABLE IF EXISTS `v_vuser_card_exchange`;

CREATE TABLE `v_vuser_card_exchange` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `everyday` tinyint(4) NOT NULL,
  `continuation` tinyint(4) NOT NULL,
  `reward` tinyint(4) NOT NULL,
  `cardinfo` varchar(200) NOT NULL,
  `cardinfo2` varchar(200) NOT NULL,
  `create_time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_exchange` */


/*Table structure for table `v_vuser_card_info` */

DROP TABLE IF EXISTS `v_vuser_card_info`;

CREATE TABLE `v_vuser_card_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `info` varchar(200) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `description` varchar(12) NOT NULL,
  `class` tinyint(1) NOT NULL,
  `password` varchar(11) NOT NULL,
  `crate_time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_info` */


/*Table structure for table `v_vuser_card_integral` */

DROP TABLE IF EXISTS `v_vuser_card_integral`;

CREATE TABLE `v_vuser_card_integral` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `title` varchar(60) NOT NULL,
  `integral` int(8) NOT NULL,
  `startdate` int(11) NOT NULL,
  `enddate` int(11) NOT NULL,
  `info` varchar(200) NOT NULL,
  `create_time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_integral` */


/*Table structure for table `v_vuser_card_set` */

DROP TABLE IF EXISTS `v_vuser_card_set`;

CREATE TABLE `v_vuser_card_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `cardname` varchar(60) NOT NULL,
  `logo` varchar(200) NOT NULL,
  `bg` varchar(100) NOT NULL,
  `diybg` varchar(200) NOT NULL,
  `msg` varchar(100) NOT NULL,
  `numbercolor` varchar(10) NOT NULL,
  `vipnamecolor` varchar(10) NOT NULL,
  `Lastmsg` varchar(100) NOT NULL,
  `vip` varchar(100) NOT NULL,
  `qiandao` varchar(100) NOT NULL,
  `shopping` varchar(100) NOT NULL,
  `memberinfo` varchar(100) NOT NULL,
  `membermsg` varchar(100) NOT NULL,
  `contact` varchar(100) NOT NULL,
  `create_time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_set` */


/*Table structure for table `v_vuser_card_sign` */

DROP TABLE IF EXISTS `v_vuser_card_sign`;

CREATE TABLE `v_vuser_card_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(50) NOT NULL,
  `wecha_id` varchar(50) NOT NULL,
  `sign_time` int(11) NOT NULL,
  `is_sign` int(11) NOT NULL,
  `expense` int(11) NOT NULL,
  `score_type` int(11) NOT NULL COMMENT ' ',
  `sell_expense` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_sign` */


/*Table structure for table `v_vuser_card_vip` */

DROP TABLE IF EXISTS `v_vuser_card_vip`;

CREATE TABLE `v_vuser_card_vip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(60) NOT NULL,
  `title` varchar(60) NOT NULL,
  `group` tinyint(1) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `startdate` int(11) NOT NULL,
  `enddate` int(11) NOT NULL,
  `info` varchar(200) NOT NULL,
  `create_time` int(11) NOT NULL,
  `siteid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `token` (`token`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*Data for the table `v_vuser_card_vip` */


/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
