<?php

/**
 * ZLOG-APIZƷ
 * @copyright (C)2011 Cenwor Inc.
 * @author Moyo <dev@uuland.org>
 * @package zlog
 * @name product.apiz.php
 * @version 1.0
 */

class productZLOG extends iMasterZLOG
{
	protected $zlogType = 'product';
	public function publish($pid, $data)
	{
		if ($data['saveHandler'] == 'draft')
		{
			$this->zlogCreate($pid, 'ѾΪƷID='.$data['draft'].'һݲݸ浵'.$data['flag']);
		}
		else
		{
			$this->zlogCreate($pid, 'Ʒ'.$data['flag'].'Ѿ');
		}
	}
	public function delete($pid, $data)
	{
		$dType = ($data['saveHandler'] == 'draft') ? 'ݸ' : 'Ʒ';
		$this->zlogCreate($pid, $dType.''.$data['flag'].'ѱɾ');
	}
	public function maintain($affected_rows)
	{
		$this->zlogCreate('system', 'ѾԶɶԲƷ״̬άӰƷ'.$affected_rows);
	}
	public function draftClear($sql, $aff)
	{
		$aff > 0 && $this->zlogCreate('system', 'ѾԶõĲƷݸ壬'.$aff, 'SQLɸѡ'.addslashes($sql));
	}
	public function saveError($pid, $because)
	{
		$this->zlogCreate($pid, 'ʱ'.$because);
	}
	public function update($pid, $newData)
	{
				if ($newData['saveHandler'] == 'draft') return;
		if (isset($newData['@extra']))
		{
			$newData = array_merge($newData, $newData['@extra']);
			unset($newData['@extra']);
		}
		$r = $this->dataCompare($pid, $newData);
		if ($r['cstring'] == '')
		{
			return;
		}
				$this->zlogCreate($pid, 'Ʒ'.$r['data']['flag'].'ݸ', $r['cstring']);
	}
	private function dataCompare($pid, $newData)
	{
		$cString = '';
		$oldData = logic('product')->SrcOne($pid);
		$oldData = array_merge($oldData, $this->getOldExtraData($pid));
		foreach ($newData as $k => $v)
		{
			$ov = isset($oldData[$k]) ? $oldData[$k] : false;
			if (!$ov) continue;
			if ($ov == $v) continue;
			if (is_string($v) && (strlen($ov) > 100 || strlen($v) > 100))
			{
				continue;
			}
			else
			{
				$cString .= '޸ <i><b>'.$this->dataFieldName($k).'</b></i> ֮ǰ <strike>'.htmlspecialchars($ov).'</strike>  '.htmlspecialchars($v).'';
			}
			$cString .= '<br/>';
		}
		return array('data' => $oldData, 'cstring' => $cString);
	}
	
	private function getOldExtraData($pid)
	{
		$r = array();
		if (post('__catalog_subclass_old'))
		{
			$r['category'] = post('__catalog_subclass_old', 'int');
		}
		else
		{
			$r['category'] = 0;
		}
		$r['hideseller'] = meta('p_hs_'.$pid) ? 'true' : 'false';
		$r['irebates'] = meta('p_ir_'.$pid) ? 'true' : 'false';
		$oExpressList = meta('expresslist_of_'.$pid);
		$r['expresslist'] = $oExpressList ? $oExpressList : '';
		$oPaymentList = meta('paymentlist_of_'.$pid);
		$r['specialPayment'] = $oPaymentList ? 'true' : 'false';
		$r['specialPaymentSel'] = $oPaymentList;
		return $r;
	}
	private function dataFieldName($k)
	{
		$m = array(
			'name' => 'Ʒ',
			'flag' => '',
			'city' => 'Ͷų',
			'display' => 'ʾʽ',
			'sellerid' => '̼',
			'order' => 'ʾȼ',
			'price' => 'ԭ',
			'nowprice' => 'Ź',
			'maxnum' => 'Ʒ',
			'begintime' => 'Źʼʱ',
			'overtime' => 'Źʱ',
			'type' => 'Ź',
			'perioddate' => 'ŹȯЧ',
			'allinone' => 'ȯһ',
			'weight' => 'Ʒ',
			'successnum' => 'ɹŹ',
			'virtualnum' => '⹺',
			'oncemax' => 'һ๺',
			'oncemin' => 'һٹ',
			'img' => 'ƷͼƬ',
			'multibuy' => 'Ƿι',
			'category' => 'Ʒ',
			'hideseller' => 'Ƿ̼Ϣ',
			'irebates' => 'Ƿ뷵',
			'expresslist' => 'ָͷʽб',
			'specialPayment' => 'Ƿʹͳһ֧ʽ',
			'specialPaymentSel' => 'ָ֧ʽб'
		);
		return isset($m[$k]) ? $m[$k] : $k;
	}
}

?>