<?php

/**
 * ߼
 * @copyright (C)2011 Cenwor Inc.
 * @author Moyo <dev@uuland.org>
 * @package logic
 * @name sort.logic.php
 * @version 1.0
 */

class SortManageLogic
{
	
	private $filterPools = array(
		'default' => array(
			'name' => 'Ĭ',
			'sql' => 'p.order DESC, p.id DESC'
		),
		'recent' => array(
			'name' => '',
			'title' => 'ϼʱʾ',
			'dir' => 'down',
			'sql' => 'p.begintime DESC'
		),
		'sells' => array(
			'name' => '',
			'title' => 'ղƷʾƷ',
			'dir' => 'down',
			'sql' => 'p.sells_count+p.virtualnum DESC'
		),
		'price-asc' => array(
			'name' => '۸()',
			'title' => 'ռ۸ӵ͵ʾ',
			'dir' => 'up',
			'sql' => 'p.nowprice ASC'
		),
		'price-desc' => array(
			'name' => '۸()',
			'title' => 'ռ۸Ӹߵʾ',
			'dir' => 'down',
			'sql' => 'p.nowprice DESC'
		)
	);
	
	public function filter_pools()
	{
		return $this->filterPools;
	}
	
	public function set_filter_pool($key, $config)
	{
		$this->filterPools[$key] = $config;
	}
	
	public function product_navigate()
	{
		$sortKey = $this->get_sort_key();
		$sorts = $this->filterPools;
		foreach ($sorts as $k => $data)
		{
			$sorts[$k]['url'] = logic('url')->create('product', array('sort' => $k));
			if ($sortKey == $k)
			{
				$sorts[$k]['selected'] = true;
			}
		}
		include handler('template')->file('home_sort_navigate');
	}
	
	public function product_sql_filter()
	{
		return $this->filterPools[$this->get_sort_key()]['sql'];
	}
	
	private function get_sort_key()
	{
		$sk = get('sort', 'string');
		return isset($this->filterPools[$sk]) ? $sk : 'default';
	}
}

?>