/*
 * artDialog iframeTools
 * Date: 2011-08-06 22:10
 * http://code.google.com/p/artdialog/
 * (c) 2009-2010 TangBin, http://www.planeArt.cn
 *
 * This is licensed under the GNU LGPL, version 2.1 or later.
 * For details, see: http://creativecommons.org/licenses/LGPL/2.1/
 */
 
;(function ($, window, artDialog, undefined) {

var _topDialog, _proxyDialog, _zIndex,
	_data = '@ARTDIALOG.DATA',
	_open = '@ARTDIALOG.OPEN',
	_opener = '@ARTDIALOG.OPENER',
	_winName = window.name = window.name || '@ARTDIALOG.WINNAME' + (new Date).getTime();

$(function () {
	!window.jQuery && document.compatMode === 'BackCompat'
	&& alert('artDialog Error: document.compatMode === "BackCompat"');
});
	
	
/** ȡ artDialog ɿ缶õ߲ window  */
var _top = artDialog.top = artDialog.parent = function () {
	var top = window,
	test = function (name) {
		try {
			var doc = window[name].document;	// |Ȩ
			doc.getElementsByTagName; 			// chrome ذȫ
		} catch (e) {
			return false;
		};
		// ܼ޷ʾԪ
		// bugfix @ 2011.08.16 by Moyo <dev@uuland.org>
		return window[name].artDialog && doc.getElementsByTagName('frameset').length === 0;
	};
	
	if (test('top')) {
		top = window.top;
	} else if (test('parent')) {
		top = window.parent;
	};
	
	return top;
}();


_topDialog = _top.artDialog;


// ȡҳԻֵ
_zIndex = function () {
	return _topDialog.defaults.zIndex;
};



/**
 * ݹӿ
 * @see		http://www.planeart.cn/?p=1554
 * @param	{String}	洢
 * @param	{Any}		Ҫ洢(޴򷵻رѯ)
 */
artDialog.data = function (name, value) {
	var top = artDialog.top,
		cache = top[_data] || {};
	top[_data] = cache;
	
	if (value) {
		cache[name] = value;
	} else {
		return cache[name];
	};
	return cache;
};


/**
 * ݹɾӿ
 * @param	{String}	ɾ
 */
artDialog.removeData = function (name) {
	var cache = artDialog.top[_data];
	if (cache && cache[name]) delete cache[name];
};


/** ͨԻ */
artDialog.through = _proxyDialog = function () {
	var api = _topDialog.apply(this, arguments);
		
	// ӵǰwindowΪiframeпܶԻwindowжغȫرЩԻ
	// ΪiframeעҲڴɾ䴴ĶԷֹص
	if (_top !== window) artDialog.list[api.config.id] = api;
	return api;
};

// ҳжǰرдԽĶԻ
_top !== window && $(window).bind('unload', function () {
	var list = artDialog.list;
	for (var i in list) {
		if (list[i]) {
			list[i].config.duration = 0; // ȡ
			list[i].close();
			delete list[i];
		};
	};
});


/**
 *  (iframe)
 * @param	{String}	ַ
 * @param	{Object}	ò. ﴫĻصյĵ1Ϊiframeڲwindow
 * @param	{Boolean}	Ƿ. Ĭtrue
 */
artDialog.open = function (url, options, cache) {
	options = options || {};
	
	var api, titleBar, loadInit, oldLocation,
		iframe, $iframe, $idoc, iwin, ibody,
		top = artDialog.top,
		iframeCss = 'width:100%;height:100%;border:none 0',
		title = options.title,
		$content, $main;
		
	if (cache === false) {
		var ts = (new Date()).getTime(),
			ret = url.replace(/([?&])_=[^&]*/, "$1_=" + ts );
		url = ret + ((ret === url) ? (/\?/.test(url) ? "&" : "?") + "_=" + ts : "");
	};
		
	var load = function () {
		var iWidth, iHeight, newLocation,
			loading = api.DOM.content.find('.aui_loading'),
			aConfig = api.config;
			
		titleBar.style.display = 'block';
		$content.addClass('aui_state_full');
		
		loading && loading.hide();
		
		iwin = iframe.contentWindow;
		try {
			ibody = iwin.document.body;// 
		} catch (e) {
			$iframe.unbind('load', load);
			loadInit = true;
			iframe.style.cssText = iframeCss;
			api.position(aConfig.left, aConfig.top);
			return;
		};
		
		$(iwin).bind('unload', unload);
		newLocation = iwin.location.href;
		if (newLocation === oldLocation) return;
		oldLocation = newLocation;
		$idoc = $(iwin.document);
		
		iWidth = aConfig.width === 'auto' ?
			$idoc.width() + parseInt($(ibody).css('marginLeft')) : aConfig.width;
		iHeight = aConfig.height === 'auto' ?
			$idoc.height() : aConfig.height;
			
		if (!loadInit) {
			setTimeout(function () {
				iframe.style.cssText = iframeCss;
			}, 0);// setTimeout: ֹIE6~7¶ԻʽȾ쳣
		};
		
		api.size(iWidth, iHeight);
		aConfig.follow ?
			api.follow(aConfig.follow) :
			api.position(aConfig.left, aConfig.top);
		
		!loadInit && options.initFn && options.initFn.call(api, iwin, top);
		loadInit = true;
	};
	
	var unload = function () {
		loadInit = false;
	};
		
	var config = {
		zIndex: _zIndex(),
		initFn: function () {
			api = this;
			var DOM = api.DOM;
			$main = DOM.main;
			$content = DOM.content;
			titleBar = DOM.titleBar[0];
			!title && (titleBar.style.display = 'none');
			
			iframe = api.iframe = top.document.createElement('iframe');
			iframe.src = url;
			iframe.name = 'Open' + api.config.id;
			iframe.style.cssText = 'position:absolute;left:-9999em;top:-9999em;border:none 0;background:transparent';
			iframe.setAttribute('frameborder', 0, 0);
			iframe.setAttribute('allowTransparency', true);
			$iframe = $(iframe);
			api.content().appendChild(iframe);
			
			iwin = iframe.contentWindow;
			
			try {
				iwin.name = iframe.name;
				artDialog.data(iframe.name + _open, api);
				artDialog.data(iframe.name + _opener, window);
				$(iwin).bind('unload', unload);
			} catch (e) {};
			
			$iframe.bind('load', load);
		},
		closeFn: function () {
			$iframe.css('display', 'none').unbind('load', load);
			
			options.closeFn && options.closeFn.call(this, iframe.contentWindow, top);
			$content.removeClass('aui_state_full');
			
			// ҪҪiframeַ´γֵĶԻIE67޷۽input
			// IEɾiframeiframeȻڴг⣬ûsrc׽ķ
			$iframe[0].src = 'about:blank';
			$iframe.remove();
			
			try {
				artDialog.removeData(iframe.name + _open);
				artDialog.removeData(iframe.name + _opener);
				$(iwin).unbind('unload', unload);
			} catch (e) {};
		}
	};
	
	// صһָiframeڲwindow
	if (typeof options.yesFn === 'function') config.yesFn = function () {
		return options.yesFn.call(api, iframe.contentWindow, top);
	};
	if (typeof options.noFn === 'function') config.noFn = function () {
		return options.noFn.call(api, iframe.contentWindow, top);
	};
	
	delete options.content;

	for (var i in options) {
		if (config[i] === undefined) config[i] = options[i];
	};
	
	return _proxyDialog(config);
};


/** openƽӿ(open򿪵iframeڲ˽з) */
artDialog.open.api = artDialog.data(_winName + _open);


/** openԴҳwindow(open򿪵iframeڲ˽з) */
artDialog.opener = artDialog.open.origin = artDialog.data(_winName + _opener) || window;


/** artDialog.open 򿪵iframeҳرնԻݷ */
artDialog.close = function () {
	var api = artDialog.data(_winName + _open);
	api && api.close();
	return false;
};

// iframeлӸ߶
_top != window && $(document).bind('mousedown', function () {
	var api = artDialog.open.api;
	api && api.zIndex();
});


/**
 * Ajax
 * @param	{String}			ַ
 * @param	{Object, String}	ò. ַʾʹģJSON
 * @param	{Boolean}			Ƿ. Ĭtrue
 */
artDialog.load = function(url, options, cache){
	cache = cache || false;
	var opt = options || {};
		
	var config = {
		zIndex: _zIndex(),
		initFn: function(here){
			var api = this,
				aConfig = api.config;
			
			$.ajax({
				url: url,
				success: function (content) {					
					api.content(content);
					aConfig.follow ?
						api.follow(aConfig.follow) :
						api.position(aConfig.left, aConfig.top);
	
					opt.initFn && opt.initFn.call(api, here);				
				},
				cache: cache
			});
			
		}
	};
	
	delete options.content;
	
	for (var i in opt) {
		if (config[i] === undefined) config[i] = opt[i];
	};
	
	return _proxyDialog(config);
};


/**
 * 
 * @param	{String}	Ϣ
 */
artDialog.alert = function (content) {
	return _proxyDialog({
		id: 'Alert',
		zIndex: _zIndex(),
		icon: 'warning',
		fixed: true,
		lock: true,
		content: content,
		yesFn: true
	});
};

/**
 * ɹ
 * @param    {String}    Ϣ
 */
artDialog.success = function (content) {
    return _proxyDialog({
        id: 'Success',
        zIndex: _zIndex(),
        icon: 'succeed',
        fixed: true,
        lock: false,
        content: content
    }).time(1.5);
};

/**
 * ʧ
 * @param    {String}    Ϣ
 */
artDialog.failed = function (content) {
    return _proxyDialog({
        id: 'Failed',
        zIndex: _zIndex(),
        icon: 'error',
        fixed: true,
        lock: true,
        content: content,
        yesFn: true
    });
};


/**
 * ȷ
 * @param	{String}	Ϣ
 * @param	{Function}	ȷťص
 * @param	{Function}	ȡťص
 */
artDialog.confirm = function (content, yes, no) {
	return _proxyDialog({
		id: 'Confirm',
		zIndex: _zIndex(),
		icon: 'question',
		fixed: true,
		lock: true,
		opacity: .1,
		content: content,
		yesFn: function (here) {
			return yes.call(this, here);
		},
		noFn: function (here) {
			return no && no.call(this, here);
		}
	});
};


/**
 * 
 * @param	{String}	
 * @param	{Function}	ص. ղֵ
 * @param	{String}	Ĭֵ
 */
artDialog.prompt = function (content, yes, value) {
	value = value || '';
	var input;
	
	return _proxyDialog({
		id: 'Prompt',
		zIndex: _zIndex(),
		icon: 'question',
		fixed: true,
		lock: true,
		opacity: .1,
		content: [
			'<div style="margin-bottom:5px;font-size:12px">',
				content,
			'</div>',
			'<div>',
				'<input value="',
					value,
				'" style="width:18em;padding:6px 4px" />',
			'</div>'
			].join(''),
		initFn: function () {
			input = this.DOM.content.find('input')[0];
			input.select();
			input.focus();
		},
		yesFn: function (here) {
			return yes && yes.call(this, input.value, here);
		},
		noFn: true
	});
};


/**
 * ʾ
 * @param	{String}	ʾ
 * @param	{Number}	ʾʱ (Ĭ1.5)
 */
artDialog.tips = function (content, time) {
	return _proxyDialog({
		id: 'Tips',
		zIndex: _zIndex(),
		title: false,
		noFn: false,
		fixed: true,
		lock: false
	})
	.content('<div style="padding: 0 1em;">' + content + '</div>')
	.position('50%', 'goldenRatio')
	.time(time || 1.5);
};

// extend

/**
 * ½֪ͨ
 */
art.dialog.notice = function (options) {
    var opt = options || {},
        api, aConfig, hide, wrap, top,
        duration = 800;
        
    var config = {
        id: 'Notice',
        left: '100%',
        top: '100%',
        fixed: true,
        drag: false,
        resize: false,
        follow: null,
        lock: false,
        initFn: function(here){
            api = this;
            aConfig = api.config;
            wrap = api.DOM.wrap;
            top = parseInt(wrap[0].style.top);
            hide = top + wrap[0].offsetHeight;
            
            wrap.css('top', hide + 'px')
                .animate({top: top + 'px'}, duration, function () {
                    opt.initFn && opt.initFn.call(api, here);
                });
        },
        closeFn: function(here){
            wrap.animate({top: hide + 'px'}, duration, function () {
                opt.closeFn && opt.closeFn.call(this, here);
                aConfig.closeFn = $.noop;
                api.close();
            });
            
            return false;
        }
    };    
    
    for (var i in opt) {
        if (config[i] === undefined) config[i] = opt[i];
    };
    
    return art.dialog(config);
};

/**
* eff . shake
*/
art.dialog.fn.shake = function (){
    var style = this.DOM.wrap[0].style,
        p = [4, 8, 4, 0, -4, -8, -4, 0],
        fx = function () {
            style.marginLeft = p.shift() + 'px';
            if (p.length <= 0) {
                style.marginLeft = 0;
                clearInterval(timerId);
            };
        };
    p = p.concat(p.concat(p));
    timerId = setInterval(fx, 13);
    return this;
};

// ǿartDialogק
// - ֹiframe²
// - ԳԻ϶Ż
$(function () {
	var event = artDialog.dragEvent;
	if (!event) return;

	var $window = $(window),
		$document = $(document),
		positionType = !-[1,] && !('minWidth' in document.documentElement.style)
		? 'absolute' : 'fixed',
		dragEvent = event.prototype,
		mask = document.createElement('div'),
		style = mask.style;
		
	style.cssText = 'display:none;position:' + positionType + ';left:0;top:0;width:100%;height:100%;'
	+ 'cursor:move;filter:alpha(opacity=0);opacity:0;background:#FFF';
		
	document.body.appendChild(mask);
	dragEvent._start = dragEvent.start;
	dragEvent._end = dragEvent.end;
	
	dragEvent.start = function () {
		var DOM = artDialog.focus.DOM,
			main = DOM.main[0],
			iframe = DOM.content[0].getElementsByTagName('iframe')[0];
		
		dragEvent._start.apply(this, arguments);
		style.display = 'block';
		style.zIndex = artDialog.defaults.zIndex + 3;
		
		if (positionType === 'absolute') {
			style.width = $window.width() + 'px';
			style.height = $window.height() + 'px';
			style.left = $document.scrollLeft() + 'px';
			style.top = $document.scrollTop() + 'px';
		};
		
		if (iframe && main.offsetWidth * main.offsetHeight > 160000) {
			main.style.visibility = 'hidden';
		};
	};
	
	dragEvent.end = function () {
		var dialog = artDialog.focus;
		dragEvent._end.apply(this, arguments);
		style.display = 'none';
		if (dialog) dialog.DOM.main[0].style.visibility = 'visible';
	};
});

})(window.jQuery || window.art, this, this.artDialog);



