/**
 * @copyright (C)2011 Cenwor Inc.
 * @author Moyo <dev@uuland.org>
 * @package js
 * @name buy.checkout.js
 * @date 2013-08-12 15:32:54
 */
 
var _allow_to_submit = {};
var __reg_price_list = {};

$(document).ready(function(){
	
});

function fizinit()
{
	$('#num_buys').bind('blur', function(){change_of_num_buys()});
	change_of_num_buys();
	$('#checkout_submit').bind('submit', function(){return checkout_submit()});
}

function change_of_num_buys()
{
	var num = parseInt($('#num_buys').val());
	var tips = '';
	if (isNaN(num))
	{
		$('#num_buys').val(oncemin);
	}
	else if (num < oncemin)
	{
		tips = 'Ҫ'+oncemin+'Ʒܲţ';
		$('#num_buys').val(oncemin);
	}
	else if (oncemax > 0 && num > oncemax)
	{
		tips = 'ֻܹ'+oncemax+'Ʒ';
		$('#num_buys').val(oncemax);
	}
	else if (num > surplus)
	{
		tips = 'Źֻʣ'+surplus+'Ʒˣ';
		$('#num_buys').val(surplus);
	}
	if (tips != '')
	{
		$('#num_buys').tipTip({
			content:tips,
			keepAlive:true,
			activation:"focus",
			defaultPosition:"top",
			edgeOffset:8,
			maxWidth:"300px"
		});
		$('#num_buys').focus();
		num = parseInt($('#num_buys').val());
	}
	else
	{
		$.hook.call('buys_num_change', num);
	}
	__reg_price_list['product'] = {value : price*num};
	price_calc();
    if (typeof(weight) != 'undefined')
    {
        weight_calc(num);
    }
}
/**
 * ͳƼ۸
 */
function price_calc(num)
{
	if (parseInt(num) > 0)
	{

	}
	else
	{
		num = parseInt($('#num_buys').val());
	}
	var total = 0;
	$.each(__reg_price_list, function(item, price) {
		if (!isNaN(parseFloat(price.value)))
		{
			var i_psv = price.csingle ? (parseFloat(price.value) * num) : parseFloat(price.value);
			$('#price_' + item).text(i_psv.toFixed(2));
			total += i_psv;
		}
	});
	$('#price_total').text(total.toFixed(2));
}
/**
* 
*/
function weight_calc(num)
{
    var wall = weight * num;
    var dsp =  wall>=1000?(Math.round(wall/10)/100)+' Kg':wall+' g';
    $('#product_weight').html(dsp);
}
/**
 * ע۸Ʒ
 * @param string id
 * @param string name
 * @param string calcMode
 */
function price_type_reg(id, name, calcMode)
{
	var fid = 'price_'+id;
	var price = __reg_price_list[id];
	if (price != undefined) return false;
	__reg_price_list[id] = {value : 0, csingle : calcMode == 'single' ? true : false};
	// ʾ
	$('#tr_price_total').before('<tr id="tr_'+fid+'"><td class="left"><font id="'+fid+'_name">'+name+'</font></td><td class="right">&yen; <font id="'+fid+'" class="price">0</font></td></tr>');
}
/**
 * ƷǷ
 * @param string id
 */
function price_type_exists(id)
{
	return __reg_price_list[id] == undefined ? false : true;
}
/**
 * ļƷ
 * @param string id
 * @param string newName
 * @param string calcMode
 */
function price_type_change(id, newName, calcMode)
{
	var fid = 'price_'+id+'_name';
	if ($('#'+fid).length < 1)
	{
		price_type_reg(id, newName, calcMode);
	}
	else
	{
		$('#'+fid).text(newName);
	}
}
/**
 * ɾƷ
 * @param string id
 */
function price_type_remove(id)
{
	delete __reg_price_list[id];
	$('#tr_price_'+id).remove();
	price_calc();
}
/**
 * ļƷѼ۸
 * @param string id
 * @param integer price
 * @param string calcMode
 */
function price_change(id, price, calcMode)
{
	__reg_price_list[id].value = price;
	if (calcMode)
	{
		__reg_price_list[id].csingle = calcMode == 'single' ? true : false;
	}
	price_calc();
}
/**
 * ѯֶǷ
 * @param string name
 */
function checkout_field_exists(name)
{
	var fid = 'field_'+name;
	return $('#'+fid).length > 0 ? true : false;
}
/**
 * һֶ
 * @param {Object} name
 * @param {Object} value
 */
function checkout_field_append(name, value)
{
	if (checkout_field_exists(name))
	{
		checkout_field_update(name, value);
	}
	else
	{
		var fid = 'field_'+name;
		$('#product_id').after('<input id="'+fid+'" type="hidden" name="'+name+'" value="'+value+'" />');
	}
}
/**
 * ±
 * @param string name
 * @param mixed value
 */
function checkout_field_update(name, value)
{
	if (checkout_field_exists(name))
	{
		var fid = 'field_'+name;
		$('#'+fid).val(value);
	}
	else
	{
		checkout_field_append(name, value);
	}
}
/**
 * ɾֶ
 * @param string name
 */
function checkout_field_remove(name)
{
	if (checkout_field_exists(name))
	{
		var fid = 'field_'+name;
		$('#'+fid).remove();
	}
}
/**
 * ύ
 */
function checkout_submit()
{
	$.hook.call('checkout_submit');
	if (if_allow_to_submit())
	{
		var num = parseInt($('#num_buys').val());
		checkout_field_append('num_buys', num);
		$('#checkout_submit').ajaxSubmit({
			beforeSubmit: function()
			{
				$('#checkout_submit_button').attr('disabled', true);
				$('#submit_status').text('ΪɶԺ...');
				$('#submit_status').css('display', 'inline');
			},
			success: function(data)
			{
				try {
					eval('var data='+data);
				} catch(e) {
					$('#submit_status').text('˴ԣ');
					return;
				}
				if (data.status != 'ok')
				{
					$('#submit_status').text(data.msg);
				}
				else
				{
					$('#submit_status').text('Ѿȡת...');
					order_finish(data.id);
				}
				$('#checkout_submit_button').attr('disabled', false);
			}
		});
	}
	return false;
}

function df_allow_to_submit(key, allow)
{
    _allow_to_submit[key] = allow;
}

function if_allow_to_submit()
{
    var _allow = true;
    $.each(_allow_to_submit, function(key, allow){
        if (!allow)
        {
            _allow = false;
        }
    });
    return _allow;
}