<?php
function module_flow_main()
{
	global $global;
	$global['step'] = get_global('step');
	$global['direct'] = get_global('direct');
	if($global['step'] == '' || $global['step'] == 'cart')
	{
		flow_cart();
	}elseif($global['step'] == 'consignee'){
		if($global['user_id'] != 0 || $global['direct'] != '')
		{
			flow_consignee();
		}else{
			flow_login();
		}
	}elseif($global['step'] == 'checkout'){
		flow_checkout();
	}elseif($global['step'] == 'done'){
		flow_done();
	}
}
function flow_cart()
{
	global $global,$smarty;
	$global['step'] = get_global('step');
	$cart = array();
	$shop_total = 0;
	$market_total = 0;
	$json = get_cart_json();
	if($json != '' && $json != 'null')
	{
		if($arr = json_decode($json,true))
		{
			$obj = new goods();
			$obj->set_field('goo_id,goo_title,goo_x_img,goo_market_price,goo_shop_price');
			for($i = 0;$i < count($arr);$i ++)
			{
				$id = key($arr);
				$obj->set_where('');
				$obj->set_where('goo_show = 1');
				$obj->set_where("goo_id = $id");
				$one = $obj->get_one();
				$one['goo_title'] = cut_str($one['goo_title'],11);
				$cart[$i] = $one;
				$cart[$i]['number'] = $arr[$id];
				$cart[$i]['subtotal'] = sprintf('%.2f',$cart[$i]['goo_shop_price'] * $arr[$id]);
				$shop_total += $cart[$i]['subtotal'];
				$market_total += sprintf('%.2f',$cart[$i]['goo_market_price'] * $arr[$id]);
				next($arr);
			}
		}
	}
	$smarty->assign('cart',$cart);
	$smarty->assign('shop_total',sprintf('%.2f',$shop_total));
	$smarty->assign('market_total',sprintf('%.2f',$market_total));	
	$smarty->assign('cut_down',sprintf('%.2f',$market_total - $shop_total));
	if($market_total != 0)
	{
		$smarty->assign('discount',sprintf('%d',($market_total - $shop_total) / $market_total * 100));
	}else{
		$smarty->assign('discount',0);
	}
}
function flow_consignee()
{
	global $global,$smarty;
	$arr = array();
	if($global['user_id'] != 0)
	{
		$obj = new consignee();
		$obj->set_where('con_user_id = '.$global['user_id']);
		$arr = $obj->get_list();
		$obj = new region();
		for($i = 0; $i < count($arr); $i ++)
		{
			$region[$i] = explode('|',$arr[$i]['con_region']);
			
			$obj->set_where('');
			$obj->set_where('reg_parent_id = 0');
			$arr[$i]['region_1'] = $obj->get_option(0,$region[$i][0]);
			
			$obj->set_where('');
			$obj->set_where('reg_parent_id = ' . $region[$i][0]);
			$arr[$i]['region_2'] = $obj->get_option($region[$i][0],$region[$i][1]);
			
			$obj->set_where('');
			$obj->set_where('reg_parent_id = ' . $region[$i][1]);
			$arr[$i]['region_3'] = $obj->get_option($region[$i][1],$region[$i][2]);
		}
		$obj->set_where('');
		$obj->set_where('reg_parent_id = 0');
		$con_region = $obj->get_option();
		$obj = new users();
		$obj->set_where('use_id = '.$global['user_id']);
		$one = $obj->get_one();
		if(count($one) > 0)
		{
			$con_consignee = $one['use_real_name'];
			$con_email = $one['use_email'];
			$con_address = $one['use_address'];
			$con_tel = $one['use_tel'];
		}else{
			rhs_error();
		}
	}else{
		$obj = new region();
		$obj->set_where('reg_parent_id = 0');
		$con_region = $obj->get_option();
		$con_consignee = '';
		$con_email = '';
		$con_address = '';
		$con_tel = '';
	}
	$smarty->assign('show_login',0);
	$smarty->assign('consignee',$arr);
	$smarty->assign('con_region',$con_region);
	$smarty->assign('con_consignee',$con_consignee);
	$smarty->assign('con_email',$con_email);
	$smarty->assign('con_address',$con_address);
	$smarty->assign('con_tel',$con_tel);
}
function flow_login()
{
	global $smarty;
	$smarty->assign('show_login',1);
}
function flow_checkout()
{
	global $smarty;
	flow_cart();
	$flag = false;
	$obj = new orders();
	while(!$flag)
	{
		$ord_sn = get_random(date('ymdHis'),3);
		$obj->set_where('');
		$obj->set_where("ord_sn = '$ord_sn'");
		if($obj->get_count() == 0)
		{
			$flag = true;
		}
	}
	$obj = new shipping();
	$shipping = $obj->get_list();
	
	$obj = new payment();
	$payment= $obj->get_list();
	$region_1 = post('region_1');
	$region_2 = post('region_2');
	$region_3 = post('region_3');
	if($region_1 == 0)
	{
		$region_2 = 0;
		$region_3 = 0;
	}elseif($region_2 == 0){
		$region_3 = 0;
	}
	$smarty->assign('ord_sn',$ord_sn);
	$smarty->assign('ord_region',$region_1.'|'.$region_2.'|'.$region_3);
	$smarty->assign('ord_consignee',post('consignee'));
	$smarty->assign('ord_email',post('email'));
	$smarty->assign('ord_address',post('address'));
	$smarty->assign('ord_zipcode',post('zipcode'));
	$smarty->assign('ord_tel',post('tel'));
	$smarty->assign('ord_mobile',post('mobile'));
	$smarty->assign('ord_building',post('building'));
	$smarty->assign('ord_best_time',post('best_time'));
	$smarty->assign('shipping',$shipping);
	$smarty->assign('payment',$payment);
}
function flow_done()
{
	global $global,$smarty;
	$price = array();
	$shop_total = 0;
	$market_total = 0;
	$ord_sn = post('sn');
	$ord_region = post('region');
	$ord_consignee = post('consignee');
	$ord_email = post('email');
	$ord_address = post('address');
	$ord_zipcode = post('zipcode');
	$ord_tel = post('tel');
	$ord_mobile = post('mobile');
	$ord_building = post('building');
	$ord_best_time = post('best_time');
	$ord_shipping_id = post('shipping');
	$ord_payment_id = post('payment');
	$ord_message = post('message');
	$ord_add_time = time();
	$json = get_cart_json();
	if($ord_region == '' || $ord_consignee == '' || $ord_email == '' || $ord_address == '' || $ord_tel == '' || $ord_shipping_id == '' || $ord_payment_id == '')
	{
		$smarty->assign('flow_done',0);
		$smarty->assign('info_text','对不起，您提交的订单信息不足!');
		$smarty->assign('link_text','返回购物车');
		$smarty->assign('link_href',url(array('channel'=>'flow')));
	}elseif($json == ''){
		$smarty->assign('flow_done',0);
		$smarty->assign('info_text','对不起，您还没有选择商品!');
		$smarty->assign('link_text','返回首页');
		$smarty->assign('link_href','index.php');
	}else{
		$flow_done = 1;
		$ord_goods_json = get_goods_json($json,$shop_total,$market_total);
		//处理配送区域region
		$arr = explode('|',$ord_region);
		$ord_region = '';
		for($i = 0;$i < count($arr);$i ++)
		{
			if($arr[$i] != '')
			{
				$ord_region .= get_data('region',$arr[$i],'reg_name');
				if($i != count($arr) - 1)
				{
					$ord_region .= '|';
				}
			}
		}
		//处理配送方式shipping
		$obj = new shipping();
		$obj->set_where("shi_id = $ord_shipping_id");
		$one = $obj->get_one();
		if(count($one) > 0)
		{
			$price['shipping'] = floatval($one['shi_price']);
			$ord_shipping_name = $one['shi_name'];
		}else{
			$price['shipping'] = 0;
			$ord_shipping_name = '';
		}
		//处理支付方式payment
		$obj = new payment();
		$obj->set_where("pay_id = $ord_payment_id");
		$one = $obj->get_one();
		if(count($one) > 0)
		{
			$price['payment'] = floatval($one['pay_price']);
			$ord_payment_name = $one['pay_name'];
			$pay_code = $one['pay_code'];
			$pay_text = $one['pay_text'];
		}else{
			$price['payment'] = 0;
			$ord_payment_name = '';
			$pay_code = '';
			$pay_text = '';
		}
		$price['shop_total'] = $shop_total;
		$price['market_total'] = $market_total;
		$ord_price_json = urlencode(json_encode($price));
		$ord_price_total = sprintf('%.2f',$price['shop_total'] + $price['shipping'] + $price['payment']);
		$obj = new orders();
		$obj->set_where("ord_sn = '$ord_sn'");
		if($obj->get_count() == 0)
		{
			if($pay_code == 'system')
			{
				$ord_status = 1;
			}else{
				$ord_status = 0;
			}
			
			//添加订单记录
			$obj->set_value('ord_user_id',$global['user_id']);
			$obj->set_value('ord_sn',$ord_sn);
			$obj->set_value('ord_goods_json',$ord_goods_json);
			$obj->set_value('ord_region',$ord_region);
			$obj->set_value('ord_consignee',$ord_consignee);
			$obj->set_value('ord_email',$ord_email);
			$obj->set_value('ord_address',$ord_address);
			$obj->set_value('ord_zipcode',$ord_zipcode);
			$obj->set_value('ord_tel',$ord_tel);
			$obj->set_value('ord_mobile',$ord_mobile);
			$obj->set_value('ord_building',$ord_building);
			$obj->set_value('ord_best_time',$ord_best_time);
			$obj->set_value('ord_message',$ord_message);
			$obj->set_value('ord_shipping_id',$ord_shipping_id);
			$obj->set_value('ord_shipping_name',$ord_shipping_name);
			$obj->set_value('ord_payment_id',$ord_payment_id);
			$obj->set_value('ord_payment_name',$ord_payment_name);
			$obj->set_value('ord_price_json',$ord_price_json);
			$obj->set_value('ord_price_total',$ord_price_total);
			$obj->set_value('ord_add_time',$ord_add_time);
			$obj->set_value('ord_status',$ord_status);
			$obj->set_value('ord_lang',S_LANG);
			$obj->add();
			set_cart_json('');
			
			//系统内置余额支付，未考虑余额不足
			if($pay_code == 'system')
			{
				$money = sprintf('%.2f',get_data('users',$global['user_id'],'use_money'));
				if($money >= $ord_price_total)
				{
					$obj = new account();
					$obj->set_value('acc_user_id',$global['user_id']);
					$obj->set_value('acc_sn',$ord_sn);
					$obj->set_value('acc_increase',0);
					$obj->set_value('acc_amount',$ord_price_total);
					$obj->set_value('acc_add_time',time());
					$obj->set_value('acc_edit_time',time());
					$obj->set_value('acc_status',2);
					$obj->add();
					
					$obj = new users();
					$obj->set_value('use_money',$money - $ord_price_total);
					$obj->set_where('use_id = '.$global['user_id']);
					$obj->edit();
				}else{
					$obj = new orders();
					$obj->set_where("ord_sn = '$ord_sn'");
					$obj->set_value('ord_status',0);
					$obj->edit();
					
					$flow_done = 0;
					$info_text= '对不起，您的余额不足，请充值后再支付!';
					$link_text= '查看订单';
					$link_href= url(array('channel'=>'user','mod'=>'order_sheet'));
				}
			}
		}else{
			$flow_done = 0;
			$info_text = '您的订单已提交，请不要重复下单!';
			$link_text = '查看订单';
			$link_href = url(array('channel'=>'user','mod'=>'order_sheet'));
		}
		if($flow_done)
		{
			$smarty->assign('flow_done',1);
			$smarty->assign('ord_sn',$ord_sn);
			$smarty->assign('ord_price_total',$ord_price_total);
			$smarty->assign('ord_shipping_name',$ord_shipping_name);
			$smarty->assign('ord_payment_name',$ord_payment_name);
			$smarty->assign('pay_code',$pay_code);
			$smarty->assign('pay_text',$pay_text);
		}else{
			$smarty->assign('flow_done',0);
			$smarty->assign('info_text',$info_text);
			$smarty->assign('link_text',$link_text);
			$smarty->assign('link_href',$link_href);
		}
	}
}
function get_goods_json($json,&$shop_total,&$market_total)
{
	$obj = new goods();
	$goods = array();
	if($json != '' && $json != 'null')
	{
		if($arr = json_decode($json,true))
		{
			for($i = 0;$i < count($arr);$i ++)
			{
				$id = key($arr);
				$obj->set_field('goo_id,goo_title,goo_x_img,goo_market_price,goo_shop_price,goo_add_time,goo_number');
				$obj->set_where("goo_id = $id");
				$list = $obj->get_list();
				$goods[$i] = $list[0];
				$goods[$i]['number'] = $arr[$id];
				$goods[$i]['subtotal'] = sprintf('%.2f',$goods[$i]['goo_shop_price'] * $arr[$id]);
				$obj->set_value('goo_number',$goods[$i]['goo_number'] - $arr[$id]);
				$obj->set_where("goo_id = $id");
				$obj->edit();
				$shop_total += $goods[$i]['subtotal'];
				$market_total += sprintf('%.2f',$goods[$i]['goo_market_price'] * $arr[$id]);
				next($arr);
			}
		}
	}
	return urlencode(json_encode($goods));
}
//红头船
?>