<?php
//模板扩展函数
function template_ext($template)
{
		//php标签
		/*
			{php echo phpinfo();}	=>	<?php echo phpinfo(); ?>
		 */
		$template = preg_replace ( "/\{php\s+(.+)\}/", "<?php \\1?>", $template );
		
		//if 标签
		/*
			{if $name==1}		=>	<?php if ($name==1){ ?>
			{elseif $name==2}	=>	<?php } elseif ($name==2){ ?>
			{else}				=>	<?php } else { ?>
			{/if}				=>	<?php } ?>
		 */
		$template = preg_replace ( "/\{if\s+(.+?)\}/", "<?php if(\\1) { ?>", $template );
		$template = preg_replace ( "/\{else\}/", "<?php } else { ?>", $template );
		$template = preg_replace ( "/\{elseif\s+(.+?)\}/", "<?php } elseif (\\1) { ?>", $template );
		$template = preg_replace ( "/\{\/if\}/", "<?php } ?>", $template );
		
		//碎片替换
        $template = preg_replace("/\{\\\$fragment\.([a-z0-9_]+)\}/iU",
        "<?php echo module('select')->fragment('$1'); ?>", $template);
		
	    //替换载入模板
	    $template = preg_replace('/<!--#lan:include\s*file=\"(.*)\"-->/iU',
	                    "<?php \$file=explode('.', \"$1\"); ?>{include file=\"".$lang_tpl."\\1\"}", $template);
	    $template = preg_replace('/<!--#lan:include\s*file=\'(.*)\'-->/iU',
	                    "<?php \$file=explode('.', \"$1\"); ?>{include file=\"".$lang_tpl."\\1]\"}", $template);

	    //字符截取
		$template = preg_replace ( "/\{(\\$[a-z0-9_]+)\.([a-z0-9_]+)\s+len\=\"(.*)\"\}/iU", "<?php echo msubstr($1['$2'],0,$3); ?>", $template);
		$template = preg_replace ( "/\{(\\$[a-z0-9_]+)\.([a-z0-9_]+)\.([a-z0-9_]+)\s+len\=\"(.*)\"\}/iU", "<?php echo msubstr($1[\'$2\'][\'$3\'],0,$4); ?>", $template);
		
		//for 标签
		/*
			{for $i=0;$i<10;$i++}	=>	<?php for($i=0;$i<10;$i++) { ?>
			{/for}					=>	<?php } ?>
		 */
		$template = preg_replace("/\{for\s+(.+?)\}/","<?php for(\\1) { ?>",$template);
		$template = preg_replace("/\{\/for\}/","<?php } ?>",$template);
		
		//loop 标签
		/*
			{loop $arr $vo}			=>	<?php $n=1; if (is_array($arr) foreach($arr as $vo){ ?>
			{loop $arr $key $vo}	=>	<?php $n=1; if (is_array($array) foreach($arr as $key => $vo){ ?>
			{/loop}					=>	<?php $n++;}unset($n) ?>
		 */
		$template = preg_replace ( "/\{loop\s+(\S+)\s+(\S+)\}/", "<?php \$n=1;if(is_array(\\1)) foreach(\\1 AS \\2) { ?>", $template );
		$template = preg_replace ( "/\{loop\s+(\S+)\s+(\S+)\s+(\S+)\}/", "<?php \$n=1; if(is_array(\\1)) foreach(\\1 AS \\2 => \\3) { ?>", $template );
		$template = preg_replace ( "/\{\/loop\}/", "<?php \$n++;}unset(\$n); ?>", $template );
		
		//函数 标签
		/*
			{date('Y-m-d H:i:s')}	=>	<?php echo date('Y-m-d H:i:s');?> 
			{$date('Y-m-d H:i:s')}	=>	<?php echo $date('Y-m-d H:i:s');?> 
		 */
		$template = preg_replace ( "/\{([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff:]*\(([^{}]*)\))\}/", "<?php echo \\1;?>", $template );
		$template = preg_replace ( "/\{(\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff:]*\(([^{}]*)\))\}/", "<?php echo \\1;?>", $template );
		
		//变量/常量 标签
		/*
			{$name}	=>	<?php echo $name; ?>
			{CONSTANCE}	=> <?php echo CONSTANCE;?>
		 */
		/*$template = preg_replace ( "/\{(\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\}/", "<?php echo \\1;?>", $template );*/
		/*$template = preg_replace("/\{(\\$[a-zA-Z0-9_\[\]\'\"\$\x7f-\xff]+)\}/es", "\$this->addquote('<?php echo \\1;?>')",$template);*/
		$template = preg_replace ( "/\{([A-Z_\x7f-\xff][A-Z0-9_\x7f-\xff]*)\}/s", "<?php echo \\1;?>", $template );	
	return $template;

}
?>