<?php
/*
    类名      FileUpload
    参数有
    $fileName   上传文件的表单name值
    $dir        上传文件保存的目录位置
    $randBoolean    一个布尔值，true为文件本身的名称，false为随机名称
    $type       允许文件上传类型

 */
    class FileUpload{
        private $fileName;      //保存上传图像的超全局数组
        private $dir;           //用户上传的指定目录
        private $randBoolean;   //是否要随机名，false为是，true为否
        private $type;          //限制用户上传的文件类型
        private $fileInfo;      //保存用户上传文件的信息
        private $errorMsg;      //保存错误信息
        private $errorBoolean   =   false;      //这个临时用来判断是否有错误信息出现
        private $file_hou;      //保存文件的后缀
        private $maxsize;       //文件的允许最大值
        private $uploadName;    //文件上传后的名称

        function __construct($fileName, $dir='uploads', $randBoolean, $maxsize=20000, $type=array("txt","jpg","png","gif","wbmp","rar")){
            $this->fileName =   $_FILES[$fileName];
            $this->getFileInfo();
            $this->dir      =   $dir;
            $this->randBoolean  =   $randBoolean;
            $this->type     =   $type;
            $this->maxsize  =   $maxsize;
        }

        //文件上传函数
        public function uploadFile(){
            if (is_array($this->fileInfo["name"])){
                for ($i=0; $i<count($this->fileInfo["name"]); $i++){
                    //echo $this->fileInfo["name"][$i]."<br />";

                    if (!$this->checkType($this->fileInfo["name"][$i])){
                        echo $this->getError();
                        continue;
                    }
                    $this->checkMaxSize($this->fileInfo["size"][$i], $this->fileInfo["name"][$i]);
                    if ($this->errorBoolean){
                        echo $this->getError();
                        continue;
                    }
                    $this->setErrorMsg($this->fileInfo["error"][$i], $this->fileInfo["name"][$i]);
                    if ($this->errorBoolean){
                        echo $this->getError();
                        continue;
                    }else {
                        if (is_uploaded_file($this->fileInfo["tmp_name"][$i])){
                            if (!$this->randBoolean){
                                $this->uploadName[$i]   =   $this->dir."/".time().$i.".".$this->file_hou;
                            }else {
                                $this->uploadName[$i]   =   $this->dir."/".$this->fileInfo["name"][$i];
                            }

                            if (move_uploaded_file($this->fileInfo["tmp_name"][$i],$this->uploadName[$i])){
                                echo $this->fileInfo["name"][$i];
                                echo "上传文件成功<br />";
                            }else {
                                echo "上传文件失败";
                            }
                        }else {
                            exit("非法操作");
                        }
                    }
                }
            }else {
                if (!$this->checkType($this->fileInfo["name"])){
                    echo $this->getError();
                    exit();
                }
                $this->checkMaxSize($this->fileInfo["size"],$this->fileInfo["name"]);
                if ($this->errorBoolean){
                    echo $this->getError();
                    exit();
                }
                $this->setErrorMsg($this->fileInfo["error"], $this->fileInfo["name"]);
                if ($this->errorBoolean){
                    echo $this->getError();
                    exit();
                }else {
                    if (is_uploaded_file($this->fileInfo["tmp_name"])){
                        $this->uploadName   =   $this->getPath();
                        if (move_uploaded_file($this->fileInfo["tmp_name"],$this->uploadName)){
                           // echo "上传文件成功";
                        }else {
                            echo "上传文件失败";
                        }
                    }else {
                        exit("非法操作");
                    }
                }
            }
        }
        //这里返回上传文件后文件的名称
        public function getUploadName($httpurl){
            return $httpurl.$this->uploadName;
        }
        //这个函数是得到上传错误信息
        public function getError(){
            return $this->errorMsg;
        }

        //得到上传文件的信息
        private function getFileInfo(){
            $this->fileInfo["name"] =   $this->fileName["name"];
            $this->fileInfo["tmp_name"] =   $this->fileName["tmp_name"];
            $this->fileInfo["type"] =   $this->fileName["type"];
            $this->fileInfo["error"]    =   $this->fileName["error"];
            $this->fileInfo["size"]     =   $this->fileName["size"];
        }

        //检查文件是不是符合上传类型
        private function checkType($name){
            $arrType    =   explode(".",$name);
            $type       =   strtolower($arrType[count($arrType)-1]);
            $this->file_hou =   $type;
            if (!in_array($type,$this->type)){
                $this->setErrorMsg(-1,$name);
                return false;
            }
            return true;
        }
        //检测最大值
        private function checkMaxSize($filesize,$name){
            if ($size   > $this->maxsize){
                $this->setErrorMsg(-2,$name);
            }
        }
        private function setErrorMsg($errorNum, $fileName){
            $errorMsg   =   "您上传的文件:<b>".$fileName."</b><font color=red> 出错</font>:错误原因<br />  ";
            switch ($errorNum){
                case 1:
                    $errorMsg   .=  "文件超过系统设置大小";
                    $this->errorBoolean =   true;
                    break;
                case -1:
                    $errorMsg   .=  "文件类型超出指定范围";
                    $this->errorBoolean =   true;
                    break;
                case 3:
                    $errorMsg   .=  "文件只有部分被上传";
                    $this->errorBoolean =   true;
                    break;
                case 4:
                    $errorMsg   .=  "没有文件被上传";
                    $this->errorBoolean =   true;
                    break;
                case -2:
                    $errorMsg   .=  "上传文件超表单指定大小";
                    $this->errorBoolean =   true;
                    break;
            }
            $this->errorMsg=$errorMsg;
        }
        //检查目录
        private function checkDir(){
            if (!file_exists($this->dir) || !is_writeable($this->dir)){
                if (!mkdir($this->dir, 0755)){
                    exit("创建文件失败");
                }
            }
        }

        //得到文件的名称
        private function getFileName(){
            if ($this->randBoolean){
                return $this->fileInfo["name"];
            }else {
                return time().".".$this->file_hou;
            }
        }
        //得到上传位置和名称
        private function getPath(){
           $this->checkDir();
            $name   =   $this->getFileName();
            return $this->dir."/".$name;
        }
    }
?>
