<?php

class robotsAction extends backendAction {


	private $_tbconfig = null;

	public function _initialize() {
        parent::_initialize();
        $this->_mod = D('robots');
        $this->_cate_mod = D('items_cate');
		$api_config = M('items_site')->where(array('code' => 'taobao'))->getField('config');
        $this->_tbconfig = unserialize($api_config);
    }

	 public function _before_index() {
        //分类信息
        $res = $this->_cate_mod->field('id,name')->select();
        $cate_list = array();
        foreach ($res as $val) {
            $cate_list[$val['id']] = $val['name'];
        }
        $this->assign('cate_list', $cate_list);

        //默认排序
        $this->sort = 'ordid ASC,';
        $this->order ='last_time DESC';
    }

	public function add(){
		if (IS_POST) {
			$name					= $this->_post('name', 'trim');
			$cid					= $this->_post('cid', 'trim');
			$cate_id				= $this->_post('cate_id', 'trim');
			$keyword				= $this->_post('keyword', 'trim');
			$page					= $this->_post('page', 'trim');
			$sort					= $this->_post('sort', 'trim');
			$start_commissionRate	= $this->_post('start_commissionRate', 'trim');
			$end_commissionRate		= $this->_post('end_commissionRate', 'trim');
			$start_coupon_rate		= $this->_post('start_coupon_rate', 'trim');
			$end_coupon_rate		= $this->_post('end_coupon_rate', 'trim');
			$start_volume			= $this->_post('start_volume', 'trim');
			$end_volume				= $this->_post('end_volume', 'trim');
			$start_price			= $this->_post('start_price', 'trim');
			$end_price				= $this->_post('end_price', 'trim');
			$start_credit			= $this->_post('start_credit', 'trim');
			$end_credit				= $this->_post('end_credit', 'trim');
			$shop_type				= $this->_post('shop_type', 'trim','all');
			$ems					= $this->_post('ems', 'trim');
			$tb_cid					= $this->_post('tb_cid', 'trim');
			$http_mode				= $this->_post('http_mode', 'trim');

			if( !$name||!trim($name) ){
				$this->error('请填写采集器名称');
			}
			if( !$cate_id||!trim($cate_id) ){
				$this->error('请选择商品分类');
			}

			if($http_mode == 1){
				//淘宝网采集
				if(!$keyword && !$tb_cid) {
					 $this->error('请填写关键词或者填写淘宝网分类ID');
				}
				if($start_price > $end_price){
					$this->error('最低价格不能高于最高价格');
				}
			}else{
				//API采集
				if (!$keyword && !$cid) {
					$this->error('请填写关键词或选择API分类');
				}
				if($start_commissionRate > $end_commissionRate){
					$this->error('起始佣金不能高于最高佣金');
				}
			}
			
			if($start_coupon_rate > $end_coupon_rate){
				$this->error('最低折扣不能高于最高折扣');
			}
			if($start_volume > $end_volume){
				$this->error('最低销量不能高于最高销量');
			}

			$data['name'] = $name;
			$data['cid'] = $cid;
			$data['cate_id'] = $cate_id;
			$data['keyword'] = $keyword;
			$data['page'] = $page;
			$data['sort'] = $sort;
			$data['start_commissionRate'] = $start_commissionRate;
			$data['end_commissionRate'] = $end_commissionRate;
			$data['start_coupon_rate'] = $start_coupon_rate;
			$data['end_coupon_rate'] = $end_coupon_rate;
			$data['start_volume'] = $start_volume;
			$data['end_volume'] = $end_volume;
			$data['start_price'] = $start_price;
			$data['end_price'] = $end_price;
			$data['start_credit'] = $start_credit;
			$data['end_credit'] = $end_credit;
			$data['shop_type'] = $shop_type;
			$data['ems'] = $ems;
			$data['tb_cid'] = $tb_cid;
			$data['http_mode'] = $http_mode;

			$this->_mod->create($data);
			$item_id = $this->_mod->add();
			$this->success('添加成功！');
		}
	}


	 public function edit() {
        if (IS_POST) {
			$id		= $this->_post('id', 'trim');
			$name		= $this->_post('name', 'trim');
			$cid		= $this->_post('cid', 'trim');
			$cate_id		= $this->_post('cate_id', 'trim');
			$keyword		= $this->_post('keyword', 'trim');
			$page		= $this->_post('page', 'trim');
			$sort		= $this->_post('sort', 'trim');
			$start_commissionRate		= $this->_post('start_commissionRate', 'trim');
			$end_commissionRate		= $this->_post('end_commissionRate', 'trim');
			$start_coupon_rate		= $this->_post('start_coupon_rate', 'trim');
			$end_coupon_rate		= $this->_post('end_coupon_rate', 'trim');
			$start_volume		= $this->_post('start_volume', 'trim');
			$end_volume		= $this->_post('end_volume', 'trim');
			$start_price		= $this->_post('start_price', 'trim');
			$end_price		= $this->_post('end_price', 'trim');
			$start_credit		= $this->_post('start_credit', 'trim');
			$end_credit		= $this->_post('end_credit', 'trim');
			$shop_type		= $this->_post('shop_type', 'trim','all');
			$ems					= $this->_post('ems', 'trim');
			$tb_cid					= $this->_post('tb_cid', 'trim');
			$http_mode				= $this->_post('http_mode', 'trim');

			if( !$name||!trim($name) ){
				$this->error('请填写采集器名称');
			}
			if( !$cate_id||!trim($cate_id) ){
				$this->error('请选择商品分类');
			}

			if($http_mode == 1){
				//淘宝网采集
				if(!$keyword && !$tb_cid) {
					 $this->error('请填写关键词或者填写淘宝网分类ID');
				}
				if($start_price > $end_price){
					$this->error('最低价格不能高于最高价格');
				}
			}else{
				//API采集
				if (!$keyword && !$cid) {
					$this->error('请填写关键词或选择API分类');
				}
				if($start_commissionRate > $end_commissionRate){
					$this->error('起始佣金不能高于最高佣金');
				}
			}
			
			if($start_coupon_rate > $end_coupon_rate){
				$this->error('最低折扣不能高于最高折扣');
			}
			if($start_volume > $end_volume){
				$this->error('最低销量不能高于最高销量');
			}

			$data['name'] = $name;
			$data['cid'] = $cid;
			$data['cate_id'] = $cate_id;
			$data['keyword'] = $keyword;
			$data['page'] = $page;
			$data['sort'] = $sort;
			$data['start_commissionRate'] = $start_commissionRate;
			$data['end_commissionRate'] = $end_commissionRate;
			$data['start_coupon_rate'] = $start_coupon_rate;
			$data['end_coupon_rate'] = $end_coupon_rate;
			$data['start_volume'] = $start_volume;
			$data['end_volume'] = $end_volume;
			$data['start_price'] = $start_price;
			$data['end_price'] = $end_price;
			$data['start_credit'] = $start_credit;
			$data['end_credit'] = $end_credit;
			$data['shop_type'] = $shop_type;
			$data['ems'] = $ems;
			$data['tb_cid'] = $tb_cid;
			$data['http_mode'] = $http_mode;
 
  
            //更新商品
            $this->_mod->where(array('id'=>$id))->save($data);
            $this->success(L('operation_success'));
        } else {
            $id = $this->_get('id','intval');
            $item = $this->_mod->where(array('id'=>$id))->find();
            //分类
            $spid = $this->_cate_mod->where(array('id'=>$item['cate_id']))->getField('spid');
            if( $spid==0 ){
                $spid = $item['cate_id'];
            }else{
                $spid .= $item['cate_id'];
            }
            $this->assign('selected_ids',$spid); //分类选中
            $this->assign('info', $item);
            //来源
            $orig_list = M('items_orig')->select();
            $this->assign('orig_list', $orig_list);
			if (!function_exists("curl_getinfo")) {
				$this->error(L('curl_not_open'));
			}
			//获取淘宝商品分类
			$items_cate = $this->_get_tbcats();
			$this->assign('items_cate', $items_cate);
            $this->display();
        }
    }




	public function add_do() {
		//判断CURL
        if (!function_exists("curl_getinfo")) {
            $this->error(L('curl_not_open'));
        }
        //获取淘宝商品分类
        $items_cate = $this->_get_tbcats();
        $this->assign('items_cate', $items_cate);
        $this->display();
	}

	public function collect(){
		if(!$this->_tbconfig['app_key']){$this->ajaxReturn(0, '请设置appkey');}
		$id		= $this->_get('id', 'trim');
		$p		= $this->_get('p', 'intval', 1);
		if($p==1){
			$totalcoll = 0;
		}else{
			$totalcoll = F('totalcoll');
		}
		
		$date = M('robots')->where(array('id'=>$id))->find();
		F('robot_setting', $date);
		if($date){
			if($date['http_mode'] == '0'){
				M('robots')->where(array('id'=>$id))->save(array('last_page'=>$p,'last_time'=>time()));
				//API采集START
				$map['keyword'] = $date['keyword'];									//关键词
				$map['cid'] = $date['cid'];											//api分类ID
				$map['cate_id'] = $date['cate_id'];									//入库分类ID
				if ($p > $date['page']) {
					$this->ajaxReturn(0, '已经采集完成'.$date['page'].'页！请返回，谢谢');
				}
				$map['start_commissionRate']	= $date['start_commissionRate'];	//佣金比率下限
				$map['end_commissionRate']		= $date['end_commissionRate'];		//佣金比率上限
				$map['start_volume']			= $date['start_volume'];			//销量下限
				$map['end_volume']				= $date['end_volume'];				//销量上限
				$map['start_coupon_rate']		= $date['start_coupon_rate'];		//折扣最低比率
				$map['end_coupon_rate']			= $date['end_coupon_rate'];			//折扣最高比率
				$map['start_credit']			= $date['start_credit'];			//卖家信用下限
				$map['end_credit']				= $date['end_credit'];				//卖家信用上限
				$map['shop_type']				= $date['shop_type'];				//是否天猫商品
				if($date['sort']){
					$sorts=explode("|",$date['sort']);
					$map['sort']=$sorts[0].'_'.$sorts[1];							//排序方法
				}					
				$result							= $this->_get_list($map, $p);
				$taobaoke_item_list = $result['item_list'];
				$taobaoke_item_list && F('taobaoke_item_list', $taobaoke_item_list);
				$coll=0;
				$msg = '失败！';
				foreach ($taobaoke_item_list as $key => $val) {
						  $res= $this->_ajax_publish_insert($val);
						  if($res>0){
								$coll++;
								$totalcoll++;
						  }
						  $msg = '成功！';
				}
				F('totalcoll',$totalcoll);
				$this->assign('p',$p);
				$this->assign('msg',$msg);
				$this->assign('coll', $coll); 
				$this->assign('totalcoll', $totalcoll);
				$resp = $this->fetch('collect');
				$this->ajaxReturn(1, '', $resp);
				//API采集END
			}else{
				//淘宝网采集START
				if ($p > $date['page']) {
					$this->ajaxReturn(0, '已经采集完成'.$date['page'].'页！请返回，谢谢');
				}
				$s=($p-1)*44;
				$q='';
				$tp= F('tp');
				if($p>1){
					if ($p > $tp) {
						$this->ajaxReturn(0, '已经采集完成'.$tp.'页！请返回，谢谢');
					}
				}/*
				$match=array(
					//采集规则
					//简体
					'cn_listitem'			=> '/<div class="item-box">(.*?)data-encode="true">/s',
					'cn_content'			=> '/<div id="list-content(.*?)<\/body>/s',
					'cn_total_start'		=> '<li class="result-info">',
					'cn_total_end'			=> '件宝贝',
					'cn_titlebar_start'		=> '<h3 class="summary">',
					'cn_titlebar_end'		=> '<\/h3>',
					'cn_title_start'		=> 'title="',
					'cn_title_end'			=> '"',
					'cn_img_start'			=> '<img src="',
					'cn_img_end'			=> '" resy-img=',
					'cn_imgs_start'			=> '<span><img data-ks-lazyload="',
					'cn_imgs_end'			=> '_160x160.jpg"',
					'cn_imgss_start'		=> '<span><img data-ks-lazyload="',
					'cn_imgss_end'			=> '" resy-img=',
					'cn_iid_start'			=> 'data-item="',
					'cn_iid_end'			=> '"',
					'cn_price_start'		=> '<div class="col origin-price">',
					'cn_price_end'			=> '<\/div>',
					'cn_prices_start'		=> '<div class="col origin-price"  >￥',
					'cn_prices_end'			=> '<\/div>',
					'cn_zkprice_start'		=> '<div class="col price">￥',
					'cn_zkprice_end'		=> '<em><\/em>',
					'cn_volume_start'		=> '最近成交<label>',
					'cn_volume_end'			=> '<\/label>笔',
					'cn_nickbar_start'		=> '<div class="col seller">',
					'cn_nickbar_end'		=> '<\/div>',
					'cn_nick_start'			=> '">',
					'cn_nick_end'			=> '<\/a>',
					'cn_ems_start'			=> '<div class="col shipping">',
					'cn_ems_end'			=> '<\/div>',
					'cn_emsor_start'		=> '免运费',
					'cn_zekou_start'		=> '<li class="rate">',
					'cn_zekou_end'			=> '<br>折<\/li>',
					'cn_zekous_start'		=> '<li class="rate">',
					'cn_zekous_end'			=> '<br\/>折<\/li>',
					'cn_daytime_start'		=> '剩余时间<br>',
					'cn_daytime_end'		=> '天<\/li>',
					'cn_hourtime_start'		=> '剩余时间<br>',
					'cn_hourtime_end'		=> '小时<\/li>',
					'cn_secondtime_start'	=> '剩余时间<br>',
					'cn_secondtime_end'		=> '分<\/li>',
					//繁体
					'hk_listitem'			=> '/<div class="item-box">(.*?)data-encode="true">/s',
					'hk_content'			=> '/<div id="list-content(.*?)<\/body>/s',
					'hk_total_start'		=> '<li class="result-info">',
					'hk_total_end'			=> '件寶貝',
					'hk_titlebar_start'		=> '<h3 class="summary">',
					'hk_titlebar_end'		=> '<\/h3>',
					'hk_title_start'		=> 'title="',
					'hk_title_end'			=> '"',
					'hk_img_start'			=> '<img src="',
					'hk_img_end'			=> '_210x210.jpg"',
					'hk_imgs_start'			=> '<span><img data-ks-lazyload="',
					'hk_imgs_end'			=> '_160x160.jpg"',
					'hk_imgss_start'		=> '<span><img data-ks-lazyload="',
					'hk_imgss_end'			=> '_210x210.jpg',
					'hk_iid_start'			=> 'data-item="',
					'hk_iid_end'			=> '"',
					'hk_price_start'		=> '<div class="col origin-price">￥',
					'hk_price_end'			=> '<\/div>',
					'hk_prices_start'		=> '<div class="col origin-price"  >￥',
					'hk_prices_end'			=> '<\/div>',
					'hk_zkprice_start'		=> '<div class="col price">￥',
					'hk_zkprice_end'		=> '<em><\/em>',
					'hk_volume_start'		=> '最近成交<label>',
					'hk_volume_end'			=> '<\/label>筆',
					'hk_nickbar_start'		=> '<div class="col seller">',
					'hk_nickbar_end'		=> '<\/div>',
					'hk_nick_start'			=> '">',
					'hk_nick_end'			=> '<\/a>',
					'hk_ems_start'			=> '<div class="col shipping">',
					'hk_ems_end'			=> '<\/div>',
					'hk_emsor_start'		=> '免運費',
					'hk_zekou_start'		=> '<li class="rate">',
					'hk_zekou_end'			=> '<br>折<\/li>',
					'hk_zekous_start'		=> '<li class="rate">',
					'hk_zekous_end'			=> '<br\/>折<\/li>',
					'hk_daytime_start'		=> '剩餘時間<br>',
					'hk_daytime_end'		=> '天<\/li>',
					'hk_hourtime_start'		=> '剩餘時間<br>',
					'hk_hourtime_end'		=> '小時<\/li>',
					'hk_secondtime_start'	=> '剩餘時間<br>',
					'hk_secondtime_end'		=> '分<\/li>',
				
				);*/
				if($date['tb_cid']){$q.='&cat='.$date['tb_cid'];}
				if($date['keyword']){$q.='&q='.$date['keyword'];}
				if($date['shop_type'] == 'B'){
						$q.='&tab=mall';
				}else{
						$q.='&tab=all';
				}
				if($date['start_coupon_rate'] && $date['end_coupon_rate'] && $date['start_coupon_rate']< $date['end_coupon_rate'] ){
						$q.='&zk_rate=%5B'.$date['start_coupon_rate'].'%2C'.$date['end_coupon_rate'].'%5D';
				}
				if($date['start_price'] && $date['end_price'] && $date['start_price']< $date['end_price'] ){
						$q.='&start_price='.$date['start_price'].'&end_price='.$date['end_price'];
				}
				if($date['sort']){
					$sorts=explode("|",$date['sort']);
					if($sorts[0]=='volume'){
						$sorts[0]='sale';
					}
					$q.='&sort='.$sorts[0].'-'.$sorts[1];
				}
				$url='http://s.taobao.com/search?commend=all'.$q.'&style=grid&atype=b&limitPromotion=true&filterFineness=2&fs=1&discount_index=1&s='.$s.'&zk_type=0#J_FilterTabBar';
				
				
				$ftxia_https = new ftxia_https();
				$ftxia_https->fetch($url);
				$content = $ftxia_https->results;
				
				if(!$content){
					$content = file_get_contents($url);
				}
				
				
				
				$content=Newiconv("GBK", "UTF-8", $content); 
			
				if(strstr($content,'淘宝')){
					$pre= 'cn_';
					if(strpos($content,'以下是今天参加全部促销的宝贝')){
						$this->ajaxReturn(0, '已经采集完成'.$p.'页！请返回，谢谢');
					}
				}else{
					$pre= 'hk_';
					if(strpos($content,'以下是今天參加全部促銷的寶貝')){
						$this->ajaxReturn(0, '已经采集完成'.$p.'页！请返回，谢谢');
					}
				}
				M('robots')->where(array('id'=>$id))->save(array('last_page'=>$p,'last_time'=>time()));
				$totalnum=get_word($content,L($pre.'total_start'),L($pre.'total_end'));//总的数量
				
				
				
				$tp = intval($totalnum/44)+1;
				F('tp',$tp);	
				
				
				if(preg_match_all(L($pre.'listitem'), $content, $matchitem)) {
				
					for($i=0;$i<count($matchitem[0]);$i++){
						$pi=($p-1)*44+$i;
						$msg='折扣不满足。不采集';
						$item=$matchitem[1][$i];
						$titlebar	=get_word($item,L($pre.'titlebar_start'),L($pre.'titlebar_end'));
						$title	=get_word($titlebar,L($pre.'title_start'),L($pre.'title_end'));
						if($pre=='hk_'){
						   $title=$this->chgUtfcode($title);
						}
						$img	=get_word($item,L($pre.'img_start'),L($pre.'img_end'));
					
						
						$iid	=get_word($item,L($pre.'iid_start'),L($pre.'iid_end'));
						
						$priceStr	=get_word($item,L($pre.'price_start'),L($pre.'price_end'));
						
						$zkprice = $this->ydGetWord($priceStr,L($pre.'pricess_start'),L($pre.'pricess_end'));
					

						$price=$this->ydGetWord($priceStr,L($pre.'price_start_01'),L($pre.'price_end_01'));
						$price = $this->ydGetWordPos($price,L($pre.'pricess_start'));
						
					
						$volume	=get_word($item,L($pre.'volume_start'),L($pre.'volume_end'));
						
						$nickbar	=get_word($item,L($pre.'nickbar_start'),L($pre.'nickbar_end'));
					
						$nick=$this->ydGetWordPos($nickbar,'>');
						$nick =$this->ydGetWord($nick,L($pre.'nick_start'),L($pre.'nick_end'));
						$nick=$this->ydGetWordPos($nick,'>');
						if($pre=='hk_'){
						   $nick=$this->chgUtfcode($nick);
						}
						
						$ems	=get_word($item,L($pre.'ems_start'),L($pre.'ems_end'));
						
						

						if($ems){
							if($pre=='hk_'){
								if(strpos($ems,'免運費')){$ems='1';}else{$ems='0';}
							}else{
								if(strpos($ems,'免运费')){$ems='1';}else{$ems='0';}
							}
						}else{
							$ems='0';
						}
 
						if(!$volume){$volume=0;}
						$zekou	=get_word($item,L($pre.'zekou_start'),L($pre.'zekou_end'));
						if(!$zekou){
							$zekou	=get_word($item,L($pre.'zekous_start'),L($pre.'zekous_end'));
							if(!$zekou){$zekou=5;}
						}
						
						$times='';
						if(strpos($item,L($pre.'daytime_end'))){
							$timess	=	get_word($item,L($pre.'daytime_start'),L($pre.'daytime_end'));
							$times	=	(int)(time()+$timess*86400);
						}
						if(strpos($item,L($pre.'hourtime_end'))){
							$timess	=	get_word($item,L($pre.'hourtime_start'),L($pre.'hourtime_end'));
							$times	=	(int)(time()+$timess*3600);
						}
						if(strpos($item,L($pre.'secondtime_end'))){
							$timess	=	get_word($item,L($pre.'secondtime_start'),L($pre.'secondtime_end'));
							$times	=	(int)(time()+$timess*60);
						}
						if(!defined(ENDTIME)){
							define('ENDTIME','24');
						}
						if(!$times){
							$times	=	(int)(time()+ENDTIME*3600);
						}
						if(strpos($item,'tmall.com')){
							$itemarray['shop_type']='B';
						}else{
							$itemarray['shop_type']='C';
						}
						
						
						$itemarray['title']=$title;
						$itemarray['pic_url']=$img;
						$itemarray['num_iid']=$iid;
						$itemarray['price']=$price;
						$itemarray['coupon_price']=$zkprice;
						$itemarray['volume']=$volume;
						$itemarray['nick']=$nick?$nick:'无';
						$itemarray['ems']=$ems;
						$itemarray['cate_id']=$date['cate_id'];
						$itemarray['coupon_rate']=$zekou*1000;
						$itemarray['coupon_end_time']=$times;
						$itemarray['coupon_start_time']=time();						
						if($title && $img && $iid){
						
					
						$result['item_list'][]=$itemarray;}
						
					}
				}else{
				   
					$result['msg']='采集结束！请返回2';
				}
				

				$taobaoke_item_list = $result['item_list'];
				$taobaoke_item_list && F('taobaoke_item_list', $taobaoke_item_list);
				$coll=0;
				$thiscount=0;
				foreach ($taobaoke_item_list as $key => $val) {
						  $res= $this->_ajax_tb_publish_insert($val);
						  if($res>0){
								$coll++;
								$totalcoll++;
						  } 
						  $thiscount++;
				}
				F('totalcoll',$totalcoll);
				$this->assign('p',$p);
				$this->assign('coll', $coll);
				$this->assign('thiscount', $thiscount); 
				$this->assign('totalnum', $totalnum);
				$this->assign('totalcoll', $totalcoll);
				$resp = $this->fetch('collect');
				// die($resp);
				$this->ajaxReturn(1, '', $resp);
				//淘宝网采集END
			}

		}else{
			$this->ajaxReturn(0, 'api');
		}
	}
	 
    public function ydGetWord($str,$firstStr,$nextStr){
	   
	    $firstIndex = strpos($str,$firstStr);	
		$firstNext  = strpos($str,$nextStr);	
		$theLength = strlen($str);
		if($theLength==0||$firstIndex<0||$nextStr<0){
		  return '';
		}
	    $str1 = trim(substr($str, $firstIndex+strlen($firstStr), $firstNext-$firstIndex-strlen($firstStr)));
		
		return $str1;
	}
	
	public function ydGetWordPos($str,$firstStr){
	     $firstIndex = strpos($str,$firstStr);
		 $theLength = strlen($str);
		 if($theLength==0||$firstIndex<0){
		    return '';
		 }
		  $resu =  trim(substr($str, $firstIndex+strlen($firstStr)));
		  return $resu;
	}
	
	/**
	*繁体转换成简体
	**/
 public  function chgUtfcode($s){
   $n=strlen($s);
   $cn=" 万与丑专业丛东丝丢两严丧个丬丰临为丽举么义乌乐乔习乡书买乱争于亏云亘亚产亩亲亵亸亿仅从仑仓仪们价众优伙会伛伞伟传伤伥伦伧伪伫体余佣佥侠侣侥侦侧侨侩侪侬俣俦俨俩俪俭债倾偬偻偾偿傥傧储傩儿兑兖党兰关兴兹养兽冁内冈册写军农冢冯冲决况冻净凄凉凌减凑凛几凤凫凭凯击凼凿刍划刘则刚创删别刬刭刽刿剀剂剐剑剥剧劝办务劢动励劲劳势勋勐勚匀匦匮区医华协单卖卢卤卧卫却卺厂厅历厉压厌厍厕厢厣厦厨厩厮县参叆叇双发变叙叠叶号叹叽吁后吓吕吗吣吨听启吴呒呓呕呖呗员呙呛呜咏咔咙咛咝咤咴咸哌响哑哒哓哔哕哗哙哜哝哟唛唝唠唡唢唣唤唿啧啬啭啮啰啴啸喷喽喾嗫呵嗳嘘嘤嘱噜噼嚣嚯团园囱围囵国图圆圣圹场坂坏块坚坛坜坝坞坟坠垄垅垆垒垦垧垩垫垭垯垱垲垴埘埙埚埝埯堑堕塆墙壮声壳壶壸处备复够头夸夹夺奁奂奋奖奥妆妇妈妩妪妫姗姜娄娅娆娇娈娱娲娴婳婴婵婶媪嫒嫔嫱嬷孙学孪宁宝实宠审宪宫宽宾寝对寻导寿将尔尘尧尴尸尽层屃屉届属屡屦屿岁岂岖岗岘岙岚岛岭岳岽岿峃峄峡峣峤峥峦崂崃崄崭嵘嵚嵛嵝嵴巅巩巯币帅师帏帐帘帜带帧帮帱帻帼幂幞干并广庄庆庐庑库应庙庞废庼廪开异弃张弥弪弯弹强归当录彟彦彻径徕御忆忏忧忾怀态怂怃怄怅怆怜总怼怿恋恳恶恸恹恺恻恼恽悦悫悬悭悯惊惧惨惩惫惬惭惮惯愍愠愤愦愿慑慭憷懑懒懔戆戋戏戗战戬户扎扑扦执扩扪扫扬扰抚抛抟抠抡抢护报担拟拢拣拥拦拧拨择挂挚挛挜挝挞挟挠挡挢挣挤挥挦捞损捡换捣据捻掳掴掷掸掺掼揸揽揿搀搁搂搅携摄摅摆摇摈摊撄撑撵撷撸撺擞攒敌敛数斋斓斗斩断无旧时旷旸昙昼昽显晋晒晓晔晕晖暂暧札术朴机杀杂权条来杨杩杰极构枞枢枣枥枧枨枪枫枭柜柠柽栀栅标栈栉栊栋栌栎栏树栖样栾桊桠桡桢档桤桥桦桧桨桩梦梼梾检棂椁椟椠椤椭楼榄榇榈榉槚槛槟槠横樯樱橥橱橹橼檐檩欢欤欧歼殁殇残殒殓殚殡殴毁毂毕毙毡毵氇气氢氩氲汇汉污汤汹沓沟没沣沤沥沦沧沨沩沪沵泞泪泶泷泸泺泻泼泽泾洁洒洼浃浅浆浇浈浉浊测浍济浏浐浑浒浓浔浕涂涌涛涝涞涟涠涡涢涣涤润涧涨涩淀渊渌渍渎渐渑渔渖渗温游湾湿溃溅溆溇滗滚滞滟滠满滢滤滥滦滨滩滪漤潆潇潋潍潜潴澜濑濒灏灭灯灵灾灿炀炉炖炜炝点炼炽烁烂烃烛烟烦烧烨烩烫烬热焕焖焘煅煳熘爱爷牍牦牵牺犊犟状犷犸犹狈狍狝狞独狭狮狯狰狱狲猃猎猕猡猪猫猬献獭玑玙玚玛玮环现玱玺珉珏珐珑珰珲琎琏琐琼瑶瑷璇璎瓒瓮瓯电画畅畲畴疖疗疟疠疡疬疮疯疱疴痈痉痒痖痨痪痫痴瘅瘆瘗瘘瘪瘫瘾瘿癞癣癫癯皑皱皲盏盐监盖盗盘眍眦眬着睁睐睑瞒瞩矫矶矾矿砀码砖砗砚砜砺砻砾础硁硅硕硖硗硙硚确硷碍碛碜碱碹磙礼祎祢祯祷祸禀禄禅离秃秆种积称秽秾稆税稣稳穑穷窃窍窑窜窝窥窦窭竖竞笃笋笔笕笺笼笾筑筚筛筜筝筹签简箓箦箧箨箩箪箫篑篓篮篱簖籁籴类籼粜粝粤粪粮糁糇紧絷纟纠纡红纣纤纥约级纨纩纪纫纬纭纮纯纰纱纲纳纴纵纶纷纸纹纺纻纼纽纾线绀绁绂练组绅细织终绉绊绋绌绍绎经绐绑绒结绔绕绖绗绘给绚绛络绝绞统绠绡绢绣绤绥绦继绨绩绪绫绬续绮绯绰绱绲绳维绵绶绷绸绹绺绻综绽绾绿缀缁缂缃缄缅缆缇缈缉缊缋缌缍缎缏缐缑缒缓缔缕编缗缘缙缚缛缜缝缞缟缠缡缢缣缤缥缦缧缨缩缪缫缬缭缮缯缰缱缲缳缴缵罂网罗罚罢罴羁羟羡翘翙翚耢耧耸耻聂聋职聍联聩聪肃肠肤肷肾肿胀胁胆胜胧胨胪胫胶脉脍脏脐脑脓脔脚脱脶脸腊腌腘腭腻腼腽腾膑臜舆舣舰舱舻艰艳艹艺节芈芗芜芦苁苇苈苋苌苍苎苏苘苹茎茏茑茔茕茧荆荐荙荚荛荜荞荟荠荡荣荤荥荦荧荨荩荪荫荬荭荮药莅莜莱莲莳莴莶获莸莹莺莼萚萝萤营萦萧萨葱蒇蒉蒋蒌蓝蓟蓠蓣蓥蓦蔷蔹蔺蔼蕲蕴薮藁藓虏虑虚虫虬虮虽虾虿蚀蚁蚂蚕蚝蚬蛊蛎蛏蛮蛰蛱蛲蛳蛴蜕蜗蜡蝇蝈蝉蝎蝼蝾螀螨蟏衅衔补衬衮袄袅袆袜袭袯装裆裈裢裣裤裥褛褴襁襕见观觃规觅视觇览觉觊觋觌觍觎觏觐觑觞触觯詟誉誊讠计订讣认讥讦讧讨让讪讫训议讯记讱讲讳讴讵讶讷许讹论讻讼讽设访诀证诂诃评诅识诇诈诉诊诋诌词诎诏诐译诒诓诔试诖诗诘诙诚诛诜话诞诟诠诡询诣诤该详诧诨诩诪诫诬语诮误诰诱诲诳说诵诶请诸诹诺读诼诽课诿谀谁谂调谄谅谆谇谈谊谋谌谍谎谏谐谑谒谓谔谕谖谗谘谙谚谛谜谝谞谟谠谡谢谣谤谥谦谧谨谩谪谫谬谭谮谯谰谱谲谳谴谵谶谷豮贝贞负贠贡财责贤败账货质贩贪贫贬购贮贯贰贱贲贳贴贵贶贷贸费贺贻贼贽贾贿赀赁赂赃资赅赆赇赈赉赊赋赌赍赎赏赐赑赒赓赔赕赖赗赘赙赚赛赜赝赞赟赠赡赢赣赪赵赶趋趱趸跃跄跖跞践跶跷跸跹跻踊踌踪踬踯蹑蹒蹰蹿躏躜躯车轧轨轩轪轫转轭轮软轰轱轲轳轴轵轶轷轸轹轺轻轼载轾轿辀辁辂较辄辅辆辇辈辉辊辋辌辍辎辏辐辑辒输辔辕辖辗辘辙辚辞辩辫边辽达迁过迈运还这进远违连迟迩迳迹适选逊递逦逻遗遥邓邝邬邮邹邺邻郁郄郏郐郑郓郦郧郸酝酦酱酽酾酿释里鉅鉴銮錾钆钇针钉钊钋钌钍钎钏钐钑钒钓钔钕钖钗钘钙钚钛钝钞钟钠钡钢钣钤钥钦钧钨钩钪钫钬钭钮钯钰钱钲钳钴钵钶钷钸钹钺钻钼钽钾钿铀铁铂铃铄铅铆铈铉铊铋铍铎铏铐铑铒铕铗铘铙铚铛铜铝铞铟铠铡铢铣铤铥铦铧铨铪铫铬铭铮铯铰铱铲铳铴铵银铷铸铹铺铻铼铽链铿销锁锂锃锄锅锆锇锈锉锊锋锌锍锎锏锐锑锒锓锔锕锖锗错锚锜锞锟锠锡锢锣锤锥锦锨锩锫锬锭键锯锰锱锲锳锴锵锶锷锸锹锺锻锼锽锾锿镀镁镂镃镆镇镈镉镊镌镍镎镏镐镑镒镕镖镗镙镚镛镜镝镞镟镠镡镢镣镤镥镦镧镨镩镪镫镬镭镮镯镰镱镲镳镴镶长门闩闪闫闬闭问闯闰闱闲闳间闵闶闷闸闹闺闻闼闽闾闿阀阁阂阃阄阅阆阇阈阉阊阋阌阍阎阏阐阑阒阓阔阕阖阗阘阙阚阛队阳阴阵阶际陆陇陈陉陕陧陨险随隐隶隽难雏雠雳雾霁霉霭靓静靥鞑鞒鞯鞴韦韧韨韩韪韫韬韵页顶顷顸项顺须顼顽顾顿颀颁颂颃预颅领颇颈颉颊颋颌颍颎颏颐频颒颓颔颕颖颗题颙颚颛颜额颞颟颠颡颢颣颤颥颦颧风飏飐飑飒飓飔飕飖飗飘飙飚飞飨餍饤饥饦饧饨饩饪饫饬饭饮饯饰饱饲饳饴饵饶饷饸饹饺饻饼饽饾饿馀馁馂馃馄馅馆馇馈馉馊馋馌馍馎馏馐馑馒馓馔馕马驭驮驯驰驱驲驳驴驵驶驷驸驹驺驻驼驽驾驿骀骁骂骃骄骅骆骇骈骉骊骋验骍骎骏骐骑骒骓骔骕骖骗骘骙骚骛骜骝骞骟骠骡骢骣骤骥骦骧髅髋髌鬓魇魉鱼鱽鱾鱿鲀鲁鲂鲄鲅鲆鲇鲈鲉鲊鲋鲌鲍鲎鲏鲐鲑鲒鲓鲔鲕鲖鲗鲘鲙鲚鲛鲜鲝鲞鲟鲠鲡鲢鲣鲤鲥鲦鲧鲨鲩鲪鲫鲬鲭鲮鲯鲰鲱鲲鲳鲴鲵鲶鲷鲸鲹鲺鲻鲼鲽鲾鲿鳀鳁鳂鳃鳄鳅鳆鳇鳈鳉鳊鳋鳌鳍鳎鳏鳐鳑鳒鳓鳔鳕鳖鳗鳘鳙鳛鳜鳝鳞鳟鳠鳡鳢鳣鸟鸠鸡鸢鸣鸤鸥鸦鸧鸨鸩鸪鸫鸬鸭鸮鸯鸰鸱鸲鸳鸴鸵鸶鸷鸸鸹鸺鸻鸼鸽鸾鸿鹀鹁鹂鹃鹄鹅鹆鹇鹈鹉鹊鹋鹌鹍鹎鹏鹐鹑鹒鹓鹔鹕鹖鹗鹘鹚鹛鹜鹝鹞鹟鹠鹡鹢鹣鹤鹥鹦鹧鹨鹩鹪鹫鹬鹭鹯鹰鹱鹲鹳鹴鹾麦麸黄黉黡黩黪黾鼋鼌鼍鼗鼹齄齐齑齿龀龁龂龃龄龅龆龇龈龉龊龋龌龙龚龛龟志制咨只里系范松没尝尝闹面准钟别闲干尽脏拼";
   $big5=" 萬與醜專業叢東絲丟兩嚴喪個爿豐臨為麗舉麼義烏樂喬習鄉書買亂爭於虧雲亙亞產畝親褻嚲億僅從侖倉儀們價眾優夥會傴傘偉傳傷倀倫傖偽佇體餘傭僉俠侶僥偵側僑儈儕儂俁儔儼倆儷儉債傾傯僂僨償儻儐儲儺兒兌兗黨蘭關興茲養獸囅內岡冊寫軍農塚馮衝決況凍淨淒涼淩減湊凜幾鳳鳧憑凱擊氹鑿芻劃劉則剛創刪別剗剄劊劌剴劑剮劍剝劇勸辦務勱動勵勁勞勢勳猛勩勻匭匱區醫華協單賣盧鹵臥衛卻巹廠廳曆厲壓厭厙廁廂厴廈廚廄廝縣參靉靆雙發變敘疊葉號歎嘰籲後嚇呂嗎唚噸聽啟吳嘸囈嘔嚦唄員咼嗆嗚詠哢嚨嚀噝吒噅鹹呱響啞噠嘵嗶噦嘩噲嚌噥喲嘜嗊嘮啢嗩唕喚呼嘖嗇囀齧囉嘽嘯噴嘍嚳囁嗬噯噓嚶囑嚕劈囂謔團園囪圍圇國圖圓聖壙場阪壞塊堅壇壢壩塢墳墜壟壟壚壘墾坰堊墊埡墶壋塏堖塒塤堝墊垵塹墮壪牆壯聲殼壺壼處備複夠頭誇夾奪奩奐奮獎奧妝婦媽嫵嫗媯姍薑婁婭嬈嬌孌娛媧嫻嫿嬰嬋嬸媼嬡嬪嬙嬤孫學孿寧寶實寵審憲宮寬賓寢對尋導壽將爾塵堯尷屍盡層屭屜屆屬屢屨嶼歲豈嶇崗峴嶴嵐島嶺嶽崠巋嶨嶧峽嶢嶠崢巒嶗崍嶮嶄嶸嶔崳嶁脊巔鞏巰幣帥師幃帳簾幟帶幀幫幬幘幗冪襆幹並廣莊慶廬廡庫應廟龐廢廎廩開異棄張彌弳彎彈強歸當錄彠彥徹徑徠禦憶懺憂愾懷態慫憮慪悵愴憐總懟懌戀懇惡慟懨愷惻惱惲悅愨懸慳憫驚懼慘懲憊愜慚憚慣湣慍憤憒願懾憖怵懣懶懍戇戔戲戧戰戩戶紮撲扡執擴捫掃揚擾撫拋摶摳掄搶護報擔擬攏揀擁攔擰撥擇掛摯攣掗撾撻挾撓擋撟掙擠揮撏撈損撿換搗據撚擄摑擲撣摻摜摣攬撳攙擱摟攪攜攝攄擺搖擯攤攖撐攆擷擼攛擻攢敵斂數齋斕鬥斬斷無舊時曠暘曇晝曨顯晉曬曉曄暈暉暫曖劄術樸機殺雜權條來楊榪傑極構樅樞棗櫪梘棖槍楓梟櫃檸檉梔柵標棧櫛櫳棟櫨櫟欄樹棲樣欒棬椏橈楨檔榿橋樺檜槳樁夢檮棶檢欞槨櫝槧欏橢樓欖櫬櫚櫸檟檻檳櫧橫檣櫻櫫櫥櫓櫞簷檁歡歟歐殲歿殤殘殞殮殫殯毆毀轂畢斃氈毿氌氣氫氬氳彙漢汙湯洶遝溝沒灃漚瀝淪滄渢溈滬濔濘淚澩瀧瀘濼瀉潑澤涇潔灑窪浹淺漿澆湞溮濁測澮濟瀏滻渾滸濃潯濜塗湧濤澇淶漣潿渦溳渙滌潤澗漲澀澱淵淥漬瀆漸澠漁瀋滲溫遊灣濕潰濺漵漊潷滾滯灩灄滿瀅濾濫灤濱灘澦濫瀠瀟瀲濰潛瀦瀾瀨瀕灝滅燈靈災燦煬爐燉煒熗點煉熾爍爛烴燭煙煩燒燁燴燙燼熱煥燜燾煆糊溜愛爺牘犛牽犧犢強狀獷獁猶狽麅獮獰獨狹獅獪猙獄猻獫獵獼玀豬貓蝟獻獺璣璵瑒瑪瑋環現瑲璽瑉玨琺瓏璫琿璡璉瑣瓊瑤璦璿瓔瓚甕甌電畫暢佘疇癤療瘧癘瘍鬁瘡瘋皰屙癰痙癢瘂癆瘓癇癡癉瘮瘞瘺癟癱癮癭癩癬癲臒皚皺皸盞鹽監蓋盜盤瞘眥矓著睜睞瞼瞞矚矯磯礬礦碭碼磚硨硯碸礪礱礫礎硜矽碩硤磽磑礄確鹼礙磧磣堿镟滾禮禕禰禎禱禍稟祿禪離禿稈種積稱穢穠穭稅穌穩穡窮竊竅窯竄窩窺竇窶豎競篤筍筆筧箋籠籩築篳篩簹箏籌簽簡籙簀篋籜籮簞簫簣簍籃籬籪籟糴類秈糶糲粵糞糧糝餱緊縶糸糾紆紅紂纖紇約級紈纊紀紉緯紜紘純紕紗綱納紝縱綸紛紙紋紡紵紖紐紓線紺絏紱練組紳細織終縐絆紼絀紹繹經紿綁絨結絝繞絰絎繪給絢絳絡絕絞統綆綃絹繡綌綏絛繼綈績緒綾緓續綺緋綽緔緄繩維綿綬繃綢綯綹綣綜綻綰綠綴緇緙緗緘緬纜緹緲緝縕繢緦綞緞緶線緱縋緩締縷編緡緣縉縛縟縝縫縗縞纏縭縊縑繽縹縵縲纓縮繆繅纈繚繕繒韁繾繰繯繳纘罌網羅罰罷羆羈羥羨翹翽翬耮耬聳恥聶聾職聹聯聵聰肅腸膚膁腎腫脹脅膽勝朧腖臚脛膠脈膾髒臍腦膿臠腳脫腡臉臘醃膕齶膩靦膃騰臏臢輿艤艦艙艫艱豔艸藝節羋薌蕪蘆蓯葦藶莧萇蒼苧蘇檾蘋莖蘢蔦塋煢繭荊薦薘莢蕘蓽蕎薈薺蕩榮葷滎犖熒蕁藎蓀蔭蕒葒葤藥蒞蓧萊蓮蒔萵薟獲蕕瑩鶯蓴蘀蘿螢營縈蕭薩蔥蕆蕢蔣蔞藍薊蘺蕷鎣驀薔蘞藺藹蘄蘊藪槁蘚虜慮虛蟲虯蟣雖蝦蠆蝕蟻螞蠶蠔蜆蠱蠣蟶蠻蟄蛺蟯螄蠐蛻蝸蠟蠅蟈蟬蠍螻蠑螿蟎蠨釁銜補襯袞襖嫋褘襪襲襏裝襠褌褳襝褲襇褸襤繈襴見觀覎規覓視覘覽覺覬覡覿覥覦覯覲覷觴觸觶讋譽謄訁計訂訃認譏訐訌討讓訕訖訓議訊記訒講諱謳詎訝訥許訛論訩訟諷設訪訣證詁訶評詛識詗詐訴診詆謅詞詘詔詖譯詒誆誄試詿詩詰詼誠誅詵話誕詬詮詭詢詣諍該詳詫諢詡譸誡誣語誚誤誥誘誨誑說誦誒請諸諏諾讀諑誹課諉諛誰諗調諂諒諄誶談誼謀諶諜謊諫諧謔謁謂諤諭諼讒諮諳諺諦謎諞諝謨讜謖謝謠謗諡謙謐謹謾謫譾謬譚譖譙讕譜譎讞譴譫讖穀豶貝貞負貟貢財責賢敗賬貨質販貪貧貶購貯貫貳賤賁貰貼貴貺貸貿費賀貽賊贄賈賄貲賃賂贓資賅贐賕賑賚賒賦賭齎贖賞賜贔賙賡賠賧賴賵贅賻賺賽賾贗讚贇贈贍贏贛赬趙趕趨趲躉躍蹌蹠躒踐躂蹺蹕躚躋踴躊蹤躓躑躡蹣躕躥躪躦軀車軋軌軒軑軔轉軛輪軟轟軲軻轤軸軹軼軤軫轢軺輕軾載輊轎輈輇輅較輒輔輛輦輩輝輥輞輬輟輜輳輻輯轀輸轡轅轄輾轆轍轔辭辯辮邊遼達遷過邁運還這進遠違連遲邇逕跡適選遜遞邐邏遺遙鄧鄺鄔郵鄒鄴鄰鬱郤郟鄶鄭鄆酈鄖鄲醞醱醬釅釃釀釋裏钜鑒鑾鏨釓釔針釘釗釙釕釷釺釧釤鈒釩釣鍆釹鍚釵鈃鈣鈈鈦鈍鈔鍾鈉鋇鋼鈑鈐鑰欽鈞鎢鉤鈧鈁鈥鈄鈕鈀鈺錢鉦鉗鈷缽鈳鉕鈽鈸鉞鑽鉬鉭鉀鈿鈾鐵鉑鈴鑠鉛鉚鈰鉉鉈鉍鈹鐸鉶銬銠鉺銪鋏鋣鐃銍鐺銅鋁銱銦鎧鍘銖銑鋌銩銛鏵銓鉿銚鉻銘錚銫鉸銥鏟銃鐋銨銀銣鑄鐒鋪鋙錸鋱鏈鏗銷鎖鋰鋥鋤鍋鋯鋨鏽銼鋝鋒鋅鋶鐦鐧銳銻鋃鋟鋦錒錆鍺錯錨錡錁錕錩錫錮鑼錘錐錦鍁錈錇錟錠鍵鋸錳錙鍥鍈鍇鏘鍶鍔鍤鍬鍾鍛鎪鍠鍰鎄鍍鎂鏤鎡鏌鎮鎛鎘鑷鐫鎳鎿鎦鎬鎊鎰鎔鏢鏜鏍鏰鏞鏡鏑鏃鏇鏐鐔钁鐐鏷鑥鐓鑭鐠鑹鏹鐙鑊鐳鐶鐲鐮鐿鑔鑣鑞鑲長門閂閃閆閈閉問闖閏闈閑閎間閔閌悶閘鬧閨聞闥閩閭闓閥閣閡閫鬮閱閬闍閾閹閶鬩閿閽閻閼闡闌闃闠闊闋闔闐闒闕闞闤隊陽陰陣階際陸隴陳陘陝隉隕險隨隱隸雋難雛讎靂霧霽黴靄靚靜靨韃鞽韉韝韋韌韍韓韙韞韜韻頁頂頃頇項順須頊頑顧頓頎頒頌頏預顱領頗頸頡頰頲頜潁熲頦頤頻頮頹頷頴穎顆題顒顎顓顏額顳顢顛顙顥纇顫顬顰顴風颺颭颮颯颶颸颼颻飀飄飆飆飛饗饜飣饑飥餳飩餼飪飫飭飯飲餞飾飽飼飿飴餌饒餉餄餎餃餏餅餑餖餓餘餒餕餜餛餡館餷饋餶餿饞饁饃餺餾饈饉饅饊饌饢馬馭馱馴馳驅馹駁驢駔駛駟駙駒騶駐駝駑駕驛駘驍罵駰驕驊駱駭駢驫驪騁驗騂駸駿騏騎騍騅騌驌驂騙騭騤騷騖驁騮騫騸驃騾驄驏驟驥驦驤髏髖髕鬢魘魎魚魛魢魷魨魯魴魺鮁鮃鯰鱸鮋鮓鮒鮊鮑鱟鮍鮐鮭鮚鮳鮪鮞鮦鰂鮜鱠鱭鮫鮮鮺鯗鱘鯁鱺鰱鰹鯉鰣鰷鯀鯊鯇鮶鯽鯒鯖鯪鯕鯫鯡鯤鯧鯝鯢鯰鯛鯨鯵鯴鯔鱝鰈鰏鱨鯷鰮鰃鰓鱷鰍鰒鰉鰁鱂鯿鰠鼇鰭鰨鰥鰩鰟鰜鰳鰾鱈鱉鰻鰵鱅鰼鱖鱔鱗鱒鱯鱤鱧鱣鳥鳩雞鳶鳴鳲鷗鴉鶬鴇鴆鴣鶇鸕鴨鴞鴦鴒鴟鴝鴛鴬鴕鷥鷙鴯鴰鵂鴴鵃鴿鸞鴻鵐鵓鸝鵑鵠鵝鵒鷳鵜鵡鵲鶓鵪鶤鵯鵬鵮鶉鶊鵷鷫鶘鶡鶚鶻鶿鶥鶩鷊鷂鶲鶹鶺鷁鶼鶴鷖鸚鷓鷚鷯鷦鷲鷸鷺鸇鷹鸌鸏鸛鸘鹺麥麩黃黌黶黷黲黽黿鼂鼉鞀鼴齇齊齏齒齔齕齗齟齡齙齠齜齦齬齪齲齷龍龔龕龜誌製谘隻裡係範鬆冇嚐嘗鬨麵準鐘彆閒乾儘臟拚";
   
   for($i=0;$i<$n;$i++)
   {
      $t=ord(substr($s,$i,1));   
      if($t>=128)//中文字一次取3個
      {
        $s1=substr($s,$i,3);
        if(strpos($big5,$s1)>0)//簡體字中有就用簡體字
          $s2=$s2.substr($cn,strpos($big5,$s1),3);
        else
          $s2=$s2.$s1;
        $i=$i+2;
      }
      else
      {
        $s1=substr($s,$i,1);
        $s2=$s2.$s1;
      }
   }
   return $s2;
}




	public function robot(){
		$id		= $this->_get('id', 'trim');
		$date = M('robots')->where(array('id'=>$id))->find();
		if($date){
			$map['keyword'] = $date['keyword'];									//关键词
            $map['cid'] = $date['cid'];											//api分类ID
			$map['cate_id'] = $date['cate_id'];									//入库分类ID
            $p = $this->_get('p', 'intval', 1);
            if ($p > 100) {
                $this->redirect('robots/index');
            }

            $map['start_commissionRate']	= $date['start_commissionRate'];	//佣金比率下限
            $map['end_commissionRate']		= $date['end_commissionRate'];		//佣金比率上限
            $map['start_volume']			= $date['start_volume'];			//销量下限
            $map['end_volume']				= $date['end_volume'];				//销量上限
            $map['start_coupon_rate']		= $date['start_coupon_rate'];		//折扣最低比率
            $map['end_coupon_rate']			= $date['end_coupon_rate'];			//折扣最高比率
            $map['start_credit']			= $date['start_credit'];			//卖家信用下限
            $map['end_credit']				= $date['end_credit'];				//卖家信用上限
            $map['shop_type']				= $date['shop_type'];				//是否天猫商品
            $map['sort']					= $date['sort'];					//排序方法
 

			$result							= $this->_get_list($map, $p);
            $pager = new Page($result['count'], 40);
            $page = $pager->show();
            $this->assign("page", $page);
			$this->assign("p", $p);
			$this->assign("count", $result['count']);
            $taobaoke_item_list = $result['item_list'];
			$taobaoke_item_list && F('taobaoke_item_list', $taobaoke_item_list);
			$returnlist=array();
			foreach ($taobaoke_item_list as $key => $val) {
					  $returnlist[] = $this->_publish_insert($val);
			}
			$this->assign('list', $returnlist);                               
			$this->assign('list_table', true);
			$lv =$result['count']/40;
			if($lv>$p){
				$nexturl = U('robots/robot',array('id'=>$id,'p'=>$p));
				$this->assign('nexturl', $nexturl);
			}
			$this->display();

		}
		
	}

 
    private function _publish_insert($item) {
        $item['title'] = strip_tags($item['title']);
        $item['click_url'] = Url::replace($item['click_url'], array('spm' => '2014.' . $this->_tbconfig['app_key'] . '.1.0'));
        $result = D('items')->publish($item);
        return $result;
    }

	private function _ajax_publish_insert($item) {
        $item['title'] = strip_tags($item['title']);
        $item['click_url'] = Url::replace($item['click_url'], array('spm' => '2014.' . $this->_tbconfig['app_key'] . '.1.0'));
        $result = D('items')->ajax_publish($item);
        return $result;
    }

	private function _ajax_tb_publish_insert($item) {
        $item['title'] = strip_tags($item['title']);
        $result = D('items')->ajax_tb_publish($item);
        return $result;
    }

	 public function ajax_get_tbcats() {
        $cid = $this->_get('cid', 'intval', 0);
        $item_cate = $this->_get_tbcats($cid);
        if ($item_cate) {
            $this->ajaxReturn(1, '', $item_cate);
        } else {
            $this->ajaxReturn(0);
        }
    }

    /**
     * 获取商品列表
     * 返回商品列表和总数
     */
    private function _get_list($map, $p) {
        $tb_top = $this->_get_tb_top();
        $req = $tb_top->load_api('TaobaokeItemsCouponGetRequest');
        $req->setFields('num_iid,title,nick,pic_url,price,click_url,commission,commission_rate,commission_num,commission_volume,shop_click_url,seller_credit_score,item_location,volume,coupon_price,coupon_rate,coupon_start_time,coupon_end_time,shop_type');
        $req->setPageNo($p);
        $req->setPageSize(40);
        $map['keyword'] && $req->setKeyword($map['keyword']); //关键词
        $map['cid'] && $req->setCid($map['cid']); //分类
        $map['start_commissionRate'] && $req->setStartCommissionRate($map['start_commissionRate'] * 100); //佣金比率下限
        $map['end_commissionRate'] && $req->setEndCommissionRate($map['end_commissionRate'] * 100); //佣金比率上限
        $map['start_volume'] && $req->setStartCommissionNum($map['start_volume']); //销量下限
        $map['end_volume'] && $req->setEndCommissionNum($map['end_volume']); //销量上限
        $map['start_coupon_rate'] && $req->setStartCouponRate($map['start_coupon_rate'] * 100); //折扣最低比率
        $map['end_coupon_rate'] && $req->setEndCouponRate($map['end_coupon_rate'] * 100);//折扣最高比率
        $map['start_credit'] && $req->setStartCredit($map['start_credit']); //卖家信用下限
        $map['end_credit'] && $req->setEndCredit($map['end_credit']); //卖家信用上限
        $map['shop_type'] && $req->setShopType($map['shop_type']); //卖家类型
        $map['sort'] && $req->setSort($map['sort']);
        
       // $req->setStartCommissionRate(1000);
        //$req->setEndCommissionRate(2000);
        
        $resp = $tb_top->execute($req);
		//exit(print_r($resp));
        $count = $resp->total_results;
        //列表内容
        $iids = array();
        $resp_items = (array) $resp->taobaoke_items;
        $taobaoke_item_list = array();
        foreach ($resp_items['taobaoke_item'] as $val) {
            $val = (array) $val;
			$val['cate_id']=$map['cate_id'];
            $taobaoke_item_list[$val['num_iid']] = $val;
        }
       

        //返回
        return array(
            'count' => intval($count),
            'item_list' => $taobaoke_item_list,
        );
    }


	
    private function _get_tbcats($cid = 0) {
        $tb_top = $this->_get_tb_top();
        $req = $tb_top->load_api('ItemcatsGetRequest');
        $req->setFields("cid,parent_cid,name,is_parent");
        $req->setParentCid($cid);
        $resp = $tb_top->execute($req);
        $res_cats = (array) $resp->item_cats;
        $item_cate = array();
        foreach ($res_cats['item_cat'] as $val) {
            $val = (array) $val;
            $item_cate[] = $val;
        }
        return $item_cate;
    }

    private function _get_tb_top() {
        vendor('Taobaotop.TopClient');
        vendor('Taobaotop.RequestCheckUtil');
        vendor('Taobaotop.Logger');
        $tb_top = new TopClient;
        $tb_top->appkey = $this->_tbconfig['app_key'];
        $tb_top->secretKey = $this->_tbconfig['app_secret'];
        return $tb_top;
    }
 
 
 
 
	 

}
?>