<?php
class indexAction extends frontendAction {
	public function _initialize() {
        parent::_initialize();
        $this->_mod = D('items');
        $this->_cate_mod = D('items_cate');
    }
    /**
	 ** 首页（全部）
	 **/
    public function index() {
		$item_mod = M('items');

		$today_str = mktime(0,0,0,date("m"),date("d"),date("Y"));
		$today_wh['coupon_start_time'] = array('egt',$today_str);
		$today_item = $this->_mod->where($today_wh)->count();
		$this->assign('today_item', $today_item);

		$order = 'ordid asc ';
		$sort = $this->_get('sort', 'trim', 'default'); //排序
		$status = $this->_get('status', 'trim', 'all'); //排序
		switch ($sort){
            case 'new':
                $order.= ', coupon_start_time DESC';
                break;
            case 'price':
                $order.= ', price DESC';
                break;
			case 'hot':
                $order.= ', volume DESC';
                break;
			case 'default':
				$order.= ', '.C('ftx_index_sort');
        }

		switch ($status){
            case 'all':
                $where['status']="underway";
                break;
            case 'underway':
                $where['status']="underway";
                break;
			case 'sellout':
				$where['status']="sellout";
				break;
        }
		if(C('ftx_wait_time') == '1'){
			$where['coupon_start_time'] = array('egt',time());
		}elseif(C('ftx_wait_time') =='2'){
			$where['coupon_start_time'] = array('elt',time());
		}

		if(C('ftx_end_time') == '1'){
			$where['coupon_end_time'] = array('egt',time());
		}
		if(C('ftx_index_ems') == '1'){
			$where['ems'] = '1';
		}

		if(C('ftx_index_shop_type')){$where['shop_type'] = C('ftx_index_shop_type');}

		if(C('ftx_index_mix_price')>0){$where['coupon_price'] = array('egt',C('ftx_index_mix_price'));}
		if(C('ftx_index_max_price')>0){$where['coupon_price'] = array('elt',C('ftx_index_max_price'));}
		if(C('ftx_index_mix_price')>0 && C('ftx_index_max_price')>0){$where['coupon_price'] = array(array('egt',C('ftx_index_mix_price')),array('elt',C('ftx_index_max_price')),'and');}

		if(C('ftx_index_mix_volume')>0){$where['volume'] = array('egt',C('ftx_index_mix_volume'));}
		if(C('ftx_index_max_volume')>0){$where['volume'] = array('elt',C('ftx_index_max_volume'));}
		if(C('ftx_index_mix_volume')>0 && C('ftx_index_max_volume')>0){$where['volume'] = array(array('egt',C('ftx_index_mix_volume')),array('elt',C('ftx_index_max_volume')),'and');}

		$where['pass'] = '1';
		$index_info['sort']=$sort;
		$index_info['status']=$status;

		$page_size = C('ftx_index_page_size');
        $p = $this->_get('p', 'intval', 1); //页码
		$index_info['p']=$p;

        $start = $page_size * ($p - 1) ;
        
        $items_list = $item_mod->where($where)->order($order)->limit($start . ',' . $page_size)->select();
		$items = array();
		foreach($items_list as $key=>$val){
			$items[$key]			= $val;
			$items[$key]['class']	= $this->_mod->status($val['status'],$val['coupon_start_time'],$val['coupon_end_time']);
			$items[$key]['zk']		= round(($val['coupon_price']/$val['price'])*10, 2); 
			if(!$val['click_url']){
				$items[$key]['click_url']	=U('jump/index',array('id'=>$val['id']));
			}
		}
		F('items_list', $items);
		$this->assign('items_list', $items);
		$this->assign('index_info',$index_info);
		$count = $item_mod->where($where)->count();
        $pager = $this->_pager($count, $page_size);
        $this->assign('page', $pager->fshow());
		$this->assign('total_item',$count);
		if (false === $cate_list = F('cate_list')) {
            $cate_list = D('items_cate')->cate_cache();
        }
		$this->assign('cate_list', $cate_list); //分类
		$item_comment_mod = M('items_comment');
		$comm_map['status'] = '1';
		$comment_list = $item_comment_mod->where($comm_map)->order('add_time DESC')->limit('0,10')->select();
		$this->assign('comment_list', $comment_list);

        $this->assign('nav_curr', 'index');
        $this->_config_seo(C('ftx_seo_config.index'));
        $this->display();
    }

	/**
	 ** 搜索
	 **/
	public function so() {
		$sort = $this->_get('sort', 'trim', 'hot'); //排序
		$status = $this->_get('status', 'trim', 'all'); //排序
		$cid = $this->_get('cid', 'trim');
		$k = $this->_get('k', 'trim');
		$order = 'ordid asc ,id desc';
		switch ($sort) {
            case 'new':
                $order.= ', coupon_start_time DESC';
                break;
            case 'price':
                $order.= ', price DESC';
                break;
        }
		switch ($status) {
            case 'all':
                $where['status']="underway";
                break;
            case 'underway':
                $where['status']="underway";
                break;
			case 'sellout':
				$where['status']="sellout";
				break;
        }
		if($k){
			$where['title'] = array('like', '%' . $k . '%');
			$this->assign('k',$k);
		}
		if ($cid) {
            $id_arr = $this->_cate_mod->get_child_ids($cid, true);
            $map['cate_id'] = array('IN', $id_arr);
            $spid = $this->_cate_mod->where(array('id'=>$cate_id))->getField('spid');
            if( $spid==0 ){
                $spid = $cid;
            }else{
                $spid .= $cid;
            }
			$this->assign('cid',$cid);
        }
		$where['pass'] = '1';
		$index_info['sort']=$sort;
		$index_info['status']=$status;
		$page_size = C('ftx_index_page_size');
        $p = $this->_get('p', 'intval', 1); //页码
		$index_info['p']=$p;

        $start = $page_size * ($p - 1) ;
        $item_mod = M('items');
        $items_list = $item_mod->where($where)->order($order)->limit($start . ',' . $page_size)->select();
		$items = array();
		foreach($items_list as $key=>$val){
			$items[$key]			= $val;
			$items[$key]['class']	= $this->_mod->status($val['status'],$val['coupon_start_time'],$val['coupon_end_time']);
			$items[$key]['zk']		= round(($val['coupon_price']/$val['price'])*10, 2); 
			if(!$val['click_url']){
				$items[$key]['click_url']	=U('jump/index',array('id'=>$val['id']));
			}
		}
		F('items_list', $items);
		$this->assign('items_list', $items);
		$this->assign('index_info',$index_info);
		$count = $item_mod->where($where)->count();
        $pager = $this->_pager($count, $page_size);
        $this->assign('page', $pager->fshow());
		$this->assign('total_item',$count);

		if (false === $cate_list = F('cate_list')) {
            $cate_list = D('items_cate')->cate_cache();
        }
		$this->assign('cate_list', $cate_list); //分类

		$item_comment_mod = M('items_comment');
		$comment_list = $item_comment_mod->order('id DESC')->limit('0,10')->select();
		$this->assign('comment_list', $comment_list);

        $this->assign('nav_curr', 'index');
    
		$page_seo=array(
			'title' => '搜索"'.$k.'"的宝贝结果页 - '.C('ftx_site_name'),
        );
		$this->assign('page_seo', $page_seo);
        $this->display();
    }


	public function shortcut(){
		$Shortcut = "[InternetShortcut] 
		URL=".__ROOT__." 
		IDList= 
		[{000214A0-0000-0000-C000-000000000046}] 
		Prop3=19,2 
		"; 
		Header("Content-type: application/octet-stream"); 
		header("Content-Disposition: attachment; filename=".C('ftx_site_name').".url;"); 
		echo $Shortcut; 
	}

    /**
	 ** 分类
	 **/
	public function cate(){
		$cid	=	$this->_get('cid', 'trim');
		$sort	=	$this->_get('sort', 'trim', 'default'); //排序
		$status =	$this->_get('status', 'trim', 'all'); //排序
		$order	=	'ordid asc ';




		$cinfo = $this->_cate_mod->where(array('id'=>$cid))->find();
		switch ($sort) {
            case 'new':
                $order.= ', coupon_start_time DESC';
                break;
            case 'price':
                $order.= ', price DESC';
                break;
			case 'hot':
                $order.= ', volume DESC';
                break;
			case 'default':
				$order.= ', '.$cinfo['sort'];
        }

		switch ($status) {
            case 'all':
                $map['status']="underway";
                break;
            case 'underway':
                $map['status']="underway";
                break;
			case 'sellout':
				$map['status']="sellout";
				break;
        }
		if($cinfo['shop_type']){$map['shop_type'] = $cinfo['shop_type'];}
		if($cinfo['mix_price']>0){$map['coupon_price'] = array('egt',$cinfo['mix_price']);}
		if($cinfo['max_price']>0){$map['coupon_price'] = array('elt',$cinfo['max_price']);}
		if($cinfo['max_price']>0 && $cinfo['mix_price']>0){$map['coupon_price'] = array(array('egt',$cinfo['mix_price']),array('elt',$cinfo['max_price']),'and');}
		if($cinfo['mix_volume']>0){$map['volume'] = array('egt',$cinfo['mix_volume']);}
		if($cinfo['max_volume']>0){$map['volume'] = array('elt',$cinfo['max_volume']);}
		if($cinfo['max_volume']>0 && $cinfo['mix_volume']>0){$map['volume'] = array(array('egt',$cinfo['mix_volume']),array('elt',$cinfo['max_volume']),'and');}

		if($cinfo['thiscid']==0){
            $id_arr = $this->_cate_mod->get_child_ids($cid, true);
            $map['cate_id'] = array('IN', $id_arr);
			$today_wh['cate_id'] = array('IN', $id_arr);
        }

		$today_str = mktime(0,0,0,date("m"),date("d"),date("Y"));
		$today_wh['coupon_start_time'] = array('egt',$today_str);
		$today_item = $this->_mod->where($today_wh)->count();
		$this->assign('today_item', $today_item);


		$this->assign('cid',$cid);
		$this->assign('cinfo',$cinfo);
		if($cinfo['wait_time'] == '1'){
			$map['coupon_start_time'] = array('egt',time());
		}elseif($cinfo['wait_time'] =='2'){
			$map['coupon_start_time'] = array('elt',time());
		}

		if($cinfo['end_time'] == '1'){
			$map['coupon_end_time'] = array('egt',time());
		}
		if($cinfo['ems'] == '1'){
			$map['ems'] = '1';
		}
		$map['pass']="1";

		$index_info['sort']=$sort;
		$index_info['status']=$status;
		$index_info['cid']=$cid;

		$page_size = C('ftx_index_page_size');
        $p = $this->_get('p', 'intval', 1); //页码
		$index_info['p']=$p;

        $start = $page_size * ($p - 1) ;
        $item_mod = M('items');
        $items_list = $item_mod->where($map)->order($order)->limit($start . ',' . $page_size)->select();
		$items = array();
		foreach($items_list as $key=>$val){
			$items[$key]			= $val;
			$items[$key]['class']	= $this->_mod->status($val['status'],$val['coupon_start_time'],$val['coupon_end_time']);
			$items[$key]['zk']		= round(($val['coupon_price']/$val['price'])*10, 2); 
			if(!$val['click_url']){
				$items[$key]['click_url']	=U('jump/index',array('id'=>$val['id']));
			}
		}
		F('items_list', $items);
		$this->assign('items_list', $items);
		$this->assign('index_info',$index_info);
		$count = $item_mod->where($map)->count();
        $pager = $this->_pager($count, $page_size);
        $this->assign('page', $pager->fshow());
		$this->assign('total_item',$count);

		if (false === $cate_list = F('cate_list')) {
            $cate_list = D('items_cate')->cate_cache();
        }
		
		$this->assign('cate_list', $cate_list); //分类

		$item_comment_mod = M('items_comment');
		$comm_map['status'] = '1';
		$comment_list = $item_comment_mod->where($comm_map)->order('add_time DESC')->limit('0,10')->select();
		$this->assign('comment_list', $comment_list);
        $this->assign('nav_curr', 'index');
        $this->_config_seo(C('ftx_seo_config.cate'), array(
            'cate_name' => $cinfo['name'],
            'seo_title' => $cinfo['seo_title'],
			'seo_keywords' => $cinfo['seo_keys'],
			'seo_description' => $cinfo['seo_desc'],
        ));
        $this->display();
	}
}
?>