$(document).ready(function($) {
	var $container = $('#timeline-box');
	resetArrow();
	function resetArrow() {
		var s = $container.find('.timeline');
		$.each(s, function(i, obj) {
			appendArrow(obj);
		});
		resetLineHeight();
	}
	
	function appendArrow(obj){
		var posLeft = $(obj).css("left");
		var con = $(obj).find('.corner');
		var html='';
		if (posLeft == "0px"||posLeft == "auto") {
			html = "<span class='right-line'><i class='right-corner'></i><i class='pointer'></i></span>";
		} else {
			html = "<span class='left-line'><i class='left-corner'></i><i class='pointer'></i></span>";
		}
		$(con).html(html);
	}
	
	function resetLineHeight() {
		var line = $container.find('.line');
		var height = $container.height();
		$(line).css('height',height);
	}

	$container.imagesLoaded(function(){
		$container.find('.timeline').fadeIn();
		$container.find('.timeline').removeClass('hide');
		$container.masonry({
				isAnimated: false,
				itemSelector : '.timeline',
				animationOptions: {
				    duration: 300,
				    easing: 'swing',
				    queue: false
				  }
			});
		$('#timeline-loadingPins').addClass('hide');
		setTimeout(function(){resetArrow();}, 500);
	});
	 $container.infinitescroll({
	      navSelector  : '#page-nav:last',    // selector for the paged navigation 
	      nextSelector : 'a#page-next:last',  // selector for the NEXT link (to page 2)
	      itemSelector : '.timeline',     // selector for all items you'll retrieve
	      debug		 	: false,
	      loading: {
	          finishedMsg: '就这些了哦',
	          img: base_url + 'assets/img/ajax-loader.gif',
	          msg: 'test mesg',
	          msgText: '正在加载……'
	        }
	      },
	      function( newElements ) {
	        var $newElems = $( newElements ).css({ opacity: 0 });
	        $newElems.imagesLoaded(function(){
	        	$newElems.removeClass('hide');
	        	$newElems.animate({ opacity: 1 });
	        	$container.masonry( 'appended', $newElems, true ); 
	        	setTimeout(function(){resetArrow();}, 500);
	        });
	      }
	    );
	


		$('.line').mousemove(function(e) {
			var topdiv = 540;
			var pag = e.pageY - topdiv - 60;
			$('.plus').addClass('plus_bg');
			$('.plus').css({
				"top" : pag + "px"
			});
		}).mouseout(function() {
			$('.plus').removeClass('plus_bg');
		});
	 
	$(".line").click(function(e) {
		var topdiv = 540;
		$("#popup").css({
			'top' : (e.pageY - topdiv - 69) + 'px'
		});
		$("#popup").fadeIn();
		$("#update").focus();

	});


});