<?php
/**
 *      [PinTuXiu] (C)2001-2099 ONightjar.com Pintuxiu.com.
 *      This is NOT a freeware, use is subject to license terms
 */
class goodshop extends basecontroller
{

	public function __construct() {
		parent::__construct();
		$this->seo_title(T('goodshop'));
		$this->storeCategories = spClass("ptx_store_category")->getStoreCategories();
		
		$scid =  $this->spArgs("scid");
		if($scid){
			$this->scid = $scid;
			$this->storeCategory = spClass("ptx_store_category")->find_one(array('store_category_id'=>$scid));
		}
	}

	public function pre_index(){
		$num_per_page = 8;
		$ptx_goodshop = spClass("ptx_goodshop");

		if($this->category_id){
			$conditions['category_id'] = $this->category_id;
			$args['cat']=$this->category_id;
		}
		$shops = $ptx_goodshop->search($conditions,$this->page,$num_per_page);
		$this->pages = createTPages($ptx_goodshop->spPager()->getPager(), 'goodshop', 'index',$conditions);
		$this->prepareView($shops);
		$this->output("goodshop/index");
	}
	
	public function listing(){
		$num_per_page = 10;
		$ptx_goodshop = spClass("ptx_goodshop");
		$sort =  $this->spArgs("sort");
		$args = array();
		if($this->scid){
			$conditions['store_category_id'] = $this->scid;
			$args['scid'] = $this->scid;
		}
	
		if($sort){
			$args['sort'] = $sort;
			$this->sort = $sort;
		}
		if($sort=='dtime'){
			$sort = " ptx_goodshop.create_time DESC ";
		}elseif($sort=='atime'){
			$sort = " ptx_goodshop.create_time ASC ";
		}elseif($sort=='dlike'){
			$sort = " ptx_goodshop.total_like DESC ";
		}
	
		$stores = $ptx_goodshop->search($conditions,$this->page,$num_per_page,null,$sort);
		$this->pages = createTPages($ptx_goodshop->spPager()->getPager(), $this->current_controller, $this->current_action,$args);
		$ptx_share = spClass('ptx_share');
		foreach ($stores as $key=>$store){
			$share_conditions['user_id'] = $store['user_id'];
			$shares = $ptx_share->search($share_conditions,1,5);
			$stores[$key]['shares'] = $shares;
		}
		$this->stores = $stores;
		$this->output("goodshop/listing");
	}
	
	public function show(){
		$this->lastest();
	}

	public function index(){
		
		$this->output("goodshop/index");
	}
	
	public function subCategory(){
		$parent_id = $this->spArgs("parentid");
		
		$ptx_store_category = spClass("ptx_store_category");
		
		$this->storeCategories = $ptx_store_category->getStoreCategories();
		
		foreach ($this->storeCategories as $storeCategory) {
			if($storeCategory['store_category_id']==$parent_id){
				$this->ajax_success_response($storeCategory['children'], '');
			}
		}
	}

	private function prepareView($shops){
		$user_id = $this->is_login()?$this->current_user['user_id']:0;
		$ptx_share = spClass('ptx_share');
		$this->is_shop = true;
		foreach ($shops as $key=>$shop){
			$conditions['user_id'] = $shop['user_id'];
			$shares = $ptx_share->search($conditions,1,5);
			$shops[$key]['shares'] = $shares;
			$shops[$key]['relation_view'] = $this->relationView($user_id,$shop['user_id']);
		}
		$this->shops = $shops;
	}

	public function apply(){
		$this->ajax_check_login();
		
		$catid =  $this->spArgs("rid");
		if($catid&&is_numeric($catid)){
			$this->catid = $catid;
		}
		if($this->txt&&$this->catid){
			$ptx_goodshop = spClass("ptx_goodshop");
			if($ptx_goodshop->check_exits($this->current_user['user_id'])){
				$this->ajax_failed_response(T('already_applied'));
				return;
			}
			
			$ptx_apply = spClass("ptx_apply");
			if($ptx_apply->check_exits($this->current_user['user_id'],2)){
				$this->ajax_failed_response(T('already_applied'));
				return;
			}
			$ptx_apply->add_shopapply($this->current_user['user_id'],$this->catid,$this->txt);
			$this->ajax_success_response(null, T('apply_succeed'));
			return;
		}
		$this->ajax_failed_response();
	}

}