<?php
/**
 *      [PinTuXiu] (C)2001-2099 ONightjar.com Pintuxiu.com.
 *      This is NOT a freeware, use is subject to license terms
 */
class group extends basecontroller
{

	public function __construct() {
		parent::__construct();
	}

	public function listing(){
		$num_per_page = 10;
		$ptx_group = spClass("ptx_group");
		$category_id =  $this->spArgs("category_id");
		$sort =  $this->spArgs("sort");
		$args = array();
		if($category_id){
			$conditions['category_id'] = $category_id;
			$args['category_id'] = $category_id;
		}

		if($sort){
			$args['sort'] = $sort;
		}
		if($sort=='dtime'){
			$sort = " ptx_group.create_time DESC ";
		}elseif($sort=='atime'){
			$sort = " ptx_group.create_time ASC ";
		}elseif($sort=='dmember'){
			$sort = " ptx_group.total_member DESC ";
		}

		$groups = $ptx_group->search($conditions,$this->page,$num_per_page,null,$sort);
		$this->pages = createTPages($ptx_group->spPager()->getPager(), $this->current_controller, $this->current_action,$args);
		$ptx_share = spClass('ptx_share');
		foreach ($groups as $key=>$group){
			$share_conditions['keyword'] = 'group'.$group['group_id'].'g';
			$shares = $ptx_share->count($share_conditions);
			$groups[$key]['shares'] = $shares;
		}
		$this->groups = $groups;
		$this->newest10 = $ptx_group->search_no_page(null,null,null,3);
		$this->output("group/listing");
	}
	
	public function join_group(){
		$this->ajax_check_login();
		$groupid =  $this->spArgs("groupid");
		if(!$groupid){
			$this->ajax_failed_response("group not exist!");
		}
		
		$ptx_group = spClass("ptx_group");
		
		if(!($group=$ptx_group->find(array('group_id'=>$groupid)))){
			$this->ajax_failed_response("group not exist!");
		}
		
		$ptx_user_group = spClass("ptx_user_group");
		
		$data['user_id'] = $this->current_user['user_id'];
		$data['group_id'] = $groupid;
		
		if($ptx_user_group->add_one($data)){
			$ptx_group->update_total_member($groupid);
			
			$event_dispatcher = spClass('event_dispatcher');
			$event_data['to_user_id'] = $this->current_user['user_id'];
			$event_data['to_nickname'] = $this->current_user['nickname'];
			$event_data['related_id'] = $group['group_id'];
			$event_data['related_title'] = $group['group_title'];
			$event_dispatcher->invoke('join_group',$event_data);
			
			$this->ajax_success_response(null, T('operate_succeed'));
		}else{
			$this->ajax_failed_response(T('illegal_operation'));
		}
	}
	
	public function show(){
		$this->lastest();
	}
	
	public function hot(){
		$this->output_pin('hot', " ptx_share.total_likes DESC ");
	}
	
	public function lastest(){
		$this->output_pin('lastest', " ptx_share.create_time DESC ");
	}
	
	public function goods(){
		$conditions['type'] = 'goods';
		$this->output_pin('goods', " ptx_share.create_time DESC ",$conditions);
	}
	
	public function video(){
		$conditions['type'] = 'video';
		$this->output_pin('video', " ptx_share.create_time DESC ",$conditions);
	}
	
	public function share(){
		$conditions['type'] = 'share';
		$this->output_pin('share', " ptx_share.create_time DESC ",$conditions);
	}
	
	public function article(){
		$conditions['type'] = 'article';
		$this->output_pin('article', " ptx_share.create_time DESC ",$conditions);
	}
	
	private function output_pin($action,$order,$conditions=array()){
		$groupid =  $this->spArgs("groupid");
		if(!$groupid){
			$this->error404();
		}
		
		$num_per_page = $this->settings['ui_layout']['pin_pagenum'];
		$num_per_page = $num_per_page?$num_per_page:15;
		$ptx_share = spClass('ptx_share');
		$wf =  $this->spArgs("wf");
	
		$ptx_group = spClass("ptx_group");
		$group_conditions['group_id'] = $groupid;
		$this->group = $ptx_group->find_one($group_conditions);
		
		$this->seo_title($this->group['group_title'].T($action));
	
		$conditions['keyword'] = 'group'.$groupid.'g';

		$args = array("page"=>"2","wf"=>"1","groupid"=>$groupid);
	
		if($this->settings['ui_layout']['orgin_post']){
			$conditions['orgin_post']=1;
		}
	
		$this->nextpage_url = spUrl("group",$action, $args);
		$shares = $ptx_share->search($conditions,$this->page,$num_per_page,null,$order);
		$this->total_shares = $ptx_share->count($conditions);
		$this->waterfallView($shares,'pin');
		$need_header_footer = ($wf=='1')?false:true;
		if($need_header_footer){
			$data['user_id'] = $this->current_user['user_id'];
			$data['group_id'] = $groupid;
			$ptx_user_group = spClass("ptx_user_group");
			if($ptx_user_group->find_one($data)){
				$this->joined = true;
			}
			$mpage =  $this->spArgs("mpage",1);
			$this->members = $ptx_user_group->search(array('group_id'=>$groupid),$mpage,30," user.user_id, user.nickname ");
			$this->mpages = createTPages($ptx_user_group->spPager()->getPager(), 'group', $action,array("groupid"=>$groupid),'mpage');
			
		}
		$this->output("group/show",$need_header_footer);
	}


}