<?php
/**
 *      [PinTuXiu] (C)2001-2099 ONightjar.com Pintuxiu.com.
 *      This is NOT a freeware, use is subject to license terms
 */
class staruser extends basecontroller
{

	public function __construct() {
		parent::__construct();
		$this->seo_title('达人秀');
		$medalid =  $this->spArgs("rid");
		if($medalid&&is_numeric($medalid)){
			$this->medalid = $medalid;
		}
	}

	public function index(){
		$num_per_page = 10;
		$ptx_staruser = spClass("ptx_staruser");

		if($this->medalid){
			$conditions['medal_id'] = $this->medalid;
			$args['cat']=$this->medalid;
		}
		$starusers = $ptx_staruser->search($conditions,$this->page,$num_per_page);
		$this->pages = createTPages($ptx_staruser->spPager()->getPager(), 'staruser', 'index',$conditions);
		$this->prepareView($starusers);
		$this->output("staruser/index");
	}
	
	public function apply(){
		$this->ajax_check_login();
		if($this->txt&&$this->medalid){
			$ptx_apply = spClass("ptx_apply");
			$ptx_staruser = spClass("ptx_staruser");
			if($ptx_staruser->check_exits($this->current_user['user_id'])){
				$this->ajax_failed_response(T('already_staruser_failed'));
				return;
			}
			if($ptx_apply->check_exits($this->current_user['user_id'],1)){
				$this->ajax_failed_response(T('already_applied'));
				return;
			}
			$ptx_apply->add_starapply($this->current_user['user_id'],$this->medalid,$this->txt);
			$this->ajax_success_response(null, T('apply_succeed'));
			return;
		}
		$this->ajax_failed_response();
	}
	
	public function show(){
		$this->prepareShow();
		$this->output("staruser/index");
	}
	
	private function prepareShow(){
		$ptx_staruser = spClass("ptx_staruser");
		$staruser_cates = $ptx_staruser->get_staruser_cache();
		foreach ($staruser_cates as $key=>$staruser_cate){
			$starusers = $staruser_cate['staruser'];
			$staruser_cates[$key]['staruser'] = $this->fillView($starusers);
		}
		$this->startuser_cates = $staruser_cates;
	}
	
	private function prepareView($starusers){
		$this->starusers = $this->fillView($starusers);
	}
	
	private function fillView($starusers){
		$user_id = $this->is_login()?$this->current_user['user_id']:0;
		foreach ($starusers as $key=>$star){
			$star['star_cover'] = str_to_arr($star['star_cover']);
			$style = $star['star_cover']['style']?$star['star_cover']['style']:'star_1';
			$this->staruser = $star;
			$starusers[$key]['star_view'] = $this->render('common/'.$style);
			$starusers[$key]['relation_view'] = $this->relationView($user_id,$star['user_id']);
		}
		return $starusers;
	}
	
	public function save_staruser(){
		$this->ajax_check_editer();
		$star_reason = $this->spArgs("sreason");
		if(!$this->medalid||!$this->user_id||!$star_reason){
			$this->ajax_failed_response(T('illegal_operation'));
			return;
		}

		$ptx_staruser = spClass("ptx_staruser");
		$data['user_id'] = $this->user_id;
		$data['medal_id'] = $this->medalid;
		$data['star_reason'] = $star_reason;
		$conditions['user_id'] = $this->user_id;
		$conditions['medal_id'] = $this->medalid;
		$staruser = $ptx_staruser->find_one($conditions);
		if(!$staruser){
			$ptx_staruser->add_one($data);
			$ptx_user = spClass("ptx_user");
			$ptx_user->update_staruser($this->user_id,1);
		}else{
			$ptx_staruser->update($conditions,$data);
		}
		$ptx_staruser->update_staruser_cache();
		$this->ajax_success_response(null, '');
		return;
	}

	public function get_staruser(){
		$this->ajax_check_login();
		if(!$this->user_id||(!$this->is_editer()&&!$this->current_user['is_star'])){
			$this->ajax_failed_response(T('illegal_operation'));
			return;
		}
		$ptx_staruser = spClass("ptx_staruser");
		$condition['user_id'] = $this->user_id;
		//$condition['medalid'] = $this->medalid;
		$staruser = $ptx_staruser->find_one($condition);
		if($staruser){
			$ptx_share = spClass("ptx_share");
			$share = $ptx_share->find_one(array('share_id'=>$this->share_id),NULL,'share_id,detail.image_path');
			$ptx_user = spClass("ptx_user");
			$user = $ptx_user->getuser_byid($this->user_id);
			$staruser['nickname'] = $user['nickname'];
			$staruser['bio'] = $user['bio'];
			$staruser['user_title'] = $user['user_title'];
			$staruser['total_likes'] = $user['total_likes'];
			$staruser['avatar'] = useravatar($this->user_id, 'large');
			$staruser['star_cover'] = str_to_arr($staruser['star_cover']);
			$staruser['home'] = spUrl('pub','index',array('uid'=>$staruser['user_id']));
			$staruser['image_path'] = base_url($share['image_path'].'_middle.jpg');
			$this->ajax_success_response($staruser, '');
			return;
		}else{
			$ptx_user = spClass("ptx_user");
			$user = $ptx_user->getuser_byid($this->user_id);
			$staruser['user_id'] = $this->user_id;
			$staruser['home'] = spUrl('pub','index',array('uid'=>$staruser['user_id']));
			$staruser['nickname'] = $user['nickname'];
			$staruser['bio'] = $user['bio'];
			$staruser['avatar'] = useravatar($this->user_id, 'large');
			$this->ajax_failed_response('',$staruser);
			return;
		}
	}

	public function crop_staruser_cover(){
		$this->ajax_check_login();
		if(!$this->medalid||!$this->share_id||!$this->user_id||(!$this->is_editer()&&!$this->current_user['is_star'])){
			$this->ajax_failed_response(T('illegal_operation'));
			return;
		}

		$position = $this->spArgs("position");
		$x = $this->spArgs("x");
		$y = $this->spArgs("y");
		$w = $this->spArgs("w");
		$h = $this->spArgs("h");
		$js_w = $this->spArgs("js_w");
		$js_h = $this->spArgs("js_h");
		$ww = $this->spArgs("ww");
		$hh = $this->spArgs("hh");
		$style = $this->spArgs("sy",'star_1');

		$ptx_share = spClass('ptx_share');
		$share = $ptx_share->findJoin(array('share_id' => $this->share_id),null,'image_path');
		if($share){
			$imagelib = spClass("ImageLib");
			$imagepath = APP_PATH.$share['image_path'];
			$image_size=getimagesize($imagepath.'_large.jpg');
			$weight=$image_size[0];
			$height=$image_size[1];
			if($js_w<$weight){
				$scale = $js_w/$weight;
			}elseif ($js_h<$height){
				$scale = $js_h/$height;
			}else{
				$scale = 1;
			}
			$x = $x/$scale;
			$y = $y/$scale;
			$w = $w/$scale;
			$h = $h/$scale;
			$imagelib->crop_image($imagepath.'_large.jpg',$imagepath.'_star.jpg',$x,$y,$w,$h);
			$imagelib->create_thumb($imagepath.'_star.jpg',NULL,$ww,$hh,$imagepath.'_star.jpg');
		}

		$ptx_staruser = spClass("ptx_staruser");
		$condition['user_id'] = $this->user_id;
		//$condition['medalid'] = $this->medalid;
		$staruser = $ptx_staruser->find_one($condition);
		if($staruser){
			$covers = str_to_arr($staruser['star_cover']);
			$covers['style'] = $style;
			$covers['s'.$position.'_sid'] = $this->share_id;
			$covers['s'.$position.'_image_path'] = $share['image_path'];
			$star_cover = array_to_str($covers);
			$ptx_staruser->update($condition,array('star_cover'=>$star_cover));
			$ptx_staruser->update_staruser_cache();
			$data['img']= base_url($share['image_path'].'_star.jpg?'.uniqid());
			$this->ajax_success_response($data, T('operate_succeed'));
			return;
		}
		$this->ajax_failed_response(T('operate_failed'));
		return;
	}

}