<?php
/**
 *      [PinTuXiu] (C)2001-2099 ONightjar.com Pintuxiu.com.
 *      This is NOT a freeware, use is subject to license terms
 */
class topic extends basecontroller
{

	public function __construct() {
		parent::__construct();
		
		$topicid =  $this->spArgs("topicid");
		if($topicid){
			$ptx_topic = spClass("ptx_topic");
			$topic_conditions['topic_id'] = $topicid;
			$this->topic = $ptx_topic->find_one($topic_conditions);
		}
	}

	public function listing(){
		$num_per_page = 5;
		$ptx_topic = spClass("ptx_topic");
		$category_id =  $this->spArgs("category_id");
		$sort =  $this->spArgs("sort");
		$args = array();
		if($category_id){
			$conditions['category_id'] = $category_id;
			$args['category_id'] = $category_id;
		}

		if($sort){
			$args['sort'] = $sort;
			$this->sort = $sort;
		}
		if($sort=='dtime'){
			$sort = " ptx_topic.create_time DESC ";
		}elseif($sort=='atime'){
			$sort = " ptx_topic.create_time ASC ";
		}elseif($sort=='dlike'){
			$sort = " ptx_topic.total_like DESC ";
		}

		$topics = $ptx_topic->search($conditions,$this->page,$num_per_page,null,$sort);
		$this->pages = createTPages($ptx_topic->spPager()->getPager(), $this->current_controller, $this->current_action,$args);
		$ptx_share = spClass('ptx_share');
		foreach ($topics as $key=>$topic){
			$share_conditions['keyword'] = 'topic'.$topic['topic_id'].'t';
			$shares = $ptx_share->search($share_conditions,1,5);
			$topics[$key]['shares'] = $shares;
		}
		$this->topics = $topics;
		$this->newest10 = $ptx_topic->search_no_page(null,null,null,10);
		$this->output("topic/listing");
	}

	public function show(){
		$this->lastest();
	}
	
	public function hot(){
		$this->seo_title($this->topic['topic_title'].T('hot_pin'));
		$this->output_pin('hot', " ptx_share.total_likes DESC ");
	}

	public function lastest(){
		$this->seo_title($this->topic['topic_title'].T('lastest_pin'));
		$this->output_pin('lastest', " ptx_share.create_time DESC ");
	}

	public function goods(){
		$this->seo_title($this->topic['topic_title'].T('goods'));
		$conditions['type'] = 'goods';
		$this->output_pin('goods', " ptx_share.create_time DESC ",$conditions);
	}

	public function video(){
		$this->seo_title($this->topic['topic_title'].T('video'));
		$conditions['type'] = 'video';
		$this->output_pin('video', " ptx_share.create_time DESC ",$conditions);
	}

	public function share(){
		$this->seo_title($this->topic['topic_title'].T('share'));
		$conditions['type'] = 'share';
		$this->output_pin('share', " ptx_share.create_time DESC ",$conditions);
	}
	
	public function article(){
		$this->seo_title($this->topic['topic_title'].T('article'));
		$conditions['type'] = 'article';
		$this->output_pin('article', " ptx_share.create_time DESC ",$conditions);
	}
	
	private function output_pin($action,$order,$conditions=array()){
		$num_per_page = $this->settings['ui_layout']['pin_pagenum'];
		$num_per_page = $num_per_page?$num_per_page:15;
		$ptx_share = spClass('ptx_share');
		$wf =  $this->spArgs("wf");
	
		$conditions['keyword'] = 'topic'.$this->topic['topic_id'].'t';
		
		$args = array();
		$args['page']='2';
		$args['wf']='1';
		$args['topicid']=$this->topic['topic_id'];
		
		if($this->settings['ui_layout']['orgin_post']){
			$conditions['orgin_post']=1;
		}
	
		$this->nextpage_url = spUrl("topic",$action, $args);
		$shares = $ptx_share->search($conditions,$this->page,$num_per_page,null,$order);
		$conditions['topicid'] = $this->topic['topic_id'];
		$this->pages = createTPages($ptx_share->spPager()->getPager(), 'topic', $action,$conditions);
		$this->waterfallView($shares,'pin');
		$need_header_footer = ($wf=='1')?false:true;
		$this->output("topic/show",$need_header_footer);
	}
	
	public function add_like()
	{
		$this->ajax_check_login();
		if($this->topic){
			$user_id = $this->current_user['user_id'];
			
			$data['user_id'] = $user_id;
			$data['topic_id'] = $this->topic['topic_id'];
			$ptx_favorite_topic = spClass("ptx_favorite_topic");
			$result = $ptx_favorite_topic->add_one($data);
			if($result){
				$ptx_topic = spClass("ptx_topic");
				$ptx_topic->add_like($this->topic['topic_id']);
				$event_dispatcher = spClass('event_dispatcher');
				$event_data['to_user_id'] = $this->current_user['user_id'];
				$event_data['to_nickname'] = $this->current_user['nickname'];
				$event_data['related_id'] = $this->topic['topic_id'];
				$event_data['related_title'] = $this->topic['topic_title'];
				$event_dispatcher->invoke('add_like_topic',$event_data);
				$this->ajax_success_response(null, 'success');
			}else{
				$this->ajax_failed_response('like_already');
			}
		}else{
			$this->ajax_failed_response('illegal_operation');
		}
	
	}

}